/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.chestloot;

import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class ChestGenHooks {
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    private ArrayList<WeightedRandomChestContent> contents = new ArrayList();

    public static void init(String category, List<WeightedRandomChestContent> items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    static void addDungeonLoot(ChestGenHooks dungeon, ItemStack item, int weight, int min, int max) {
        dungeon.addItem(new WeightedRandomChestContent(item, min, max, weight));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static ItemStack[] generateStacks(Random rand, ItemStack source, int min, int max) {
        ItemStack[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.func_77973_b() == null) {
            ret = new ItemStack[]{};
        } else if (count > source.func_77976_d()) {
            ret = new ItemStack[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.func_77946_l();
                ret[x].func_190920_e(1);
            }
        } else {
            ret = new ItemStack[]{source.func_77946_l()};
            ret[0].func_190920_e(count);
        }
        return ret;
    }

    public static List<WeightedRandomChestContent> getItems(String category, Random rnd) {
        return ChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, WeightedRandomChestContent item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, ItemStack item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public static ItemStack getOneItem(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, List<WeightedRandomChestContent> items, int min, int max) {
        this(category);
        for (WeightedRandomChestContent item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(WeightedRandomChestContent item) {
        if (item.theItemId != null) {
            this.contents.add(item);
        }
    }

    public void removeItem(ItemStack item) {
        Iterator<WeightedRandomChestContent> itr = this.contents.iterator();
        while (itr.hasNext()) {
            WeightedRandomChestContent cont = itr.next();
            if (!item.func_77969_a(cont.theItemId) && (item.func_77952_i() != Short.MAX_VALUE || item.func_77973_b() != cont.theItemId.func_77973_b())) continue;
            itr.remove();
        }
    }

    public List<WeightedRandomChestContent> getItems(Random random) {
        ArrayList<WeightedRandomChestContent> wrcc_array = new ArrayList<WeightedRandomChestContent>();
        for (WeightedRandomChestContent wrcc : this.contents) {
            WeightedRandomChestContent n;
            Item item = wrcc.theItemId.func_77973_b();
            if (item == null || (n = this.getChestGenBase(item, this, random, wrcc)) == null) continue;
            wrcc_array.add(n);
        }
        return wrcc_array;
    }

    public WeightedRandomChestContent getChestGenBase(Item item, ChestGenHooks chest, Random random, WeightedRandomChestContent original) {
        if (item instanceof ItemEnchantedBook) {
            ItemStack itemstack = new ItemStack(Items.field_151122_aG, 1, 0);
            EnchantmentHelper.func_77504_a((Random)random, (ItemStack)itemstack, (int)30, (boolean)true);
            return new WeightedRandomChestContent(itemstack, original.minStackSize, original.maxStackSize, original.field_76292_a);
        }
        return original;
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public ItemStack getOneItem(Random rand) {
        WeightedRandomChestContent item = (WeightedRandomChestContent)WeightedRandom.func_76271_a((Random)rand, this.getItems(rand));
        ItemStack[] stacks = ChestGenHooks.generateStacks(rand, item.theItemId, item.minStackSize, item.maxStackSize);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }
}

