/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.biomestructures;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.chestloot.ChestGenHooks;
import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TaigaStructures {
    public static ArrayList<BlueprintData> getRandomTaigaDecorBlueprint(FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        int decorCount = 7;
        return TaigaStructures.getTaigaDecorBlueprint(random.nextInt(decorCount), materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static ArrayList<BlueprintData> getTaigaDecorBlueprint(int decorType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        IBlockState biomeGrassState;
        IBlockState biomeDirtState;
        ArrayList<BlueprintData> blueprint = new ArrayList<BlueprintData>();
        IBlockState biomeFillerState = biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), materialType, biome, disallowModSubs);
        if (biome != null && biome.field_76753_B != null) {
            biomeFillerState = biome.field_76753_B;
        }
        IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), materialType, biome, disallowModSubs);
        if (biome != null && biome.field_76752_A != null) {
            biomeTopState = biome.field_76752_A;
        }
        IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomeStoneStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), coordBaseMode);
        boolean genericBoolean = false;
        switch (decorType) {
            case 0: {
                boolean shift = random.nextBoolean();
                switch (random.nextInt(2)) {
                    case 0: {
                        for (int i = -2; i <= 1; ++i) {
                            BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, -1, i + (shift ? 1 : 0), biomePlankState);
                            BlueprintData.addFillBelowTo(blueprint, 0, -2, i + (shift ? 1 : 0), FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        }
                        if (VillageGeneratorConfigHandler.fillTroughsWithWater) {
                            BlueprintData.addFillWithBlocks(blueprint, 0, 0, -2 + (shift ? 1 : 0), 0, 0, 1 + (shift ? 1 : 0), Blocks.field_150355_j.func_176223_P());
                        }
                        BlueprintData.addFillWithBlocks(blueprint, -1, 0, -2 + (shift ? 1 : 0), -1, 0, 1 + (shift ? 1 : 0), biomeTrapdoorState.func_177230_c().func_176203_a(6));
                        BlueprintData.addFillWithBlocks(blueprint, -1, -1, -2 + (shift ? 1 : 0), -1, -1, 1 + (shift ? 1 : 0), biomeTopState);
                        BlueprintData.addFillWithBlocks(blueprint, 1, 0, -2 + (shift ? 1 : 0), 1, 0, 1 + (shift ? 1 : 0), biomeTrapdoorState.func_177230_c().func_176203_a(7));
                        BlueprintData.addFillWithBlocks(blueprint, 1, -1, -2 + (shift ? 1 : 0), 1, -1, 1 + (shift ? 1 : 0), biomeTopState);
                        BlueprintData.addFillWithBlocks(blueprint, 0, 0, -3 + (shift ? 1 : 0), 0, 0, -3 + (shift ? 1 : 0), biomeTrapdoorState.func_177230_c().func_176203_a(5));
                        BlueprintData.addFillWithBlocks(blueprint, 0, -1, -3 + (shift ? 1 : 0), 0, -1, -3 + (shift ? 1 : 0), biomeTopState);
                        BlueprintData.addFillWithBlocks(blueprint, 0, 0, 2 + (shift ? 1 : 0), 0, 0, 2 + (shift ? 1 : 0), biomeTrapdoorState.func_177230_c().func_176203_a(4));
                        BlueprintData.addFillWithBlocks(blueprint, 0, -1, 2 + (shift ? 1 : 0), 0, -1, 2 + (shift ? 1 : 0), biomeTopState);
                        break;
                    }
                    case 1: {
                        for (int i = -2; i <= 1; ++i) {
                            BlueprintData.addPlaceBlockAndClearAbove(blueprint, i + (shift ? 1 : 0), -1, 0, biomePlankState);
                            BlueprintData.addFillBelowTo(blueprint, i + (shift ? 1 : 0), -2, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        }
                        if (VillageGeneratorConfigHandler.fillTroughsWithWater) {
                            BlueprintData.addFillWithBlocks(blueprint, -2 + (shift ? 1 : 0), 0, 0, 1 + (shift ? 1 : 0), 0, 0, Blocks.field_150355_j.func_176223_P());
                        }
                        BlueprintData.addFillWithBlocks(blueprint, -3 + (shift ? 1 : 0), 0, 0, -3 + (shift ? 1 : 0), 0, 0, biomeTrapdoorState.func_177230_c().func_176203_a(6));
                        BlueprintData.addFillWithBlocks(blueprint, -3 + (shift ? 1 : 0), -1, 0, -3 + (shift ? 1 : 0), -1, 0, biomeTopState);
                        BlueprintData.addFillWithBlocks(blueprint, 2 + (shift ? 1 : 0), 0, 0, 2 + (shift ? 1 : 0), 0, 0, biomeTrapdoorState.func_177230_c().func_176203_a(7));
                        BlueprintData.addFillWithBlocks(blueprint, 2 + (shift ? 1 : 0), -1, 0, 2 + (shift ? 1 : 0), -1, 0, biomeTopState);
                        BlueprintData.addFillWithBlocks(blueprint, -2 + (shift ? 1 : 0), 0, -1, 1 + (shift ? 1 : 0), 0, -1, biomeTrapdoorState.func_177230_c().func_176203_a(5));
                        BlueprintData.addFillWithBlocks(blueprint, -2 + (shift ? 1 : 0), -1, -1, 1 + (shift ? 1 : 0), -1, -1, biomeTopState);
                        BlueprintData.addFillWithBlocks(blueprint, -2 + (shift ? 1 : 0), 0, 1, 1 + (shift ? 1 : 0), 0, 1, biomeTrapdoorState.func_177230_c().func_176203_a(4));
                        BlueprintData.addFillWithBlocks(blueprint, -2 + (shift ? 1 : 0), -1, 1, 1 + (shift ? 1 : 0), -1, 1, biomeTopState);
                    }
                }
                break;
            }
            case 1: {
                BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, biomeCobblestoneState);
                BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                switch (random.nextInt(4)) {
                    case 0: {
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, biomeCobblestoneState);
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, biomeStoneStairsState.func_177230_c().func_176203_a(3));
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeStoneStairsState.func_177230_c().func_176203_a(3));
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, 1, biomeStoneStairsState.func_177230_c().func_176203_a(2));
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, 1, biomeStoneStairsState.func_177230_c().func_176203_a(1));
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        break;
                    }
                    case 1: {
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, biomeCobblestoneState);
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, biomeStoneStairsState.func_177230_c().func_176203_a(0));
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeStoneStairsState.func_177230_c().func_176203_a(0));
                        BlueprintData.addPlaceBlock(blueprint, 1, 1, 0, biomeStoneStairsState.func_177230_c().func_176203_a(1));
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, -1, biomeStoneStairsState.func_177230_c().func_176203_a(3));
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        break;
                    }
                    case 2: {
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, biomeCobblestoneState);
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, biomeStoneStairsState.func_177230_c().func_176203_a(2));
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeStoneStairsState.func_177230_c().func_176203_a(2));
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, -1, biomeStoneStairsState.func_177230_c().func_176203_a(3));
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, -1, biomeStoneStairsState.func_177230_c().func_176203_a(0));
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        break;
                    }
                    case 3: {
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, biomeCobblestoneState);
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, biomeStoneStairsState.func_177230_c().func_176203_a(1));
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeStoneStairsState.func_177230_c().func_176203_a(1));
                        BlueprintData.addPlaceBlock(blueprint, -1, 1, 0, biomeStoneStairsState.func_177230_c().func_176203_a(0));
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, 1, biomeStoneStairsState.func_177230_c().func_176203_a(2));
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    }
                }
                break;
            }
            case 2: {
                genericBoolean = true;
            }
            case 3: {
                int boulderTopperMeta;
                Block boulderTopperBlock;
                BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, biomeCobblestoneState);
                BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                int boulderOrientation = random.nextInt(4);
                if (genericBoolean) {
                    boulderTopperBlock = Blocks.field_150463_bK;
                    boulderTopperMeta = 0;
                    Block biomeCobblestoneBlock = biomeCobblestoneState.func_177230_c();
                    if (biomeCobblestoneBlock == Blocks.field_150341_Y) {
                        boulderTopperMeta = 1;
                    } else if (biomeCobblestoneBlock == Blocks.field_150322_A) {
                        IBlockState testState = ModObjects.chooseModSandstoneWall(materialType == FunctionsVN.MaterialType.MESA);
                        if (testState == null) {
                            boulderTopperBlock = Blocks.field_150322_A;
                        } else {
                            boulderTopperBlock = testState.func_177230_c();
                            boulderTopperMeta = testState.func_177230_c().func_176201_c(testState);
                        }
                    } else if (biomeCobblestoneBlock != Blocks.field_150347_e) {
                        boulderTopperBlock = biomeCobblestoneBlock;
                    }
                } else {
                    boulderTopperBlock = biomeStoneStairsState.func_177230_c();
                    boulderTopperMeta = (new int[]{3, 0, 2, 1})[boulderOrientation];
                }
                BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, boulderTopperBlock.func_176203_a(boulderTopperMeta));
                switch (boulderOrientation) {
                    case 0: {
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, biomeStoneStairsState.func_177230_c().func_176203_a(2));
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        break;
                    }
                    case 1: {
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, biomeStoneStairsState.func_177230_c().func_176203_a(1));
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        break;
                    }
                    case 2: {
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, biomeStoneStairsState.func_177230_c().func_176203_a(3));
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        break;
                    }
                    case 3: {
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, biomeStoneStairsState.func_177230_c().func_176203_a(0));
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    }
                }
                break;
            }
            case 4: {
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 0, 0, campfireState);
                BlueprintData.addPlaceBlock(blueprint, 0, -1, 0, biomeTopState);
                break;
            }
            case 5: {
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, -1, 0, 0, biomeTrapdoorState.func_177230_c().func_176203_a(6));
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, 1, 0, 0, biomeTrapdoorState.func_177230_c().func_176203_a(7));
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 0, -1, biomeTrapdoorState.func_177230_c().func_176203_a(5));
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 0, 1, biomeTrapdoorState.func_177230_c().func_176203_a(4));
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 0, 0, Blocks.field_150407_cf.func_176223_P());
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 1, 0, campfireState);
                break;
            }
            case 6: {
                Block boulderTopperBlock = Blocks.field_150463_bK;
                int boulderTopperMeta = 0;
                if (biomeCobblestoneState.func_177230_c() == Blocks.field_150341_Y) {
                    boulderTopperMeta = 1;
                } else if (biomeCobblestoneState.func_177230_c() == Blocks.field_150322_A) {
                    IBlockState testState = ModObjects.chooseModSandstoneWall(materialType == FunctionsVN.MaterialType.MESA);
                    if (testState == null) {
                        boulderTopperBlock = Blocks.field_150322_A;
                    } else {
                        boulderTopperBlock = testState.func_177230_c();
                        boulderTopperMeta = testState.func_177230_c().func_176201_c(testState);
                    }
                } else if (biomeCobblestoneState.func_177230_c() != Blocks.field_150347_e) {
                    boulderTopperBlock = biomeCobblestoneState.func_177230_c();
                }
                BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, boulderTopperBlock.func_176203_a(boulderTopperMeta));
                BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 1, 0, Blocks.field_150478_aa.func_176203_a(0));
                BlueprintData.addPlaceBlock(blueprint, 0, -1, 0, biomeTopState);
            }
        }
        return blueprint;
    }

    public static class TaigaStreetDecor1
    extends StructureVillageVN.VNComponent {
        public static final int STRUCTURE_WIDTH = 3;
        public static final int STRUCTURE_DEPTH = 9;
        public static final int STRUCTURE_HEIGHT = 2;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaStreetDecor1() {
        }

        public TaigaStreetDecor1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaStreetDecor1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)2, (int)9, (EnumFacing)coordBaseMode);
            return TaigaStreetDecor1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaStreetDecor1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorDepth;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                uvw[2] = decorDepth = ((Integer)FunctionsVN.weightedRandom(new int[]{-2, -1, 0, 1, 2, 3, 4, 5}, new double[]{9.0, 2.0, 1.0, 6.0, 5.0, 5.0, 1.0, 1.0}, randomFromXYZ)).intValue();
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (decorDepth < 0) {
                    int nonairSurrounding = 0;
                    int decorY = this.func_74862_a(decorHeightY);
                    for (int i = 0; i < 8; ++i) {
                        int z;
                        int[][] surroundpos = new int[][]{{0, 0}, {0, 1}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {1, 0}};
                        int u = surroundpos[i][0];
                        int w = surroundpos[i][0];
                        int x = this.func_74865_a(u, w);
                        BlockPos pos = new BlockPos(x, decorY, z = this.func_74873_b(u, w));
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || ++nonairSurrounding < 4) continue;
                        ++decorHeightY;
                        break;
                    }
                }
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 2, uvw[2], structureBB);
                this.func_175811_a(world, biomeTopState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && decorDepth >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaWeaponsmith2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFFF", " FFFFF", " FFFFF", " FPFPF", "FFPPPF", "FFPPFF", " PPPPF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaWeaponsmith2() {
        }

        public TaigaWeaponsmith2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaWeaponsmith2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaWeaponsmith2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaWeaponsmith2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{3, 0, 3, 3, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 1, 3}, {1, 2, 3, 1, 3, 3}, {5, 1, 1, 5, 1, 3}, {5, 2, 3, 5, 3, 3}, {1, 1, 5, 1, 1, 5}, {3, 1, 5, 3, 1, 5}, {5, 1, 5, 5, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{1, 4, 3, 5, 4, 3}, {1, 3, 4, 5, 3, 4}, {1, 2, 5, 5, 2, 5}, {1, 1, 6, 5, 1, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{1, 2, 1, -1}, {5, 2, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoh : new int[][]{{3, 1, 3, 2, 0}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwoh[3], this.func_186165_e(), uvwoh[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwoh[0], uvwoh[1], uvwoh[2], structureBB);
            }
            for (int[] uwg : new int[][]{{0, 1, 1, 1}, {1, 1, 4, 0}, {2, 1, 4, 1}, {4, 1, 4, 0}, {4, 1, 5, 0}, {5, 1, 0, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 1;
                int w = 3;
                while (u == 3 && w == 3) {
                    u = 2 + random.nextInt(3);
                    w = 0 + random.nextInt(4);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class TaigaWeaponsmith1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FPFPFPF", "FPPPPPF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaWeaponsmith1() {
        }

        public TaigaWeaponsmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaWeaponsmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaWeaponsmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaWeaponsmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 5, 3, 2}, {1, 1, 5, 5, 3, 5}, {1, 1, 3, 1, 3, 4}, {5, 1, 3, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 2, 3, 0, 2}, {2, 0, 3, 4, 0, 4}, {1, 4, 2, 5, 5, 2}, {2, 6, 2, 4, 6, 2}, {3, 7, 2, 3, 7, 2}, {1, 4, 5, 5, 5, 5}, {2, 6, 5, 4, 6, 5}, {3, 7, 5, 3, 7, 5}, {1, 4, 3, 1, 5, 4}, {5, 4, 3, 5, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 1, 2}, {3, 6, 1, 2}, {3, 5, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 5, 1, 0, 5, 6}, {1, 6, 1, 1, 6, 6}, {2, 7, 1, 2, 7, 6}, {3, 8, 1, 3, 8, 6}, {4, 7, 1, 4, 7, 6}, {5, 6, 1, 5, 6, 6}, {6, 5, 1, 6, 5, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uw : new int[][]{{2, 5, 2}, {4, 5, 2}, {2, 2, 5}, {4, 2, 5}, {2, 5, 5}, {4, 5, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            for (int[] uw : new int[][]{{1, 4, 1, 5, 4, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 1, 3}, {1, 4, 0, 2}, {2, 4, 0, 2}, {3, 4, 0, 2}, {4, 4, 0, 2}, {5, 4, 0, 2}, {6, 4, 1, 1}, {1, 2, 6, 0}, {3, 2, 6, 0}, {5, 2, 6, 0}, {1, 5, 6, 0}, {3, 5, 6, 0}, {5, 5, 6, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 1, 4}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{4, 2, 4, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, false)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 3, 1}, {2, 1, 4, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoh : new int[][]{{2, 1, 1, 2, 0}, {4, 1, 1, 2, 0}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwoh[3], this.func_186165_e(), uvwoh[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwoh[0], uvwoh[1], uvwoh[2], structureBB);
            }
            int chestU = 4;
            int chestV = 1;
            int chestW = 3;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof TileEntityChest) {
                ((TileEntityChest)te).func_189404_a(LootTableList.field_186423_e, random.nextLong());
            }
            for (int[] uwg : new int[][]{{0, 1, 0, 0}, {6, 1, 2, 0}, {1, 5, 1, 0}, {3, 5, 1, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 5, 1}, {5, 5, 1}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 1;
                int w = 3;
                int s = random.nextInt(11);
                if (s >= 8) {
                    u = 3;
                    w = 2 + random.nextInt(3);
                } else if (s > 2) {
                    u = 0;
                    w = s - 2;
                } else {
                    u = 1;
                    w = 2 * s + 1;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class TaigaToolSmith1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"           ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", "    FFF    ", "    FFF    ", " F   P   F "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaToolSmith1() {
        }

        public TaigaToolSmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaToolSmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaToolSmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaToolSmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{1, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{5, 0, 3, 5, 0, 3}, {1, 1, 3, 9, 3, 3}, {1, 1, 6, 9, 3, 6}, {1, 1, 4, 1, 4, 5}, {9, 1, 4, 9, 4, 5}, {2, 0, 4, 8, 0, 5}, {2, 1, 4, 2, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 1, 6, 3, 1}, {4, 1, 2, 4, 3, 2}, {6, 1, 2, 6, 3, 2}, {5, 4, 1, 5, 4, 2}, {5, 0, 1, 5, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{5, 3, 0, 2}, {5, 3, 4, 0}, {2, 4, 4, 1}, {2, 4, 5, 1}, {8, 4, 4, 3}, {8, 4, 5, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{3, 3, 0, 3, 3, 1}, {4, 4, 0, 4, 4, 3}, {5, 5, 0, 5, 5, 3}, {6, 4, 0, 6, 4, 3}, {7, 3, 0, 7, 3, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{0, 3, 2, 3, 3, 2}, {7, 3, 2, 10, 3, 2}, {0, 4, 3, 3, 4, 3}, {5, 4, 3, 5, 4, 3}, {7, 4, 3, 10, 4, 3}, {0, 5, 4, 10, 5, 4}, {0, 5, 5, 10, 5, 5}, {0, 4, 6, 10, 4, 6}, {0, 3, 7, 10, 3, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uw : new int[][]{{2, 2, 3}, {8, 2, 3}, {3, 2, 6}, {5, 2, 6}, {7, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 2, 2}, {3, 2, 2, 2}, {7, 2, 2, 2}, {9, 2, 2, 2}, {2, 2, 7, 0}, {4, 2, 7, 0}, {6, 2, 7, 0}, {8, 2, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{8, 1, 4, 8, 1, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState smithingTableBlockState = ModObjects.chooseModSmithingTable(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 1, 5}}) {
                this.func_175811_a(world, smithingTableBlockState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 6;
            int chestV = 1;
            int chestW = 4;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof TileEntityChest) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_toolsmith");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 3, 2, 1, 0}, {5, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 6;
                int v = 1;
                int w = 4;
                while (u == 6 && w == 4) {
                    u = 3 + random.nextInt(5);
                    w = 4 + random.nextInt(2);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class TaigaTemple1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"        F FFF", "        FFFFF", "    FFFFFFFFF", "    FFFFFFFFF", " FFFFFFFFFFFF", " FFFFFFFFFFFF", " FFFFFFFFFF  ", " FFFFFFFFF   ", " FFFFFFFFF   ", "FFFFFFP      ", "FFFFFPPP     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 14;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 5;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaTemple1() {
        }

        public TaigaTemple1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaTemple1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)14, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaTemple1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaTemple1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{5, 0, 5, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 5, 0, 5})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{6, 0, 2, 6, 0, 2}, {1, 1, 2, 7, 3, 2}, {1, 1, 3, 1, 4, 5}, {1, 1, 6, 6, 3, 6}, {6, 3, 5, 6, 3, 5}, {7, 4, 4, 7, 4, 4}, {2, 0, 3, 6, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 4, 4, 1}, {7, 3, 5, 1}, {6, 4, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{7, 0, 3, 7, 3, 4}, {2, 4, 3, 7, 4, 3}, {1, 5, 4, 6, 5, 4}, {2, 4, 5, 6, 4, 5}, {7, 1, 4, 7, 3, 4}, {8, 1, 4, 9, 4, 4}, {7, 5, 4, 9, 10, 4}, {6, 1, 7, 6, 3, 7}, {6, 4, 5, 6, 10, 7}, {7, 1, 8, 9, 10, 8}, {10, 1, 5, 10, 10, 7}, {7, 0, 5, 9, 0, 7}, {7, 5, 5, 9, 5, 7}, {11, 1, 6, 11, 1, 6}, {12, 1, 6, 12, 2, 6}, {8, 1, 9, 8, 2, 10}, {9, 1, 6, 9, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 1, 0}, {12, 3, 6, 12, 3, 6}, {8, 3, 10, 8, 3, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{0, 2, 0, -1}, {12, 4, 6, -1}, {8, 4, 10, -1}, {7, 10, 6, 1}, {9, 10, 6, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uw : new int[][]{{2, 1, 1, 4, 1, 1}, {8, 1, 2, 8, 1, 3}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uw : new int[][]{{3, 2, 2}, {2, 2, 6}, {4, 2, 6}, {1, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{11, 0, 9, 11, 0, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{7, 2, 7, 7, 5, 7, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            for (int[] uwg : new int[][]{{8, 2, 3, 1}, {10, 1, 4, 1}, {12, 1, 5, 1}, {10, 1, 8, 1}, {12, 1, 10, 1}, {4, 1, 8, 1}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 2}, {4, 2, 1, 2}, {0, 2, 3, 3}, {0, 2, 5, 3}, {1, 2, 7, 0}, {3, 2, 7, 0}, {5, 2, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2}, {3, 1, 0, 2}, {4, 1, 0, 2}, {1, 1, 1, 3}, {5, 1, 1, 1}, {8, 1, 1, 2}, {9, 1, 2, 1}, {9, 1, 3, 1}, {11, 1, 8, 2}, {10, 1, 9, 3}, {12, 1, 9, 1}, {11, 1, 10, 0}, {7, 7, 3, 2}, {9, 7, 3, 2}, {7, 9, 3, 2}, {9, 9, 3, 2}, {7, 7, 9, 0}, {9, 7, 9, 0}, {7, 9, 9, 0}, {9, 9, 9, 0}, {5, 7, 5, 3}, {5, 7, 7, 3}, {5, 9, 5, 3}, {5, 9, 7, 3}, {11, 7, 5, 1}, {11, 7, 7, 1}, {11, 9, 5, 1}, {11, 9, 7, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            this.func_175811_a(world, Blocks.field_150355_j.func_176223_P(), 2, 2, 6, structureBB);
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{2, 1, 3, 2, 1, 3, 1}, {2, 1, 5, 2, 1, 5, 1}, {11, 2, 6, 11, 2, 6, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{8, 7, 4}, {6, 7, 6}, {8, 7, 8}, {10, 7, 6}, {8, 9, 4}, {6, 9, 6}, {8, 9, 8}, {10, 9, 6}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{6, 11, 3, 10, 11, 4}, {6, 11, 8, 10, 11, 9}, {6, 11, 5, 6, 11, 7}, {5, 11, 4, 5, 11, 8}, {10, 11, 5, 10, 11, 7}, {11, 11, 4, 11, 11, 8}, {6, 12, 4, 10, 12, 5}, {6, 12, 7, 10, 12, 8}, {6, 12, 6, 7, 12, 6}, {9, 12, 6, 10, 12, 6}, {7, 13, 5, 9, 13, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwm : new int[][]{{8, 1, 5, GeneralConfig.useVillageColors ? this.townColor : 10}, {8, 1, 6, GeneralConfig.useVillageColors ? this.townColor : 10}, {8, 1, 7, GeneralConfig.useVillageColors ? this.townColor : 10}, {9, 1, 7, GeneralConfig.useVillageColors ? this.townColor : 10}, {9, 1, 5, GeneralConfig.useVillageColors ? this.townColor : 10}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            int flowernumber = random.nextInt(2) + 1;
            int potU = 9;
            int potV = 2;
            int potW = 6;
            int potX = this.func_74865_a(potU, potW);
            int potY = this.func_74862_a(potV);
            int potZ = this.func_74873_b(potU, potW);
            TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
            BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
            world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
            world.func_175690_a(flowerPotPos, flowerPot);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 1, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 1}, {8, 2, 2}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{5, 1, -1}, {6, 1, -1}, {7, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 0;
                int v = 1;
                int w = 0;
                if (random.nextInt(18) < 12) {
                    u = 3 + random.nextInt(4);
                    w = 3 + random.nextInt(3);
                } else {
                    u = 7 + random.nextInt(2);
                    w = 5 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class TaigaTannery1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", "      F  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaTannery1() {
        }

        public TaigaTannery1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaTannery1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaTannery1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaTannery1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{5, 0, 1, 5, 0, 1}, {7, 0, 1, 7, 0, 1}, {1, 0, 3, 1, 2, 6}, {7, 0, 3, 7, 2, 6}, {2, 0, 3, 6, 0, 6}, {4, 4, 4, 4, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 2, 1, 0, 2, 8}, {1, 3, 1, 1, 3, 8}, {2, 4, 1, 2, 4, 8}, {3, 5, 1, 5, 5, 8}, {6, 4, 1, 6, 4, 8}, {7, 3, 1, 7, 3, 8}, {8, 2, 1, 8, 2, 8}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{5, 1, 1, -1}, {7, 1, 1, -1}, {4, 4, 3, 2}, {4, 4, 6, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 2, 7, 2, 2}, {2, 3, 2, 6, 3, 2}, {3, 4, 2, 5, 4, 2}, {1, 0, 7, 7, 2, 7}, {2, 3, 7, 6, 3, 7}, {3, 4, 7, 5, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uw : new int[][]{{1, 0, 1, 4, 0, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uw : new int[][]{{3, 2, 2}, {3, 2, 7}, {5, 2, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 2}, {4, 2, 1, 2}, {2, 2, 8, 0}, {4, 2, 8, 0}, {6, 2, 8, 0}, {0, 0, 1, 3}, {1, 0, 0, 2}, {2, 0, 0, 2}, {3, 0, 0, 2}, {4, 0, 0, 2}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            int chestU = 2;
            int chestV = 1;
            int chestW = 6;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_tannery");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{3, 1, 3, 2}, {4, 1, 4, 1}, {4, 1, 5, 1}, {3, 1, 6, 0}, {2, 1, 4, 3}, {2, 1, 5, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 3, 1, 4, 3, 1, 5, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{6, 0, 1, 6, 0, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 1, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{6, 1, 5}, {6, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(3), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uwg : new int[][]{{1, 1, 1, 1}, {3, 1, 1, 1}, {4, 1, 1, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, 1}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4 + random.nextInt(2);
                int v = 1;
                int w = 3 + random.nextInt(4);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class TaigaSmallHouse5
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaSmallHouse5() {
        }

        public TaigaSmallHouse5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaSmallHouse5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaSmallHouse5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaSmallHouse5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{2, 1, 2, 4, 5, 2}, {3, 6, 2, 3, 6, 2}, {2, 1, 6, 4, 5, 6}, {3, 6, 6, 3, 6, 6}, {1, 1, 2, 1, 4, 6}, {5, 1, 2, 5, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 4, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 4, 1}, {5, 1, 1, 5, 4, 1}, {1, 1, 7, 1, 4, 7}, {5, 1, 7, 5, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 4, 0, 0, 4, 8}, {1, 5, 0, 1, 5, 8}, {2, 6, 0, 2, 6, 8}, {3, 7, 0, 3, 7, 8}, {4, 6, 0, 4, 6, 8}, {5, 5, 0, 5, 5, 8}, {6, 4, 0, 6, 4, 8}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 4, 1, 2}, {3, 4, 3, 0}, {3, 4, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uw : new int[][]{{1, 3, 4}, {3, 3, 6}, {5, 3, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 3, 3}, {0, 3, 5, 3}, {6, 3, 3, 1}, {6, 3, 5, 1}, {2, 3, 7, 0}, {4, 3, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{4, 2, 5, 4, 2, 5, 3}, {3, 1, 1, 3, 1, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{2, 2, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 10}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            int chestU = 2;
            int chestV = 2;
            int chestW = 3;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uwg : new int[][]{{2, 1, 1, 1}, {4, 1, 1, 1}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 4, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var22_46;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var22_46 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaSmallHouse4
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "  FFF  ", "F FFF  ", "   P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaSmallHouse4() {
        }

        public TaigaSmallHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaSmallHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaSmallHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaSmallHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{1, 1, 3, 5, 3, 3}, {3, 0, 3, 3, 0, 3}, {1, 1, 6, 5, 3, 6}, {1, 1, 4, 1, 4, 5}, {5, 1, 4, 5, 4, 5}, {2, 0, 4, 4, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 1, 3, 0, 2}, {2, 1, 1, 2, 3, 2}, {4, 1, 1, 4, 3, 2}, {3, 3, 1, 3, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 3, 0, 1, 3, 2}, {2, 4, 0, 2, 4, 2}, {3, 5, 0, 3, 5, 3}, {3, 4, 3, 3, 4, 3}, {4, 4, 0, 4, 4, 2}, {5, 3, 0, 5, 3, 2}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{0, 3, 2, 0, 3, 2}, {6, 3, 2, 6, 3, 2}, {0, 4, 3, 2, 4, 3}, {4, 4, 3, 6, 4, 3}, {0, 5, 4, 6, 5, 5}, {0, 4, 6, 6, 4, 6}, {0, 3, 7, 6, 3, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 4, 4, 0}, {3, 4, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uw : new int[][]{{2, 2, 6}, {4, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 7, 0}, {3, 2, 7, 0}, {5, 2, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}, {3, 1, 3, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{4, 1, 4, 2, GeneralConfig.useVillageColors ? this.townColor2 : 11}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 2, 1, 5, structureBB);
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaSmallHouse3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "  FFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaSmallHouse3() {
        }

        public TaigaSmallHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaSmallHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaSmallHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaSmallHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 1, 1, 3, 1}, {5, 0, 1, 5, 3, 1}, {1, 0, 5, 1, 3, 5}, {5, 0, 5, 5, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 3, 1, 4, 4, 1}, {3, 5, 1, 3, 5, 1}, {2, 3, 5, 4, 4, 5}, {3, 5, 5, 3, 5, 5}, {1, 0, 2, 1, 3, 4}, {5, 0, 2, 5, 3, 4}, {2, 0, 1, 4, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 3, 0, 0, 3, 6}, {1, 4, 0, 1, 4, 6}, {2, 5, 0, 2, 5, 6}, {3, 6, 0, 3, 6, 6}, {4, 5, 0, 4, 5, 6}, {5, 4, 0, 5, 4, 6}, {6, 3, 0, 6, 3, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 1, 0}, {4, 0, 0, 4, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 0, -1}, {4, 2, 0, -1}, {4, 4, 2, 0}, {4, 4, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 4, 2, 1}, {2, 1, 5, 4, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 3, 1}, {2, 1, 4, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 0, 0, 3, 0, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{0, 2, 2, 3}, {0, 2, 4, 3}, {6, 2, 2, 1}, {6, 2, 4, 1}, {2, 2, 6, 0}, {4, 2, 6, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{4, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 11}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 2, 1, 2, structureBB);
            int chestU = 4;
            int chestV = 1;
            int chestW = 2;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var23_47;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var23_47 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaSmallHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaSmallHouse2() {
        }

        public TaigaSmallHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaSmallHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaSmallHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaSmallHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 2, 3, 1, 4}, {2, 1, 3, 2, 1, 3}, {4, 1, 3, 4, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2, 1, 0}, {4, 1, 0, 4, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 0, -1}, {4, 2, 0, -1}, {4, 3, 3, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 5, 4, 1}, {2, 5, 1, 4, 5, 1}, {3, 6, 1, 3, 6, 1}, {1, 1, 5, 5, 4, 5}, {2, 5, 5, 4, 5, 5}, {3, 6, 5, 3, 6, 5}, {1, 1, 2, 1, 4, 4}, {5, 1, 2, 5, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 2, 2, 1, 2}, {4, 1, 2, 4, 1, 2}, {2, 1, 4, 2, 1, 4}, {4, 1, 4, 4, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 4, 0, 0, 4, 6}, {1, 5, 0, 1, 5, 6}, {2, 6, 0, 2, 6, 6}, {3, 7, 0, 3, 7, 6}, {4, 6, 0, 4, 6, 6}, {5, 5, 0, 5, 5, 6}, {6, 4, 0, 6, 4, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 2, 2, 0}, {4, 2, 4, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 1, 0, 3, 1, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uw : new int[][]{{1, 3, 3}, {3, 3, 5}, {5, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 2, 3}, {0, 3, 4, 3}, {6, 3, 2, 1}, {6, 3, 4, 1}, {2, 3, 6, 0}, {4, 3, 6, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{2, 2, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 10}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uwg : new int[][]{{1, 1, 0, 1}, {5, 1, 0, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaSmallHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", " F   F ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "   P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaSmallHouse1() {
        }

        public TaigaSmallHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaSmallHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaSmallHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaSmallHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 4, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 5, 1, 4, 5, 2}, {2, 5, 6, 4, 5, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 1, 1}, {4, 1, 1, 4, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 1, -1}, {4, 2, 1, -1}, {3, 5, 3, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 2, 4, 4, 2}, {3, 6, 2, 3, 6, 2}, {2, 1, 6, 4, 4, 6}, {3, 6, 6, 3, 6, 6}, {1, 2, 3, 1, 5, 5}, {5, 2, 3, 5, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 4, 2}, {5, 1, 1, 5, 4, 2}, {1, 1, 6, 1, 4, 7}, {5, 1, 6, 5, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 4, 0, 0, 4, 8}, {1, 5, 0, 1, 5, 8}, {2, 6, 0, 2, 6, 8}, {3, 7, 0, 3, 7, 8}, {4, 6, 0, 4, 6, 8}, {5, 5, 0, 5, 5, 8}, {6, 4, 0, 6, 4, 8}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 2, 4, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 2, 3, 2}, {2, 2, 5, 0}}) {
                int signX = this.func_74865_a(uvwo[0], uvwo[2]);
                int signY = this.func_74862_a(uvwo[1]);
                int signZ = this.func_74873_b(uvwo[0], uvwo[2]);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(uvwo[3], this.func_186165_e().func_176736_b(), true)), 2);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 1, 1, 3, 1, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uw : new int[][]{{1, 3, 4}, {3, 3, 6}, {5, 3, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 3, 3}, {0, 3, 5, 3}, {6, 3, 3, 1}, {6, 3, 5, 1}, {2, 3, 7, 0}, {4, 3, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{4, 2, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 10}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 2, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaSmallFarm1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFF FF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaSmallFarm1() {
        }

        public TaigaSmallFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaSmallFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaSmallFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaSmallFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uvw : new int[][]{{0, 1, 0}, {0, 1, 1}, {0, 1, 4}, {0, 1, 6}, {3, 1, 7}, {5, 1, 7}, {6, 1, 1}, {6, 1, 4}, {6, 1, 5}, {6, 1, 7}}) {
                this.func_175811_a(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{0, 1, 2}, {0, 1, 3}, {0, 1, 5}, {0, 1, 7}, {1, 1, 0}, {1, 1, 5}, {1, 1, 7}, {2, 1, 0}, {2, 1, 3}, {2, 1, 7}, {3, 1, 1}, {4, 1, 0}, {4, 1, 7}, {5, 1, 0}, {5, 1, 5}, {6, 1, 0}, {6, 1, 2}, {6, 1, 3}, {6, 1, 6}}) {
                this.func_175811_a(world, biomeMossyCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 0, 1}, {1, 1, 3}, {1, 0, 6}, {2, 1, 6}, {3, 0, 3}, {4, 1, 3}, {5, 0, 1}, {5, 1, 3}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 0, 2, 2, 0}, {4, 2, 0, 4, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 0, -1}, {4, 3, 0, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 2, 7}, {1, 1, 4, 7}, {2, 1, 1, 7}, {2, 1, 2, 7}, {2, 1, 4, 7}, {2, 1, 5, 7}, {3, 1, 2, 7}, {3, 1, 4, 7}, {3, 1, 5, 7}, {3, 1, 6, 7}, {4, 1, 1, 7}, {4, 1, 2, 7}, {4, 1, 4, 7}, {4, 1, 6, 7}, {5, 1, 2, 7}, {5, 1, 4, 7}, {5, 1, 6, 7}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {2, 2, 6}, {4, 2, 3}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150423_aK.func_176203_a(random.nextInt(3)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 2}, {1, 2, 4}, {2, 2, 1}, {2, 2, 2}, {2, 2, 4}, {2, 2, 5}, {3, 2, 2}, {3, 2, 4}, {3, 2, 5}, {3, 2, 6}, {4, 2, 1}, {4, 2, 2}, {4, 2, 4}, {4, 2, 6}, {5, 2, 2}, {5, 2, 4}, {5, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150393_bb.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 1}, {1, 1, 6}, {3, 1, 3}, {4, 1, 5}, {5, 1, 1}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            for (int[] uvw : new int[][]{{2, 2, 3}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                if (compostBinState != null) {
                    this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150423_aK.func_176203_a(random.nextInt(3)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 1, 0, 3, 1, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 1 + random.nextInt(5);
                int v = 2;
                int w = random.nextBoolean() ? 2 : 4;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaShepherdsHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFFFF  ", "F FFFFFFF  ", "  FFFFFFF  ", "  FFFFFFF  ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " F F F F F ", "   P   P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaShepherdsHouse1() {
        }

        public TaigaShepherdsHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaShepherdsHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaShepherdsHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaShepherdsHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 8}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{1, 1, 2, 9, 2, 2}, {1, 1, 5, 9, 2, 5}, {1, 1, 3, 1, 2, 4}, {9, 1, 3, 9, 2, 4}, {2, 1, 6, 2, 1, 9}, {3, 1, 9, 7, 1, 9}, {8, 1, 6, 8, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 3, 2, 3, 4, 2}, {3, 5, 2, 3, 5, 2}, {5, 3, 2, 5, 3, 2}, {7, 3, 2, 8, 4, 2}, {7, 5, 2, 7, 5, 2}, {2, 3, 5, 4, 4, 5}, {3, 5, 5, 3, 5, 5}, {6, 3, 5, 8, 4, 5}, {7, 5, 5, 7, 5, 5}, {1, 3, 2, 1, 4, 5}, {9, 3, 2, 9, 4, 5}, {2, 1, 3, 8, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 2, 6}, {2, 2, 7}, {2, 2, 8}, {2, 2, 9}, {3, 2, 9}, {4, 2, 9}, {5, 2, 9}, {6, 2, 9}, {7, 2, 9}, {8, 2, 6}, {8, 2, 7}, {8, 2, 8}, {8, 2, 9}, {8, 2, 3}, {8, 2, 4}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{5, 4, 0, 5, 4, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 5, 1, 2}, {7, 5, 1, 2}, {4, 4, 3, 3}, {6, 4, 3, 1}, {2, 3, 9, -1}, {8, 3, 9, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 3, 2, 4, 4, 2}, {6, 3, 2, 6, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 3, 1}, {5, 1, 1, 5, 3, 1}, {9, 1, 1, 9, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uw : new int[][]{{0, 3, 0, 0, 3, 6}, {1, 4, 0, 1, 4, 6}, {2, 5, 0, 2, 5, 6}, {3, 6, 0, 3, 6, 6}, {4, 5, 0, 4, 5, 6}, {6, 5, 0, 6, 5, 6}, {7, 6, 0, 7, 6, 6}, {8, 5, 0, 8, 5, 6}, {9, 4, 0, 9, 4, 6}, {10, 3, 0, 10, 3, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 4, 1, 4, 4, 1}, {6, 4, 1, 8, 4, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 1, 1, 3, 1, 1, 3}, {7, 1, 1, 7, 1, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uw : new int[][]{{3, 1, 6, 7, 1, 8}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uw : new int[][]{{3, 3, 5}, {7, 3, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{2, 3, 6, 0}, {4, 3, 6, 0}, {6, 3, 6, 0}, {8, 3, 6, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uvwo[3], true, true)), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{8, 2, 3}, {8, 2, 4}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState loomState = ModObjects.chooseModLoom(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 2, 3}, {2, 2, 4}}) {
                this.func_175811_a(world, loomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{4, 2, 3, GeneralConfig.useVillageColors ? this.townColor : 10}, {5, 2, 4, GeneralConfig.useVillageColors ? this.townColor : 10}, {6, 2, 3, GeneralConfig.useVillageColors ? this.townColor : 10}, {4, 2, 4, GeneralConfig.useVillageColors ? this.townColor4 : 0}, {5, 2, 3, GeneralConfig.useVillageColors ? this.townColor4 : 0}, {6, 2, 4, GeneralConfig.useVillageColors ? this.townColor4 : 0}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 2, 2, 1, 1}, {7, 2, 2, 2, 1, 0}, {5, 2, 5, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {7, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(5);
                int v = 2;
                int w = 3 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{6, 2, 8}}) {
                        BlockPos animalPos = new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]));
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(animalPos), null);
                        animal.func_70012_b((double)animalPos.func_177958_n() + 0.5, (double)animalPos.func_177956_o() + 0.5, (double)animalPos.func_177952_p() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaMediumHouse4
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", "    P    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaMediumHouse4() {
        }

        public TaigaMediumHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaMediumHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaMediumHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaMediumHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{4, 0, 1, 4, 0, 1}, {2, 1, 1, 6, 2, 1}, {3, 3, 1, 5, 3, 1}, {2, 1, 7, 6, 2, 7}, {3, 3, 7, 5, 3, 7}, {1, 1, 2, 1, 2, 6}, {7, 1, 2, 7, 2, 6}, {4, 0, 3, 4, 0, 3}, {4, 2, 4, 4, 3, 4}, {3, 5, 3, 5, 5, 3}, {3, 5, 5, 5, 5, 5}, {3, 5, 4, 3, 5, 4}, {5, 5, 4, 5, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 0, 2, 4, 0, 2}, {2, 0, 2, 3, 0, 6}, {5, 0, 2, 6, 0, 6}, {4, 0, 5, 4, 0, 6}, {4, 1, 6, 4, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 2, 1}, {2, 3, 1, 2, 3, 1}, {6, 3, 1, 6, 3, 1}, {7, 1, 1, 7, 2, 1}, {1, 1, 7, 1, 2, 7}, {7, 1, 7, 7, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 2, 0, 0, 2, 8}, {1, 3, 0, 1, 3, 8}, {2, 4, 0, 2, 4, 8}, {3, 5, 0, 3, 5, 2}, {3, 5, 6, 3, 5, 8}, {4, 5, 0, 4, 5, 2}, {4, 5, 6, 4, 5, 8}, {5, 5, 0, 5, 5, 2}, {5, 5, 6, 5, 5, 8}, {6, 4, 0, 6, 4, 8}, {7, 3, 0, 7, 3, 8}, {8, 2, 0, 8, 2, 8}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{3, 4, 1, 5, 4, 1}, {3, 4, 7, 5, 4, 7}, {2, 3, 7, 2, 3, 7}, {6, 3, 7, 6, 3, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{4, 4, 0, 2}, {4, 4, 8, 0}, {4, 2, 3, 2}, {3, 2, 4, 3}, {5, 2, 4, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 2, 1}, {2, 1, 3, 1}, {6, 1, 2, 0}, {6, 1, 3, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 4, 3, 5, 4, 3, 7}, {3, 4, 5, 5, 4, 5, 6}, {3, 4, 4, 3, 4, 4, 4}, {5, 4, 4, 5, 4, 4, 5}, {3, 6, 3, 5, 6, 3, 3}, {3, 6, 5, 5, 6, 5, 2}, {3, 6, 4, 3, 6, 4, 0}, {5, 6, 4, 5, 6, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uw : new int[][]{{3, 2, 7}, {5, 2, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 8, 0}, {4, 2, 8, 0}, {6, 2, 8, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 1, 4, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), this.func_186165_e());
            for (int[] uvw : new int[][]{{4, 4, 4}}) {
                if (campfireState.func_177230_c() == Block.func_149684_b((String)"campfire:campfire")) {
                    int woodmeta = biomePlankState.func_177230_c().func_176201_c(biomePlankState);
                    ModObjects.setModCampfireBlockstate(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), woodmeta);
                    continue;
                }
                this.func_175811_a(world, campfireState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{3, 1, 4, 3}, {4, 1, 5, 0}, {5, 1, 4, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{3, 1, 6, 1, GeneralConfig.useVillageColors ? this.townColor : 10}, {5, 1, 6, 3, GeneralConfig.useVillageColors ? this.townColor : 10}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 2, -1, 0}, {6, 1, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaMediumHouse3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"             ", "FFFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", "F FFF   FFF  ", "  FFF F FFF  ", "   P  F  P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaMediumHouse3() {
        }

        public TaigaMediumHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaMediumHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaMediumHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaMediumHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{6, 1, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{1, 1, 3, 1, 3, 6}, {1, 4, 4, 1, 4, 5}, {11, 1, 3, 11, 3, 6}, {11, 4, 4, 11, 4, 5}, {5, 1, 3, 7, 3, 3}, {2, 1, 6, 10, 3, 6}, {3, 0, 1, 3, 0, 2}, {9, 0, 1, 9, 0, 2}, {2, 0, 3, 4, 0, 5}, {5, 0, 4, 7, 0, 5}, {8, 0, 3, 10, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 4, 3, 1}, {3, 4, 1, 3, 4, 2}, {8, 1, 1, 10, 3, 1}, {9, 4, 1, 9, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {9, 3, 0, 2}, {3, 3, 2, 0}, {6, 3, 4, 0}, {9, 3, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 2, 2, 3, 2}, {4, 1, 2, 4, 3, 2}, {8, 1, 2, 8, 3, 2}, {10, 1, 2, 10, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 1, 5, 1}, {7, 1, 5, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 3, 0, 1, 3, 2}, {2, 4, 0, 2, 4, 2}, {3, 5, 0, 3, 5, 3}, {4, 4, 0, 4, 4, 2}, {5, 3, 0, 5, 3, 2}, {7, 3, 0, 7, 3, 2}, {8, 4, 0, 8, 4, 2}, {9, 5, 0, 9, 5, 3}, {10, 4, 0, 10, 4, 2}, {11, 3, 0, 11, 3, 2}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{0, 3, 2, 0, 3, 2}, {12, 3, 2, 12, 3, 2}, {0, 4, 3, 12, 4, 3}, {0, 5, 4, 12, 5, 4}, {0, 5, 5, 12, 5, 5}, {0, 4, 6, 12, 4, 6}, {0, 3, 7, 12, 3, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uw : new int[][]{{3, 2, 6}, {6, 2, 6}, {9, 2, 6}, {6, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 2, 2, 2}, {7, 2, 2, 2}, {2, 2, 7, 0}, {4, 2, 7, 0}, {5, 2, 7, 0}, {7, 2, 7, 0}, {8, 2, 7, 0}, {10, 2, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{3, 1, 5}, {6, 1, 5}, {9, 1, 5}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{3, 2, 5, 1}, {6, 2, 5, 2}, {9, 2, 5, 2}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, false)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}, {9, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{2, 1, 4, 2, GeneralConfig.useVillageColors ? this.townColor2 : 11}, {10, 1, 4, 2, GeneralConfig.useVillageColors ? this.townColor2 : 11}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 10, 1, 3, structureBB);
            for (int[] uuvvww : new int[][]{{2, 4, 4, 2, 4, 5}, {10, 4, 4, 10, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            int chestU = 2;
            int chestV = 1;
            int chestW = 3;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uwg : new int[][]{{0, 1, 6, 1}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {9, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 1, 4, -1, 0}, {8, 1, 4, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var26_62;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var26_62 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaMediumHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "FFFFF  ", "FFFFF  ", "PFFP   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaMediumHouse2() {
        }

        public TaigaMediumHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaMediumHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaMediumHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaMediumHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{3, 0, 3, 3, 0, 3}, {1, 1, 3, 5, 8, 3}, {1, 1, 6, 5, 8, 6}, {1, 1, 4, 1, 9, 5}, {5, 1, 4, 5, 9, 5}, {2, 0, 4, 4, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 2, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 2, 2}, {4, 1, 1, 4, 2, 2}, {3, 0, 1, 3, 0, 2}, {3, 3, 1, 3, 3, 1}, {0, 4, 5, 0, 4, 5}, {2, 4, 4, 4, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 4, 0}, {0, 6, 4, 3}, {2, 9, 4, 1}, {2, 9, 5, 1}, {4, 9, 4, 3}, {4, 9, 5, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 1, 1, 3}, {0, 1, 2, 6}, {0, 2, 2, 3}, {0, 2, 3, 6}, {0, 3, 3, 3}, {0, 3, 4, 6}, {0, 4, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 2, 0, 1, 2, 2}, {2, 3, 0, 2, 3, 2}, {3, 4, 0, 3, 4, 2}, {4, 3, 0, 4, 3, 2}, {5, 2, 0, 5, 2, 2}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{0, 8, 2, 6, 8, 2}, {0, 9, 3, 6, 9, 3}, {0, 10, 4, 6, 10, 4}, {0, 10, 5, 6, 10, 5}, {0, 9, 6, 6, 9, 6}, {0, 8, 7, 6, 8, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uw : new int[][]{{2, 6, 3}, {4, 6, 3}, {2, 6, 6}, {4, 6, 6}, {2, 2, 6}, {4, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 2, 2}, {3, 6, 2, 2}, {5, 6, 2, 2}, {1, 6, 7, 0}, {3, 6, 7, 0}, {5, 6, 7, 0}, {1, 2, 7, 0}, {3, 2, 7, 0}, {5, 2, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}, {3, 1, 3, 2, 1, 0}, {1, 5, 5, 3, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{3, 1, 5, 1, GeneralConfig.useVillageColors ? this.townColor2 : 11}, {3, 5, 4, 3, GeneralConfig.useVillageColors ? this.townColor : 10}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 4, 1, 5, structureBB);
            int chestU = 2;
            int chestV = 5;
            int chestW = 4;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{0, 1, -1}, {3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 1, 4, -1, 0}, {3, 5, 5, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var23_48;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var23_48 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaMediumHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFFP", "  FFF  P", "  FFF PP", "  FFF PF", " FFFFFP ", " F   FPF", "     FP "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 3;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaMediumHouse1() {
        }

        public TaigaMediumHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaMediumHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaMediumHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaMediumHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 3, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 3);
            this.establishFoundation(world, structureBB, foundationPattern, 3, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uvw : new int[][]{{6, 2, 6}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_74878_a(world, structureBB, uvw[0], uvw[1] + 1, uvw[2], uvw[0], uvw[1] + 4, uvw[2]);
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 1, 4}, {0, 1, 5}, {0, 1, 6}, {1, 1, 0}, {1, 1, 3}, {1, 1, 4}, {1, 1, 5}, {1, 1, 6}, {2, 0, 0}, {2, 0, 1}, {3, 0, 0}, {3, 0, 1}, {4, 0, 1}, {5, 1, 3}, {5, 1, 4}, {5, 1, 5}, {6, 1, 5}, {7, 1, 0}, {7, 1, 2}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_74878_a(world, structureBB, uvw[0], uvw[1] + 1, uvw[2], uvw[0], uvw[1] + 4, uvw[2]);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, -1, 6}, {3, -1, 6}, {4, -1, 6}, {2, -1, 5}, {3, -1, 5}, {4, -1, 5}, {2, -1, 4}, {3, -1, 4}, {4, -1, 4}, {2, 1, 7}, {3, 1, 7}, {4, 1, 7}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 2, 0, 4, 2, 0}, {2, 1, 4, 4, 1, 6}, {3, 0, 5, 3, 0, 6}, {3, 0, 4, 4, 0, 4}, {3, 2, 3, 3, 2, 4}, {3, 1, 3, 3, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 2, 3, 0, 2}, {2, 1, 2, 4, 4, 2}, {2, 3, 4, 4, 4, 4}, {2, 0, 3, 2, 4, 3}, {4, 0, 3, 4, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 0, 5, 1}, {2, 0, 6, 1}, {6, 3, 6, 1}, {5, 4, 6, 1}, {4, 5, 6, 1}, {1, 5, 1, 7}, {2, 5, 1, 7}, {3, 5, 1, 7}, {4, 5, 1, 7}, {5, 5, 1, 7}, {1, 5, 5, 6}, {2, 5, 5, 6}, {3, 5, 5, 6}, {4, 5, 5, 6}, {5, 5, 5, 6}, {1, 5, 2, 4}, {1, 5, 3, 4}, {1, 5, 4, 4}, {5, 5, 2, 5}, {5, 5, 3, 5}, {5, 5, 4, 5}, {4, 6, 2, 2}, {4, 6, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 1, 4, 8, 1}, {3, 9, 1, 3, 9, 1}, {2, 6, 5, 4, 8, 5}, {3, 9, 5, 3, 9, 5}, {1, 6, 2, 1, 7, 4}, {5, 6, 2, 5, 7, 4}, {2, 5, 2, 4, 5, 4}, {3, 5, 5, 3, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 3, 6, 5, 3, 6}, {4, 4, 6, 4, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{3, 3, 6}, {3, 4, 6}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{4, 6, 3}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 1, 1, 7, 1}, {5, 6, 1, 5, 7, 1}, {1, 6, 5, 1, 7, 5}, {5, 6, 5, 5, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 7, 0, 0, 7, 6}, {1, 8, 0, 1, 8, 6}, {2, 9, 0, 2, 9, 6}, {3, 10, 0, 3, 10, 6}, {4, 9, 0, 4, 9, 6}, {5, 8, 0, 5, 8, 6}, {6, 7, 0, 6, 7, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 1, 2}, {3, 3, 3, 0}, {1, 4, 3, 3}, {5, 4, 3, 1}, {3, 8, 6, 0}, {3, 8, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{4, 1, 0, 4, 1, 0, 0}, {5, 2, 0, 5, 2, 0, 0}, {3, 0, 3, 3, 0, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uw : new int[][]{{3, 7, 1}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 7, 0, 2}, {4, 7, 0, 2}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 2, 2, 1, 1}, {3, 6, 5, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uwg : new int[][]{{1, 3, 1, 1}, {1, 3, 2, 1}, {5, 3, 2, 1}, {5, 3, 1, 0}, {7, 3, 1, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{4, 0, 5, 2, GeneralConfig.useVillageColors ? this.townColor : 10}, {2, 6, 3, 0, GeneralConfig.useVillageColors ? this.townColor2 : 11}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            int chestU = 2;
            int chestV = 0;
            int chestW = 4;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{6, 3, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 6, 4, -1, 0}, {3, 6, 3, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var26_60;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var26_60 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaMasonsHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"F       F", " FFFFFFFF", " FFFFFFFF", " FFFFFFFF", " FFFFFFFF", " FFFFFFFF", "FFFFFFFFF", "FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaMasonsHouse1() {
        }

        public TaigaMasonsHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaMasonsHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaMasonsHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaMasonsHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{3, 1, 2, 5, 4, 2}, {4, 5, 2, 4, 5, 2}, {1, 1, 3, 2, 2, 3}, {2, 3, 3, 2, 3, 3}, {6, 1, 3, 7, 2, 3}, {6, 3, 3, 6, 3, 3}, {1, 1, 6, 7, 2, 6}, {2, 3, 6, 6, 3, 6}, {3, 4, 6, 5, 4, 6}, {4, 5, 6, 4, 5, 6}, {1, 1, 4, 1, 1, 5}, {7, 1, 4, 7, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 2, 1, 0, 2, 7}, {1, 3, 1, 1, 3, 7}, {2, 4, 1, 2, 4, 7}, {3, 5, 1, 3, 5, 7}, {4, 6, 1, 4, 6, 7}, {5, 5, 1, 5, 5, 7}, {6, 4, 1, 6, 4, 7}, {7, 3, 1, 7, 3, 7}, {8, 2, 1, 8, 2, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 1, 2}, {5, 3, 1, 2}, {4, 4, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 3, 5, 1, 3}, {2, 1, 4, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{0, 1, 1}, {8, 1, 1}, {0, 1, 7}, {8, 1, 7}, {1, 2, 4}, {1, 2, 5}, {7, 2, 4}, {7, 2, 5}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{4, 1, 1, 4, 1, 1, 3}, {5, 2, 3, 5, 2, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState stonecutterState = ModObjects.chooseModStonecutterState(2, this.func_186165_e());
            this.func_175811_a(world, stonecutterState, 4, 2, 5, structureBB);
            for (int[] uw : new int[][]{{4, 3, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2}, {3, 1, 1, 1}, {2, 1, 2, 0}, {1, 1, 1, 3}, {6, 1, 0, 2}, {7, 1, 1, 1}, {6, 1, 2, 0}, {5, 1, 1, 3}, {3, 3, 7, 0}, {5, 3, 7, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            int flowerPotU = 3;
            int flowerPotV = 2;
            int flowerPotW = 3;
            int xWithOffset = this.func_74865_a(flowerPotU, flowerPotW);
            int yWithOffset = this.func_74862_a(flowerPotV);
            int zWithOffset = this.func_74873_b(flowerPotU, flowerPotW);
            this.func_175811_a(world, Blocks.field_150457_bL.func_176223_P(), flowerPotU, flowerPotV, flowerPotW, structureBB);
            TileEntityFlowerPot tileentityflowerpot = (TileEntityFlowerPot)world.func_175625_s(new BlockPos(xWithOffset, yWithOffset, zWithOffset));
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (tileentityflowerpot != null) {
                tileentityflowerpot.func_190614_a(new ItemStack(Item.func_150898_a((Block)biomeSaplingState.func_177230_c()), 1, biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState)));
                tileentityflowerpot.func_70296_d();
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4;
                int v = 2;
                int w = 5;
                while (u == 4 && w == 5) {
                    u = 2 + random.nextInt(5);
                    w = 4 + random.nextInt(2);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class TaigaLibrary1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  F    F F ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFPFFFF ", " FFFFPFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaLibrary1() {
        }

        public TaigaLibrary1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaLibrary1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaLibrary1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaLibrary1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{10, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{5, 0, 2, 5, 0, 2}, {1, 1, 2, 9, 4, 2}, {2, 5, 2, 8, 5, 2}, {3, 6, 2, 7, 6, 2}, {4, 7, 2, 6, 7, 2}, {5, 8, 2, 5, 8, 2}, {1, 1, 6, 9, 4, 6}, {2, 5, 6, 8, 5, 6}, {3, 6, 6, 7, 6, 6}, {4, 7, 6, 6, 7, 6}, {5, 8, 6, 5, 8, 6}, {2, 0, 3, 8, 0, 5}, {5, 1, 4, 5, 2, 4}, {6, 1, 4, 6, 1, 4}, {2, 3, 3, 8, 3, 3}, {2, 3, 4, 4, 3, 4}, {2, 3, 5, 8, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 0, 4, 1, 0}, {6, 1, 0, 6, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{0, 4, 1, 0, 4, 7}, {1, 5, 1, 1, 5, 7}, {2, 6, 1, 2, 6, 7}, {3, 7, 1, 3, 7, 7}, {4, 8, 1, 4, 8, 7}, {5, 9, 1, 5, 9, 7}, {6, 8, 1, 6, 8, 7}, {7, 7, 1, 7, 7, 7}, {8, 6, 1, 8, 6, 7}, {9, 5, 1, 9, 5, 7}, {10, 4, 1, 10, 4, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 0, -1}, {6, 2, 0, -1}, {5, 7, 1, 2}, {5, 7, 7, 0}, {4, 2, 3, 0}, {4, 2, 5, 2}, {8, 2, 5, 2}, {3, 6, 4, 1}, {7, 6, 4, 3}, {5, 7, 3, 0}, {5, 7, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 3, 1, 4, 5}, {9, 1, 3, 9, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{5, 3, 4, 5, 3, 4, 1}, {6, 2, 4, 6, 2, 4, 1}, {7, 1, 4, 7, 1, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 3, 1, 1}, {7, 1, 1, 9, 1, 1}, {4, 4, 1, 6, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 3, 3, 1, 5, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {3, 4, 3, 4, 4, 5, GeneralConfig.useVillageColors ? this.townColor : 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvwo : new int[][]{{2, 1, 5, 1}}) {
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState), -1);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 3, 2, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 3, 1}, {2, 1, 4, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uw : new int[][]{{3, 2, 2}, {7, 2, 2}, {4, 5, 2}, {6, 5, 2}, {1, 2, 4}, {9, 2, 4}, {3, 2, 6}, {5, 2, 6}, {7, 2, 6}, {3, 5, 6}, {5, 5, 6}, {7, 5, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{0, 1, 1, 3}, {1, 1, 0, 2}, {2, 1, 0, 2}, {3, 1, 0, 2}, {4, 1, 1, 1}, {6, 1, 1, 3}, {7, 1, 0, 2}, {8, 1, 0, 2}, {9, 1, 0, 2}, {10, 1, 1, 1}, {3, 4, 1, 3}, {4, 4, 0, 2}, {5, 4, 0, 2}, {6, 4, 0, 2}, {7, 4, 1, 1}, {2, 2, 1, 2}, {3, 5, 1, 2}, {5, 5, 1, 2}, {7, 5, 1, 2}, {8, 2, 1, 2}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 5, 1}, {3, 2, 1}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uwg : new int[][]{{1, 2, 1, 1}, {9, 2, 1, 1}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(2);
                int v = random.nextBoolean() ? 1 : 4;
                int w = 3 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class TaigaLargeFarm2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FF  F  ", "FFFFFFF ", " FFFFF F", " FFFFF  ", "PPFFFF  ", "FPPFFF F", "FFPPFF F", "F FPPPPP", "   PFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaLargeFarm2() {
        }

        public TaigaLargeFarm2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaLargeFarm2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaLargeFarm2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaLargeFarm2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{7, 1, 2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] nArray = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(nArray[0], nArray[2]), this.func_74862_a(nArray[1]), this.func_74873_b(nArray[0], nArray[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(nArray[0], nArray[2]), 64, this.func_74873_b(nArray[0], nArray[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, nArray, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 1, 0, 6, 2, 0}, {1, 1, 2, 1, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{6, 3, 0, -1}, {1, 3, 2, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 5, 7}, {1, 1, 6, 7}, {2, 1, 5, 7}, {2, 1, 6, 7}, {2, 1, 7, 3}, {3, 1, 3, 7}, {3, 1, 4, 0}, {3, 1, 5, 1}, {3, 1, 7, 7}, {4, 1, 2, 7}, {4, 1, 4, 7}, {4, 1, 5, 7}, {4, 1, 6, 0}, {5, 1, 2, 0}, {5, 1, 3, 0}, {5, 1, 4, 7}, {5, 1, 5, 7}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 1, 3}, {0, 1, 7}, {2, 1, 1}, {5, 1, 8}, {7, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150423_aK.func_176203_a(random.nextInt(3)), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState iBlockState = ModObjects.chooseModComposterState();
            for (int[] uvw : new int[][]{{5, 1, 0}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                if (iBlockState != null) {
                    this.func_175811_a(world, iBlockState.func_177230_c().func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150423_aK.func_176203_a(random.nextInt(3)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 0, 6}, {4, 0, 3}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, 6}, {4, 1, 3}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{2, 1, 4, 2, 1, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{6, 1, 2, 1}, {6, 1, 3, 1}, {6, 1, 4, 1}, {6, 1, 4, 1}, {5, 1, 6, 1}, {4, 1, 7, 1}, {2, 1, 8, 0}, {3, 1, 8, 0}, {0, 1, 5, 3}, {0, 1, 6, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uwg : new int[][]{{0, 1, 1, 1}, {1, 1, 8, 1}, {4, 1, 0, 1}, {6, 1, 7, 1}, {7, 1, 3, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 1;
                int w = 1;
                int s = random.nextInt(9);
                if (s == 0) {
                    u = 1;
                    w = 4;
                } else if (s <= 2) {
                    u = s;
                    w = 3;
                } else if (s <= 4) {
                    u = s - 1;
                    w = 2;
                } else if (s <= 8) {
                    u = s - 2;
                    w = 1;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaLargeFarm1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  F   P   ", " FFFFFPFFF", "F  FFPPFF ", "  FFFPFFF ", " FFFFPFFF ", " FFFPPFFFF", " FFFPPFF  ", " FFFPFFF  ", " FFPPFFFF ", "   PF  F  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaLargeFarm1() {
        }

        public TaigaLargeFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaLargeFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaLargeFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaLargeFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{8, 1, 1, 8, 3, 1}, {2, 1, 8, 2, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{8, 4, 1, -1}, {2, 4, 8, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 2, 4}, {1, 1, 3, 7}, {1, 1, 4, 5}, {1, 1, 5, 7}, {2, 1, 1, 7}, {2, 1, 2, 5}, {2, 1, 4, 7}, {2, 1, 5, 5}, {2, 1, 6, 4}, {3, 1, 3, 1}, {3, 1, 5, 6}, {3, 1, 7, 5}, {4, 1, 5, 7}, {4, 1, 6, 7}, {4, 1, 7, 7}, {4, 1, 8, 7}, {5, 1, 1, 7}, {5, 1, 2, 7}, {5, 1, 2, 7}, {5, 1, 8, 7}, {6, 1, 1, 1}, {6, 1, 3, 7}, {6, 1, 4, 3}, {6, 1, 6, 5}, {7, 1, 2, 3}, {7, 1, 3, 5}, {7, 1, 4, 7}, {7, 1, 5, 3}, {7, 1, 7, 7}, {8, 1, 6, 7}, {8, 1, 7, 5}, {8, 1, 8, 7}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 1}, {4, 1, 0}, {7, 1, 0}, {9, 1, 4}, {7, 2, 8}, {2, 1, 9}, {0, 1, 7}}) {
                this.func_175811_a(world, Blocks.field_150423_aK.func_176203_a(random.nextInt(3)), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            for (int[] uvw : new int[][]{{3, 1, 2}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                if (compostBinState != null) {
                    this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150423_aK.func_176203_a(random.nextInt(3)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 0, 2}, {3, 0, 6}, {6, 0, 2}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, 3}, {3, 1, 6}, {7, 1, 6}, {6, 1, 2}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 1, 4, 3, 1, 4, 1}, {6, 1, 5, 6, 1, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{1, 1, 0, 2}, {2, 1, 0, 2}, {5, 1, 0, 2}, {6, 1, 0, 2}, {7, 1, 1, 1}, {8, 1, 2, 1}, {8, 1, 3, 1}, {8, 1, 4, 1}, {8, 1, 5, 1}, {9, 1, 6, 1}, {9, 1, 7, 1}, {9, 1, 8, 1}, {8, 1, 9, 0}, {7, 1, 9, 0}, {5, 1, 9, 0}, {4, 1, 9, 0}, {0, 1, 1, 3}, {0, 1, 2, 3}, {0, 1, 3, 3}, {0, 1, 4, 3}, {0, 1, 5, 3}, {1, 1, 6, 3}, {2, 1, 7, 3}, {3, 1, 8, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4;
                int v = 1;
                int w = 4;
                int s = random.nextInt(12);
                if (s == 0) {
                    u = 3;
                    w = 1;
                } else if (s <= 4) {
                    u = 4;
                    w = s;
                } else if (s <= 9) {
                    u = 5;
                    w = s - 2;
                } else if (s <= 11) {
                    u = 6;
                    w = s - 3;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaFletcherHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"           ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", "    FFF    ", "    FFF    ", "    FFF    ", "   FFFFF   ", "    FFF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaFletcherHouse1() {
        }

        public TaigaFletcherHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaFletcherHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaFletcherHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaFletcherHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{4, 0, 3, 6, 3, 3}, {5, 4, 3, 5, 4, 3}, {1, 0, 5, 1, 3, 8}, {1, 4, 6, 1, 4, 7}, {9, 0, 5, 9, 3, 8}, {9, 4, 6, 9, 4, 7}, {2, 0, 8, 8, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 2, 2}, {6, 2, 2, 2}, {5, 3, 4, 0}, {3, 3, 7, 2}, {7, 3, 7, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 5, 3, 3, 5}, {4, 0, 4, 4, 3, 4}, {7, 0, 5, 8, 3, 5}, {6, 0, 4, 6, 3, 4}, {5, 4, 4, 5, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 0, 5, 4, 0, 5}, {2, 0, 6, 3, 0, 7}, {6, 0, 5, 6, 0, 5}, {7, 0, 6, 8, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{3, 3, 2, 3, 3, 4}, {4, 4, 2, 4, 4, 4}, {5, 5, 2, 5, 5, 5}, {6, 4, 2, 6, 4, 4}, {7, 3, 2, 7, 3, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{0, 3, 4, 2, 3, 4}, {8, 3, 4, 10, 3, 4}, {0, 4, 5, 10, 4, 5}, {0, 5, 6, 10, 5, 6}, {0, 5, 7, 10, 5, 7}, {0, 4, 8, 10, 4, 8}, {0, 3, 9, 10, 3, 9}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 0, 4, 5, 0, 5}, {4, 0, 6, 6, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 6, 1}, {2, 1, 7, 1}, {8, 1, 6, 0}, {8, 1, 7, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{5, 0, 2, 5, 0, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvw : new int[][]{{3, 0, 1}, {7, 0, 1}}) {
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 1, 7}, {6, 1, 7}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 2, 7, 4, 2, 7}, {6, 2, 7, 6, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 10), Blocks.field_150404_cg.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 10), false);
            }
            IBlockState fletchingTableState = ModObjects.chooseModFletchingTableState(2, this.func_186165_e());
            this.func_175811_a(world, fletchingTableState, 5, 1, 7, structureBB);
            for (int[] uw : new int[][]{{2, 2, 5}, {8, 2, 5}, {3, 2, 8}, {5, 2, 8}, {7, 2, 8}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], uw[1], uw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 0, 2}, {4, 0, 1, 1}, {3, 0, 2, 0}, {2, 0, 1, 3}, {7, 0, 0, 2}, {8, 0, 1, 1}, {7, 0, 2, 0}, {6, 0, 1, 3}, {1, 2, 4, 2}, {3, 2, 4, 2}, {7, 2, 4, 2}, {9, 2, 4, 2}, {2, 2, 9, 0}, {4, 2, 9, 0}, {6, 2, 9, 0}, {8, 2, 9, 0}}) {
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, 1}, {7, 1, 1}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 3, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int chestU = 4;
            int chestV = 1;
            int chestW = 5;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_fletcher");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(5);
                int v = 1;
                int w = 6;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaFisherCottage1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", " FFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", " FFFFFFFFF", "FFFFFFFFFF", "F FFFFFFFF", "  FFFFFFFF", "F FFFFF   ", " FFFFFFF  ", " FFFP F   ", "    PFF  F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaFisherCottage1() {
        }

        public TaigaFisherCottage1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaFisherCottage1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaFisherCottage1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaFisherCottage1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{9, 2, 0}, {0, 2, 11}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{4, 1, 2, 4, 1, 2}, {3, 2, 2, 5, 5, 2}, {4, 6, 2, 4, 6, 2}, {3, 1, 6, 5, 5, 6}, {4, 6, 6, 4, 6, 6}, {3, 1, 3, 5, 1, 3}, {3, 1, 5, 5, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 1, 2}, {5, 3, 1, 2}, {3, 3, 7, 0}, {5, 3, 7, 0}, {3, 3, 3, 0}, {5, 3, 3, 0}, {4, 5, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 3, 2, 4, 5}, {6, 2, 3, 6, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 4, 5, 1, 4}, {4, 1, 7, 4, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 2, 4, 1}, {6, 2, 1, 6, 4, 1}, {1, 2, 2, 1, 3, 2}, {1, 1, 6, 1, 3, 6}, {7, 2, 2, 7, 3, 2}, {7, 1, 6, 7, 3, 6}, {2, 1, 7, 2, 4, 7}, {6, 1, 7, 6, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 4, 0, 1, 4, 8}, {2, 5, 0, 2, 5, 8}, {3, 6, 0, 3, 6, 8}, {4, 7, 0, 4, 7, 8}, {5, 6, 0, 5, 6, 8}, {6, 5, 0, 6, 5, 8}, {7, 4, 0, 7, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 5, 7, 5, 5, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 5, 2}, {3, 2, 5}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 2, 3, 4, 2, 5, 3}, {3, 2, 7, 3, 2, 7, 3}, {5, 2, 7, 5, 2, 7, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), false);
            }
            for (int[] uuvvww : new int[][]{{3, 3, 5, 3, 3, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, false)), biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, false)), false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 2, 2, 1, 0}, {4, 2, 6, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwb : new int[][]{{0, 1, 0, 1}, {0, 1, 1, 1}, {0, 1, 2, 1}, {0, 1, 4, 1}, {0, 1, 7, 1}, {0, 1, 10, 1}, {1, 1, 0, 1}, {1, 1, 3, 1}, {1, 1, 4, 0}, {1, 1, 5, 0}, {2, 1, 0, 1}, {3, 1, 0, 1}, {5, 1, 1, 1}, {7, 1, 0, 1}, {7, 1, 1, 1}, {7, 1, 3, 1}, {8, 1, 0, 1}, {8, 1, 1, 1}, {8, 1, 2, 1}, {8, 1, 3, 1}, {9, 1, 1, 1}, {9, 1, 2, 1}, {9, 1, 3, 1}}) {
                this.func_175811_a(world, uvwb[0] == 0 ? biomeDirtState : biomeGrassState, uvwb[0], uvwb[1] - 1, uvwb[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 2, 3, 1, 2}, {1, 1, 6, 1, 1, 6}, {2, 1, 1, 2, 1, 1}, {2, 1, 2, 2, 1, 6}, {6, 1, 2, 6, 1, 6}, {1, 0, 4, 1, 0, 6}, {1, 0, 7, 3, 0, 9}, {1, 0, 10, 2, 0, 10}, {5, 0, 7, 5, 0, 7}, {7, 1, 10, 8, 1, 10}, {9, 1, 7, 9, 1, 7}, {6, 1, 1, 6, 1, 1}, {5, 1, 2, 7, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            IBlockState biomeSandState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150354_m.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 0, 11, 5, 0, 11}, {7, 0, 7, 7, 0, 7}, {9, 0, 5, 9, 0, 10}, {8, 0, 5, 8, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandState, biomeSandState, false);
            }
            IBlockState biomeGravelState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 10, 3, 0, 10}, {4, 0, 8, 8, 0, 10}, {6, 0, 11, 8, 0, 11}, {9, 0, 10, 9, 0, 10}, {6, 0, 7, 6, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGravelState, biomeGravelState, false);
            }
            IBlockState biomeClayState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150435_aG.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 0, 5, 5, 0, 5}, {6, 0, 4, 6, 0, 5}, {7, 0, 3, 7, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeClayState, biomeClayState, false);
            }
            for (int[] uvw : new int[][]{{3, 2, 1}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uwg : new int[][]{{0, 2, 3, 0}, {0, 2, 5, 1}, {1, 2, 10, 1}, {1, 2, 1, 1}, {6, 2, 0, 1}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvwoo : new int[][]{{8, 2, 10, 3, -1}, {9, 2, 7, 0, -1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), ModObjects.chooseModBarrelBlockState(this.func_186165_e(), uvwoo[4], uvwoo[3]), 2);
            }
            for (int[] uuvvww : new int[][]{{5, 2, 3, 5, 2, 5}, {1, 1, 8, 3, 1, 9}, {3, 1, 7, 3, 1, 7}, {2, 1, 10, 6, 1, 10}, {5, 1, 8, 7, 1, 9}, {5, 1, 7, 5, 1, 7}, {7, 1, 7, 7, 1, 7}, {7, 1, 5, 7, 1, 5}, {8, 1, 5, 8, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            for (int[] uvw : new int[][]{{4, 2, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4;
                int v = 2;
                int w = 2 + random.nextInt(8);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaCartographerHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "  FPF  ", "  FPF F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaCartographerHouse1() {
        }

        public TaigaCartographerHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaCartographerHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaCartographerHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaCartographerHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{6, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{3, 0, 2, 3, 0, 2}, {1, 1, 2, 1, 3, 6}, {5, 1, 2, 5, 3, 6}, {2, 0, 3, 4, 0, 5}, {2, 1, 6, 4, 3, 6}, {2, 3, 3, 4, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2, 1, 0}, {4, 1, 0, 4, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 2, 1, 6, 2}, {1, 4, 4, 1, 4, 4}, {1, 6, 4, 1, 6, 4}, {1, 4, 6, 1, 6, 6}, {5, 4, 2, 5, 6, 2}, {5, 4, 4, 5, 4, 4}, {5, 6, 4, 5, 6, 4}, {5, 4, 6, 5, 6, 6}, {3, 4, 2, 3, 4, 2}, {3, 6, 2, 3, 6, 2}, {3, 8, 2, 3, 8, 2}, {3, 4, 6, 3, 4, 6}, {3, 6, 6, 3, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 3, 1, 6, 3}, {1, 4, 5, 1, 6, 5}, {5, 4, 3, 5, 6, 3}, {5, 4, 5, 5, 6, 5}, {2, 4, 6, 2, 7, 6}, {4, 4, 6, 4, 7, 6}, {2, 4, 2, 2, 7, 2}, {4, 4, 2, 4, 7, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 0, -1}, {4, 2, 0, -1}, {3, 8, 1, 2}, {2, 2, 3, 1}, {4, 2, 3, 3}, {3, 6, 3, 0}, {3, 6, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 7, 1}, {4, 1, 1, 4, 7, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{0, 6, 0, 0, 6, 7}, {1, 7, 0, 1, 7, 7}, {2, 8, 0, 2, 8, 7}, {3, 9, 0, 3, 9, 7}, {4, 8, 0, 4, 8, 7}, {5, 7, 0, 5, 7, 7}, {6, 6, 0, 6, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 2, 4, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 4, 4}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{2, 4, 3, 2, 4, 3, 1}, {2, 4, 5, 2, 4, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 4, 0, 3, 4, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{0, 2, 3, 0, 2, 3, 3}, {0, 2, 5, 0, 2, 5, 3}, {6, 2, 3, 6, 2, 3, 1}, {6, 2, 5, 6, 2, 5, 1}, {2, 2, 7, 2, 2, 7, 0}, {4, 2, 7, 4, 2, 7, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, true)), biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, true)), false);
            }
            for (int[] uuvvww : new int[][]{{3, 3, 1, 3, 3, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, false)), biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, false)), false);
            }
            for (int[] uuvvww : new int[][]{{2, 5, 4, 2, 5, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, false)), biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, false)), false);
            }
            for (int[] uvw : new int[][]{{1, 2, 4}, {1, 5, 4}, {5, 2, 4}, {5, 5, 4}, {3, 2, 6}, {3, 5, 6}, {3, 5, 2}, {3, 7, 2}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState cartographyTableState = ModObjects.chooseModCartographyTableState(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 1, 5}}) {
                this.func_175811_a(world, cartographyTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{4, 2, 5, 4, 3, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            int chestU = 4;
            int chestV = 4;
            int chestW = 3;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_cartographer");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            this.func_175811_a(world, biomeGrassState, 3, 4, 1, structureBB);
            for (Object uvw : (ChestGenHooks)new int[][]{{3, 5, 1}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, (int)uvw[0], (int)uvw[1], (int)uvw[2], structureBB);
            }
            for (Object uvw : (ChestGenHooks)new int[][]{{3, 1, -1}}) {
                Object pathU = uvw[0];
                Object pathV = uvw[1];
                Object pathW = uvw[2];
                this.func_74871_b(world, (int)pathU, (int)pathV, (int)pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, (int)pathU, (int)(pathV - 2), (int)pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW)))) {
                    this.func_175811_a(world, biomeGrassState, (int)pathU, (int)(pathV - true), (int)pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2;
                int v = 1;
                int w = 5;
                while (u == 2 && w == 5) {
                    u = 2 + random.nextInt(3);
                    w = 3 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class TaigaButcherShop1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 4;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaButcherShop1() {
        }

        public TaigaButcherShop1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaButcherShop1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaButcherShop1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaButcherShop1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 4, 1, 1}, {1, 1, 2, 5, 4, 2}, {2, 5, 2, 4, 5, 2}, {3, 6, 2, 3, 6, 2}, {1, 1, 7, 5, 4, 7}, {9, 1, 4, 9, 4, 7}, {9, 5, 5, 9, 5, 6}, {2, 1, 6, 2, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{6, 1, 1, 9, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 2, 1, 6, 2, 2}, {7, 2, 1, 9, 2, 1}, {9, 2, 2, 9, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{3, 5, 1, 2}, {3, 4, 3, 0}, {3, 4, 6, 2}, {8, 4, 6, 3}, {8, 4, 5, 3}, {9, 3, 2, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 4, 7}, {1, 5, 5, 1, 5, 6}, {5, 1, 2, 5, 4, 4}, {6, 1, 7, 9, 4, 7}, {6, 1, 4, 8, 4, 4}, {5, 5, 5, 9, 5, 6}, {5, 6, 5, 6, 6, 5}, {5, 6, 7, 5, 6, 7}, {4, 6, 6, 4, 6, 6}, {2, 1, 2, 2, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 3, 6, 5, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{0, 4, 1, 0, 4, 3}, {1, 5, 1, 1, 5, 4}, {2, 6, 1, 2, 6, 4}, {3, 7, 1, 3, 7, 4}, {4, 6, 1, 4, 6, 4}, {5, 5, 1, 5, 5, 4}, {6, 4, 1, 6, 4, 3}, {0, 4, 8, 10, 4, 8}, {0, 5, 7, 10, 5, 7}, {0, 6, 6, 3, 6, 6}, {6, 6, 6, 10, 6, 6}, {0, 6, 5, 4, 6, 5}, {7, 6, 5, 10, 6, 5}, {0, 5, 4, 0, 5, 4}, {6, 5, 4, 10, 5, 4}, {7, 4, 3, 10, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{0, 4, 1, 0, 4, 3}, {1, 5, 1, 1, 5, 4}, {2, 6, 1, 2, 6, 4}, {3, 7, 1, 3, 7, 4}, {4, 6, 1, 4, 6, 4}, {5, 5, 1, 5, 5, 4}, {6, 4, 1, 6, 4, 3}, {3, 6, 3, 3, 6, 3}, {2, 5, 3, 4, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 6, 3, 3, 6, 3}, {2, 1, 3, 2, 1, 5}, {3, 1, 3, 4, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{7, 1, 6}, {8, 2, 6}, {8, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150334_T.func_176203_a(0), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 1, 5}, {6, 1, 5}, {7, 1, 5}, {8, 1, 5}, {5, 1, 6}, {6, 1, 6}, {8, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150333_U.func_176203_a(8), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{5, 2, 6, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(smokerState.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{2, 1, 0, 4, 1, 0, 3}, {4, 7, 5, 6, 7, 5, 3}, {4, 7, 7, 6, 7, 7, 2}, {4, 7, 6, 4, 7, 6, 0}, {6, 7, 6, 6, 7, 6, 1}, {4, 6, 7, 4, 6, 7, 4}, {6, 6, 7, 6, 6, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 1, 0, 9, 1, 0, 2}, {5, 1, 1, 5, 1, 1, 3}, {10, 1, 1, 10, 1, 3, 1}, {2, 2, 5, 2, 2, 5, 2}, {3, 2, 6, 3, 2, 6, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{0, 3, 4, 0, 3, 4, 3}, {0, 3, 7, 0, 3, 7, 3}, {2, 3, 8, 2, 3, 8, 0}, {4, 3, 8, 4, 3, 8, 0}, {6, 3, 8, 6, 3, 8, 0}, {8, 3, 8, 8, 3, 8, 0}, {5, 4, 5, 5, 4, 5, 2}, {6, 4, 6, 6, 4, 6, 1}, {4, 4, 6, 4, 4, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, true)), biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, true)), false);
            }
            for (int[] uvw : new int[][]{{1, 3, 5}, {1, 3, 6}, {3, 3, 7}, {7, 3, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 2, 2, 1, 1}, {7, 2, 4, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), this.func_186165_e());
            for (int[] uvw : new int[][]{{5, 5, 6}}) {
                if (campfireState.func_177230_c() == Block.func_149684_b((String)"campfire:campfire")) {
                    int woodmeta = biomePlankState.func_177230_c().func_176201_c(biomePlankState);
                    ModObjects.setModCampfireBlockstate(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), woodmeta);
                    continue;
                }
                this.func_175811_a(world, campfireState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 0}, {0, 1, 6}, {4, 1, 8}, {5, 1, 8}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uwg : new int[][]{{0, 1, 3, 1}, {1, 1, 1, 1}, {5, 1, 0, 1}, {10, 1, 4, 1}, {10, 1, 5, 0}, {10, 1, 6, 1}, {3, 1, 8, 0}, {8, 1, 8, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{7, 2, 2}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
                int u = 2 + random.nextInt(6);
                int v = 2;
                int w = 5;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class TaigaArmorerHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " F P  F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaArmorerHouse1() {
        }

        public TaigaArmorerHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaArmorerHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaArmorerHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaArmorerHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 2, 4, 0, 2}, {3, 0, 7, 4, 0, 7}, {2, 0, 2, 2, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 2, 8}, {5, 1, 1, 5, 2, 8}, {2, 1, 1, 4, 3, 1}, {3, 4, 1, 3, 4, 1}, {2, 1, 8, 4, 3, 8}, {3, 4, 8, 3, 4, 8}, {3, 0, 1, 3, 0, 1}, {3, 0, 3, 3, 0, 6}, {4, 1, 3, 4, 1, 3}, {4, 1, 6, 4, 1, 6}, {4, 2, 4, 4, 3, 5}, {4, 4, 5, 4, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvw : new int[][]{{4, 1, 4, 3}, {4, 1, 5, 3}}) {
                IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(uvw[3], this.func_186165_e());
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), blastFurnaceState, 2);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 5, 5, 4, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{0, 2, 0, 0, 2, 9}, {1, 3, 0, 1, 3, 9}, {2, 4, 0, 2, 4, 9}, {3, 5, 0, 3, 5, 9}, {4, 4, 0, 4, 4, 9}, {5, 3, 0, 5, 3, 9}, {6, 2, 0, 6, 2, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 2, 0}, {3, 3, 7, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{4, 2, 3, 4, 2, 3, 3}, {4, 2, 6, 4, 2, 6, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 9, 2, 2, 9, 0}, {4, 2, 9, 4, 2, 9, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, true)), biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], true, true)), false);
            }
            for (int[] uvw : new int[][]{{3, 2, 8}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, 0}, {6, 1, 0}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(2);
                int v = 1;
                int w = 2 + random.nextInt(6);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class TaigaArmorer2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FPFFP", " PFFFP ", "FFFFFF ", "FPFFFPF", "PFFFFPP", " PPPPF ", "F PPP P"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaArmorer2() {
        }

        public TaigaArmorer2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaArmorer2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaArmorer2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaArmorer2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] nArray = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(nArray[0], nArray[2]), this.func_74862_a(nArray[1]), this.func_74873_b(nArray[0], nArray[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(nArray[0], nArray[2]), 64, this.func_74873_b(nArray[0], nArray[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, nArray, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(2, this.func_186165_e());
            for (int[] uvw : new int[][]{{3, 1, 4}}) {
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), blastFurnaceState, 2);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 3, 0, 3, 3}, {3, 2, 4, 3, 7, 4}, {6, 1, 3, 6, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], iBlockState, iBlockState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{1, 4, 2, 5, 4, 2}, {0, 4, 3, 6, 4, 3}, {1, 4, 4, 5, 4, 4}, {1, 5, 3, 5, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvw : new int[][]{{2, 0, 2}, {3, 0, 2}, {3, 0, 3}, {4, 0, 2}, {3, 4, 4}}) {
                this.func_175811_a(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 4, 1, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), this.func_186165_e());
            for (int[] uvw : new int[][]{{5, 1, 1}}) {
                if (campfireState.func_177230_c() == Block.func_149684_b((String)"campfire:campfire")) {
                    int woodmeta = biomePlankState.func_177230_c().func_176201_c(biomePlankState);
                    ModObjects.setModCampfireBlockstate(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), woodmeta);
                    continue;
                }
                this.func_175811_a(world, campfireState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{2, 1, 3, 2, 1, 3, 3}, {4, 1, 3, 4, 1, 3, 3}, {2, 1, 4, 2, 1, 4, 0}, {4, 1, 4, 4, 1, 4, 1}, {2, 1, 5, 4, 1, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uwg : new int[][]{{0, 1, 4, 1}, {2, 1, 6, 1}, {5, 1, 6, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(3);
                int v = 1;
                int w = 0 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class TaigaAnimalPen1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"             ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", "      F      "};
        private static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        private static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public TaigaAnimalPen1() {
        }

        public TaigaAnimalPen1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static TaigaAnimalPen1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return TaigaAnimalPen1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new TaigaAnimalPen1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    if (!foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase().equals("F") && world.func_180495_p(new BlockPos(this.func_74865_a(u, w), this.func_74862_a(-1), this.func_74873_b(u, w))) != biomeDirtState) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeGrassState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 1, 11, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 5, 1, 1}, {7, 1, 1, 11, 1, 1}, {1, 1, 6, 11, 1, 6}, {1, 1, 1, 1, 1, 6}, {11, 1, 1, 11, 1, 6}, {1, 2, 1, 1, 2, 1}, {1, 2, 6, 1, 2, 6}, {11, 2, 1, 11, 2, 1}, {11, 2, 6, 11, 2, 6}, {5, 2, 1, 5, 3, 1}, {7, 2, 1, 7, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{6, 1, 1, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 3, 1, 6, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{6, 4, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 0, 5, 0, 0, 2}, {7, 0, 0, 11, 0, 0, 2}, {1, 0, 7, 11, 0, 7, 0}, {0, 0, 1, 0, 0, 6, 3}, {12, 0, 1, 12, 0, 6, 1}, {3, 1, 3, 4, 1, 3, 2}, {2, 1, 4, 2, 1, 4, 3}, {3, 1, 5, 4, 1, 5, 0}, {5, 1, 4, 5, 1, 4, 1}, {6, 3, 0, 6, 3, 0, 2}, {6, 3, 2, 6, 3, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), biomeTrapdoorState.func_177230_c().func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[6], false, true)), false);
            }
            this.func_175804_a(world, structureBB, 3, 1, 4, 4, 1, 4, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{6, 0, 0, 6, 0, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{6, 1, 3}, {8, 1, 4}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class TaigaMeetingPoint2
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"   PPP F ", "FPPPPPPP ", " PFFFFFPF", "PPFFFFFPP", "PPFFFFFPP", "PPFFFFFPP", " PFFFFFP ", " PPPPPPP ", "   PPPF F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        public static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public TaigaMeetingPoint2() {
        }

        public TaigaMeetingPoint2(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 70, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 70, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 2, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(8, 1), this.func_74862_a(2), this.func_74873_b(8, 1));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            int[][] decorUVW = new int[][]{{0, 2, 7}, {8, 2, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] nArray = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(nArray[0], nArray[2]), this.func_74862_a(nArray[1]), this.func_74873_b(nArray[0], nArray[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(nArray[0], nArray[2]), 0, this.func_74873_b(nArray[0], nArray[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, nArray, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            this.func_175804_a(world, structureBB, 2, 1, 2, 6, 2, 6, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 2, 0, 2, 6, 0, 6, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 3, 0, 3, 5, 0, 5, biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            this.func_175804_a(world, structureBB, 3, 1, 3, 5, 2, 5, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            this.func_175811_a(world, biomeMossyCobblestoneState, 3, 2, 2, structureBB);
            this.func_175811_a(world, biomeMossyCobblestoneState, 2, 2, 4, structureBB);
            this.func_175811_a(world, biomeCobblestoneState, 3, 0, 3, structureBB);
            this.func_175804_a(world, structureBB, 2, 3, 2, 6, 5, 6, biomeFenceState, biomeFenceState, false);
            this.func_74878_a(world, structureBB, 2, 3, 3, 6, 4, 5);
            this.func_74878_a(world, structureBB, 3, 3, 2, 5, 4, 6);
            this.func_74878_a(world, structureBB, 3, 5, 3, 5, 5, 5);
            IBlockState roofLogState = StructureVillageVN.getHorizontalPillarState(biomeLogState, this.func_186165_e().func_176736_b(), false);
            this.func_175804_a(world, structureBB, 3, 6, 2, 5, 6, 6, roofLogState, roofLogState, false);
            this.func_175804_a(world, structureBB, 2, 5, 2, 2, 5, 6, roofLogState, roofLogState, false);
            this.func_175804_a(world, structureBB, 6, 5, 2, 6, 5, 6, roofLogState, roofLogState, false);
            for (int[] uvwo : new int[][]{{2, 5, 1, 2}, {6, 5, 1, 2}, {2, 5, 7, 0}, {6, 5, 7, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (GeneralConfig.useVillageColors) {
                int n = ((int)world.func_72905_C() % 4 + this.func_186165_e().func_176736_b()) % 4;
                BlockPos uvw = new BlockPos(4, 5, 4);
                int metaCycle = (n + Math.abs(this.func_74865_a(uvw.func_177958_n(), uvw.func_177952_p()) % 2 - this.func_74873_b(uvw.func_177958_n(), uvw.func_177952_p()) % 2 * 3) + uvw.func_177956_o()) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
            } else {
                this.func_175811_a(world, biomePlankState, 4, 5, 4, structureBB);
            }
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int n = 4;
                int signYBB = 5;
                int signZBB = 5;
                int signZBB2 = 3;
                int signX = this.func_74865_a(n, signZBB);
                int signX2 = this.func_74865_a(n, signZBB2);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(n, signZBB);
                int signZ2 = this.func_74873_b(n, signZBB2);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(0, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                TileEntitySign signContents2 = new TileEntitySign();
                for (int i = 0; i < 4; ++i) {
                    signContents2.field_145915_a[i] = signContents.field_145915_a[i];
                }
                world.func_180501_a(new BlockPos(signX2, signY, signZ2), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(2, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX2, signY, signZ2), (TileEntity)signContents2);
            }
            if (GeneralConfig.villageBanners) {
                int n = 7;
                int bannerZBB = 8;
                int bannerYBB = 2;
                int bannerX = this.func_74865_a(n, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(n, bannerZBB);
                this.func_175804_a(world, structureBB, n, bannerYBB - 2, bannerZBB, n, bannerYBB - 1, bannerZBB, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175808_b(world, biomeFillerState, n, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, true);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            } else {
                int n = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(7, 8), 0, this.func_74873_b(7, 8))).func_177977_b().func_177956_o();
                if (n > -1) {
                    this.func_175811_a(world, biomeGrassState, 7, n - 1 - this.field_74887_e.field_78895_b, 8, structureBB);
                    this.func_74871_b(world, 7, n - this.field_74887_e.field_78895_b, 8, structureBB);
                }
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{7, 2, 1, -1, 0}, {8, 2, 3, -1, 0}, {0, 2, 5, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class TaigaMeetingPoint1
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"PPFPPPPPPPF ", "PPPFPFPPFPF ", "PPFPPPPPPPPP", "PFFFPPFPFPFP", "FPFPPFPPPFPP", "PPFFPPPPFPP ", "    PPP     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 3;
        public static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public TaigaMeetingPoint1() {
        }

        public TaigaMeetingPoint1(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 66, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 66, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            if (this.func_186165_e().func_176736_b() == 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 3) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 2 : 4), EnumFacing.EAST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 1 ? 2 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 3) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 4, EnumFacing.WEST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 0) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78897_a + -1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (random.nextInt(4) - 1), EnumFacing.WEST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 1) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78897_a + (random.nextInt(4) + 1), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + -1, EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 2) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78897_a + -1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (random.nextInt(4) - 1), EnumFacing.WEST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 3) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78897_a + random.nextInt(4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + -1, EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 0) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78897_a + (random.nextInt(6) + 3), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 1) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78897_a + -1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (random.nextInt(6) + 3), EnumFacing.WEST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 2) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78897_a + -1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (random.nextInt(6) + 3), EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 3) {
                StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (random.nextInt(6) + 3), EnumFacing.EAST, this.func_74877_c());
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)9, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(2, 3), this.func_74862_a(2), this.func_74873_b(2, 3));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            for (int[] offset_xy : new int[][]{{0, 2}, {1, 3}, {2, 1}, {2, 2}, {2, 4}, {2, 6}, {3, 1}, {3, 3}, {3, 5}, {5, 2}, {5, 5}, {6, 3}, {8, 1}, {8, 3}, {8, 5}, {9, 2}, {9, 4}, {10, 3}, {10, 5}, {10, 6}, {10, 3}}) {
                this.func_175811_a(world, biomeGrassState, offset_xy[0], 0, offset_xy[1], structureBB);
            }
            this.func_175811_a(world, biomeDirtState, 2, 0, 3, structureBB);
            if (GeneralConfig.useVillageColors) {
                IBlockState concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175811_a(world, concreteBlockstate, 2, 1, 3, structureBB);
            } else {
                this.func_175811_a(world, biomePlankState, 2, 1, 3, structureBB);
            }
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(6), 1, 1, 3, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(7), 3, 1, 3, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(5), 2, 1, 2, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(4), 2, 1, 4, structureBB);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signXBB = 2;
                int signYBB = 2;
                int signZBB = 3;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 5;
                int bannerZBB = 4;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175811_a(world, biomeGrassState, bannerXBB, bannerYBB - 1, bannerZBB, structureBB);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 2, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, true);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{2, 1, 5, -1, 0}, {4, 1, 2, -1, 0}, {9, 1, 4, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }
}

