/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.biomestructures;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.chestloot.ChestGenHooks;
import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SwampStructures {
    public static ArrayList<BlueprintData> getRandomSwampDecorBlueprint(FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        int decorCount = 7;
        return SwampStructures.getSwampDecorBlueprint(random.nextInt(decorCount), materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static ArrayList<BlueprintData> getSwampDecorBlueprint(int decorType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        IBlockState biomeStrippedLogHorizAlongState;
        IBlockState biomeStrippedLogHorizAcrossState;
        IBlockState biomeGrassState;
        ArrayList<BlueprintData> blueprint = new ArrayList<BlueprintData>();
        IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), materialType, biome, disallowModSubs);
        if (biome != null && biome.field_76752_A != null) {
            biomeTopState = biome.field_76752_A;
        }
        IBlockState biomeFillerState = biomeDirtState;
        if (biome != null && biome.field_76753_B != null) {
            biomeFillerState = biome.field_76753_B;
        }
        IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
        IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
        IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), materialType, biome, disallowModSubs);
        IBlockState biomeStrippedLogVertState = biomeLogVertState;
        if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
            if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
            } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
            }
        }
        if ((biomeStrippedLogHorizAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, coordBaseMode.func_176736_b(), true)).func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
            if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
            } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
            }
        }
        if ((biomeStrippedLogHorizAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, coordBaseMode.func_176736_b(), false)).func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
            if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
            } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
            }
        }
        boolean genericBoolean = false;
        boolean genericInt = false;
        int postheight = 2;
        block0 : switch (decorType) {
            case 0: 
            case 1: {
                ++postheight;
            }
            case 2: 
            case 3: {
                ++postheight;
            }
            case 4: 
            case 5: {
                ++postheight;
                int lanternheight = 2 + (random.nextBoolean() ? 1 : 0);
                BlueprintData.addFillWithBlocks(blueprint, 0, lanternheight, -1, 0, lanternheight + 1, 0, biomeFenceState);
                BlueprintData.addPlaceBlock(blueprint, 0, lanternheight, -1, biomeHangingLanternState);
                if (random.nextBoolean()) {
                    int lantern2height = 2 + (random.nextBoolean() ? 1 : 0);
                    switch (random.nextInt(5)) {
                        case 0: 
                        case 1: {
                            BlueprintData.addFillWithBlocks(blueprint, 0, lantern2height, 0, 1, lantern2height + 1, 0, biomeFenceState);
                            BlueprintData.addPlaceBlock(blueprint, 1, lantern2height, 0, biomeHangingLanternState);
                            break;
                        }
                        case 2: 
                        case 3: {
                            BlueprintData.addFillWithBlocks(blueprint, -1, lantern2height, 0, 0, lantern2height + 1, 0, biomeFenceState);
                            BlueprintData.addPlaceBlock(blueprint, -1, lantern2height, 0, biomeHangingLanternState);
                            break;
                        }
                        case 4: {
                            BlueprintData.addFillWithBlocks(blueprint, 0, lantern2height, 0, 0, lantern2height + 1, 1, biomeFenceState);
                            BlueprintData.addPlaceBlock(blueprint, 0, lantern2height, 1, biomeHangingLanternState);
                        }
                    }
                }
                BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 0, postheight - 1, 0, biomeStrippedLogVertState);
                break;
            }
            case 6: {
                BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, biomeFillerState);
                switch (random.nextInt(4)) {
                    case 0: {
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, biomeFillerState);
                        BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 1, 0, 0, biomeStrippedLogHorizAcrossState);
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, biomeFenceState);
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, 1, biomeTopState);
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, 1, biomeSittingLanternState);
                        break block0;
                    }
                    case 1: {
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, biomeFillerState);
                        BlueprintData.addFillWithBlocks(blueprint, 0, 0, -1, 0, 0, 0, biomeStrippedLogHorizAlongState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, biomeFenceState);
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, 1, biomeTopState);
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, 1, biomeSittingLanternState);
                        break block0;
                    }
                    case 2: {
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, biomeFillerState);
                        BlueprintData.addFillWithBlocks(blueprint, -1, 0, 0, 0, 0, 0, biomeStrippedLogHorizAcrossState);
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, biomeFenceState);
                        BlueprintData.addFillBelowTo(blueprint, 1, -1, -1, biomeTopState);
                        BlueprintData.addPlaceBlock(blueprint, 1, 0, -1, biomeSittingLanternState);
                        break block0;
                    }
                    case 3: {
                        BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, biomeFillerState);
                        BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 0, 0, 1, biomeStrippedLogHorizAlongState);
                        BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, biomeFenceState);
                        BlueprintData.addFillBelowTo(blueprint, -1, -1, -1, biomeTopState);
                        BlueprintData.addPlaceBlock(blueprint, -1, 0, -1, biomeSittingLanternState);
                    }
                }
            }
        }
        return blueprint;
    }

    public static class SwampRoadAccent
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"   ", "PPP", "PPP", "PPP", "   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int W_OFFSET = -4;
        public static final byte MEDIAN_BORDERS = 5;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampRoadAccent() {
        }

        public SwampRoadAccent(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            this.field_74887_e.func_78886_a(this.func_186165_e() == EnumFacing.WEST ? 4 : (this.func_186165_e() == EnumFacing.EAST ? -4 : 0), 0, this.func_186165_e() == EnumFacing.SOUTH ? -4 : (this.func_186165_e() == EnumFacing.NORTH ? 4 : 0));
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampRoadAccent buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)(STRUCTURE_DEPTH + -4), (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)(-4 - STRUCTURE_DEPTH - -4), (int)STRUCTURE_WIDTH, (int)21, (int)-4, (EnumFacing)coordBaseMode);
            return SwampRoadAccent.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new SwampRoadAccent(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)5, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 1, 3, 4}, {1, 4, 2, 1, 4, 2}, {1, 1, 0, 1, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvw : new int[][]{{1, 0, 4}, {1, 0, 0}}) {
                this.func_175808_b(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{1, 3, 2}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 3, 1, 4, 3}, {1, 4, 1, 1, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 4, 1, 4, 4}, {1, 4, 0, 1, 4, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampStreetDecor
    extends StructureVillageVN.VNComponent {
        public static final int STRUCTURE_WIDTH = 3;
        public static final int STRUCTURE_DEPTH = 3;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampStreetDecor() {
        }

        public SwampStreetDecor(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampStreetDecor buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)5, (int)3, (EnumFacing)coordBaseMode);
            return SwampStreetDecor.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampStreetDecor(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorDepth;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                uvw[2] = decorDepth = ((Integer)FunctionsVN.weightedRandom(new int[]{-1, 0, 1}, new double[]{1.0, 9.0, 5.0}, randomFromXYZ)).intValue();
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (decorDepth < 0) {
                    int nonairSurrounding = 0;
                    int decorY = this.func_74862_a(decorHeightY);
                    for (int i = 0; i < 8; ++i) {
                        int z;
                        int[][] surroundpos = new int[][]{{0, 0}, {0, 1}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {1, 0}};
                        int u = surroundpos[i][0];
                        int w = surroundpos[i][0];
                        int x = this.func_74865_a(u, w);
                        BlockPos pos = new BlockPos(x, decorY, z = this.func_74873_b(u, w));
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || ++nonairSurrounding < 4) continue;
                        ++decorHeightY;
                        break;
                    }
                }
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && decorDepth >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampWildFarm
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"      FF       ", "     FFFFFF    ", "   FFFFFFFFF   ", "  FFFFFFFFFFFF ", " FFFFFFFFFFFFFF", "FFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFF", " FFFFFFFFFFFFF ", "  FFFFFFFFFFFF ", "  FFFFFFFFFFFF ", "   FFFFFFFFFF  ", "   FFFFFFFFFF  ", "    FFFFFFFFF  ", "     FFFFF     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 2;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampWildFarm() {
        }

        public SwampWildFarm(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampWildFarm buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampWildFarm.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampWildFarm(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 1, 7, 0, 1, 8}, {1, 1, 6, 1, 1, 6}, {1, 1, 9, 1, 1, 9}, {2, 1, 4, 2, 1, 4}, {2, 1, 10, 2, 1, 10}, {3, 1, 2, 3, 1, 3}, {3, 1, 10, 3, 1, 11}, {4, 1, 1, 4, 1, 2}, {5, 1, 0, 5, 1, 1}, {5, 1, 12, 5, 1, 12}, {6, 1, 0, 6, 1, 0}, {6, 1, 13, 7, 1, 13}, {8, 1, 12, 10, 1, 12}, {10, 1, 11, 11, 1, 11}, {12, 1, 10, 13, 1, 10}, {13, 1, 9, 14, 1, 9}, {13, 1, 4, 13, 1, 6}, {14, 1, 7, 14, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 7, 2, 1, 8}, {2, 1, 9, 2, 1, 9}, {3, 1, 8, 4, 1, 9}, {4, 1, 10, 4, 1, 10}, {5, 1, 9, 6, 1, 11}, {6, 1, 12, 6, 1, 12}, {7, 1, 9, 7, 1, 9}, {7, 1, 11, 7, 1, 12}, {3, 1, 4, 3, 1, 4}, {4, 1, 3, 4, 1, 4}, {5, 1, 2, 5, 1, 5}, {6, 1, 1, 6, 1, 6}, {7, 1, 5, 7, 1, 5}, {7, 1, 1, 8, 1, 2}, {8, 1, 4, 8, 1, 5}, {8, 1, 8, 8, 1, 8}, {9, 1, 2, 9, 1, 8}, {10, 1, 2, 10, 1, 3}, {10, 1, 5, 10, 1, 6}, {11, 1, 2, 11, 1, 5}, {12, 1, 5, 12, 1, 5}, {10, 1, 10, 10, 1, 10}, {11, 1, 8, 11, 1, 10}, {12, 1, 7, 12, 1, 9}, {13, 1, 7, 13, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            Block[] cropPair1 = StructureVillageVN.chooseCropPair(random);
            Block[] cropPair2 = StructureVillageVN.chooseCropPair(random);
            for (int[] uvwfcp : new int[][]{{2, 1, 5, 7, 0, random.nextInt(6)}, {2, 1, 6, 7, 0, random.nextInt(6)}, {3, 1, 5, 7, 0, random.nextInt(6)}, {3, 1, 6, 7, 0, random.nextInt(6)}, {3, 1, 7, 7, 0, random.nextInt(6)}, {4, 1, 5, 7, 0, random.nextInt(6)}, {4, 1, 6, 7, 0, random.nextInt(6)}, {4, 1, 7, 7, 0, random.nextInt(6)}, {5, 1, 6, 7, 0, random.nextInt(6)}, {5, 1, 7, 7, 0, random.nextInt(6)}, {5, 1, 8, 7, 0, random.nextInt(6)}, {6, 1, 7, 7, 0, random.nextInt(6)}, {6, 1, 8, 7, 0, random.nextInt(6)}, {7, 1, 6, 7, 0, random.nextInt(6)}, {7, 1, 7, 7, 0, random.nextInt(6)}, {7, 1, 8, 7, 0, random.nextInt(6)}, {8, 1, 6, 7, 0, random.nextInt(6)}, {8, 1, 7, 7, 0, random.nextInt(6)}, {7, 1, 3, 7, 1, random.nextInt(6)}, {7, 1, 4, 7, 1, random.nextInt(6)}, {8, 1, 3, 7, 1, random.nextInt(6)}, {4, 1, 11, 7, 1, random.nextInt(6)}, {7, 1, 10, 7, 2, random.nextInt(6)}, {8, 1, 9, 7, 2, random.nextInt(6)}, {8, 1, 10, 7, 2, random.nextInt(6)}, {8, 1, 11, 7, 2, random.nextInt(6)}, {9, 1, 9, 7, 2, random.nextInt(6)}, {9, 1, 10, 7, 2, random.nextInt(6)}, {9, 1, 11, 7, 2, random.nextInt(6)}, {10, 1, 7, 7, 2, random.nextInt(6)}, {10, 1, 8, 7, 2, random.nextInt(6)}, {10, 1, 9, 7, 2, random.nextInt(6)}, {11, 1, 6, 7, 2, random.nextInt(6)}, {11, 1, 7, 7, 2, random.nextInt(6)}, {12, 1, 6, 7, 2, random.nextInt(6)}, {7, 1, 0, 7, 3, random.nextInt(6)}, {8, 1, 0, 7, 3, random.nextInt(6)}, {9, 1, 0, 7, 3, random.nextInt(6)}, {9, 1, 1, 7, 3, random.nextInt(6)}, {10, 1, 1, 7, 3, random.nextInt(6)}, {11, 1, 1, 7, 3, random.nextInt(6)}, {12, 1, 1, 7, 3, random.nextInt(6)}, {12, 1, 2, 7, 3, random.nextInt(6)}, {12, 1, 3, 7, 3, random.nextInt(6)}, {12, 1, 4, 7, 3, random.nextInt(6)}}) {
                IBlockState cropState;
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwfcp[3]), uvwfcp[0], uvwfcp[1], uvwfcp[2], structureBB);
                int cropProgressMeta = uvwfcp[5];
                while (true) {
                    try {
                        cropState = (uvwfcp[4] / 2 == 0 ? cropPair1 : cropPair2)[uvwfcp[4] % 2].func_176203_a(cropProgressMeta);
                    }
                    catch (IllegalArgumentException e) {
                        if (cropProgressMeta == 0) {
                            cropState = Blocks.field_150464_aj.func_176203_a(uvwfcp[5]);
                            break;
                        }
                        cropProgressMeta /= 2;
                        continue;
                    }
                    break;
                }
                this.func_175811_a(world, cropState, uvwfcp[0], uvwfcp[1] + 1, uvwfcp[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 2, 9}, {3, 2, 8}, {5, 2, 3}, {6, 2, 2}, {6, 2, 5}, {6, 2, 11}, {9, 2, 3}, {9, 2, 7}, {11, 2, 4}, {12, 2, 9}, {13, 2, 7}}) {
                this.func_175811_a(world, Blocks.field_150392_bi.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeGravelState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 0, 0, 8, 0, 0}, {6, 0, 3, 6, 0, 4}, {7, 0, 2, 7, 0, 3}, {10, 0, 2, 10, 0, 3}, {11, 0, 2, 11, 0, 2}, {0, 0, 8, 2, 0, 8}, {1, 0, 9, 3, 0, 9}, {8, 0, 7, 9, 0, 8}, {10, 0, 8, 10, 0, 8}, {7, 0, 11, 8, 0, 11}, {7, 0, 12, 7, 0, 12}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGravelState, biomeGravelState, false);
            }
            IBlockState biomeClayState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150435_aG.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 0, 1, 6, 0, 1}, {6, 0, 2, 7, 0, 2}, {7, 0, 3, 7, 0, 3}, {2, 0, 4, 2, 0, 4}, {3, 0, 3, 4, 0, 4}, {5, 0, 4, 5, 0, 5}, {9, 0, 6, 10, 0, 6}, {10, 0, 7, 11, 0, 7}, {11, 0, 8, 11, 0, 8}, {11, 0, 9, 13, 0, 9}, {4, 0, 9, 4, 0, 9}, {3, 0, 10, 6, 0, 10}, {3, 0, 11, 4, 0, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeClayState, biomeClayState, false);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            for (int[] uvw : new int[][]{{10, 2, 4}}) {
                IBlockState cropState;
                if (compostBinState != null) {
                    this.func_175811_a(world, compostBinState, uvw[0], uvw[1], uvw[2], structureBB);
                    this.func_175811_a(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1] - 1, uvw[2], structureBB);
                int cropProgressMeta = random.nextInt(6);
                while (true) {
                    try {
                        cropState = cropPair1[1].func_176203_a(cropProgressMeta);
                    }
                    catch (IllegalArgumentException e) {
                        if (cropProgressMeta == 0) {
                            cropState = Blocks.field_150464_aj.func_176203_a(cropProgressMeta);
                            break;
                        }
                        cropProgressMeta /= 2;
                        continue;
                    }
                    break;
                }
                this.func_175811_a(world, cropState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 2, 12, 5, 3, 12}, {6, 2, 13, 6, 4, 13}, {7, 2, 13, 7, 2, 13}, {8, 2, 12, 8, 3, 12}, {10, 2, 11, 10, 2, 11}, {14, 2, 8, 14, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150436_aH.func_176223_P(), Blocks.field_150436_aH.func_176223_P(), false);
            }
            for (int[] uvwg : new int[][]{{0, 2, 7, 2}, {1, 2, 6, 2}, {2, 2, 10, 0}, {3, 2, 10, 0}, {4, 2, 2, 0}, {5, 2, 1, 1}, {12, 2, 10, 0}, {13, 2, 5, 1}, {13, 2, 9, 0}, {13, 2, 10, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int[][] farmerPositions = new int[][]{{2, 1, 5}, {3, 1, 5}, {4, 1, 5}, {5, 1, 6}, {6, 1, 7}, {7, 1, 6}, {8, 1, 6}, {7, 1, 3}, {8, 1, 3}, {4, 1, 11}, {7, 1, 10}, {8, 1, 9}, {9, 1, 9}, {10, 1, 7}, {11, 1, 6}, {12, 1, 6}, {7, 1, 0}, {8, 1, 0}, {9, 1, 0}, {10, 1, 1}, {11, 1, 1}, {12, 1, 1}, {0, 1, 7}, {0, 1, 8}, {1, 1, 6}, {1, 1, 9}, {2, 1, 4}, {2, 1, 10}, {3, 1, 2}, {3, 1, 3}, {3, 1, 10}, {3, 1, 11}, {4, 1, 1}, {4, 1, 2}, {5, 1, 0}, {5, 1, 1}, {5, 1, 12}, {6, 1, 0}, {6, 1, 13}, {7, 1, 13}, {8, 1, 12}, {10, 1, 12}, {10, 1, 11}, {11, 1, 11}, {12, 1, 10}, {13, 1, 10}, {13, 1, 9}, {14, 1, 9}, {13, 1, 4}, {13, 1, 6}, {14, 1, 7}, {14, 1, 8}};
                int[] farmerPosition = farmerPositions[random.nextInt(farmerPositions.length)];
                int u = farmerPosition[0];
                int v = farmerPosition[1] + 1;
                int w = farmerPosition[2];
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampWeaponSmithy
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" F    F ", "  FFFF  ", "  FFFF  ", " FFFFFF ", "FFFFFFFF", " FFFFFF ", "  FFFF  ", "   PP   ", "  FPPF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 2;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampWeaponSmithy() {
        }

        public SwampWeaponSmithy(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampWeaponSmithy buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampWeaponSmithy.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampWeaponSmithy(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 4, 0, 2, 4}, {1, 2, 8, 1, 2, 8}, {7, 2, 4, 7, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeMossyCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 2, 8, 6, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneWallState, biomeMossyCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{0, 3, 4, -1}, {1, 3, 8, -1}, {6, 3, 8, -1}, {7, 3, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 4, 0, 1, 4}, {1, 1, 3, 1, 4, 3}, {1, 1, 4, 1, 3, 4}, {1, 1, 5, 1, 4, 5}, {2, 1, 2, 2, 4, 2}, {2, 5, 4, 2, 5, 5}, {2, 4, 5, 2, 4, 5}, {2, 1, 6, 2, 7, 6}, {2, 1, 7, 2, 3, 7}, {3, 1, 7, 4, 7, 7}, {3, 5, 5, 4, 7, 5}, {5, 1, 2, 5, 4, 2}, {5, 5, 4, 5, 5, 5}, {5, 4, 5, 5, 4, 5}, {5, 1, 6, 5, 7, 6}, {5, 1, 7, 5, 3, 7}, {6, 1, 3, 6, 4, 3}, {6, 1, 4, 6, 3, 4}, {6, 1, 5, 6, 4, 5}, {7, 1, 4, 7, 1, 4}, {3, 4, 2, 4, 4, 2}, {2, 1, 5, 5, 1, 5}, {2, 0, 5, 5, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 8, 1, 1, 8}, {6, 1, 8, 6, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{1, 5, 5, 0}, {1, 5, 4, 0}, {1, 5, 3, 3}, {2, 5, 3, 0}, {2, 5, 2, 3}, {3, 5, 2, 3}, {4, 5, 2, 3}, {5, 5, 2, 3}, {5, 5, 3, 1}, {6, 5, 5, 1}, {6, 5, 4, 1}, {6, 5, 3, 3}, {3, 4, 5, 7}, {4, 4, 5, 7}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 4, 1, 4, 4}, {6, 4, 4, 6, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            for (int[] uvwoc : new int[][]{{3, 5, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 5, 4, 3, GeneralConfig.useVillageColors ? this.townColor : 15}, {4, 5, 3, 1, GeneralConfig.useVillageColors ? this.townColor : 15}, {4, 5, 4, 0, GeneralConfig.useVillageColors ? this.townColor : 15}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomeGravelState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 5, 1, 4}, {3, 1, 2, 4, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGravelState, biomeGravelState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 0, 2, 3, 0}, {5, 2, 0, 5, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{2, 4, 0, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {3, 4, 0, GeneralConfig.useVillageColors ? this.townColor : 15}, {4, 4, 0, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {5, 4, 0, GeneralConfig.useVillageColors ? this.townColor : 15}, {2, 4, 1, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 4, 1, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {4, 4, 1, GeneralConfig.useVillageColors ? this.townColor : 15}, {5, 4, 1, GeneralConfig.useVillageColors ? this.townColor3 : 10}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(uvwo[3]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoh : new int[][]{{2, 2, 5, 1, 1}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwoh[3], this.func_186165_e(), uvwoh[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwoh[0], uvwoh[1], uvwoh[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 3, 5, 2}, {5, 2, 5, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uuvvww : new int[][]{{3, 7, 6, 4, 7, 6}, {3, 2, 6, 4, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{3, 1, 6}, {4, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150353_l.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 2;
            int chestV = 2;
            int chestW = 3;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof TileEntityChest) {
                ((TileEntityChest)te).func_189404_a(LootTableList.field_186423_e, random.nextLong());
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(9);
                int u = s <= 0 ? 2 : (s <= 3 ? 3 : (s <= 6 ? 4 : 5));
                int v = 2;
                int w = s <= 0 ? 4 : (s <= 6 ? 3 + (s - 1) % 3 : s - 4);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SwampToolSmithy
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"          ", "          ", "          ", "          ", "FFFF      ", "FFF       ", "FFF       ", "FFF       ", "FFF       "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 6;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampToolSmithy() {
        }

        public SwampToolSmithy(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampToolSmithy buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampToolSmithy.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampToolSmithy(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            Block polishedAndesiteStairsBlock;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{6, 0, 6, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 6, 0, 6})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwss : new int[][]{{1, 1, 1, -1, 1}}) {
                Block block = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2]))).func_177230_c();
                Block saplingblock = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2]))).func_177230_c();
                if (block == null || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])))) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    Block dirtblock1 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))).func_177230_c();
                    Block dirtblock2 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))).func_177230_c();
                    Block dirtblock3 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]))).func_177230_c();
                    if (!world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4])))) continue;
                    this.func_175811_a(world, Blocks.field_150349_c.func_176223_P(), uvwss[0] + uvwss[3], uvwss[1] - 1, uvwss[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150349_c.func_176223_P(), uvwss[0], uvwss[1] - 1, uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, Blocks.field_150349_c.func_176223_P(), uvwss[0] + uvwss[3], uvwss[1] - 1, uvwss[2] + uvwss[4], structureBB);
                }
                this.func_175811_a(world, Blocks.field_150349_c.func_176223_P(), uvwss[0], uvwss[1] - 1, uvwss[2], structureBB);
                this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2], structureBB);
                if (!(biomeSaplingState.func_177230_c() instanceof BlockSapling)) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                }
                ((BlockSapling)biomeSaplingState.func_177230_c()).func_176476_e(world, new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])), biomeSaplingState, world.field_73012_v);
            }
            for (int[] uuvvww : new int[][]{{3, 2, 4, 3, 3, 4}, {3, 2, 3, 3, 3, 3}, {3, 3, 1, 4, 4, 2}, {2, 1, -1, 2, 2, 4}, {3, 1, -1, 3, 2, -1}}) {
                this.func_74878_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5]);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{0, 0, 0, 0, 0, 4}, {1, 0, 0, 1, 0, 0}, {1, 0, 2, 1, 0, 4}, {2, 0, 0, 2, 0, 4}, {3, 0, 4, 3, 0, 4}, {3, 4, 4, 3, 5, 8}, {3, 5, 3, 3, 5, 3}, {9, 4, 3, 9, 5, 8}, {4, 4, 3, 4, 6, 3}, {5, 4, 3, 5, 7, 3}, {6, 6, 3, 6, 8, 3}, {7, 4, 3, 7, 7, 3}, {8, 4, 3, 8, 6, 3}, {4, 4, 8, 4, 6, 8}, {5, 6, 8, 5, 7, 8}, {6, 7, 8, 6, 8, 8}, {7, 6, 8, 7, 7, 8}, {8, 4, 8, 8, 6, 8}, {5, 4, 8, 7, 4, 8}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 2, 3, 4, 2, 7}, {8, 2, 3, 8, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState iBlockState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeStrippedLogHorizAcrossState = iBlockState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 2, 0, 9, 2, 0}, {5, 2, 3, 7, 2, 3}, {3, 2, 8, 9, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 3, 2, 0}, {6, 3, 2, 3}, {7, 3, 2, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 4, 3, 1, 4}, {3, 2, 2, 3, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 3, 3, 1, 3}, {3, 2, 1, 9, 2, 1}, {4, 2, 2, 9, 2, 2}, {3, 4, 3, 3, 4, 3}, {3, 2, 5, 9, 2, 7}, {5, 2, 4, 7, 2, 7}, {9, 2, 3, 9, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 8, 3, 1, 8}, {5, 1, 8, 5, 1, 8}, {7, 1, 8, 7, 1, 8}, {9, 1, 8, 9, 1, 8}, {4, 1, 3, 4, 1, 3}, {8, 1, 3, 8, 1, 3}, {3, 1, 0, 3, 1, 0}, {5, 1, 0, 5, 1, 0}, {7, 1, 0, 7, 1, 0}, {9, 1, 0, 9, 1, 0}, {3, 3, 0, 3, 5, 0}, {5, 3, 0, 5, 7, 0}, {7, 3, 0, 7, 7, 0}, {9, 3, 0, 9, 5, 0}, {4, 5, 0, 4, 6, 0}, {6, 5, 0, 6, 8, 0}, {8, 5, 0, 8, 6, 0}, {6, 7, 1, 6, 7, 2}, {6, 6, 8, 6, 6, 8}, {5, 5, 8, 7, 5, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvw : new int[][]{{3, 0, 8}, {5, 0, 8}, {7, 0, 8}, {9, 0, 8}, {4, 0, 3}, {8, 0, 3}, {3, 0, 0}, {5, 0, 0}, {7, 0, 0}, {9, 0, 0}}) {
                this.func_175808_b(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState concreteBlockState = Blocks.field_192443_dR.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15);
            for (int[] uuvvww : new int[][]{{3, 3, 5, 3, 3, 8}, {4, 3, 3, 9, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], concreteBlockState, concreteBlockState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{4, 7, 8, 0}, {5, 8, 8, 0}, {7, 8, 8, 1}, {9, 6, 8, 1}, {3, 6, 7, 0}, {9, 6, 7, 1}, {3, 6, 6, 0}, {5, 8, 6, 0}, {7, 8, 6, 1}, {8, 7, 6, 1}, {9, 6, 6, 1}, {4, 7, 5, 0}, {5, 8, 5, 0}, {7, 8, 5, 1}, {8, 7, 5, 1}, {9, 6, 5, 1}, {4, 7, 4, 0}, {5, 8, 4, 0}, {7, 8, 4, 1}, {8, 7, 4, 1}, {9, 6, 4, 1}, {3, 6, 3, 0}, {4, 7, 3, 0}, {5, 8, 3, 0}, {7, 8, 3, 1}, {8, 7, 3, 1}, {9, 6, 3, 1}, {3, 6, 2, 0}, {4, 7, 2, 0}, {5, 8, 2, 0}, {8, 7, 2, 1}, {9, 6, 2, 1}, {3, 6, 1, 0}, {5, 8, 1, 0}, {9, 6, 1, 1}, {5, 8, 0, 0}, {7, 8, 0, 1}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeMossyCobblestoneStairsBlock = ModObjects.chooseModMossyCobblestoneStairsBlock();
            if (biomeMossyCobblestoneStairsBlock == null) {
                biomeMossyCobblestoneStairsBlock = Blocks.field_150446_ar;
            }
            biomeMossyCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 6, 8, 0}, {8, 7, 8, 1}, {4, 7, 7, 0}, {5, 8, 7, 0}, {7, 8, 7, 1}, {8, 7, 7, 1}, {4, 7, 6, 0}, {3, 6, 5, 0}, {3, 6, 4, 0}, {7, 8, 2, 1}, {4, 7, 1, 0}, {7, 8, 1, 1}, {8, 7, 1, 1}, {3, 6, 0, 0}, {4, 7, 0, 0}, {8, 7, 0, 1}, {9, 6, 0, 1}}) {
                this.func_175811_a(world, biomeMossyCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 9, 1, 6, 9, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{6, 9, 0, 6, 9, 0}, {6, 9, 4, 6, 9, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 4, 3, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{4, 4, 7, 1}}) {
                this.func_175811_a(world, ModObjects.chooseModSmithingTable(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 6, 4, 4, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{6, 6, 1}, {4, 6, 7}, {8, 6, 5}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState polishedAndesiteSlabUpperState = ModObjects.chooseModPolishedAndesiteSlabState(true);
            if (polishedAndesiteSlabUpperState == null) {
                polishedAndesiteSlabUpperState = ModObjects.chooseModAndesiteBrickSlabState(true);
            }
            if ((polishedAndesiteStairsBlock = ModObjects.chooseModPolishedAndesiteStairsBlock()) == null) {
                polishedAndesiteStairsBlock = ModObjects.chooseModAndesiteBrickStairsBlock();
            }
            if (polishedAndesiteSlabUpperState == null || polishedAndesiteStairsBlock == null) {
                polishedAndesiteSlabUpperState = ModObjects.chooseModAndesiteSlabState(true);
                polishedAndesiteStairsBlock = ModObjects.chooseModAndesiteStairsBlock();
                if (polishedAndesiteSlabUpperState == null || polishedAndesiteStairsBlock == null) {
                    polishedAndesiteSlabUpperState = Blocks.field_150333_U.func_176203_a(13);
                    polishedAndesiteStairsBlock = Blocks.field_150390_bg;
                }
            }
            for (int[] uvw : new int[][]{{4, 4, 5}}) {
                this.func_175811_a(world, polishedAndesiteSlabUpperState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 4, 4, 6}, {4, 4, 6, 7}}) {
                this.func_175811_a(world, polishedAndesiteStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePolishedAndesiteState = Blocks.field_150348_b.func_176203_a(6);
            biomePolishedAndesiteState = StructureVillageVN.getBiomeSpecificBlockState(biomePolishedAndesiteState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{7, 4, 5}, {8, 4, 5}}) {
                this.func_175811_a(world, biomePolishedAndesiteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 8;
            int chestV = 4;
            int chestW = 7;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof TileEntityChest) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_toolsmith");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uuvvww : (ChestGenHooks)new int[][]{{1, 0, 1, 1, 0, 1}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeTopState, biomeTopState, false);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (Object uvwo : (ChestGenHooks)new int[][]{{2, 5, 5, 3}, {2, 4, 5, 3}, {2, 3, 5, 3}, {2, 2, 5, 3}, {2, 5, 8, 3}, {2, 4, 8, 3}, {2, 3, 8, 3}, {2, 2, 8, 3}, {2, 1, 8, 3}, {3, 5, 9, 0}, {3, 4, 9, 0}, {8, 6, 9, 0}, {8, 5, 9, 0}, {8, 4, 9, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a((int)uvwo[0], (int)uvwo[2]), this.func_74862_a((int)uvwo[1]), this.func_74873_b((int)uvwo[0], (int)uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(13);
                int u = s <= 3 ? s + 5 : (s <= 5 ? s + 1 : (s <= 9 ? s - 1 : s - 5));
                int v = 4;
                int w = s <= 3 ? 4 : (s <= 5 ? 5 : (s <= 9 ? 6 : 7));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SwampTemple
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFFFFFFFF", " FPPPPPPPFF", " FFFFFFFPFF", " FFFFFFFPFF", " FFFFFFFPFF", " FFFFFFFPFF", " FFFFFFFPFF", " FFFFFFFFFF", " FFFFFFFFFF", " FFFFFFFFFF", " FFFFFFFFFF", " FFPPFF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 4;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampTemple() {
        }

        public SwampTemple(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampTemple buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampTemple.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampTemple(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 1, 8, 1, 1, 8}, {1, 4, 8, 1, 4, 8}, {1, 1, 7, 1, 4, 7}, {1, 1, 6, 1, 1, 6}, {1, 4, 6, 1, 4, 6}, {1, 1, 5, 1, 4, 5}, {1, 1, 4, 1, 1, 4}, {1, 4, 4, 1, 4, 4}, {1, 1, 3, 1, 4, 3}, {1, 4, 2, 1, 4, 2}, {6, 1, 8, 6, 1, 8}, {6, 4, 8, 6, 4, 8}, {6, 1, 7, 6, 4, 7}, {6, 1, 6, 6, 1, 6}, {6, 4, 6, 6, 4, 6}, {6, 1, 5, 6, 3, 5}, {6, 1, 4, 6, 1, 4}, {6, 4, 4, 6, 4, 4}, {6, 1, 3, 6, 3, 3}, {6, 1, 2, 6, 1, 2}, {1, 2, 1, 1, 5, 1}, {2, 4, 1, 2, 5, 1}, {3, 7, 1, 4, 8, 1}, {5, 4, 1, 5, 6, 1}, {6, 2, 1, 6, 4, 1}, {3, 1, 9, 3, 6, 9}, {4, 3, 9, 4, 6, 9}, {5, 1, 9, 5, 5, 9}, {6, 1, 9, 6, 1, 9}, {2, 0, 1, 6, 0, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 1, 2}, {6, 4, 2, 6, 4, 3}, {6, 4, 5, 6, 4, 5}, {1, 1, 1, 1, 1, 1}, {2, 6, 1, 2, 6, 1}, {3, 4, 1, 4, 4, 1}, {6, 1, 1, 6, 1, 1}, {6, 5, 1, 6, 5, 1}, {1, 1, 9, 1, 4, 9}, {2, 1, 9, 2, 5, 9}, {6, 2, 9, 6, 4, 9}, {1, 0, 1, 1, 0, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{7, 0, 2, 9, 0, 4}, {7, 0, 5, 7, 0, 9}, {9, 0, 5, 9, 0, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 9, 1, 0}, {4, 9, 1, 1}, {5, 7, 1, 1}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 3, 2}, {2, 1, 5, 2}, {5, 1, 3, 2}, {5, 1, 5, 2}, {2, 6, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {2, 6, 5, 0}, {2, 6, 6, 0}, {2, 6, 7, 0}, {2, 6, 8, 0}, {2, 6, 9, 0}, {3, 7, 2, 0}, {3, 7, 3, 0}, {3, 7, 4, 0}, {3, 7, 5, 0}, {3, 7, 6, 0}, {3, 7, 7, 0}, {3, 7, 8, 0}, {3, 7, 9, 0}, {4, 7, 2, 1}, {4, 7, 3, 1}, {4, 7, 4, 1}, {4, 7, 5, 1}, {4, 7, 6, 1}, {4, 7, 7, 1}, {4, 7, 8, 1}, {4, 7, 9, 1}, {5, 6, 2, 1}, {5, 6, 3, 1}, {5, 6, 4, 1}, {5, 6, 5, 1}, {5, 6, 6, 1}, {5, 6, 7, 1}, {5, 6, 8, 1}, {5, 6, 9, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 2, 1, 5, 9}, {6, 5, 2, 6, 5, 9}, {3, 1, 8, 3, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 5, 2, 0, 5, 9}, {7, 5, 2, 7, 5, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            Block biomeMossyCobblestoneStairsBlock = ModObjects.chooseModMossyCobblestoneStairsBlock();
            if (biomeMossyCobblestoneStairsBlock == null) {
                biomeMossyCobblestoneStairsBlock = Blocks.field_150446_ar;
            }
            biomeMossyCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{2, 7, 1, 0}, {2, 3, 0, 3}, {3, 3, 0, 3}, {4, 3, 0, 3}, {5, 3, 0, 3}}) {
                this.func_175811_a(world, biomeMossyCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 2, 1}, {5, 1, 1, 5, 2, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 3, 1, 5, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{8, 1, 1, 9, 1, 1}, {10, 1, 4, 10, 1, 10}, {2, 1, 11, 7, 1, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeMossyCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 1, 1, 7, 1, 1}, {10, 1, 1, 10, 1, 3}, {8, 1, 11, 10, 1, 11}, {1, 1, 10, 1, 1, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneWallState, biomeMossyCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{2, 4, 3, 1}, {2, 4, 7, 1}, {5, 4, 3, 3}, {5, 4, 7, 3}, {10, 2, 1, -1}, {10, 2, 11, -1}, {1, 2, 11, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 3, 4, 1, 7, GeneralConfig.useVillageColors ? this.townColor3 : 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvwc : new int[][]{{3, 6, 1, GeneralConfig.useVillageColors ? this.townColor : 15}, {4, 5, 1, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 5, 1, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {4, 6, 1, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {1, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {1, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 15}, {1, 3, 6, GeneralConfig.useVillageColors ? this.townColor : 15}, {1, 3, 8, GeneralConfig.useVillageColors ? this.townColor : 15}, {1, 2, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {1, 2, 4, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {1, 2, 6, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {1, 2, 8, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {6, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {6, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 15}, {6, 3, 6, GeneralConfig.useVillageColors ? this.townColor : 15}, {6, 3, 8, GeneralConfig.useVillageColors ? this.townColor : 15}, {6, 2, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {6, 2, 4, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {6, 2, 6, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {6, 2, 8, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                this.func_175811_a(world, Blocks.field_150397_co.func_176203_a(uvwc[3]), uvwc[0], uvwc[1], uvwc[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}, {4, 1, 1, 0, 1, 1}, {4, 1, 9, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 2, 8}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176203_a(4), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 1, 2, 7, 1, 9}, {8, 1, 2, 8, 1, 2}, {9, 1, 2, 9, 1, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            for (int[] uvw : new int[][]{{8, 1, 4}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 5, 1, 3}, {0, 4, 1, 3}, {0, 3, 1, 3}, {0, 2, 1, 3}, {0, 4, 3, 3}, {0, 3, 3, 3}, {0, 2, 3, 3}, {0, 1, 3, 3}, {0, 0, 3, 3}, {0, 4, 9, 3}, {7, 4, 3, 1}, {7, 3, 3, 1}, {1, 4, 10, 0}, {1, 3, 10, 0}, {1, 5, 10, 0}, {1, 4, 10, 0}, {1, 3, 10, 0}, {1, 2, 10, 0}, {1, 1, 10, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(2);
                int v = 1;
                int w = 2 + random.nextInt(6);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class SwampTannery
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"    FFFFFFFF", " FFFFFFFFFFF", "FFF FFFFFFFF", "FFF FFFFFFFF", "FFF FFFFFFFF", "    FFF     ", "    FFF     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 5;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 1;
        private int averageGroundLevel = -1;

        public SwampTannery() {
        }

        public SwampTannery(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampTannery buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampTannery.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampTannery(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 1, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{5, 0, 5, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{1, 5, 0, 5})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 2, 0, 2, 4}, {1, 0, 2, 1, 0, 4}, {1, 1, 2, 1, 2, 2}, {2, 0, 2, 2, 2, 4}, {4, 0, 0, 6, 0, 1}, {4, 0, 2, 4, 0, 6}, {5, 0, 2, 6, 0, 2}, {5, 0, 6, 6, 0, 6}, {7, 0, 2, 11, 0, 6}, {4, 1, 2, 4, 3, 4}, {4, 3, 5, 4, 3, 5}, {4, 1, 6, 4, 3, 6}, {5, 1, 6, 6, 3, 6}, {7, 1, 2, 11, 1, 2}, {11, 1, 3, 11, 1, 5}, {7, 1, 6, 11, 1, 6}, {5, 3, 2, 5, 3, 2}, {6, 1, 2, 6, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 3, 4, 6}, {1, 3, 4, 6}, {2, 3, 4, 6}, {0, 3, 3, 4}, {2, 3, 3, 5}, {0, 3, 2, 7}, {1, 3, 2, 7}, {2, 3, 2, 7}, {3, 3, 6, 0}, {4, 4, 6, 0}, {6, 4, 6, 1}, {7, 3, 6, 1}, {3, 3, 5, 0}, {4, 4, 5, 0}, {6, 4, 5, 1}, {7, 3, 5, 1}, {3, 3, 4, 0}, {4, 4, 4, 0}, {6, 4, 4, 1}, {7, 3, 4, 1}, {3, 3, 3, 0}, {4, 4, 3, 0}, {6, 4, 3, 1}, {7, 3, 3, 1}, {3, 3, 2, 0}, {4, 4, 2, 0}, {6, 4, 2, 1}, {7, 3, 2, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 4, 2, 4, 4}, {0, 4, 3, 0, 4, 3}, {2, 4, 3, 2, 4, 3}, {0, 4, 2, 2, 4, 2}, {1, 5, 2, 1, 6, 2}, {1, 6, 1, 1, 6, 1}, {4, 1, 0, 6, 1, 0}, {4, 2, 0, 4, 2, 0}, {6, 2, 0, 6, 2, 0}, {9, 2, 6, 9, 2, 6}, {11, 2, 6, 11, 2, 6}, {9, 2, 2, 9, 2, 2}, {11, 2, 2, 11, 2, 2}, {5, 4, 2, 5, 4, 2}, {5, 4, 6, 5, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 3, 0, 6, 3, 1}, {8, 3, 2, 11, 3, 6}, {5, 5, 2, 5, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{1, 1, 3, 1, 3, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 2, 2, 1, 0}, {4, 1, 5, 3, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{10, 1, 5}, {10, 1, 3}}) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(3), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvws : new int[][]{{11, 2, 4, 0}}) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(this.func_74865_a(uvws[0], uvws[2]), this.func_74862_a(uvws[1]), this.func_74873_b(uvws[0], uvws[2])), Blocks.field_150345_g, uvws[3]);
            }
            for (int[] uvwoc : new int[][]{{5, 0, 5, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {6, 0, 5, 3, GeneralConfig.useVillageColors ? this.townColor : 15}, {5, 0, 4, 1, GeneralConfig.useVillageColors ? this.townColor : 15}, {6, 0, 4, 0, GeneralConfig.useVillageColors ? this.townColor : 15}, {5, 0, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {6, 0, 3, 3, GeneralConfig.useVillageColors ? this.townColor : 15}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{6, 3, 4}, {1, 5, 1}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 2, 4, 3}, {12, 1, 5, 1}, {0, 2, 5, 0}, {0, 1, 5, 0}, {5, 3, 7, 0}, {5, 2, 7, 0}, {6, 3, 7, 0}, {9, 1, 7, 0}, {10, 1, 7, 0}, {0, 2, 1, 2}, {1, 2, 1, 2}, {1, 1, 1, 2}, {9, 1, 1, 2}, {10, 1, 1, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(16);
                int u = s == 15 ? 10 : 5 + s / 3;
                int v = 1;
                int w = s == 15 ? 4 : 3 + s % 3;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SwampStable
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"            FFFF  ", "         FFFFFFFF ", "        FFFFFFFFFF", "        FFFFFFFFFF", "        FFFFFFFFFF", "        FFFFFFFFFF", "        FFFFFFFFFF", "         FFFFFFFF ", "            FFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 13;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampStable() {
        }

        public SwampStable(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampStable buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampStable.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampStable(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{13, 0, 13, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 13, 0, 13})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{8, 0, 2, 8, 0, 6}, {9, 0, 1, 11, 0, 7}, {12, 0, 0, 12, 0, 8}, {13, 0, 0, 13, 0, 6}, {13, 0, 8, 14, 0, 8}, {14, 0, 0, 14, 0, 5}, {15, 0, 1, 16, 0, 3}, {15, 0, 7, 15, 0, 8}, {16, 0, 6, 16, 0, 7}, {17, 0, 2, 17, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uvwg : new int[][]{{13, 1, 1, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 7, 1, 5, 7}, {8, 1, 7, 8, 5, 7}, {1, 1, 1, 1, 5, 1}, {8, 1, 1, 8, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvw : new int[][]{{1, 0, 7}, {8, 0, 7}, {1, 0, 1}, {8, 0, 1}}) {
                this.func_175808_b(world, biomeStrippedLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 7, 7, 3, 7}, {2, 4, 7, 2, 4, 7}, {4, 4, 7, 5, 4, 7}, {7, 4, 7, 7, 4, 7}, {2, 5, 7, 7, 5, 7}, {1, 3, 2, 1, 3, 6}, {1, 4, 2, 1, 4, 2}, {1, 4, 4, 1, 4, 4}, {1, 4, 6, 1, 4, 6}, {1, 5, 2, 1, 5, 6}, {8, 3, 2, 8, 5, 2}, {8, 3, 6, 8, 5, 6}, {2, 3, 1, 7, 3, 1}, {2, 4, 1, 2, 4, 1}, {4, 4, 1, 5, 4, 1}, {7, 4, 1, 7, 4, 1}, {2, 5, 1, 7, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{11, 1, 3, 11, 1, 5}, {9, 2, 3, 9, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 2, 8, 2, 6}, {2, 2, 7, 2, 2, 7}, {4, 2, 7, 5, 2, 7}, {7, 2, 7, 7, 2, 7}, {1, 2, 2, 1, 2, 3}, {1, 2, 5, 1, 2, 6}, {2, 2, 1, 2, 2, 1}, {4, 2, 1, 5, 2, 1}, {7, 2, 1, 7, 2, 1}, {10, 1, 3, 10, 1, 5}, {8, 5, 3, 8, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 6, 1, 1, 6, 7}, {2, 6, 7, 2, 6, 7}, {4, 6, 7, 7, 6, 7}, {8, 6, 1, 8, 6, 3}, {8, 6, 5, 8, 6, 7}, {4, 6, 1, 5, 6, 1}, {3, 7, 3, 6, 7, 3}, {3, 7, 4, 3, 7, 4}, {6, 7, 4, 6, 7, 4}, {3, 7, 5, 6, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 7, 4, 6, 7}, {8, 6, 4, 8, 6, 4}, {2, 6, 1, 3, 6, 1}, {6, 6, 1, 7, 6, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 6, 1, 0, 6, 8}, {1, 6, 8, 6, 6, 8}, {9, 6, 0, 9, 6, 2}, {9, 6, 5, 9, 6, 6}, {2, 6, 0, 5, 6, 0}, {7, 6, 0, 8, 6, 0}, {2, 7, 2, 2, 7, 6}, {3, 7, 2, 6, 7, 2}, {3, 7, 6, 6, 7, 6}, {7, 7, 2, 7, 7, 6}, {4, 8, 4, 4, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{0, 6, 0, 1, 6, 0}, {6, 6, 0, 6, 6, 0}, {7, 6, 8, 9, 6, 8}, {9, 6, 3, 9, 6, 4}, {9, 6, 7, 9, 6, 7}, {5, 8, 4, 5, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{6, 3, 2, 3}, {7, 3, 3, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{7, 3, 2, 7, 3, 2}, {13, 0, 7, 13, 0, 7}, {14, 0, 6, 14, 0, 7}, {15, 0, 4, 15, 0, 6}, {16, 0, 4, 16, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{14, 1, 7}, {15, 1, 5}, {16, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150392_bi.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{2, 6, 4}, {7, 6, 4}, {3, 2, 7}, {6, 2, 7}, {1, 2, 4}, {3, 2, 1}, {6, 2, 1}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{9, 1, 1, 12, 1, 1}, {12, 1, 0, 14, 1, 0}, {14, 1, 1, 14, 1, 1}, {9, 3, 1, 10, 3, 1}, {9, 2, 1, 12, 2, 1}, {16, 1, 1, 16, 1, 2}, {17, 1, 2, 17, 1, 6}, {16, 1, 6, 16, 1, 7}, {15, 1, 7, 15, 1, 8}, {12, 1, 8, 14, 1, 8}, {9, 1, 7, 12, 1, 7}, {9, 3, 7, 10, 3, 7}, {9, 2, 7, 12, 2, 7}, {8, 1, 2, 8, 1, 6}, {3, 4, 7, 3, 4, 7}, {6, 4, 7, 6, 4, 7}, {1, 4, 3, 1, 4, 3}, {1, 4, 5, 1, 4, 5}, {3, 4, 1, 3, 4, 1}, {6, 4, 1, 6, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{15, 1, 1}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(2, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 3, 6}, {2, 4, 6}, {4, 3, 3}, {4, 4, 2}, {5, 3, 2}, {6, 3, 6}, {8, 3, 5}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 3, 5}, {3, 3, 2}, {4, 3, 2}, {4, 3, 2}, {7, 3, 5}}) {
                this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(Blocks.field_150407_cf.func_176203_a(0), this.func_186165_e().func_176736_b(), false), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 3, 6}, {7, 3, 6}, {7, 4, 6}}) {
                this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(Blocks.field_150407_cf.func_176203_a(0), this.func_186165_e().func_176736_b(), true), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{1, 5, 0, 2}, {1, 4, 0, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    ArrayList<Object> arraylist_animal;
                    for (int[] uvw : new int[][]{{15, 1, 3}}) {
                        boolean mooshroomsInsteadOfCows;
                        arraylist_animal = new ArrayList<Object>();
                        boolean bl = mooshroomsInsteadOfCows = this.materialType == FunctionsVN.MaterialType.MUSHROOM;
                        if (VillageGeneratorConfigHandler.animaniaLivestock && mooshroomsInsteadOfCows) {
                            for (String animal_namespace : mooshroomsInsteadOfCows ? ModObjects.animania_mooshroom : ModObjects.animania_cow) {
                                EntityLiving testEntity = null;
                                try {
                                    testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(animal_namespace), (World)world);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (testEntity == null) continue;
                                arraylist_animal.add(testEntity);
                            }
                        }
                        if (arraylist_animal.isEmpty() && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                            arraylist_animal.add(mooshroomsInsteadOfCows ? new EntityMooshroom(world) : new EntityCow(world));
                        }
                        if (arraylist_animal.isEmpty()) continue;
                        EntityLiving animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                    for (int[] uvw : new int[][]{{13, 1, 4}}) {
                        arraylist_animal = new ArrayList();
                        if (VillageGeneratorConfigHandler.animaniaLivestock && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                            for (String animal_namespace : ModObjects.animania_horse) {
                                EntityLiving testEntity = null;
                                try {
                                    testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(animal_namespace), (World)world);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (testEntity == null) continue;
                                arraylist_animal.add(testEntity);
                            }
                        }
                        if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                            arraylist_animal.add(new EntityHorse(world));
                        }
                        if (arraylist_animal.isEmpty()) continue;
                        EntityLiving animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                        if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities) {
                            String[] petname_a = NameGenerator.newRandomName("pet", random);
                            animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                        }
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampSmallHouse5
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"     ", "     ", "  FF ", "     ", " F   ", "     ", "F    ", "F    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = -1;
        private static final int DECREASE_MAX_U = 3;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampSmallHouse5() {
        }

        public SwampSmallHouse5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampSmallHouse5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampSmallHouse5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampSmallHouse5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            int v;
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{-1, 0, -1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, -1, 0, -1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStrippedLogVertState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 6, 0, 6, 6}, {4, 1, 6, 4, 6, 6}, {0, 1, 2, 0, 6, 2}, {4, 1, 2, 4, 6, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvw : new int[][]{{0, 0, 6}, {4, 0, 6}, {0, 0, 2}, {4, 0, 2}}) {
                this.func_175808_b(world, biomeStrippedLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 1, 1}, {1, 4, 2, 2, 4, 2}, {2, 5, 2, 2, 5, 2}, {1, 6, 2, 3, 6, 2}, {0, 4, 3, 0, 4, 5}, {0, 5, 5, 0, 5, 5}, {0, 6, 3, 0, 6, 5}, {4, 4, 3, 4, 4, 5}, {4, 5, 5, 4, 5, 5}, {4, 6, 3, 4, 6, 5}, {1, 4, 6, 3, 4, 6}, {2, 5, 6, 2, 5, 6}, {1, 6, 6, 3, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 3, 1, 4, 3, 1}, {0, 3, 3, 0, 3, 3}, {0, 3, 5, 0, 3, 5}, {4, 3, 3, 4, 3, 3}, {4, 3, 5, 4, 3, 5}, {1, 3, 6, 1, 3, 6}, {3, 3, 6, 3, 3, 6}, {1, 3, 2, 3, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 1, 0, 3}, {1, 2, 1, 0}, {2, 3, 1, 0}, {1, 1, 1, 5}, {2, 2, 1, 5}, {3, 3, 1, 5}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 4, 1}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{0, 6, 1}, {4, 6, 1}, {1, 6, 3}, {2, 3, 6}, {0, 3, 4}, {4, 3, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{1, 4, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 15}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 7, 6, 4, 7, 6}, {4, 7, 2, 4, 7, 5}, {0, 7, 4, 0, 7, 4}, {0, 7, 2, 2, 7, 2}, {0, 8, 4, 2, 8, 4}, {2, 8, 5, 2, 8, 5}, {4, 8, 4, 4, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 7, 5, 1, 7, 5}, {0, 7, 3, 0, 7, 3}, {0, 7, 3, 0, 7, 3}, {3, 7, 2, 3, 7, 2}, {3, 8, 4, 3, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 7, 1, 2, 7, 1}, {0, 7, 7, 0, 7, 7}, {3, 7, 7, 4, 7, 7}, {1, 8, 3, 4, 8, 3}, {3, 8, 5, 4, 8, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{3, 7, 1, 4, 7, 1}, {1, 7, 7, 2, 7, 7}, {0, 8, 3, 0, 8, 3}, {0, 8, 5, 1, 8, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 5, 2, 6, 5}, {2, 9, 5, 2, 9, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{2, 4, 5, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvwo : new int[][]{{1, 7, 3, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {2, 7, 3, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 7, 3, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {1, 7, 4, GeneralConfig.useVillageColors ? this.townColor : 15}, {2, 7, 4, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {3, 7, 4, GeneralConfig.useVillageColors ? this.townColor : 15}, {1, 7, 5, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {2, 7, 5, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 7, 5, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(uvwo[3]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 5, 6}, {3, 5, 6}, {0, 5, 3}, {0, 5, 4}, {4, 5, 3}, {4, 5, 4}, {1, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwfcp : new int[][]{{3, 0, 5, 7, 4, 7}, {1, 0, 3, 7, 2, random.nextInt(5)}}) {
                this.func_175808_b(world, biomeFillerState, uvwfcp[0], uvwfcp[1] - 1, uvwfcp[2], structureBB);
                this.func_175811_a(world, (uvwfcp[4] == 0 ? Blocks.field_150464_aj : (uvwfcp[4] == 1 ? Blocks.field_150469_bN : (uvwfcp[4] == 2 ? Blocks.field_150459_bM : (uvwfcp[4] == 3 ? Blocks.field_150394_bc : Blocks.field_150393_bb)))).func_176203_a(uvwfcp[5]), uvwfcp[0], uvwfcp[1] + 1, uvwfcp[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwfcp[3]), uvwfcp[0], uvwfcp[1], uvwfcp[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, 5}}) {
                this.func_175811_a(world, Blocks.field_150423_aK.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uwuwvs : new int[][]{{3, 2, 3, 4, 0, 1}, {3, 3, 3, 3, 0, 0}, {3, 3, 3, 3, 0, 2}, {3, 2, 3, 3, 0, 3}, {2, 4, 2, 5, 0, 3}}) {
                int u_offset = 0;
                int w_offset = 0;
                v = uwuwvs[4];
                switch (uwuwvs[5]) {
                    case 0: {
                        w_offset = 1;
                        break;
                    }
                    case 1: {
                        u_offset = 1;
                        break;
                    }
                    case 2: {
                        w_offset = -1;
                        break;
                    }
                    case 3: {
                        u_offset = -1;
                        break;
                    }
                }
                for (int u = uwuwvs[0]; u <= uwuwvs[2]; ++u) {
                    for (int w = uwuwvs[1]; w <= uwuwvs[3]; ++w) {
                        int z;
                        int y;
                        int x = this.func_74865_a(u + u_offset, w + w_offset);
                        BlockPos pos = new BlockPos(x, y = this.func_74862_a(v), z = this.func_74873_b(u + u_offset, w + w_offset));
                        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d()) {
                            this.func_175808_b(world, biomeFillerState, u + u_offset, v, w + w_offset, structureBB);
                            this.func_175811_a(world, biomeTopState, u + u_offset, v + 1, w + w_offset, structureBB);
                            continue;
                        }
                        if (!world.func_175623_d(pos)) continue;
                        this.func_175808_b(world, biomeFillerState, u + u_offset, v - 1, w + w_offset, structureBB);
                        this.func_175811_a(world, biomeTopState, u + u_offset, v, w + w_offset, structureBB);
                    }
                }
            }
            for (int[] uuvvww : new int[][]{{3, 0, 3, 3, 0, 3}, {2, 0, 4, 2, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{-1, 6, 4, 3}, {-1, 6, 3, 3}, {-1, 5, 3, 3}, {0, 6, 7, 0}, {0, 5, 7, 0}, {1, 6, 7, 0}, {1, 5, 7, 0}, {1, 4, 7, 0}, {1, 3, 7, 0}, {2, 6, 7, 0}, {2, 5, 7, 0}, {5, 6, 2, 1}, {5, 5, 2, 1}, {5, 4, 2, 1}, {5, 3, 2, 1}, {5, 7, 3, 1}, {5, 6, 3, 1}, {5, 5, 3, 1}, {1, 6, 1, 2}, {1, 5, 1, 2}, {2, 6, 1, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 4, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampSmallHouse4
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "  F      "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 4;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampSmallHouse4() {
        }

        public SwampSmallHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampSmallHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampSmallHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampSmallHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            int flowerindex;
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStrippedLogVertState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 6, 2, 5, 6}, {6, 0, 6, 6, 5, 6}, {2, 0, 2, 2, 5, 2}, {6, 0, 2, 6, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvw : new int[][]{{2, -1, 6}, {6, -1, 6}, {2, -1, 2}, {6, -1, 2}}) {
                this.func_175808_b(world, biomeStrippedLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 3, 2, 4, 3, 2}, {4, 4, 2, 4, 4, 2}, {3, 5, 2, 5, 5, 2}, {2, 3, 3, 2, 3, 5}, {2, 4, 5, 2, 4, 5}, {2, 5, 3, 2, 5, 5}, {6, 3, 3, 6, 3, 5}, {6, 4, 3, 6, 4, 3}, {6, 5, 3, 6, 5, 5}, {3, 3, 6, 5, 3, 6}, {3, 5, 6, 5, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 6, 2, 1}, {2, 2, 3, 2, 2, 3}, {2, 2, 5, 2, 2, 5}, {6, 2, 3, 6, 2, 3}, {6, 2, 5, 6, 2, 5}, {3, 2, 6, 3, 2, 6}, {5, 2, 6, 5, 2, 6}, {3, 2, 2, 5, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 0, 0, 0}, {3, 1, 0, 0}, {4, 2, 0, 0}, {3, 0, 0, 5}, {4, 1, 0, 5}, {5, 2, 0, 5}, {3, 3, 3, 2}, {3, 3, 5, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 1}, {6, 3, 1}, {3, 4, 2}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{3, 3, 4}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{2, 2, 4}, {6, 2, 4}, {4, 2, 6}, {3, 5, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{2, 4, 1}, {6, 4, 1}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{5, 3, 4, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 6, 2, 2, 6, 3}, {2, 6, 5, 2, 6, 6}, {3, 6, 2, 4, 6, 5}, {5, 6, 4, 5, 6, 6}, {6, 6, 3, 6, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 4, 2, 6, 4}, {3, 6, 6, 4, 6, 6}, {5, 6, 2, 6, 6, 2}, {5, 6, 3, 5, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 1, 1, 6, 2}, {1, 6, 5, 1, 6, 7}, {4, 6, 7, 7, 6, 7}, {7, 6, 3, 7, 6, 6}, {2, 6, 1, 5, 6, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{1, 6, 3, 1, 6, 4}, {2, 6, 7, 3, 6, 7}, {6, 6, 1, 7, 6, 1}, {7, 6, 2, 7, 6, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 3, 3, 1, 3, 4}, {3, 3, 7, 5, 3, 7}, {7, 3, 4, 7, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150349_c.func_176223_P(), Blocks.field_150349_c.func_176223_P(), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 4, 3, 1}, {2, 4, 4, 1}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {6, 4, 4, 3}, {6, 4, 5, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 3, 2, 2}, {0, 3, 3, 3}, {0, 3, 4, 3}, {1, 3, 5, 0}, {2, 3, 7, 3}, {3, 3, 8, 0}, {4, 3, 8, 0}, {5, 3, 8, 0}, {6, 3, 7, 1}, {7, 3, 3, 2}, {8, 3, 4, 1}, {8, 3, 5, 1}, {7, 3, 6, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 2, 3, 3}, {1, 2, 4, 3}, {3, 2, 7, 0}, {4, 2, 7, 0}, {5, 2, 7, 0}, {7, 2, 4, 1}, {7, 2, 5, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, false)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int flowerindex2 = flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
            int flowerindex3 = flowerindex;
            while (flowerindex2 == flowerindex) {
                flowerindex2 = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
            }
            while (flowerindex3 == flowerindex || flowerindex3 == flowerindex2) {
                flowerindex3 = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
            }
            for (int[] uvwf : new int[][]{{1, 4, 3, flowerindex}, {1, 4, 4, flowerindex}, {3, 4, 7, flowerindex2}, {4, 4, 7, flowerindex2}, {5, 4, 7, flowerindex2}, {7, 4, 4, flowerindex3}, {7, 4, 5, flowerindex3}}) {
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvwf[0], uvwf[1], uvwf[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{1, 5, 3, 3}, {1, 5, 4, 3}, {2, 5, 7, 0}, {2, 4, 7, 0}, {3, 5, 7, 0}, {7, 5, 2, 1}, {7, 4, 2, 1}, {7, 3, 2, 1}, {7, 2, 2, 1}, {6, 5, 1, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 3, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampSmallHouse3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFFFF  ", "FFFFFFFF ", "FFFFFFFF ", "FFFFFFFF ", "FFFFFFF  ", "FFFFFFF  ", "FFFFFFFF ", "FFFFFFFFF", "  FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampSmallHouse3() {
        }

        public SwampSmallHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampSmallHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampSmallHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampSmallHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{2, 1, 0}, {8, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{4, 0, 0, 4, 0, 2}, {2, 1, 3, 3, 3, 3}, {4, 3, 3, 4, 3, 3}, {5, 1, 3, 5, 3, 3}, {2, 1, 4, 2, 2, 7}, {2, 3, 5, 2, 3, 6}, {1, 1, 7, 1, 2, 7}, {3, 1, 7, 6, 3, 7}, {7, 1, 5, 7, 3, 6}, {6, 1, 4, 6, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 3, 5, 0, 7}, {6, 0, 4, 6, 0, 7}, {7, 0, 5, 7, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 3, 0, 1, 3}, {0, 1, 4, 0, 2, 5}, {0, 1, 6, 0, 1, 7}, {1, 1, 3, 1, 2, 3}, {1, 1, 4, 1, 3, 5}, {1, 1, 6, 1, 2, 6}, {1, 1, 8, 2, 1, 8}, {3, 1, 8, 6, 2, 8}, {4, 4, 3, 5, 4, 3}, {6, 1, 3, 6, 3, 3}, {7, 1, 7, 7, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 3, 3, 4, 5}, {2, 4, 6, 7, 4, 6}, {2, 4, 7, 6, 4, 7}, {2, 4, 3, 6, 4, 5}, {0, 2, 4, 0, 2, 5}, {1, 3, 6, 1, 3, 7}, {2, 3, 7, 2, 3, 7}, {3, 3, 8, 6, 3, 8}, {7, 3, 7, 7, 3, 7}, {0, 2, 3, 0, 2, 3}, {0, 2, 6, 0, 2, 7}, {1, 2, 8, 2, 2, 8}, {0, 1, 2, 2, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 4, 4, 5, 6, 5}, {4, 7, 4, 4, 7, 4}, {6, 3, 2, 6, 4, 2}, {7, 1, 2, 7, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{7, 3, 3, 8, 3, 3}, {2, 3, 4, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 3, 3, 1, 3, 3}, {5, 5, 2, 5, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{5, 3, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 3, 5, 3, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            IBlockState polishedGraniteState = Blocks.field_150348_b.func_176203_a(2);
            for (int[] uvw : new int[][]{{3, 1, 6}}) {
                this.func_175811_a(world, polishedGraniteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 6}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 3, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 4, 5, 0}, {1, 2, 2, 0}, {1, 5, 4, 0}, {1, 4, 7, 2}, {2, 5, 3, 0}, {2, 5, 5, 0}, {3, 4, 8, 0}, {5, 5, 7, 2}, {6, 5, 3, 2}, {7, 5, 4, 0}, {7, 5, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 2, 2}}) {
                this.func_175811_a(world, Blocks.field_150328_O.func_176203_a(1), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{6, 1, 5, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{5, 1, 5, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampSmallHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "  FF   ", "  FF   ", "  FF   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampSmallHouse2() {
        }

        public SwampSmallHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampSmallHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampSmallHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampSmallHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{0, 3, 10, 0, 3, 10}, {6, 3, 10, 6, 3, 10}, {0, 3, 8, 0, 3, 8}, {6, 3, 8, 6, 3, 8}, {0, 3, 6, 0, 3, 6}, {6, 3, 6, 6, 3, 6}, {1, 3, 3, 5, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 3, 5, 0, 5}, {1, 0, 6, 1, 0, 7}, {5, 0, 6, 5, 0, 7}, {1, 0, 8, 5, 0, 10}, {1, 1, 5, 2, 3, 5}, {3, 3, 5, 3, 3, 5}, {4, 1, 5, 5, 3, 5}, {2, 4, 6, 4, 4, 6}, {1, 0, 6, 1, 3, 6}, {1, 0, 7, 1, 1, 7}, {1, 3, 7, 1, 3, 7}, {1, 0, 8, 1, 3, 8}, {1, 0, 9, 1, 1, 9}, {1, 3, 9, 1, 3, 9}, {5, 0, 6, 5, 3, 6}, {5, 0, 7, 5, 1, 7}, {5, 3, 7, 5, 3, 7}, {5, 0, 8, 5, 3, 8}, {5, 0, 9, 5, 1, 9}, {5, 3, 9, 5, 3, 9}, {1, 0, 10, 5, 3, 10}, {2, 4, 10, 2, 4, 10}, {4, 4, 10, 4, 4, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 0, 3, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 3, 4, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 3}, {1, 2, 3}, {5, 1, 3}, {5, 2, 3}, {3, 4, 10}, {1, 2, 9}, {5, 2, 9}, {1, 2, 7}, {5, 2, 7}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 6, 1, 4, 8}, {3, 5, 6, 3, 5, 6}, {3, 5, 8, 3, 5, 8}, {3, 5, 10, 3, 5, 10}, {5, 4, 6, 5, 4, 6}, {5, 4, 10, 5, 4, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 9, 1, 4, 10}, {5, 4, 7, 5, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 6, 0, 4, 7}, {2, 5, 6, 2, 5, 8}, {2, 5, 10, 2, 5, 10}, {4, 5, 6, 4, 5, 7}, {4, 5, 10, 4, 5, 10}, {6, 4, 6, 6, 4, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{0, 4, 8, 0, 4, 10}, {2, 5, 9, 2, 5, 9}, {4, 5, 8, 4, 5, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            IBlockState biomeCobblestoneSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(11), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 5, 7, 3, 5, 7}, {3, 5, 9, 3, 5, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabUpperState, biomeCobblestoneSlabUpperState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 4, 8}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwc : new int[][]{{2, 0, 7, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {3, 0, 6, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {4, 0, 7, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {2, 0, 6, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {3, 0, 7, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {4, 0, 6, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(uvwc[3]), uvwc[0], uvwc[1], uvwc[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 5, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{4, 2, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 1, 8, 2, GeneralConfig.useVillageColors ? this.townColor3 : 10}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, 4}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            int chestU = 1;
            int chestV = 1;
            int chestW = 4;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{6, 3, 5, 1}, {6, 2, 5, 1}, {6, 1, 5, 1}, {6, 0, 5, 1}, {1, 3, 11, 0}, {4, 4, 11, 0}, {4, 3, 11, 0}, {4, 2, 11, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 7, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampSmallHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampSmallHouse1() {
        }

        public SwampSmallHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampSmallHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampSmallHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampSmallHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 0, 4, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 0, 1, 0, 1}, {0, 0, 2, 4, 0, 7}, {0, 1, 4, 0, 3, 4}, {1, 3, 4, 1, 3, 4}, {2, 1, 4, 2, 3, 4}, {3, 1, 4, 3, 1, 4}, {3, 3, 4, 3, 3, 4}, {4, 1, 4, 4, 3, 4}, {0, 1, 5, 0, 1, 5}, {0, 3, 5, 0, 3, 5}, {0, 1, 6, 0, 3, 6}, {4, 1, 5, 4, 1, 5}, {4, 3, 5, 4, 3, 5}, {4, 1, 6, 4, 3, 6}, {0, 0, 7, 1, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0}, {2, 1, 0}, {0, 1, 2}, {0, 2, 2}, {4, 1, 2}, {4, 2, 2}, {0, 2, 5}, {3, 2, 4}, {4, 2, 5}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 5, 0, 4, 6}, {4, 4, 5, 4, 4, 6}, {2, 0, 8, 4, 3, 8}, {2, 0, 7, 2, 0, 7}, {4, 0, 7, 4, 0, 7}, {2, 1, 7, 4, 3, 7}, {3, 4, 7, 3, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 5, 7, 3, 5, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 2, 1, 3, 2}, {3, 3, 2, 4, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeCobblestoneSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(11), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 3, 0, 3, 3}, {4, 3, 3, 4, 3, 3}, {1, 4, 5, 3, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabUpperState, biomeCobblestoneSlabUpperState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{2, 3, 2, 2, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabUpperState = ModObjects.chooseModMossyCobblestoneSlabState(true);
            biomeMossyCobblestoneSlabUpperState = biomeMossyCobblestoneSlabUpperState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabUpperState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabUpperState;
            for (int[] uuvvww : new int[][]{{1, 3, 3, 3, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabUpperState, biomeMossyCobblestoneSlabUpperState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{0, 4, 7, 2}, {1, 4, 7, 2}, {0, 5, 6, 2}, {1, 5, 6, 2}, {2, 5, 6, 2}, {3, 5, 6, 2}, {0, 5, 5, 3}, {1, 5, 5, 3}, {3, 5, 5, 3}, {0, 4, 4, 3}, {3, 4, 4, 3}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeMossyCobblestoneStairsBlock = ModObjects.chooseModMossyCobblestoneStairsBlock();
            if (biomeMossyCobblestoneStairsBlock == null) {
                biomeMossyCobblestoneStairsBlock = Blocks.field_150446_ar;
            }
            biomeMossyCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{2, 4, 7, 2}, {4, 4, 7, 2}, {4, 5, 6, 2}, {2, 5, 5, 3}, {4, 5, 5, 3}, {1, 4, 4, 3}, {2, 4, 4, 3}, {4, 4, 4, 3}}) {
                this.func_175811_a(world, biomeMossyCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 2, 2}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{1, 1, 4, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{3, 1, 7, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvwoc : new int[][]{{2, 1, 5, 3, GeneralConfig.useVillageColors ? this.townColor : 15}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 6, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampShepherdHouse2
    extends StructureVillageVN.VNComponent {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{" FFFFF  ", "FFFFFFF ", "FFFFFFF ", "FFFFFFF ", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", " FFFFFFF", " FFFFF P", "  FFF  P", "   PPPPP"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 4;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 3;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampShepherdHouse2() {
        }

        public SwampShepherdHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampShepherdHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampShepherdHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampShepherdHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 4, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 4);
            this.establishFoundation(world, structureBB, foundationPattern, 4, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 4, 4, 1, 4, 6}, {2, 4, 3, 2, 4, 5}, {2, 4, 8, 2, 4, 9}, {3, 4, 5, 3, 4, 5}, {3, 4, 9, 3, 4, 9}, {4, 4, 3, 4, 4, 9}, {4, 4, 8, 4, 4, 9}, {5, 4, 3, 5, 4, 5}, {5, 4, 8, 5, 4, 9}, {6, 4, 6, 6, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 4, 0, 4, 9}, {1, 4, 2, 1, 4, 3}, {1, 4, 7, 1, 4, 10}, {2, 4, 1, 2, 4, 2}, {2, 4, 10, 5, 4, 10}, {4, 4, 1, 4, 4, 2}, {5, 4, 2, 5, 4, 2}, {5, 4, 9, 5, 4, 9}, {6, 4, 3, 6, 4, 4}, {6, 4, 7, 6, 4, 9}, {7, 4, 4, 7, 4, 6}, {1, 5, 4, 1, 5, 6}, {2, 5, 3, 4, 5, 9}, {5, 5, 3, 5, 5, 8}, {6, 5, 6, 6, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uvw : new int[][]{{7, 4, 4}, {7, 4, 5}}) {
                int posX = this.func_74865_a(uvw[0], uvw[2]);
                int posY = this.func_74862_a(uvw[1]);
                int posZ = this.func_74873_b(uvw[0], uvw[2]);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 6, 5, 3, 9}, {3, 1, 4, 3, 4, 4}, {3, 2, 3, 3, 4, 3}, {3, 3, 2, 3, 4, 2}, {3, 4, 1, 3, 4, 1}}) {
                this.func_74878_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5]);
            }
            for (int[] uuvvww : new int[][]{{3, 3, 5, 3, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 4, 1, 6, 6}, {2, 6, 6, 2, 6, 9}, {3, 6, 9, 4, 6, 9}, {4, 6, 8, 5, 6, 8}, {5, 6, 3, 5, 6, 4}, {5, 6, 6, 5, 6, 7}, {2, 6, 3, 4, 6, 3}, {2, 6, 4, 2, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 4, 2}, {2, 7, 6, -1}, {5, 7, 3, -1}, {5, 7, 7, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 5, 0, 3, 9}, {1, 0, 9, 1, 3, 9}, {1, 0, 10, 5, 3, 10}, {5, 0, 9, 5, 3, 9}, {6, 0, 5, 6, 3, 9}, {1, 0, 5, 2, 3, 5}, {4, 0, 5, 5, 3, 5}, {1, 0, 6, 1, 0, 8}, {5, 0, 6, 5, 0, 8}, {3, 0, 4, 3, 0, 5}, {2, 1, 3, 2, 3, 4}, {4, 1, 3, 4, 3, 4}, {2, 2, 2, 2, 3, 2}, {4, 2, 2, 4, 3, 2}, {2, 3, 1, 2, 3, 1}, {4, 3, 1, 4, 3, 1}, {2, 4, 6, 4, 4, 7}, {3, 4, 8, 3, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 3, 1, 2}, {3, 2, 2, 2}, {3, 1, 3, 2}, {1, 3, 6, 5}, {1, 3, 7, 5}, {1, 3, 8, 5}, {2, 3, 8, 7}, {2, 3, 9, 5}, {3, 3, 9, 7}, {4, 3, 9, 4}, {4, 3, 8, 7}, {5, 3, 6, 4}, {5, 3, 7, 4}, {5, 3, 8, 4}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{5, 6, 5}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(1, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{7, 4, 3, 3}, {6, 5, 5, 1}, {5, 1, 8, 7}, {5, 1, 6, 6}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 7, 5, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            int flowernumber = 9;
            int potU = 5;
            int potV = 2;
            int potW = 7;
            int potX = this.func_74865_a(potU, potW);
            int potY = this.func_74862_a(potV);
            int potZ = this.func_74873_b(potU, potW);
            TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
            BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
            world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
            world.func_175690_a(flowerPotPos, flowerPot);
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 3, 8}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 5, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 1, 7, 1}}) {
                this.func_175811_a(world, ModObjects.chooseModLoom(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 1, 6, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 0, 9, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 0, 9, GeneralConfig.useVillageColors ? this.townColor : 15}, {4, 0, 9, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 0, 8, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 0, 8, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {4, 0, 8, GeneralConfig.useVillageColors ? this.townColor : 15}, {2, 0, 7, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 0, 7, GeneralConfig.useVillageColors ? this.townColor : 15}, {4, 0, 7, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 0, 6, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 0, 6, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {4, 0, 6, GeneralConfig.useVillageColors ? this.townColor : 15}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(uvwo[3]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 2, 9, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 2, 9, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {4, 2, 9, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (int[] uvwg : new int[][]{{1, 5, 8, 0}, {3, 6, 8, 0}, {2, 5, 10, 0}, {5, 5, 9, 0}, {6, 5, 7, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            int chestU = 1;
            int chestV = 1;
            int chestW = 8;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_shepherd");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(3);
                int v = 1;
                int w = 6 + random.nextInt(5);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{3, 6, 6}}) {
                        ArrayList<Object> arraylist_animal = new ArrayList<Object>();
                        if (VillageGeneratorConfigHandler.animaniaLivestock) {
                            for (String animal_namespace : ModObjects.animania_sheep) {
                                EntityLiving testEntity = null;
                                try {
                                    testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(animal_namespace), (World)world);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (testEntity == null) continue;
                                arraylist_animal.add(testEntity);
                            }
                        }
                        if (arraylist_animal.isEmpty() && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                            arraylist_animal.add(new EntitySheep(world));
                        }
                        if (arraylist_animal.isEmpty()) continue;
                        EntityLiving animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampShepherdHouse1
    extends StructureVillageVN.VNComponent {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"         ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFFF", "        P"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 9;
        private static final int INCREASE_MIN_U = 7;
        private static final int DECREASE_MAX_U = -1;
        private static final int INCREASE_MIN_W = -1;
        private static final int DECREASE_MAX_W = 6;
        private int averageGroundLevel = -1;

        public SwampShepherdHouse1() {
        }

        public SwampShepherdHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static SwampShepherdHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampShepherdHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampShepherdHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{7, 6, 7, -1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{-1, 7, 6, 7})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{-1, -1, -1, 6})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{6, -1, -1, -1})[this.func_186165_e().func_176736_b()]), true, (byte)9, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 0, 1, 7, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 7, 1, 5, 7}, {7, 1, 7, 7, 5, 7}, {1, 1, 1, 1, 5, 1}, {7, 1, 1, 7, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 6, 1, 1, 6, 7}, {7, 6, 1, 7, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 7, 5, 4, 7}, {4, 5, 7, 5, 5, 7}, {6, 3, 7, 6, 3, 7}, {1, 3, 2, 1, 4, 6}, {1, 5, 2, 1, 5, 2}, {1, 5, 6, 1, 5, 6}, {7, 3, 2, 7, 4, 6}, {7, 5, 2, 7, 5, 2}, {7, 5, 6, 7, 5, 6}, {2, 3, 1, 6, 4, 1}, {4, 5, 1, 4, 5, 1}, {2, 3, 2, 3, 3, 6}, {4, 3, 6, 4, 3, 6}, {5, 3, 2, 6, 3, 6}, {8, 0, 1, 8, 0, 1}, {1, 7, 4, 7, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 3, 8, 4, 4, 8}, {0, 3, 4, 0, 4, 4}, {4, 3, 0, 4, 4, 0}, {2, 1, 7, 6, 1, 7}, {1, 1, 2, 1, 1, 6}, {7, 1, 2, 7, 1, 6}, {2, 1, 1, 6, 1, 1}, {4, 1, 4, 4, 1, 4}, {4, 1, 5, 4, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            Block biomeWoodStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{4, 3, 5, 3}, {4, 2, 4, 3}, {4, 1, 3, 3}}) {
                this.func_175811_a(world, biomeWoodStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 7, 6, 6, 7}, {1, 7, 5, 7, 7, 5}, {1, 7, 3, 7, 7, 3}, {2, 6, 1, 6, 6, 1}, {8, 1, 2, 8, 1, 2}, {8, 2, 4, 8, 2, 4}, {8, 3, 6, 8, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 6, 6, 6, 6}, {2, 6, 2, 6, 6, 2}, {8, 1, 3, 8, 1, 3}, {8, 2, 5, 8, 2, 5}, {8, 3, 7, 8, 3, 8}, {5, 3, 8, 7, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 2, 8}, {0, 2, 4}, {4, 2, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{7, 2, 4}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 6, 4, 1}, {6, 6, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{4, 3, 4, 3}, {4, 3, 3, 3}, {4, 3, 2, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, false)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            Block biomeWoodDoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwoor : new int[][]{{6, 4, 7, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorBlock.func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 5, 7, 3, 5, 7}, {1, 5, 3, 1, 5, 5}, {7, 5, 3, 7, 5, 5}, {2, 5, 1, 3, 5, 1}, {5, 5, 1, 6, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150410_aZ.func_176223_P(), Blocks.field_150410_aZ.func_176223_P(), false);
            }
            IBlockState polishedDioriteState = Blocks.field_150348_b.func_176203_a(4);
            for (int[] uvw : new int[][]{{6, 4, 2}}) {
                this.func_175811_a(world, polishedDioriteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 5, 2}}) {
                int i = uvw[0];
                int v = uvw[1];
                int j = uvw[2];
                int x = this.func_74865_a(i, j);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(i, j);
                String[] cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            for (int[] uvwo : new int[][]{{2, 4, 2, 0}}) {
                this.func_175811_a(world, ModObjects.chooseModLoom(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 4, 6, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {2, 4, 5, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {2, 5, 6, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(uvwo[3]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{6, 4, 3, 6, 4, 5, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {5, 4, 2, 5, 4, 5, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvwg : new int[][]{{2, 1, 5, 0}, {3, 1, 2, 0}, {5, 1, 5, 0}, {6, 1, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(21);
                int i = s <= 1 ? 2 : (s <= 16 ? (s - 2) / 5 + 3 : 6);
                int v = 4;
                int j = s <= 1 ? s - 3 : (s <= 16 ? (s - 2) % 5 + 2 : s - 14);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(i, j) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(i, j) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{3, 1, 6}, {6, 1, 4}}) {
                        ArrayList<Object> arraylist_animal = new ArrayList<Object>();
                        if (VillageGeneratorConfigHandler.animaniaLivestock) {
                            for (String animal_namespace : ModObjects.animania_sheep) {
                                EntityLiving testEntity = null;
                                try {
                                    testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(animal_namespace), (World)world);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (testEntity == null) continue;
                                arraylist_animal.add(testEntity);
                            }
                        }
                        if (arraylist_animal.isEmpty() && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                            arraylist_animal.add(new EntitySheep(world));
                        }
                        if (arraylist_animal.isEmpty()) continue;
                        EntityLiving animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int getVillagerType(int number) {
            return 0;
        }
    }

    public static class SwampMediumHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"            ", "            ", "            ", "            ", "            ", "            ", "            ", "         FF ", "         F  ", "         FF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 9;
        private static final int INCREASE_MIN_U = 8;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 6;
        private int averageGroundLevel = -1;

        public SwampMediumHouse2() {
        }

        public SwampMediumHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampMediumHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampMediumHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampMediumHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{8, 6, 8, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 8, 6, 8})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 6})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{6, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)9, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStrippedLogVertState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 9, 1, 4, 9}, {7, 1, 9, 7, 4, 9}, {1, 1, 5, 1, 4, 5}, {7, 1, 5, 7, 4, 5}, {2, 1, 2, 2, 4, 2}, {6, 1, 2, 6, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 0, 6, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 9, 1, 0, 9}, {7, 0, 9, 7, 0, 9}, {1, 0, 5, 1, 0, 5}, {7, 0, 5, 7, 0, 5}, {2, 0, 2, 2, 0, 2}, {6, 0, 2, 6, 0, 2}, {2, 0, 0, 2, 0, 0}, {4, 0, 0, 4, 0, 0}, {6, 0, 0, 6, 0, 0}, {2, 4, 0, 6, 4, 0}, {7, 3, 2, 8, 3, 2}, {8, 2, 2, 10, 2, 2}, {7, 3, 0, 8, 3, 0}, {8, 2, 0, 10, 2, 0}, {2, 4, 1, 2, 4, 1}, {6, 4, 1, 6, 4, 1}, {8, 1, 2, 8, 2, 2}, {10, 0, 2, 10, 1, 2}, {2, 2, 0, 2, 3, 0}, {4, 2, 0, 4, 3, 0}, {6, 2, 0, 6, 3, 0}, {8, 1, 0, 8, 2, 0}, {10, 0, 0, 10, 1, 0}, {1, 3, 7, 1, 3, 7}, {7, 3, 7, 7, 3, 7}, {2, 3, 3, 2, 3, 3}, {6, 3, 3, 6, 3, 4}, {3, 3, 2, 4, 3, 2}, {4, 5, 2, 4, 5, 2}, {3, 5, 5, 5, 5, 5}, {3, 5, 9, 5, 5, 9}, {4, 5, 6, 4, 5, 8}, {3, 3, 5, 3, 3, 5}, {5, 3, 5, 5, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvw : new int[][]{{1, -1, 9}, {7, -1, 9}, {1, -1, 5}, {7, -1, 5}, {2, -1, 2}, {6, -1, 2}, {2, -1, 0}, {4, -1, 0}, {6, -1, 0}}) {
                this.func_175808_b(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 2, 2, 4, 2, 2}, {3, 4, 2, 5, 4, 2}, {2, 1, 3, 2, 2, 3}, {2, 1, 4, 2, 1, 4}, {2, 4, 3, 2, 4, 3}, {1, 1, 6, 1, 2, 8}, {1, 3, 6, 1, 3, 6}, {1, 3, 8, 1, 3, 8}, {1, 4, 6, 1, 4, 8}, {7, 1, 6, 7, 2, 8}, {7, 3, 6, 7, 3, 6}, {7, 3, 8, 7, 3, 8}, {7, 4, 6, 7, 4, 8}, {6, 4, 3, 6, 4, 4}, {6, 1, 3, 6, 2, 4}, {2, 1, 9, 6, 4, 9}, {2, 4, 5, 6, 4, 5}, {2, 3, 5, 2, 3, 5}, {6, 3, 5, 6, 3, 5}, {2, 2, 5, 3, 2, 5}, {5, 2, 5, 6, 2, 5}, {2, 1, 5, 6, 1, 8}, {3, 1, 2, 5, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 5, 1, 5, 9}, {3, 6, 5, 3, 6, 9}, {5, 6, 5, 5, 6, 9}, {7, 5, 5, 7, 5, 9}, {2, 5, 0, 2, 5, 3}, {4, 6, 0, 4, 6, 4}, {6, 5, 0, 6, 5, 4}, {7, 1, 0, 7, 1, 2}, {9, 0, 0, 9, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 5, 0, 4, 9}, {2, 5, 5, 2, 5, 9}, {4, 6, 5, 4, 6, 9}, {6, 5, 5, 6, 5, 9}, {8, 4, 5, 8, 4, 9}, {1, 4, 0, 1, 4, 4}, {3, 5, 0, 3, 5, 4}, {5, 5, 0, 5, 5, 4}, {7, 4, 0, 7, 4, 4}, {2, 1, 1, 6, 1, 1}, {8, 0, 0, 8, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{6, 2, 6}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 3, 0}, {4, 4, 7}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{3, 2, 4}, {5, 2, 4}, {4, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{4, 5, 0, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 2, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 2, 6}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 2, 4, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 4, 2, 4, 4}, {2, 6, 4, 2, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 5, 4, 2, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwoc : new int[][]{{3, 2, 8, 1, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {5, 2, 8, 3, GeneralConfig.useVillageColors ? this.townColor3 : 10}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 7, -1, 0}, {5, 2, 7, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampMediumHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "F         "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 5;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampMediumHouse1() {
        }

        public SwampMediumHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampMediumHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampMediumHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampMediumHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{5, 0, 5, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 5, 0, 5})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 8}, {5, 0, 9}, {9, 0, 8}, {1, 0, 5}, {5, 0, 5}, {9, 0, 5}, {1, 0, 1}, {5, 0, 1}, {9, 0, 1}, {1, 2, 1}, {1, 2, 2}, {1, 3, 1}, {5, 2, 1}, {5, 3, 1}, {9, 2, 1}, {9, 3, 1}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, -1, 8}, {5, -1, 9}, {9, -1, 8}, {1, -1, 5}, {5, -1, 5}, {9, -1, 5}, {1, -1, 1}, {5, -1, 1}, {9, -1, 1}}) {
                this.func_175808_b(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{7, 2, 7, 7, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 1, 3}, {1, 1, 1, 9, 1, 8}, {4, 1, 9, 6, 1, 9}, {1, 2, 4, 1, 3, 4}, {2, 2, 4, 3, 2, 4}, {4, 2, 4, 4, 3, 4}, {6, 2, 4, 7, 3, 4}, {8, 2, 4, 8, 2, 4}, {9, 2, 4, 9, 3, 4}, {3, 4, 4, 7, 4, 4}, {5, 5, 4, 5, 5, 4}, {1, 2, 8, 3, 3, 8}, {3, 4, 8, 3, 4, 8}, {7, 4, 8, 7, 4, 8}, {7, 2, 8, 9, 3, 8}, {1, 2, 5, 1, 3, 7}, {9, 2, 5, 9, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 8, 2, 4, 8}, {4, 5, 8, 6, 5, 8}, {6, 5, 4, 6, 5, 4}, {8, 4, 8, 8, 4, 8}, {4, 2, 8, 4, 2, 8}, {6, 2, 8, 6, 2, 8}, {4, 2, 9, 6, 3, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 4, 2, 4, 4}, {4, 5, 4, 4, 5, 4}, {8, 4, 4, 8, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 4, 4, 2}, {2, 4, 3, 3, 4, 3}, {6, 4, 1, 7, 4, 3}, {8, 4, 1, 8, 4, 2}, {1, 4, 5, 1, 4, 7}, {9, 4, 8, 9, 4, 8}, {3, 5, 6, 3, 5, 8}, {5, 6, 4, 5, 6, 7}, {7, 5, 4, 7, 5, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{1, 4, 3, 1, 4, 4}, {1, 4, 8, 1, 4, 8}, {4, 4, 3, 4, 4, 3}, {5, 4, 1, 5, 4, 3}, {8, 4, 3, 8, 4, 3}, {9, 4, 1, 9, 4, 7}, {3, 5, 4, 3, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            IBlockState biomeCobblestoneSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(11), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 5, 2, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabUpperState, biomeCobblestoneSlabUpperState, false);
            }
            IBlockState biomeMossyCobblestoneSlabUpperState = ModObjects.chooseModMossyCobblestoneSlabState(true);
            biomeMossyCobblestoneSlabUpperState = biomeMossyCobblestoneSlabUpperState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabUpperState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabUpperState;
            for (int[] uuvvww : new int[][]{{2, 4, 6, 2, 4, 7}, {4, 5, 5, 4, 5, 7}, {6, 5, 5, 6, 5, 7}, {8, 4, 5, 8, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabUpperState, biomeMossyCobblestoneSlabUpperState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{4, 4, 8, 5}, {5, 4, 8, 7}, {6, 4, 8, 4}, {4, 3, 8, 5}, {6, 3, 8, 4}, {4, 4, 9, 2}, {5, 4, 9, 2}, {6, 4, 9, 2}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 2, 8, 5, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 0, 0, 3}, {0, 1, 1, 3}, {2, 2, 2, 3}, {3, 2, 2, 3}, {6, 2, 2, 1}, {8, 2, 2, 0}, {2, 2, 5, 2}, {3, 2, 5, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{7, 2, 2}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{7, 3, 1}, {5, 5, 7}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{7, 3, 7}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 6, 3, 2, 6, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {3, 2, 7, 3, 2, 7, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 7, 2, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{2, 3, 4}, {3, 3, 4}, {8, 3, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 2, 4, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{5, 3, 8, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvwoc : new int[][]{{6, 2, 6, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {8, 2, 6, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvwoc : new int[][]{{7, 3, 3, 2, 14}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                if (GeneralConfig.useVillageColors) {
                    NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = new ItemStack(Items.field_179564_cE);
                    villageBanner.func_77983_a("BlockEntityTag", (NBTBase)villageNBTtag.func_74775_l("BlockEntityTag"));
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 3, 4, 3}, {0, 2, 4, 3}, {0, 1, 4, 3}, {10, 3, 4, 1}, {10, 3, 5, 1}, {10, 2, 5, 1}, {10, 1, 5, 1}, {10, 3, 6, 1}, {10, 2, 6, 1}, {1, 3, 9, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{6, 2, 5, -1, 0}, {8, 2, 5, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampMasonHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampMasonHouse() {
        }

        public SwampMasonHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampMasonHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampMasonHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampMasonHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 0, 0, 0, 1}, {0, 0, 4, 0, 0, 5}, {0, 0, 9, 0, 0, 11}, {5, 0, 11, 6, 0, 11}, {6, 0, 8, 6, 0, 8}, {6, 0, 0, 6, 0, 1}, {4, 0, 0, 4, 0, 0}, {1, 0, 1, 5, 0, 2}, {1, 0, 3, 2, 0, 6}, {4, 0, 3, 5, 0, 6}, {1, 0, 7, 4, 0, 9}, {1, 0, 10, 1, 0, 10}, {4, 0, 10, 5, 0, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 2, 0, 0, 3}, {0, 0, 6, 0, 0, 8}, {1, 0, 11, 4, 0, 11}, {2, 0, 10, 3, 0, 10}, {6, 0, 9, 6, 0, 10}, {6, 0, 2, 6, 0, 7}, {5, 0, 8, 5, 0, 9}, {1, 0, 0, 2, 0, 0}, {5, 0, 0, 5, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            for (int[] uvwoc : new int[][]{{3, 0, 3, 1, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 0, 4, 0, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 0, 5, 3, GeneralConfig.useVillageColors ? this.townColor : 15}, {3, 0, 6, 2, GeneralConfig.useVillageColors ? this.townColor : 15}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 0, 0, 3}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 1, 1}, {0, 1, 4, 0, 1, 5}, {0, 1, 8, 0, 1, 11}, {1, 1, 11, 1, 1, 11}, {3, 1, 11, 6, 1, 11}, {6, 1, 10, 6, 1, 10}, {6, 1, 7, 6, 1, 8}, {6, 1, 3, 6, 1, 3}, {6, 1, 0, 6, 1, 0}, {4, 1, 0, 4, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeMossyCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 1, 3}, {0, 1, 6, 0, 1, 7}, {2, 1, 11, 2, 1, 11}, {6, 1, 9, 6, 1, 9}, {6, 1, 4, 6, 1, 6}, {6, 1, 1, 6, 1, 2}, {5, 1, 0, 5, 1, 0}, {1, 1, 0, 2, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneWallState, biomeMossyCobblestoneWallState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 2, 8, 1, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150333_U.func_176203_a(3), Blocks.field_150333_U.func_176203_a(3), false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 8, 1, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150435_aG.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), false);
            }
            for (int[] uvwo : new int[][]{{4, 1, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150390_bg.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePolishedAndesiteState = Blocks.field_150348_b.func_176203_a(6);
            for (int[] uvw : new int[][]{{4, 1, 3}}) {
                this.func_175811_a(world, biomePolishedAndesiteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeAndesiteState = Blocks.field_150348_b.func_176203_a(5);
            for (int[] uvw : new int[][]{{1, 1, 9}}) {
                this.func_175811_a(world, biomeAndesiteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeStoneBrickSlabLowerState = Blocks.field_150333_U.func_176203_a(5);
            for (int[] uuvvww : new int[][]{{2, 1, 5, 2, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickSlabLowerState, biomeStoneBrickSlabLowerState, false);
            }
            for (int[] uvw : new int[][]{{2, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150336_V.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState polishedDioriteState = Blocks.field_150348_b.func_176203_a(4);
            for (int[] uvw : new int[][]{{2, 1, 7}}) {
                this.func_175811_a(world, polishedDioriteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState concreteBlockState = Blocks.field_192443_dR.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 2, 4, 1}, {3, 4, 1, 3, 4, 1}, {4, 1, 1, 5, 4, 1}, {1, 1, 2, 1, 1, 7}, {1, 2, 3, 1, 3, 3}, {1, 2, 5, 1, 3, 5}, {1, 2, 7, 1, 3, 7}, {1, 4, 2, 1, 4, 7}, {5, 1, 2, 5, 1, 7}, {5, 2, 3, 5, 3, 3}, {5, 2, 5, 5, 3, 5}, {5, 2, 7, 5, 3, 7}, {5, 4, 2, 5, 4, 7}, {2, 1, 8, 2, 3, 9}, {3, 1, 9, 4, 3, 9}, {4, 3, 8, 4, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], concreteBlockState, concreteBlockState, false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{1, 2, 2, 1}, {1, 2, 4, 1}, {1, 2, 6, 1}, {5, 2, 2, 3}, {5, 2, 4, 3}, {5, 2, 6, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 3, 2, 1}, {1, 3, 4, 1}, {1, 3, 6, 1}, {5, 3, 2, 3}, {5, 3, 4, 3}, {5, 3, 6, 3}, {3, 3, 1, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 2, 4, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            this.func_175811_a(world, ModObjects.chooseModStonecutterState(2, this.func_186165_e()), 3, 1, 8, structureBB);
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 7, 4, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 7, 5, 5, 7}, {1, 5, 2, 1, 5, 6}, {5, 5, 2, 5, 5, 6}, {1, 5, 1, 5, 5, 1}, {3, 6, 3, 3, 6, 5}, {2, 4, 8, 4, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 4, 3}, {3, 3, 8}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}, {4, 1, 8, 1, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int chestU = 1;
            int chestV = 1;
            int chestW = 10;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_mason");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (Object uvwo : (ChestGenHooks)new int[][]{{0, 4, 2, 3}, {0, 4, 3, 3}, {0, 3, 3, 3}, {0, 2, 3, 3}, {0, 4, 5, 3}, {0, 3, 7, 3}, {0, 2, 7, 3}, {1, 3, 9, 3}, {1, 2, 9, 3}, {6, 3, 1, 1}, {6, 2, 1, 1}, {6, 4, 3, 1}, {6, 3, 3, 1}, {6, 2, 3, 1}, {6, 4, 5, 1}, {6, 3, 5, 1}, {6, 2, 5, 1}, {6, 4, 6, 1}, {6, 3, 7, 1}, {5, 3, 8, 1}, {5, 3, 9, 1}, {5, 2, 9, 1}, {5, 1, 9, 1}, {1, 4, 8, 0}, {1, 3, 8, 0}, {2, 3, 10, 0}, {2, 2, 10, 0}, {2, 1, 10, 0}, {3, 3, 10, 0}, {1, 4, 0, 2}, {1, 3, 0, 2}, {1, 2, 0, 2}, {2, 3, 0, 2}, {2, 2, 0, 2}, {5, 4, 0, 2}, {5, 3, 0, 2}, {5, 2, 0, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a((int)uvwo[0], (int)uvwo[2]), this.func_74862_a((int)uvwo[1]), this.func_74873_b((int)uvwo[0], (int)uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(20);
                int u = s <= 2 ? 2 : (s <= 8 ? 3 : (s <= 13 ? 4 : (s <= 16 ? 5 : s - 15)));
                int v = 2;
                int w = s <= 2 ? s - 2 : (s <= 8 ? s - 1 : (s <= 13 ? s - 5 : (s <= 16 ? s - 6 : 10)));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SwampLibrary
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFPPPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampLibrary() {
        }

        public SwampLibrary(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampLibrary buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampLibrary.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampLibrary(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState polishedGraniteState = Blocks.field_150348_b.func_176203_a(2);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 6, 1, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], polishedGraniteState, polishedGraniteState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 6, 3, 3, 6}, {3, 2, 8, 3, 3, 9}, {3, 4, 9, 3, 5, 9}, {6, 2, 3, 6, 3, 3}, {6, 2, 5, 6, 2, 6}, {6, 2, 8, 6, 2, 8}, {6, 2, 10, 6, 2, 10}, {6, 4, 10, 6, 4, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uvwo : new int[][]{{6, 3, 5, -1}, {6, 3, 8, -1}}) {
                this.func_175811_a(world, Blocks.field_150429_aA.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150348_b.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 3, 1, 2, 3}, {1, 4, 3, 1, 4, 3}, {1, 3, 8, 1, 4, 8}, {7, 2, 5, 7, 3, 5}, {7, 3, 8, 7, 4, 8}, {1, 3, 2, 1, 4, 2}, {3, 5, 2, 3, 5, 2}, {5, 5, 2, 5, 5, 2}, {7, 3, 2, 7, 4, 2}, {3, 2, 11, 3, 2, 11}, {3, 4, 11, 3, 5, 11}, {5, 2, 11, 5, 3, 11}, {6, 4, 11, 6, 4, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneState, biomeStoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {1, 2, 5, 1, 3, 5}, {1, 4, 6, 1, 4, 6}, {1, 1, 7, 1, 1, 7}, {1, 3, 7, 1, 4, 7}, {1, 2, 8, 1, 2, 8}, {1, 1, 9, 1, 1, 9}, {1, 2, 10, 1, 4, 10}, {7, 1, 3, 7, 4, 3}, {7, 1, 5, 7, 1, 5}, {7, 4, 5, 7, 4, 5}, {7, 3, 6, 7, 4, 6}, {7, 1, 7, 7, 2, 7}, {7, 1, 8, 7, 2, 8}, {7, 2, 10, 7, 4, 10}, {1, 1, 2, 1, 2, 2}, {2, 2, 2, 2, 5, 2}, {3, 1, 2, 3, 3, 2}, {4, 1, 2, 4, 1, 2}, {4, 4, 2, 4, 5, 2}, {5, 2, 2, 5, 3, 2}, {6, 2, 2, 6, 5, 2}, {7, 1, 2, 7, 2, 2}, {1, 1, 11, 1, 4, 11}, {2, 1, 11, 2, 1, 11}, {2, 5, 11, 2, 5, 11}, {3, 3, 11, 3, 3, 11}, {5, 1, 11, 5, 1, 11}, {5, 4, 11, 5, 5, 11}, {7, 1, 11, 7, 4, 11}, {2, 5, 5, 2, 5, 5}, {2, 5, 8, 2, 5, 8}, {6, 5, 5, 6, 5, 5}, {6, 5, 8, 6, 5, 8}, {0, 1, 2, 0, 1, 2}, {0, 1, 11, 0, 1, 11}, {4, 1, 12, 4, 1, 12}, {7, 1, 12, 7, 1, 12}, {7, 1, 1, 7, 1, 1}, {8, 1, 2, 8, 1, 2}, {8, 1, 11, 8, 1, 11}, {3, 6, 5, 5, 6, 5}, {3, 6, 8, 5, 6, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 1, 1, 5}, {1, 4, 5, 1, 4, 5}, {1, 1, 6, 1, 3, 6}, {1, 2, 7, 1, 2, 7}, {1, 1, 8, 1, 1, 8}, {1, 1, 10, 1, 1, 10}, {1, 1, 10, 1, 1, 10}, {7, 1, 4, 7, 1, 4}, {7, 1, 6, 7, 2, 6}, {7, 3, 7, 7, 4, 7}, {7, 1, 9, 7, 1, 10}, {2, 1, 2, 2, 1, 2}, {4, 6, 2, 4, 6, 2}, {6, 1, 2, 6, 1, 2}, {3, 1, 11, 4, 1, 11}, {4, 6, 11, 4, 6, 11}, {6, 1, 11, 6, 1, 11}, {6, 5, 11, 6, 5, 11}, {1, 1, 1, 1, 1, 1}, {0, 1, 5, 0, 1, 5}, {0, 1, 8, 0, 1, 8}, {1, 1, 12, 1, 1, 12}, {8, 1, 5, 8, 1, 5}, {8, 1, 8, 8, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 8, 0, 12}, {0, 0, 0, 2, 0, 0}, {6, 0, 0, 8, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{2, 6, 11, 0}, {3, 6, 11, 1}, {3, 7, 11, 2}, {4, 7, 12, 6}, {4, 7, 11, 3}, {5, 7, 11, 2}, {5, 6, 11, 0}, {6, 6, 11, 1}, {2, 6, 8, 0}, {6, 6, 8, 1}, {2, 6, 5, 0}, {6, 6, 5, 1}, {2, 6, 2, 0}, {3, 6, 2, 1}, {3, 7, 2, 3}, {4, 7, 1, 7}, {4, 7, 2, 2}, {5, 7, 2, 3}, {5, 6, 2, 0}, {6, 6, 2, 1}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {1, 5, 6, 0}, {1, 5, 7, 0}, {1, 5, 8, 0}, {1, 5, 9, 0}, {1, 5, 10, 0}, {1, 5, 11, 0}, {7, 5, 2, 1}, {7, 5, 3, 1}, {7, 5, 4, 1}, {7, 5, 5, 1}, {7, 5, 6, 1}, {7, 5, 7, 1}, {7, 5, 8, 1}, {7, 5, 9, 1}, {7, 5, 10, 1}, {7, 5, 11, 1}, {2, 4, 8, 5}, {3, 5, 8, 5}, {5, 5, 8, 4}, {6, 4, 8, 4}, {2, 4, 5, 5}, {3, 5, 5, 5}, {5, 5, 5, 4}, {6, 4, 5, 4}, {7, 2, 4, 0}, {7, 4, 4, 4}, {7, 2, 9, 0}, {7, 4, 9, 4}, {1, 2, 4, 1}, {1, 4, 4, 5}, {1, 2, 9, 1}, {1, 4, 9, 5}, {2, 2, 11, 3}, {2, 4, 11, 7}, {4, 2, 11, 3}, {4, 5, 11, 7}, {6, 2, 11, 3}, {6, 4, 11, 7}, {0, 2, 11, 4}, {0, 3, 11, 0}, {0, 2, 8, 4}, {0, 3, 8, 0}, {0, 2, 5, 4}, {0, 3, 5, 0}, {0, 2, 2, 4}, {0, 3, 2, 0}, {1, 2, 1, 7}, {1, 3, 1, 3}, {7, 2, 1, 7}, {7, 3, 1, 3}, {8, 2, 11, 5}, {8, 3, 11, 1}, {8, 2, 8, 5}, {8, 3, 8, 1}, {8, 2, 5, 5}, {8, 3, 5, 1}, {8, 2, 2, 5}, {8, 3, 2, 1}, {1, 2, 12, 6}, {1, 3, 12, 2}, {4, 2, 12, 6}, {4, 3, 12, 2}, {7, 2, 12, 6}, {7, 3, 12, 2}, {3, 1, 1, 7}, {4, 1, 1, 3}, {5, 1, 1, 7}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 7, 8, 5, 7, 8}, {3, 7, 5, 5, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 4, 1, 3}, {2, 5, 3, 5}, {2, 5, 4, 5}, {2, 5, 6, 5}, {2, 5, 7, 5}, {2, 5, 9, 5}, {2, 5, 10, 5}, {6, 5, 3, 4}, {6, 5, 4, 4}, {6, 5, 6, 4}, {6, 5, 7, 4}, {6, 5, 9, 4}, {6, 5, 10, 4}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 6, 3, 4, 6, 4}, {4, 6, 6, 4, 6, 7}, {4, 6, 9, 4, 6, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 3, 3, 6, 4}, {3, 6, 6, 3, 6, 7}, {3, 6, 9, 3, 6, 10}, {5, 6, 3, 5, 6, 4}, {5, 6, 6, 5, 6, 7}, {5, 6, 9, 5, 6, 10}, {3, 4, 1, 3, 4, 1}, {5, 4, 1, 5, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 2, 1}, {3, 3, 1}, {5, 2, 1}, {5, 3, 1}, {3, 2, 3}, {3, 2, 4}, {3, 4, 6}, {3, 5, 6}, {6, 3, 6}, {6, 4, 6}, {3, 4, 8}, {3, 5, 10}, {6, 3, 10}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{3, 2, 5}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(1, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 5, 5}, {4, 5, 8}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 3, 3, 3, 3, 3, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {3, 3, 4, 3, 3, 4, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvwc : new int[][]{{3, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {5, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 15}, {1, 3, 4, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {1, 3, 9, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {7, 3, 4, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {7, 3, 9, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {2, 3, 11, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {4, 3, 11, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {4, 4, 11, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {6, 3, 11, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                this.func_175811_a(world, Blocks.field_150397_co.func_176203_a(uvwc[3]), uvwc[0], uvwc[1], uvwc[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 2, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{6, 2, 4, 3}, {6, 2, 7, 3}}) {
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState), -1);
            }
            int chestU = 2;
            int chestV = 2;
            int chestW = 3;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_library");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (Object uvwo : (ChestGenHooks)new int[][]{{0, 4, 3, 3}, {0, 3, 3, 3}, {0, 2, 3, 3}, {0, 1, 3, 3}, {0, 4, 9, 3}, {0, 3, 8, 3}, {0, 2, 8, 3}, {0, 1, 8, 3}, {8, 4, 2, 1}, {8, 4, 3, 1}, {8, 3, 3, 1}, {8, 2, 3, 1}, {8, 1, 3, 1}, {8, 2, 4, 1}, {8, 4, 6, 1}, {8, 3, 6, 1}, {8, 2, 6, 1}, {8, 1, 6, 1}, {8, 3, 7, 1}, {8, 2, 7, 1}, {8, 4, 8, 1}, {8, 1, 9, 1}, {8, 4, 10, 1}, {8, 3, 10, 1}, {8, 2, 10, 1}, {8, 1, 10, 1}, {2, 5, 12, 0}, {2, 4, 12, 0}, {5, 4, 12, 0}, {5, 3, 12, 0}, {5, 2, 12, 0}, {6, 5, 12, 0}, {6, 4, 12, 0}, {6, 2, 12, 0}, {6, 1, 12, 0}, {1, 4, 1, 2}, {2, 4, 1, 2}, {2, 3, 1, 2}, {2, 2, 1, 2}, {2, 1, 1, 2}, {6, 4, 1, 2}, {6, 3, 1, 2}, {6, 2, 1, 2}, {6, 1, 1, 2}, {7, 4, 1, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a((int)uvwo[0], (int)uvwo[2]), this.func_74862_a((int)uvwo[1]), this.func_74873_b((int)uvwo[0], (int)uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(25);
                int u = s <= 5 ? 2 : (s <= 7 ? 3 : (s <= 15 ? 4 : (s <= 23 ? 5 : 6)));
                int v = 2;
                int w = s <= 1 ? s + 4 : (s <= 5 ? s + 5 : (s <= 6 ? 7 : (s <= 7 ? 10 : (s <= 15 ? s - 5 : (s <= 23 ? s - 13 : 9)))));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class SwampLargeHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", " FF    FF", "  F   FF ", "   FFF   ", "   FFF   ", "   FFF   ", "  FFFFFF ", " FFFFFF F", " F FFFF  ", "F FFFFFF ", "   FFFF  ", "    FF   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 14;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampLargeHouse() {
        }

        public SwampLargeHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampLargeHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)14, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampLargeHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampLargeHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 9, 2, 1, 9}, {6, 0, 9, 6, 1, 9}, {7, 0, 9, 7, 0, 9}, {2, 0, 5, 2, 1, 5}, {6, 0, 5, 6, 1, 5}, {3, 0, 6, 3, 5, 8}, {4, 0, 6, 4, 2, 7}, {4, 0, 8, 4, 8, 8}, {5, 0, 6, 5, 5, 8}, {4, 0, 8, 4, 2, 8}, {4, 5, 6, 4, 5, 6}, {3, 13, 6, 5, 13, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{1, 0, 10, 1, 0, 10}, {8, 0, 10, 8, 0, 10}, {7, 0, 5, 7, 0, 5}, {8, 0, 4, 8, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{2, 0, 10, 2, 0, 10}, {7, 0, 10, 7, 0, 10}, {0, 0, 2, 0, 0, 2}, {1, 0, 3, 1, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 5, 3, 11, 5}, {4, 8, 5, 4, 8, 5}, {4, 11, 5, 4, 11, 5}, {5, 6, 5, 5, 11, 5}, {2, 6, 6, 2, 11, 6}, {2, 6, 7, 2, 6, 7}, {2, 9, 7, 2, 9, 7}, {2, 11, 7, 2, 11, 7}, {2, 6, 8, 2, 11, 8}, {6, 6, 6, 6, 11, 6}, {6, 6, 7, 6, 6, 7}, {6, 9, 7, 6, 9, 7}, {6, 11, 7, 6, 11, 7}, {6, 6, 8, 6, 11, 8}, {3, 6, 9, 5, 9, 9}, {3, 10, 9, 3, 11, 9}, {4, 11, 9, 4, 11, 9}, {5, 10, 9, 5, 11, 9}, {3, 8, 8, 3, 8, 8}, {2, 12, 5, 6, 12, 5}, {2, 12, 6, 2, 12, 8}, {6, 12, 6, 6, 12, 8}, {2, 12, 9, 6, 12, 9}, {0, 11, 5, 0, 11, 5}, {2, 11, 3, 2, 11, 3}, {6, 11, 3, 6, 11, 3}, {8, 11, 5, 8, 11, 5}, {0, 11, 9, 0, 11, 9}, {2, 11, 11, 2, 11, 11}, {6, 11, 11, 6, 11, 11}, {8, 11, 9, 8, 11, 9}, {0, 8, 5, 0, 8, 5}, {2, 8, 3, 2, 8, 3}, {6, 8, 3, 6, 8, 3}, {8, 8, 5, 8, 8, 5}, {0, 8, 9, 0, 8, 9}, {2, 8, 11, 2, 8, 11}, {6, 8, 11, 6, 8, 11}, {8, 8, 9, 8, 8, 9}, {0, 5, 9, 1, 5, 9}, {2, 4, 9, 2, 4, 9}, {6, 4, 9, 6, 4, 9}, {7, 5, 9, 8, 5, 9}, {0, 5, 5, 1, 5, 5}, {2, 4, 5, 2, 4, 5}, {6, 4, 5, 6, 4, 5}, {7, 5, 5, 8, 5, 5}, {3, 0, 1, 5, 0, 5}, {5, 2, 4, 5, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 0, 0, 3}, {5, 1, 2, 3}, {5, 2, 3, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 2, 5, 5, 2, 5}, {4, 2, 4, 4, 2, 4}, {5, 1, 3, 5, 1, 3}, {0, 5, 6, 0, 5, 8}, {1, 5, 4, 1, 5, 4}, {1, 5, 6, 1, 5, 8}, {1, 5, 10, 1, 5, 10}, {2, 5, 3, 2, 5, 11}, {3, 5, 3, 5, 5, 5}, {3, 5, 9, 5, 5, 11}, {6, 5, 3, 6, 5, 11}, {7, 5, 4, 7, 5, 4}, {7, 5, 6, 7, 5, 8}, {7, 5, 10, 7, 5, 10}, {8, 5, 6, 8, 5, 8}, {0, 8, 6, 0, 8, 8}, {1, 8, 4, 1, 8, 10}, {2, 8, 4, 2, 8, 5}, {2, 8, 9, 2, 8, 10}, {3, 8, 3, 5, 8, 4}, {3, 8, 10, 5, 8, 11}, {6, 8, 4, 6, 8, 5}, {6, 8, 9, 6, 8, 10}, {7, 8, 4, 7, 8, 10}, {8, 8, 6, 8, 8, 8}, {3, 8, 6, 3, 8, 7}, {4, 8, 6, 4, 8, 6}, {5, 8, 6, 5, 8, 8}, {1, 11, 10, 7, 11, 10}, {1, 11, 5, 1, 11, 9}, {7, 11, 5, 7, 11, 9}, {1, 11, 4, 7, 11, 4}, {2, 11, 5, 2, 11, 5}, {6, 11, 5, 6, 11, 5}, {2, 11, 9, 2, 11, 9}, {6, 11, 9, 6, 11, 9}, {3, 11, 3, 5, 11, 3}, {0, 11, 6, 0, 11, 8}, {8, 11, 6, 8, 11, 8}, {3, 11, 11, 5, 11, 11}, {1, 4, 9, 1, 4, 9}, {7, 4, 9, 7, 4, 9}, {1, 4, 5, 1, 4, 5}, {7, 4, 5, 7, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 12, 10, 6, 12, 10}, {1, 12, 5, 1, 12, 9}, {7, 12, 5, 7, 12, 9}, {2, 12, 4, 6, 12, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 4}, {6, 0, 4}, {2, 0, 2}, {6, 0, 2}, {3, 1, 4}, {3, 2, 4}, {3, 3, 4}, {4, 3, 4}, {3, 3, 5}, {0, 6, 4}, {0, 6, 5}, {0, 6, 6}, {0, 6, 7}, {0, 6, 8}, {0, 6, 9}, {0, 6, 10}, {1, 6, 10}, {1, 6, 11}, {2, 6, 11}, {3, 6, 11}, {4, 6, 11}, {5, 6, 11}, {6, 6, 11}, {7, 6, 11}, {7, 6, 10}, {8, 6, 10}, {8, 6, 9}, {8, 6, 8}, {8, 6, 7}, {8, 6, 6}, {8, 6, 5}, {8, 6, 4}, {7, 6, 4}, {7, 6, 3}, {6, 6, 3}, {5, 6, 3}, {4, 6, 3}, {3, 6, 3}, {2, 6, 3}, {1, 6, 3}, {1, 6, 4}, {0, 7, 5}, {0, 7, 9}, {2, 7, 3}, {6, 7, 3}, {2, 7, 11}, {6, 7, 11}, {8, 7, 5}, {8, 7, 9}, {0, 9, 4}, {0, 9, 5}, {0, 9, 6}, {0, 9, 7}, {0, 9, 8}, {0, 9, 9}, {0, 9, 10}, {1, 9, 10}, {1, 9, 11}, {2, 9, 11}, {3, 9, 11}, {4, 9, 11}, {5, 9, 11}, {6, 9, 11}, {7, 9, 11}, {7, 9, 10}, {8, 9, 10}, {8, 9, 9}, {8, 9, 8}, {8, 9, 7}, {8, 9, 6}, {8, 9, 5}, {8, 9, 4}, {7, 9, 4}, {7, 9, 3}, {6, 9, 3}, {5, 9, 3}, {4, 9, 3}, {3, 9, 3}, {2, 9, 3}, {1, 9, 3}, {1, 9, 4}, {0, 10, 5}, {0, 10, 9}, {2, 10, 3}, {6, 10, 3}, {2, 10, 11}, {6, 10, 11}, {8, 10, 5}, {8, 10, 9}, {4, 12, 7}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 11, 7}, {3, 7, 8}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{2, 2, 9}, {6, 2, 5}, {1, 7, 10}, {7, 7, 4}, {7, 10, 10}, {1, 10, 4}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 9, 5, 2, 1, 0}, {4, 6, 5, 2, 1, 0}, {4, 3, 6, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 10, 7, 1}, {4, 10, 9, 2}, {6, 10, 7, 3}, {2, 7, 7, 1}, {6, 7, 7, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 11, 7, 1}, {4, 11, 9, 2}, {6, 11, 7, 3}, {2, 8, 7, 1}, {6, 8, 7, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{4, 3, 7, 4, 8, 7, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            for (int[] uvwoc : new int[][]{{5, 6, 7, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {3, 9, 7, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            int chestU = 3;
            int chestV = 6;
            int chestW = 8;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{2, 13, 6, 3}, {-1, 11, 9, 3}, {-1, 10, 9, 3}, {-1, 9, 9, 3}, {2, 10, 9, 3}, {2, 9, 9, 3}, {2, 7, 9, 3}, {6, 13, 6, 1}, {7, 7, 6, 1}, {7, 6, 6, 1}, {6, 4, 6, 1}, {6, 3, 6, 1}, {6, 3, 7, 1}, {6, 2, 7, 1}, {6, 3, 8, 1}, {6, 2, 8, 1}, {6, 11, 12, 0}, {6, 10, 12, 0}, {6, 9, 12, 0}, {6, 8, 12, 0}, {6, 7, 12, 0}, {3, 7, 10, 0}, {4, 7, 10, 0}, {4, 6, 10, 0}, {5, 2, 9, 0}, {5, 1, 9, 0}, {4, 2, 9, 0}, {4, 1, 9, 0}, {3, 1, 9, 0}, {3, 0, 9, 0}, {3, 13, 5, 2}, {5, 13, 5, 2}, {2, 10, 5, 2}, {2, 8, 2, 2}, {2, 7, 2, 2}, {2, 6, 2, 2}, {6, 11, 2, 2}, {6, 10, 2, 2}, {6, 9, 2, 2}, {6, 8, 2, 2}, {6, 7, 2, 2}, {6, 6, 2, 2}, {6, 7, 5, 2}, {6, 6, 5, 2}, {5, 4, 5, 2}, {5, 3, 5, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{5, 6, 6, -1, 0}, {3, 9, 6, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var29_66;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var29_66 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampHutFarm
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"     FFFFFFFF", "     FFFFFFFF", " FFFFFFFFFFFF", " FFFFFFFFFFFF", " FFFFFFFFFFFF", " FFFFFFFFFFFF", " FFFFFFFFFFFF", "   F FFFFFFFF", "   F FFFFFFFF", "   F         ", "   F         "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 7;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampHutFarm() {
        }

        public SwampHutFarm(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampHutFarm buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampHutFarm.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampHutFarm(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{7, 0, 7, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 7, 0, 7})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{4, 1, 10}, {12, 1, 10}, {12, 1, 2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (Object uuvvww : (Random)new int[][]{{1, 1, 8, 1, 5, 8}, {5, 1, 8, 5, 5, 8}, {1, 1, 4, 1, 5, 4}, {5, 1, 4, 5, 5, 4}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (Object uuvvww : (Random)new int[][]{{2, 4, 8, 2, 5, 8}, {3, 4, 8, 3, 4, 8}, {4, 4, 8, 4, 5, 8}, {1, 4, 5, 1, 5, 5}, {1, 4, 6, 1, 4, 6}, {1, 4, 7, 1, 5, 7}, {5, 4, 5, 5, 5, 5}, {5, 4, 6, 5, 4, 6}, {5, 4, 7, 5, 5, 7}, {2, 4, 4, 2, 5, 4}, {4, 4, 4, 4, 5, 4}}) {
                this.func_175804_a(world, structureBB, (int)uuvvww[0], (int)uuvvww[1], (int)uuvvww[2], (int)uuvvww[3], (int)uuvvww[4], (int)uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 1, 1, 3}, {3, 2, 2, 3}, {3, 3, 3, 3}, {3, 1, 2, 6}, {3, 2, 3, 6}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 8, 2, 3, 8}, {4, 3, 8, 4, 3, 8}, {1, 3, 7, 5, 3, 7}, {2, 3, 6, 4, 3, 6}, {1, 3, 5, 5, 3, 5}, {2, 3, 4, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 5, 8}, {1, 5, 6}, {5, 5, 6}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 4, 1, 0, 8}, {2, 0, 4, 2, 0, 4}, {2, 0, 8, 2, 0, 8}, {3, 0, 0, 3, 0, 3}, {5, 0, 2, 5, 0, 4}, {4, 0, 9, 5, 0, 10}, {6, 0, 8, 6, 0, 8}, {7, 0, 5, 7, 0, 5}, {7, 0, 7, 7, 0, 7}, {9, 0, 5, 9, 0, 5}, {11, 0, 3, 11, 0, 3}, {11, 0, 9, 11, 0, 9}, {9, 0, 10, 10, 0, 10}, {8, 0, 2, 12, 0, 2}, {12, 0, 2, 12, 0, 2}, {12, 0, 6, 12, 0, 7}, {1, 6, 8, 4, 6, 8}, {1, 6, 6, 1, 6, 7}, {5, 6, 5, 5, 6, 7}, {2, 6, 4, 4, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 4, 4, 0, 4}, {3, 0, 8, 4, 0, 8}, {6, 0, 2, 7, 0, 2}, {6, 0, 4, 6, 0, 4}, {6, 0, 10, 8, 0, 10}, {7, 0, 7, 7, 0, 7}, {8, 0, 8, 8, 0, 8}, {8, 0, 4, 8, 0, 4}, {9, 0, 7, 9, 0, 7}, {10, 0, 3, 10, 0, 5}, {10, 0, 8, 10, 0, 10}, {11, 0, 10, 11, 0, 10}, {12, 0, 3, 12, 0, 5}, {12, 0, 8, 12, 0, 10}, {5, 6, 4, 5, 6, 4}, {5, 6, 8, 5, 6, 8}, {1, 6, 4, 1, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 6, 9, 4, 6, 9}, {0, 6, 6, 0, 6, 8}, {6, 6, 4, 6, 6, 4}, {6, 6, 7, 6, 6, 8}, {1, 6, 3, 6, 6, 3}, {3, 7, 5, 4, 7, 5}, {4, 7, 6, 4, 7, 6}, {2, 7, 7, 4, 7, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{5, 6, 9, 6, 6, 9}, {0, 6, 3, 0, 6, 5}, {6, 6, 5, 6, 6, 6}, {2, 7, 5, 2, 7, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabUpperState = ModObjects.chooseModMossyCobblestoneSlabState(true);
            biomeMossyCobblestoneSlabUpperState = biomeMossyCobblestoneSlabUpperState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabUpperState, this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(11), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 7, 6, 3, 7, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabUpperState, biomeMossyCobblestoneSlabUpperState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 5, 3, 0, 7}, {8, 0, 6, 8, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            Block[] cropPair1 = StructureVillageVN.chooseCropPair(random);
            Block[] cropPair2 = StructureVillageVN.chooseCropPair(random);
            for (int[] uvwfcp : new int[][]{{6, 0, 5, 7, 0, random.nextInt(3)}, {6, 0, 6, 7, 0, random.nextInt(3)}, {6, 0, 7, 7, 0, random.nextInt(3)}, {7, 0, 6, 7, 0, random.nextInt(3)}, {9, 0, 6, 7, 1, random.nextInt(3)}, {10, 0, 5, 7, 1, random.nextInt(3)}, {10, 0, 6, 7, 1, random.nextInt(3)}, {10, 0, 7, 7, 1, random.nextInt(3)}, {11, 0, 4, 7, 1, random.nextInt(3)}, {11, 0, 5, 7, 1, random.nextInt(3)}, {11, 0, 6, 7, 1, random.nextInt(3)}, {11, 0, 7, 7, 1, random.nextInt(3)}, {11, 0, 8, 7, 1, random.nextInt(3)}, {8, 0, 5, 7, 2, random.nextInt(3)}, {7, 0, 4, 7, 2, random.nextInt(3)}, {8, 0, 4, 7, 2, random.nextInt(3)}, {9, 0, 4, 7, 2, random.nextInt(3)}, {6, 0, 3, 7, 2, random.nextInt(3)}, {7, 0, 3, 7, 2, random.nextInt(3)}, {8, 0, 3, 7, 2, random.nextInt(3)}, {9, 0, 3, 7, 2, random.nextInt(3)}, {10, 0, 3, 7, 2, random.nextInt(3)}, {8, 0, 7, 7, 3, random.nextInt(3)}, {7, 0, 8, 7, 3, random.nextInt(3)}, {8, 0, 8, 7, 3, random.nextInt(3)}, {9, 0, 8, 7, 3, random.nextInt(3)}, {6, 0, 9, 7, 3, random.nextInt(3)}, {7, 0, 9, 7, 3, random.nextInt(3)}, {8, 0, 9, 7, 3, random.nextInt(3)}, {9, 0, 9, 7, 3, random.nextInt(3)}, {10, 0, 9, 7, 3, random.nextInt(3)}}) {
                IBlockState cropState;
                int cropProgressMeta = uvwfcp[5];
                while (true) {
                    try {
                        cropState = (uvwfcp[4] / 2 == 0 ? cropPair1 : cropPair2)[uvwfcp[4] % 2].func_176203_a(cropProgressMeta);
                    }
                    catch (IllegalArgumentException e) {
                        if (cropProgressMeta == 0) {
                            cropState = Blocks.field_150464_aj.func_176203_a(uvwfcp[5]);
                            break;
                        }
                        cropProgressMeta /= 2;
                        continue;
                    }
                    break;
                }
                this.func_175811_a(world, cropState, uvwfcp[0], uvwfcp[1] + 1, uvwfcp[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwfcp[3]), uvwfcp[0], uvwfcp[1], uvwfcp[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, 5}, {3, 1, 7}, {8, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150392_bi.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 5, 2, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 5, 2, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150436_aH.func_176223_P(), Blocks.field_150436_aH.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{4, 1, 5}, {4, 1, 6}, {4, 1, 7}}) {
                this.func_175811_a(world, Blocks.field_150423_aK.func_176203_a(random.nextInt(3)), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{5, 1, 5}, {5, 1, 6}, {5, 1, 7}}) {
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150393_bb.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                for (int[] uvw : new int[][]{{5, 1, 2}}) {
                    this.func_175811_a(world, compostBinState, uvw[0], uvw[1], uvw[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 4, 6}, {2, 4, 7}, {2, 5, 7}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 4, 7}}) {
                this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(Blocks.field_150407_cf.func_176203_a(0), this.func_186165_e().func_176736_b(), false), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 6, 5, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 3, 8}, {1, 3, 6}, {5, 3, 6}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 4;
            int chestV = 4;
            int chestW = 5;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_farm");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 8;
                int v = 1;
                int w = 6;
                while (u == 8 && w == 6 || u >= 11 && w >= 9 || u >= 11 && w <= 3) {
                    u = 6 + random.nextInt(7);
                    w = 2 + random.nextInt(9);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampHorribleSecret
    extends StructureVillageVN.VNComponent {
        public static final int STRUCTURE_WIDTH = 8;
        public static final int STRUCTURE_DEPTH = 8;
        public static final int STRUCTURE_HEIGHT = 28;
        private static final int GROUND_LEVEL = 22;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampHorribleSecret() {
        }

        public SwampHorribleSecret(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampHorribleSecret buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)8, (int)28, (int)8, (EnumFacing)coordBaseMode);
            return SwampHorribleSecret.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampHorribleSecret(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            int z;
            int y;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel <= 28 + 5) {
                    return true;
                }
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 22, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < 8; ++u) {
                for (int w = 0; w < 8; ++w) {
                    this.func_74871_b(world, u, 22, w, structureBB);
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{4, 22, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{3, 21, 6, 5, 21, 6}, {2, 21, 5, 6, 21, 5}, {1, 21, 3, 7, 21, 4}, {1, 21, 2, 2, 21, 2}, {6, 21, 2, 7, 21, 2}, {2, 21, 1, 6, 21, 1}, {3, 21, 0, 5, 21, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 0, 5, 20, 0}, {0, 1, 1, 6, 9, 7}, {7, 1, 2, 7, 20, 4}, {2, 10, 1, 6, 20, 1}, {1, 10, 2, 7, 20, 4}, {2, 10, 5, 6, 20, 5}, {3, 10, 6, 5, 20, 6}}) {
                this.func_74878_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5]);
            }
            for (int[] uuvvww : new int[][]{{3, 21, 2, 5, 21, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150346_d.func_176203_a(1), Blocks.field_150346_d.func_176203_a(1), false);
            }
            for (int[] uuvvww : new int[][]{{3, 19, 6, 5, 20, 6}, {2, 19, 5, 6, 20, 5}, {1, 19, 2, 2, 20, 4}, {6, 19, 2, 7, 20, 4}, {2, 19, 1, 6, 20, 1}, {3, 19, 0, 5, 20, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 0, 5, 18, 0}, {2, 10, 1, 6, 18, 1}, {1, 10, 2, 1, 18, 4}, {2, 10, 2, 2, 18, 5}, {7, 0, 2, 7, 18, 4}, {6, 10, 2, 6, 18, 5}, {3, 10, 5, 5, 18, 6}, {0, 0, 2, 2, 9, 2}, {0, 0, 1, 0, 9, 7}, {1, 0, 3, 1, 9, 3}, {1, 0, 4, 1, 1, 7}, {1, 2, 5, 1, 2, 7}, {1, 3, 4, 1, 5, 7}, {3, 0, 2, 6, 0, 2}, {4, 1, 2, 6, 2, 2}, {3, 3, 2, 6, 6, 2}, {2, 7, 3, 2, 9, 3}, {6, 7, 2, 6, 9, 7}, {6, 6, 3, 6, 6, 3}, {6, 6, 5, 6, 6, 7}, {6, 0, 3, 6, 5, 7}, {1, 6, 7, 5, 9, 7}, {1, 9, 4, 2, 9, 6}, {3, 9, 5, 5, 9, 6}, {5, 9, 4, 5, 9, 4}, {3, 7, 2, 3, 7, 2}, {3, 8, 4, 3, 8, 4}, {5, 10, 2, 5, 10, 2}, {3, 11, 2, 3, 11, 2}, {3, 12, 4, 3, 12, 4}, {5, 13, 4, 5, 13, 4}, {5, 14, 2, 5, 14, 2}, {3, 15, 2, 3, 15, 2}, {3, 16, 4, 3, 16, 4}, {5, 17, 4, 5, 17, 4}, {5, 18, 2, 5, 18, 2}, {4, 7, 3, 4, 20, 3}, {1, 0, 1, 6, 9, 1}, {2, 0, 7, 5, 5, 7}, {2, 0, 6, 2, 5, 6}, {3, 0, 6, 3, 2, 6}, {3, 4, 6, 3, 5, 6}, {4, 0, 6, 5, 5, 6}, {5, 0, 3, 5, 5, 3}, {5, 0, 4, 5, 3, 4}, {5, 5, 4, 5, 5, 4}, {5, 0, 5, 5, 5, 5}, {2, 0, 3, 4, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{3, 18, 6}, {4, 18, 6}, {5, 18, 6}, {2, 18, 5}, {3, 18, 5}, {4, 18, 5}, {5, 18, 5}, {6, 18, 5}, {1, 18, 4}, {2, 18, 4}, {6, 18, 4}, {7, 18, 4}, {1, 18, 3}, {2, 18, 3}, {6, 18, 3}, {7, 18, 3}, {1, 18, 2}, {2, 18, 2}, {6, 18, 2}, {7, 18, 2}, {2, 18, 1}, {3, 18, 1}, {4, 18, 1}, {5, 18, 1}, {6, 18, 1}, {3, 18, 0}, {4, 18, 0}, {5, 18, 0}, {3, 17, 6}, {4, 17, 6}, {5, 17, 6}, {2, 17, 5}, {3, 17, 5}, {4, 17, 5}, {5, 17, 5}, {6, 17, 5}, {1, 17, 4}, {2, 17, 4}, {6, 17, 4}, {7, 17, 4}, {1, 17, 2}, {2, 17, 2}, {6, 17, 2}, {7, 17, 2}, {2, 17, 1}, {3, 17, 1}, {4, 17, 1}, {5, 17, 1}, {6, 17, 1}, {3, 17, 0}, {4, 17, 0}, {5, 17, 0}, {3, 16, 6}, {5, 16, 6}, {2, 16, 5}, {3, 16, 5}, {5, 16, 5}, {6, 16, 5}, {1, 16, 4}, {2, 16, 4}, {1, 16, 3}, {2, 16, 3}, {6, 16, 3}, {7, 16, 3}, {6, 16, 2}, {7, 16, 2}, {2, 16, 1}, {3, 16, 1}, {4, 16, 1}, {6, 16, 1}, {3, 16, 0}, {4, 16, 0}, {3, 18, 6}, {4, 15, 6}, {2, 15, 5}, {3, 15, 5}, {4, 15, 5}, {6, 15, 5}, {6, 15, 4}, {7, 15, 4}, {1, 15, 3}, {2, 15, 3}, {6, 15, 3}, {7, 15, 3}, {1, 15, 2}, {2, 15, 2}, {6, 15, 2}, {7, 15, 2}, {3, 15, 1}, {4, 15, 1}, {5, 15, 1}, {3, 15, 0}, {4, 15, 0}, {5, 15, 0}, {4, 14, 6}, {5, 14, 6}, {2, 14, 5}, {4, 14, 5}, {5, 14, 5}, {6, 14, 4}, {7, 14, 4}, {1, 14, 3}, {2, 14, 3}, {6, 14, 2}, {7, 14, 2}, {2, 14, 1}, {4, 14, 1}, {6, 14, 1}, {4, 14, 0}, {5, 13, 6}, {2, 13, 5}, {5, 13, 5}, {1, 13, 4}, {2, 13, 4}, {6, 13, 4}, {7, 13, 4}, {1, 13, 2}, {2, 13, 2}, {6, 13, 2}, {7, 13, 2}, {3, 13, 1}, {6, 13, 1}, {3, 13, 0}, {3, 12, 6}, {3, 12, 5}, {6, 12, 5}, {1, 12, 4}, {2, 12, 4}, {6, 12, 2}, {7, 12, 2}, {2, 12, 1}, {5, 12, 1}, {5, 12, 0}, {3, 11, 6}, {3, 11, 5}, {6, 11, 5}, {1, 11, 3}, {2, 11, 3}, {6, 11, 2}, {7, 11, 2}, {3, 11, 1}, {3, 11, 0}, {4, 10, 6}, {4, 10, 5}, {1, 10, 4}, {2, 10, 4}, {6, 10, 4}, {7, 10, 4}, {3, 10, 1}, {5, 10, 1}, {3, 10, 0}, {5, 10, 0}, {6, 9, 2}, {7, 9, 2}, {2, 8, 7}, {4, 8, 7}, {6, 8, 6}, {1, 6, 3}, {0, 6, 6}, {1, 6, 7}, {5, 6, 7}, {1, 5, 6}, {2, 5, 6}, {2, 0, 3}, {4, 0, 3}, {4, 18, 3}, {4, 16, 3}, {4, 12, 3}, {4, 7, 3}}) {
                this.func_175811_a(world, biomeMossyCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 20, 2, 1}, {4, 19, 2, 1}, {5, 18, 3, 2}, {4, 17, 4, 0}, {3, 16, 3, 3}, {4, 15, 2, 1}, {5, 14, 3, 2}, {4, 13, 4, 0}, {3, 12, 3, 3}, {4, 11, 2, 1}, {5, 10, 3, 2}, {4, 9, 4, 0}, {3, 8, 3, 3}, {4, 7, 2, 1}, {5, 6, 3, 2}, {4, 16, 4, 5}, {4, 14, 2, 4}, {5, 13, 3, 7}, {3, 11, 3, 6}, {4, 10, 2, 4}, {5, 9, 3, 7}, {4, 8, 4, 5}, {3, 7, 3, 6}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeMossyCobblestoneStairsBlock = ModObjects.chooseModMossyCobblestoneStairsBlock();
            if (biomeMossyCobblestoneStairsBlock == null) {
                biomeMossyCobblestoneStairsBlock = Blocks.field_150446_ar;
            }
            biomeMossyCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 19, 2, 4}, {4, 18, 2, 4}, {5, 17, 3, 7}, {3, 15, 3, 6}, {4, 12, 4, 5}, {2, 8, 4, 4}}) {
                this.func_175811_a(world, biomeMossyCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 19, 4, 0}, {4, 17, 2, 2}, {4, 15, 4, 0}, {4, 13, 2, 2}, {4, 11, 4, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 7, 5, 1}, {3, 7, 6, 2}, {5, 7, 5, 3}, {5, 3, 4, 3}, {3, 3, 6, 2}, {1, 2, 4, 1}, {3, 1, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150429_aA.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 5, 4, 5, 5}, {2, 1, 4, 2, 5, 4}, {4, 1, 4, 4, 5, 4}, {2, 1, 3, 4, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int[] uvwo : new int[][]{{6, 6, 4, 3}}) {
                int x = this.func_74865_a(uvwo[0], uvwo[2]);
                BlockPos pos = new BlockPos(x, y = this.func_74862_a(uvwo[1]), z = this.func_74873_b(uvwo[0], uvwo[2]));
                if (!structureBB.func_175898_b((Vec3i)pos) || world.func_180495_p(pos) == Blocks.field_150367_z) continue;
                world.func_180501_a(pos, Blocks.field_150367_z.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
                TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.func_175625_s(pos);
                if (tileentitydispenser == null) continue;
                int number_of_potions = 2;
                for (int i = 0; i < number_of_potions; ++i) {
                    PotionType potionID;
                    switch (random.nextInt(5)) {
                        default: {
                            potionID = PotionTypes.field_185220_C;
                            break;
                        }
                        case 1: {
                            potionID = PotionTypes.field_185250_v;
                            break;
                        }
                        case 2: {
                            potionID = PotionTypes.field_185226_I;
                            break;
                        }
                        case 3: {
                            potionID = PotionTypes.field_185246_r;
                            break;
                        }
                        case 4: {
                            potionID = PotionTypes.field_185252_x;
                        }
                    }
                    ItemStack dispenserItem = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potionID);
                    tileentitydispenser.func_70299_a(random.nextInt(tileentitydispenser.func_70302_i_()), dispenserItem);
                }
            }
            IBlockState biomeWoodPressurePlateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150456_au.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{5, 6, 4, 5, 6, 4}}) {
                this.func_175811_a(world, biomeWoodPressurePlateState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 1;
                int w = 4;
                int x = this.func_74865_a(u, w);
                y = this.func_74862_a(v);
                z = this.func_74873_b(u, w);
                EntityZombieVillager zombie = new EntityZombieVillager(world);
                zombie.func_70691_i(zombie.func_110138_aP());
                zombie.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
                zombie.func_110163_bv();
                if (GeneralConfig.nameEntities) {
                    String[] villager_name_a = NameGenerator.newRandomName("villager", random);
                    zombie.func_96094_a((villager_name_a[1] + " " + villager_name_a[2] + " " + villager_name_a[3]).trim());
                }
                world.func_72838_d((Entity)zombie);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampFletcherHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"            ", "            ", "            ", "            ", "            ", "            ", "            ", "            ", " F          ", "FF          ", "PFFF        ", "PPF         "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 8;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 8;
        private int averageGroundLevel = -1;

        public SwampFletcherHouse() {
        }

        public SwampFletcherHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampFletcherHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampFletcherHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampFletcherHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 8, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 8, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{8, 0, 8, 8})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{8, 8, 0, 8})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStrippedLogVertState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 1, 2}, {2, 1, 0, 2, 1, 0}, {1, 1, 3, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {2, 3, 4, 2, 3, 4}, {4, 3, 2, 4, 3, 2}, {3, 4, 5, 3, 6, 5}, {5, 4, 3, 5, 6, 3}, {6, 1, 10, 6, 2, 10}, {3, 1, 9, 3, 2, 9}, {9, 1, 9, 9, 2, 9}, {6, 1, 7, 6, 2, 7}, {2, 1, 6, 2, 2, 6}, {5, 1, 6, 5, 2, 6}, {6, 1, 6, 6, 1, 6}, {7, 1, 6, 7, 2, 6}, {10, 1, 6, 10, 2, 6}, {6, 1, 5, 6, 2, 5}, {3, 1, 3, 3, 2, 3}, {9, 1, 3, 9, 2, 3}, {6, 1, 2, 6, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvw : new int[][]{{6, 0, 10}, {3, 0, 9}, {9, 0, 9}, {6, 0, 7}, {2, 0, 6}, {5, 0, 6}, {6, 0, 6}, {7, 0, 6}, {10, 0, 6}, {6, 0, 5}, {3, 0, 3}, {9, 0, 3}, {6, 0, 2}}) {
                this.func_175808_b(world, biomeStrippedLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 3, 5, 1, 3, 7}, {2, 3, 8, 2, 3, 9}, {3, 3, 9, 3, 3, 10}, {4, 3, 10, 4, 3, 10}, {5, 3, 11, 7, 3, 11}, {10, 3, 8, 10, 3, 9}, {9, 3, 9, 9, 3, 10}, {8, 3, 10, 8, 3, 10}, {11, 3, 5, 11, 3, 7}, {8, 3, 2, 9, 3, 2}, {9, 3, 3, 10, 3, 3}, {10, 3, 4, 10, 3, 4}, {5, 3, 1, 7, 3, 1}, {7, 4, 9, 7, 6, 9}, {9, 4, 7, 9, 6, 7}, {3, 3, 5, 3, 3, 7}, {4, 3, 4, 4, 3, 8}, {5, 3, 3, 5, 3, 9}, {6, 3, 3, 6, 3, 5}, {6, 3, 7, 6, 3, 9}, {7, 3, 3, 7, 3, 9}, {8, 3, 4, 8, 3, 8}, {9, 3, 5, 9, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 1, 1}, {1, 1, 2, 1, 1, 2}, {1, 2, 5, 1, 2, 5}, {1, 2, 7, 1, 2, 7}, {2, 2, 3, 2, 2, 5}, {2, 2, 7, 2, 2, 9}, {3, 2, 2, 3, 2, 2}, {3, 2, 4, 3, 2, 8}, {3, 2, 10, 3, 2, 10}, {4, 2, 2, 4, 2, 10}, {5, 2, 1, 5, 2, 5}, {5, 2, 7, 5, 2, 11}, {6, 2, 3, 6, 2, 4}, {6, 2, 8, 6, 2, 9}, {7, 2, 1, 7, 2, 5}, {7, 2, 7, 7, 2, 11}, {8, 2, 2, 8, 2, 10}, {9, 2, 2, 9, 2, 2}, {9, 2, 4, 9, 2, 8}, {9, 2, 10, 9, 2, 10}, {10, 2, 3, 10, 2, 5}, {10, 2, 7, 2, 2, 9}, {11, 2, 5, 11, 2, 5}, {11, 2, 7, 11, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 1, 1}, {2, 2, 2, 2, 2, 2}, {3, 3, 3, 3, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeCobblestoneSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(11), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 5, 1, 6, 6}, {2, 6, 4, 2, 6, 7}, {3, 6, 4, 3, 6, 4}, {3, 6, 9, 4, 6, 10}, {5, 6, 10, 5, 6, 11}, {6, 6, 11, 7, 6, 11}, {8, 6, 10, 9, 6, 10}, {9, 6, 9, 9, 6, 9}, {4, 6, 2, 4, 6, 2}, {5, 6, 1, 6, 6, 2}, {7, 6, 1, 7, 6, 1}, {8, 6, 2, 9, 6, 2}, {9, 6, 3, 9, 6, 3}, {10, 6, 3, 10, 6, 7}, {11, 6, 5, 11, 6, 7}, {5, 7, 7, 5, 7, 7}, {7, 7, 7, 7, 7, 7}, {5, 7, 5, 5, 7, 5}, {7, 7, 5, 7, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabUpperState, biomeCobblestoneSlabUpperState, false);
            }
            IBlockState biomeMossyCobblestoneSlabUpperState = ModObjects.chooseModMossyCobblestoneSlabState(true);
            biomeMossyCobblestoneSlabUpperState = biomeMossyCobblestoneSlabUpperState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabUpperState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabUpperState;
            for (int[] uuvvww : new int[][]{{1, 6, 7, 1, 6, 7}, {2, 6, 3, 2, 6, 3}, {2, 6, 8, 2, 6, 9}, {3, 6, 2, 3, 6, 3}, {3, 6, 8, 3, 6, 8}, {7, 6, 2, 7, 6, 2}, {6, 6, 10, 7, 6, 10}, {10, 6, 8, 10, 6, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabUpperState, biomeMossyCobblestoneSlabUpperState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 7, 5, 3, 7, 8}, {4, 7, 3, 4, 7, 4}, {4, 7, 8, 4, 7, 9}, {5, 7, 3, 6, 7, 3}, {5, 7, 9, 8, 7, 9}, {8, 7, 4, 8, 7, 4}, {9, 7, 4, 9, 7, 8}, {8, 7, 8, 8, 7, 8}, {6, 8, 5, 6, 8, 5}, {5, 8, 6, 7, 8, 6}, {6, 8, 7, 6, 8, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{3, 7, 4, 3, 7, 4}, {7, 7, 3, 8, 7, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 7, 7, 5, 7, 7}, {5, 7, 8, 5, 7, 8}, {7, 7, 7, 7, 7, 8}, {7, 7, 4, 7, 7, 5}, {8, 7, 5, 8, 7, 7}, {5, 7, 4, 5, 7, 5}, {6, 7, 4, 6, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 7, 5, 4, 7, 6}, {6, 7, 8, 6, 7, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 7, 6, 6, 7, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 4, 6, 3, 6, 7}, {4, 4, 8, 4, 6, 8}, {5, 4, 9, 6, 6, 9}, {6, 4, 3, 7, 6, 3}, {8, 4, 4, 8, 6, 4}, {9, 4, 5, 9, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150359_w.func_176203_a(0), Blocks.field_150359_w.func_176203_a(0), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{8, 4, 9, 0}, {8, 5, 9, 0}, {9, 4, 8, 1}, {9, 5, 8, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{8, 6, 9, 0}, {9, 6, 8, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{6, 6, 6}, {6, 2, 1}, {1, 2, 6}, {11, 2, 6}, {6, 2, 11}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{1, 3, 3}, {3, 3, 1}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 4, 5, 4, 4, 7, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {5, 4, 4, 7, 4, 4, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {8, 4, 5, 8, 4, 7, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {5, 4, 8, 7, 4, 8, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvwoc : new int[][]{{5, 3, 2, 0, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {6, 3, 2, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {7, 3, 2, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {8, 3, 3, 3, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {9, 3, 4, 0, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {10, 3, 5, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {10, 3, 6, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {10, 3, 7, 3, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {9, 3, 8, 0, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {8, 3, 9, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {7, 3, 10, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {6, 3, 10, 3, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {5, 3, 10, 0, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {4, 3, 9, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 3, 8, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 3, 7, 3, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 3, 6, 0, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 3, 5, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 3, 4, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {4, 3, 3, 3, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            this.func_175811_a(world, ModObjects.chooseModFletchingTableState(3, this.func_186165_e()), 8, 4, 8, structureBB);
            for (int[] uvwc : new int[][]{{6, 3, 4, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwc[3]), uvwc[0], uvwc[1], uvwc[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 3, 6}}) {
                this.func_175811_a(world, Blocks.field_150335_W.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 6;
            int chestV = 4;
            int chestW = 6;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150447_bR.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_fletcher");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (Object uvwo : (ChestGenHooks)new int[][]{{10, 1, 3, 1}, {11, 3, 3, 1}, {11, 3, 8, 1}, {11, 3, 9, 1}, {9, 3, 1, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a((int)uvwo[0], (int)uvwo[2]), this.func_74862_a((int)uvwo[1]), this.func_74873_b((int)uvwo[0], (int)uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                int u;
                this.entitiesGenerated = true;
                int s = random.nextInt(20);
                int v = 4;
                int n = s <= 2 ? 4 : (s <= 7 ? 5 : (s <= 11 ? 6 : (u = s <= 16 ? 7 : 8)));
                int w = s <= 2 ? s + 5 : (s <= 7 ? s + 1 : (s <= 9 ? s - 4 : (s <= 11 ? s - 3 : (s <= 16 ? s - 8 : s - 12))));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampFisherCottage2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"             ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", "             ", "             ", "             ", "             ", "  FF         "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 7;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampFisherCottage2() {
        }

        public SwampFisherCottage2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampFisherCottage2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampFisherCottage2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampFisherCottage2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{7, 0, 7, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 7, 0, 7})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStrippedLogVertState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 8, 2, 2, 8}, {4, 0, 8, 4, 2, 8}, {6, 0, 8, 6, 3, 8}, {8, 0, 8, 8, 2, 8}, {10, 0, 8, 10, 2, 8}, {2, 0, 6, 2, 2, 6}, {4, 0, 6, 4, 5, 6}, {6, 0, 6, 6, 7, 6}, {8, 0, 6, 8, 5, 6}, {10, 0, 6, 10, 2, 6}, {2, 1, 4, 2, 2, 4}, {2, 1, 2, 2, 2, 2}, {4, 1, 2, 4, 5, 2}, {8, 1, 2, 8, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvw : new int[][]{{2, 0, 4}, {2, 0, 2}, {4, 0, 2}, {8, 0, 2}}) {
                this.func_175808_b(world, biomeStrippedLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{5, 5, 6, 5, 5, 6}, {7, 5, 6, 7, 5, 6}, {5, 5, 2, 7, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            for (int[] uwuwvs : new int[][]{{1, 10, 11, 10, 0, 0}, {11, 4, 11, 11, 0, 1}, {1, 5, 11, 5, 0, 2}, {1, 4, 1, 11, 0, 3}}) {
                int u_offset = 0;
                int w_offset = 0;
                int v = uwuwvs[4];
                switch (uwuwvs[5]) {
                    case 0: {
                        w_offset = 1;
                        break;
                    }
                    case 1: {
                        u_offset = 1;
                        break;
                    }
                    case 2: {
                        w_offset = -1;
                        break;
                    }
                    case 3: {
                        u_offset = -1;
                        break;
                    }
                }
                for (int u = uwuwvs[0]; u <= uwuwvs[2]; ++u) {
                    for (int w = uwuwvs[1]; w <= uwuwvs[3]; ++w) {
                        int z;
                        int y;
                        int x = this.func_74865_a(u + u_offset, w + w_offset);
                        if (world.func_180495_p(new BlockPos(x, (y = this.func_74862_a(v)) + 1, z = this.func_74873_b(u + u_offset, w + w_offset))).func_185904_a().func_76224_d()) {
                            this.func_175808_b(world, biomeFillerState, u + u_offset, v, w + w_offset, structureBB);
                            this.func_175811_a(world, biomeTopState, u + u_offset, v + 1, w + w_offset, structureBB);
                            continue;
                        }
                        if (!world.func_175623_d(new BlockPos(x, y, z))) continue;
                        this.func_175808_b(world, biomeFillerState, u + u_offset, v - 1, w + w_offset, structureBB);
                        this.func_175811_a(world, biomeTopState, u + u_offset, v, w + w_offset, structureBB);
                    }
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 9, 11, 0, 10}, {1, 0, 8, 1, 0, 8}, {3, 0, 8, 3, 0, 8}, {5, 0, 8, 5, 0, 8}, {7, 0, 8, 7, 0, 8}, {9, 0, 8, 9, 0, 8}, {11, 0, 8, 11, 0, 8}, {1, 0, 7, 11, 0, 7}, {1, 0, 6, 1, 0, 6}, {3, 0, 6, 3, 0, 6}, {5, 0, 6, 5, 0, 6}, {7, 0, 6, 7, 0, 6}, {9, 0, 6, 9, 0, 6}, {11, 0, 6, 11, 0, 6}, {1, 0, 5, 11, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 3, 2, 2, 3}, {2, 2, 5, 2, 2, 5}, {2, 2, 7, 2, 2, 7}, {3, 2, 2, 3, 2, 8}, {4, 2, 3, 4, 3, 5}, {4, 2, 7, 4, 2, 7}, {4, 4, 3, 4, 4, 3}, {4, 4, 5, 4, 4, 5}, {4, 5, 3, 4, 5, 5}, {5, 2, 2, 5, 2, 8}, {5, 3, 2, 5, 3, 2}, {5, 6, 6, 5, 6, 6}, {6, 2, 2, 6, 2, 5}, {6, 2, 7, 6, 2, 7}, {6, 3, 2, 6, 4, 2}, {5, 6, 2, 7, 6, 2}, {6, 7, 2, 6, 7, 2}, {7, 2, 2, 7, 2, 8}, {7, 3, 2, 7, 3, 2}, {7, 3, 6, 7, 3, 6}, {7, 6, 6, 7, 6, 6}, {8, 2, 3, 8, 3, 5}, {8, 4, 3, 8, 4, 3}, {8, 4, 5, 8, 4, 5}, {8, 5, 3, 8, 5, 5}, {8, 2, 7, 8, 2, 7}, {9, 2, 6, 9, 2, 8}, {10, 2, 7, 10, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 2, 1, 3}, {3, 2, 1, 3}, {2, 1, 0, 3}, {3, 1, 0, 3}, {8, 6, 2, 1}, {8, 6, 3, 1}, {8, 6, 4, 1}, {8, 6, 5, 1}, {8, 6, 6, 1}, {7, 7, 2, 1}, {7, 7, 3, 1}, {7, 7, 4, 1}, {7, 7, 5, 1}, {7, 7, 6, 1}, {5, 7, 2, 0}, {5, 7, 3, 0}, {5, 7, 4, 0}, {5, 7, 5, 0}, {5, 7, 6, 0}, {4, 6, 2, 0}, {4, 6, 3, 0}, {4, 6, 4, 0}, {4, 6, 5, 0}, {4, 6, 6, 0}, {9, 3, 7, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 3, 1, 1}, {6, 3, 3, 6, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 8, 2, 6, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            for (int[] uvw : new int[][]{{5, 4, 2}, {7, 4, 2}, {4, 4, 4}, {8, 4, 4}, {7, 4, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 7, 4}, {6, 6, 4}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{6, 5, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{6, 4, 8}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{5, 3, 3, 1, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {7, 3, 3, 3, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            for (int[] uvws : new int[][]{{5, 4, 3, 5}, {7, 4, 3, 0}}) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(this.func_74865_a(uvws[0], uvws[2]), this.func_74862_a(uvws[1]), this.func_74873_b(uvws[0], uvws[2])), Blocks.field_150345_g, uvws[3]);
            }
            for (int[] uvwc : new int[][]{{6, 3, 4, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwc[3]), uvwc[0], uvwc[1], uvwc[2], structureBB);
            }
            for (int[] uvwoo : new int[][]{{8, 3, 7, 0, -1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), ModObjects.chooseModBarrelBlockState(this.func_186165_e(), uvwoo[4], uvwoo[3]), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 3, 6, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                int u;
                this.entitiesGenerated = true;
                int s = random.nextInt(19);
                int v = 3;
                int n = s <= 5 ? 5 + s % 3 : (s <= 9 ? 4 + (s - 6) % 2 : (s <= 10 ? 6 : (s <= 12 ? 7 : (s <= 15 ? s - 5 : (u = s <= 17 ? 10 : 9)))));
                int w = s <= 5 ? 4 + s / 3 : (s <= 9 ? 7 + (s - 6) / 2 : (s <= 10 ? 7 : (s <= 12 ? s - 4 : (s <= 15 ? 8 : (s <= 17 ? s - 10 : 6)))));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampFisherCottage1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFF   FFF ", "FFFFFFFFF ", "FFFFFFFFF ", " FFFFFFF  ", " FFFFFFF  ", " FFFFFFF  ", "FFFFFFFFF ", "FFFFFFFFF ", "FFF   FFFF", "      PPPP"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 6;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampFisherCottage1() {
        }

        public SwampFisherCottage1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampFisherCottage1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampFisherCottage1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampFisherCottage1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{6, 0, 6, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 6, 0, 6})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{6, 0, 9, 8, 0, 9}, {8, 0, 8, 8, 0, 8}, {0, 0, 7, 0, 0, 9}, {1, 0, 7, 1, 0, 7}, {1, 0, 9, 2, 0, 9}, {0, 0, 1, 0, 0, 2}, {1, 0, 1, 1, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 0, 7, 7, 0, 8}, {8, 0, 7, 8, 0, 7}, {1, 0, 8, 2, 0, 8}, {2, 0, 7, 2, 0, 7}, {0, 0, 3, 2, 0, 3}, {1, 0, 2, 2, 0, 2}, {2, 0, 1, 2, 0, 1}, {1, 0, 4, 1, 0, 6}, {3, 0, 2, 5, 0, 2}, {3, 0, 8, 5, 0, 8}, {7, 0, 4, 7, 0, 6}, {6, 0, 1, 8, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 4, 2, 0, 6}, {3, 0, 3, 5, 0, 7}, {6, 0, 4, 6, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{4, 1, 3}, {5, 1, 5}}) {
                this.func_175811_a(world, Blocks.field_150392_bi.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 4, 5, 7, 6, 5}, {8, 4, 6, 8, 6, 6}, {5, 4, 9, 5, 6, 9}, {8, 4, 9, 8, 6, 9}, {4, 4, 8, 4, 6, 8}, {1, 4, 5, 1, 6, 5}, {0, 4, 4, 0, 6, 4}, {0, 4, 1, 0, 6, 1}, {3, 4, 1, 3, 6, 1}, {4, 4, 2, 4, 6, 2}, {1, 1, 8, 1, 6, 8}, {7, 1, 8, 7, 2, 8}, {1, 1, 2, 1, 2, 2}, {7, 1, 2, 7, 6, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{7, 2, 3, 0}, {1, 2, 7, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 3, 7, 7, 3, 8}, {1, 3, 7, 1, 3, 7}, {2, 3, 8, 2, 3, 8}, {1, 3, 2, 2, 3, 3}, {6, 3, 2, 6, 3, 3}, {7, 3, 3, 7, 3, 3}, {2, 7, 7, 2, 7, 7}, {6, 7, 7, 7, 7, 8}, {2, 7, 5, 3, 7, 5}, {5, 7, 5, 6, 7, 5}, {4, 7, 3, 4, 7, 4}, {4, 7, 6, 4, 7, 7}, {1, 7, 2, 2, 7, 3}, {6, 7, 3, 6, 7, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 3, 9, 6}, {6, 3, 9, 6}, {7, 3, 9, 6}, {8, 3, 9, 6}, {5, 3, 7, 4}, {5, 3, 8, 4}, {8, 3, 7, 5}, {8, 3, 8, 5}, {5, 3, 6, 7}, {6, 3, 6, 7}, {7, 3, 6, 7}, {8, 3, 6, 7}, {0, 3, 4, 6}, {1, 3, 4, 6}, {2, 3, 4, 6}, {3, 3, 4, 6}, {0, 3, 2, 4}, {0, 3, 3, 4}, {3, 3, 2, 5}, {3, 3, 3, 5}, {0, 3, 1, 7}, {1, 3, 1, 7}, {2, 3, 1, 7}, {3, 3, 1, 7}, {5, 3, 2, 4}, {5, 3, 3, 4}, {5, 3, 4, 4}, {6, 3, 4, 6}, {7, 3, 4, 6}, {8, 3, 4, 6}, {1, 3, 6, 7}, {3, 3, 8, 5}, {7, 1, 1, 0}, {8, 1, 1, 3}, {8, 2, 2, 3}, {8, 3, 3, 3}, {8, 1, 2, 6}, {8, 2, 3, 6}, {1, 4, 2, 5}, {3, 4, 2, 4}, {0, 7, 4, 0}, {0, 7, 3, 0}, {0, 7, 2, 0}, {1, 7, 7, 0}, {1, 7, 6, 0}, {1, 7, 5, 0}, {1, 7, 4, 2}, {5, 7, 8, 2}, {4, 7, 8, 2}, {3, 7, 8, 2}, {2, 7, 8, 2}, {1, 7, 8, 2}, {7, 7, 9, 2}, {6, 7, 9, 2}, {5, 7, 9, 0}, {8, 7, 7, 1}, {8, 7, 8, 1}, {8, 7, 9, 1}, {7, 7, 3, 1}, {7, 7, 4, 1}, {7, 7, 5, 1}, {7, 7, 6, 1}, {8, 7, 6, 3}, {3, 7, 2, 1}, {4, 7, 2, 3}, {5, 7, 2, 3}, {6, 7, 2, 3}, {7, 7, 2, 3}, {0, 7, 1, 3}, {1, 7, 1, 3}, {2, 7, 1, 3}, {3, 7, 1, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 3, 2, 4, 3, 5}, {4, 3, 8, 4, 3, 8}, {5, 3, 5, 8, 3, 5}, {1, 3, 5, 1, 3, 5}, {2, 4, 2, 2, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uuvvww : new int[][]{{8, 6, 7, 8, 6, 8}, {6, 6, 9, 7, 6, 9}, {2, 6, 8, 3, 6, 8}, {1, 6, 6, 1, 6, 7}, {0, 6, 2, 0, 6, 3}, {1, 6, 1, 2, 6, 1}, {5, 6, 2, 6, 6, 2}, {8, 6, 7, 8, 6, 8}, {8, 4, 7, 8, 4, 8}, {6, 4, 9, 7, 4, 9}, {2, 4, 8, 3, 4, 8}, {1, 4, 6, 1, 4, 7}, {0, 4, 2, 0, 4, 3}, {1, 4, 1, 2, 4, 1}, {5, 4, 2, 6, 4, 2}, {8, 4, 7, 8, 4, 8}, {7, 4, 3, 7, 6, 3}, {7, 6, 4, 7, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15), false);
            }
            for (int[] uvw : new int[][]{{8, 5, 7}, {8, 5, 8}, {6, 5, 9}, {7, 5, 9}, {2, 5, 8}, {3, 5, 8}, {1, 5, 6}, {1, 5, 7}, {0, 5, 2}, {0, 5, 3}, {1, 5, 1}, {2, 5, 1}, {5, 5, 2}, {6, 5, 2}, {8, 5, 7}, {8, 5, 8}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 7, 7}, {5, 7, 7}, {2, 7, 6}, {3, 7, 6}, {5, 7, 6}, {6, 7, 6}, {2, 7, 4}, {3, 7, 4}, {5, 7, 4}, {6, 7, 4}, {3, 7, 3}, {5, 7, 3}}) {
                this.func_175811_a(world, Blocks.field_150359_w.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 5}, {3, 6, 5}, {4, 6, 6}, {4, 6, 7}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeBrickWallState = null;
            IBlockState biomeBrickBlockState = Blocks.field_150336_V.func_176223_P();
            biomeBrickWallState = ModObjects.chooseModBrickWallState();
            if (biomeBrickWallState == null) {
                biomeBrickWallState = Blocks.field_150463_bK.func_176203_a(0);
                biomeBrickBlockState = Blocks.field_150347_e.func_176203_a(0);
            }
            biomeBrickWallState = StructureVillageVN.getBiomeSpecificBlockState(biomeBrickWallState, this.materialType, this.biome, this.disallowModSubs);
            biomeBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(biomeBrickBlockState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 5, 5, 4, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBrickWallState, biomeBrickWallState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 7, 5, 4, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBrickBlockState, biomeBrickBlockState, false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{4, 4, 6, 3}, {4, 4, 7, 3}, {2, 4, 5, 0}, {3, 4, 5, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{2, 6, 3}, {6, 6, 7}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 4, 5, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            int chestU = 7;
            int chestV = 4;
            int chestW = 7;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_fisher");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvw : (ChestGenHooks)new int[][]{{1, 5, 2}}) {
                Object u = uvw[0];
                Object v = uvw[1];
                Object w = uvw[2];
                int x = this.func_74865_a((int)u, (int)w);
                int y = this.func_74862_a((int)v);
                int z = this.func_74873_b((int)u, (int)w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{7, 4, 4, 1, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176203_a(4), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{9, 1, 1, 9, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            for (int[] uvwoo : new int[][]{{1, 1, 7, 2, -1}, {2, 1, 8, 2, 1}, {3, 1, 8, 2, -1}, {7, 1, 3, 3, -1}, {8, 4, 5, 2, -1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), ModObjects.chooseModBarrelBlockState(this.func_186165_e(), uvwoo[4], uvwoo[3]), 2);
            }
            for (int[] uvwoc : new int[][]{{9, 3, 5, 1, 15}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                if (GeneralConfig.useVillageColors) {
                    NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = new ItemStack(Items.field_179564_cE);
                    villageBanner.func_77983_a("BlockEntityTag", (NBTBase)villageNBTtag.func_74775_l("BlockEntityTag"));
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{4, 4, 9, 0}, {4, 3, 9, 0}, {4, 2, 9, 0}, {4, 1, 9, 0}, {4, 4, 1, 2}, {4, 3, 1, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                int w;
                int u;
                this.entitiesGenerated = true;
                int s = random.nextInt(20);
                int v = 4;
                if (s < 12) {
                    u = 1 + s % 6;
                    w = 3 + s / 6;
                } else {
                    u = 5 + (s - 12) / 4;
                    w = 5 + (s - 12) % 4;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampCartographerHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"          ", "          ", "          ", "          ", "          ", "          ", "          ", "         F", "         P"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 6;
        private static final int DECREASE_MAX_U = -1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampCartographerHouse() {
        }

        public SwampCartographerHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampCartographerHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampCartographerHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampCartographerHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{6, 0, 6, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 6, 0, 6})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{-1, 0, -1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, -1, 0, -1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState darkPrismarineState = Blocks.field_180397_cI.func_176203_a(2);
            for (int[] uuvvww : new int[][]{{1, 1, 7, 1, 2, 7}, {7, 1, 7, 7, 2, 7}, {3, 1, 5, 3, 8, 5}, {5, 1, 5, 5, 2, 5}, {3, 1, 3, 3, 2, 3}, {5, 1, 3, 5, 2, 3}, {1, 1, 1, 1, 2, 1}, {7, 1, 1, 7, 2, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], darkPrismarineState, darkPrismarineState, false);
            }
            for (int[] uvw : new int[][]{{1, 0, 7}, {7, 0, 7}, {3, 0, 5}, {5, 0, 5}, {3, 0, 3}, {5, 0, 3}, {1, 0, 1}, {7, 0, 1}}) {
                this.func_175808_b(world, darkPrismarineState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 3, 1, 2, 3, 8}, {3, 3, 1, 3, 3, 4}, {3, 3, 6, 3, 3, 8}, {4, 3, 1, 5, 3, 8}, {6, 3, 1, 7, 3, 7}, {8, 3, 4, 8, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor3 : 10), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor3 : 10), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 0, 0, 3, 1}, {1, 3, 0, 8, 3, 0}, {8, 3, 1, 8, 3, 3}, {8, 3, 5, 8, 3, 8}, {9, 3, 4, 9, 3, 5}, {6, 3, 8, 7, 3, 8}, {0, 3, 2, 0, 5, 8}, {6, 4, 2, 6, 5, 4}, {6, 4, 6, 6, 5, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 0, 0, 4, 1}, {1, 4, 0, 8, 4, 0}, {8, 4, 1, 8, 4, 3}, {8, 4, 5, 9, 4, 5}, {8, 4, 6, 8, 4, 8}, {7, 4, 8, 7, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{0, 6, 8, 0}, {1, 7, 8, 0}, {2, 8, 8, 0}, {4, 8, 8, 1}, {1, 7, 7, 0}, {2, 8, 7, 0}, {4, 8, 7, 1}, {0, 6, 6, 0}, {1, 7, 6, 0}, {2, 8, 6, 0}, {4, 8, 6, 1}, {5, 7, 6, 1}, {1, 7, 5, 0}, {2, 8, 5, 0}, {6, 6, 5, 1}, {5, 7, 4, 1}, {6, 6, 4, 1}, {2, 8, 3, 0}, {4, 8, 3, 1}, {5, 7, 3, 1}, {0, 6, 2, 0}, {1, 7, 2, 0}, {2, 8, 2, 0}, {4, 8, 2, 1}, {5, 7, 2, 1}, {6, 6, 2, 1}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeMossyCobblestoneStairsBlock = ModObjects.chooseModMossyCobblestoneStairsBlock();
            if (biomeMossyCobblestoneStairsBlock == null) {
                biomeMossyCobblestoneStairsBlock = Blocks.field_150446_ar;
            }
            biomeMossyCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{5, 7, 8, 1}, {6, 6, 8, 1}, {0, 6, 7, 0}, {5, 7, 7, 1}, {6, 6, 7, 1}, {6, 6, 6, 1}, {0, 6, 5, 0}, {4, 8, 5, 1}, {5, 7, 5, 1}, {0, 6, 4, 0}, {1, 7, 4, 0}, {2, 8, 4, 0}, {4, 8, 4, 1}, {0, 6, 3, 0}, {1, 7, 3, 0}, {6, 6, 3, 1}}) {
                this.func_175811_a(world, biomeMossyCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 9, 2, 3, 9, 3}, {3, 9, 5, 3, 9, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{3, 9, 4, 3, 9, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 3, 1}, {1, 4, 4, 1}, {9, 1, 1, 3}, {9, 2, 2, 3}, {9, 3, 3, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{9, 1, 2, 9, 1, 2}, {9, 2, 3, 9, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{1, 4, 5, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{5, 4, 7, 2, GeneralConfig.useVillageColors ? this.townColor3 : 10}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            for (int[] uvws : new int[][]{{5, 5, 7, random.nextInt(6)}}) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(this.func_74865_a(uvws[0], uvws[2]), this.func_74862_a(uvws[1]), this.func_74873_b(uvws[0], uvws[2])), Blocks.field_150345_g, uvws[3]);
            }
            for (int[] uvwo : new int[][]{{1, 4, 7, 1}}) {
                this.func_175811_a(world, ModObjects.chooseModCartographyTableState(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 6, 7, 5, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 4, 5, 3, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 4, 8, 5, 6, 8}, {2, 7, 8, 4, 7, 8}, {3, 8, 8, 3, 8, 8}, {1, 4, 2, 5, 6, 2}, {2, 7, 2, 4, 7, 2}, {3, 8, 2, 3, 8, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150359_w.func_176203_a(0), Blocks.field_150359_w.func_176203_a(0), false);
            }
            for (int[] uvwo : new int[][]{{3, 6, 6, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{7, 5, 7, 1}, {5, 6, 9, 0}, {5, 5, 9, 0}, {5, 4, 9, 0}, {6, 5, 9, 0}, {6, 4, 9, 0}, {6, 3, 9, 0}, {6, 2, 9, 0}, {6, 1, 9, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(20);
                int u = s <= 1 ? 1 : (s <= 6 ? 2 : (s <= 8 ? 3 : (s <= 10 ? 3 : (s <= 15 ? 4 : 5))));
                int v = 4;
                int w = s <= 1 ? s + 5 : (s <= 6 ? s + 1 : (s <= 8 ? s - 4 : (s <= 10 ? s - 3 : (s <= 15 ? s - 8 : s - 13))));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class SwampButcherShop
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"     FFFF    ", "    FFFFFF   ", "  FFFFFFFFF  ", " FFFFFFFFFFF ", "FFFFFFFFFFFF ", "FFFFFFFFFFFFF", " FFFFFFFFFFFF", "  FFFFFFFFFFF", "  FFFFFFFFFFF", "  FFFFFFFFFFF", "  FFFFFFFFFFF", "   FFFFFFFFFF", "   FFFFFFFFF ", "   FFFFFFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 2;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 3;
        private static final int DECREASE_MAX_U = 3;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampButcherShop() {
        }

        public SwampButcherShop(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampButcherShop buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampButcherShop.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampButcherShop(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{8, 5, 11}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uvw : new int[][]{{5, 1, 2}, {6, 1, 2}, {7, 1, 2}, {5, 1, 1}, {6, 1, 1}, {7, 1, 1}, {5, 1, 0}, {6, 1, 0}, {7, 1, 0}}) {
                int posX = this.func_74865_a(uvw[0], uvw[2]);
                int posY = this.func_74862_a(uvw[1]);
                int posZ = this.func_74873_b(uvw[0], uvw[2]);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 3, 8, 0, 9}, {4, 4, 4, 4, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 4, 2, 5, 4, 2}, {6, 4, 3, 7, 4, 3}, {3, 1, 3, 8, 1, 3}, {3, 2, 3, 5, 3, 3}, {7, 2, 3, 8, 3, 3}, {3, 1, 4, 3, 2, 9}, {3, 4, 3, 3, 4, 8}, {3, 3, 4, 3, 3, 4}, {3, 3, 7, 3, 3, 9}, {8, 1, 4, 8, 4, 9}, {4, 1, 9, 7, 4, 9}, {5, 4, 4, 7, 4, 4}, {4, 4, 5, 7, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 0, 4, 1, 2}, {1, 2, 8, 1, 2, 9}, {2, 2, 7, 2, 3, 9}, {2, 2, 10, 2, 2, 10}, {3, 2, 10, 4, 3, 10}, {4, 2, 11, 4, 2, 11}, {5, 2, 10, 8, 3, 11}, {8, 4, 11, 8, 4, 11}, {6, 2, 12, 7, 2, 12}, {8, 4, 2, 8, 4, 2}, {8, 2, 1, 8, 2, 1}, {9, 2, 1, 9, 2, 1}, {9, 2, 2, 9, 3, 2}, {9, 2, 3, 9, 3, 10}, {9, 4, 3, 9, 4, 7}, {10, 2, 0, 10, 2, 1}, {10, 2, 2, 10, 3, 7}, {10, 2, 8, 10, 2, 9}, {11, 2, 2, 11, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 5, 6, 3, 5, 8}, {4, 5, 5, 8, 5, 9}, {5, 5, 4, 8, 5, 4}, {6, 5, 3, 8, 5, 3}, {9, 5, 3, 9, 5, 7}, {8, 5, 2, 8, 5, 2}, {2, 4, 7, 2, 4, 9}, {3, 4, 9, 3, 4, 9}, {3, 4, 10, 8, 4, 10}, {5, 4, 11, 7, 4, 11}, {9, 4, 2, 9, 4, 2}, {9, 4, 8, 9, 4, 9}, {10, 4, 2, 10, 4, 7}, {4, 4, 3, 5, 4, 3}, {6, 4, 2, 7, 4, 2}, {1, 3, 8, 1, 3, 9}, {2, 3, 10, 2, 3, 10}, {4, 3, 11, 4, 3, 11}, {6, 3, 12, 7, 3, 12}, {9, 3, 10, 9, 3, 10}, {10, 3, 8, 10, 3, 9}, {11, 3, 2, 11, 3, 7}, {10, 3, 0, 10, 3, 1}, {8, 3, 1, 9, 3, 1}, {1, 2, 7, 1, 2, 7}, {0, 2, 8, 0, 2, 9}, {1, 2, 10, 1, 2, 10}, {2, 2, 11, 3, 2, 11}, {4, 2, 12, 5, 2, 12}, {5, 2, 13, 8, 2, 13}, {8, 2, 12, 9, 2, 12}, {9, 2, 0, 9, 2, 0}, {9, 2, 11, 10, 2, 11}, {10, 2, 10, 11, 2, 10}, {11, 2, 8, 11, 2, 9}, {12, 2, 2, 12, 2, 8}, {11, 2, 1, 11, 2, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 2, 2, 4, 3, 2}, {8, 2, 2, 8, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 4, 7, 3, 8}}) {
                this.func_74878_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5]);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{6, 3, 7}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState smoothStoneBlockState = ModObjects.chooseModSmoothStoneBlockState();
            for (int[] uuvvww : new int[][]{{5, 1, 7, 6, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], smoothStoneBlockState, smoothStoneBlockState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 5, 4, 4, 7, 4}, {4, 2, 4, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{8, 2, 0, 0}, {9, 3, 0, 0}, {10, 4, 1, 3}, {9, 5, 2, 1}, {6, 1, 4, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 6, 3, 6, 8}, {4, 6, 8, 4, 6, 9}, {5, 6, 9, 8, 6, 9}, {8, 6, 7, 8, 6, 8}, {9, 6, 3, 9, 6, 7}, {4, 6, 5, 4, 6, 6}, {5, 6, 4, 5, 6, 5}, {6, 6, 3, 6, 6, 4}, {7, 6, 3, 7, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{3, 7, 6, -1}, {6, 7, 3, -1}, {9, 7, 7, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{8, 6, 3}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(2, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{4, 1, 4, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{3, 3, 5, 1}, {3, 3, 6, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 2, 3, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{1, 3, 7, 1}, {1, 4, 8, 0}, {2, 4, 10, 2}, {3, 3, 11, 0}, {3, 5, 9, 0}, {5, 3, 13, 0}, {6, 5, 10, 1}, {7, 5, 11, 0}, {7, 6, 8, 0}, {7, 6, 4, 0}, {8, 3, 12, 0}, {9, 3, 11, 1}, {9, 5, 8, 0}, {10, 4, 8, 0}, {10, 5, 4, 0}, {11, 4, 3, 0}, {11, 4, 5, 0}, {12, 3, 5, 2}, {12, 3, 6, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(16);
                int u = s <= 3 ? 4 : (s <= 7 ? 5 : (s <= 10 ? 6 : 7));
                int v = 1;
                int w = s <= 3 ? s + 5 : (s <= 6 ? s : (s <= 8 ? 8 : (s <= 10 ? s - 4 : s - 7)));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{6, 6, 6}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SwampArmorerHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFF ", "FFFFFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = -1;
        private static final int DECREASE_MAX_U = 5;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampArmorerHouse() {
        }

        public SwampArmorerHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampArmorerHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampArmorerHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampArmorerHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{-1, 0, -1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, -1, 0, -1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{5, 0, 5, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 5, 0, 5})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150336_V.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 3, 7, 0, 3}, {0, 0, 0, 0, 0, 2}, {7, 0, 2, 8, 1, 2}, {8, 0, 3, 8, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBrickBlockState, biomeBrickBlockState, false);
            }
            IBlockState biomeBrickWallState = null;
            biomeBrickWallState = ModObjects.chooseModBrickWallState();
            if (biomeBrickWallState == null) {
                biomeBrickWallState = Blocks.field_150463_bK.func_176203_a(0);
            }
            biomeBrickWallState = StructureVillageVN.getBiomeSpecificBlockState(biomeBrickWallState, this.materialType, this.biome, this.disallowModSubs);
            biomeBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(biomeBrickBlockState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 2, 3, 7, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBrickWallState, biomeBrickWallState, false);
            }
            for (int[] uvwo : new int[][]{{7, 1, 3, 3}}) {
                IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(uvwo[3], this.func_186165_e());
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvwo[0], uvwo[1], uvwo[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), blastFurnaceState, 2);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 4, 8, 0, 4}, {0, 0, 5, 0, 0, 6}, {8, 0, 5, 8, 0, 6}, {0, 0, 7, 8, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 7, 8, 1, 7}, {0, 1, 5, 0, 1, 6}, {8, 1, 5, 8, 1, 6}, {0, 1, 4, 3, 1, 4}, {5, 1, 4, 8, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 13), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 13), false);
            }
            for (int[] uuvvww : new int[][]{{0, 3, 4, 8, 3, 4}, {0, 2, 4, 1, 2, 4}, {7, 2, 4, 8, 2, 4}, {0, 3, 7, 8, 3, 7}, {0, 2, 7, 1, 2, 7}, {3, 2, 7, 3, 2, 7}, {5, 2, 7, 5, 2, 7}, {7, 2, 7, 8, 2, 7}, {0, 2, 5, 0, 3, 6}, {8, 2, 5, 8, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15), false);
            }
            for (int[] uvwoc : new int[][]{{3, 2, 4, 2, GeneralConfig.useVillageColors ? this.townColor2 : 13}, {5, 2, 4, 0, GeneralConfig.useVillageColors ? this.townColor2 : 13}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 1, 1, 2, 1}, {3, 0, 1, 3, 2, 1}, {5, 0, 1, 5, 2, 1}, {7, 0, 1, 7, 2, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uwuwvs : new int[][]{{7, 0, 7, 0, 0, 1}, {0, 0, 8, 0, 0, 2}}) {
                int u_offset = 0;
                int w_offset = 0;
                int v = uwuwvs[4];
                switch (uwuwvs[5]) {
                    case 0: {
                        w_offset = 1;
                        break;
                    }
                    case 1: {
                        u_offset = 1;
                        break;
                    }
                    case 2: {
                        w_offset = -1;
                        break;
                    }
                    case 3: {
                        u_offset = -1;
                        break;
                    }
                }
                for (int u = uwuwvs[0]; u <= uwuwvs[2]; ++u) {
                    for (int w = uwuwvs[1]; w <= uwuwvs[3]; ++w) {
                        int z;
                        int y;
                        int x = this.func_74865_a(u + u_offset, w + w_offset);
                        if (world.func_180495_p(new BlockPos(x, (y = this.func_74862_a(v)) + 1, z = this.func_74873_b(u + u_offset, w + w_offset))).func_185904_a().func_76224_d()) {
                            this.func_175808_b(world, biomeFillerState, u + u_offset, v, w + w_offset, structureBB);
                            this.func_175811_a(world, biomeTopState, u + u_offset, v + 1, w + w_offset, structureBB);
                            continue;
                        }
                        if (!world.func_175623_d(new BlockPos(x, y, z))) continue;
                        this.func_175808_b(world, biomeFillerState, u + u_offset, v - 1, w + w_offset, structureBB);
                        this.func_175811_a(world, biomeTopState, u + u_offset, v, w + w_offset, structureBB);
                    }
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 2, 6, 0, 2}, {2, 0, 1, 2, 0, 1}, {4, 0, 1, 4, 0, 1}, {6, 0, 1, 6, 0, 1}, {1, 0, 0, 7, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 7, 8, 4, 7}, {0, 4, 5, 0, 4, 6}, {8, 4, 5, 8, 4, 6}, {1, 1, 6, 1, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 8, 8, 4, 8}, {0, 4, 4, 8, 4, 4}, {0, 3, 1, 8, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 3, 6, 3, 3}, {8, 3, 3, 8, 3, 3}, {1, 4, 5, 7, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeBrickSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(4), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 5, 6, 8, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBrickSlabLowerState, biomeBrickSlabLowerState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{7, 1, 5, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{7, 1, 6}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 2, 7, 2}, {4, 2, 7, 2}, {6, 2, 7, 2}, {2, 2, 4, 0}, {6, 2, 4, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 4, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 5, 1, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 5, 7, 0, 6, GeneralConfig.useVillageColors ? this.townColor3 : 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150325_L.func_176203_a(uuvvww[6]), Blocks.field_150325_L.func_176203_a(uuvvww[6]), false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{1, 2, 2}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{7, 2, 2}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 3, 6, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 1;
            int chestV = 2;
            int chestW = 6;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof TileEntityChest) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_armorer");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (Object uvwo : (ChestGenHooks)new int[][]{{-1, 4, 5, 3}, {-1, 3, 5, 3}, {-1, 2, 5, 3}, {9, 4, 6, 1}, {9, 3, 6, 1}, {9, 2, 6, 1}, {9, 1, 6, 1}, {9, 1, 7, 1}, {1, 3, 8, 0}, {1, 2, 8, 0}, {3, 3, 8, 0}, {3, 2, 8, 0}, {3, 1, 8, 0}, {4, 3, 8, 0}, {1, 2, 0, 2}, {1, 1, 0, 2}, {7, 2, 0, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a((int)uvwo[0], (int)uvwo[2]), this.func_74862_a((int)uvwo[1]), this.func_74873_b((int)uvwo[0], (int)uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(13);
                int v = 3;
                int u = s <= 9 ? 2 + s / 2 : s - 6;
                int w = s <= 9 ? 5 + s % 2 : 3;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SwampAnimalPen2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF", "FFFFFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampAnimalPen2() {
        }

        public SwampAnimalPen2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampAnimalPen2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampAnimalPen2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampAnimalPen2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 0, 0, 0, 13}, {1, 0, 0, 1, 0, 3}, {1, 0, 7, 3, 0, 13}, {2, 0, 0, 3, 0, 2}, {4, 0, 0, 4, 0, 1}, {4, 0, 6, 4, 0, 7}, {4, 0, 10, 4, 0, 13}, {5, 0, 0, 6, 0, 0}, {5, 0, 5, 5, 0, 6}, {5, 0, 11, 5, 0, 13}, {6, 0, 4, 6, 0, 7}, {6, 0, 12, 8, 0, 13}, {7, 0, 0, 7, 0, 4}, {7, 0, 6, 7, 0, 9}, {8, 0, 0, 8, 0, 3}, {8, 0, 7, 8, 0, 10}, {9, 0, 0, 10, 0, 2}, {9, 0, 8, 9, 0, 13}, {10, 0, 10, 10, 0, 13}, {11, 0, 0, 11, 0, 3}, {11, 0, 10, 11, 0, 13}, {12, 0, 0, 12, 0, 4}, {12, 0, 8, 12, 0, 13}, {13, 0, 0, 13, 0, 13}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 13, 0, 4, 13}, {13, 1, 13, 13, 5, 13}, {0, 1, 0, 0, 4, 0}, {13, 1, 0, 13, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 12}, {1, 5, 13}, {0, 5, 13}, {12, 5, 13}, {13, 5, 12}, {0, 5, 0}, {0, 5, 1}, {1, 4, 0}, {12, 5, 0}, {13, 4, 1}, {1, 1, 13}, {2, 1, 13}, {3, 1, 13}, {4, 1, 13}, {5, 1, 13}, {6, 1, 13}, {9, 1, 13}, {10, 1, 13}, {11, 1, 13}, {12, 1, 13}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 1, 6}, {0, 1, 7}, {0, 1, 8}, {0, 1, 9}, {0, 1, 10}, {0, 1, 11}, {0, 1, 12}, {13, 1, 1}, {13, 1, 2}, {13, 1, 5}, {13, 1, 6}, {13, 1, 7}, {13, 1, 8}, {13, 1, 9}, {13, 1, 10}, {13, 1, 11}, {13, 1, 12}, {1, 1, 0}, {2, 1, 0}, {3, 1, 0}, {4, 1, 0}, {5, 1, 0}, {6, 1, 0}, {7, 1, 0}, {8, 1, 0}, {9, 1, 0}, {12, 1, 0}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{7, 1, 13}, {8, 1, 13}, {10, 1, 0}, {11, 1, 0}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(2, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 1, 4}, {0, 1, 5}, {13, 1, 3}, {13, 1, 4}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(1, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{0, 3, 12}, {1, 4, 13}, {12, 4, 13}, {13, 4, 12}, {12, 4, 0}, {13, 3, 1}, {1, 3, 0}, {0, 4, 1}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 7, 1, 0, 8}, {2, 0, 7, 2, 0, 9}, {3, 0, 7, 3, 0, 11}, {4, 0, 8, 4, 0, 12}, {5, 0, 9, 5, 0, 12}, {6, 0, 10, 6, 0, 12}, {7, 0, 8, 7, 0, 8}, {8, 0, 7, 9, 0, 9}, {10, 0, 6, 10, 0, 8}, {11, 0, 5, 11, 0, 7}, {3, 0, 3, 3, 0, 4}, {4, 0, 2, 4, 0, 5}, {5, 0, 1, 5, 0, 6}, {6, 0, 1, 6, 0, 5}, {7, 0, 1, 7, 0, 4}, {8, 0, 2, 9, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{2, 1, 8}, {3, 1, 10}, {3, 1, 11}, {4, 1, 5}, {4, 1, 10}, {5, 1, 3}, {5, 1, 9}, {7, 1, 3}, {9, 1, 7}, {9, 1, 9}, {11, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150392_bi.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{9, 1, 10}, {10, 1, 10}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{10, 1, 9}}) {
                this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(Blocks.field_150407_cf.func_176203_a(0), this.func_186165_e().func_176736_b(), false), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{1, 1, 5, 0}, {1, 1, 11, 2}, {1, 1, 12, 1}, {2, 1, 4, 0}, {2, 1, 12, 1}, {7, 1, 11, 0}, {9, 1, 5, 1}, {10, 1, 1, 2}, {10, 1, 3, 0}, {10, 1, 4, 0}, {11, 1, 1, 1}, {11, 1, 4, 0}, {12, 1, 1, 2}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    EntityLiving animal;
                    for (int[] uvw : new int[][]{{2, 1, 10}, {8, 1, 5}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                    for (int[] uvw : new int[][]{{2, 1, 2}}) {
                        ArrayList<Object> arraylist_animal = new ArrayList<Object>();
                        if (VillageGeneratorConfigHandler.animaniaLivestock && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                            for (EntityLiving animal_namespace : ModObjects.animania_horse) {
                                EntityLiving testEntity = null;
                                try {
                                    testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation((String)animal_namespace), (World)world);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (testEntity == null) continue;
                                arraylist_animal.add(testEntity);
                            }
                        }
                        if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                            arraylist_animal.add(new EntityHorse(world));
                        }
                        if (arraylist_animal.isEmpty()) continue;
                        animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                        if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities) {
                            String[] petname_a = NameGenerator.newRandomName("pet", random);
                            animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                        }
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampAnimalPen1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"        ", " F    F ", "        ", " F    F ", "  F     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 4;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 3;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SwampAnimalPen1() {
        }

        public SwampAnimalPen1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SwampAnimalPen1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)4, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SwampAnimalPen1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SwampAnimalPen1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStrippedLogVertState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 3, 1, 1, 3}, {6, 0, 3, 6, 1, 3}, {1, 0, 1, 1, 1, 1}, {6, 0, 1, 6, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 1, 2}, {2, 1, 3, 5, 1, 3}, {6, 1, 2, 6, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 3, 5, 0, 3}, {1, 0, 2, 6, 0, 2}, {2, 0, 1, 5, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 2, 1, 1, 2, 2}, {2, 2, 1, 5, 2, 1}, {6, 2, 1, 6, 2, 3}, {2, 2, 3, 5, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 3, 1, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 1, 0, 2, 4}, {1, 2, 4, 2, 2, 4}, {5, 2, 4, 7, 2, 4}, {7, 2, 0, 7, 2, 4}, {2, 2, 0, 6, 2, 0}, {2, 3, 2, 3, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeMossyCobblestoneSlabLowerState = ModObjects.chooseModMossyCobblestoneSlabState(false);
            biomeMossyCobblestoneSlabLowerState = biomeMossyCobblestoneSlabLowerState != null ? StructureVillageVN.getBiomeSpecificBlockState(biomeMossyCobblestoneSlabLowerState, this.materialType, this.biome, this.disallowModSubs) : biomeCobblestoneSlabLowerState;
            for (int[] uuvvww : new int[][]{{3, 2, 4, 4, 2, 4}, {4, 3, 2, 5, 3, 2}, {0, 2, 0, 1, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneSlabLowerState, biomeMossyCobblestoneSlabLowerState, false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2}, {3, 1, 1, 2}, {4, 1, 1, 2}, {5, 1, 1, 2}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{0, 1, 4}, {7, 1, 4}, {0, 1, 0}, {7, 1, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{3, 1, 2}, {5, 1, 2}}) {
                    if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel >= 2) continue;
                    ArrayList<Object> arraylist_animal = new ArrayList<Object>();
                    if (VillageGeneratorConfigHandler.animaniaLivestock) {
                        for (String animal_namespace : ModObjects.animania_chicken) {
                            EntityLiving testEntity = null;
                            try {
                                testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(animal_namespace), (World)world);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (testEntity == null) continue;
                            arraylist_animal.add(testEntity);
                        }
                    }
                    if (arraylist_animal.isEmpty() && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                        arraylist_animal.add(new EntityChicken(world));
                    }
                    if (arraylist_animal.isEmpty()) continue;
                    EntityLiving animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                    IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                    animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SwampMonolith
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"F   PPP    F", "  PPPPPFP   ", " PFPPFPPPP  ", " PPPFFFFPPP ", "PPPFFFFFFPF ", "PPPFFFFFFPPP", "FPPFFFFFFPPP", " PPFFFFFFFPP", " FPPFFFFPPP ", "  PPPPPPPPP ", "   PPPPPPP  ", "F    PPP   F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SwampMonolith() {
        }

        public SwampMonolith(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 70, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 70, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{5, 4, 4, 5})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (new int[]{4, 5, 5, 4})[this.func_186165_e().func_176736_b()], EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{4, 5, 5, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (new int[]{5, 4, 4, 5})[this.func_186165_e().func_176736_b()], EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            boolean hanging;
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 11}, {11, 1, 11}, {0, 1, 0}, {11, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] nArray = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(nArray[0], nArray[2]), this.func_74862_a(nArray[1]), this.func_74873_b(nArray[0], nArray[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(nArray[0], nArray[2]), 64, this.func_74873_b(nArray[0], nArray[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, nArray, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState darkPrismarineState = Blocks.field_180397_cI.func_176203_a(2);
            for (int[] uuvvww : new int[][]{{5, 1, 5, 6, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], darkPrismarineState, darkPrismarineState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 7, 7, 1, 7}, {4, 1, 5, 4, 1, 6}, {7, 1, 5, 7, 1, 6}, {4, 1, 4, 7, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 7, -1}, {7, 2, 7, -1}, {4, 2, 4, -1}, {7, 2, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signU = 6;
                int signV = 1;
                int signW = 3;
                int signO = 2;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                hanging = true;
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), iBlockState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                for (int[] uvwo : new int[][]{{4, 1, 1, 4}, {8, 1, 1, 12}}) {
                    int bannerU = uvwo[0];
                    int bannerV = uvwo[1];
                    int bannerW = uvwo[2];
                    hanging = false;
                    int bannerX = this.func_74865_a(bannerU, bannerW);
                    int bannerY = this.func_74862_a(bannerV);
                    int bannerZ = this.func_74873_b(bannerU, bannerW);
                    BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                    this.func_175811_a(world, biomeCobblestoneState, uvwo[0], uvwo[1] - 1, uvwo[2], structureBB);
                    world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwo[3], this.func_186165_e().func_176736_b(), false)), 2);
                    TileEntityBanner tilebanner = new TileEntityBanner();
                    ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                    tilebanner.func_175112_a(villageBanner, true);
                    world.func_175690_a(bannerPos, (TileEntity)tilebanner);
                }
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{6, 1, 2, -1, 0}, {1, 1, 4, -1, 0}, {4, 1, 9, -1, 0}, {10, 1, 5, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class SwampPavilion
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"   PPF  ", " PPPPPP ", "PPFPPFP ", "PFPFPPPP", "PPPPPFFP", " PFPPFPP", " PPPPPP ", "  FPP   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SwampPavilion() {
        }

        public SwampPavilion(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 69, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 69, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() < 2 ? 2 : 3), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() < 2 ? 2 : 3), EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() < 2 ? 3 : 2), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() < 2 ? 3 : 2), EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeLogVertState;
            IBlockState biomeStrippedLogVertState;
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if ((biomeStrippedLogVertState = (biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs))).func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 5, 2, 3, 5}, {5, 1, 5, 5, 3, 5}, {2, 1, 2, 2, 3, 2}, {5, 1, 2, 5, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 6, 4, 6}, {2, 5, 2, 5, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{1, 3, 6}, {6, 3, 6}, {1, 3, 1}, {6, 3, 1}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 4, 3, 0, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {3, 4, 4, 1, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {4, 4, 3, 3, GeneralConfig.useVillageColors ? this.townColor3 : 10}, {4, 4, 4, 2, GeneralConfig.useVillageColors ? this.townColor3 : 10}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            int signU = 2;
            int signV = 3;
            int signW = 1;
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signO = 2;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                boolean hanging = true;
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            } else {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(-1)), signU, signV, signW, structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 2, 1, 2, 10}, {5, 2, 1, 2, 10}}) {
                int bannerU = uvwoc[0];
                int bannerV = uvwoc[1];
                int bannerW = uvwoc[2];
                boolean hanging = true;
                int bannerX = this.func_74865_a(bannerU, bannerW);
                int bannerY = this.func_74862_a(bannerV);
                int bannerZ = this.func_74873_b(bannerU, bannerW);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                if (GeneralConfig.useVillageColors) {
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{3, 1, 3, -1, 0}, {1, 1, 2, -1, 0}, {0, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class SwampStatue
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{" F  PFF   ", "    FPP  F", "   PPPP   ", "F PFFFFPF ", "PPPFFFFPP ", "PPPFFFFFPP", "PPFFFFFFPP", "  FFPPPPPP", "F FFFPPF  ", "    PPP  F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SwampStatue() {
        }

        public SwampStatue(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 71, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 71, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{4, 4, 4, 3})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (new int[]{2, 4, 5, 4})[this.func_186165_e().func_176736_b()], EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{4, 5, 4, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (new int[]{3, 4, 4, 4})[this.func_186165_e().func_176736_b()], EnumFacing.WEST, this.func_74877_c());
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            boolean hanging;
            Block block;
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 2}, {9, 1, 0}, {1, 1, 9}, {9, 1, 8}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] nArray = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(nArray[0], nArray[2]), this.func_74862_a(nArray[1]), this.func_74873_b(nArray[0], nArray[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(nArray[0], nArray[2]), 64, this.func_74873_b(nArray[0], nArray[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, nArray, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState darkPrismarineState = Blocks.field_180397_cI.func_176203_a(2);
            for (int[] uuvvww : new int[][]{{3, 1, 3, 6, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], darkPrismarineState, darkPrismarineState, false);
            }
            Object var19_25 = null;
            IBlockState biomePrismarineBlockState = null;
            IBlockState biomePrismarineSlabUpperState = null;
            IBlockState biomePrismarineSlabLowerState = null;
            IBlockState biomePrismarineWallState = null;
            boolean useOnlyStone = false;
            while (true) {
                void var19_29;
                if (useOnlyStone) {
                    Block block2 = Blocks.field_150446_ar;
                } else {
                    Block block3 = ModObjects.chooseModPrismarineStairsBlock();
                    if (block3 == null) {
                        useOnlyStone = true;
                        continue;
                    }
                }
                block = StructureVillageVN.getBiomeSpecificBlockState(var19_29.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
                if (useOnlyStone) {
                    biomePrismarineBlockState = Blocks.field_150347_e.func_176203_a(0);
                } else if (biomePrismarineBlockState == null) {
                    useOnlyStone = true;
                    continue;
                }
                biomePrismarineBlockState = StructureVillageVN.getBiomeSpecificBlockState(biomePrismarineBlockState, this.materialType, this.biome, this.disallowModSubs);
                if (useOnlyStone) {
                    biomePrismarineSlabLowerState = Blocks.field_150333_U.func_176203_a(3);
                } else {
                    biomePrismarineSlabLowerState = ModObjects.chooseModPrismarineSlabState(false);
                    if (biomePrismarineSlabLowerState == null) {
                        useOnlyStone = true;
                        continue;
                    }
                }
                biomePrismarineSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(biomePrismarineSlabLowerState, this.materialType, this.biome, this.disallowModSubs);
                if (useOnlyStone) {
                    biomePrismarineSlabUpperState = Blocks.field_150333_U.func_176203_a(11);
                } else {
                    biomePrismarineSlabUpperState = ModObjects.chooseModPrismarineSlabState(true);
                    if (biomePrismarineSlabUpperState == null) {
                        useOnlyStone = true;
                        continue;
                    }
                }
                biomePrismarineSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(biomePrismarineSlabUpperState, this.materialType, this.biome, this.disallowModSubs);
                if (useOnlyStone) {
                    biomePrismarineWallState = Blocks.field_150463_bK.func_176203_a(0);
                    break;
                }
                biomePrismarineWallState = ModObjects.chooseModPrismarineWallState();
                if (biomePrismarineWallState != null) break;
                useOnlyStone = true;
            }
            biomePrismarineWallState = StructureVillageVN.getBiomeSpecificBlockState(biomePrismarineWallState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 3, 3, 3}, {5, 3, 3, 3}, {4, 3, 5, 7}, {5, 3, 5, 7}, {4, 3, 6, 6}, {5, 3, 6, 6}, {3, 5, 4, 3}, {6, 5, 4, 3}, {4, 6, 3, 3}, {5, 6, 3, 3}, {4, 6, 6, 2}, {5, 6, 6, 2}}) {
                this.func_175811_a(world, block.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 4, 4, 5, 4, 4}, {4, 4, 6, 5, 5, 6}, {4, 6, 4, 5, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePrismarineBlockState, biomePrismarineBlockState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 4, 5, 5, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePrismarineSlabLowerState, biomePrismarineSlabLowerState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 4, 4, 3, 4, 4}, {6, 4, 4, 6, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePrismarineSlabUpperState, biomePrismarineSlabUpperState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 5, 5, 3, 5, 6}, {6, 5, 5, 6, 5, 6}, {4, 5, 7, 5, 6, 7}, {4, 5, 4, 5, 5, 4}, {4, 3, 4, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePrismarineWallState, biomePrismarineWallState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 5, 3, 5, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            Block polishedBlackstoneButtonBlock = ModObjects.chooseModPolishedBlackstoneButton();
            if (polishedBlackstoneButtonBlock == null) {
                polishedBlackstoneButtonBlock = Blocks.field_150430_aB;
            }
            for (int[] uuvvwwo : new int[][]{{3, 1, 2, 6, 1, 2, 2}, {2, 1, 3, 2, 1, 6, 3}, {7, 1, 3, 7, 1, 6, 1}, {3, 1, 7, 6, 1, 7, 0}, {4, 7, 3, 5, 7, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], polishedBlackstoneButtonBlock.func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), polishedBlackstoneButtonBlock.func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 1}, {7, 0, 1}, {0, 0, 6}, {8, 0, 6}, {5, 0, 9}}) {
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 15), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1}, {7, 1, 1}, {0, 1, 6}, {8, 1, 6}, {5, 1, 9}}) {
                this.func_175811_a(world, biomeFenceState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{0, 2, 6, -1}, {8, 2, 6, -1}, {5, 2, 9, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int signU = 2;
            int signV = 2;
            int signW = 1;
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signO = 4;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                hanging = false;
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            } else {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(-1)), signU, signV, signW, structureBB);
            }
            int bannerU = 7;
            int bannerV = 2;
            int bannerW = 1;
            if (GeneralConfig.villageBanners) {
                int bannerO = 12;
                hanging = false;
                int bannerX = this.func_74865_a(bannerU, bannerW);
                int bannerY = this.func_74862_a(bannerV);
                int bannerZ = this.func_74873_b(bannerU, bannerW);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(bannerO, this.func_186165_e().func_176736_b(), hanging)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, true);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            } else {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(-1)), bannerU, bannerV, bannerW, structureBB);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{6, 1, 1, -1, 0}, {8, 1, 4, -1, 0}, {4, 1, 8, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class SwampWillow
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"F PPPPP F", " PPFFFPP ", "PPFFFFFPP", "PFFFFFFFP", "PFFFFFFFP", "PFFFFFFFP", "PPFFFFFPP", " PPFFFPP ", "F PPPPP F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 13;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SwampWillow() {
        }

        public SwampWillow(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 76, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 76, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 0}, {8, 1, 0}, {0, 1, 0}, {8, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{1, 0, 3, 1, 0, 5}, {2, 0, 2, 2, 0, 3}, {2, 0, 5, 2, 0, 5}, {3, 0, 1, 5, 0, 2}, {3, 0, 7, 5, 0, 7}, {6, 0, 2, 6, 0, 3}, {6, 0, 6, 6, 0, 6}, {7, 0, 3, 7, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 4, 2, 0, 4}, {2, 0, 6, 5, 0, 6}, {6, 0, 4, 6, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyCobblestoneState, biomeMossyCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 0, 5, 3, 1, 5}, {4, 0, 5, 4, 2, 5}, {5, 0, 5, 5, 0, 5}, {3, 0, 4, 3, 3, 4}, {4, 0, 4, 4, 9, 4}, {5, 0, 4, 5, 2, 4}, {3, 0, 3, 3, 1, 3}, {5, 0, 3, 5, 1, 3}, {4, 10, 5, 4, 10, 5}, {3, 11, 4, 3, 11, 4}, {6, 7, 4, 6, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState;
            if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
            }
            if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 2, 5}, {4, 3, 5}, {5, 1, 5}, {3, 4, 4}, {5, 3, 4}, {3, 2, 3}, {4, 0, 3}, {4, 2, 3}, {4, 3, 3}, {5, 2, 3}}) {
                this.func_175811_a(world, biomeStrippedWoodOrLogOrLogVerticState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 7, 4, 3, 7, 4}, {5, 6, 4, 5, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 5, 3, 1, 7, 3}, {1, 7, 4, 1, 7, 4}, {1, 11, 4, 1, 11, 4}, {1, 6, 5, 1, 8, 5}, {2, 7, 3, 2, 7, 3}, {2, 11, 3, 2, 11, 3}, {2, 8, 4, 2, 8, 4}, {2, 10, 4, 2, 12, 4}, {2, 7, 5, 2, 8, 5}, {2, 11, 5, 2, 11, 5}, {2, 4, 6, 2, 7, 6}, {3, 4, 2, 3, 5, 2}, {3, 8, 2, 3, 10, 2}, {3, 5, 3, 3, 6, 3}, {3, 9, 3, 3, 11, 3}, {3, 10, 4, 3, 10, 4}, {3, 12, 4, 3, 12, 4}, {3, 6, 5, 3, 6, 5}, {3, 10, 5, 3, 12, 5}, {3, 9, 6, 3, 10, 6}, {4, 8, 3, 4, 9, 3}, {4, 11, 3, 4, 11, 3}, {4, 10, 4, 4, 11, 4}, {4, 6, 5, 4, 7, 5}, {4, 9, 5, 4, 9, 5}, {4, 11, 5, 4, 11, 5}, {4, 5, 6, 4, 11, 6}, {5, 5, 2, 5, 9, 2}, {5, 6, 3, 5, 6, 3}, {5, 9, 3, 5, 10, 3}, {5, 9, 4, 5, 9, 4}, {5, 6, 5, 5, 6, 5}, {5, 10, 5, 5, 11, 5}, {5, 8, 6, 5, 10, 6}, {5, 4, 7, 5, 9, 7}, {6, 3, 1, 6, 7, 1}, {6, 6, 2, 6, 9, 2}, {6, 4, 3, 6, 10, 3}, {6, 6, 4, 6, 6, 4}, {6, 9, 4, 6, 9, 4}, {6, 3, 5, 6, 7, 5}, {7, 7, 2, 7, 8, 2}, {7, 2, 3, 7, 9, 3}, {7, 5, 4, 7, 7, 4}, {7, 7, 5, 7, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150362_t.func_176203_a(4), Blocks.field_150362_t.func_176203_a(4), false);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{3, 5, 4, 3}, {3, 6, 4, 3}, {3, 8, 4, 3}, {3, 9, 4, 3}, {4, 4, 5, 0}, {4, 5, 5, 0}, {4, 8, 5, 0}, {6, 8, 5, 0}, {5, 5, 4, 1}, {5, 7, 4, 1}, {5, 8, 4, 1}, {7, 8, 4, 1}, {4, 4, 3, 2}, {4, 5, 3, 2}, {4, 6, 3, 2}, {4, 7, 3, 2}, {6, 4, 2, 2}, {6, 5, 2, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signU = 3;
                int signV = 1;
                int signW = 2;
                int signO = 8;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                boolean hanging = false;
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerU = 4;
                int bannerV = 3;
                int bannerW = 2;
                int bannerO = 2;
                boolean hanging = true;
                int bannerX = this.func_74865_a(bannerU, bannerW);
                int bannerY = this.func_74862_a(bannerV);
                int bannerZ = this.func_74873_b(bannerU, bannerW);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(bannerO, this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                if (GeneralConfig.useVillageColors) {
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 0);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{1, 1, 3, -1, 0}, {2, 1, 8, -1, 0}, {7, 1, 7, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }
}

