/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.biomestructures;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.chestloot.ChestGenHooks;
import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SavannaStructures {
    public static ArrayList<BlueprintData> getRandomSavannaDecorBlueprint(FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        int decorCount = 1;
        return SavannaStructures.getSavannaDecorBlueprint(random.nextInt(decorCount), materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static ArrayList<BlueprintData> getSavannaDecorBlueprint(int decorType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        IBlockState biomeGrassState;
        ArrayList<BlueprintData> blueprint = new ArrayList<BlueprintData>();
        IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), materialType, biome, disallowModSubs);
        if (biome != null && biome.field_76752_A != null) {
            biomeTopState = biome.field_76752_A;
        }
        IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), materialType, biome, disallowModSubs);
        switch (decorType) {
            case 0: {
                BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, biomeFenceState);
                BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, Blocks.field_150478_aa.func_176203_a(0));
                BlueprintData.addPlaceBlock(blueprint, 0, -1, 0, biomeTopState);
            }
        }
        return blueprint;
    }

    public static class SavannaStreetSubstitute4
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFF      ", " FFFFF     ", " FFFFFFF   ", "FFFFFFF    ", "  FFFF     ", " FFFF      ", " FFFFF     ", "FFFFFF     ", " FFFFFF    ", "  FFFFF    ", "  FFFFFF   ", " FFFFFFFF  ", " FFFFFFFF  ", "  FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 2;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaStreetSubstitute4() {
        }

        public SavannaStreetSubstitute4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaStreetSubstitute4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)2, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)(-4 - STRUCTURE_DEPTH), (int)STRUCTURE_WIDTH, (int)18, (int)-4, (EnumFacing)coordBaseMode);
            return SavannaStreetSubstitute4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new SavannaStreetSubstitute4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uvwpmc : new int[][]{{2, 0, 0, 0, 7, 0}, {3, 0, 0, 0, 7, 0}, {4, 0, 0, 0, 7, 0}, {5, 0, 0, 0, 7, 0}, {6, 0, 0, 0, 7, -1}, {7, 0, 0, 0, 7, 0}, {9, 0, 0, 0, 7, 0}, {10, 0, 0, 1, 7, 0}, {1, 0, 1, 0, 7, 0}, {2, 0, 1, 0, 7, 0}, {3, 0, 1, 0, 7, 0}, {4, 0, 1, 0, 7, 0}, {6, 0, 1, 1, 7, 0}, {7, 0, 1, 0, 7, -1}, {8, 0, 1, 0, 7, 0}, {1, 0, 2, 0, 7, 0}, {3, 0, 2, 0, 7, 0}, {4, 0, 2, 0, 7, 0}, {5, 0, 2, 0, 7, 0}, {6, 0, 2, 1, 7, 1}, {7, 0, 2, 1, 7, 1}, {8, 0, 2, 0, 7, 0}, {2, 0, 3, 0, 7, 0}, {3, 0, 3, 1, 7, 0}, {4, 0, 3, 1, 7, 0}, {5, 0, 3, 0, 7, 1}, {6, 0, 3, 0, 7, 1}, {7, 0, 3, 0, 7, 1}, {2, 0, 4, 0, 7, 0}, {3, 0, 4, 0, 7, 0}, {4, 0, 4, 0, 7, 1}, {6, 0, 4, 0, 7, 1}, {1, 0, 5, 0, 7, 0}, {2, 0, 5, 0, 7, 0}, {4, 0, 5, 0, 7, 0}, {5, 0, 5, 0, 7, 1}, {6, 0, 5, 0, 7, 1}, {0, 0, 6, 0, 7, 0}, {1, 0, 6, 0, 7, 0}, {2, 0, 6, 0, 7, 0}, {3, 0, 6, 0, 7, 0}, {4, 0, 6, 0, 7, 0}, {5, 0, 6, 0, 7, 0}, {1, 0, 7, 0, 7, 1}, {2, 0, 7, 0, 7, 1}, {3, 0, 7, 1, 7, 0}, {4, 0, 7, 0, 7, 0}, {5, 0, 7, 0, 7, 0}, {1, 0, 8, 0, 7, 1}, {2, 0, 8, 0, 7, 0}, {3, 0, 8, 0, 7, 0}, {4, 0, 8, 0, 7, 0}, {2, 0, 9, 0, 7, 0}, {3, 0, 9, 0, 7, 0}, {4, 0, 9, 0, 7, 0}, {5, 0, 9, 0, 7, 0}, {0, 0, 10, 0, 7, 0}, {1, 0, 10, 0, 0, 0}, {3, 0, 10, 0, 0, 0}, {4, 0, 10, 0, 7, 0}, {5, 0, 10, 1, 7, 0}, {6, 0, 10, 0, 7, 0}, {1, 0, 11, 0, 0, 0}, {2, 0, 11, 0, 0, 0}, {3, 0, 11, 0, 7, 0}, {5, 0, 11, 0, 7, 0}, {6, 0, 11, 0, 7, 0}, {7, 0, 11, 0, 7, 0}, {1, 0, 12, 0, 0, 1}, {2, 0, 12, 1, 7, 1}, {3, 0, 12, 0, 7, 0}, {4, 0, 12, 0, 7, 0}, {5, 0, 12, 0, 7, 0}, {2, 0, 13, 0, 7, 0}, {3, 0, 13, 0, 7, 0}, {4, 0, 13, 0, 0, 0}}) {
                this.func_175808_b(world, biomeFillerState, uvwpmc[0], uvwpmc[1] - 1, uvwpmc[2], structureBB);
                this.func_74871_b(world, uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                if (uvwpmc[5] != -1) {
                    this.func_175811_a(world, uvwpmc[5] == 1 ? Blocks.field_150394_bc.func_176223_P() : Blocks.field_150464_aj.func_176203_a(uvwpmc[3]), uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                }
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwpmc[4]), uvwpmc[0], uvwpmc[1], uvwpmc[2], structureBB);
            }
            for (int[] uvw : new int[][]{{8, 0, -1}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]), false);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{8, 0, 0}, {5, 0, 1}, {2, 0, 2}, {5, 0, 4}, {3, 0, 5}, {2, 0, 10}, {4, 0, 11}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaStreetSubstitute3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFF", "FFFF", " FF ", "    ", "    ", "    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 2;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;
        private int farmGroundLevel = 0;

        public SavannaStreetSubstitute3() {
        }

        public SavannaStreetSubstitute3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaStreetSubstitute3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)2, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)(-4 - STRUCTURE_DEPTH), (int)STRUCTURE_WIDTH, (int)18, (int)-4, (EnumFacing)coordBaseMode);
            return SavannaStreetSubstitute3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new SavannaStreetSubstitute3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            ArrayList<Integer> otherSideRoadHeights = new ArrayList<Integer>();
            for (int[] uw : new int[][]{{0, 4}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {3, 4}, {3, 5}}) {
                int aboveTopLevel = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uw[0], uw[1]), 64, this.func_74873_b(uw[0], uw[1]))).func_177956_o();
                if (aboveTopLevel == -1) continue;
                otherSideRoadHeights.add(aboveTopLevel);
            }
            if (FunctionsVN.medianIntArray(otherSideRoadHeights, true) > 0) {
                this.farmGroundLevel = FunctionsVN.medianIntArray(otherSideRoadHeights, true) - this.averageGroundLevel;
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uvwpmc : new int[][]{{0, this.farmGroundLevel, 4, 0, 0, 0}, {1, this.farmGroundLevel, 3, 0, 7, 0}, {1, this.farmGroundLevel, 4, 0, 0, 0}, {1, this.farmGroundLevel, 5, 0, 7, 0}, {2, this.farmGroundLevel, 3, 0, 7, 0}, {2, this.farmGroundLevel, 5, 0, 0, 0}, {3, this.farmGroundLevel, 4, 1, 7, 0}, {3, this.farmGroundLevel, 5, 0, 7, 0}}) {
                this.func_175808_b(world, biomeFillerState, uvwpmc[0], uvwpmc[1] - 1, uvwpmc[2], structureBB);
                this.func_74871_b(world, uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                this.func_175811_a(world, uvwpmc[5] == 1 ? Blocks.field_150394_bc.func_176223_P() : Blocks.field_150464_aj.func_176203_a(uvwpmc[3]), uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwpmc[4]), uvwpmc[0], uvwpmc[1], uvwpmc[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, this.farmGroundLevel, 4}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaStreetSubstitute2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"          FF  ", "        FFFFF ", "    FF FFFFFF ", "  FFFFFFFFFFF ", " FFFFFFFFFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 3;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;
        private int otherSideOffset = 0;
        private static final int OTHERSIDE_MIN_U = 1;
        private static final int OTHERSIDE_MAX_U = 11;

        public SavannaStreetSubstitute2() {
        }

        public SavannaStreetSubstitute2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaStreetSubstitute2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)3, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)(-4 - STRUCTURE_DEPTH), (int)STRUCTURE_WIDTH, (int)19, (int)-4, (EnumFacing)coordBaseMode);
            return SavannaStreetSubstitute2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new SavannaStreetSubstitute2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            ArrayList<Integer> otherSideRoadHeights = new ArrayList<Integer>();
            for (int i = 1; i <= 11; ++i) {
                int aboveTopLevel = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(i, -4), 64, this.func_74873_b(i, -4))).func_177956_o();
                if (aboveTopLevel == -1) continue;
                otherSideRoadHeights.add(aboveTopLevel);
            }
            if (FunctionsVN.medianIntArray(otherSideRoadHeights, true) > 0) {
                this.otherSideOffset = FunctionsVN.medianIntArray(otherSideRoadHeights, true) - this.averageGroundLevel;
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{4, 1, 0}, {12, 1, -2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 2, uvw[2], structureBB);
                this.func_175811_a(world, biomeTopState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 2, uvw[2], structureBB);
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && uvw[2] >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 0, 0}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 0, -1}, {6, this.otherSideOffset, -3}, {9, this.otherSideOffset, -3}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]), false);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uvwpmc : new int[][]{{1, 0, 0, 0, 7, 0}, {2, 0, 1, 1, 7, 0}, {3, 0, 1, 0, 7, 0}, {4, 0, 1, 0, 7, 1}, {4, 0, 2, 0, 7, 0}, {5, 0, 0, 0, 7, 1}, {5, 0, 2, 0, 7, 0}, {6, 0, 1, 0, 7, 1}, {6, 0, 0, 1, 7, 0}, {7, 0, 0, 0, 7, 0}, {7, 0, 1, 0, 7, 0}, {7, 0, 2, 1, 7, 0}, {8, 0, 0, 1, 7, 0}, {8, 0, 2, 1, 7, 0}, {8, 0, 3, 1, 7, 0}, {9, 0, 0, 0, 7, 0}, {9, 0, 1, 0, 7, 0}, {9, 0, 2, 0, 7, 0}, {9, 0, 3, 1, 7, 0}, {10, 0, 0, 0, 7, 1}, {10, 0, 1, 1, 7, 1}, {10, 0, 2, 2, 7, 0}, {10, 0, 3, 0, 7, 0}, {10, 0, 4, 0, 7, 0}, {11, 0, 0, 0, 7, 1}, {11, 0, 1, 2, 7, 1}, {11, 0, 3, 0, 7, 0}, {11, 0, 4, 0, 7, 0}, {12, 0, 0, 1, 7, 0}, {12, 0, 1, 0, 7, 0}, {12, 0, 2, 2, 7, 0}, {12, 0, 3, 0, 7, 0}, {1, this.otherSideOffset, -4, 1, 7, 0}, {2, this.otherSideOffset, -4, 1, 7, 1}, {2, this.otherSideOffset, -5, 0, 7, 1}, {3, this.otherSideOffset, -4, 1, 7, 0}, {3, this.otherSideOffset, -6, 0, 7, 0}, {4, this.otherSideOffset, -4, 0, 7, 0}, {4, this.otherSideOffset, -5, 0, 7, 0}, {5, this.otherSideOffset, -4, 1, 7, 1}, {5, this.otherSideOffset, -5, 0, 7, 1}, {5, this.otherSideOffset, -6, 0, 7, 1}, {6, this.otherSideOffset, -5, 0, 7, 0}, {7, this.otherSideOffset, -4, 0, 7, 0}, {7, this.otherSideOffset, -5, 0, 7, 0}, {8, this.otherSideOffset, -4, 1, 7, 0}, {8, this.otherSideOffset, -5, 1, 7, 0}, {8, this.otherSideOffset, -6, 0, 7, 0}, {9, this.otherSideOffset, -5, 1, 7, 0}, {10, this.otherSideOffset, -4, 0, 7, 0}, {11, this.otherSideOffset, -4, 0, 7, 0}}) {
                this.func_175808_b(world, biomeFillerState, uvwpmc[0], uvwpmc[1] - 1, uvwpmc[2], structureBB);
                this.func_74871_b(world, uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                this.func_175811_a(world, uvwpmc[5] == 1 ? Blocks.field_150394_bc.func_176223_P() : Blocks.field_150464_aj.func_176203_a(uvwpmc[3]), uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwpmc[4]), uvwpmc[0], uvwpmc[1], uvwpmc[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 0, 0}, {5, 0, 1}, {8, 0, 1}, {11, 0, 2}, {3, this.otherSideOffset, -5}, {6, this.otherSideOffset, -4}, {9, this.otherSideOffset, -4}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaStreetSubstitute1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       FF   ", "    FFFFFFF ", "  FFFFFFFFF ", " FFFFFFFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 3;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;
        private int otherSideOffset = 0;
        private static final int OTHERSIDE_MIN_U = 1;
        private static final int OTHERSIDE_MAX_U = 4;

        public SavannaStreetSubstitute1() {
        }

        public SavannaStreetSubstitute1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaStreetSubstitute1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)3, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)(-4 - STRUCTURE_DEPTH), (int)STRUCTURE_WIDTH, (int)19, (int)-4, (EnumFacing)coordBaseMode);
            return SavannaStreetSubstitute1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new SavannaStreetSubstitute1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            ArrayList<Integer> otherSideRoadHeights = new ArrayList<Integer>();
            for (int i = 1; i <= 4; ++i) {
                int aboveTopLevel = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(i, -4), 64, this.func_74873_b(i, -4))).func_177956_o();
                if (aboveTopLevel == -1) continue;
                otherSideRoadHeights.add(aboveTopLevel);
            }
            if (FunctionsVN.medianIntArray(otherSideRoadHeights, true) > 0) {
                this.otherSideOffset = FunctionsVN.medianIntArray(otherSideRoadHeights, true) - this.averageGroundLevel;
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{4, 1, 0}, {7, 1, 2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 2, uvw[2], structureBB);
                this.func_175811_a(world, biomeTopState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && uvw[2] >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 0, -1}, {9, 0, -1}, {3, this.otherSideOffset, -3}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]), false);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uvwpmc : new int[][]{{1, 0, 0, 2, 7, 0}, {2, 0, 1, 1, 7, 0}, {3, 0, 0, 0, 7, 0}, {3, 0, 1, 0, 7, 0}, {4, 0, 2, 2, 7, 0}, {4, 0, 1, 1, 7, 1}, {5, 0, 0, 0, 7, 1}, {5, 0, 2, 0, 7, 0}, {6, 0, 0, 1, 7, 0}, {6, 0, 2, 1, 7, 0}, {7, 0, 0, 0, 7, 0}, {7, 0, 1, 0, 7, 0}, {7, 0, 3, 1, 7, 0}, {8, 0, 0, 2, 7, 1}, {8, 0, 1, 2, 7, 0}, {8, 0, 2, 2, 7, 0}, {8, 0, 3, 0, 7, 0}, {9, 0, 1, 1, 7, 0}, {9, 0, 2, 0, 7, 0}, {10, 0, 0, 0, 7, 0}, {10, 0, 1, 2, 7, 0}, {10, 0, 2, 1, 7, 0}, {1, this.otherSideOffset, -4, 1, 7, 0}, {2, this.otherSideOffset, -4, 2, 7, 1}, {2, 0, -5, 0, 0, 0}, {3, this.otherSideOffset, -5, 0, 0, 0}, {4, this.otherSideOffset, -4, 0, 0, 1}}) {
                this.func_175808_b(world, biomeFillerState, uvwpmc[0], uvwpmc[1] - 1, uvwpmc[2], structureBB);
                this.func_74871_b(world, uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                this.func_175811_a(world, uvwpmc[5] == 1 ? Blocks.field_150394_bc.func_176223_P() : Blocks.field_150464_aj.func_176203_a(uvwpmc[3]), uvwpmc[0], uvwpmc[1] + 1, uvwpmc[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwpmc[4]), uvwpmc[0], uvwpmc[1], uvwpmc[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 0, 0}, {5, 0, 1}, {6, 0, 1}, {9, 0, 0}, {3, this.otherSideOffset, -4}}) {
                this.func_175808_b(world, biomeFillerState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaStreetDecor1
    extends StructureVillageVN.VNComponent {
        public static final int STRUCTURE_WIDTH = 3;
        public static final int STRUCTURE_DEPTH = 6;
        public static final int STRUCTURE_HEIGHT = 2;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaStreetDecor1() {
        }

        public SavannaStreetDecor1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaStreetDecor1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)2, (int)6, (EnumFacing)coordBaseMode);
            return SavannaStreetDecor1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaStreetDecor1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorDepth;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                uvw[2] = decorDepth = ((Integer)FunctionsVN.weightedRandom(new int[]{-2, 0, 1, 2, 3, 4, 5}, new double[]{2.0, 3.0, 4.0, 3.0, 2.0, 1.0, 2.0}, randomFromXYZ)).intValue();
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (decorDepth < 0) {
                    int nonairSurrounding = 0;
                    int decorY = this.func_74862_a(decorHeightY);
                    for (int i = 0; i < 8; ++i) {
                        int z;
                        int[][] surroundpos = new int[][]{{0, 0}, {0, 1}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {1, 0}};
                        int u = surroundpos[i][0];
                        int w = surroundpos[i][0];
                        int x = this.func_74865_a(u, w);
                        BlockPos pos = new BlockPos(x, decorY, z = this.func_74873_b(u, w));
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || ++nonairSurrounding < 4) continue;
                        ++decorHeightY;
                        break;
                    }
                }
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 2, uvw[2], structureBB);
                this.func_175811_a(world, biomeTopState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && decorDepth >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaWeaponsmith2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"             ", "  FFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", "  FFFFFFFFFF ", "  FFFFFFFFFF ", "  FFFFFFFFFF ", "    FFFFFFF  ", "    FFFFF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaWeaponsmith2() {
        }

        public SavannaWeaponsmith2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaWeaponsmith2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaWeaponsmith2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaWeaponsmith2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{1, 1, 5, 1, 2, 5}, {1, 1, 6, 1, 4, 6}, {2, 1, 7, 10, 4, 7}, {11, 1, 2, 11, 4, 6}, {9, 1, 1, 9, 4, 1}, {7, 1, 4, 7, 4, 4}, {6, 1, 4, 6, 1, 4}, {5, 1, 4, 5, 2, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{6, 4, 4, 6, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{6, 4, 3, 2}, {11, 3, 1, 2}, {4, 4, 6, 2}, {8, 4, 6, 2}, {9, 4, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uw : new int[][]{{8, 1, 2, 8, 4, 3}, {10, 1, 1, 10, 4, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 6, 1, 5, 7}, {2, 5, 7, 10, 5, 7}, {11, 5, 1, 11, 5, 7}, {9, 5, 1, 10, 5, 1}, {8, 5, 1, 8, 5, 4}, {6, 5, 4, 7, 5, 4}, {2, 6, 5, 10, 6, 6}, {9, 6, 2, 10, 6, 4}, {5, 1, 5, 10, 1, 6}, {8, 1, 4, 10, 1, 4}, {9, 1, 2, 10, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{8, 5, 0, 3}, {9, 5, 0, 3}, {10, 5, 0, 3}, {11, 5, 0, 3}, {8, 6, 1, 3}, {9, 6, 1, 3}, {10, 6, 1, 3}, {11, 6, 1, 3}, {6, 5, 3, 3}, {7, 5, 3, 3}, {1, 6, 4, 3}, {2, 6, 4, 3}, {3, 6, 4, 3}, {4, 6, 4, 3}, {5, 6, 4, 3}, {6, 6, 4, 3}, {7, 6, 4, 3}, {8, 6, 4, 3}, {1, 5, 8, 2}, {2, 5, 8, 2}, {3, 5, 8, 2}, {4, 5, 8, 2}, {5, 5, 8, 2}, {6, 5, 8, 2}, {7, 5, 8, 2}, {8, 5, 8, 2}, {9, 5, 8, 2}, {10, 5, 8, 2}, {11, 5, 8, 2}, {1, 6, 7, 2}, {2, 6, 7, 2}, {3, 6, 7, 2}, {4, 6, 7, 2}, {5, 6, 7, 2}, {6, 6, 7, 2}, {7, 6, 7, 2}, {8, 6, 7, 2}, {9, 6, 7, 2}, {10, 6, 7, 2}, {11, 6, 7, 2}, {0, 5, 6, 0}, {0, 5, 7, 0}, {1, 6, 5, 0}, {1, 6, 6, 0}, {7, 5, 1, 0}, {7, 5, 2, 0}, {8, 6, 2, 0}, {8, 6, 3, 0}, {12, 5, 1, 1}, {12, 5, 2, 1}, {12, 5, 3, 1}, {12, 5, 4, 1}, {12, 5, 5, 1}, {12, 5, 6, 1}, {12, 5, 7, 1}, {11, 6, 2, 1}, {11, 6, 3, 1}, {11, 6, 4, 1}, {11, 6, 5, 1}, {11, 6, 6, 1}, {8, 2, 6, 1}, {10, 2, 6, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{9, 2, 6}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 3, 7}, {8, 3, 7}, {11, 3, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState smoothStoneState = ModObjects.chooseModSmoothStoneBlockState();
            for (int[] uuvvww : new int[][]{{5, 1, 1, 7, 1, 3}, {2, 1, 2, 4, 2, 4}, {2, 3, 4, 5, 5, 4}, {1, 3, 5, 1, 5, 5}, {1, 5, 4, 1, 5, 4}, {2, 1, 5, 4, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], smoothStoneState, smoothStoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 5, 4, 0, 5, 5}, {1, 5, 3, 5, 5, 3}, {2, 5, 2, 4, 5, 2}, {4, 1, 1, 4, 1, 1}, {8, 1, 1, 8, 1, 1}, {4, 1, 0, 8, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150333_U.func_176203_a(0), Blocks.field_150333_U.func_176203_a(0), false);
            }
            this.func_175804_a(world, structureBB, 3, 2, 3, 3, 2, 3, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            for (int[] uuvvww : new int[][]{{2, 3, 2, 2, 4, 3}, {3, 3, 2, 4, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int[] uvwoh : new int[][]{{6, 2, 2, 2, 0}, {3, 2, 5, 0, 1}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwoh[3], this.func_186165_e(), uvwoh[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwoh[0], uvwoh[1], uvwoh[2], structureBB);
            }
            int chestU = 9;
            int chestV = 2;
            int chestW = 2;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof TileEntityChest) {
                ((TileEntityChest)te).func_189404_a(LootTableList.field_186423_e, random.nextLong());
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 2, 4, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, -1}, {5, 1, -1}, {6, 1, -1}, {7, 1, -1}, {8, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 6;
                int v = 3;
                int w = 5;
                int s = random.nextInt(7);
                if (s == 0) {
                    u = 2;
                    w = 5;
                } else if (s <= 6) {
                    u = s - 1;
                    w = 6;
                } else if (s <= 13) {
                    u = s - 3;
                    w = 5;
                } else if (s <= 16) {
                    u = s - 6;
                    w = 4;
                } else if (s <= 18) {
                    u = s - 8;
                    w = 3;
                } else if (s == 19) {
                    u = 9;
                    w = 2;
                } else if (s <= 22) {
                    u = s - 15;
                    w = 3;
                } else if (s == 23) {
                    u = 5;
                    w = 2;
                } else if (s == 24) {
                    u = 7;
                    w = 2;
                } else if (s <= 27) {
                    u = s - 20;
                    w = 1;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SavannaWeaponsmith1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFFFF", " FFFFFFFF", " FFFFFFFF", " FFFFFFFF", " FFFFFFFF", "FFFFPFFFF", "FFFFPFFFF", "FFFFPFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaWeaponsmith1() {
        }

        public SavannaWeaponsmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaWeaponsmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaWeaponsmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaWeaponsmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 3, 3, 3, 3}, {5, 1, 3, 6, 3, 3}, {2, 1, 6, 2, 3, 6}, {3, 1, 6, 3, 1, 6}, {4, 1, 6, 4, 3, 6}, {5, 1, 6, 5, 1, 6}, {6, 1, 6, 6, 3, 6}, {1, 1, 4, 1, 3, 5}, {7, 1, 4, 7, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{4, 3, 3, 4, 3, 3}, {3, 3, 6, 3, 3, 6}, {5, 3, 6, 5, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 4, 2, 0, 5}, {4, 0, 3, 4, 0, 5}, {6, 0, 4, 6, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 0, 4, 3, 0, 5}, {5, 0, 4, 5, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 5, 2}, {5, 3, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 3, 7, 4, 3}, {1, 4, 4, 1, 4, 5}, {1, 4, 6, 7, 4, 6}, {7, 4, 4, 7, 4, 5}, {2, 5, 4, 6, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 2, 3}, {2, 4, 2, 3}, {3, 4, 2, 3}, {4, 4, 2, 3}, {5, 4, 2, 3}, {6, 4, 2, 3}, {7, 4, 2, 3}, {1, 5, 3, 3}, {2, 5, 3, 3}, {3, 5, 3, 3}, {4, 5, 3, 3}, {5, 5, 3, 3}, {6, 5, 3, 3}, {7, 5, 3, 3}, {1, 4, 7, 2}, {2, 4, 7, 2}, {3, 4, 7, 2}, {4, 4, 7, 2}, {5, 4, 7, 2}, {6, 4, 7, 2}, {7, 4, 7, 2}, {1, 5, 6, 2}, {2, 5, 6, 2}, {3, 5, 6, 2}, {4, 5, 6, 2}, {5, 5, 6, 2}, {6, 5, 6, 2}, {7, 5, 6, 2}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {0, 4, 6, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {8, 4, 3, 1}, {8, 4, 4, 1}, {8, 4, 5, 1}, {8, 4, 6, 1}, {7, 5, 4, 1}, {7, 5, 5, 1}, {6, 1, 4, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2, 1, 2}, {6, 1, 0, 6, 1, 2}, {3, 1, 0, 3, 1, 0}, {5, 1, 0, 5, 1, 0}, {6, 1, 5, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwm : new int[][]{{6, 2, 5, GeneralConfig.useVillageColors ? this.townColor5 : 0}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 3, 2, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {5, 3, 2, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (int[] uvw : new int[][]{{3, 2, 6}, {5, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoh : new int[][]{{2, 1, 5, 1, 0}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwoh[3], this.func_186165_e(), uvwoh[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwoh[0], uvwoh[1], uvwoh[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 3, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{1, 1, 2, 0}, {3, 1, 1, 0}, {3, 1, 2, 0}, {5, 1, 2, 0}, {7, 1, 2, 0}, {7, 1, 3, 0}, {8, 1, 0, 0}, {8, 1, 2, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 1;
                int w = 4 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SavannaToolSmith1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFPFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaToolSmith1() {
        }

        public SavannaToolSmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaToolSmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaToolSmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaToolSmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 1, 4, 3, 1}, {6, 1, 1, 6, 3, 1}, {4, 1, 5, 4, 3, 5}, {5, 1, 5, 5, 1, 5}, {6, 1, 5, 6, 3, 5}, {7, 1, 2, 7, 3, 2}, {7, 1, 4, 7, 3, 4}, {3, 1, 2, 3, 3, 2}, {3, 1, 4, 3, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{7, 3, 3, 7, 3, 3}, {3, 3, 3, 3, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{5, 3, 1, 5, 3, 1}, {5, 3, 5, 5, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{5, 3, 0, 2}, {5, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 0, 1, 5, 0, 1}, {4, 0, 2, 6, 0, 2}, {3, 0, 3, 7, 0, 3}, {4, 0, 4, 6, 0, 4}, {3, 4, 1, 7, 4, 1}, {3, 4, 5, 7, 4, 5}, {3, 4, 2, 3, 4, 4}, {7, 4, 2, 7, 4, 4}, {1, 4, 2, 2, 4, 2}, {1, 4, 2, 1, 4, 3}, {1, 4, 4, 2, 4, 4}, {8, 4, 2, 9, 4, 2}, {9, 4, 2, 9, 4, 3}, {8, 4, 4, 9, 4, 4}, {4, 5, 2, 6, 5, 4}, {5, 6, 3, 5, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {6, 4, 0, 3}, {7, 4, 0, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {6, 5, 1, 3}, {7, 5, 1, 3}, {4, 6, 2, 3}, {5, 6, 2, 3}, {6, 6, 2, 3}, {3, 5, 2, 0}, {3, 5, 3, 0}, {3, 5, 4, 0}, {4, 6, 3, 0}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {6, 4, 6, 2}, {7, 4, 6, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {6, 5, 5, 2}, {7, 5, 5, 2}, {4, 6, 4, 2}, {5, 6, 4, 2}, {6, 6, 4, 2}, {7, 5, 2, 1}, {7, 5, 3, 1}, {7, 5, 4, 1}, {6, 6, 3, 1}, {4, 1, 4, 3}, {6, 1, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 3, 2, 4, 3}, {8, 4, 3, 8, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 3, 2}, {1, 1, 4, 1, 3, 4}, {9, 1, 2, 9, 3, 2}, {9, 1, 4, 9, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwoc : new int[][]{{1, 4, 1, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {2, 4, 1, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 2, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 3, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 4, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {1, 4, 5, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {2, 4, 5, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {8, 4, 1, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {9, 4, 1, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {10, 4, 2, 1, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {10, 4, 3, 1, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {10, 4, 4, 1, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {8, 4, 5, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {9, 4, 5, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (int[] uvw : new int[][]{{5, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState smithingTableBlockState = ModObjects.chooseModSmithingTable(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{5, 1, 4}}) {
                this.func_175811_a(world, smithingTableBlockState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 1, 0, 1, 0}, {3, 1, 3, 1, 1, 1}, {7, 1, 3, 3, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}, {1, 1, 3, 0}, {2, 1, 4, 0}, {2, 1, 5, 0}, {3, 1, 0, 0}, {3, 1, 1, 0}, {4, 1, 6, 0}, {5, 1, 6, 0}, {6, 1, 6, 0}, {7, 1, 0, 0}, {7, 1, 1, 0}, {7, 1, 5, 0}, {7, 1, 6, 0}, {8, 1, 0, 0}, {8, 1, 2, 0}, {8, 1, 3, 0}, {8, 1, 4, 0}, {8, 1, 5, 0}, {9, 1, 0, 0}, {9, 1, 1, 0}, {9, 1, 5, 0}, {10, 1, 1, 0}, {10, 1, 3, 0}, {10, 1, 4, 0}, {10, 1, 5, 0}, {10, 1, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4 + random.nextInt(3);
                int v = 1;
                int w = 2 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SavannaTemple2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", "  FFFFF  ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", "  FFFFF  ", "    P    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaTemple2() {
        }

        public SavannaTemple2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaTemple2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaTemple2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaTemple2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 3, 3, 1}, {5, 1, 1, 6, 3, 1}, {3, 5, 1, 5, 5, 1}, {2, 1, 5, 2, 3, 5}, {4, 1, 5, 4, 3, 5}, {6, 1, 5, 6, 3, 5}, {3, 5, 5, 5, 5, 5}, {1, 1, 2, 1, 3, 2}, {1, 1, 4, 1, 3, 4}, {3, 5, 2, 3, 5, 4}, {7, 1, 2, 7, 3, 2}, {7, 1, 4, 7, 3, 4}, {5, 5, 2, 5, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{4, 0, 1, 4, 0, 1}, {1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {7, 1, 3, 7, 1, 3}, {7, 3, 3, 7, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{4, 3, 1, 4, 3, 1}, {3, 1, 5, 3, 1, 5}, {3, 3, 5, 3, 3, 5}, {5, 1, 5, 5, 1, 5}, {5, 3, 5, 5, 3, 5}, {2, 0, 2, 3, 0, 4}, {5, 0, 2, 6, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvwwc : new int[][]{{4, 0, 2, 4, 0, 4, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 4, 1, 3, 4, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {4, 4, 1, 4, 4, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 4, 1, 5, 4, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {5, 4, 2, 5, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 4, 3, 5, 4, 3, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {5, 4, 4, 5, 4, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 4, 5, 5, 4, 5, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {4, 4, 5, 4, 4, 5, GeneralConfig.useVillageColors ? this.townColor : 4}, {3, 4, 5, 3, 4, 5, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 4, 4, 3, 4, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {3, 4, 3, 3, 4, 3, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {3, 4, 2, 3, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            for (int[] uvwo : new int[][]{{4, 4, 0, 2}, {4, 4, 6, 0}, {3, 2, 2, 0}, {5, 2, 2, 0}, {4, 2, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 2, 4, 5}, {3, 6, 1, 5, 6, 5}, {6, 4, 1, 7, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 6, 0, 3}, {4, 6, 0, 3}, {5, 6, 0, 3}, {3, 6, 6, 2}, {4, 6, 6, 2}, {5, 6, 6, 2}, {2, 6, 1, 0}, {2, 6, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {2, 6, 5, 0}, {6, 6, 1, 1}, {6, 6, 2, 1}, {6, 6, 3, 1}, {6, 6, 4, 1}, {6, 6, 5, 1}, {6, 4, 0, 3}, {7, 4, 0, 3}, {8, 4, 1, 1}, {8, 4, 2, 1}, {8, 4, 3, 1}, {8, 4, 4, 1}, {8, 4, 5, 1}, {6, 4, 6, 2}, {7, 4, 6, 2}, {6, 1, 2, 0}, {6, 1, 3, 0}, {6, 1, 4, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 5}, {7, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, 3}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 1;
                int w = 2 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class SavannaTemple1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFPFFFF", "FFFPPPFFF", "FFFPFPFFF", "FFFPPPFFF", "FFFFPFFFF", "FFFFPFFFF", "FFFFPFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaTemple1() {
        }

        public SavannaTemple1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaTemple1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaTemple1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaTemple1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 7, 6, 3, 7}, {2, 1, 11, 2, 4, 11}, {3, 1, 11, 3, 1, 11}, {4, 1, 11, 4, 4, 11}, {5, 1, 11, 5, 1, 11}, {6, 1, 11, 6, 4, 11}, {1, 1, 8, 1, 4, 8}, {1, 1, 9, 1, 1, 9}, {1, 1, 10, 1, 4, 10}, {7, 1, 8, 7, 4, 8}, {7, 1, 9, 7, 1, 9}, {7, 1, 10, 7, 4, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{4, 0, 7, 4, 0, 7}, {2, 4, 7, 6, 4, 7}, {1, 4, 9, 1, 4, 9}, {7, 4, 9, 7, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 4, 11, 3, 4, 11}, {5, 4, 11, 5, 4, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{6, 1, 9, 6, 1, 9}, {2, 1, 8, 2, 1, 10}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uuvvwwc : new int[][]{{0, 1, 4, 0, 2, 4, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {0, 3, 4, 0, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 1, 1, 2, 2, 1, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {2, 3, 1, 2, 3, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {6, 1, 1, 6, 2, 1, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {6, 3, 1, 6, 3, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {8, 1, 4, 8, 2, 4, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {8, 3, 4, 8, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 8, 0}, {3, 4, 10, 2}, {5, 4, 10, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 7, 7, 5, 7}, {1, 5, 11, 7, 5, 11}, {1, 5, 8, 1, 5, 10}, {7, 5, 8, 7, 5, 10}, {2, 6, 8, 6, 6, 10}, {2, 0, 8, 6, 0, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 5, 6, 3}, {2, 5, 6, 3}, {3, 5, 6, 3}, {4, 5, 6, 3}, {5, 5, 6, 3}, {6, 5, 6, 3}, {7, 5, 6, 3}, {1, 6, 7, 3}, {2, 6, 7, 3}, {3, 6, 7, 3}, {4, 6, 7, 3}, {5, 6, 7, 3}, {6, 6, 7, 3}, {7, 6, 7, 3}, {1, 5, 12, 2}, {2, 5, 12, 2}, {3, 5, 12, 2}, {4, 5, 12, 2}, {5, 5, 12, 2}, {6, 5, 12, 2}, {7, 5, 12, 2}, {1, 6, 11, 2}, {2, 6, 11, 2}, {3, 6, 11, 2}, {4, 6, 11, 2}, {5, 6, 11, 2}, {6, 6, 11, 2}, {7, 6, 11, 2}, {0, 5, 7, 0}, {0, 5, 8, 0}, {0, 5, 9, 0}, {0, 5, 10, 0}, {0, 5, 11, 0}, {1, 6, 8, 0}, {1, 6, 9, 0}, {1, 6, 10, 0}, {8, 5, 7, 1}, {8, 5, 8, 1}, {8, 5, 9, 1}, {8, 5, 10, 1}, {8, 5, 11, 1}, {7, 6, 8, 1}, {7, 6, 9, 1}, {7, 6, 10, 1}, {6, 1, 8, 0}, {6, 1, 10, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 9}, {7, 2, 9}, {3, 2, 11}, {5, 2, 11}}) {
                for (int i = 0; i < 2; ++i) {
                    this.func_175811_a(world, Blocks.field_150397_co.func_176203_a(i == 1 ? (GeneralConfig.useVillageColors ? this.townColor : 4) : (GeneralConfig.useVillageColors ? this.townColor2 : 1)), uvw[0], uvw[1] + i, uvw[2], structureBB);
                }
            }
            for (int[] uvwm : new int[][]{{2, 2, 8, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 2, 9, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {6, 2, 9, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 2, 10}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 7, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{2, 3, 0, 2, 12}, {6, 3, 0, 2, 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                if (GeneralConfig.useVillageColors) {
                    NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = new ItemStack(Items.field_179564_cE);
                    villageBanner.func_77983_a("BlockEntityTag", (NBTBase)villageNBTtag.func_74775_l("BlockEntityTag"));
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (int[] uvwg : new int[][]{{0, 1, 1, 0}, {0, 1, 3, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {0, 1, 8, 0}, {0, 1, 9, 0}, {0, 1, 11, 0}, {1, 1, 0, 0}, {1, 1, 2, 0}, {1, 1, 3, 0}, {1, 1, 5, 0}, {1, 1, 7, 0}, {1, 1, 12, 0}, {2, 1, 2, 0}, {2, 1, 4, 0}, {2, 1, 12, 0}, {3, 1, 0, 0}, {3, 1, 2, 0}, {3, 1, 6, 0}, {4, 1, 12, 0}, {5, 1, 0, 0}, {5, 1, 6, 0}, {5, 1, 12, 0}, {6, 1, 3, 0}, {6, 1, 12, 0}, {7, 1, 1, 0}, {7, 1, 2, 0}, {7, 1, 3, 0}, {7, 1, 5, 0}, {7, 1, 7, 0}, {7, 1, 12, 0}, {7, 1, 11, 0}, {8, 1, 1, 0}, {8, 1, 3, 0}, {8, 1, 6, 0}, {8, 1, 8, 0}, {8, 1, 12, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 1;
                int w = 8 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class SavannaTannery1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFPFFFF", "FFFFPFFFF", "PPPPFFPPP"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaTannery1() {
        }

        public SavannaTannery1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaTannery1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaTannery1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaTannery1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 3, 5, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{4, 0, 2, 4, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 0, 3, 2, 0, 4}, {6, 0, 3, 6, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvwwc : new int[][]{{2, 1, 2, 6, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 4}, {1, 1, 3, 1, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {7, 1, 3, 7, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 1, 5, 6, 3, 5, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 1, 2}, {4, 3, 3, 0}, {4, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 2, 6, 4, 2}, {1, 4, 3, 1, 4, 4}, {7, 4, 3, 7, 4, 4}, {2, 4, 5, 6, 4, 5}, {2, 5, 3, 6, 5, 4}, {3, 3, 0, 3, 3, 0}, {5, 3, 0, 5, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 1, 3}, {2, 4, 1, 3}, {3, 4, 1, 3}, {4, 4, 1, 3}, {5, 4, 1, 3}, {6, 4, 1, 3}, {7, 4, 1, 3}, {1, 5, 2, 3}, {2, 5, 2, 3}, {3, 5, 2, 3}, {4, 5, 2, 3}, {5, 5, 2, 3}, {6, 5, 2, 3}, {7, 5, 2, 3}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {6, 4, 6, 2}, {7, 4, 6, 2}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {6, 5, 5, 2}, {7, 5, 5, 2}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {8, 4, 2, 1}, {8, 4, 3, 1}, {8, 4, 4, 1}, {8, 4, 5, 1}, {7, 5, 3, 1}, {7, 5, 4, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 0, 3, 2, 0}, {5, 1, 0, 5, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 3, 1, 3, 3, 1}, {4, 3, 0, 4, 3, 0}, {5, 3, 1, 5, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvwoc : new int[][]{{3, 3, -1, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {5, 3, -1, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (int[] uvw : new int[][]{{3, 2, 5}, {5, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{6, 1, 3}, {6, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(3), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            int chestU = 2;
            int chestV = 1;
            int chestW = 4;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_tannery");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState smoothStoneState = ModObjects.chooseModSmoothStoneBlockState();
            for (int[] uuvvww : new int[][]{{2, 1, 3, 2, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], smoothStoneState, smoothStoneState, false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 2, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{5, 0, -1}}) {
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}, {0, 1, 2, 0}, {0, 1, 4, 0}, {1, 1, 0, 0}, {1, 1, 2, 0}, {2, 1, 0, 0}, {2, 1, 6, 0}, {3, 1, 6, 0}, {4, 1, 6, 0}, {5, 1, -1, 0}, {5, 1, 6, 0}, {6, 1, 6, 0}, {7, 1, 0, 0}, {7, 1, 6, 0}, {8, 1, 0, 0}, {8, 1, 1, 0}, {8, 1, 3, 0}, {8, 1, 4, 0}, {8, 1, 5, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 1;
                int w = 3 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SavannaSmallHouse8
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", "  FFF  ", " FFFFF ", " FFFFF ", "  FFF  ", "   P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse8() {
        }

        public SavannaSmallHouse8(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse8 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse8.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse8(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 2, 2, 1}, {4, 2, 1, 4, 2, 1}, {1, 2, 2, 1, 2, 3}, {2, 2, 4, 2, 2, 4}, {4, 2, 4, 4, 2, 4}, {5, 2, 2, 5, 2, 3}, {3, 0, 2, 3, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 2, 0, 3}, {4, 0, 2, 4, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uuvvwwc : new int[][]{{2, 1, 1, 2, 1, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {4, 1, 1, 4, 1, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 3, 1, 4, 3, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {1, 1, 2, 1, 1, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {1, 3, 2, 1, 3, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 1, 2, 5, 1, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 3, 2, 5, 3, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 1, 4, 4, 1, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 3, 4, 4, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 3}, {1, 4, 4, 5, 4, 4}, {5, 4, 2, 5, 4, 3}, {2, 5, 2, 4, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {1, 4, 5, 2}, {2, 4, 5, 2}, {3, 4, 5, 2}, {4, 4, 5, 2}, {5, 4, 5, 2}, {1, 5, 4, 2}, {2, 5, 4, 2}, {3, 5, 4, 2}, {4, 5, 4, 2}, {5, 5, 4, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {4, 1, 2, 0}, {4, 1, 3, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 1, 2, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallHouse7
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse7() {
        }

        public SavannaSmallHouse7(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse7 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse7.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse7(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 3, 1}, {4, 1, 1, 4, 3, 1}, {1, 1, 2, 1, 3, 2}, {1, 1, 4, 1, 3, 4}, {2, 1, 5, 2, 3, 5}, {4, 1, 5, 4, 3, 5}, {5, 1, 2, 5, 3, 2}, {5, 1, 4, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{3, 3, 1, 3, 3, 1}, {3, 1, 5, 3, 1, 5}, {3, 3, 5, 3, 3, 5}, {1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {5, 1, 3, 5, 1, 3}, {5, 3, 3, 5, 3, 3}, {2, 0, 2, 4, 0, 4}, {3, 0, 1, 3, 0, 1}, {4, 1, 3, 4, 1, 3}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {4, 2, 3, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 4}, {3, 6, 3, 3, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {2, 6, 2, 3}, {3, 6, 2, 3}, {4, 6, 2, 3}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {2, 6, 4, 2}, {3, 6, 4, 2}, {4, 6, 4, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {2, 6, 3, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {4, 6, 3, 1}, {4, 1, 2, 2}, {4, 1, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 2;
            int chestV = 1;
            int chestW = 2;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvwoc : (ChestGenHooks)new int[][]{{2, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    Object orientation = uvwoc[3];
                    reference var28_43 = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    Object v = uvwoc[1];
                    reference var30_45 = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a((int)var28_43, (int)var30_45), this.func_74862_a((int)v), this.func_74873_b((int)var28_43, (int)var30_45), StructureVillageVN.getBedOrientationMeta((int)orientation, this.func_186165_e(), isHead), (int)uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}, {0, 1, 3, 0}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 1, 0}, {1, 1, 5, 0}, {1, 1, 6, 0}, {4, 1, 0, 0}, {5, 1, 5, 0}, {5, 1, 6, 0}, {6, 1, 4, 0}, {6, 1, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{5, 1, 0, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallHouse6
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"   F   ", "  FFF  ", " FFFFF ", " FFFFFF", " FFFFF ", "  FFF  ", "   PF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse6() {
        }

        public SavannaSmallHouse6(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse6 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse6.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse6(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1}, {2, 3, 1}, {4, 1, 1}, {4, 3, 1}, {2, 1, 5}, {2, 3, 5}, {4, 1, 5}, {4, 3, 5}, {3, 1, 5}, {1, 1, 2}, {1, 3, 2}, {1, 1, 4}, {1, 3, 4}, {1, 1, 3}, {5, 1, 2}, {5, 3, 2}, {5, 1, 4}, {5, 3, 4}, {5, 1, 3}}) {
                this.func_175811_a(world, biomeLogVertState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{2, 2, 1}, {4, 2, 1}, {2, 2, 5}, {4, 2, 5}, {1, 3, 3}, {5, 3, 3}}) {
                this.func_175811_a(world, biomeLogHorAlongState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 3, 1}, {3, 3, 5}, {1, 2, 2}, {1, 2, 4}, {5, 2, 2}, {5, 2, 4}}) {
                this.func_175811_a(world, biomeLogHorAcrossState, uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{2, 1, 3, 2, 1, 3}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 4}, {3, 0, 1, 3, 0, 1}, {1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 4}, {3, 6, 3, 3, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {2, 6, 2, 3}, {3, 6, 2, 3}, {4, 6, 2, 3}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {2, 6, 4, 2}, {3, 6, 4, 2}, {4, 6, 4, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {2, 6, 3, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {4, 6, 3, 1}, {2, 1, 2, 2}, {2, 1, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{4, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{4, 1, 0, 0}, {6, 1, 3, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallHouse5
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse5() {
        }

        public SavannaSmallHouse5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 3, 1}, {4, 1, 1, 4, 3, 1}, {2, 1, 5, 2, 3, 5}, {4, 1, 5, 4, 3, 5}, {1, 1, 2, 1, 3, 2}, {1, 1, 4, 1, 3, 4}, {5, 1, 2, 5, 3, 2}, {5, 1, 4, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {5, 1, 3, 5, 1, 3}, {5, 3, 3, 5, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 3, 1, 3, 3, 1}, {3, 1, 5, 3, 1, 5}, {3, 3, 5, 3, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvwwc : new int[][]{{2, 4, 1, 4, 4, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 5, 2, 4, 7, 2, GeneralConfig.useVillageColors ? this.townColor : 4}, {1, 4, 2, 1, 4, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 5, 3, 2, 7, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 4, 2, 5, 4, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {4, 5, 3, 4, 7, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 4, 5, 4, 4, 5, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 5, 4, 4, 7, 4, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 2, 3, 6, 2}, {2, 6, 3, 2, 6, 3}, {3, 6, 4, 3, 6, 4}, {4, 6, 3, 4, 6, 3}, {0, 1, 1, 0, 4, 1}, {0, 1, 5, 0, 4, 5}, {1, 1, 0, 1, 4, 0}, {5, 1, 0, 5, 4, 0}, {6, 1, 1, 6, 4, 1}, {6, 1, 5, 6, 4, 5}, {1, 1, 6, 1, 4, 6}, {5, 1, 6, 5, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 2, 0}, {3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 4}, {3, 0, 1, 3, 0, 1}, {2, 8, 2, 4, 8, 4}, {3, 9, 3, 3, 9, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{4, 1, 4}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 8, 1, 3}, {2, 8, 1, 3}, {3, 8, 1, 3}, {4, 8, 1, 3}, {5, 8, 1, 3}, {2, 9, 2, 3}, {3, 9, 2, 3}, {4, 9, 2, 3}, {1, 8, 5, 2}, {2, 8, 5, 2}, {3, 8, 5, 2}, {4, 8, 5, 2}, {5, 8, 5, 2}, {2, 9, 4, 2}, {3, 9, 4, 2}, {4, 9, 4, 2}, {1, 8, 2, 0}, {1, 8, 3, 0}, {1, 8, 4, 0}, {2, 9, 3, 0}, {5, 8, 2, 1}, {5, 8, 3, 1}, {5, 8, 4, 1}, {4, 9, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 5, 1, 0, 5, 5}, {1, 5, 0, 1, 5, 6}, {2, 5, 0, 4, 5, 1}, {2, 5, 5, 4, 5, 6}, {5, 5, 0, 5, 5, 6}, {6, 5, 1, 6, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 1, 4, 1, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}, {0, 1, 2, 0}, {0, 1, 4, 0}, {0, 1, 6, 0}, {1, 1, 1, 0}, {2, 1, 0, 0}, {2, 1, 3, 0}, {4, 1, 0, 0}, {6, 1, 0, 0}, {6, 1, 3, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallHouse4
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse4() {
        }

        public SavannaSmallHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 1, 5, 4, 1}, {7, 1, 1, 7, 4, 1}, {4, 1, 2, 4, 4, 2}, {4, 1, 4, 4, 4, 4}, {5, 1, 5, 5, 4, 5}, {7, 1, 5, 7, 4, 5}, {8, 1, 2, 8, 4, 2}, {8, 1, 4, 8, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{4, 3, 3, 4, 3, 3}, {8, 1, 3, 8, 1, 3}, {8, 3, 3, 8, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{6, 3, 1, 6, 3, 1}, {6, 1, 5, 6, 1, 5}, {6, 3, 5, 6, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{6, 0, 1, 6, 0, 1}, {4, 0, 3, 4, 0, 3}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 4, 1, 6, 4, 1}, {6, 4, 5, 6, 4, 5}, {4, 4, 3, 4, 4, 3}, {8, 4, 3, 8, 4, 3}, {1, 1, 1, 1, 3, 1}, {1, 1, 5, 1, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{6, 3, 0, 2}, {6, 3, 2, 0}, {6, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 0, 2, 7, 0, 4}, {4, 5, 1, 8, 5, 1}, {4, 5, 2, 4, 5, 4}, {4, 5, 5, 8, 5, 5}, {8, 5, 2, 8, 5, 4}, {5, 6, 2, 7, 6, 4}, {6, 7, 3, 6, 7, 3}, {1, 4, 1, 1, 4, 1}, {1, 4, 5, 1, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 5, 0, 3}, {5, 5, 0, 3}, {6, 5, 0, 3}, {7, 5, 0, 3}, {8, 5, 0, 3}, {4, 6, 1, 3}, {5, 6, 1, 3}, {6, 6, 1, 3}, {7, 6, 1, 3}, {8, 6, 1, 3}, {5, 7, 2, 3}, {6, 7, 2, 3}, {7, 7, 2, 3}, {4, 5, 6, 2}, {5, 5, 6, 2}, {6, 5, 6, 2}, {7, 5, 6, 2}, {8, 5, 6, 2}, {4, 6, 5, 2}, {5, 6, 5, 2}, {6, 6, 5, 2}, {7, 6, 5, 2}, {8, 6, 5, 2}, {5, 7, 4, 2}, {6, 7, 4, 2}, {7, 7, 4, 2}, {3, 5, 1, 0}, {3, 5, 2, 0}, {3, 5, 3, 0}, {3, 5, 4, 0}, {3, 5, 5, 0}, {4, 6, 2, 0}, {4, 6, 3, 0}, {4, 6, 4, 0}, {5, 7, 3, 0}, {9, 5, 1, 1}, {9, 5, 2, 1}, {9, 5, 3, 1}, {9, 5, 4, 1}, {9, 5, 5, 1}, {8, 6, 2, 1}, {8, 6, 3, 1}, {8, 6, 4, 1}, {7, 7, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 2, 1, 4, 4}, {2, 4, 1, 2, 4, 5}, {3, 4, 1, 3, 4, 1}, {3, 4, 5, 3, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvw : new int[][]{{8, 2, 3}, {6, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{1, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {2, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {3, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 1, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 2, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 3, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 4, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 5, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {1, 4, 6, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {2, 4, 6, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {3, 4, 6, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos blockPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(blockPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(blockPos, (TileEntity)tilebanner);
            }
            int chestU = 7;
            int chestV = 1;
            int chestW = 2;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvwoc : new int[][]{{7, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{6, 1, 1, 0, 1, 1}, {4, 1, 3, 1, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(nArray[3], this.func_186165_e(), nArray[4] == 1, nArray[5] == 1)[height]), nArray[0], nArray[1] + height, nArray[2], structureBB);
                }
            }
            for (int[] nArray : new int[][]{{0, 1, 0, 0}, {0, 1, 2, 0}, {0, 1, 4, 0}, {0, 1, 6, 0}, {1, 1, 4, 0}, {2, 1, 1, 0}, {2, 1, 3, 0}, {3, 1, 4, 0}, {3, 1, 5, 0}, {4, 1, 5, 0}, {5, 1, 6, 0}, {7, 1, 6, 0}, {8, 1, 5, 0}, {8, 1, 6, 0}, {9, 1, 0, 0}, {9, 1, 4, 0}, {9, 1, 5, 0}, {9, 1, 6, 1}}) {
                if (nArray[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), nArray[0], nArray[1], nArray[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), nArray[0], nArray[1], nArray[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), nArray[0], nArray[1] + 1, nArray[2], structureBB);
            }
            for (int[] nArray : new int[][]{{6, 1, -1}}) {
                int pathU = nArray[0];
                int pathV = nArray[1];
                int pathW = nArray[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{5, 1, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallHouse3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse3() {
        }

        public SavannaSmallHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvwwc : new int[][]{{2, 1, 1, 4, 3, 1, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {1, 1, 2, 1, 3, 4, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {5, 1, 2, 5, 3, 4, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {2, 1, 5, 4, 3, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{2, 0, 2, 4, 0, 4}, {3, 0, 1, 3, 0, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 4, 2}, {2, 3, 2, 0}, {4, 3, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 4}, {3, 6, 3, 3, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {2, 6, 2, 3}, {3, 6, 2, 3}, {4, 6, 2, 3}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {2, 6, 4, 2}, {3, 6, 4, 2}, {4, 6, 4, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {2, 6, 3, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {4, 6, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 4, 1, 4, structureBB);
            for (int[] uvwoc : new int[][]{{2, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}, {0, 1, 6, 0}, {1, 1, 1, 0}, {1, 1, 5, 0}, {1, 1, 6, 0}, {4, 1, 0, 0}, {4, 1, 6, 0}, {5, 1, 5, 0}, {5, 1, 6, 0}, {6, 1, 2, 0}, {6, 1, 4, 0}, {6, 1, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{5, 1, 0, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse2() {
        }

        public SavannaSmallHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvwwc : new int[][]{{2, 1, 1, 4, 3, 1, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {1, 1, 2, 1, 3, 4, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {5, 1, 2, 5, 3, 4, GeneralConfig.useVillageColors ? this.townColor4 : 14}, {2, 1, 5, 4, 3, 5, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{2, 0, 2, 4, 0, 4}, {3, 0, 1, 3, 0, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 4}, {3, 6, 3, 3, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {2, 6, 2, 3}, {3, 6, 2, 3}, {4, 6, 2, 3}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {2, 6, 4, 2}, {3, 6, 4, 2}, {4, 6, 4, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {2, 6, 3, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {4, 6, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 2;
            int chestV = 1;
            int chestW = 4;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvwoc : (ChestGenHooks)new int[][]{{4, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    Object orientation = uvwoc[3];
                    reference var28_44 = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    Object v = uvwoc[1];
                    reference var30_46 = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a((int)var28_44, (int)var30_46), this.func_74862_a((int)v), this.func_74873_b((int)var28_44, (int)var30_46), StructureVillageVN.getBedOrientationMeta((int)orientation, this.func_186165_e(), isHead), (int)uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 1, 0}, {1, 1, 5, 0}, {1, 1, 6, 0}, {3, 1, 6, 0}, {4, 1, 6, 0}, {5, 1, 5, 0}, {5, 1, 6, 0}, {6, 1, 2, 0}, {6, 1, 4, 0}, {6, 1, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 0, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallHouse1() {
        }

        public SavannaSmallHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvwwc : new int[][]{{2, 1, 1, 4, 3, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {1, 1, 2, 1, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 1, 2, 5, 3, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 1, 5, 4, 3, 5, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{2, 0, 2, 4, 0, 4}, {3, 0, 1, 3, 0, 1}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 4}, {3, 6, 3, 3, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {2, 6, 2, 3}, {3, 6, 2, 3}, {4, 6, 2, 3}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {2, 6, 4, 2}, {3, 6, 4, 2}, {4, 6, 4, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {2, 6, 3, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {4, 6, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{2, 1, 4}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{4, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                boolean[] i = new boolean[]{false, true};
                int n = i.length;
                for (int j = 0; j < n; ++j) {
                    boolean isHead = i[j];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 3, 0}, {0, 1, 4, 1}, {0, 1, 6, 0}, {1, 1, 0, 0}, {1, 1, 1, 0}, {1, 1, 5, 0}, {1, 1, 6, 0}, {3, 1, 6, 0}, {4, 1, 0, 0}, {4, 1, 6, 0}, {5, 1, 5, 0}, {5, 1, 6, 0}, {6, 1, 2, 0}, {6, 1, 4, 0}, {6, 1, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 0, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaSmallFarm
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFFF", "FFFFFF", " FFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFF ", "FFFFF ", "FFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaSmallFarm() {
        }

        public SavannaSmallFarm(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaSmallFarm buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaSmallFarm.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaSmallFarm(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uvw : new int[][]{{0, 0, 0, 7}, {0, 0, 1, 7}, {0, 0, 3, 7}, {0, 0, 4, 7}, {1, 0, 2, 0}, {1, 0, 3, 0}, {1, 0, 4, 0}, {1, 0, 6, 0}, {2, 0, 0, 1}, {2, 0, 1, 7}, {2, 0, 2, 7}, {2, 0, 3, 0}, {2, 0, 4, 1}, {2, 0, 5, 7}, {2, 0, 6, 7}, {2, 0, 7, 0}, {2, 0, 8, 0}, {3, 0, 0, 0}, {3, 0, 1, 1}, {3, 0, 3, 7}, {3, 0, 6, 0}, {3, 0, 7, 0}, {3, 0, 8, 0}, {4, 0, 2, 7}, {4, 0, 3, 7}, {4, 0, 4, 7}, {4, 0, 5, 5}, {4, 0, 6, 7}, {4, 0, 7, 7}, {5, 0, 3, 7}, {5, 0, 4, 7}, {5, 0, 5, 6}, {5, 0, 7, 5}, {5, 0, 8, 6}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 0, 0, 0}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 8}}) {
                this.func_175811_a(world, Blocks.field_150440_ba.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 0, 1}, {3, 0, 2}, {3, 0, 5}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            for (int[] uvw : new int[][]{{1, 1, 5}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                if (compostBinState != null) {
                    this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150440_ba.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{0, 1, 2, 1}, {0, 1, 5, 1}, {0, 1, 7, 0}, {1, 1, 7, 1}, {3, 1, 4, 1}, {4, 1, 1, 1}, {4, 1, 8, 0}, {5, 1, 0, 1}, {5, 1, 6, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 1;
                int v = 1;
                int w = 1;
                while (u == 1 && w == 1 || u == 3 && w == 2 || u == 3 && w == 5 || u == 1 && w == 8 || u == 1 && w == 5 || u == 0 && w == 8 || u == 0 && w == 6 || u == 5 && w == 1 || u == 5 && w == 2) {
                    u = random.nextInt(6);
                    w = random.nextInt(9);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaShepherd1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", " FFFFFFFFFF", "  FFFPFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 13;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaShepherd1() {
        }

        public SavannaShepherd1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaShepherd1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)13, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaShepherd1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaShepherd1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 1, 4, 3, 1}, {6, 1, 1, 6, 3, 1}, {3, 1, 2, 3, 3, 2}, {3, 1, 3, 3, 1, 3}, {3, 1, 4, 3, 3, 4}, {4, 1, 5, 4, 3, 5}, {6, 1, 5, 6, 3, 5}, {7, 1, 2, 7, 3, 2}, {7, 1, 3, 7, 1, 3}, {7, 1, 4, 7, 3, 4}, {5, 0, 3, 5, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{5, 0, 1, 5, 0, 1}, {3, 3, 3, 3, 3, 3}, {7, 3, 3, 7, 3, 3}, {5, 0, 5, 5, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{5, 3, 1, 5, 3, 1}, {5, 3, 5, 5, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 4, 2, 1, 4}, {8, 1, 4, 10, 1, 4}, {0, 1, 5, 0, 1, 11}, {10, 1, 5, 10, 1, 11}, {0, 1, 12, 10, 1, 12}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 0, 2}, {6, 2, 0, 2}, {5, 3, 4, 2}, {6, 2, 12, -1}, {10, 2, 12, -1}, {10, 2, 8, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 0, 2, 6, 0, 2}, {4, 0, 3, 4, 0, 3}, {4, 0, 4, 6, 0, 4}, {6, 0, 3, 6, 0, 3}, {3, 4, 1, 7, 4, 1}, {3, 4, 2, 3, 4, 4}, {3, 4, 5, 7, 4, 5}, {7, 4, 2, 7, 4, 4}, {4, 5, 2, 6, 5, 4}, {5, 6, 3, 5, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {6, 4, 0, 3}, {7, 4, 0, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {6, 5, 1, 3}, {7, 5, 1, 3}, {4, 6, 2, 3}, {5, 6, 2, 3}, {6, 6, 2, 3}, {2, 4, 1, 0}, {2, 4, 2, 0}, {2, 4, 3, 0}, {2, 4, 4, 0}, {2, 4, 5, 0}, {3, 5, 2, 0}, {3, 5, 3, 0}, {3, 5, 4, 0}, {4, 6, 3, 0}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {6, 4, 6, 2}, {7, 4, 6, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {6, 5, 5, 2}, {7, 5, 5, 2}, {4, 6, 4, 2}, {5, 6, 4, 2}, {6, 6, 4, 2}, {8, 4, 1, 1}, {8, 4, 2, 1}, {8, 4, 3, 1}, {8, 4, 4, 1}, {8, 4, 5, 1}, {7, 5, 2, 1}, {7, 5, 3, 1}, {7, 5, 4, 1}, {6, 6, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 3}, {7, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState loomState = ModObjects.chooseModLoom(3, this.func_186165_e());
            for (int[] uvw : new int[][]{{6, 1, 3}}) {
                this.func_175811_a(world, loomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{6, 1, 2, 6, 1, 2}, {6, 1, 4, 6, 1, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 1, 0, 1, 0}, {5, 1, 5, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{1, 1, 9, 0}, {1, 1, 10, 0}, {2, 1, 7, 0}, {2, 1, 8, 0}, {2, 1, 10, 0}, {2, 1, 11, 1}, {3, 1, 6, 0}, {3, 1, 7, 0}, {4, 1, 8, 0}, {5, 1, 7, 0}, {5, 1, 8, 0}, {5, 1, 11, 0}, {6, 1, 8, 0}, {6, 1, 11, 0}, {7, 1, 5, 0}, {7, 1, 6, 0}, {7, 1, 7, 0}, {7, 1, 8, 0}, {7, 1, 9, 0}, {7, 1, 10, 0}, {8, 1, 7, 0}, {8, 1, 8, 0}, {8, 1, 11, 0}, {9, 1, 5, 0}, {9, 1, 7, 0}, {9, 1, 8, 0}, {9, 1, 10, 0}, {9, 1, 11, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 0, 9}, {3, 0, 8}, {3, 0, 9}, {3, 0, 10}, {4, 0, 9}, {4, 0, 10}, {4, 0, 11}, {5, 0, 10}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwss : new int[][]{{8, 1, 10, -1, -1}}) {
                Block dirtblock = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2]))).func_177230_c();
                Block saplingblock = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2]))).func_177230_c();
                if (dirtblock == null || dirtblock != Blocks.field_150346_d && dirtblock != Blocks.field_150349_c || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])))) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    Block dirtblock1 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))).func_177230_c();
                    Block dirtblock2 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))).func_177230_c();
                    Block dirtblock3 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]))).func_177230_c();
                    if (dirtblock1 == null || dirtblock2 == null || dirtblock3 == null || dirtblock1 != Blocks.field_150346_d && dirtblock1 != Blocks.field_150349_c || dirtblock2 != Blocks.field_150346_d && dirtblock2 != Blocks.field_150349_c || dirtblock3 != Blocks.field_150346_d && dirtblock3 != Blocks.field_150349_c || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4])))) continue;
                }
                this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2], structureBB);
                if (!(biomeSaplingState.func_177230_c() instanceof BlockSapling)) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                }
                ((BlockSapling)biomeSaplingState.func_177230_c()).func_176476_e(world, new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])), biomeSaplingState, world.field_73012_v);
            }
            for (int[] uvw : new int[][]{{5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4 + random.nextInt(2);
                int v = 1;
                int w = 2 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{4, 1, 7}}) {
                        BlockPos animalPos = new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]));
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(animalPos), null);
                        animal.func_70012_b((double)animalPos.func_177958_n() + 0.5, (double)animalPos.func_177956_o() + 0.5, (double)animalPos.func_177952_p() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaMediumHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"           ", "      FFF  ", "  F  FFFFF ", "     FFFFFP", "  FFFFFFFFP", " FFFFFFFF P", " FFFFFFFFP ", " FFFFFFFPP ", "  FFF PP   ", "   PPFP    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaMediumHouse2() {
        }

        public SavannaMediumHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaMediumHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaMediumHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaMediumHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)9, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{2, 1, 7}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] nArray = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(nArray[0], nArray[2]), this.func_74862_a(nArray[1]), this.func_74873_b(nArray[0], nArray[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(nArray[0], nArray[2]), 64, this.func_74873_b(nArray[0], nArray[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, nArray, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 3, 1}, {4, 1, 1, 4, 3, 1}, {1, 1, 2, 1, 3, 2}, {1, 1, 4, 1, 3, 4}, {2, 1, 5, 2, 3, 5}, {4, 1, 5, 4, 3, 5}, {5, 1, 2, 5, 3, 2}, {5, 1, 4, 5, 3, 4}, {6, 1, 4, 6, 3, 4}, {8, 1, 4, 8, 3, 4}, {5, 1, 5, 5, 3, 5}, {5, 1, 7, 5, 3, 7}, {6, 1, 8, 6, 3, 8}, {8, 1, 8, 8, 3, 8}, {9, 1, 5, 9, 3, 5}, {9, 1, 7, 9, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState iBlockState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {5, 1, 3, 5, 1, 3}, {5, 3, 3, 5, 3, 3}, {3, 0, 1, 3, 0, 1}, {3, 3, 1, 3, 3, 1}, {3, 1, 5, 3, 1, 5}, {3, 3, 5, 3, 3, 5}, {5, 1, 6, 5, 1, 6}, {5, 3, 6, 5, 3, 6}, {9, 0, 6, 9, 0, 6}, {9, 3, 6, 9, 3, 6}, {7, 1, 4, 7, 1, 4}, {7, 3, 4, 7, 3, 4}, {7, 1, 8, 7, 1, 8}, {7, 3, 8, 7, 3, 8}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], iBlockState, iBlockState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 4, 2}, {6, 3, 6, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 4}, {4, 1, 4, 4, 1, 4}, {1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {6, 0, 5, 8, 0, 7}, {5, 4, 6, 5, 4, 8}, {6, 4, 8, 8, 4, 8}, {9, 4, 4, 9, 4, 8}, {6, 4, 4, 8, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 2, 4, 5, 4}, {6, 5, 5, 8, 5, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {7, 4, 3, 3}, {8, 4, 3, 3}, {9, 4, 3, 3}, {6, 5, 4, 3}, {7, 5, 4, 3}, {8, 5, 4, 3}, {9, 5, 4, 3}, {4, 4, 7, 0}, {4, 4, 8, 0}, {5, 5, 6, 0}, {5, 5, 7, 0}, {5, 4, 9, 2}, {6, 4, 9, 2}, {7, 4, 9, 2}, {8, 4, 9, 2}, {9, 4, 9, 2}, {5, 5, 8, 2}, {6, 5, 8, 2}, {7, 5, 8, 2}, {8, 5, 8, 2}, {9, 5, 8, 2}, {10, 4, 4, 1}, {10, 4, 5, 1}, {10, 4, 6, 1}, {10, 4, 7, 1}, {10, 4, 8, 1}, {9, 5, 5, 1}, {9, 5, 6, 1}, {9, 5, 7, 1}, {4, 1, 2, 0}, {4, 1, 3, 0}, {8, 1, 5, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 0, 2, 0}, {7, 0, 2, 0}, {7, 0, 3, 1}, {8, 0, 3, 0}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 0, 3}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {5, 2, 3}, {5, 2, 6}, {7, 2, 8}, {7, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 6;
            int chestV = 1;
            int chestW = 7;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 2, 1, 2, structureBB);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}, {9, 1, 6, 3, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{2, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {7, 1, 5, 1, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {11, 1, 6}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}, {8, 1, 7, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaMediumHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"    FFFFFFF    ", "    FFFFFFF    ", "  FFFFFFFFFFF  ", " FFFFFFFFFFFFF ", " FFFFFFFFFFFFF ", " FFFFFFFFFFFFF ", "  FFFFFFF FFF  ", "   PFFFFF  P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaMediumHouse1() {
        }

        public SavannaMediumHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaMediumHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaMediumHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaMediumHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{8, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (Object uw : (Random)new int[][]{{1, 3, 3, 1, 3, 3}, {5, 3, 3, 5, 3, 3}, {9, 3, 3, 9, 3, 3}, {13, 3, 3, 13, 3, 3}}) {
                this.func_175804_a(world, structureBB, (int)uw[0], (int)uw[1], (int)uw[2], (int)uw[3], (int)uw[4], (int)uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 3, 1, 3, 3, 1}, {11, 3, 1, 11, 3, 1}, {3, 3, 5, 3, 3, 5}, {11, 3, 5, 11, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 1, 2, 8, 1, 2}, {4, 1, 6, 4, 1, 7}, {5, 1, 7, 9, 1, 7}, {10, 1, 6, 10, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{10, 1, 4, 10, 1, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {11, 3, 0, 2}, {3, 3, 4, 2}, {10, 2, 4, -1}, {6, 3, 3, 1}, {8, 3, 3, 3}, {4, 2, 7, -1}, {10, 2, 7, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 3, 1}, {4, 1, 1, 4, 3, 1}, {1, 1, 2, 1, 3, 2}, {1, 1, 3, 1, 1, 3}, {1, 1, 4, 1, 3, 4}, {2, 1, 5, 2, 3, 5}, {3, 1, 5, 3, 1, 5}, {4, 1, 5, 4, 3, 5}, {5, 1, 2, 5, 3, 2}, {5, 1, 4, 5, 3, 4}, {12, 1, 1, 12, 3, 1}, {10, 1, 1, 10, 3, 1}, {13, 1, 2, 13, 3, 2}, {13, 1, 3, 13, 1, 3}, {13, 1, 4, 13, 3, 4}, {12, 1, 5, 12, 3, 5}, {11, 1, 5, 11, 1, 5}, {10, 1, 5, 10, 3, 5}, {9, 1, 2, 9, 3, 2}, {9, 1, 4, 9, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 1, 3, 0, 1}, {2, 0, 2, 4, 0, 4}, {5, 0, 3, 5, 0, 3}, {1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 4}, {3, 6, 3, 3, 6, 3}, {11, 0, 1, 11, 0, 1}, {10, 0, 2, 12, 0, 4}, {9, 0, 3, 9, 0, 3}, {9, 4, 1, 13, 4, 1}, {13, 4, 2, 13, 4, 4}, {9, 4, 5, 13, 4, 5}, {9, 4, 2, 9, 4, 4}, {10, 5, 2, 12, 5, 4}, {11, 6, 3, 11, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {2, 6, 2, 3}, {3, 6, 2, 3}, {4, 6, 2, 3}, {2, 6, 3, 0}, {2, 6, 4, 2}, {3, 6, 4, 2}, {4, 6, 4, 2}, {4, 6, 3, 1}, {9, 4, 0, 3}, {10, 4, 0, 3}, {11, 4, 0, 3}, {12, 4, 0, 3}, {13, 4, 0, 3}, {8, 4, 1, 0}, {8, 4, 2, 0}, {8, 4, 3, 0}, {8, 4, 4, 0}, {8, 4, 5, 0}, {9, 4, 6, 2}, {10, 4, 6, 2}, {11, 4, 6, 2}, {12, 4, 6, 2}, {13, 4, 6, 2}, {14, 4, 1, 1}, {14, 4, 2, 1}, {14, 4, 3, 1}, {14, 4, 4, 1}, {14, 4, 5, 1}, {9, 5, 1, 3}, {10, 5, 1, 3}, {11, 5, 1, 3}, {12, 5, 1, 3}, {13, 5, 1, 3}, {9, 5, 2, 0}, {9, 5, 3, 0}, {9, 5, 4, 0}, {9, 5, 5, 2}, {10, 5, 5, 2}, {11, 5, 5, 2}, {12, 5, 5, 2}, {13, 5, 5, 2}, {13, 5, 2, 1}, {13, 5, 3, 1}, {13, 5, 4, 1}, {10, 6, 2, 3}, {11, 6, 2, 3}, {12, 6, 2, 3}, {10, 6, 3, 0}, {10, 6, 4, 2}, {11, 6, 4, 2}, {12, 6, 4, 2}, {12, 6, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{5, 0, 5, 7}, {5, 0, 6, 7}, {6, 0, 5, 7}, {6, 0, 6, 7}, {7, 0, 5, 7}, {8, 0, 5, 7}, {8, 0, 6, 7}, {9, 0, 5, 7}, {9, 0, 6, 7}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{7, 0, 6}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {3, 2, 5}, {11, 2, 5}, {13, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 2;
            int chestV = 1;
            int chestW = 2;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 4, 1, 4, structureBB);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 1}, {5, 1, 3, 3, 1, 0}, {9, 1, 3, 1, 1, 1}, {11, 1, 1, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{7, 1, 1, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {12, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {11, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}, {11, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaMason1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"          ", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", " FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaMason1() {
        }

        public SavannaMason1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaMason1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaMason1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaMason1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 2, 2, 2, 2}, {3, 1, 1, 3, 2, 1}, {6, 1, 1, 6, 2, 1}, {7, 1, 2, 7, 2, 2}, {1, 1, 3, 1, 3, 3}, {1, 1, 4, 1, 1, 4}, {1, 1, 5, 1, 3, 5}, {2, 1, 6, 2, 3, 6}, {3, 1, 6, 3, 1, 6}, {4, 1, 6, 5, 3, 6}, {6, 1, 6, 6, 1, 6}, {7, 1, 6, 7, 3, 6}, {8, 1, 3, 8, 3, 3}, {8, 1, 4, 8, 1, 4}, {8, 1, 5, 8, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{4, 0, 1, 5, 0, 1}, {1, 3, 4, 1, 3, 4}, {8, 3, 4, 8, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 3, 6, 3, 3, 6}, {6, 3, 6, 6, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwoc : new int[][]{{2, 3, 2, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {3, 3, 1, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {4, 3, 1, 0, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 3, 1, 1, GeneralConfig.useVillageColors ? this.townColor : 4}, {6, 3, 1, 0, GeneralConfig.useVillageColors ? this.townColor : 4}, {7, 3, 2, 0, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 3, 5, 2}, {6, 3, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 3, 7, 0, 5}, {3, 0, 2, 6, 0, 2}, {3, 4, 1, 6, 4, 1}, {2, 4, 2, 2, 4, 2}, {1, 4, 3, 1, 4, 5}, {2, 4, 6, 7, 4, 6}, {8, 4, 3, 8, 4, 5}, {7, 4, 2, 7, 4, 2}, {2, 5, 3, 7, 5, 5}, {3, 5, 2, 6, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 2, 3}, {2, 4, 1, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {6, 4, 0, 3}, {7, 4, 1, 3}, {8, 4, 2, 3}, {1, 5, 3, 3}, {2, 5, 2, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {6, 5, 1, 3}, {7, 5, 2, 3}, {8, 5, 3, 3}, {9, 4, 3, 1}, {9, 4, 4, 1}, {9, 4, 5, 1}, {8, 5, 4, 1}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {1, 5, 4, 0}, {1, 5, 5, 2}, {1, 4, 6, 2}, {2, 5, 6, 2}, {3, 5, 6, 2}, {4, 5, 6, 2}, {5, 5, 6, 2}, {6, 5, 6, 2}, {7, 5, 6, 2}, {8, 4, 6, 2}, {8, 5, 5, 2}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 4}, {3, 2, 6}, {6, 2, 6}, {8, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState stonecutterState = ModObjects.chooseModStonecutterState(1, this.func_186165_e());
            this.func_175811_a(world, stonecutterState, 2, 1, 4, structureBB);
            for (int[] uvw : new int[][]{{4, 1, 5}, {6, 1, 5}, {7, 1, 5}, {7, 2, 5}, {7, 3, 5}, {7, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150435_aG.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 5;
            int chestV = 1;
            int chestW = 5;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_mason");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{3, 1, 2}, {6, 1, 2}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 1, 0, 1, 0}, {5, 1, 1, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 1, 0}, {0, 1, 2, 0}, {1, 1, 0, 0}, {1, 1, 2, 0}, {2, 1, 0, 0}, {3, 1, 0, 0}, {6, 1, 0, 0}, {7, 1, 0, 0}, {7, 1, 1, 0}, {8, 1, 0, 0}, {8, 1, 2, 0}, {9, 1, 1, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(4);
                int v = 1;
                int w = 3 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SavannaLibrary1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaLibrary1() {
        }

        public SavannaLibrary1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaLibrary1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaLibrary1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaLibrary1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 3, 1, 0}, {6, 1, 0, 7, 1, 0}, {1, 1, 1, 1, 1, 2}, {8, 1, 1, 8, 1, 2}, {4, 2, 2, 5, 2, 2}, {2, 1, 3, 7, 2, 3}, {1, 1, 4, 1, 2, 4}, {8, 1, 4, 8, 2, 4}, {3, 1, 3, 3, 5, 3}, {6, 1, 3, 6, 5, 3}, {2, 1, 6, 2, 1, 6}, {4, 1, 6, 4, 1, 6}, {6, 1, 6, 6, 1, 6}, {3, 2, 6, 3, 2, 6}, {5, 2, 6, 5, 2, 6}, {7, 2, 6, 7, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 1, 5, 1, 2, 5}, {8, 1, 5, 8, 2, 5}, {2, 2, 6, 2, 2, 6}, {4, 2, 6, 4, 2, 6}, {6, 2, 6, 6, 2, 6}, {3, 1, 6, 3, 1, 6}, {5, 1, 6, 5, 1, 6}, {7, 1, 6, 7, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{4, 5, 3, 5, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvwwc : new int[][]{{2, 3, 3, 2, 5, 3, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {7, 3, 3, 7, 5, 3, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {1, 3, 4, 1, 5, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {8, 3, 4, 8, 5, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {2, 3, 6, 7, 5, 6, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            for (int[] uvwo : new int[][]{{3, 2, 0, -1}, {6, 2, 0, -1}, {3, 5, 5, 2}, {6, 5, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 0, 3}, {5, 1, 0, 3}, {4, 2, 1, 3}, {5, 2, 1, 3}, {1, 6, 2, 3}, {2, 6, 2, 3}, {3, 6, 2, 3}, {4, 6, 2, 3}, {5, 6, 2, 3}, {6, 6, 2, 3}, {7, 6, 2, 3}, {8, 6, 2, 3}, {1, 6, 7, 2}, {2, 6, 7, 2}, {3, 6, 7, 2}, {4, 6, 7, 2}, {5, 6, 7, 2}, {6, 6, 7, 2}, {7, 6, 7, 2}, {8, 6, 7, 2}, {0, 6, 3, 0}, {0, 6, 4, 0}, {0, 6, 5, 0}, {0, 6, 6, 0}, {9, 6, 3, 1}, {9, 6, 4, 1}, {9, 6, 5, 1}, {9, 6, 6, 1}, {2, 6, 3, 3}, {3, 6, 3, 3}, {4, 6, 3, 3}, {5, 6, 3, 3}, {6, 6, 3, 3}, {7, 6, 3, 3}, {2, 6, 6, 2}, {3, 6, 6, 2}, {4, 6, 6, 2}, {5, 6, 6, 2}, {6, 6, 6, 2}, {7, 6, 6, 2}, {1, 6, 4, 0}, {1, 6, 5, 0}, {8, 6, 4, 1}, {8, 6, 5, 1}, {7, 3, 4, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 1, 5, 1, 2}, {2, 1, 4, 7, 2, 5}, {1, 6, 3, 8, 6, 3}, {1, 6, 6, 8, 6, 6}, {1, 6, 4, 1, 6, 5}, {8, 6, 4, 8, 6, 5}, {2, 7, 4, 7, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{3, 4, 6}, {6, 4, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 3, 5, 1}}) {
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState), -1);
            }
            for (int[] uuvvww : new int[][]{{2, 3, 4, 2, 6, 4}, {7, 3, 5, 7, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uvwm : new int[][]{{4, 3, 4, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {5, 3, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {5, 3, 4, GeneralConfig.useVillageColors ? this.townColor4 : 0}, {4, 3, 5, GeneralConfig.useVillageColors ? this.townColor4 : 0}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 3, 3, 0, 1, 0}, {5, 3, 3, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, 1}, {2, 1, 2}, {3, 1, 1}, {3, 1, 2}, {6, 1, 1}, {6, 1, 2}, {7, 1, 1}, {7, 1, 2}}) {
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{0, 1, 1, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {1, 1, 0, 0}, {1, 1, 3, 0}, {2, 2, 1, 0}, {3, 2, 1, 0}, {3, 2, 2, 1}, {6, 2, 2, 1}, {7, 2, 2, 0}, {7, 1, 7, 0}, {8, 1, 0, 0}, {8, 1, 7, 0}, {9, 1, 1, 0}, {9, 1, 3, 0}, {9, 1, 4, 0}, {9, 1, 7, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 2, 2}, {6, 2, 1}}) {
                this.func_175811_a(world, Blocks.field_150328_O.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 2, 1}, {7, 2, 1}}) {
                this.func_175811_a(world, biomeSaplingState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(4);
                int v = 3;
                int w = 4 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class SavannaLargeFarm2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFF   FFF ", "FFFPFFFFF ", "PFFFPFFFF ", "PPFFFPFFF ", "FFFFFFFFPP", "FFFFFFPFFF", "PFFFFFFPF ", " PFFFFFFFF", "   FFF  F "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaLargeFarm2() {
        }

        public SavannaLargeFarm2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaLargeFarm2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaLargeFarm2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaLargeFarm2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{3, 2, 3}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uvw : new int[][]{{0, 1, 3, 6}, {0, 1, 4, 7}, {1, 1, 2, 7}, {1, 1, 6, 5}, {2, 1, 2, 6}, {2, 1, 3, 5}, {2, 1, 4, 5}, {2, 1, 5, 7}, {2, 1, 6, 7}, {3, 1, 1, 7}, {3, 1, 2, 7}, {3, 1, 5, 7}, {3, 1, 6, 7}, {4, 1, 2, 7}, {4, 1, 3, 6}, {4, 1, 4, 7}, {4, 1, 7, 2}, {5, 1, 0, 7}, {5, 1, 1, 7}, {5, 1, 2, 7}, {5, 1, 3, 7}, {5, 1, 4, 6}, {6, 1, 4, 7}, {6, 1, 5, 7}, {6, 1, 6, 7}, {6, 1, 7, 4}, {7, 1, 3, 0}, {7, 1, 4, 7}, {7, 1, 5, 6}, {7, 1, 6, 7}, {8, 1, 0, 7}, {8, 1, 1, 7}, {8, 1, 2, 0}, {8, 1, 6, 4}, {8, 1, 7, 6}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvw[3]), uvw[0], uvw[1] + 1, uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 3}, {1, 1, 7}, {4, 1, 1}, {4, 1, 5}, {7, 1, 7}, {8, 1, 3}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 0, 7}}) {
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                for (int[] uvwo : new int[][]{{6, 2, 2}}) {
                    this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 2, 7, 0}, {1, 2, 4, 1}, {2, 2, 1, 0}, {2, 2, 7, 1}, {3, 2, 0, 1}, {3, 2, 4, 0}, {5, 2, 6, 1}, {5, 2, 7, 0}, {6, 2, 1, 1}, {7, 2, 1, 0}, {8, 2, 5, 1}, {9, 2, 1, 0}, {9, 2, 3, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 2;
                int w = 3;
                while (u == 1 && w == 3 || u == 1 && w == 7 || u == 4 && w == 1 || u == 4 && w == 5 || u == 7 && w == 7 || u == 8 && w == 3 || u == 6 && w == 2 || u == 3 && w == 3) {
                    u = 1 + random.nextInt(STRUCTURE_WIDTH - 2);
                    w = 1 + random.nextInt(STRUCTURE_DEPTH - 2);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaLargeFarm1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaLargeFarm1() {
        }

        public SavannaLargeFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaLargeFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaLargeFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaLargeFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var13_17;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{1, 1, 0, 3, 1, 0}, {5, 1, 0, 7, 1, 0}, {0, 1, 1, 0, 1, 3}, {0, 1, 5, 0, 1, 7}, {1, 1, 8, 3, 1, 8}, {5, 1, 8, 7, 1, 8}, {8, 1, 1, 8, 1, 3}, {8, 1, 5, 8, 1, 7}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] nArrayArray = new int[][]{{4, 1, 0, 3}, {4, 1, 8, 2}, {0, 1, 4, 0}, {8, 1, 4, 1}};
            int n = nArrayArray.length;
            boolean bl = false;
            while (var13_17 < n) {
                int[] uvwo = nArrayArray[var13_17];
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
                ++var13_17;
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 3, 1, 4}, {4, 1, 1, 4, 1, 7}, {5, 1, 4, 7, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 2, 1, 3}, {3, 1, 1, 3, 1, 2}, {1, 1, 5, 2, 1, 7}, {3, 1, 6, 3, 1, 7}, {5, 1, 1, 5, 1, 2}, {6, 1, 1, 7, 1, 3}, {5, 1, 6, 5, 1, 7}, {6, 1, 5, 7, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150458_ak.func_176203_a(7), Blocks.field_150458_ak.func_176203_a(7), false);
            }
            for (int[] uvw : new int[][]{{3, 1, 3}, {5, 1, 3}, {3, 1, 5}, {5, 1, 5}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                for (int[] uvwo : new int[][]{{8, 1, 0}, {0, 1, 8}}) {
                    this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            for (int[][] cropPos : new int[][][]{new int[][]{{1, 2, 1, 2, 2, 3}, {3, 2, 1, 3, 2, 2}}, new int[][]{{1, 2, 5, 2, 2, 7}, {3, 2, 6, 3, 2, 7}}, new int[][]{{5, 2, 1, 5, 2, 2}, {6, 2, 1, 7, 2, 3}}, new int[][]{{5, 2, 6, 5, 2, 7}, {6, 2, 5, 7, 2, 7}}}) {
                Block cropBlock = StructureVillageVN.chooseCropPair(random)[0];
                for (int i = 0; i < 2; ++i) {
                    IBlockState cropState;
                    int cropProgressMeta = 7;
                    while (true) {
                        try {
                            cropState = cropBlock.func_176203_a(cropProgressMeta);
                        }
                        catch (IllegalArgumentException e) {
                            if (cropProgressMeta == 0) {
                                cropState = Blocks.field_150464_aj.func_176203_a(7);
                                break;
                            }
                            cropProgressMeta /= 2;
                            continue;
                        }
                        break;
                    }
                    this.func_175804_a(world, structureBB, cropPos[i][0], cropPos[i][1], cropPos[i][2], cropPos[i][3], cropPos[i][4], cropPos[i][5], cropState, cropState, false);
                }
            }
            if (!this.entitiesGenerated) {
                int n2;
                this.entitiesGenerated = true;
                int n3 = 3;
                int v = 2;
                int w = 3;
                while (!(n2 != 3 && n2 != 5 || w != 3 && w != 5)) {
                    n2 = 1 + random.nextInt(STRUCTURE_WIDTH - 2);
                    w = 1 + random.nextInt(STRUCTURE_DEPTH - 2);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(n2, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(n2, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaFletcherHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFPFFFPFFF", "FFFPFFFPFFF", "FFFPFFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaFletcherHouse1() {
        }

        public SavannaFletcherHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaFletcherHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaFletcherHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaFletcherHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvwwc : new int[][]{{2, 1, 3, 4, 4, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {6, 1, 3, 8, 4, 3, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{4, 1, 6, 4, 1, 6}, {6, 1, 6, 6, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 2, 2}, {7, 3, 2, 2}, {4, 2, 6, -1}, {6, 2, 6, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvwwc : new int[][]{{2, 1, 7, 4, 4, 7, GeneralConfig.useVillageColors ? this.townColor : 4}, {6, 1, 7, 8, 4, 7, GeneralConfig.useVillageColors ? this.townColor : 4}, {1, 1, 4, 1, 4, 6, GeneralConfig.useVillageColors ? this.townColor : 4}, {9, 1, 4, 9, 4, 6, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwc[0], uuvvwwc[1], uuvvwwc[2], uuvvwwc[3], uuvvwwc[4], uuvvwwc[5], Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), Blocks.field_150406_ce.func_176203_a(uuvvwwc[6]), false);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 3, 5, 4, 3}, {5, 1, 7, 5, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 4, 2}, {2, 1, 6, 3}, {8, 1, 4, 2}, {8, 1, 6, 3}, {0, 5, 2, 3}, {1, 5, 2, 3}, {2, 5, 2, 3}, {3, 5, 2, 3}, {4, 5, 2, 3}, {5, 5, 2, 3}, {6, 5, 2, 3}, {7, 5, 2, 3}, {8, 5, 2, 3}, {9, 5, 2, 3}, {10, 5, 2, 3}, {0, 5, 8, 2}, {1, 5, 8, 2}, {2, 5, 8, 2}, {3, 5, 8, 2}, {4, 5, 8, 2}, {5, 5, 8, 2}, {6, 5, 8, 2}, {7, 5, 8, 2}, {8, 5, 8, 2}, {9, 5, 8, 2}, {10, 5, 8, 2}, {0, 5, 3, 0}, {0, 5, 4, 0}, {0, 5, 5, 0}, {0, 5, 6, 0}, {0, 5, 7, 0}, {10, 5, 3, 1}, {10, 5, 4, 1}, {10, 5, 5, 1}, {10, 5, 6, 1}, {10, 5, 7, 1}, {1, 6, 3, 3}, {2, 6, 3, 3}, {3, 6, 3, 3}, {4, 6, 3, 3}, {5, 6, 3, 3}, {6, 6, 3, 3}, {7, 6, 3, 3}, {8, 6, 3, 3}, {9, 6, 3, 3}, {1, 6, 7, 2}, {2, 6, 7, 2}, {3, 6, 7, 2}, {4, 6, 7, 2}, {5, 6, 7, 2}, {6, 6, 7, 2}, {7, 6, 7, 2}, {8, 6, 7, 2}, {9, 6, 7, 2}, {1, 6, 4, 0}, {1, 6, 5, 0}, {1, 6, 6, 0}, {9, 6, 4, 1}, {9, 6, 5, 1}, {9, 6, 6, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 1, 4, 1}, {5, 4, 1, 5, 4, 1}, {9, 4, 1, 9, 4, 1}, {2, 5, 3, 8, 5, 3}, {2, 5, 7, 8, 5, 7}, {1, 5, 3, 1, 5, 7}, {9, 5, 3, 9, 5, 7}, {2, 6, 4, 8, 6, 6}, {2, 0, 4, 8, 0, 6}, {3, 0, 3, 3, 0, 3}, {7, 0, 3, 7, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 3, 1}, {5, 1, 1, 5, 3, 1}, {9, 1, 1, 9, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{2, 1, 5}, {8, 1, 5}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 1, 4, 4, 1}, {6, 4, 1, 8, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 2, 8, 4, 2}, {1, 4, 2, 1, 4, 3}, {9, 4, 2, 9, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 5}, {1, 3, 5}, {3, 2, 7}, {3, 3, 7}, {7, 2, 7}, {7, 3, 7}, {9, 2, 5}, {9, 3, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState fletchingTableState = ModObjects.chooseModFletchingTableState(2, this.func_186165_e());
            this.func_175811_a(world, fletchingTableState, 5, 1, 6, structureBB);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 3, 0, 1, 0}, {7, 1, 3, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{1, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {5, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {9, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {1, 4, 8, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {5, 4, 8, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {9, 4, 8, 0, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 5, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {10, 4, 5, 1, GeneralConfig.useVillageColors ? this.townColor3 : 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (int[] uvwg : new int[][]{{0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 5, 0}, {0, 1, 7, 0}, {0, 1, 8, 0}, {1, 1, 0, 0}, {1, 1, 8, 0}, {2, 1, 0, 0}, {2, 1, 2, 0}, {2, 1, 8, 0}, {4, 1, 2, 0}, {5, 1, 2, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 8, 0}, {8, 1, 0, 0}, {8, 1, 1, 0}, {10, 1, 0, 0}, {10, 1, 2, 0}, {10, 1, 3, 0}, {10, 1, 4, 0}, {10, 1, 5, 0}, {10, 1, 6, 0}, {10, 1, 7, 0}, {10, 1, 8, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {7, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(5);
                int v = 1;
                int w = 4 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaFisherCottage1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFF ", "FFFFFFF ", " FFFFF  ", "   FFF  ", "   FFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaFisherCottage1() {
        }

        public SavannaFisherCottage1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaFisherCottage1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaFisherCottage1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaFisherCottage1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 2, 0, 3}, {4, 2, 0, 3}, {5, 2, 0, 3}, {3, 3, 1, 3}, {4, 3, 1, 3}, {5, 3, 1, 3}, {3, 4, 2, 3}, {4, 4, 2, 3}, {5, 4, 2, 3}, {1, 9, 2, 3}, {2, 9, 2, 3}, {3, 9, 2, 3}, {4, 9, 2, 3}, {5, 9, 2, 3}, {6, 9, 2, 3}, {7, 9, 2, 3}, {1, 9, 7, 2}, {2, 9, 7, 2}, {3, 9, 7, 2}, {4, 9, 7, 2}, {5, 9, 7, 2}, {6, 9, 7, 2}, {7, 9, 7, 2}, {1, 9, 3, 0}, {1, 9, 4, 0}, {1, 9, 5, 0}, {1, 9, 6, 0}, {7, 9, 3, 1}, {7, 9, 4, 1}, {7, 9, 5, 1}, {7, 9, 6, 1}, {2, 10, 3, 3}, {3, 10, 3, 3}, {4, 10, 3, 3}, {5, 10, 3, 3}, {6, 10, 3, 3}, {2, 10, 6, 2}, {3, 10, 6, 2}, {4, 10, 6, 2}, {5, 10, 6, 2}, {6, 10, 6, 2}, {2, 10, 4, 0}, {2, 10, 5, 0}, {6, 10, 4, 1}, {6, 10, 5, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 2, 1, 5, 2, 1}, {3, 3, 2, 5, 3, 2}, {3, 4, 3, 3, 4, 3}, {5, 4, 3, 5, 4, 3}, {2, 5, 3, 2, 5, 6}, {3, 5, 4, 5, 5, 6}, {6, 5, 3, 6, 5, 6}, {2, 9, 3, 2, 9, 6}, {6, 9, 3, 6, 9, 6}, {3, 9, 3, 5, 9, 4}, {3, 9, 6, 5, 9, 6}, {3, 10, 4, 5, 10, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{3, 6, 4, 5, 8, 4}, {3, 6, 6, 5, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 7, 3, 2}, {5, 7, 3, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 6, 3, 2, 8, 3}, {6, 6, 3, 6, 8, 3}, {2, 6, 6, 2, 8, 6}, {6, 6, 6, 6, 8, 6}, {2, 1, 6, 2, 1, 6}, {4, 1, 6, 4, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 3, 2, 4, 3}, {4, 2, 3, 4, 4, 3}, {6, 2, 3, 6, 4, 3}, {2, 2, 6, 2, 4, 6}, {4, 2, 6, 4, 4, 6}, {6, 2, 6, 6, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 5, 3, 5, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 6, 4, 2, 8, 5}, {6, 6, 4, 6, 8, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvw : new int[][]{{4, 7, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoo : new int[][]{{1, 2, 2, 2, 2}, {5, 2, 4, 3, 3}, {5, 3, 4, 0, -1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), ModObjects.chooseModBarrelBlockState(this.func_186165_e(), uvwoo[4], uvwoo[3]), 2);
            }
            for (int[] uvw : new int[][]{{1, 1, 4}, {1, 1, 5}, {1, 1, 6}, {1, 1, 7}, {2, 1, 4}, {2, 1, 5}, {2, 1, 7}, {3, 1, 4}, {3, 1, 5}, {3, 1, 6}, {3, 1, 7}, {4, 1, 5}, {4, 1, 7}, {5, 1, 6}, {5, 1, 7}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 6, 4, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 2, 3, 0}, {1, 2, 3, 0}, {5, 2, 2, 0}, {5, 2, 8, 0}, {6, 2, 7, 0}, {7, 2, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, -1}, {4, 2, -1}, {5, 2, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 4;
                int v = 2;
                int w = 5;
                int s = random.nextInt(24);
                if (s < 24) {
                    u = 5;
                    w = 5;
                } else if (s < 23) {
                    u = 6;
                    w = s - 17;
                } else if (s < 21) {
                    u = 7;
                    w = s - 14;
                } else if (s < 19) {
                    u = s - 11;
                    w = 7;
                } else if (s < 17) {
                    u = s - 9;
                    w = 8;
                } else if (s < 10) {
                    u = 0;
                    w = s - 1;
                } else if (s < 5) {
                    u = s - 3;
                    w = 3;
                } else {
                    u = s + 3;
                    v = 6;
                    w = 5;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaCartographer1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", " F F F F ", "         ", " F  F  F ", "         ", " F F F F ", "   FFF   ", "   FFF   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaCartographer1() {
        }

        public SavannaCartographer1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaCartographer1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaCartographer1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaCartographer1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            ItemStack villageBanner;
            NBTTagCompound villageNBTtag;
            NBTTagCompound modifystanding;
            TileEntityBanner tilebanner;
            BlockPos bannerPos;
            int bannerZ;
            int bannerY;
            int bannerX;
            Object bannerZBB;
            Object bannerYBB;
            Object bannerXBB;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 2, 1, 1, 2}, {3, 0, 2, 3, 1, 2}, {5, 0, 2, 5, 1, 2}, {7, 0, 2, 7, 1, 2}, {1, 0, 4, 1, 1, 4}, {7, 0, 4, 7, 1, 4}, {1, 0, 6, 1, 1, 6}, {3, 0, 6, 3, 1, 6}, {5, 0, 6, 5, 1, 6}, {7, 0, 6, 7, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 1, 5, 0, 1}, {4, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 2, 6}, {2, 2, 3, 6, 2, 6}, {7, 2, 2, 7, 2, 6}, {1, 6, 2, 7, 6, 3}, {1, 6, 6, 7, 6, 6}, {1, 6, 4, 1, 6, 5}, {7, 6, 4, 7, 6, 5}, {2, 7, 3, 6, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 0, 0, 3}, {4, 0, 0, 3}, {5, 0, 0, 3}, {3, 1, 1, 3}, {4, 1, 1, 3}, {5, 1, 1, 3}, {0, 6, 1, 3}, {1, 6, 1, 3}, {2, 6, 1, 3}, {3, 6, 1, 3}, {4, 6, 1, 3}, {5, 6, 1, 3}, {6, 6, 1, 3}, {7, 6, 1, 3}, {8, 6, 1, 3}, {0, 6, 7, 2}, {1, 6, 7, 2}, {2, 6, 7, 2}, {3, 6, 7, 2}, {4, 6, 7, 2}, {5, 6, 7, 2}, {6, 6, 7, 2}, {7, 6, 7, 2}, {8, 6, 7, 2}, {0, 6, 2, 0}, {0, 6, 3, 0}, {0, 6, 4, 0}, {0, 6, 5, 0}, {0, 6, 6, 0}, {8, 6, 2, 1}, {8, 6, 3, 1}, {8, 6, 4, 1}, {8, 6, 5, 1}, {8, 6, 6, 1}, {1, 7, 2, 3}, {2, 7, 2, 3}, {3, 7, 2, 3}, {4, 7, 2, 3}, {5, 7, 2, 3}, {6, 7, 2, 3}, {7, 7, 2, 3}, {1, 7, 6, 2}, {2, 7, 6, 2}, {3, 7, 6, 2}, {4, 7, 6, 2}, {5, 7, 6, 2}, {6, 7, 6, 2}, {7, 7, 6, 2}, {1, 7, 3, 0}, {1, 7, 4, 0}, {1, 7, 5, 0}, {7, 7, 3, 1}, {7, 7, 4, 1}, {7, 7, 5, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 2, 6, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 3, 2, 1, 5, 2}, {7, 3, 2, 7, 5, 2}, {1, 3, 6, 1, 5, 6}, {7, 3, 6, 7, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeWoodState = ModObjects.chooseModWoodState(biomeLogVertState);
            for (int[] uw : new int[][]{{2, 3, 4, 2, 3, 4}, {6, 3, 5, 6, 3, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeWoodState, biomeWoodState, false);
            }
            for (int[] uvwo : new int[][]{{2, 4, 4, -1}, {6, 4, 5, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{1, 3, 3, 1, 5, 5}, {7, 3, 3, 7, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{2, 3, 3, 6, 5, 3}, {2, 3, 6, 6, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{4, 5, 2, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 4, 6}, {5, 4, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState cartographyTableState = ModObjects.chooseModCartographyTableState(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 3, 5}}) {
                this.func_175811_a(world, cartographyTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 3, 3, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int chestU = 6;
            int chestV = 3;
            int chestW = 4;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_cartographer");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvwoc : (ChestGenHooks)new int[][]{{0, 3, 3, 3, GeneralConfig.useVillageColors ? this.townColor2 : 12}, {0, 3, 4, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 3, 5, 3, GeneralConfig.useVillageColors ? this.townColor4 : 12}, {8, 3, 3, 1, GeneralConfig.useVillageColors ? this.townColor5 : 12}, {8, 3, 4, 1, GeneralConfig.useVillageColors ? this.townColor6 : 12}, {8, 3, 5, 1, GeneralConfig.useVillageColors ? this.townColor7 : 12}}) {
                bannerXBB = uvwoc[0];
                bannerYBB = uvwoc[1];
                bannerZBB = uvwoc[2];
                bannerX = this.func_74865_a((int)bannerXBB, (int)bannerZBB);
                bannerY = this.func_74862_a((int)bannerYBB);
                bannerZ = this.func_74873_b((int)bannerXBB, (int)bannerZBB);
                bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta((int)uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                tilebanner = new TileEntityBanner();
                modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74768_a("Base", 15 - (GeneralConfig.useVillageColors ? (int)uvwoc[4] : 12));
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (Object uvwoc : (ChestGenHooks)new int[][]{{3, 5, 2, 2, 12}, {5, 5, 2, 2, 12}}) {
                bannerXBB = uvwoc[0];
                bannerYBB = uvwoc[1];
                bannerZBB = uvwoc[2];
                bannerX = this.func_74865_a((int)bannerXBB, (int)bannerZBB);
                bannerY = this.func_74862_a((int)bannerYBB);
                bannerZ = this.func_74873_b((int)bannerXBB, (int)bannerZBB);
                bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta((int)uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                tilebanner = new TileEntityBanner();
                modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                if (GeneralConfig.useVillageColors) {
                    villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                    tilebanner.func_145839_a(modifystanding);
                    villageBanner = new ItemStack(Items.field_179564_cE);
                    villageBanner.func_77983_a("BlockEntityTag", (NBTBase)villageNBTtag.func_74775_l("BlockEntityTag"));
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (Object uvwoc : (ChestGenHooks)new int[][]{{3, 5, 2, 2, 12}, {5, 5, 2, 2, 12}}) {
                bannerXBB = uvwoc[0];
                bannerYBB = uvwoc[1];
                bannerZBB = uvwoc[2];
                bannerX = this.func_74865_a((int)bannerXBB, (int)bannerZBB);
                bannerY = this.func_74862_a((int)bannerYBB);
                bannerZ = this.func_74873_b((int)bannerXBB, (int)bannerZBB);
                bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta((int)uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                tilebanner = new TileEntityBanner();
                modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                if (GeneralConfig.useVillageColors) {
                    villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                    tilebanner.func_145839_a(modifystanding);
                    villageBanner = new ItemStack(Items.field_179564_cE);
                    villageBanner.func_77983_a("BlockEntityTag", (NBTBase)villageNBTtag.func_74775_l("BlockEntityTag"));
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            for (Object uvw : (ChestGenHooks)new int[][]{{3, 0, -1}, {4, 0, -1}, {5, 0, -1}}) {
                Object pathU = uvw[0];
                Object pathV = uvw[1];
                Object pathW = uvw[2];
                this.func_74871_b(world, (int)pathU, (int)pathV, (int)pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, (int)pathU, (int)(pathV - 2), (int)pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW)))) {
                    this.func_175811_a(world, biomeGrassState, (int)pathU, (int)(pathV - true), (int)pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 3;
                int w = 4 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class SavannaButchersShop2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFF F", "FFFFFFF  ", "FFFFFFF  ", "FFFFFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaButchersShop2() {
        }

        public SavannaButchersShop2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaButchersShop2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaButchersShop2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaButchersShop2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 1, 4}, {0, 1, 4, 1, 1, 4}, {0, 1, 5, 0, 1, 12}, {1, 1, 12, 8, 1, 12}, {8, 1, 4, 8, 1, 11}, {6, 1, 4, 7, 1, 4}, {6, 1, 1, 6, 1, 3}, {2, 2, 4, 2, 2, 4}, {2, 1, 7, 2, 2, 7}, {4, 1, 4, 4, 2, 4}, {4, 1, 7, 4, 2, 7}, {6, 2, 4, 6, 2, 4}, {6, 1, 7, 6, 2, 7}, {5, 2, 5, 5, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 1, 5, 1, 1}, {3, 3, 3, 5, 3, 3}, {2, 3, 4, 3, 3, 7}, {4, 3, 5, 4, 3, 6}, {5, 3, 4, 6, 3, 7}, {2, 7, 4, 6, 7, 4}, {2, 7, 7, 6, 7, 7}, {2, 7, 5, 2, 7, 6}, {6, 7, 5, 6, 7, 6}, {3, 8, 5, 5, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 1, 0, 3}, {4, 1, 0, 3}, {5, 1, 0, 3}, {3, 2, 1, 3}, {4, 2, 1, 3}, {5, 2, 1, 3}, {3, 3, 2, 3}, {4, 3, 2, 3}, {5, 3, 2, 3}, {3, 4, 5, 1}, {3, 4, 6, 1}, {5, 3, 8, 1}, {6, 2, 9, 2}, {6, 1, 10, 2}, {2, 7, 3, 3}, {3, 7, 3, 3}, {4, 7, 3, 3}, {5, 7, 3, 3}, {6, 7, 3, 3}, {2, 7, 8, 2}, {3, 7, 8, 2}, {4, 7, 8, 2}, {5, 7, 8, 2}, {6, 7, 8, 2}, {1, 7, 4, 0}, {1, 7, 5, 0}, {1, 7, 6, 0}, {1, 7, 7, 0}, {7, 7, 4, 1}, {7, 7, 5, 1}, {7, 7, 6, 1}, {7, 7, 7, 1}, {2, 8, 4, 3}, {3, 8, 4, 3}, {4, 8, 4, 3}, {5, 8, 4, 3}, {6, 8, 4, 3}, {6, 8, 5, 1}, {6, 8, 6, 1}, {2, 8, 7, 2}, {3, 8, 7, 2}, {4, 8, 7, 2}, {5, 8, 7, 2}, {6, 8, 7, 2}, {2, 8, 5, 0}, {2, 8, 6, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 2, 2, 5, 2, 2}, {3, 3, 8, 4, 3, 8}, {6, 2, 8, 6, 2, 8}, {6, 1, 9, 6, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 4, 3, 6, 4}, {5, 4, 4, 6, 6, 4}, {2, 4, 7, 3, 6, 7}, {5, 4, 7, 6, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{4, 6, 4, 4, 6, 4}, {4, 6, 7, 4, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{4, 3, 4, 4, 3, 4}, {4, 3, 7, 4, 3, 7}, {2, 4, 5, 2, 4, 6}, {2, 6, 5, 2, 6, 6}, {6, 4, 5, 6, 4, 6}, {6, 6, 5, 6, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{3, 5, 3, 2}, {5, 5, 3, 2}, {4, 6, 6, 2}, {4, 6, 8, 0}, {0, 2, 12, -1}, {8, 2, 12, -1}, {8, 2, 4, -1}, {4, 1, 5, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 5, 5}, {2, 5, 6}, {6, 5, 5}, {6, 5, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{3, 4, 8, 0}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(smokerState.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 4, 4, 0, 1, 1}, {4, 4, 7, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{7, 0, 0}, {7, 0, 1}, {7, 0, 2}, {7, 0, 3}, {8, 0, 0}, {8, 0, 1}, {8, 0, 2}}) {
                this.func_74871_b(world, uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175808_b(world, biomeFillerState, uvwg[0], uvwg[1] - 2, uvwg[2], structureBB);
                this.func_175811_a(world, biomeGrassState, uvwg[0], uvwg[1] - 1, uvwg[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{0, 1, 1, 0}, {1, 1, 0, 0}, {1, 1, 2, 0}, {1, 1, 3, 0}, {1, 1, 5, 0}, {1, 1, 7, 0}, {1, 1, 8, 0}, {1, 1, 9, 0}, {1, 1, 10, 0}, {2, 1, 0, 0}, {2, 1, 11, 0}, {3, 1, 5, 0}, {3, 1, 9, 0}, {3, 1, 10, 0}, {3, 1, 11, 0}, {4, 1, 8, 0}, {4, 1, 10, 0}, {5, 1, 6, 0}, {5, 1, 9, 0}, {5, 1, 10, 0}, {5, 1, 11, 0}, {6, 1, 0, 0}, {6, 1, 5, 0}, {6, 1, 6, 0}, {6, 1, 11, 0}, {7, 1, 5, 0}, {7, 1, 6, 0}, {7, 1, 8, 0}, {7, 1, 9, 0}, {7, 1, 10, 0}, {7, 0, 0, 0}, {8, 0, 1, 0}, {8, 0, 2, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            int chestU = 5;
            int chestV = 4;
            int chestW = 6;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_butcher");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvw : (ChestGenHooks)new int[][]{{3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                Object pathU = uvw[0];
                Object pathV = uvw[1];
                Object pathW = uvw[2];
                this.func_74871_b(world, (int)pathU, (int)pathV, (int)pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, (int)pathU, (int)(pathV - 2), (int)pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW)))) {
                    this.func_175811_a(world, biomeGrassState, (int)pathU, (int)(pathV - true), (int)pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (Object uvw : (ChestGenHooks)new int[][]{{2, 1, 6}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a((int)uvw[0], (int)uvw[2]) + 0.5, (double)this.func_74862_a((int)uvw[1]) + 0.5, (double)this.func_74873_b((int)uvw[0], (int)uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
                int u = 4;
                int v = 4;
                int w = 5;
                int s = random.nextInt(3);
                if (s == 2) {
                    u = 5;
                    w = 5;
                } else {
                    u = 4;
                    w = 5 + s;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SavannaButchersShop1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaButchersShop1() {
        }

        public SavannaButchersShop1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaButchersShop1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaButchersShop1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaButchersShop1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{4, 1, 1, 4, 1, 1}, {4, 4, 1, 4, 4, 1}, {7, 4, 3, 7, 4, 3}, {7, 2, 3, 7, 2, 3}, {3, 4, 6, 3, 4, 6}, {3, 2, 6, 3, 2, 6}, {7, 4, 6, 7, 4, 6}, {7, 2, 6, 7, 2, 6}, {5, 4, 6, 5, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvw : new int[][]{{7, 3, 3}, {3, 3, 6}, {7, 3, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 4, 2, 0}, {5, 4, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3, 4, 1}, {5, 1, 1, 5, 4, 2}, {6, 1, 3, 6, 4, 3}, {7, 1, 3, 7, 1, 3}, {8, 1, 3, 8, 4, 3}, {9, 1, 4, 9, 4, 5}, {2, 1, 6, 2, 4, 6}, {3, 1, 6, 3, 1, 6}, {4, 1, 6, 4, 4, 6}, {5, 1, 6, 5, 1, 6}, {6, 1, 6, 6, 4, 6}, {7, 1, 6, 7, 1, 6}, {8, 1, 6, 8, 4, 6}, {1, 1, 4, 1, 4, 5}, {2, 1, 2, 2, 4, 3}, {2, 1, 7, 2, 1, 10}, {3, 1, 10, 6, 1, 10}, {7, 1, 7, 7, 1, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 7, 6, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 7, 2, 2, 10}, {3, 2, 10, 6, 2, 10}, {7, 2, 7, 7, 2, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {5, 3, 0, 2}, {2, 3, 10, -1}, {7, 3, 10, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 1, 5, 5, 1}, {5, 5, 2, 6, 5, 2}, {6, 5, 3, 9, 5, 3}, {9, 5, 4, 9, 5, 6}, {1, 5, 6, 8, 5, 6}, {1, 5, 3, 1, 5, 5}, {2, 5, 2, 2, 5, 3}, {3, 6, 2, 4, 6, 2}, {3, 6, 3, 5, 6, 3}, {3, 6, 4, 8, 6, 4}, {2, 6, 5, 8, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 0, 3}, {3, 1, 0, 0}, {5, 1, 0, 1}, {1, 5, 0, 3}, {2, 5, 0, 3}, {3, 5, 0, 3}, {4, 5, 0, 3}, {5, 5, 0, 3}, {6, 5, 0, 3}, {6, 5, 1, 1}, {7, 5, 2, 3}, {8, 5, 2, 3}, {9, 5, 2, 3}, {10, 5, 3, 1}, {10, 5, 4, 1}, {10, 5, 5, 1}, {10, 5, 6, 1}, {1, 5, 4, 2}, {2, 5, 4, 2}, {3, 5, 4, 2}, {4, 5, 4, 2}, {5, 5, 4, 2}, {6, 5, 4, 2}, {7, 5, 4, 2}, {8, 5, 4, 2}, {9, 5, 4, 2}, {1, 5, 1, 0}, {1, 5, 2, 0}, {0, 5, 2, 3}, {0, 5, 3, 0}, {0, 5, 4, 0}, {0, 5, 5, 0}, {0, 5, 6, 0}, {1, 5, 7, 2}, {2, 5, 7, 2}, {3, 5, 7, 2}, {4, 5, 7, 2}, {5, 5, 7, 2}, {6, 5, 7, 2}, {7, 5, 7, 2}, {8, 5, 7, 2}, {9, 5, 7, 2}, {2, 6, 1, 3}, {3, 6, 1, 3}, {4, 6, 1, 3}, {5, 6, 1, 1}, {5, 6, 2, 3}, {6, 6, 2, 1}, {6, 6, 3, 3}, {7, 6, 3, 3}, {8, 6, 3, 3}, {9, 6, 3, 1}, {9, 6, 4, 1}, {9, 6, 5, 1}, {9, 6, 6, 1}, {8, 6, 6, 2}, {7, 6, 6, 2}, {6, 6, 6, 2}, {5, 6, 6, 2}, {4, 6, 6, 2}, {3, 6, 6, 2}, {2, 6, 6, 2}, {1, 6, 6, 2}, {1, 6, 5, 0}, {1, 6, 4, 0}, {1, 6, 3, 3}, {2, 6, 3, 0}, {2, 6, 2, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwc : new int[][]{{2, 1, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {2, 1, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {3, 1, 5, GeneralConfig.useVillageColors ? this.townColor : 4}, {3, 1, 4, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {3, 1, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {3, 1, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {4, 1, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {4, 1, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {4, 1, 3, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {4, 1, 2, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 1, 3, GeneralConfig.useVillageColors ? this.townColor : 4}, {5, 1, 4, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {5, 1, 5, GeneralConfig.useVillageColors ? this.townColor : 4}, {6, 1, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {6, 1, 4, GeneralConfig.useVillageColors ? this.townColor : 4}, {8, 1, 5, GeneralConfig.useVillageColors ? this.townColor2 : 1}, {8, 1, 4, GeneralConfig.useVillageColors ? this.townColor : 4}}) {
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwc[3]), uvwc[0], uvwc[1], uvwc[2], structureBB);
            }
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{2, 2, 4, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(smokerState.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 5, 2, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 4, 2, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uuvvww : new int[][]{{7, 1, 4, 7, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150333_U.func_176203_a(8), Blocks.field_150333_U.func_176203_a(8), false);
            }
            for (int[] uuvvwwo : new int[][]{{8, 2, 4, 8, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150334_T.func_176203_a(0), Blocks.field_150334_T.func_176203_a(0), false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 1, 0, 1, 1}, {5, 2, 6, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 2, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 8, 0}, {0, 1, 10, 0}, {1, 1, 2, 0}, {1, 1, 3, 0}, {1, 1, 6, 0}, {1, 1, 7, 0}, {1, 1, 8, 0}, {1, 1, 9, 0}, {2, 1, 0, 0}, {2, 1, 1, 0}, {6, 1, 1, 0}, {8, 1, 1, 0}, {8, 1, 7, 0}, {8, 1, 9, 0}, {8, 1, 10, 0}, {9, 1, 1, 0}, {9, 1, 6, 0}, {10, 1, 1, 0}, {10, 1, 3, 0}, {10, 1, 4, 0}, {10, 1, 5, 0}, {10, 1, 7, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{5, 2, 8}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
                int u = 3;
                int v = 2;
                int w = 5;
                int s = random.nextInt(15);
                if (s >= 11) {
                    u = 6 + s % 2 == 0 ? 0 : 1;
                    w = 4 + s > 12 ? 1 : 0;
                } else if (s >= 8) {
                    u = 5;
                    w = s - 3;
                } else {
                    u = 3 + s > 3 ? 1 : 0;
                    w = 2 + s % 4;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class SavannaArmorer1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaArmorer1() {
        }

        public SavannaArmorer1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaArmorer1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaArmorer1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaArmorer1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 3, 1}, {4, 1, 1, 4, 3, 1}, {2, 1, 5, 4, 3, 5}, {1, 1, 2, 1, 3, 4}, {5, 1, 2, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{3, 0, 1, 3, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 3, 1, 3, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 2}, {1, 4, 1, 5, 4, 1}, {1, 4, 2, 1, 4, 4}, {1, 4, 5, 5, 4, 5}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 2, 5, 4}, {3, 5, 2, 3, 5, 3}, {4, 5, 2, 4, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {1, 5, 1, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {5, 5, 1, 3}, {1, 5, 5, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {5, 5, 5, 2}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, 4, 2}}) {
                IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(uvw[3], this.func_186165_e());
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), blastFurnaceState, 2);
            }
            for (int[] uuvvwwo : new int[][]{{2, 0, 3, 4, 0, 3}, {2, 1, 4, 2, 2, 4}, {3, 3, 4, 3, 5, 4}, {4, 1, 4, 4, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 1), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 1), false);
            }
            for (int[] uvwoc : new int[][]{{3, 2, 4, 2, GeneralConfig.useVillageColors ? this.townColor2 : 1}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{0, 1, 0, 0}, {0, 1, 1, 0}, {0, 1, 2, 0}, {0, 1, 3, 0}, {0, 1, 4, 0}, {0, 1, 5, 0}, {0, 1, 6, 0}, {0, 1, 7, 0}, {1, 1, 0, 0}, {1, 1, 1, 0}, {1, 1, 6, 0}, {2, 1, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(3);
                int v = 1;
                int w = 2 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class SavannaAnimalPen3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaAnimalPen3() {
        }

        public SavannaAnimalPen3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaAnimalPen3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaAnimalPen3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaAnimalPen3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{2, 1, 2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] nArray = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(nArray[0], nArray[2]), this.func_74862_a(nArray[1]), this.func_74873_b(nArray[0], nArray[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(nArray[0], nArray[2]), 64, this.func_74873_b(nArray[0], nArray[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, nArray, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0, 1, 1, 0}, {3, 1, 0, 3, 1, 0}, {5, 1, 0, 7, 1, 0}, {0, 1, 8, 7, 1, 8}, {0, 1, 1, 0, 1, 7}, {7, 1, 1, 7, 1, 7}, {2, 1, 5, 2, 3, 5}, {5, 1, 5, 5, 3, 5}, {2, 2, 8, 2, 3, 8}, {5, 2, 8, 5, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{2, 1, 0, 2, 0}, {4, 1, 0, 2, 0}}) {
                this.func_175811_a(world, iBlockState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 2, 8, -1}, {4, 2, 8, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 5, 5, 4, 5}, {2, 4, 8, 5, 4, 8}, {2, 4, 6, 2, 4, 7}, {5, 4, 6, 5, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodDoubleSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150373_bw.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 4, 6, 4, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodDoubleSlabState, biomeWoodDoubleSlabState, false);
            }
            for (int[] uvwg : new int[][]{{1, 1, 5, 0}, {1, 1, 6, 0}, {2, 1, 3, 0}, {2, 1, 4, 0}, {2, 1, 6, 0}, {3, 1, 2, 0}, {3, 1, 5, 0}, {3, 1, 6, 0}, {4, 1, 6, 0}, {4, 1, 7, 0}, {5, 1, 2, 0}, {5, 1, 4, 0}, {6, 1, 1, 0}, {6, 1, 2, 0}, {6, 1, 5, 0}, {6, 1, 7, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{4, 1, 3}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                            String[] petname_a = NameGenerator.newRandomName("pet", random);
                            animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                        }
                        animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaAnimalPen2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFFF     ", "  FFFFFF   F ", "  FFFFFF     ", "  FFFFFFFFF  ", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "  FFFFFFFFFF ", "   FFFFFFFFFF", "   FFFFFFFF  ", "      FFFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaAnimalPen2() {
        }

        public SavannaAnimalPen2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaAnimalPen2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaAnimalPen2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaAnimalPen2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 2);
            this.establishFoundation(world, structureBB, foundationPattern, 2, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{5, 2, 6}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uvw : new int[][]{{4, 0, 6}, {5, 0, 5}, {9, 0, 6}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 2, 0, 7, 2, 0}, {7, 3, 0, 7, 4, 0}, {8, 4, 0, 9, 4, 0}, {9, 2, 0, 9, 3, 0}, {10, 2, 0, 10, 2, 2}, {11, 2, 2, 11, 2, 4}, {12, 2, 4, 12, 2, 7}, {10, 2, 7, 11, 2, 7}, {7, 2, 8, 10, 2, 8}, {7, 2, 9, 7, 2, 11}, {2, 2, 11, 6, 2, 11}, {2, 2, 7, 2, 2, 10}, {0, 2, 7, 1, 2, 7}, {0, 2, 4, 0, 2, 6}, {1, 2, 4, 2, 2, 4}, {2, 2, 3, 3, 2, 3}, {3, 2, 1, 3, 2, 2}, {4, 2, 1, 6, 2, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{8, 2, 0, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{7, 5, 0, -1}, {9, 5, 0, -1}, {12, 3, 4, -1}, {7, 3, 8, -1}, {0, 3, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{1, 2, 5, 0}, {1, 2, 6, 0}, {2, 2, 6, 1}, {3, 2, 5, 0}, {3, 2, 6, 0}, {3, 2, 8, 0}, {3, 2, 9, 0}, {4, 2, 2, 0}, {4, 2, 3, 0}, {4, 2, 4, 0}, {4, 2, 5, 0}, {4, 2, 9, 1}, {4, 2, 10, 1}, {5, 2, 3, 0}, {5, 2, 8, 0}, {5, 2, 10, 0}, {6, 2, 4, 1}, {6, 2, 6, 0}, {6, 2, 8, 0}, {6, 2, 9, 1}, {6, 2, 10, 1}, {7, 2, 2, 0}, {7, 2, 3, 0}, {7, 2, 4, 0}, {7, 2, 6, 0}, {8, 2, 1, 0}, {8, 2, 2, 0}, {8, 2, 3, 0}, {8, 2, 5, 0}, {8, 2, 6, 0}, {8, 2, 7, 0}, {9, 2, 1, 0}, {9, 2, 2, 0}, {9, 2, 3, 1}, {9, 2, 5, 0}, {10, 2, 5, 0}, {11, 2, 5, 0}, {11, 2, 6, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvw : new int[][]{{8, 2, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{4, 2, 8}, {8, 2, 4}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                            String[] petname_a = NameGenerator.newRandomName("pet", random);
                            animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                        }
                        animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaAnimalPen1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "    F    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public SavannaAnimalPen1() {
        }

        public SavannaAnimalPen1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static SavannaAnimalPen1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return SavannaAnimalPen1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new SavannaAnimalPen1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 1, 8, 0, 1}, {0, 0, 8, 8, 0, 8}, {0, 0, 2, 0, 0, 7}, {8, 0, 2, 8, 0, 7}, {2, 1, 7, 6, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 2, 7, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uvw : new int[][]{{1, 0, 5}, {3, 0, 2}, {3, 0, 3}, {4, 0, 2}, {5, 0, 4}, {6, 0, 2}, {7, 0, 2}, {7, 0, 3}, {7, 0, 4}, {7, 0, 5}, {7, 0, 6}, {7, 0, 7}}) {
                this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 1, 8, 1, 1}, {0, 1, 8, 8, 1, 8}, {0, 1, 2, 0, 1, 7}, {8, 1, 2, 8, 1, 7}, {0, 2, 4, 0, 3, 4}, {4, 1, 4, 4, 3, 4}, {8, 2, 4, 8, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{4, 1, 1, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 5, 6, 1, 5}, {2, 1, 6, 2, 1, 6}, {6, 1, 6, 6, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{3, 1, 6}, {4, 1, 6}, {5, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 8, 8, 2, 8}, {0, 3, 6, 8, 3, 6}, {0, 4, 4, 8, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 7, 1, 2, 7}, {7, 2, 7, 8, 2, 7}, {0, 3, 5, 8, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodDoubleSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150373_bw.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 7, 6, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodDoubleSlabState, biomeWoodDoubleSlabState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 0, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{5, 1, 2}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class SavannaMeetingPoint4
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{" F PPP   ", " PPPPPPP ", " PPFFFPP ", "PPFFFFFPP", "PPFFFFFPP", "PPFFFFFPP", " PPFFFPP ", " PPPPPPP ", "F  PPP   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SavannaMeetingPoint4() {
        }

        public SavannaMeetingPoint4(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 69, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 69, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodenStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeBarkState = ModObjects.chooseModWoodState(biomeLogState);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(4, 4), this.func_74862_a(3), this.func_74873_b(4, 4));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            for (int[] uw : new int[][]{{0, 0}, {1, 10}}) {
                this.func_175811_a(world, biomeGrassState, uw[0], 0, uw[1], structureBB);
            }
            this.func_175804_a(world, structureBB, 3, 0, 2, 5, 0, 6, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 2, 0, 3, 5, 0, 5, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 3, 1, 2, 5, 1, 6, biomeBarkState, biomeBarkState, false);
            this.func_175804_a(world, structureBB, 2, 1, 3, 6, 1, 5, biomeBarkState, biomeBarkState, false);
            this.func_175804_a(world, structureBB, 4, 0, 3, 4, 0, 5, biomeBarkState, biomeBarkState, false);
            this.func_175804_a(world, structureBB, 3, 0, 4, 5, 0, 4, biomeBarkState, biomeBarkState, false);
            this.func_175804_a(world, structureBB, 4, 1, 3, 4, 1, 5, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 3, 1, 4, 5, 1, 4, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            for (int[] uvwo : new int[][]{{2, 2, 4, -1}, {4, 2, 2, -1}, {4, 2, 6, -1}, {6, 2, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 3, 2, 3, 5, 3, 5, biomeFenceState, biomeFenceState, false);
            this.func_74878_a(world, structureBB, 4, 2, 3, 4, 3, 5);
            this.func_74878_a(world, structureBB, 3, 2, 4, 5, 3, 4);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(3), 3, 4, 3, structureBB);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(3), 4, 4, 3, structureBB);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(1), 5, 4, 3, structureBB);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(1), 5, 4, 4, structureBB);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(2), 5, 4, 5, structureBB);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(2), 4, 4, 5, structureBB);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(0), 3, 4, 5, structureBB);
            this.func_175811_a(world, biomeWoodenStairsState.func_177230_c().func_176203_a(0), 3, 4, 4, structureBB);
            this.func_175811_a(world, biomePlankState, 4, 4, 4, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 4, 3, 4, structureBB);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signXBB = 4;
                int signYBB = 3;
                int signZBB = 3;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(2, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                int signZBB2 = 5;
                int signX2 = this.func_74865_a(signXBB, signZBB2);
                int signZ2 = this.func_74873_b(signXBB, signZBB2);
                TileEntitySign signContents2 = new TileEntitySign();
                for (int i = 0; i < 4; ++i) {
                    signContents2.field_145915_a[i] = signContents.field_145915_a[i];
                }
                world.func_180501_a(new BlockPos(signX2, signY, signZ2), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(0, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX2, signY, signZ2), (TileEntity)signContents2);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 7;
                int bannerZBB = 7;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175804_a(world, structureBB, bannerXBB, bannerYBB - 2, bannerZBB, bannerXBB, bannerYBB - 1, bannerZBB, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(12, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, true);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{7, 1, 1, -1, 0}, {8, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class SavannaMeetingPoint3
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"   PPP   ", "F PPPPP  ", "  PFFFP  ", " PPFFFPP ", "PPPFFFPPP", "PPPPPPPPP", "PPPFFFPPP", " PPFFFPP ", "  PFFFPF ", " FPPPPP  ", "   PPP   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SavannaMeetingPoint3() {
        }

        public SavannaMeetingPoint3(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 69, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 69, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 3), EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 3), EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodenSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeBarkState = ModObjects.chooseModWoodState(biomeLogState);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(4, 5), this.func_74862_a(3), this.func_74873_b(4, 5));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            for (int[] uw : new int[][]{{0, 9}, {1, 1}, {9, 2}}) {
                this.func_175811_a(world, biomeGrassState, uw[0], 0, uw[1], structureBB);
            }
            this.func_175804_a(world, structureBB, 3, 0, 2, 5, 0, 4, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 3, 0, 6, 5, 0, 8, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 3, 1, 2, 3, 1, 4, biomeBarkState, biomeBarkState, false);
            this.func_175804_a(world, structureBB, 5, 1, 2, 5, 1, 4, biomeBarkState, biomeBarkState, false);
            this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(biomeLogState, this.func_186165_e().func_176736_b(), true), 4, 1, 2, structureBB);
            this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(biomeLogState, this.func_186165_e().func_176736_b(), true), 4, 1, 4, structureBB);
            this.func_175811_a(world, biomeBarkState, 4, 0, 3, structureBB);
            this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), 4, 1, 3, structureBB);
            this.func_175804_a(world, structureBB, 3, 1, 6, 3, 1, 8, biomeBarkState, biomeBarkState, false);
            this.func_175804_a(world, structureBB, 5, 1, 6, 5, 1, 8, biomeBarkState, biomeBarkState, false);
            this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(biomeLogState, this.func_186165_e().func_176736_b(), true), 4, 1, 6, structureBB);
            this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(biomeLogState, this.func_186165_e().func_176736_b(), true), 4, 1, 8, structureBB);
            this.func_175811_a(world, StructureVillageVN.getHorizontalPillarState(biomeLogState, this.func_186165_e().func_176736_b(), true), 4, 0, 7, structureBB);
            this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), 4, 1, 7, structureBB);
            this.func_175804_a(world, structureBB, 3, 2, 4, 5, 3, 6, biomeFenceState, biomeFenceState, false);
            this.func_74878_a(world, structureBB, 4, 2, 4, 4, 3, 6);
            this.func_74878_a(world, structureBB, 3, 2, 5, 5, 3, 5);
            this.func_175804_a(world, structureBB, 3, 4, 4, 5, 4, 6, biomeWoodenSlabState, biomeWoodenSlabState, false);
            this.func_175811_a(world, biomePlankState, 4, 4, 5, structureBB);
            for (int[] uvwo : new int[][]{{3, 2, 2, -1}, {5, 2, 2, -1}, {3, 2, 8, -1}, {5, 2, 8, -1}, {4, 5, 5, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 4, 3, 5, structureBB);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signXBB = 3;
                int signYBB = 3;
                int signZBB = 5;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(3, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                int signXBB2 = 5;
                int signX2 = this.func_74865_a(signXBB2, signZBB);
                int signZ2 = this.func_74873_b(signXBB2, signZBB);
                TileEntitySign signContents2 = new TileEntitySign();
                for (int i = 0; i < 4; ++i) {
                    signContents2.field_145915_a[i] = signContents.field_145915_a[i];
                }
                world.func_180501_a(new BlockPos(signX2, signY, signZ2), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(1, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX2, signY, signZ2), (TileEntity)signContents2);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 7;
                int bannerZBB = 7;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175804_a(world, structureBB, bannerXBB, bannerYBB - 2, bannerZBB, bannerXBB, bannerYBB - 1, bannerZBB, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, true);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{6, 1, 5, -1, 0}, {7, 1, 3, -1, 0}, {9, 1, 6, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class SavannaMeetingPoint2
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"   FPPPF   ", " FFFPPPFFF ", " FFPPPPPFF ", "FFPPFFFPPFF", "PPPFFFFFPPP", "PPPFFFFFPPP", "PPPFFFFFPPP", "FFPPFFFPPF ", " FFPPPPP   ", " FFFPPP  F ", "    PPP    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SavannaMeetingPoint2() {
        }

        public SavannaMeetingPoint2(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 69, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 69, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 4, EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 4, EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(9, 1), this.func_74862_a(2), this.func_74873_b(9, 1));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            for (int[] grass_uw : new int[][]{{0, 3}, {0, 7}, {1, 2}, {1, 3}, {1, 7}, {1, 8}, {2, 1}, {2, 2}, {2, 8}, {2, 9}, {3, 1}, {3, 9}, {3, 10}, {4, 4}, {4, 5}, {4, 6}, {5, 4}, {5, 6}, {6, 4}, {6, 5}, {6, 6}, {7, 9}, {7, 10}, {8, 8}, {8, 9}, {9, 3}, {9, 7}, {9, 8}, {10, 7}}) {
                this.func_175811_a(world, biomeGrassState, grass_uw[0], 0, grass_uw[1], structureBB);
            }
            for (int[] uw : new int[][]{{1, 1}, {1, 9}, {3, 4}, {3, 5}, {3, 6}, {4, 3}, {4, 7}, {5, 3}, {5, 5}, {5, 7}, {6, 3}, {6, 7}, {7, 4}, {7, 5}, {7, 6}, {9, 1}, {9, 9}}) {
                this.func_175811_a(world, biomeDirtState, uw[0], 0, uw[1], structureBB);
            }
            for (int[] grass_uw : new int[][]{{7, 10}, {8, 8}, {8, 9}, {9, 7}, {10, 7}}) {
                this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(0), grass_uw[0], 1, grass_uw[1], structureBB);
            }
            this.func_175804_a(world, structureBB, 3, 1, 4, 7, 1, 6, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 1), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 1), false);
            this.func_175804_a(world, structureBB, 4, 1, 3, 6, 1, 7, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 1), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 1), false);
            this.func_175804_a(world, structureBB, 4, 1, 4, 6, 1, 6, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 5, 1, 5, 5, 5, 5, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), false);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 1, 1, 1, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 9, 1, 1, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 9, 1, 9, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 1, 1, 9, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 5, 1, 3, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 5, 1, 7, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 3, 1, 5, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 7, 1, 5, structureBB);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 1), 5, 4, 5, structureBB);
            for (int[] uvwo : new int[][]{{1, 2, 1, -1}, {9, 2, 9, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signXBB = 9;
                int signYBB = 2;
                int signZBB = 1;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(12, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                int signXBB2 = 1;
                int signZBB2 = 9;
                int signX2 = this.func_74865_a(signXBB2, signZBB2);
                int signZ2 = this.func_74873_b(signXBB2, signZBB2);
                TileEntitySign signContents2 = new TileEntitySign();
                for (int i = 0; i < 4; ++i) {
                    signContents2.field_145915_a[i] = signContents.field_145915_a[i];
                }
                world.func_180501_a(new BlockPos(signX2, signY, signZ2), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX2, signY, signZ2), (TileEntity)signContents2);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{3, 1, 8, -1, 0}, {6, 1, 9, -1, 0}, {9, 1, 6, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            for (int[] uvwoc : new int[][]{{5, 4, 6, 0, 12}, {6, 4, 5, 1, 12}, {5, 4, 4, 2, 12}, {4, 4, 5, 3, 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                if (GeneralConfig.useVillageColors) {
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                    tilebanner.func_175112_a(villageBanner, true);
                } else {
                    modifystanding.func_74768_a("Base", 15 - (GeneralConfig.useVillageColors ? uvwoc[4] : 12));
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            return true;
        }
    }

    public static class SavannaMeetingPoint1
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"FFFFPPFPPFFPPF", "FFFPPPPFPFPPFP", "FFPFPFPPPFFFFF", "FFFPPPFFPFPPFP", "FFPFPPPPPPPPPF", "FFFPPPFFFPFPPP", "FFFPPFPFPPPFPP", "FFFFFPPFPPPPPP", "FPFPPPFPFFPPFP", "FPPPPPPFPFFFPP", "FPFPFPFPFFFFFF", "FFFPFPFPFPPPPP"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        public static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public SavannaMeetingPoint1() {
        }

        public SavannaMeetingPoint1(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 68, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 68, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            if (this.func_186165_e().func_176736_b() % 2 != 1) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 0 ? 5 : (this.func_186165_e().func_176736_b() == 2 ? 4 : 0)), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 1 || this.func_186165_e().func_176736_b() == 2 ? 5 : 4), EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 1 || this.func_186165_e().func_176736_b() == 2 ? 5 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            if (this.func_186165_e().func_176736_b() % 2 != 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 1 ? 4 : 5), EnumFacing.WEST, this.func_74877_c());
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)13, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodenSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodenStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(6, 7), this.func_74862_a(1), this.func_74873_b(6, 7));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{2, 1, 10}, {8, 1, 0}, {13, 1, 11}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = uvw[1];
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] grass_uw : new int[][]{{2, 0}, {2, 1}, {3, 9}, {4, 0}, {4, 1}, {4, 4}, {5, 5}, {6, 6}, {6, 8}, {7, 0}, {7, 8}, {7, 10}, {8, 1}, {8, 3}, {8, 6}, {9, 2}, {9, 9}, {9, 11}, {10, 11}, {11, 1}, {11, 5}, {12, 9}, {13, 1}, {13, 7}, {13, 9}}) {
                this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), grass_uw[0], 1, grass_uw[1], structureBB);
            }
            this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), 0, 1, 5, structureBB);
            this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(8), 0, 2, 5, structureBB);
            this.func_175804_a(world, structureBB, 1, 1, 4, 1, 3, 4, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 3, 1, 4, 3, 3, 4, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 3, 1, 7, 3, 3, 7, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 1, 1, 7, 1, 3, 7, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 1, 4, 4, 3, 4, 7, biomeWoodenSlabState, biomeWoodenSlabState, false);
            this.func_175804_a(world, structureBB, 1, 4, 5, 3, 4, 5, biomeWoodenStairsState.func_177230_c().func_176203_a(3), biomeWoodenStairsState.func_177230_c().func_176203_a((new int[]{2, 1, 3, 0})[this.func_186165_e().func_176736_b()]), false);
            this.func_175804_a(world, structureBB, 1, 4, 6, 3, 4, 6, biomeWoodenStairsState.func_177230_c().func_176203_a(2), biomeWoodenStairsState.func_177230_c().func_176203_a((new int[]{3, 0, 2, 1})[this.func_186165_e().func_176736_b()]), false);
            this.func_175804_a(world, structureBB, 2, 1, 5, 2, 1, 6, biomeLogState, biomeLogState, false);
            this.func_175804_a(world, structureBB, 9, 1, 1, 9, 3, 1, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 9, 1, 3, 9, 3, 3, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 12, 1, 3, 12, 3, 3, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 12, 1, 1, 12, 3, 1, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 9, 4, 1, 12, 4, 3, biomeWoodenSlabState, biomeWoodenSlabState, false);
            this.func_175804_a(world, structureBB, 10, 4, 1, 10, 4, 3, biomeWoodenStairsState.func_177230_c().func_176203_a(0), biomeWoodenStairsState.func_177230_c().func_176203_a(this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2), false);
            this.func_175804_a(world, structureBB, 11, 4, 1, 11, 4, 3, biomeWoodenStairsState.func_177230_c().func_176203_a(1), biomeWoodenStairsState.func_177230_c().func_176203_a(this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 3), false);
            this.func_175804_a(world, structureBB, 10, 1, 2, 11, 1, 2, biomeLogState, biomeLogState, false);
            this.func_175804_a(world, structureBB, 9, 1, 8, 9, 3, 8, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 9, 1, 10, 9, 3, 10, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 12, 1, 10, 12, 3, 10, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 12, 1, 8, 12, 3, 8, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 9, 4, 8, 12, 4, 10, biomeWoodenSlabState, biomeWoodenSlabState, false);
            this.func_175804_a(world, structureBB, 10, 4, 8, 10, 4, 10, biomeWoodenStairsState.func_177230_c().func_176203_a(0), biomeWoodenStairsState.func_177230_c().func_176203_a(this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2), false);
            this.func_175804_a(world, structureBB, 11, 4, 8, 11, 4, 10, biomeWoodenStairsState.func_177230_c().func_176203_a(1), biomeWoodenStairsState.func_177230_c().func_176203_a(this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 3), false);
            this.func_175804_a(world, structureBB, 10, 1, 9, 11, 1, 9, biomeLogState, biomeLogState, false);
            for (int[] uvwoc : new int[][]{{0, 4, 6, 3, GeneralConfig.useVillageColors ? this.townColor3 : 12}, {0, 4, 5, 3, GeneralConfig.useVillageColors ? this.townColor6 : 12}, {10, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor2 : 12}, {11, 4, 0, 2, GeneralConfig.useVillageColors ? this.townColor7 : 12}, {11, 4, 11, 0, GeneralConfig.useVillageColors ? this.townColor4 : 12}, {10, 4, 11, 0, GeneralConfig.useVillageColors ? this.townColor5 : 12}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signXBB = 7;
                int signYBB = 1;
                int signZBB = 6;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 11;
                int bannerZBB = 6;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175811_a(world, biomeGrassState, bannerXBB, bannerYBB - 1, bannerZBB, structureBB);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 2, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, true);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{3, 1, 2, -1, 0}, {5, 1, 4, -1, 0}, {8, 1, 4, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }
}

