/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.biomestructures;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.chestloot.ChestGenHooks;
import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class JungleStructures {
    public static ArrayList<BlueprintData> getRandomJungleDecorBlueprint(FunctionsVN.VillageType villageType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        int decorCount = 8;
        return JungleStructures.getJungleDecorBlueprint(random.nextInt(decorCount), villageType, materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static ArrayList<BlueprintData> getJungleDecorBlueprint(int decorType, FunctionsVN.VillageType villageType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        ArrayList<BlueprintData> blueprint;
        block40: {
            IBlockState biomeGrassState;
            blueprint = new ArrayList<BlueprintData>();
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), materialType, biome, disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), materialType, biome, disallowModSubs);
            if (biome != null && biome.field_76752_A != null) {
                biomeTopState = biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (biome != null && biome.field_76753_B != null) {
                biomeFillerState = biome.field_76753_B;
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), materialType, biome, disallowModSubs);
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), materialType, biome, disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), materialType, biome, disallowModSubs);
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), materialType, biome, disallowModSubs);
            boolean genericBoolean = false;
            int genericInt = 0;
            block0 : switch (decorType) {
                case 0: {
                    IBlockState hayBlockstate = Blocks.field_150407_cf.func_176203_a(0);
                    BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, hayBlockstate);
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    switch (random.nextInt(4)) {
                        case 0: {
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), false));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), false));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, 1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, 1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), false));
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            break;
                        }
                        case 1: {
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), true));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), true));
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, 1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, -1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), true));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            break;
                        }
                        case 2: {
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), false));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), false));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, -1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, -1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), false));
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            break;
                        }
                        case 3: {
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), true));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), true));
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, -1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, 1, hayBlockstate);
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, StructureVillageVN.getHorizontalPillarState(hayBlockstate, coordBaseMode.func_176736_b(), true));
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                        }
                    }
                    break;
                }
                case 1: {
                    IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), coordBaseMode);
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, biomeCobblestoneState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 1, 0, 0, biomeCobblestoneState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, -1, 0, 0, biomeCobblestoneState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 0, 1, biomeCobblestoneState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 0, -1, biomeCobblestoneState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 1, 0, campfireState);
                    break;
                }
                case 2: {
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, biomeCobblestoneState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeChiseledStoneBrickState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 2, 0, biomeFenceState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 3, 0, biomeFenceState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 3, -1, biomeFenceState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 2, -1, biomeHangingLanternState);
                    if (villageType != FunctionsVN.VillageType.JUNGLE && villageType != FunctionsVN.VillageType.SWAMP) break;
                    for (int[] xyzo : new int[][]{{0, 0, -1, StructureVillageVN.chooseVineMeta(2)}, {1, 0, 0, StructureVillageVN.chooseVineMeta(1)}, {-1, 0, 0, StructureVillageVN.chooseVineMeta(3)}}) {
                        BlueprintData.addPlaceBlock(blueprint, xyzo[0], xyzo[1], xyzo[2], Blocks.field_150395_bd.func_176203_a(xyzo[3]));
                    }
                    break;
                }
                case 3: {
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, biomeCobblestoneState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeChiseledStoneBrickState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 2, 0, biomeSittingLanternState);
                    switch (random.nextInt(4)) {
                        case 0: {
                            if (villageType == FunctionsVN.VillageType.JUNGLE || villageType == FunctionsVN.VillageType.SWAMP) {
                                for (int[] xyzo : new int[][]{{0, 0, -1, StructureVillageVN.chooseVineMeta(2)}, {0, 1, -1, StructureVillageVN.chooseVineMeta(2)}, {1, 0, 0, StructureVillageVN.chooseVineMeta(1)}, {0, 0, 1, StructureVillageVN.chooseVineMeta(0)}, {-1, 1, 0, StructureVillageVN.chooseVineMeta(3)}}) {
                                    BlueprintData.addPlaceBlock(blueprint, xyzo[0], xyzo[1], xyzo[2], Blocks.field_150395_bd.func_176203_a(xyzo[3]));
                                }
                                break block0;
                            }
                            break block40;
                        }
                        case 1: {
                            if (villageType == FunctionsVN.VillageType.JUNGLE || villageType == FunctionsVN.VillageType.SWAMP) {
                                for (int[] xyzo : new int[][]{{-1, 0, 0, StructureVillageVN.chooseVineMeta(3)}, {-1, 1, 0, StructureVillageVN.chooseVineMeta(3)}, {0, 0, -1, StructureVillageVN.chooseVineMeta(2)}, {1, 0, 0, StructureVillageVN.chooseVineMeta(1)}, {0, 1, 1, StructureVillageVN.chooseVineMeta(0)}}) {
                                    BlueprintData.addPlaceBlock(blueprint, xyzo[0], xyzo[1], xyzo[2], Blocks.field_150395_bd.func_176203_a(xyzo[3]));
                                }
                                break block0;
                            }
                            break block40;
                        }
                        case 2: {
                            if (villageType == FunctionsVN.VillageType.JUNGLE || villageType == FunctionsVN.VillageType.SWAMP) {
                                for (int[] xyzo : new int[][]{{0, 0, 1, StructureVillageVN.chooseVineMeta(0)}, {0, 1, 1, StructureVillageVN.chooseVineMeta(0)}, {-1, 0, 0, StructureVillageVN.chooseVineMeta(3)}, {0, 0, -1, StructureVillageVN.chooseVineMeta(2)}, {1, 1, 0, StructureVillageVN.chooseVineMeta(1)}}) {
                                    BlueprintData.addPlaceBlock(blueprint, xyzo[0], xyzo[1], xyzo[2], Blocks.field_150395_bd.func_176203_a(xyzo[3]));
                                }
                                break block0;
                            }
                            break block40;
                        }
                        case 3: {
                            if (villageType == FunctionsVN.VillageType.JUNGLE || villageType == FunctionsVN.VillageType.SWAMP) {
                                for (int[] xyzo : new int[][]{{1, 0, 0, StructureVillageVN.chooseVineMeta(1)}, {1, 1, 0, StructureVillageVN.chooseVineMeta(1)}, {0, 0, 1, StructureVillageVN.chooseVineMeta(0)}, {-1, 0, 0, StructureVillageVN.chooseVineMeta(3)}, {0, 1, -1, StructureVillageVN.chooseVineMeta(2)}}) {
                                    BlueprintData.addPlaceBlock(blueprint, xyzo[0], xyzo[1], xyzo[2], Blocks.field_150395_bd.func_176203_a(xyzo[3]));
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 0, 2, 0, biomeCobblestoneState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 3, 0, biomeChiseledStoneBrickState);
                    if (villageType == FunctionsVN.VillageType.JUNGLE || villageType == FunctionsVN.VillageType.SWAMP) {
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, 1, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(0)));
                        BlueprintData.addPlaceBlock(blueprint, 1, 1, 0, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(1)));
                        BlueprintData.addPlaceBlock(blueprint, 0, 1, -1, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(2)));
                        BlueprintData.addPlaceBlock(blueprint, -1, 1, 0, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(3)));
                    }
                    genericInt = random.nextInt(4);
                    IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), materialType, biome, disallowModSubs);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, genericInt % 2 == 0 ? -1 : 0, 3, genericInt % 2 == 0 ? 0 : -1, biomeCobblestoneWallState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, genericInt % 2 == 0 ? 1 : 0, 3, genericInt % 2 == 0 ? 0 : 1, biomeCobblestoneWallState);
                    BlueprintData.addPlaceBlock(blueprint, genericInt % 2 == 0 ? -1 : 0, 2, genericInt % 2 == 0 ? 0 : -1, biomeHangingLanternState);
                    BlueprintData.addPlaceBlock(blueprint, genericInt % 2 == 0 ? 1 : 0, 2, genericInt % 2 == 0 ? 0 : 1, biomeHangingLanternState);
                    if (villageType != FunctionsVN.VillageType.JUNGLE && villageType != FunctionsVN.VillageType.SWAMP) break;
                    BlueprintData.addPlaceBlock(blueprint, genericInt % 2 != 0 ? -1 : 0, 2, genericInt % 2 != 0 ? 0 : -1, Blocks.field_150395_bd.func_176203_a(genericInt % 2 != 0 ? StructureVillageVN.chooseVineMeta(3) : StructureVillageVN.chooseVineMeta(2)));
                    BlueprintData.addPlaceBlock(blueprint, genericInt % 2 != 0 ? 1 : 0, 2, genericInt % 2 != 0 ? 0 : 1, Blocks.field_150395_bd.func_176203_a(genericInt % 2 != 0 ? StructureVillageVN.chooseVineMeta(1) : StructureVillageVN.chooseVineMeta(0)));
                    BlueprintData.addPlaceBlock(blueprint, genericInt == 1 ? -1 : (genericInt == 3 ? 1 : 0), 3, genericInt == 0 ? -1 : (genericInt == 2 ? 1 : 0), Blocks.field_150395_bd.func_176203_a(genericInt == 0 ? StructureVillageVN.chooseVineMeta(2) : (genericInt == 1 ? StructureVillageVN.chooseVineMeta(3) : (genericInt == 2 ? StructureVillageVN.chooseVineMeta(0) : StructureVillageVN.chooseVineMeta(1)))));
                    break;
                }
                case 5: {
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 0, 0, biomeLogVertState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeSittingLanternState);
                    break;
                }
                case 6: {
                    IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, coordBaseMode.func_176736_b(), true);
                    IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, coordBaseMode.func_176736_b(), false);
                    BlueprintData.addFillBelowTo(blueprint, 0, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    switch (random.nextInt(4)) {
                        case 0: {
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 1, 0, 0, biomeLogHorAcrossState);
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, 1, biomeLogVertState);
                            if (villageType != FunctionsVN.VillageType.JUNGLE && villageType != FunctionsVN.VillageType.SWAMP) break;
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(2)));
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(1)));
                            break;
                        }
                        case 1: {
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addFillWithBlocks(blueprint, 0, 0, -1, 0, 0, 0, biomeLogHorAlongState);
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, 1, biomeLogVertState);
                            if (villageType != FunctionsVN.VillageType.JUNGLE && villageType != FunctionsVN.VillageType.SWAMP) break;
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, 1, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(3)));
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(2)));
                            break;
                        }
                        case 2: {
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addFillWithBlocks(blueprint, -1, 0, 0, 0, 0, 0, biomeLogHorAcrossState);
                            BlueprintData.addFillBelowTo(blueprint, 1, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, -1, biomeLogVertState);
                            if (villageType != FunctionsVN.VillageType.JUNGLE && villageType != FunctionsVN.VillageType.SWAMP) break;
                            BlueprintData.addPlaceBlock(blueprint, 1, 0, 0, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(0)));
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(3)));
                            break;
                        }
                        case 3: {
                            BlueprintData.addFillBelowTo(blueprint, 0, -1, 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 0, 0, 1, biomeLogHorAlongState);
                            BlueprintData.addFillBelowTo(blueprint, -1, -1, -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, -1, biomeLogVertState);
                            if (villageType != FunctionsVN.VillageType.JUNGLE && villageType != FunctionsVN.VillageType.SWAMP) break;
                            BlueprintData.addPlaceBlock(blueprint, 0, 0, -1, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(1)));
                            BlueprintData.addPlaceBlock(blueprint, -1, 0, 0, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(0)));
                        }
                    }
                    BlueprintData.addPlaceBlock(blueprint, 0, 1, 0, biomeSittingLanternState);
                    break;
                }
                case 7: {
                    int vertOffset = -1;
                    BlueprintData.addFillBelowTo(blueprint, 0, -1 + vertOffset, 0, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 0 + vertOffset, 0, biomeCobblestoneState);
                    genericBoolean = random.nextBoolean();
                    BlueprintData.addFillBelowTo(blueprint, genericBoolean ? -1 : 0, -1 + vertOffset, genericBoolean ? 0 : -1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addFillBelowTo(blueprint, genericBoolean ? 1 : 0, -1 + vertOffset, genericBoolean ? 0 : 1, FunctionsVN.shouldUseCobblestoneFoundation(biome) ? biomeCobblestoneState : biomeFillerState);
                    BlueprintData.addPlaceBlock(blueprint, genericBoolean ? -1 : 0, 0 + vertOffset, genericBoolean ? 0 : -1, biomeCobblestoneState);
                    BlueprintData.addPlaceBlock(blueprint, genericBoolean ? 1 : 0, 0 + vertOffset, genericBoolean ? 0 : 1, biomeCobblestoneState);
                    BlueprintData.addFillWithBlocks(blueprint, genericBoolean ? -1 : 0, 1 + vertOffset, genericBoolean ? 0 : -1, genericBoolean ? -1 : 0, 3 + vertOffset, genericBoolean ? 0 : -1, biomeFenceState);
                    BlueprintData.addFillWithBlocks(blueprint, genericBoolean ? 1 : 0, 1 + vertOffset, genericBoolean ? 0 : 1, genericBoolean ? 1 : 0, 3 + vertOffset, genericBoolean ? 0 : 1, biomeFenceState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, genericBoolean ? -1 : 0, 3 + vertOffset, genericBoolean ? 0 : -1, biomeFenceState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, genericBoolean ? 1 : 0, 3 + vertOffset, genericBoolean ? 0 : 1, biomeFenceState);
                    BlueprintData.addPlaceBlockAndClearAbove(blueprint, 0, 3 + vertOffset, 0, biomeFenceState);
                    BlueprintData.addPlaceBlock(blueprint, 0, 2 + vertOffset, 0, biomeHangingLanternState);
                }
            }
        }
        return blueprint;
    }

    public static class JungleRoadAccent2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", "       ", "PPPPPPP", "PPPPPPP", "PPPPPPP", "  F    ", " FF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 13;
        private static final int GROUND_LEVEL = 1;
        private static final int W_OFFSET = -5;
        public static final byte MEDIAN_BORDERS = 10;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleRoadAccent2() {
        }

        public JungleRoadAccent2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            this.field_74887_e.func_78886_a(this.func_186165_e() == EnumFacing.WEST ? 5 : (this.func_186165_e() == EnumFacing.EAST ? -5 : 0), 0, this.func_186165_e() == EnumFacing.SOUTH ? -5 : (this.func_186165_e() == EnumFacing.NORTH ? 5 : 0));
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleRoadAccent2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)13, (int)(STRUCTURE_DEPTH + -5), (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)(-4 - STRUCTURE_DEPTH - -5), (int)STRUCTURE_WIDTH, (int)29, (int)-4, (EnumFacing)coordBaseMode);
            return JungleRoadAccent2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new JungleRoadAccent2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)10, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 5, 1, 6, 5}, {1, 6, 0, 1, 6, 0}, {5, 6, 0, 5, 6, 0}, {1, 3, 5, 1, 3, 5}, {5, 3, 0, 5, 3, 0}, {0, 5, 1, 0, 5, 1}, {6, 5, 5, 6, 5, 5}, {5, 5, 6, 5, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{0, 6, 1, -1}, {6, 6, 5, -1}, {5, 6, 6, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            biomeLogVertState = biomeLogVertState.func_177230_c() == Blocks.field_150322_A ? Blocks.field_150364_r.func_176203_a(3) : biomeLogVertState;
            for (int[] uuvvww : new int[][]{{1, 4, 5, 1, 5, 5}, {5, 1, 5, 5, 11, 5}, {1, 1, 1, 1, 8, 1}, {5, 4, 0, 5, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvw : new int[][]{{5, 0, 5}, {1, 0, 1}}) {
                this.func_175808_b(world, biomeLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 2, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 8, -1, 2, 9, 3}, {-1, 8, 0, -1, 9, 2}, {3, 8, 0, 3, 9, 2}, {1, 10, 0, 1, 11, 2}, {0, 10, 1, 0, 11, 1}, {2, 10, 1, 2, 11, 1}, {2, 10, 2, 2, 10, 2}, {4, 9, 3, 6, 10, 7}, {3, 9, 4, 3, 10, 6}, {7, 9, 3, 7, 10, 6}, {5, 11, 4, 5, 12, 6}, {4, 11, 5, 4, 12, 5}, {6, 11, 5, 6, 12, 5}, {6, 11, 4, 6, 11, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 0, 1, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 7, 6, 2}, {4, 7, 6, 2}, {0, 7, 2, 0}, {0, 7, 4, 0}, {6, 7, 1, 1}, {6, 7, 3, 1}, {2, 7, -1, 3}, {4, 7, -1, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 0, 4, 4, 0}, {2, 4, 5, 4, 4, 5}, {1, 4, 2, 1, 4, 4}, {5, 4, 1, 5, 4, 4}, {1, 7, 0, 5, 7, 0}, {1, 7, 5, 4, 7, 5}, {1, 7, 2, 1, 7, 4}, {5, 7, 1, 5, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 0, 4, 5, 0}, {2, 5, 5, 4, 5, 5}, {1, 5, 2, 1, 5, 4}, {5, 5, 1, 5, 5, 4}, {2, 7, 1, 4, 7, 4}, {2, 3, 2, 4, 3, 4}, {3, 3, 1, 4, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{2, 1, 1, 2, 3, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 4, 1, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, false)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 4, 4}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 4;
            int chestV = 4;
            int chestW = 3;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] grass_uw : new int[][]{{2, 0, 1}, {1, 0, 0}, {2, 0, 0}}) {
                this.func_175811_a(world, biomeGrassState, grass_uw[0], grass_uw[1], grass_uw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 0}}) {
                this.func_175811_a(world, (random.nextBoolean() ? Blocks.field_150328_O : Blocks.field_150327_N).func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 1, 1, 3}, {0, 2, 1, 3}, {0, 3, 1, 3}, {0, 4, 1, 3}, {0, 7, 1, 3}, {1, 4, -1, 2}, {1, 5, -1, 2}, {5, 8, 6, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleRoadAccent1
    extends StructureVillageVN.VNComponent {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"PPPPP", "PFFFP", "PFFFP", "PFFFP", "PPPPP"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int W_OFFSET = -4;
        public static final byte MEDIAN_BORDERS = 10;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleRoadAccent1() {
        }

        public JungleRoadAccent1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            this.field_74887_e.func_78886_a(this.func_186165_e() == EnumFacing.WEST ? 4 : (this.func_186165_e() == EnumFacing.EAST ? -4 : 0), 0, this.func_186165_e() == EnumFacing.SOUTH ? -4 : (this.func_186165_e() == EnumFacing.NORTH ? 4 : 0));
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleRoadAccent1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)(STRUCTURE_DEPTH + -4), (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)(-4 - STRUCTURE_DEPTH - -4), (int)STRUCTURE_WIDTH, (int)21, (int)-4, (EnumFacing)coordBaseMode);
            return JungleRoadAccent1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new JungleRoadAccent1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)10, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{-1, 1, 5}, {5, 1, -1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{1, 0, 3, 3, 0, 3}, {1, 0, 2, 1, 0, 2}, {3, 0, 2, 3, 0, 2}, {1, 0, 1, 3, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 1, 1}, {2, 1, 3, 2, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 1, 3}, {3, 1, 1, 3, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 2, 3, 1}, {2, 2, 3, 2, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 3, 3, 0}, {3, 3, 3, 1}, {1, 3, 2, 0}, {3, 3, 2, 1}, {1, 3, 1, 0}, {3, 3, 1, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 1, 2, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 2, 2, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{0, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleStreetDecor
    extends StructureVillageVN.VNComponent {
        public static final int STRUCTURE_WIDTH = 3;
        public static final int STRUCTURE_DEPTH = 3;
        public static final int STRUCTURE_HEIGHT = 4;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleStreetDecor() {
        }

        public JungleStreetDecor(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleStreetDecor buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)4, (int)3, (EnumFacing)coordBaseMode);
            return JungleStreetDecor.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleStreetDecor(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorDepth;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                uvw[2] = decorDepth = ((Integer)FunctionsVN.weightedRandom(new int[]{-2, -1, 0, 1, 2, 3}, new double[]{1.0, 2.0, 3.0, 8.0, 4.0, 2.0}, randomFromXYZ)).intValue();
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (decorDepth < 0) {
                    int nonairSurrounding = 0;
                    int decorY = this.func_74862_a(decorHeightY);
                    for (int i = 0; i < 8; ++i) {
                        int z;
                        int[][] surroundpos = new int[][]{{0, 0}, {0, 1}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {1, 0}};
                        int u = surroundpos[i][0];
                        int w = surroundpos[i][0];
                        int x = this.func_74865_a(u, w);
                        BlockPos pos = new BlockPos(x, decorY, z = this.func_74873_b(u, w));
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || ++nonairSurrounding < 4) continue;
                        ++decorHeightY;
                        break;
                    }
                }
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 2, uvw[2], structureBB);
                this.func_175811_a(world, biomeTopState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && decorDepth >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleWoodAnimalPen
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"     FFF   ", "   FFFFFF  ", "  FFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFF ", "   FFFFF   ", "    FFF    ", "     F     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 3;
        private static final int DECREASE_MAX_U = 3;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleWoodAnimalPen() {
        }

        public JungleWoodAnimalPen(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleWoodAnimalPen buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleWoodAnimalPen.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleWoodAnimalPen(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 3, 0, 1, 3}, {1, 0, 3, 1, 0, 3}, {2, 0, 3, 2, 1, 3}, {3, 0, 2, 3, 1, 2}, {4, 0, 1, 6, 1, 1}, {7, 0, 2, 7, 1, 2}, {8, 0, 3, 8, 0, 3}, {9, 0, 3, 9, 1, 3}, {10, 0, 4, 10, 1, 4}, {10, 0, 5, 10, 0, 5}, {10, 0, 6, 10, 1, 6}, {9, 0, 7, 9, 1, 7}, {9, 0, 8, 9, 0, 8}, {9, 0, 9, 9, 1, 9}, {8, 0, 10, 8, 1, 10}, {7, 0, 11, 7, 1, 11}, {6, 0, 11, 6, 0, 11}, {5, 0, 11, 5, 1, 11}, {4, 0, 10, 4, 1, 10}, {3, 0, 10, 3, 0, 10}, {2, 0, 9, 2, 1, 9}, {1, 0, 8, 1, 1, 8}, {1, 0, 7, 1, 0, 7}, {0, 0, 6, 0, 1, 6}, {0, 0, 4, 0, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 3, 1, 0}, {6, 3, 1, 1}, {5, 0, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 3, 0, 2, 7}, {0, 1, 4, 0, 1, 5}, {1, 1, 3, 1, 1, 3}, {1, 1, 7, 1, 1, 7}, {1, 2, 7, 1, 2, 9}, {2, 2, 9, 2, 2, 10}, {3, 2, 10, 4, 2, 10}, {3, 1, 10, 3, 1, 10}, {4, 2, 11, 8, 2, 11}, {6, 1, 11, 6, 1, 11}, {8, 2, 10, 9, 2, 10}, {9, 2, 7, 9, 2, 9}, {9, 1, 8, 9, 1, 8}, {10, 2, 3, 10, 2, 7}, {10, 1, 5, 10, 1, 5}, {8, 2, 3, 9, 2, 3}, {8, 1, 3, 8, 1, 3}, {7, 2, 2, 8, 2, 2}, {6, 1, 1, 6, 1, 1}, {4, 1, 1, 4, 1, 1}, {3, 2, 1, 4, 2, 1}, {6, 2, 1, 7, 2, 1}, {2, 2, 2, 3, 2, 2}, {1, 2, 3, 2, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 3, 1, 5, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{5, 1, 1}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(2, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 3, 3, -1}, {1, 3, 7, -1}, {4, 3, 10, -1}, {8, 3, 10, -1}, {9, 3, 7, -1}, {8, 3, 3, -1}, {5, 4, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 6, 1, 0, 6}, {2, 0, 6, 2, 0, 8}, {3, 0, 3, 7, 0, 9}, {4, 0, 2, 6, 0, 2}, {5, 0, 10, 7, 0, 10}, {8, 0, 4, 8, 0, 9}, {9, 0, 4, 9, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1] + 1, uuvvww[2], uuvvww[3], uuvvww[4] + 1, uuvvww[5], Blocks.field_150329_H.func_176203_a(1), Blocks.field_150329_H.func_176203_a(1), false);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 4, 2, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            for (int[] uvwg : new int[][]{{6, 1, 10, 1}, {9, 1, 6, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{3, 1, 6}, {7, 1, 4}, {7, 1, 8}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleWildFarm
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"   FFF       ", "  FFFFFF     ", " FFFFFFFFF   ", " FFFFFFFFF   ", " FFFFFFFFFFF ", " FFFFFFFFFFFF", " FFFFFFFFFFFF", " FFFFFFFFFFFF", "FFFFFFFFFFFF ", "FFFFFFFFFFF  ", "FFFFFFFFFFF  ", "      FFF    ", "       FF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 13;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleWildFarm() {
        }

        public JungleWildFarm(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleWildFarm buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleWildFarm.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleWildFarm(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            int uuvvww4;
            int uuvvww322;
            void var14_31;
            void var14_29;
            void var14_27;
            void var14_25;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)13, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww2 : new int[][]{{1, 1, 2, 1, 2, 2}, {1, 1, 3, 1, 2, 3}, {1, 1, 4, 1, 3, 4}, {2, 1, 5, 2, 2, 5}, {2, 1, 6, 2, 1, 6}, {2, 1, 7, 2, 3, 7}, {3, 1, 8, 3, 1, 8}, {2, 1, 9, 2, 2, 9}, {2, 1, 10, 2, 1, 10}, {3, 1, 11, 3, 3, 11}, {4, 1, 11, 4, 1, 11}, {7, 1, 10, 7, 3, 10}, {8, 1, 9, 8, 2, 9}, {9, 1, 9, 9, 2, 9}, {10, 1, 8, 10, 1, 8}, {11, 1, 7, 11, 2, 7}, {11, 1, 6, 11, 1, 6}, {11, 1, 5, 11, 3, 5}, {9, 1, 2, 9, 3, 2}, {8, 1, 1, 8, 2, 1}, {7, 1, 1, 7, 3, 1}, {6, 1, 1, 6, 1, 1}, {5, 1, 2, 5, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww2[0], uuvvww2[1], uuvvww2[2], uuvvww2[3], uuvvww2[4], uuvvww2[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{1, 3, 2, 1, 3, 2}, {1, 3, 3, 1, 3, 3}, {1, 4, 4, 1, 4, 4}, {2, 3, 5, 2, 3, 5}, {2, 2, 6, 2, 2, 6}, {2, 4, 7, 2, 4, 7}, {3, 2, 8, 3, 2, 8}, {2, 3, 9, 2, 3, 9}, {2, 2, 10, 2, 2, 10}, {3, 4, 11, 3, 4, 11}, {4, 2, 11, 4, 2, 11}, {7, 4, 10, 7, 4, 10}, {8, 3, 9, 8, 3, 9}, {10, 2, 8, 10, 2, 8}, {11, 3, 7, 11, 3, 7}, {11, 2, 6, 11, 2, 6}, {11, 4, 5, 11, 4, 5}, {9, 4, 2, 9, 4, 2}, {8, 3, 1, 8, 3, 1}, {7, 4, 1, 7, 4, 1}, {6, 2, 1, 6, 2, 1}, {5, 3, 2, 5, 3, 2}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] nArray : new int[][]{{8, 1, 8, 8, 1, 8}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] nArray : new int[][]{{6, 0, 2, 8, 0, 4}, {7, 0, 5, 7, 0, 5}, {8, 0, 8, 9, 0, 8}, {10, 0, 7, 10, 0, 7}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeDirtState, biomeDirtState, false);
            }
            IBlockState biomeCoarseDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            int[][] nArrayArray = new int[][]{{6, 1, 2, 6, 1, 4}, {8, 1, 3, 8, 1, 4}, {9, 1, 3, 9, 1, 3}};
            int uuvvww2 = nArrayArray.length;
            boolean bl = false;
            while (var14_25 < uuvvww2) {
                int[] uuvvww3 = nArrayArray[var14_25];
                this.func_175804_a(world, structureBB, uuvvww3[0], uuvvww3[1], uuvvww3[2], uuvvww3[3], uuvvww3[4], uuvvww3[5], biomeCoarseDirtState, biomeCoarseDirtState, false);
                ++var14_25;
            }
            nArrayArray = new int[][]{{2, 1, 2}, {2, 1, 3}, {7, 1, 9}};
            uuvvww2 = nArrayArray.length;
            boolean bl2 = false;
            while (var14_27 < uuvvww2) {
                int[] uvw = nArrayArray[var14_27];
                this.func_175811_a(world, Blocks.field_150440_ba.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
                ++var14_27;
            }
            nArrayArray = new int[][]{{3, 0, 2, 7, 3, 7}, {3, 0, 3, 7, 3, 7}, {4, 0, 3, 7, 0, 4}, {4, 0, 4, 7, 0, 0}, {4, 0, 5, 7, 0, 7}, {5, 0, 4, 7, 0, 7}, {7, 0, 8, 7, 3, 7}, {7, 0, 7, 7, 0, 0}, {8, 0, 7, 7, 0, 5}, {9, 1, 8, 7, 1, 0}, {10, 1, 7, 7, 1, 0}, {10, 0, 2, 7, 2, 4}, {10, 0, 3, 7, 2, 7}, {11, 0, 4, 7, 2, 0}};
            uuvvww2 = nArrayArray.length;
            boolean bl3 = false;
            while (var14_29 < uuvvww2) {
                int[] uvwfcp = nArrayArray[var14_29];
                this.func_175808_b(world, biomeFillerState, uvwfcp[0], uvwfcp[1] - 1, uvwfcp[2], structureBB);
                this.func_175811_a(world, (uvwfcp[4] == 0 ? Blocks.field_150464_aj : (uvwfcp[4] == 1 ? Blocks.field_150469_bN : (uvwfcp[4] == 2 ? Blocks.field_150459_bM : Blocks.field_150394_bc))).func_176203_a(uvwfcp[5]), uvwfcp[0], uvwfcp[1] + 1, uvwfcp[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwfcp[3]), uvwfcp[0], uvwfcp[1], uvwfcp[2], structureBB);
                ++var14_29;
            }
            nArrayArray = new int[][]{{3, 0, 8, 3, 0, 8}, {4, 0, 11, 4, 0, 11}, {8, 1, 2, 8, 1, 2}, {6, 0, 5, 8, 0, 6}};
            uuvvww2 = nArrayArray.length;
            boolean bl4 = false;
            while (var14_31 < uuvvww2) {
                int[] uuvvww322 = nArrayArray[var14_31];
                this.func_175804_a(world, structureBB, uuvvww322[0], uuvvww322[1], uuvvww322[2], uuvvww322[3], uuvvww322[4], uuvvww322[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
                ++var14_31;
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                for (int[] uvw : new int[][]{{6, 1, 6}}) {
                    this.func_175811_a(world, compostBinState, uvw[0], uvw[1], uvw[2], structureBB);
                    this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                }
            }
            for (int[] uuvvww4 : new int[][]{{3, 1, 7, 3, 1, 7}, {3, 1, 9, 3, 3, 9}, {4, 1, 10, 4, 1, 10}, {5, 1, 11, 5, 2, 11}, {5, 1, 5, 5, 1, 5}, {6, 2, 2, 6, 3, 2}, {6, 2, 3, 6, 2, 3}, {8, 2, 3, 8, 3, 3}, {8, 2, 4, 8, 2, 4}, {9, 1, 5, 9, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww4[0], uuvvww4[1], uuvvww4[2], uuvvww4[3], uuvvww4[4], uuvvww4[5], Blocks.field_150436_aH.func_176223_P(), Blocks.field_150436_aH.func_176223_P(), false);
            }
            IBlockState bambooStalkState = ModObjects.chooseModBambooStalk(0);
            if (bambooStalkState != null) {
                IBlockState iBlockState;
                int[][] nArrayArray2 = new int[][]{{3, 1, 10, 3, 5, 10, 3}, {3, 6, 10, 3, 6, 10, 4}, {3, 7, 10, 3, 8, 10, 5}, {4, 1, 8, 4, 1, 8, 3}, {4, 2, 8, 4, 3, 8, 4}, {4, 4, 8, 4, 4, 8, 5}, {5, 1, 9, 5, 1, 9, 0}, {5, 2, 9, 5, 2, 9, 1}};
                uuvvww322 = nArrayArray2.length;
                for (uuvvww4 = 0; uuvvww4 < uuvvww322; ++uuvvww4) {
                    int[] uvwuvws = nArrayArray2[uuvvww4];
                    bambooStalkState = ModObjects.chooseModBambooStalk(uvwuvws[6]);
                    this.func_175804_a(world, structureBB, uvwuvws[0], uvwuvws[1], uvwuvws[2], uvwuvws[3], uvwuvws[4], uvwuvws[5], bambooStalkState, bambooStalkState, false);
                }
                if ((Block.func_149684_b((String)"futuremc:bamboo") == null || bambooStalkState.func_177230_c() != Block.func_149684_b((String)"futuremc:bamboo")) && (iBlockState = ModObjects.chooseModBambooLeaves()) != null) {
                    int[][] uuvvww322 = new int[][]{{3, 9, 10}, {4, 5, 8}};
                    uuvvww4 = uuvvww322.length;
                    for (int uvwuvws = 0; uvwuvws < uuvvww4; ++uvwuvws) {
                        int[] uuvvww4 = uuvvww322[uvwuvws];
                        this.func_175811_a(world, iBlockState, uuvvww4[0], uuvvww4[1], uuvvww4[2], structureBB);
                    }
                }
            } else {
                bambooStalkState = Blocks.field_150436_aH.func_176223_P();
                for (int[] uvw : new int[][]{{3, 0, 11}}) {
                    this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
                }
                int[][] nArrayArray3 = new int[][]{{3, 1, 10, 3, 4, 10}, {4, 1, 8, 4, 2, 8}};
                uuvvww322 = nArrayArray3.length;
                for (uuvvww4 = 0; uuvvww4 < uuvvww322; ++uuvvww4) {
                    int[] uuvvww5 = nArrayArray3[uuvvww4];
                    this.func_175804_a(world, structureBB, uuvvww5[0], uuvvww5[1], uuvvww5[2], uuvvww5[3], uuvvww5[4], uuvvww5[5], bambooStalkState, bambooStalkState, false);
                }
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 1, 2, 3}, {0, 2, 2, 3}, {0, 1, 4, 3}, {0, 2, 4, 3}, {0, 3, 4, 3}, {1, 1, 5, 3}, {1, 1, 7, 3}, {1, 2, 7, 3}, {1, 3, 7, 3}, {1, 1, 9, 3}, {1, 2, 9, 3}, {2, 2, 11, 3}, {2, 3, 11, 3}, {6, 1, 10, 3}, {6, 2, 10, 3}, {6, 3, 10, 3}, {7, 1, 0, 2}, {7, 2, 0, 2}, {7, 3, 0, 2}, {8, 1, 0, 2}, {8, 2, 0, 2}, {9, 1, 1, 2}, {9, 2, 1, 2}, {11, 2, 4, 2}, {11, 3, 4, 2}, {3, 1, 12, 0}, {3, 2, 12, 0}, {7, 1, 11, 0}, {7, 2, 11, 0}, {8, 2, 10, 0}, {9, 1, 10, 0}, {9, 2, 10, 0}, {10, 2, 2, 1}, {10, 3, 2, 1}, {11, 1, 5, 1}, {11, 2, 5, 1}, {11, 1, 7, 1}, {11, 2, 7, 1}, {10, 1, 8, 1}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int n = random.nextInt(11);
                int u = n < 3 ? 3 : (n < 5 ? 4 : (n < 8 ? 5 : 6));
                int v = 1;
                int w = n < 3 ? n + 4 : (n < 5 ? n + 3 : (n < 8 ? n + 1 : n - 1));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleWeaponSmithy
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFFFFF", " FFFFFFF", " FFFPFFF", "FFPFFFFF", "FFFFPFFF", "FPPPFPFF", "FFFPFPFF", "FFPFFFFF", "FFFFFFFF", " FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleWeaponSmithy() {
        }

        public JungleWeaponSmithy(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleWeaponSmithy buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleWeaponSmithy.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleWeaponSmithy(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 9, 1, 2, 9}, {5, 1, 9, 5, 2, 9}, {1, 1, 5, 1, 2, 5}, {5, 1, 5, 5, 2, 5}, {1, 1, 1, 1, 2, 1}, {5, 1, 1, 5, 2, 1}, {1, 5, 9, 1, 6, 9}, {5, 5, 9, 5, 6, 9}, {1, 5, 5, 1, 6, 5}, {5, 5, 5, 5, 6, 5}, {2, 4, 1, 4, 4, 1}, {1, 4, 2, 5, 4, 7}, {1, 4, 8, 1, 4, 8}, {3, 4, 8, 5, 4, 8}, {1, 4, 9, 5, 4, 9}, {2, 8, 5, 4, 8, 5}, {1, 8, 6, 1, 8, 8}, {2, 8, 9, 4, 8, 9}, {5, 8, 6, 5, 8, 8}, {3, 9, 7, 3, 9, 7}, {6, 0, 6, 6, 0, 8}, {6, 1, 7, 6, 1, 7}, {7, 1, 5, 7, 1, 5}, {7, 1, 9, 7, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{6, 1, 5, 3}, {5, 1, 6, 0}, {5, 1, 7, 0}, {5, 1, 8, 0}, {7, 1, 6, 1}, {7, 1, 7, 1}, {7, 1, 8, 1}, {6, 1, 9, 2}, {2, 9, 8, 2}, {3, 9, 8, 2}, {4, 9, 8, 2}, {2, 9, 7, 0}, {4, 9, 7, 1}, {2, 9, 6, 3}, {3, 9, 6, 3}, {4, 9, 6, 3}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150348_b.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 5, 4, 5, 5}, {2, 6, 5, 2, 6, 5}, {4, 6, 5, 4, 6, 5}, {2, 7, 5, 4, 7, 5}, {1, 5, 6, 1, 5, 8}, {1, 6, 6, 1, 6, 6}, {1, 6, 8, 1, 6, 8}, {1, 7, 6, 1, 7, 8}, {2, 5, 9, 4, 5, 9}, {2, 6, 9, 2, 6, 9}, {4, 6, 9, 4, 6, 9}, {2, 7, 9, 4, 7, 9}, {5, 5, 6, 5, 5, 8}, {5, 6, 6, 5, 6, 6}, {5, 6, 8, 5, 6, 8}, {5, 7, 6, 5, 7, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneState, biomeStoneState, false);
            }
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 3, 9}, {5, 3, 9}, {1, 3, 5}, {5, 3, 5}, {1, 3, 1}, {5, 3, 1}, {1, 7, 9}, {5, 7, 9}, {1, 7, 5}, {5, 7, 5}}) {
                this.func_175811_a(world, biomeChiseledStoneBrickState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 6, 1, 3, 8}, {2, 1, 9, 4, 3, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{3, 0, 8}}) {
                this.func_175811_a(world, biomeCobblestoneState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{7, 1, 1, 6}, {7, 1, 4, 7}, {4, 5, 8, 5}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 1, 1, 6, 1, 1}, {7, 1, 2, 7, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvwoh : new int[][]{{3, 1, 8, 2, 0}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwoh[3], this.func_186165_e(), uvwoh[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwoh[0], uvwoh[1], uvwoh[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{0, 1, 2, 1}, {0, 1, 3, 1}, {0, 1, 4, 1}, {0, 2, 3, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvw : new int[][]{{6, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 1, 8}}) {
                this.func_175811_a(world, Blocks.field_150353_l.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{2, 1, 8, 2, 4, 8, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            for (int[] uvwm : new int[][]{{3, 5, 6, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {4, 5, 6, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeStoneBrickWallStone = ModObjects.chooseModStoneBrickWallState();
            biomeStoneBrickWallStone = StructureVillageVN.getBiomeSpecificBlockState(biomeStoneBrickWallStone != null ? biomeStoneBrickWallStone : Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 3, 0, 1, 3, 0}, {5, 3, 0, 5, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickWallStone, biomeStoneBrickWallStone, false);
            }
            IBlockState biomePolishedAndesiteSlabBottomState = ModObjects.chooseModPolishedAndesiteSlabState(false);
            if (biomePolishedAndesiteSlabBottomState == null && (biomePolishedAndesiteSlabBottomState = ModObjects.chooseModAndesiteBrickSlabState(false)) == null) {
                biomePolishedAndesiteSlabBottomState = Blocks.field_150333_U.func_176203_a(0);
            }
            biomePolishedAndesiteSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(biomePolishedAndesiteSlabBottomState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{7, 2, 5}, {7, 2, 9}}) {
                this.func_175811_a(world, biomePolishedAndesiteSlabBottomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCoarseDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 0, 8}, {4, 0, 8}, {2, 0, 7}, {3, 0, 7}, {3, 0, 6}, {4, 0, 6}, {2, 0, 5}, {3, 0, 5}, {4, 0, 4}, {2, 0, 3}, {4, 0, 2}, {3, 0, 1}}) {
                this.func_175811_a(world, biomeCoarseDirtState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 6, 7}, {3, 6, 5}, {5, 6, 7}, {3, 6, 9}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{1, 2, 0}, {5, 2, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{4, 6, 8}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(3);
                int u = 2 + random.nextInt(3);
                int v = 1;
                int w = 1 + random.nextInt(7);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class JungleToolSmithy2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"    FFFF    ", "    FFFF    ", "    FFFF    ", "   FFFFFF   ", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF ", "FFFFFFFFFFFF", "   FFFFFF   ", "    FFFF    ", "    FFFF    ", "    FFFF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 3;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleToolSmithy2() {
        }

        public JungleToolSmithy2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleToolSmithy2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleToolSmithy2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleToolSmithy2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 3, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 3);
            this.establishFoundation(world, structureBB, foundationPattern, 3, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 3, 9, 6, 3, 9}, {2, 3, 5, 2, 3, 6}, {9, 3, 5, 9, 3, 6}, {5, 3, 2, 6, 3, 2}, {3, 0, 3, 4, 0, 8}, {5, 0, 3, 6, 0, 4}, {5, 0, 7, 6, 0, 8}, {7, 0, 3, 8, 0, 8}, {3, 1, 3, 3, 4, 8}, {4, 1, 3, 7, 4, 3}, {4, 1, 8, 7, 4, 8}, {8, 1, 3, 8, 4, 8}, {3, 5, 4, 3, 7, 4}, {3, 7, 5, 3, 7, 6}, {3, 5, 7, 3, 7, 7}, {8, 5, 4, 8, 7, 4}, {8, 7, 5, 8, 7, 6}, {8, 5, 7, 8, 7, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 4, 7, 3, 7}}) {
                this.func_74878_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5]);
            }
            for (int[] uvwo : new int[][]{{4, 6, 7, 1}, {6, 3, 7, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 5, 8, 4, 7, 8}, {5, 7, 8, 6, 7, 8}, {7, 5, 8, 7, 7, 8}, {4, 5, 3, 4, 7, 3}, {5, 7, 3, 6, 7, 3}, {7, 5, 3, 7, 7, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 4, 5, 7, 4, 7}, {5, 4, 5, 6, 4, 6}, {4, 4, 4, 6, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{7, 4, 4, 7, 4, 4}, {7, 8, 4, 7, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 9, 4, 7, 9, 4}, {7, 5, 4, 7, 7, 4}, {7, 2, 4, 7, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeStoneBrickWallStone = ModObjects.chooseModStoneBrickWallState();
            biomeStoneBrickWallStone = StructureVillageVN.getBiomeSpecificBlockState(biomeStoneBrickWallStone != null ? biomeStoneBrickWallStone : Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 5, 8, 3, 5, 8}, {8, 5, 8, 8, 5, 8}, {3, 5, 3, 3, 5, 3}, {8, 5, 3, 8, 5, 3}, {5, 8, 8, 6, 8, 8}, {3, 8, 5, 3, 8, 6}, {8, 8, 5, 8, 8, 6}, {5, 8, 3, 6, 8, 3}, {3, 6, 5, 3, 6, 5}, {3, 5, 6, 3, 5, 6}, {6, 5, 8, 6, 5, 8}, {5, 6, 8, 5, 6, 8}, {8, 6, 6, 8, 6, 6}, {8, 5, 5, 8, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickWallStone, biomeStoneBrickWallStone, false);
            }
            for (int[] uuvvww : new int[][]{{3, 5, 5, 3, 5, 5}, {3, 6, 6, 3, 6, 6}, {6, 6, 8, 6, 6, 8}, {5, 5, 8, 5, 5, 8}, {8, 5, 6, 8, 5, 6}, {8, 6, 5, 8, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{5, 3, 1, 3}, {6, 3, 1, 3}, {5, 4, 2, 3}, {6, 4, 2, 3}, {1, 3, 5, 0}, {1, 3, 6, 0}, {2, 4, 5, 0}, {2, 4, 6, 0}, {10, 3, 5, 1}, {10, 3, 6, 1}, {9, 4, 5, 1}, {9, 4, 6, 1}, {5, 3, 10, 2}, {6, 3, 10, 2}, {5, 4, 9, 2}, {6, 4, 9, 2}, {4, 8, 8, 2}, {7, 8, 8, 2}, {3, 8, 4, 0}, {3, 8, 7, 0}, {4, 8, 3, 3}, {7, 8, 3, 3}, {8, 8, 4, 1}, {8, 8, 7, 1}, {6, 4, 7, 0}, {5, 3, 7, 0}, {4, 2, 6, 3}, {4, 1, 5, 3}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(13), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 8, 4, 6, 8, 4}, {4, 8, 5, 4, 8, 7}, {5, 8, 7, 7, 8, 7}, {7, 8, 5, 7, 8, 6}, {4, 2, 7, 4, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickSlabUpperState, biomeStoneBrickSlabUpperState, false);
            }
            IBlockState biomeStoneBrickSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(5), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 9, 5, 6, 9, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickSlabLowerState, biomeStoneBrickSlabLowerState, false);
            }
            for (int[] uvwo : new int[][]{{7, 1, 7, 2}}) {
                this.func_175811_a(world, ModObjects.chooseModSmithingTable(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 5, 3, 0, 1, 0}, {6, 5, 3, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{7, 1, 4, 0}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvwoc : new int[][]{{5, 0, 5, 2, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {6, 0, 5, 1, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {6, 0, 6, 0, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {5, 0, 6, 3, GeneralConfig.useVillageColors ? this.townColor4 : 9}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(11);
                int u = s <= 0 ? 4 : (s <= 4 ? 5 : (s <= 8 ? 6 : 7));
                int v = 1;
                int w = s <= 0 ? 4 : (s <= 4 ? s + 3 : (s <= 8 ? s - 1 : s - 4));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class JungleToolSmithy1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", "FFFFFF ", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFPPFF", "FFFPPFF", "FFFPPFF", "FFFPPFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleToolSmithy1() {
        }

        public JungleToolSmithy1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleToolSmithy1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleToolSmithy1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleToolSmithy1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 0, 1, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 7, 0, 2, 7}, {5, 1, 7, 5, 2, 7}, {0, 1, 4, 0, 4, 4}, {5, 1, 4, 5, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 3, 4, 4}, {4, 3, 4, 4, 4, 4}, {5, 1, 5, 5, 3, 5}, {5, 1, 6, 5, 2, 6}, {0, 1, 5, 0, 3, 5}, {0, 1, 6, 0, 2, 6}, {1, 1, 7, 4, 2, 7}, {0, 3, 7, 5, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 4, 5, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 3, 2}, {2, 3, 5, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 2, 1}, {5, 1, 1, 5, 2, 1}, {0, 3, 2, 0, 3, 3}, {0, 4, 3, 0, 4, 3}, {5, 3, 2, 5, 3, 3}, {5, 4, 3, 5, 4, 3}, {0, 2, 8, 0, 2, 8}, {5, 2, 8, 5, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 3, 1, 3}, {1, 3, 1, 3}, {2, 3, 1, 3}, {3, 3, 1, 3}, {4, 3, 1, 3}, {5, 3, 1, 3}, {0, 4, 2, 3}, {1, 4, 2, 3}, {2, 4, 2, 3}, {3, 4, 2, 3}, {4, 4, 2, 3}, {5, 4, 2, 3}, {0, 5, 3, 3}, {1, 5, 3, 3}, {2, 5, 3, 3}, {3, 5, 3, 3}, {4, 5, 3, 3}, {5, 5, 3, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 5, 4, 5, 5, 4}, {0, 4, 6, 5, 4, 6}, {0, 3, 6, 0, 3, 6}, {5, 3, 6, 5, 3, 6}, {0, 3, 8, 5, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 5, 5, 4, 5}, {1, 1, 5, 1, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvwo : new int[][]{{2, 1, 5, 1}}) {
                this.func_175811_a(world, ModObjects.chooseModSmithingTable(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 4, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeCoarseDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 1, 2, 0, 3}, {5, 0, 1, 6, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCoarseDirtState, biomeCoarseDirtState, false);
            }
            for (int[] uvw : new int[][]{{6, 1, 0}, {6, 1, 4}, {6, 1, 5}, {6, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150351_n.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{5, 1, 0, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            int chestU = 0;
            int chestV = 1;
            int chestW = 3;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof TileEntityChest) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_toolsmith");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (!this.entitiesGenerated) {
                int w;
                int v;
                int u;
                this.entitiesGenerated = true;
                int s = random.nextInt(3);
                if (s == 0) {
                    u = 2 + random.nextInt(2);
                    v = 1;
                    w = 5 + random.nextInt(2);
                } else {
                    u = 2 + random.nextInt(4);
                    v = 1;
                    w = 2 + random.nextInt(2);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class JungleTemple
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"    FFFF    ", "   FFFFFF   ", "  FFFFFFFF  ", " FFFFFFFFFF ", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", " FFFFFFFFFF ", "  FFFFFFFF  ", "   FFFFFF   ", "    FFFF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleTemple() {
        }

        public JungleTemple(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleTemple buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleTemple.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleTemple(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uvw : new int[][]{{5, 1, 1}, {5, 2, 3}, {6, 1, 3}, {6, 2, 3}, {6, 2, 2}, {3, 2, 5}, {3, 3, 6}, {5, 1, 9}, {5, 2, 8}, {6, 3, 8}, {6, 1, 9}, {8, 1, 5}, {10, 1, 5}, {8, 2, 6}, {10, 1, 6}, {3, 2, 3}, {3, 1, 8}, {8, 2, 3}, {9, 1, 2}, {9, 1, 9}, {2, 0, 4}, {4, 0, 4}, {6, 0, 4}, {5, 0, 7}, {6, 0, 7}, {7, 0, 9}, {5, 0, 5}, {5, 0, 5}, {6, 0, 6}, {5, 4, 4}, {5, 4, 6}, {4, 6, 4}, {7, 5, 4}, {7, 5, 7}, {4, 5, 7}, {4, 6, 7}}) {
                this.func_175811_a(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{5, 1, 2}, {5, 1, 3}, {5, 2, 2}, {5, 3, 3}, {6, 1, 1}, {6, 1, 2}, {6, 3, 3}, {1, 1, 5}, {2, 1, 5}, {2, 2, 5}, {3, 1, 5}, {3, 3, 5}, {1, 1, 6}, {2, 1, 6}, {3, 1, 6}, {2, 2, 6}, {3, 2, 6}, {5, 1, 8}, {5, 1, 10}, {5, 3, 8}, {5, 2, 9}, {6, 1, 8}, {6, 2, 8}, {6, 2, 9}, {6, 1, 10}, {8, 2, 5}, {8, 3, 5}, {8, 1, 6}, {8, 3, 6}, {9, 1, 5}, {9, 2, 5}, {9, 1, 6}, {9, 2, 6}, {2, 1, 2}, {3, 1, 3}, {8, 1, 3}, {2, 1, 9}, {3, 2, 8}, {8, 1, 8}, {8, 2, 8}, {3, 0, 2}, {4, 0, 5}, {4, 0, 7}, {5, 0, 4}, {7, 0, 4}, {7, 0, 6}, {7, 0, 7}, {8, 0, 2}, {9, 0, 7}, {4, 4, 4}, {4, 4, 5}, {4, 4, 6}, {4, 4, 7}, {5, 4, 5}, {5, 4, 7}, {6, 4, 4}, {6, 4, 5}, {6, 4, 6}, {6, 4, 7}, {7, 4, 4}, {7, 4, 5}, {7, 4, 6}, {7, 4, 7}, {4, 5, 4}, {7, 6, 4}, {7, 6, 7}}) {
                this.func_175811_a(world, biomeStoneBrickBlockState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{3, 3, 8}, {8, 3, 8}, {3, 3, 3}, {8, 3, 3}, {4, 7, 7}, {7, 7, 7}, {4, 7, 4}, {7, 7, 4}}) {
                this.func_175811_a(world, biomeChiseledStoneBrickState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePolishedAndesiteState = Blocks.field_150348_b.func_176203_a(6);
            biomePolishedAndesiteState = StructureVillageVN.getBiomeSpecificBlockState(biomePolishedAndesiteState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{5, 1, 6}, {6, 1, 6}, {5, 1, 5}, {6, 1, 5}}) {
                this.func_175811_a(world, biomePolishedAndesiteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePolishedAndesiteSlabBottomState = ModObjects.chooseModPolishedAndesiteSlabState(false);
            if (biomePolishedAndesiteSlabBottomState == null && (biomePolishedAndesiteSlabBottomState = ModObjects.chooseModAndesiteBrickSlabState(false)) == null) {
                biomePolishedAndesiteSlabBottomState = Blocks.field_150333_U.func_176203_a(0);
            }
            biomePolishedAndesiteSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(biomePolishedAndesiteSlabBottomState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 2, 2}, {3, 4, 3}, {9, 2, 2}, {8, 4, 3}, {2, 2, 9}, {3, 4, 8}, {9, 2, 9}, {8, 4, 8}}) {
                this.func_175811_a(world, biomePolishedAndesiteSlabBottomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{6, 1, 0, 3}, {5, 2, 1, 3}, {6, 3, 2, 3}, {0, 1, 6, 0}, {1, 2, 5, 0}, {2, 3, 5, 0}, {3, 4, 6, 0}, {5, 1, 11, 2}, {6, 2, 10, 2}, {5, 3, 9, 2}, {6, 3, 9, 2}, {5, 4, 8, 2}, {11, 1, 6, 1}, {10, 2, 5, 1}, {10, 2, 6, 1}, {9, 3, 5, 1}, {8, 4, 6, 1}, {5, 7, 7, 7}, {7, 7, 6, 4}, {4, 8, 5, 0}, {4, 8, 7, 2}, {6, 8, 7, 2}, {7, 8, 7, 2}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{5, 1, 0, 3}, {6, 2, 1, 3}, {5, 3, 2, 3}, {5, 4, 3, 3}, {6, 4, 3, 3}, {0, 1, 5, 0}, {1, 2, 6, 0}, {2, 3, 6, 0}, {3, 4, 5, 0}, {6, 1, 11, 2}, {5, 2, 10, 2}, {6, 4, 8, 2}, {11, 1, 5, 1}, {9, 3, 6, 1}, {8, 4, 5, 1}, {5, 7, 4, 6}, {6, 7, 4, 6}, {4, 7, 5, 5}, {4, 7, 6, 5}, {7, 7, 5, 4}, {6, 7, 7, 7}, {4, 8, 4, 3}, {5, 8, 4, 3}, {6, 8, 4, 3}, {7, 8, 4, 3}, {4, 8, 6, 0}, {7, 8, 5, 1}, {7, 8, 6, 1}, {5, 8, 7, 2}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{0, 1, 4}, {0, 1, 7}, {4, 1, 0}, {7, 1, 0}, {11, 1, 4}, {11, 1, 7}, {4, 1, 11}, {7, 1, 11}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{0, 2, 4, -1}, {0, 2, 7, -1}, {4, 2, 0, -1}, {7, 2, 0, -1}, {11, 2, 4, -1}, {11, 2, 7, -1}, {4, 2, 11, -1}, {7, 2, 11, -1}, {5, 2, 6, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), this.func_186165_e());
            for (int[] uvw : new int[][]{{5, 5, 6}, {6, 5, 6}, {5, 5, 5}, {6, 5, 5}}) {
                if (campfireState.func_177230_c() == Block.func_149684_b((String)"campfire:campfire")) {
                    int woodmeta = biomePlankState.func_177230_c().func_176201_c(biomePlankState);
                    ModObjects.setModCampfireBlockstate(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), woodmeta);
                    continue;
                }
                this.func_175811_a(world, campfireState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(12);
                int u = s < 4 ? s + 4 : (s < 6 ? 7 : (s < 10 ? 13 - s : 4));
                int v = 1;
                int w = s < 4 ? 4 : (s < 6 ? s + 1 : (s < 10 ? 7 : 16 - s));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class JungleTannery2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  F  F  ", " FFFFFF ", "FFFFFFFF", " FFFFFF ", " FFFFFF ", "FFFFFFFF", " FFFFFF ", " F  PPF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleTannery2() {
        }

        public JungleTannery2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleTannery2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleTannery2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleTannery2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{2, 2, 3, 5, 2, 5}, {2, 1, 2, 5, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFillerState, biomeFillerState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 3, 5, 5, 3, 5}, {4, 3, 4, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwoc : new int[][]{{3, 3, 6, 1, GeneralConfig.useVillageColors ? this.townColor : 0}, {4, 3, 6, 0, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {4, 2, 6, 3, GeneralConfig.useVillageColors ? this.townColor : 0}, {3, 2, 6, 2, GeneralConfig.useVillageColors ? this.townColor2 : 4}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomeStoneBrickWallStone = ModObjects.chooseModStoneBrickWallState();
            biomeStoneBrickWallStone = StructureVillageVN.getBiomeSpecificBlockState(biomeStoneBrickWallStone != null ? biomeStoneBrickWallStone : Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 0, 1, 1, 0}, {1, 1, 1, 1, 2, 1}, {1, 1, 2, 1, 3, 2}, {1, 1, 3, 1, 4, 3}, {6, 1, 0, 6, 1, 0}, {6, 2, 1, 6, 2, 1}, {6, 3, 2, 6, 3, 2}, {6, 4, 3, 6, 4, 3}, {0, 1, 2, 0, 2, 2}, {0, 1, 5, 0, 2, 5}, {2, 1, 7, 2, 2, 7}, {7, 1, 2, 7, 2, 2}, {7, 1, 5, 7, 2, 5}, {5, 1, 7, 5, 2, 7}, {1, 5, 4, 1, 5, 4}, {1, 5, 6, 1, 5, 6}, {6, 5, 4, 6, 5, 4}, {6, 5, 6, 6, 5, 6}, {3, 4, 4, 3, 5, 4}, {6, 4, 4, 6, 5, 4}, {3, 5, 6, 4, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickWallStone, biomeStoneBrickWallStone, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 6, 5, 1, 6, 5}, {6, 6, 5, 6, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uvwo : new int[][]{{0, 3, 2, -1}, {0, 3, 5, -1}, {2, 3, 7, -1}, {7, 3, 2, -1}, {7, 3, 5, -1}, {5, 3, 7, -1}, {2, 6, 5, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 1, 4, 6}, {6, 1, 5, 6, 4, 6}, {6, 1, 3, 6, 3, 4}, {6, 1, 2, 6, 2, 2}, {6, 1, 1, 6, 1, 1}, {2, 4, 4, 2, 4, 4}, {2, 3, 3, 3, 3, 4}, {2, 2, 2, 3, 2, 2}, {2, 1, 1, 3, 1, 1}, {2, 1, 6, 2, 4, 6}, {5, 1, 6, 5, 4, 6}, {3, 1, 6, 4, 1, 6}, {3, 4, 6, 4, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 4, 2, 5, 4}, {1, 5, 5, 1, 5, 5}, {2, 5, 6, 2, 5, 6}, {5, 5, 6, 5, 5, 6}, {6, 5, 5, 6, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 4, 6, 6, 4}, {1, 7, 5, 6, 7, 5}, {1, 6, 6, 6, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{2, 4, 3}, {2, 3, 2}, {2, 2, 1}}) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(3), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{4, 3, 3, 3}, {5, 3, 3, 3}, {4, 2, 2, 3}, {5, 2, 2, 3}, {4, 1, 1, 3}, {5, 1, 1, 3}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 2;
            int chestV = 4;
            int chestW = 5;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_tannery");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (!this.entitiesGenerated) {
                int v;
                int u;
                this.entitiesGenerated = true;
                int s = random.nextInt(14);
                int n = s <= 3 ? 3 : (u = s <= 8 ? 4 : 5);
                int n2 = s <= 0 ? 2 : (s <= 1 ? 3 : (s <= 3 ? 4 : (s <= 4 ? 2 : (s <= 5 ? 3 : (s <= 8 ? 4 : (s <= 9 ? 2 : (v = s <= 10 ? 3 : 4)))))));
                int w = s <= 0 ? 1 : (s <= 1 ? 2 : (s <= 2 ? 3 : (s <= 3 ? 5 : (s <= 8 ? s - 3 : s - 8))));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class JungleTannery1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"   F  F ", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", " FFFPPFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleTannery1() {
        }

        public JungleTannery1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleTannery1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleTannery1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleTannery1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{3, 0, 1, 6, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 6, 3, 1, 6}, {6, 1, 6, 6, 1, 6}, {3, 1, 4, 3, 1, 4}, {6, 1, 4, 6, 1, 4}, {3, 1, 2, 3, 1, 2}, {6, 1, 2, 6, 1, 2}, {3, 4, 6, 3, 4, 6}, {6, 4, 6, 6, 4, 6}, {3, 4, 4, 3, 4, 4}, {6, 4, 4, 6, 4, 4}, {3, 4, 2, 3, 4, 2}, {6, 4, 2, 6, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeStoneBrickWallStone = ModObjects.chooseModStoneBrickWallState();
            biomeStoneBrickWallStone = StructureVillageVN.getBiomeSpecificBlockState(biomeStoneBrickWallStone != null ? biomeStoneBrickWallStone : Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 8, 3, 1, 8}, {6, 1, 8, 6, 1, 8}, {2, 1, 7, 2, 1, 7}, {7, 1, 7, 7, 1, 7}, {2, 1, 1, 2, 1, 1}, {7, 1, 1, 7, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickWallStone, biomeStoneBrickWallStone, false);
            }
            for (int[] uvwo : new int[][]{{3, 2, 8, -1}, {6, 2, 8, -1}, {2, 2, 7, -1}, {7, 2, 7, -1}, {2, 2, 1, -1}, {7, 2, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 7, 6, 4, 7}, {3, 1, 5, 3, 4, 5}, {6, 1, 5, 6, 4, 5}, {3, 1, 3, 3, 4, 3}, {6, 1, 3, 6, 4, 3}, {3, 1, 1, 3, 4, 1}, {4, 4, 1, 5, 4, 1}, {6, 1, 1, 6, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 5, 1}, {5, 3, 5, 3}, {4, 3, 3, 1}, {5, 3, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 6}, {6, 2, 6}, {3, 2, 4}, {6, 2, 4}, {3, 2, 2}, {6, 2, 2}, {3, 3, 6}, {6, 3, 6}, {3, 3, 4}, {6, 3, 4}, {3, 3, 2}, {6, 3, 2}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 7, 0, 2, 7}, {0, 1, 4, 0, 2, 4}, {0, 1, 1, 0, 2, 1}, {4, 5, 1, 5, 5, 1}, {4, 5, 7, 5, 5, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 3, 0, 3}, {5, 3, 0, 3}, {3, 5, 7, 0}, {6, 5, 7, 1}, {3, 5, 6, 0}, {6, 5, 6, 1}, {3, 5, 5, 0}, {6, 5, 5, 1}, {3, 5, 4, 0}, {6, 5, 4, 1}, {3, 5, 3, 0}, {6, 5, 3, 1}, {3, 5, 2, 0}, {6, 5, 2, 1}, {3, 5, 1, 0}, {6, 5, 1, 1}, {4, 6, 7, 0}, {5, 6, 7, 1}, {4, 6, 6, 0}, {5, 6, 6, 1}, {4, 6, 5, 0}, {5, 6, 5, 1}, {4, 6, 4, 0}, {5, 6, 4, 1}, {4, 6, 3, 0}, {5, 6, 3, 1}, {4, 6, 2, 0}, {5, 6, 2, 1}, {4, 6, 1, 0}, {5, 6, 1, 1}, {5, 1, 4, 4}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 1, 0, 3, 7}, {2, 4, 1, 2, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 3, 1, 1, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvw : new int[][]{{2, 1, 6}, {2, 1, 5}, {2, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(3), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState smoothStoneBlockState = ModObjects.chooseModSmoothStoneBlockState();
            for (int[] uuvvww : new int[][]{{4, 1, 6, 5, 1, 6}, {5, 1, 5, 5, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], smoothStoneBlockState, smoothStoneBlockState, false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 1, 2, 1, 1}, {5, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{4, 4, 8, 0}, {5, 4, 8, 0}, {5, 3, 8, 0}, {7, 4, 4, 1}, {7, 4, 5, 1}, {7, 3, 5, 1}, {7, 2, 5, 1}, {7, 1, 5, 1}, {7, 4, 6, 1}, {7, 3, 6, 1}, {7, 2, 6, 1}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(13);
                int u = s <= 4 ? 1 : (s <= 6 ? 2 : (s <= 10 ? 4 : 5));
                int v = 1;
                int w = s <= 4 ? s + 2 : (s <= 6 ? s - 3 : (s <= 10 ? s - 5 : s - 9));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class JungleTamedFarm
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"    FFFF     ", "    FFFF     ", " FFFFFFFFFF  ", " FFFFFFFFFF  ", " FFFFFFFFFF  ", " FFFFFFFFFF  ", " FFFFFFFFFF  ", " FFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "   FFFFFF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 3;
        private static final int DECREASE_MAX_U = 4;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleTamedFarm() {
        }

        public JungleTamedFarm(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleTamedFarm buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleTamedFarm.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleTamedFarm(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            ItemStack itemStack;
            IBlockState bambooStalkState;
            void var21_50;
            void var21_48;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 1, 0, 0, 1}, {0, 0, 4, 0, 0, 4}, {1, 0, 10, 1, 0, 10}, {3, 0, 0, 3, 0, 1}, {4, 0, 10, 4, 0, 10}, {4, 0, 12, 4, 0, 12}, {7, 0, 10, 7, 0, 10}, {7, 0, 12, 7, 0, 12}, {8, 0, 0, 8, 0, 1}, {10, 0, 5, 10, 0, 5}, {10, 0, 10, 10, 0, 10}, {12, 0, 1, 12, 0, 1}, {12, 0, 5, 12, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 0, 1, 3}, {2, 0, 1, 3}, {4, 0, 0, 3}, {5, 0, 0, 3}, {6, 0, 0, 3}, {7, 0, 0, 3}, {9, 0, 1, 3}, {10, 0, 1, 3}, {11, 0, 1, 3}, {12, 0, 2, 1}, {12, 0, 3, 1}, {12, 0, 4, 1}, {11, 0, 5, 2}, {10, 0, 6, 1}, {10, 0, 7, 1}, {10, 0, 8, 1}, {10, 0, 9, 1}, {2, 0, 10, 2}, {3, 0, 10, 2}, {4, 0, 11, 0}, {5, 0, 12, 2}, {6, 0, 12, 2}, {7, 0, 11, 1}, {8, 0, 10, 2}, {9, 0, 10, 2}, {0, 0, 2, 0}, {0, 0, 3, 0}, {1, 0, 4, 2}, {1, 0, 5, 0}, {1, 0, 6, 0}, {1, 0, 7, 0}, {1, 0, 8, 0}, {1, 0, 9, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 2, 1, 0, 3}, {2, 0, 8, 3, 0, 9}, {4, 0, 1, 4, 0, 6}, {4, 0, 9, 4, 0, 9}, {5, 0, 8, 5, 0, 8}, {5, 0, 1, 6, 0, 1}, {5, 0, 11, 6, 0, 11}, {5, 0, 10, 5, 0, 10}, {7, 0, 1, 7, 0, 6}, {7, 0, 8, 7, 0, 8}, {8, 0, 7, 9, 0, 9}, {10, 0, 2, 11, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{1, 1, 3, 1, 1, 3}, {3, 1, 9, 3, 1, 9}, {4, 1, 6, 4, 1, 6}, {7, 1, 1, 7, 1, 1}, {8, 1, 7, 8, 1, 7}, {10, 1, 3, 10, 1, 3}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] nArray : new int[][]{{1, 2, 3, -1}, {3, 2, 9, -1}, {4, 2, 6, -1}, {7, 2, 1, -1}, {8, 2, 7, -1}, {10, 2, 3, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(nArray[3])), nArray[0], nArray[1], nArray[2], structureBB);
            }
            Block[] cropBlocksTemp1 = StructureVillageVN.chooseCropPair(random);
            Block[] cropBlocksTemp2 = StructureVillageVN.chooseCropPair(random);
            Block[] cropBlocks = new Block[]{cropBlocksTemp1[0], cropBlocksTemp1[1], cropBlocksTemp2[0]};
            for (int[] uvwmcp : new int[][]{{2, 0, 2, 7, 0, 0}, {2, 0, 3, 7, 0, 0}, {2, 0, 4, 7, 0, 0}, {2, 0, 5, 7, 0, 0}, {2, 0, 6, 7, 0, 0}, {2, 0, 7, 7, 0, 0}, {3, 0, 2, 7, 0, 0}, {3, 0, 3, 7, 0, 0}, {3, 0, 4, 7, 0, 0}, {3, 0, 5, 7, 0, 0}, {3, 0, 6, 7, 0, 0}, {3, 0, 7, 7, 0, 0}, {5, 0, 2, 7, 1, 0}, {5, 0, 3, 7, 1, 0}, {5, 0, 4, 7, 1, 0}, {5, 0, 5, 7, 1, 0}, {6, 0, 2, 7, 1, 0}, {6, 0, 3, 7, 1, 0}, {6, 0, 4, 7, 1, 0}, {6, 0, 5, 7, 1, 0}, {8, 0, 2, 7, 2, 0}, {8, 0, 3, 7, 2, 0}, {8, 0, 4, 7, 2, 0}, {8, 0, 5, 7, 2, 0}, {8, 0, 6, 7, 2, 0}, {9, 0, 2, 7, 2, 0}, {9, 0, 3, 7, 2, 0}, {9, 0, 4, 7, 2, 0}, {9, 0, 5, 7, 2, 0}, {9, 0, 6, 7, 2, 0}}) {
                IBlockState cropState;
                this.func_175808_b(world, biomeFillerState, uvwmcp[0], uvwmcp[1] - 1, uvwmcp[2], structureBB);
                int cropProgressMeta = uvwmcp[5];
                while (true) {
                    try {
                        cropState = cropBlocks[0].func_176203_a(cropProgressMeta);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (cropProgressMeta == 0) {
                            cropState = Blocks.field_150464_aj.func_176203_a(uvwmcp[5]);
                            break;
                        }
                        cropProgressMeta /= 2;
                        continue;
                    }
                    break;
                }
                this.func_175811_a(world, cropState, uvwmcp[0], uvwmcp[1] + 1, uvwmcp[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwmcp[3]), uvwmcp[0], uvwmcp[1], uvwmcp[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 8, 5, 2, 9}, {5, 2, 8, 5, 3, 9}, {6, 3, 9, 6, 3, 9}, {6, 5, 9, 6, 5, 9}, {6, 2, 10, 6, 3, 10}, {6, 5, 10, 6, 5, 10}, {7, 1, 8, 7, 1, 9}, {7, 4, 9, 7, 5, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 9, 5, 1, 9}, {5, 4, 9, 5, 5, 9}, {6, 1, 9, 6, 2, 9}, {6, 4, 9, 6, 4, 9}, {6, 1, 10, 6, 1, 10}, {6, 4, 10, 6, 4, 10}, {7, 2, 8, 7, 3, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], iBlockState, iBlockState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{5, 3, 8, 3}, {6, 6, 10, 2}, {7, 6, 9, 1}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] nArray : new int[][]{{5, 6, 9, 0}, {7, 4, 8, 3}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(nArray[3] % 4 + nArray[3] / 4 * 4), nArray[0], nArray[1], nArray[2], structureBB);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            int[][] uuvvww = new int[][]{{6, 7, 9}};
            int uvwo = uuvvww.length;
            boolean bl = false;
            while (var21_48 < uvwo) {
                int[] uvw = uuvvww[var21_48];
                this.func_175811_a(world, biomeCobblestoneSlabLowerState, uvw[0], uvw[1], uvw[2], structureBB);
                ++var21_48;
            }
            uuvvww = new int[][]{{4, 0, 7, 4, 0, 8}, {5, 0, 6, 6, 0, 7}, {6, 0, 8, 6, 0, 8}, {7, 0, 7, 7, 0, 7}, {6, 6, 9, 6, 6, 9}};
            uvwo = uuvvww.length;
            boolean bl2 = false;
            while (var21_50 < uvwo) {
                int[] uuvvww2 = uuvvww[var21_50];
                this.func_175804_a(world, structureBB, uuvvww2[0], uuvvww2[1], uuvvww2[2], uuvvww2[3], uuvvww2[4], uuvvww2[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
                ++var21_50;
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                for (int[] uvw : new int[][]{{4, 1, 1}}) {
                    this.func_175811_a(world, compostBinState, uvw[0], uvw[1], uvw[2], structureBB);
                    this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                }
            }
            if ((bambooStalkState = ModObjects.chooseModBambooStalk(0)) != null) {
                IBlockState iBlockState2;
                for (int[] uvwuvws : new int[][]{{2, 1, 8, 2, 3, 8, 3}, {2, 4, 8, 2, 4, 8, 4}, {2, 5, 8, 2, 6, 8, 5}, {2, 1, 9, 2, 1, 9, 3}, {2, 2, 9, 2, 3, 9, 4}, {2, 4, 9, 2, 4, 9, 5}, {4, 1, 9, 4, 1, 9, 0}, {4, 2, 9, 4, 3, 9, 1}, {8, 1, 9, 8, 1, 9, 0}, {8, 2, 9, 8, 2, 9, 1}, {9, 1, 8, 9, 2, 8, 3}, {9, 3, 8, 9, 3, 8, 4}, {9, 4, 8, 9, 5, 8, 5}, {10, 1, 2, 10, 1, 2, 3}, {10, 2, 2, 10, 3, 2, 4}, {10, 4, 2, 10, 4, 2, 5}}) {
                    bambooStalkState = ModObjects.chooseModBambooStalk(uvwuvws[6]);
                    this.func_175804_a(world, structureBB, uvwuvws[0], uvwuvws[1], uvwuvws[2], uvwuvws[3], uvwuvws[4], uvwuvws[5], bambooStalkState, bambooStalkState, false);
                }
                if ((Block.func_149684_b((String)"futuremc:bamboo") == null || bambooStalkState.func_177230_c() != Block.func_149684_b((String)"futuremc:bamboo")) && (iBlockState2 = ModObjects.chooseModBambooLeaves()) != null) {
                    for (int[] uuvvww3 : new int[][]{{2, 7, 8}, {2, 5, 9}, {9, 6, 8}, {10, 5, 2}}) {
                        this.func_175811_a(world, iBlockState2, uuvvww3[0], uuvvww3[1], uuvvww3[2], structureBB);
                    }
                }
            } else {
                bambooStalkState = Blocks.field_150436_aH.func_176223_P();
                for (int[] uvw : new int[][]{{5, 0, 9}, {7, 0, 9}}) {
                    this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
                }
                for (int[] uuvvww4 : new int[][]{{4, 1, 9, 4, 2, 9}, {8, 1, 9, 8, 1, 9}}) {
                    this.func_175804_a(world, structureBB, uuvvww4[0], uuvvww4[1], uuvvww4[2], uuvvww4[3], uuvvww4[4], uuvvww4[5], bambooStalkState, bambooStalkState, false);
                }
            }
            if ((itemStack = ModObjects.chooseModBambooShoot()) != null) {
                Block bambooShootBlock = Block.func_149634_a((Item)itemStack.func_77973_b());
                int bambooShootMeta = itemStack.func_77952_i();
                if (bambooShootBlock != null) {
                    for (int[] uvw : new int[][]{{8, 1, 8}, {9, 1, 7}}) {
                        this.func_175811_a(world, bambooShootBlock.func_176203_a(bambooShootMeta), uvw[0], uvw[1], uvw[2], structureBB);
                    }
                }
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo2 : new int[][]{{4, 1, 8, 3}, {4, 2, 8, 3}, {4, 4, 9, 3}, {4, 5, 9, 3}, {7, 1, 7, 2}, {7, 2, 7, 2}, {7, 3, 7, 2}, {5, 3, 10, 0}, {5, 4, 10, 0}, {6, 1, 11, 0}, {6, 2, 11, 0}, {6, 3, 11, 0}, {8, 2, 8, 1}, {8, 3, 8, 1}, {8, 3, 9, 1}, {8, 4, 9, 1}, {8, 5, 9, 1}, {7, 1, 10, 1}, {7, 2, 10, 1}, {7, 3, 10, 1}, {7, 4, 10, 1}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo2[0], uvwo2[2]), this.func_74862_a(uvwo2[1]), this.func_74873_b(uvwo2[0], uvwo2[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo2[3])), uvwo2[0], uvwo2[1], uvwo2[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(8);
                int v = 1;
                int w = 2 + random.nextInt(4);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleStoneAnimalPen
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"    FFF    ", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFPFFFFF", "FFFFFPFFFFF", "FFFFFPFFFFF", "FFFFFPFFFFF", "FFFFFPFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 4;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleStoneAnimalPen() {
        }

        public JungleStoneAnimalPen(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleStoneAnimalPen buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)4, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleStoneAnimalPen.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleStoneAnimalPen(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uvw : new int[][]{{0, 0, 0}, {0, 0, 2}, {0, 0, 3}, {0, 0, 5}, {1, 0, 6}, {4, 0, 7}, {5, 1, 7}, {8, 0, 6}, {10, 0, 1}, {10, 0, 2}, {10, 0, 6}, {2, 0, 0}, {4, 1, 0}, {6, 0, 0}}) {
                this.func_175811_a(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{0, 0, 1}, {0, 0, 4}, {0, 0, 6}, {2, 0, 6}, {3, 0, 6}, {4, 0, 6}, {4, 1, 6}, {6, 0, 6}, {6, 1, 6}, {7, 0, 6}, {9, 0, 6}, {10, 0, 5}, {10, 0, 4}, {10, 0, 3}, {4, 1, 7}, {5, 0, 7}, {6, 0, 7}, {6, 1, 7}, {10, 0, 0}, {9, 0, 0}, {8, 0, 0}, {7, 0, 0}, {6, 1, 0}, {4, 0, 0}, {3, 0, 0}, {1, 0, 0}}) {
                this.func_175811_a(world, biomeStoneBrickBlockState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 2, 6}, {6, 2, 6}, {4, 2, 0}, {6, 2, 0}, {5, 0, 6}}) {
                this.func_175811_a(world, biomeChiseledStoneBrickState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 6, 3, 1, 6}, {7, 1, 6, 9, 1, 6}, {0, 1, 1, 0, 1, 6}, {10, 1, 1, 10, 1, 6}, {0, 1, 0, 3, 1, 0}, {7, 1, 0, 10, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 1, 4, 1, 1}, {4, 1, 3, 4, 1, 5}, {6, 1, 1, 6, 1, 1}, {6, 1, 3, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 1, 2}, {6, 1, 2}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(1, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 3, 6, -1}, {6, 3, 6, -1}, {4, 3, 0, -1}, {6, 3, 0, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 1, 3, 0, 4}, {7, 0, 1, 9, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1] + 1, uuvvww[2], uuvvww[3], uuvvww[4] + 1, uuvvww[5], Blocks.field_150329_H.func_176203_a(1), Blocks.field_150329_H.func_176203_a(1), false);
            }
            for (int[] uuvvww : new int[][]{{4, 0, 1, 4, 0, 4}, {6, 0, 1, 6, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 5, 9, 0, 5}, {5, 1, 6, 5, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{2, 1, 2}, {8, 1, 3}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSteppedFarm
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFFF         ", "FFFFFFFF   FFF ", "FFFFFFFF  FFFFF", "FFFFFFF   FFFFF", "FFFFFFF   FF  F", "FFFFFFF    FFF ", " FFFFF         ", "        FFFFF  ", "       FFFFFFF ", "       FFFFFFF ", "  FFF  FFFFFFF ", " FFF F FFFFFFF ", " FFF F FFFFFFF ", " FFFFF FFFFFF  ", "  FFF   F      "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSteppedFarm() {
        }

        public JungleSteppedFarm(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSteppedFarm buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSteppedFarm.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSteppedFarm(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 0, 9, 5, 2, 13}, {8, 0, 2, 12, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 9, 0, 1, 10}, {0, 2, 10, 0, 2, 10}, {0, 0, 11, 0, 0, 11}, {0, 2, 12, 0, 2, 12}, {0, 1, 13, 0, 1, 13}, {1, 0, 14, 1, 0, 14}, {2, 1, 14, 2, 2, 14}, {3, 2, 14, 3, 2, 14}, {4, 1, 14, 4, 2, 14}, {5, 0, 14, 5, 0, 14}, {6, 0, 13, 6, 1, 13}, {6, 0, 11, 6, 0, 11}, {6, 2, 9, 6, 2, 11}, {6, 3, 11, 6, 3, 11}, {6, 1, 10, 6, 1, 10}, {6, 3, 9, 6, 3, 9}, {6, 0, 9, 6, 0, 9}, {1, 1, 8, 1, 1, 8}, {2, 2, 8, 4, 2, 8}, {4, 1, 8, 5, 1, 8}, {5, 0, 8, 5, 0, 8}, {3, 3, 11, 3, 3, 11}, {10, 0, 10, 10, 1, 10}, {7, 0, 2, 7, 0, 3}, {7, 2, 2, 7, 2, 2}, {7, 2, 4, 7, 2, 4}, {7, 1, 4, 7, 1, 5}, {7, 0, 6, 7, 0, 6}, {8, 0, 7, 9, 0, 7}, {9, 1, 7, 9, 1, 7}, {10, 2, 7, 10, 2, 7}, {11, 1, 7, 11, 1, 7}, {12, 0, 7, 12, 0, 7}, {13, 0, 5, 13, 0, 5}, {13, 1, 3, 13, 1, 4}, {13, 0, 3, 13, 0, 3}, {8, 0, 1, 9, 0, 1}, {10, 1, 1, 11, 1, 1}, {12, 0, 1, 12, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{0, 2, 9}, {0, 0, 10}, {0, 1, 11}, {0, 0, 12}, {0, 2, 13}, {1, 2, 14}, {2, 0, 14}, {3, 1, 14}, {4, 0, 14}, {5, 2, 14}, {6, 2, 13}, {6, 0, 12}, {6, 1, 11}, {6, 0, 10}, {6, 2, 9}, {1, 2, 8}, {2, 0, 8}, {3, 1, 8}, {4, 0, 8}, {5, 2, 8}, {3, 4, 11}, {10, 2, 10}, {7, 1, 2}, {7, 0, 4}, {7, 1, 6}, {8, 1, 7}, {10, 0, 7}, {12, 1, 7}, {13, 1, 2}, {13, 0, 4}, {13, 1, 6}, {8, 1, 1}, {10, 0, 1}, {12, 1, 1}}) {
                this.func_175811_a(world, biomeChiseledStoneBrickState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 0, 9}, {0, 2, 11}, {0, 1, 12}, {0, 0, 13}, {1, 1, 14}, {3, 0, 14}, {5, 1, 14}, {6, 1, 9}, {6, 1, 12}, {6, 2, 12}, {1, 0, 8}, {2, 1, 8}, {3, 0, 8}, {7, 1, 3}, {7, 0, 5}, {10, 1, 7}, {11, 0, 7}, {13, 0, 2}, {13, 1, 5}, {13, 0, 6}, {9, 1, 1}, {11, 0, 1}}) {
                this.func_175811_a(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{0, 3, 9, 0}, {0, 3, 12, 0}, {1, 3, 14, 2}, {4, 3, 14, 2}, {6, 3, 13, 1}, {1, 3, 8, 3}, {3, 3, 8, 3}, {4, 3, 8, 3}, {7, 3, 11, 6}, {9, 3, 11, 6}, {10, 3, 11, 6}, {11, 3, 11, 6}, {11, 3, 7, 5}, {7, 3, 9, 7}, {7, 2, 6, 0}, {12, 2, 7, 2}, {13, 2, 6, 1}, {13, 2, 5, 1}, {13, 2, 3, 1}, {9, 2, 1, 3}, {11, 2, 1, 3}, {12, 2, 1, 3}, {6, 2, 4, 6}, {5, 2, 2, 7}, {1, 0, 1, 0}, {2, 0, 4, 2}, {3, 0, 4, 2}, {3, 0, 0, 3}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{0, 3, 10, 0}, {0, 3, 11, 0}, {0, 3, 13, 0}, {2, 3, 14, 2}, {3, 3, 14, 2}, {5, 3, 14, 2}, {6, 3, 12, 1}, {2, 3, 8, 3}, {5, 3, 8, 3}, {8, 3, 11, 6}, {11, 3, 9, 7}, {11, 3, 8, 5}, {8, 3, 9, 7}, {9, 3, 9, 7}, {9, 3, 8, 4}, {9, 3, 7, 4}, {11, 2, 10, 5}, {10, 0, 11, 0}, {10, 0, 12, 0}, {11, 0, 13, 2}, {12, 0, 13, 2}, {13, 0, 13, 2}, {14, 0, 12, 1}, {14, 0, 11, 1}, {14, 0, 10, 1}, {11, 0, 9, 3}, {12, 0, 9, 3}, {13, 0, 9, 3}, {7, 2, 5, 0}, {8, 2, 7, 2}, {9, 2, 7, 2}, {11, 2, 7, 2}, {13, 2, 4, 1}, {13, 2, 2, 1}, {8, 2, 1, 3}, {10, 2, 1, 3}, {6, 2, 2, 7}, {5, 2, 4, 6}, {5, 1, 3, 5}, {1, 0, 2, 0}, {1, 0, 3, 0}, {4, 0, 4, 2}, {5, 0, 3, 1}, {5, 0, 2, 1}, {5, 0, 1, 1}, {2, 0, 0, 3}, {4, 0, 0, 3}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(13), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{7, 2, 10, 9, 2, 10}, {10, 2, 8, 10, 2, 9}, {6, 1, 3, 6, 1, 3}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeStoneBrickSlabLowerState, biomeStoneBrickSlabLowerState, false);
            }
            Block[] cropBlocksTemp1 = StructureVillageVN.chooseCropPair(random);
            Block[] cropBlocksTemp2 = StructureVillageVN.chooseCropPair(random);
            Block[] cropBlocks = new Block[]{cropBlocksTemp1[0], cropBlocksTemp1[1], cropBlocksTemp2[0], cropBlocksTemp2[1]};
            for (int[] uvwmcp : new int[][]{{1, 3, 13, 7, 0, 0}, {2, 3, 13, 7, 0, 0}, {3, 3, 13, 7, 0, 0}, {4, 3, 13, 7, 0, 0}, {5, 3, 13, 7, 0, 0}, {1, 3, 12, 7, 0, 0}, {2, 3, 12, 7, 0, 0}, {4, 3, 12, 7, 0, 0}, {5, 3, 12, 7, 0, 0}, {1, 3, 11, 7, 0, 0}, {5, 3, 11, 7, 0, 0}, {1, 3, 10, 7, 0, 0}, {2, 3, 10, 7, 0, 0}, {1, 3, 9, 7, 0, 0}, {2, 3, 9, 7, 0, 0}, {3, 3, 9, 7, 0, 0}, {4, 3, 9, 7, 0, 0}, {5, 3, 9, 7, 0, 0}, {11, 0, 12, 7, 1, 0}, {12, 0, 12, 7, 1, 0}, {13, 0, 12, 7, 1, 0}, {11, 0, 11, 7, 1, 0}, {12, 0, 11, 7, 1, 0}, {13, 0, 11, 7, 1, 0}, {11, 0, 10, 7, 1, 0}, {11, 2, 6, 7, 2, 0}, {12, 2, 6, 7, 2, 0}, {9, 2, 5, 7, 2, 0}, {10, 2, 5, 7, 2, 0}, {11, 2, 5, 7, 2, 0}, {12, 2, 5, 7, 2, 0}, {9, 2, 4, 7, 2, 0}, {10, 2, 4, 7, 2, 0}, {11, 2, 4, 7, 2, 0}, {12, 2, 4, 7, 2, 0}, {9, 2, 3, 7, 2, 0}, {10, 2, 3, 7, 2, 0}, {11, 2, 3, 7, 2, 0}, {12, 2, 3, 7, 2, 0}, {8, 2, 2, 7, 2, 0}, {9, 2, 2, 7, 2, 0}, {10, 2, 2, 7, 2, 0}, {11, 2, 2, 7, 2, 0}, {12, 2, 2, 7, 2, 0}, {2, 0, 3, 7, 3, 0}, {3, 0, 3, 7, 3, 0}, {2, 0, 2, 7, 3, 0}, {3, 0, 2, 7, 3, 0}, {2, 0, 1, 7, 3, 0}, {3, 0, 1, 7, 3, 0}, {4, 0, 1, 7, 3, 0}}) {
                IBlockState cropState;
                this.func_175808_b(world, biomeFillerState, uvwmcp[0], uvwmcp[1] - 1, uvwmcp[2], structureBB);
                int cropProgressMeta = uvwmcp[5];
                while (true) {
                    try {
                        cropState = cropBlocks[0].func_176203_a(cropProgressMeta);
                    }
                    catch (IllegalArgumentException e) {
                        if (cropProgressMeta == 0) {
                            cropState = Blocks.field_150464_aj.func_176203_a(uvwmcp[5]);
                            break;
                        }
                        cropProgressMeta /= 2;
                        continue;
                    }
                    break;
                }
                this.func_175811_a(world, cropState, uvwmcp[0], uvwmcp[1] + 1, uvwmcp[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwmcp[3]), uvwmcp[0], uvwmcp[1], uvwmcp[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 5, 11, 3, 5, 11}, {2, 3, 11, 2, 3, 11}, {3, 3, 12, 3, 3, 12}, {4, 3, 11, 4, 3, 11}, {3, 3, 10, 7, 3, 10}, {12, 0, 10, 12, 0, 10}, {8, 2, 6, 10, 2, 6}, {4, 0, 2, 4, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{8, 3, 10, 1}, {9, 3, 10, 2}, {10, 3, 10, 3}, {10, 3, 9, 4}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(uvw[3]), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState iBlockState = ModObjects.chooseModComposterState();
            if (iBlockState != null) {
                for (int[] uvw : new int[][]{{7, 0, 1}, {7, 0, 12}}) {
                    this.func_175811_a(world, iBlockState, uvw[0], uvw[1], uvw[2], structureBB);
                    this.func_175811_a(world, biomeDirtState, uvw[0], uvw[1] - 1, uvw[2], structureBB);
                }
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{8, 0, 0, 8, 1, 0, 2}, {7, 0, 13, 7, 2, 13, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{-1, 0, 9, 3}, {-1, 1, 9, 3}, {-1, 1, 10, 3}, {-1, 2, 10, 3}, {-1, 1, 13, 3}, {-1, 2, 13, 3}, {6, 1, 5, 3}, {0, 0, 14, 0}, {0, 1, 14, 0}, {0, 2, 14, 0}, {2, 0, 15, 0}, {2, 1, 15, 0}, {3, 1, 15, 0}, {3, 2, 15, 0}, {8, 1, 8, 0}, {7, 2, 11, 1}, {7, 1, 11, 1}, {13, 0, 1, 1}, {13, 1, 1, 1}, {14, 0, 3, 1}, {14, 1, 3, 1}, {14, 1, 4, 1}, {1, 1, 7, 2}, {1, 2, 7, 2}, {4, 1, 7, 2}, {4, 2, 7, 2}, {5, 1, 7, 2}, {9, 0, 0, 2}, {10, 0, 0, 2}, {10, 1, 0, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(2);
                int v = 1;
                int w = 1 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleStable
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFF ", "FFFFF ", "FFFFF ", "FFFFF ", "FFFFF ", "FFFFF ", "FFFFFF", "FFFFF ", "  P   ", "F P F "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleStable() {
        }

        public JungleStable(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleStable buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleStable.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleStable(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{2, 1, 9, 2, 2, 9}, {0, 1, 9, 0, 2, 9}, {4, 1, 9, 4, 2, 9}, {0, 1, 7, 0, 2, 7}, {4, 1, 7, 4, 2, 7}, {0, 1, 5, 0, 2, 5}, {4, 1, 5, 4, 2, 5}, {0, 1, 3, 0, 2, 3}, {4, 1, 3, 4, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 8, 2}, {0, 3, 3, -1}, {4, 3, 3, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 9, 1, 1, 9}, {3, 1, 9, 3, 1, 9}, {0, 1, 8, 0, 1, 8}, {4, 1, 8, 4, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{1, 1, 7, 3, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 9, 1, 2, 9}, {3, 2, 9, 3, 2, 9}, {0, 1, 0, 0, 4, 0}, {0, 1, 2, 0, 3, 2}, {0, 1, 4, 0, 3, 4}, {0, 1, 6, 0, 2, 6}, {0, 2, 8, 0, 2, 8}, {4, 1, 0, 4, 4, 0}, {4, 1, 2, 4, 3, 2}, {4, 1, 4, 4, 3, 4}, {4, 1, 6, 4, 2, 6}, {4, 2, 8, 4, 2, 8}, {1, 1, 2, 1, 1, 2}, {3, 1, 2, 3, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 1, 2}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(2, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 2, 0, 4, 2}, {4, 4, 2, 4, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 8, 4, 3, 9}, {0, 4, 4, 4, 4, 5}, {0, 5, 0, 4, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 6, 4, 3, 7}, {0, 4, 3, 4, 4, 3}, {1, 4, 2, 3, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 3, 3, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1] + 1, uuvvww[2], uuvvww[3], uuvvww[4] + 1, uuvvww[5], Blocks.field_150329_H.func_176203_a(1), Blocks.field_150329_H.func_176203_a(1), false);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 3, 0, 0, 9}, {4, 0, 3, 4, 0, 9}, {0, 0, 2, 4, 0, 2}, {1, 0, 7, 3, 0, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTopState, biomeTopState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 8, 3, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            IBlockState biomeHayBaleVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150407_cf.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{5, 1, 3}}) {
                this.func_175811_a(world, biomeHayBaleVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{-1, 2, 9, 3}, {2, 2, 10, 0}, {0, 2, 10, 0}, {0, 1, 10, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{2, 1, 4}}) {
                        BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                        EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                        if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                            String[] petname_a = NameGenerator.newRandomName("pet", random);
                            animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                        }
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse8
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", "       ", "       ", "       ", "       ", "       ", "  PF   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse8() {
        }

        public JungleSmallHouse8(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse8 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse8.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse8(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{1, 1, 5}, {1, 2, 5}, {5, 1, 5}, {5, 2, 5}, {1, 1, 1}, {1, 2, 1}, {5, 1, 1}, {5, 2, 1}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 0, 5}, {5, 0, 5}, {1, 0, 1}, {5, 0, 1}}) {
                this.func_175808_b(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 3, 5, 1, 8, 5}, {5, 3, 5, 5, 8, 5}, {1, 3, 1, 1, 8, 1}, {5, 3, 1, 5, 8, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 3, 0, 6, 3, 2}, {5, 3, 2, 5, 3, 2}, {2, 3, 5, 4, 4, 5}, {3, 5, 5, 3, 5, 5}, {2, 6, 5, 4, 6, 5}, {1, 3, 2, 1, 4, 4}, {1, 5, 3, 1, 5, 3}, {1, 6, 2, 1, 6, 4}, {5, 3, 3, 5, 4, 4}, {5, 5, 3, 5, 5, 3}, {5, 6, 2, 5, 6, 4}, {2, 3, 1, 4, 4, 1}, {3, 5, 1, 3, 5, 1}, {2, 6, 1, 4, 6, 1}, {2, 3, 2, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{3, 6, 6, 0}, {0, 6, 3, 3}, {6, 6, 3, 1}, {3, 6, 0, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 1, 0, 0}, {4, 2, 0, 0}, {5, 3, 0, 0}, {4, 1, 0, 5}, {5, 2, 0, 5}, {1, 7, 2, 6}, {1, 7, 4, 7}, {2, 7, 5, 5}, {4, 7, 5, 4}, {5, 7, 2, 6}, {5, 7, 4, 7}, {2, 7, 1, 5}, {4, 7, 1, 4}, {1, 8, 2, 0}, {1, 8, 4, 0}, {2, 8, 5, 2}, {4, 8, 5, 2}, {5, 8, 2, 1}, {5, 8, 4, 1}, {2, 8, 1, 3}, {4, 8, 1, 3}, {2, 9, 4, 2}, {3, 9, 4, 2}, {4, 9, 4, 2}, {2, 9, 3, 0}, {4, 9, 3, 1}, {2, 9, 2, 3}, {3, 9, 2, 3}, {4, 9, 2, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 8, 6, 6, 8, 6}, {0, 8, 1, 0, 8, 5}, {6, 8, 1, 6, 8, 5}, {0, 8, 0, 6, 8, 0}, {3, 8, 1, 3, 8, 1}, {3, 8, 5, 3, 8, 5}, {1, 8, 3, 1, 8, 3}, {5, 8, 3, 5, 8, 3}, {1, 9, 5, 5, 9, 5}, {1, 9, 2, 1, 9, 4}, {5, 9, 2, 5, 9, 4}, {1, 9, 1, 5, 9, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 9, 3, 3, 9, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvw : new int[][]{{2, 5, 5}, {4, 5, 5}, {1, 5, 2}, {1, 5, 4}, {5, 5, 4}, {2, 5, 1}, {4, 5, 1}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 2, 2, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), false);
            }
            int flower_u = 2;
            int flower_v = 5;
            int flower_w = 2;
            int x = this.func_74865_a(flower_u, flower_w);
            int y = this.func_74862_a(flower_v);
            int z = this.func_74873_b(flower_u, flower_w);
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int randomPottedPlant = random.nextInt(10) - 1;
            if (randomPottedPlant == -1) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
            } else {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            for (int[] uvwoc : new int[][]{{3, 4, 4, 3, GeneralConfig.useVillageColors ? this.townColor4 : 9}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            int chestU = 2;
            int chestV = 4;
            int chestW = 4;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 4, 2, 1, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 7, 5, 3}, {0, 6, 5, 3}, {1, 7, 1, 0}, {1, 6, 1, 0}, {1, 5, 1, 0}, {1, 4, 1, 0}, {1, 3, 1, 0}, {1, 2, 1, 0}, {1, 1, 1, 0}, {5, 7, 1, 0}, {5, 6, 1, 0}, {6, 7, 1, 1}, {6, 6, 1, 1}, {6, 7, 5, 1}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 4, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse7
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFF  ", " FFFFFF ", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", " FFFFFF ", "  FPPF  ", "   PP   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse7() {
        }

        public JungleSmallHouse7(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse7 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse7.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse7(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 1, 1}, {2, 1, 2, 2, 2, 2}, {5, 1, 1, 5, 1, 1}, {5, 1, 2, 5, 2, 2}, {2, 1, 8, 2, 1, 8}, {2, 1, 7, 2, 2, 7}, {3, 1, 7, 4, 1, 7}, {5, 1, 8, 5, 1, 8}, {5, 1, 7, 5, 2, 7}, {0, 1, 3, 0, 1, 3}, {1, 1, 3, 1, 2, 3}, {1, 1, 4, 1, 1, 5}, {0, 1, 6, 0, 1, 6}, {1, 1, 6, 1, 2, 6}, {7, 1, 3, 7, 1, 3}, {6, 1, 3, 6, 2, 3}, {6, 1, 4, 6, 1, 5}, {7, 1, 6, 7, 1, 6}, {6, 1, 6, 6, 2, 6}, {2, 1, 6, 5, 1, 6}, {2, 1, 4, 2, 1, 5}, {5, 1, 4, 5, 1, 5}, {2, 1, 3, 5, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            for (int[] uvwoc : new int[][]{{3, 1, 5, 1, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {4, 1, 5, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {3, 1, 4, 0, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {4, 1, 4, 3, GeneralConfig.useVillageColors ? this.townColor3 : 14}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomeTerracottaState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150405_ch.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 6, 2, 4, 6}, {5, 2, 6, 5, 4, 6}, {2, 2, 3, 2, 4, 3}, {5, 2, 3, 5, 4, 3}, {3, 4, 2, 4, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTerracottaState, biomeTerracottaState, false);
            }
            IBlockState biomeStoneBrickWallStone = ModObjects.chooseModStoneBrickWallState();
            biomeStoneBrickWallStone = StructureVillageVN.getBiomeSpecificBlockState(biomeStoneBrickWallStone != null ? biomeStoneBrickWallStone : Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 7, 1, 2, 7}, {2, 3, 7, 2, 4, 7}, {5, 3, 7, 5, 4, 7}, {6, 1, 7, 6, 2, 7}, {1, 3, 6, 1, 4, 6}, {6, 3, 6, 6, 4, 6}, {1, 3, 3, 1, 4, 3}, {6, 3, 3, 6, 4, 3}, {1, 1, 2, 1, 2, 2}, {2, 3, 2, 2, 4, 2}, {5, 3, 2, 5, 4, 2}, {6, 1, 2, 6, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickWallStone, biomeStoneBrickWallStone, false);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 1, 8, 2}, {4, 1, 8, 2}, {0, 1, 4, 0}, {0, 1, 5, 0}, {7, 1, 4, 1}, {7, 1, 5, 1}, {3, 1, 2, 3}, {4, 1, 2, 3}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 3, 7, -1}, {6, 3, 7, -1}, {1, 3, 2, -1}, {6, 3, 2, -1}, {2, 4, 5, 2}, {5, 4, 4, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 2, 7, 4, 4, 7}, {1, 2, 4, 1, 4, 5}, {6, 2, 4, 6, 4, 5}, {3, 4, 2, 4, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTerracottaState, biomeTerracottaState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 5, 7, 2}, {5, 5, 7, 2}, {1, 5, 6, 0}, {6, 5, 6, 1}, {1, 5, 3, 0}, {6, 5, 3, 1}, {2, 5, 2, 3}, {5, 5, 2, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 5, 7, 4, 5, 7}, {1, 5, 4, 1, 5, 5}, {6, 5, 4, 6, 5, 5}, {3, 5, 2, 4, 5, 2}, {2, 6, 6, 5, 6, 6}, {2, 6, 4, 2, 6, 5}, {5, 6, 4, 5, 6, 5}, {2, 6, 3, 5, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 5, 6}, {5, 5, 6}, {2, 5, 3}, {5, 5, 3}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 2, 5, 5, 2, 5}, {3, 6, 4, 4, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            int flower_u = 5;
            int flower_v = 3;
            int flower_w = 5;
            int x = this.func_74865_a(flower_u, flower_w);
            int y = this.func_74862_a(flower_v);
            int z = this.func_74873_b(flower_u, flower_w);
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int randomPottedPlant = random.nextInt(10) - 1;
            if (randomPottedPlant == -1) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
            } else {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 2, 6}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 2, 4, 2, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 3, 2, 1, 1}, {4, 2, 3, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 2, 3, 3}, {0, 4, 4, 3}, {0, 3, 4, 3}, {0, 2, 4, 3}, {7, 4, 5, 1}, {7, 3, 5, 1}, {3, 4, 8, 0}, {4, 4, 8, 0}, {4, 3, 8, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse6
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{" FFFF ", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", " FFFFF", " PPP  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse6() {
        }

        public JungleSmallHouse6(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse6 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse6.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse6(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 0, 6, 4, 0, 6}, {0, 0, 3, 5, 0, 5}, {0, 0, 2, 4, 0, 2}, {1, 0, 1, 3, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 2, 1}, {2, 3, 1, 2, 3, 1}, {3, 1, 1, 3, 2, 1}, {0, 1, 2, 0, 2, 2}, {0, 1, 3, 0, 1, 4}, {0, 3, 3, 0, 3, 4}, {0, 1, 5, 0, 2, 5}, {1, 1, 6, 1, 2, 6}, {2, 1, 6, 3, 1, 6}, {2, 3, 6, 3, 3, 6}, {4, 1, 6, 4, 2, 6}, {5, 1, 3, 5, 2, 5}, {5, 3, 4, 5, 3, 4}, {4, 1, 2, 4, 1, 2}, {4, 3, 2, 4, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{1, 3, 1}, {3, 3, 1}, {0, 3, 2}, {0, 3, 5}, {1, 3, 6}, {4, 3, 6}, {5, 3, 5}, {5, 3, 3}}) {
                this.func_175811_a(world, biomeChiseledStoneBrickState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 2, 3}, {0, 2, 4}, {2, 2, 6}, {3, 2, 6}, {4, 2, 2}}) {
                this.func_175811_a(world, Blocks.field_150359_w.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 1, 4, 3}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeBrickSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(12), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 3}, {4, 1, 5}}) {
                this.func_175811_a(world, biomeBrickSlabUpperState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 4, 4}}) {
                this.func_175811_a(world, Blocks.field_150321_G.func_176223_P(), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwf : new int[][]{{4, 2, 5, 8}}) {
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, uvwf[3]);
                BlockPos flowerPotPos = new BlockPos(this.func_74865_a(uvwf[0], uvwf[2]), this.func_74862_a(uvwf[1]), this.func_74873_b(uvwf[0], uvwf[2]));
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 4, 1, 3}, {0, 4, 3, 0}, {0, 4, 4, 0}, {2, 4, 6, 2}, {3, 4, 6, 2}, {5, 4, 4, 1}, {4, 3, 3, 6}, {4, 3, 5, 7}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 1, 4, 1}, {3, 4, 1, 3, 4, 1}, {0, 4, 2, 0, 4, 2}, {4, 4, 2, 4, 4, 2}, {5, 4, 3, 5, 4, 3}, {0, 4, 5, 0, 4, 5}, {5, 4, 5, 5, 4, 5}, {1, 4, 6, 1, 4, 6}, {4, 4, 6, 4, 4, 6}, {2, 5, 2, 2, 5, 2}, {1, 5, 3, 3, 5, 3}, {1, 5, 4, 4, 5, 4}, {2, 5, 5, 3, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 2, 1, 4, 2}, {3, 4, 2, 3, 4, 2}, {4, 4, 3, 4, 4, 3}, {1, 4, 5, 1, 4, 5}, {4, 4, 5, 4, 4, 5}, {4, 3, 4, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 4, 4}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 2, 0, 2}, {3, 2, 0, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{2, 3, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{1, 1, 4, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 1, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 1, 5, 1, 1}, {5, 1, 2, 5, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{-1, 1, 2, 3}, {-1, 1, 5, 3}, {-1, 2, 5, 3}, {-1, 3, 5, 3}, {0, 1, 6, 0}, {0, 2, 6, 0}, {3, 1, 7, 0}, {4, 1, 7, 0}, {4, 2, 7, 0}, {6, 2, 3, 1}, {6, 1, 3, 1}, {6, 1, 4, 1}, {6, 1, 5, 1}, {6, 2, 5, 1}, {6, 3, 5, 1}, {0, 1, 1, 2}, {0, 2, 1, 2}, {0, 3, 1, 2}, {3, 1, 0, 2}, {5, 2, 2, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse5
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  F F  ", " FFFFF ", "FFFFFFF", " FFFFF ", "FFFFFFF", " FFFFF ", " FFPFF ", " FFPFF ", "  PPP  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse5() {
        }

        public JungleSmallHouse5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 3, 3, 0, 3}, {2, 0, 3, 2, 2, 3}, {4, 0, 3, 4, 2, 3}, {2, 0, 2, 2, 1, 2}, {4, 0, 2, 4, 1, 2}, {2, 0, 1, 2, 2, 1}, {4, 0, 1, 4, 2, 1}, {2, 3, 1, 2, 3, 3}, {3, 3, 1, 3, 3, 1}, {3, 3, 3, 3, 3, 3}, {4, 3, 1, 4, 3, 3}, {1, 0, 6, 1, 3, 6}, {5, 0, 6, 5, 3, 6}, {1, 0, 5, 1, 1, 5}, {5, 0, 5, 5, 1, 5}, {1, 3, 5, 1, 3, 5}, {5, 3, 5, 5, 3, 5}, {1, 0, 4, 1, 3, 4}, {5, 0, 4, 5, 3, 4}, {1, 0, 7, 5, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomeStoneBrickSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(13), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 3, 2, 3, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickSlabUpperState, biomeStoneBrickSlabUpperState, false);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{2, 4, 3, 3}, {3, 4, 3, 3}, {4, 4, 3, 3}, {1, 4, 4, 0}, {1, 4, 5, 0}, {1, 4, 6, 0}, {2, 4, 7, 2}, {3, 4, 7, 2}, {4, 4, 7, 2}, {5, 4, 4, 1}, {5, 4, 5, 1}, {5, 4, 6, 1}, {2, 5, 6, 2}, {3, 5, 6, 2}, {4, 5, 6, 2}, {2, 5, 5, 0}, {4, 5, 5, 1}, {2, 5, 4, 3}, {3, 5, 4, 3}, {4, 5, 4, 3}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 4, 4, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeStoneBrickWallStone = ModObjects.chooseModStoneBrickWallState();
            biomeStoneBrickWallStone = StructureVillageVN.getBiomeSpecificBlockState(biomeStoneBrickWallStone != null ? biomeStoneBrickWallStone : Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 4, 6, 3, 4, 6}, {2, 1, 8, 2, 3, 8}, {4, 1, 8, 4, 3, 8}, {0, 1, 6, 0, 3, 6}, {6, 1, 6, 6, 3, 6}, {0, 1, 4, 0, 3, 4}, {6, 1, 4, 6, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickWallStone, biomeStoneBrickWallStone, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 5}, {5, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 5, 5, 3, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 5, 3, 1, 5, GeneralConfig.useVillageColors ? this.townColor4 : 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvwo : new int[][]{{2, 1, 6, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvw : new int[][]{{2, 2, 6}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 3, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 3, 6}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{4, 1, 5, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 5, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse4
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"        ", " FFFFFF ", " FFFFFFF", " FFFFFFF", " FFFFFFF", " FFFFFF ", "F PPP F "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse4() {
        }

        public JungleSmallHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 0, 1, 5, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 1, 0}, {6, 1, 0, 6, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 3, 2}, {2, 1, 1, 2, 1, 1}, {2, 3, 1, 2, 3, 1}, {3, 1, 1, 3, 3, 1}, {4, 3, 1, 4, 3, 1}, {5, 1, 1, 5, 3, 5}, {1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {1, 1, 4, 1, 3, 4}, {1, 1, 5, 2, 3, 5}, {3, 1, 5, 3, 2, 5}, {4, 1, 5, 5, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor4 : 9), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor4 : 9), false);
            }
            IBlockState biomeHayBaleVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150407_cf.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 1, 5, 5, 1}, {1, 5, 2, 1, 5, 4}, {5, 5, 2, 5, 5, 4}, {1, 5, 5, 5, 5, 5}, {2, 6, 2, 4, 6, 2}, {2, 6, 3, 2, 6, 3}, {4, 6, 3, 4, 6, 3}, {2, 6, 4, 4, 6, 4}, {0, 4, 0, 6, 4, 0}, {0, 4, 1, 0, 4, 5}, {6, 4, 1, 6, 4, 5}, {0, 4, 6, 6, 4, 6}, {3, 7, 3, 3, 7, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeHayBaleVertState, biomeHayBaleVertState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 2, 1}, {1, 2, 3}, {3, 3, 5}, {2, 5, 4}, {3, 5, 4}, {4, 5, 4}, {2, 5, 3}, {3, 6, 3}, {4, 5, 3}, {2, 5, 2}, {3, 5, 2}, {4, 5, 2}}) {
                this.func_175811_a(world, biomeFenceState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{0, 2, 0, -1}, {6, 2, 0, -1}, {4, 3, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 1, 2}, {2, 4, 1, 2}, {3, 4, 1, 2}, {4, 4, 1, 2}, {5, 4, 1, 2}, {1, 4, 2, 1}, {1, 4, 3, 1}, {1, 4, 4, 1}, {5, 4, 2, 0}, {5, 4, 3, 0}, {5, 4, 4, 0}, {1, 4, 5, 3}, {2, 4, 5, 3}, {3, 4, 5, 3}, {4, 4, 5, 3}, {5, 4, 5, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 3, 3, 1, 3, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvw : new int[][]{{3, 1, 4}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int chestU = 4;
            int chestV = 1;
            int chestW = 4;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvwoc : new int[][]{{2, 1, 3, 0, GeneralConfig.useVillageColors ? this.townColor4 : 9}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvwmcp : new int[][]{{6, 0, 1, 7, 0}, {7, 0, 2, 7, 0}, {7, 0, 3, 7, 0}, {7, 0, 4, 7, 0}, {6, 0, 5, 7, 0}}) {
                this.func_175808_b(world, biomeFillerState, uvwmcp[0], uvwmcp[1] - 1, uvwmcp[2], structureBB);
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvwmcp[4]), uvwmcp[0], uvwmcp[1] + 1, uvwmcp[2], structureBB);
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(uvwmcp[3]), uvwmcp[0], uvwmcp[1], uvwmcp[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{6, 0, 2, 6, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FPPPF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse3() {
        }

        public JungleSmallHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{4, 6, 4, 4, 6, 4}, {1, 0, 1, 5, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 2, 4, 4, 5, 4}, {4, 7, 4, 4, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 2, 3}, {5, 2, 3}, {3, 5, 1}, {3, 5, 5}, {3, 2, 5}}) {
                this.func_175811_a(world, biomeFenceState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 5, 1, 4, 5}, {5, 1, 5, 5, 4, 5}, {1, 1, 1, 1, 4, 1}, {5, 1, 1, 5, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 5, 2, 3, 5}, {3, 1, 5, 3, 1, 5}, {3, 3, 5, 3, 3, 5}, {4, 1, 5, 4, 3, 5}, {2, 5, 5, 2, 5, 5}, {4, 5, 5, 4, 5, 5}, {1, 1, 2, 1, 3, 2}, {1, 1, 3, 1, 1, 3}, {1, 3, 3, 1, 3, 3}, {1, 1, 4, 1, 3, 4}, {5, 1, 2, 5, 3, 2}, {5, 1, 3, 5, 1, 3}, {5, 3, 3, 5, 3, 3}, {5, 1, 4, 5, 3, 4}, {2, 1, 1, 2, 3, 1}, {3, 1, 1, 3, 1, 1}, {3, 3, 1, 3, 3, 1}, {4, 1, 1, 4, 3, 1}, {3, 5, 1, 3, 5, 1}, {3, 5, 5, 3, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 3, 1}, {4, 3, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 5, 0, 0}, {1, 5, 1, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {1, 5, 6, 0}, {2, 6, 0, 0}, {2, 6, 1, 0}, {2, 6, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {2, 6, 5, 0}, {2, 6, 6, 0}, {4, 6, 0, 1}, {4, 6, 1, 1}, {4, 6, 2, 1}, {4, 6, 3, 1}, {4, 6, 5, 1}, {4, 6, 6, 1}, {5, 5, 0, 1}, {5, 5, 1, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {5, 5, 5, 1}, {5, 5, 6, 1}, {2, 5, 0, 5}, {3, 6, 0, 7}, {4, 5, 0, 4}, {2, 5, 6, 5}, {3, 6, 6, 6}, {4, 5, 6, 4}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 7, 0, 3, 7, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{0, 4, 0, 0, 4, 6}, {6, 4, 0, 6, 4, 6}, {1, 4, 2, 1, 4, 4}, {2, 4, 1, 4, 4, 1}, {2, 4, 5, 4, 4, 5}, {5, 4, 2, 5, 4, 4}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int randomPottedPlant = random.nextInt(10) - 1;
            for (int[] uvw : new int[][]{{1, 1, 0}, {5, 1, 0}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, iBlockState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{4, 1, 4, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvwoc : new int[][]{{2, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor4 : 14}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"          ", " FFFFFFFF ", " FFFFFFFF ", " FFFFFFFF ", " FFFFFFFF ", " FPFFFFFF ", " FPFFFFFF ", " FPFFFFFF ", " FPFFFFFF ", " FPPPPPPP "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 3;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse2() {
        }

        public JungleSmallHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 0, 5, 3, 0, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFillerState, biomeFillerState, false);
            }
            for (int[] uuvvww : new int[][]{{5, 2, 2, 5, 4, 2}, {6, 4, 2, 6, 4, 2}, {7, 2, 2, 7, 4, 2}, {5, 2, 8, 5, 4, 8}, {6, 2, 8, 6, 2, 8}, {6, 4, 8, 6, 4, 8}, {7, 2, 8, 7, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), false);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 2, 8, 1, 8}, {5, 6, 2, 5, 6, 2}, {6, 7, 2, 6, 7, 2}, {7, 6, 2, 7, 6, 2}, {4, 2, 2, 4, 2, 8}, {4, 3, 2, 4, 3, 2}, {4, 3, 4, 4, 3, 8}, {4, 4, 2, 4, 4, 8}, {4, 5, 3, 4, 5, 7}, {8, 2, 2, 8, 2, 8}, {8, 3, 2, 8, 3, 2}, {8, 3, 4, 8, 3, 6}, {8, 3, 8, 8, 3, 8}, {8, 4, 2, 8, 4, 8}, {8, 5, 3, 8, 5, 7}, {5, 6, 8, 5, 6, 8}, {6, 7, 8, 6, 7, 8}, {7, 6, 8, 7, 6, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 4), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 4), false);
            }
            for (int[] uvw : new int[][]{{7, 2, 3, 7, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor5 : 1), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{1, 3, 5, 3, 3, 5}, {1, 3, 8, 3, 3, 8}, {4, 5, 2, 8, 5, 2}, {4, 5, 8, 8, 5, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 6, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 3, 6, 1, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 5, 3, 2, 5}, {3, 4, 5, 3, 4, 5}, {1, 1, 5, 1, 2, 8}, {2, 1, 8, 3, 2, 8}, {3, 4, 8, 3, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 5, 5}}) {
                this.func_175811_a(world, biomeFenceState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{5, 4, 5}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 1, 1, 3}, {6, 1, 1, 3}, {7, 1, 1, 3}, {3, 5, 1, 0}, {3, 5, 2, 0}, {3, 5, 3, 0}, {3, 5, 4, 0}, {3, 5, 5, 0}, {3, 5, 6, 0}, {3, 5, 7, 0}, {3, 5, 8, 0}, {3, 5, 9, 0}, {4, 6, 1, 0}, {4, 6, 2, 0}, {4, 6, 3, 0}, {4, 6, 4, 0}, {4, 6, 5, 0}, {4, 6, 6, 0}, {4, 6, 7, 0}, {4, 6, 8, 0}, {4, 6, 9, 0}, {5, 7, 1, 0}, {5, 7, 2, 0}, {5, 7, 3, 0}, {5, 7, 4, 0}, {5, 7, 5, 0}, {5, 7, 6, 0}, {5, 7, 7, 0}, {5, 7, 8, 0}, {5, 7, 9, 0}, {7, 7, 1, 1}, {7, 7, 2, 1}, {7, 7, 3, 1}, {7, 7, 4, 1}, {7, 7, 5, 1}, {7, 7, 6, 1}, {7, 7, 7, 1}, {7, 7, 8, 1}, {7, 7, 9, 1}, {8, 6, 1, 1}, {8, 6, 2, 1}, {8, 6, 3, 1}, {8, 6, 4, 1}, {8, 6, 5, 1}, {8, 6, 6, 1}, {8, 6, 7, 1}, {8, 6, 8, 1}, {8, 6, 9, 1}, {9, 5, 1, 1}, {9, 5, 2, 1}, {9, 5, 3, 1}, {9, 5, 4, 1}, {9, 5, 5, 1}, {9, 5, 6, 1}, {9, 5, 7, 1}, {9, 5, 8, 1}, {9, 5, 9, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 3, 5, 0, 3, 8}, {2, 4, 5, 2, 4, 8}, {3, 1, 6, 3, 1, 6}, {3, 2, 7, 3, 2, 7}, {3, 3, 6, 3, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 5, 1, 4, 8}, {6, 8, 1, 6, 8, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            for (int[] uvw : new int[][]{{6, 6, 2}, {4, 3, 3}, {6, 3, 8}, {6, 6, 8}, {8, 3, 3}, {8, 3, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 2, 4, 7, 2, 5, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            for (int[] uvwm : new int[][]{{4, 1, 1, 11}, {8, 1, 1, 11}}) {
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, uvwm[3]);
                BlockPos flowerPotPos = new BlockPos(this.func_74865_a(uvwm[0], uvwm[2]), this.func_74862_a(uvwm[1]), this.func_74873_b(uvwm[0], uvwm[2]));
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvw : new int[][]{{7, 3, 3}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 1, 5, 2, 1, 0}, {6, 2, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int chestU = 3;
            int chestV = 1;
            int chestW = 7;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvwoc : new int[][]{{6, 2, 6, 2, GeneralConfig.useVillageColors ? this.townColor2 : 4}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{5, 2, 5, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleSmallHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"            ", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "  FFFFFFFFFF", "  FFFFFFFFFF", "  FFF  FFFFF", "  FFF  FFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleSmallHouse1() {
        }

        public JungleSmallHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleSmallHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleSmallHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleSmallHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 4, 1, 0, 8}, {2, 0, 1, 2, 0, 8}, {4, 0, 1, 4, 0, 1}, {3, 0, 2, 8, 0, 4}, {7, 0, 0, 8, 0, 1}, {9, 0, 1, 9, 0, 2}, {10, 0, 0, 11, 0, 2}, {2, 1, 4, 2, 6, 4}, {3, 3, 4, 3, 3, 4}, {3, 6, 4, 3, 6, 4}, {4, 1, 4, 4, 6, 4}, {5, 1, 4, 6, 1, 4}, {5, 3, 4, 6, 4, 4}, {5, 6, 4, 6, 6, 4}, {7, 1, 4, 8, 6, 4}, {8, 1, 2, 8, 3, 3}, {8, 4, 2, 8, 5, 2}, {10, 1, 2, 11, 3, 2}, {10, 4, 2, 10, 5, 2}, {9, 3, 2, 9, 3, 2}, {8, 6, 2, 10, 6, 2}, {2, 1, 5, 2, 6, 5}, {2, 3, 6, 2, 6, 7}, {2, 1, 6, 2, 6, 8}, {11, 0, 3, 11, 3, 3}, {11, 0, 4, 11, 1, 4}, {11, 3, 4, 11, 3, 4}, {11, 0, 5, 11, 3, 5}, {11, 0, 6, 11, 1, 6}, {11, 3, 6, 11, 3, 6}, {11, 0, 7, 11, 3, 8}, {10, 4, 4, 10, 4, 4}, {10, 4, 6, 10, 4, 6}, {10, 4, 3, 10, 6, 3}, {10, 4, 4, 10, 4, 4}, {10, 5, 4, 10, 6, 4}, {10, 4, 5, 10, 6, 5}, {10, 4, 6, 10, 4, 6}, {10, 5, 6, 10, 6, 6}, {10, 4, 7, 10, 6, 8}, {3, 0, 8, 3, 1, 8}, {3, 3, 8, 3, 4, 8}, {3, 6, 8, 3, 6, 8}, {4, 0, 8, 4, 6, 8}, {5, 0, 8, 6, 1, 8}, {5, 3, 8, 6, 4, 8}, {5, 6, 8, 6, 6, 8}, {7, 0, 8, 8, 6, 8}, {9, 0, 8, 9, 1, 8}, {9, 3, 8, 9, 4, 8}, {9, 6, 8, 9, 6, 8}, {10, 0, 8, 10, 3, 8}, {2, 3, 2, 7, 3, 3}, {7, 3, 0, 11, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 4), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 4), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 5, 10, 0, 7}, {9, 0, 3, 10, 0, 4}, {4, 8, 6, 8, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 7, 2}, {10, 2, 5, 3}, {3, 6, 6, 1}, {9, 6, 6, 3}, {9, 6, 3, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 4, 0, 2, 4}, {0, 1, 8, 0, 2, 8}, {2, 1, 2, 2, 2, 2}, {4, 1, 2, 4, 2, 2}, {6, 1, 2, 6, 2, 2}, {7, 1, 0, 7, 2, 0}, {11, 1, 0, 11, 2, 0}, {2, 4, 2, 2, 4, 3}, {3, 4, 2, 7, 4, 2}, {7, 4, 0, 7, 4, 1}, {8, 4, 0, 11, 4, 0}, {11, 4, 0, 11, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 3, 4, 3}, {1, 3, 4, 3}, {0, 3, 5, 0}, {0, 3, 6, 0}, {0, 3, 7, 0}, {0, 3, 8, 2}, {1, 3, 8, 2}, {1, 4, 5, 3}, {1, 4, 6, 0}, {1, 4, 7, 2}, {1, 6, 3, 3}, {2, 6, 3, 3}, {3, 6, 3, 3}, {4, 6, 3, 3}, {5, 6, 3, 3}, {6, 6, 3, 3}, {7, 6, 3, 3}, {7, 6, 2, 0}, {7, 6, 1, 3}, {8, 6, 1, 3}, {9, 6, 1, 3}, {10, 6, 1, 3}, {11, 6, 1, 3}, {11, 6, 2, 1}, {11, 6, 2, 1}, {11, 6, 3, 1}, {11, 6, 4, 1}, {11, 6, 5, 1}, {11, 6, 6, 1}, {11, 6, 7, 1}, {11, 6, 8, 1}, {11, 6, 9, 2}, {10, 6, 9, 2}, {9, 6, 9, 2}, {8, 6, 9, 2}, {7, 6, 9, 2}, {6, 6, 9, 2}, {5, 6, 9, 2}, {4, 6, 9, 2}, {3, 6, 9, 2}, {2, 6, 9, 2}, {1, 6, 9, 2}, {1, 6, 8, 0}, {1, 6, 7, 0}, {1, 6, 6, 0}, {1, 6, 5, 0}, {1, 6, 4, 0}, {1, 6, 3, 0}, {2, 7, 4, 3}, {3, 7, 4, 3}, {4, 7, 4, 3}, {5, 7, 4, 3}, {6, 7, 4, 3}, {7, 7, 4, 3}, {8, 7, 4, 3}, {8, 7, 3, 0}, {8, 7, 2, 3}, {9, 7, 2, 3}, {10, 7, 2, 3}, {10, 7, 3, 1}, {10, 7, 4, 1}, {10, 7, 5, 1}, {10, 7, 6, 1}, {10, 7, 7, 1}, {10, 7, 8, 2}, {9, 7, 8, 2}, {8, 7, 8, 2}, {7, 7, 8, 2}, {6, 7, 8, 2}, {5, 7, 8, 2}, {4, 7, 8, 2}, {3, 7, 8, 2}, {2, 7, 8, 2}, {2, 7, 7, 0}, {2, 7, 6, 0}, {2, 7, 5, 0}, {3, 8, 5, 3}, {4, 8, 5, 3}, {5, 8, 5, 3}, {6, 8, 5, 3}, {7, 8, 5, 3}, {8, 8, 5, 3}, {9, 8, 5, 3}, {9, 8, 6, 1}, {9, 8, 7, 2}, {8, 8, 7, 2}, {7, 8, 7, 2}, {6, 8, 7, 2}, {5, 8, 7, 2}, {4, 8, 7, 2}, {3, 8, 7, 2}, {3, 8, 6, 0}, {6, 1, 7, 0}, {7, 2, 7, 0}, {8, 3, 7, 0}, {7, 1, 7, 5}, {8, 2, 7, 5}, {9, 3, 7, 5}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 3, 7, 4, 3, 7}, {3, 3, 5, 9, 3, 6}, {9, 3, 3, 9, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{9, 8, 3, 9, 8, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            for (int[] uvw : new int[][]{{5, 2, 4}, {6, 2, 4}, {5, 5, 4}, {6, 5, 4}, {3, 2, 8}, {5, 2, 8}, {6, 2, 8}, {9, 2, 8}, {3, 5, 8}, {5, 5, 8}, {6, 5, 8}, {9, 5, 8}, {11, 2, 4}, {11, 2, 6}, {10, 5, 4}, {10, 5, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 4, 0, 1, 0}, {2, 1, 6, 3, 1, 0}, {9, 1, 2, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{3, 0, 1, 3, 0, 1, 3}, {9, 0, 1, 9, 0, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{10, 1, 7}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            int chestU = 4;
            int chestV = 4;
            int chestW = 7;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvwoc : (ChestGenHooks)new int[][]{{3, 4, 6, 2, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    Object orientation = uvwoc[3];
                    reference var32_59 = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    Object v = uvwoc[1];
                    reference var34_61 = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a((int)var32_59, (int)var34_61), this.func_74862_a((int)v), this.func_74873_b((int)var32_59, (int)var34_61), StructureVillageVN.getBedOrientationMeta((int)orientation, this.func_186165_e(), isHead), (int)uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 4, 5, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleShepherdHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFFF ", " FFFFFFF ", "FFFFFFFF ", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "   FFFFFF", "      P  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleShepherdHouse() {
        }

        public JungleShepherdHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleShepherdHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleShepherdHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleShepherdHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{4, 1, 6, 7, 1, 6}, {3, 1, 2, 3, 1, 3}, {3, 1, 5, 3, 1, 5}, {8, 1, 2, 8, 1, 5}, {4, 1, 1, 5, 1, 1}, {7, 1, 1, 7, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 2, 3, 0, 5}, {4, 0, 1, 7, 0, 6}, {8, 0, 2, 8, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 2, 5}, {4, 1, 3, 7}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 5, 4, 4, 5}, {7, 4, 5, 7, 4, 5}, {4, 4, 2, 4, 4, 2}, {7, 4, 2, 7, 4, 2}, {3, 5, 6, 3, 5, 6}, {8, 5, 6, 8, 5, 6}, {3, 5, 1, 3, 5, 1}, {8, 5, 1, 8, 5, 1}, {3, 3, 0, 3, 3, 0}, {8, 3, 0, 8, 3, 0}, {3, 1, 9, 7, 1, 9}, {7, 1, 7, 7, 1, 8}, {2, 1, 8, 2, 1, 9}, {1, 1, 7, 1, 1, 8}, {0, 1, 3, 0, 1, 7}, {0, 1, 2, 2, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwg : new int[][]{{1, 1, 3, 0}, {2, 1, 3, 0}, {1, 1, 4, 0}, {2, 1, 4, 0}, {1, 1, 5, 0}, {2, 1, 5, 0}, {1, 1, 6, 0}, {2, 1, 6, 0}, {2, 1, 7, 0}, {3, 1, 7, 0}, {4, 1, 7, 0}, {5, 1, 7, 0}, {6, 1, 7, 0}, {3, 1, 8, 0}, {4, 1, 8, 0}, {5, 1, 8, 0}, {6, 1, 8, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 1) {
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
                    continue;
                }
                if (uvwg[3] == 2) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 2, 3, -1}, {0, 2, 2, -1}, {0, 2, 7, -1}, {2, 2, 9, -1}, {7, 2, 9, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{4, 4, 6, 7, 4, 6}, {4, 4, 1, 7, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{3, 4, 2, 3, 4, 5}, {8, 4, 2, 8, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 0, 6, 3, 4, 6}, {8, 0, 6, 8, 4, 6}, {3, 0, 1, 3, 4, 1}, {8, 0, 1, 8, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 1, 7}, {5, 3, 1, 3}, {6, 3, 1, 7}, {7, 3, 1, 3}, {4, 2, 1, 7}, {5, 2, 1, 3}, {7, 2, 1, 3}, {4, 3, 6, 2}, {5, 3, 6, 6}, {6, 3, 6, 2}, {7, 3, 6, 6}, {4, 2, 6, 2}, {5, 2, 6, 6}, {6, 2, 6, 2}, {7, 2, 6, 6}, {3, 3, 2, 0}, {3, 3, 3, 4}, {3, 3, 4, 0}, {3, 3, 5, 4}, {3, 2, 2, 0}, {3, 2, 3, 4}, {3, 2, 5, 4}, {8, 3, 2, 5}, {8, 3, 3, 1}, {8, 3, 4, 5}, {8, 3, 5, 1}, {8, 2, 2, 5}, {8, 2, 3, 1}, {8, 2, 4, 5}, {8, 2, 5, 1}, {4, 5, 6, 5}, {7, 5, 6, 4}, {3, 5, 5, 7}, {8, 5, 5, 7}, {3, 5, 2, 6}, {8, 5, 2, 6}, {4, 5, 1, 5}, {7, 5, 1, 4}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 5, 6, 6, 5, 6}, {3, 5, 3, 3, 5, 4}, {8, 5, 3, 8, 5, 4}, {5, 5, 1, 6, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 6, 2, 7, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 1, 1, 0, 1, 0}, {3, 1, 4, 1, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 2, 0}, {8, 2, 0}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{5, 1, 3, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {6, 1, 3, GeneralConfig.useVillageColors ? this.townColor : 0}, {6, 1, 4, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {5, 1, 4, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{7, 1, 5, 2}}) {
                this.func_175811_a(world, ModObjects.chooseModLoom(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 4;
            int chestV = 2;
            int chestW = 2;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_shepherd");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (Object uvwo : (ChestGenHooks)new int[][]{{2, 4, 1, 3}, {2, 3, 1, 3}, {9, 4, 3, 1}, {9, 3, 3, 1}, {9, 2, 3, 1}, {9, 1, 3, 1}, {9, 0, 3, 1}, {9, 4, 4, 1}, {9, 3, 4, 1}, {4, 4, 7, 0}, {5, 4, 7, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a((int)uvwo[0], (int)uvwo[2]), this.func_74862_a((int)uvwo[1]), this.func_74873_b((int)uvwo[0], (int)uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 7;
                int v = 1;
                int w = 5;
                while (u == 7 && w == 5) {
                    u = 5 + random.nextInt(3);
                    w = 2 + random.nextInt(4);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{5, 1, 7}}) {
                        ArrayList<Object> arraylist_animal = new ArrayList<Object>();
                        if (VillageGeneratorConfigHandler.animaniaLivestock) {
                            for (String animal_namespace : ModObjects.animania_sheep) {
                                EntityLiving testEntity = null;
                                try {
                                    testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(animal_namespace), (World)world);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (testEntity == null) continue;
                                arraylist_animal.add(testEntity);
                            }
                        }
                        if (arraylist_animal.isEmpty() && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                            arraylist_animal.add(new EntitySheep(world));
                        }
                        if (arraylist_animal.isEmpty()) continue;
                        EntityLiving animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleMediumHouse4
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFF  ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFPPPFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 5;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleMediumHouse4() {
        }

        public JungleMediumHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleMediumHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleMediumHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleMediumHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)5, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 1, 2, 8, 1, 6}, {1, 0, 7, 1, 0, 9}, {2, 0, 9, 2, 0, 10}, {4, 0, 7, 4, 0, 7}, {6, 0, 9, 6, 0, 10}, {7, 0, 7, 7, 0, 9}, {3, 0, 8, 5, 0, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 1, 1, 1}, {4, 1, 1, 3}, {5, 1, 1, 0}, {4, 1, 7, 2}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 8, 1, 1, 8}, {7, 1, 8, 7, 1, 8}, {1, 1, 7, 2, 1, 7}, {6, 1, 7, 7, 1, 7}, {1, 1, 1, 2, 1, 1}, {6, 1, 1, 7, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150349_c.func_176223_P(), Blocks.field_150349_c.func_176223_P(), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 1, 0}, {2, 1, 0, 2, 1, 0}, {6, 1, 0, 6, 1, 0}, {8, 1, 0, 8, 1, 0}, {0, 2, 6, 0, 4, 6}, {3, 2, 6, 3, 4, 6}, {5, 2, 6, 5, 4, 6}, {8, 2, 6, 8, 4, 6}, {0, 2, 2, 0, 4, 2}, {3, 2, 2, 3, 4, 2}, {5, 2, 2, 5, 4, 2}, {8, 2, 2, 8, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{3, 5, 2, 3, 5, 6}, {5, 5, 2, 5, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 6, 2, 4, 6}, {6, 4, 6, 7, 4, 6}, {1, 2, 6, 2, 2, 6}, {6, 2, 6, 7, 2, 6}, {1, 4, 2, 2, 4, 2}, {6, 4, 2, 7, 4, 2}, {1, 2, 2, 2, 2, 2}, {6, 2, 2, 7, 2, 2}, {0, 2, 3, 0, 4, 5}, {8, 2, 3, 8, 4, 5}, {2, 5, 2, 2, 5, 6}, {6, 5, 2, 6, 5, 6}, {4, 4, 6, 4, 4, 6}, {4, 4, 2, 4, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{1, 3, 2}, {2, 3, 2}, {6, 3, 2}, {7, 3, 2}, {1, 3, 6}, {2, 3, 6}, {6, 3, 6}, {7, 3, 6}}) {
                this.func_175811_a(world, Blocks.field_150359_w.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 5, 2, 0, 5, 6}, {3, 6, 2, 5, 6, 6}, {8, 5, 2, 8, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 1, 1, 4}, {1, 1, 0, 7}, {7, 1, 0, 7}, {8, 1, 1, 5}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {1, 5, 6, 0}, {7, 5, 2, 1}, {7, 5, 3, 1}, {7, 5, 4, 1}, {7, 5, 5, 1}, {7, 5, 6, 1}, {7, 2, 3, 6}, {7, 2, 5, 7}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 0, 0, 2, 1}, {1, 2, 0, 2, 2, 0}, {6, 2, 0, 7, 2, 0}, {8, 2, 0, 8, 2, 1}, {4, 5, 1, 4, 5, 2}, {4, 5, 4, 4, 5, 4}, {4, 5, 6, 4, 5, 7}, {1, 1, 7, 1, 1, 9}, {2, 1, 9, 2, 1, 10}, {3, 1, 10, 3, 1, 10}, {7, 1, 7, 7, 1, 9}, {6, 1, 9, 6, 1, 10}, {5, 1, 10, 5, 1, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 1, 10}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(2, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 4, 1}, {4, 4, 4}, {4, 4, 7}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{7, 2, 4}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 2, 5, 4, 2, 5, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {3, 2, 4, 5, 2, 4, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {4, 2, 3, 4, 2, 3, GeneralConfig.useVillageColors ? this.townColor5 : 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{6, 2, 4, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 2, 5, 1, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {2, 2, 3, 1, GeneralConfig.useVillageColors ? this.townColor3 : 14}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 2, 2, 1, 0}, {4, 2, 6, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, 8}, {3, 1, 7}, {5, 1, 7}, {6, 1, 8}}) {
                this.func_175811_a(world, Blocks.field_150328_O.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 2, 1}, {2, 2, 1}, {6, 2, 1}, {7, 2, 1}}) {
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(5), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 1, 7}, {6, 1, 7}}) {
                this.func_175811_a(world, biomeLeafState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{-1, 4, 4, 3}, {-1, 4, 5, 3}, {-1, 3, 5, 3}, {-1, 3, 6, 3}, {-1, 2, 6, 3}, {-1, 1, 6, 3}, {9, 4, 2, 1}, {9, 3, 2, 1}, {9, 2, 2, 1}, {9, 1, 2, 1}, {9, 4, 3, 1}, {9, 3, 3, 1}, {9, 4, 5, 1}, {9, 4, 6, 1}, {9, 3, 6, 1}, {5, 2, 7, 0}, {5, 3, 7, 0}, {5, 4, 7, 0}, {8, 4, 7, 0}, {1, 4, 1, 2}, {2, 4, 1, 2}, {2, 5, 1, 2}, {3, 5, 1, 2}, {8, 3, 1, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 2, 5, -1, 0}, {3, 2, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
                for (int[] uvwo : new int[][]{{1, 3, 4, 1}}) {
                    int z;
                    int y;
                    int x = this.func_74865_a(uvwo[0], uvwo[2]);
                    EntityPainting painting = new EntityPainting(world, new BlockPos(x, y = this.func_74862_a(uvwo[1]), z = this.func_74873_b(uvwo[0], uvwo[2])), EnumFacing.func_176731_b((int)StructureVillageVN.chooseHangingMeta(uvwo[3], this.func_186165_e())));
                    if (!painting.func_70518_d()) continue;
                    EntityPainting.EnumArt[] a_1x1_paintings = new EntityPainting.EnumArt[]{EntityPainting.EnumArt.KEBAB, EntityPainting.EnumArt.AZTEC, EntityPainting.EnumArt.ALBAN, EntityPainting.EnumArt.AZTEC_2, EntityPainting.EnumArt.BOMB, EntityPainting.EnumArt.PLANT, EntityPainting.EnumArt.WASTELAND};
                    painting.field_70522_e = a_1x1_paintings[random.nextInt(a_1x1_paintings.length)];
                    world.func_72838_d((Entity)painting);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleMediumHouse3
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"    FFF    ", "   FPPPF   ", "  FPPPPPF  ", " FPPPPPPPF ", "FFPPFPFPPFF", "FFPPPPPPPFF", "FFPPFPFPPFF", " FPPPPPPPF ", "  FPPPPPF  ", "   FPPPF   ", "    FFF    ", "    PPP    ", "  FFPPPFF  ", "  FPPPPPF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 5;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 3;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleMediumHouse3() {
        }

        public JungleMediumHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleMediumHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleMediumHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleMediumHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()]), true, (byte)5, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeHayBaleVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150407_cf.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 3, 4, 2, 3}, {6, 1, 3, 6, 2, 3}, {3, 1, 4, 3, 2, 4}, {7, 1, 4, 7, 2, 4}, {2, 1, 5, 2, 2, 5}, {8, 1, 5, 8, 2, 5}, {1, 1, 6, 1, 2, 6}, {9, 1, 6, 9, 2, 6}, {0, 1, 7, 0, 2, 9}, {10, 1, 7, 10, 2, 9}, {1, 1, 10, 1, 2, 10}, {9, 1, 10, 9, 2, 10}, {2, 1, 11, 2, 2, 11}, {8, 1, 11, 8, 2, 11}, {3, 1, 12, 3, 2, 12}, {7, 1, 12, 7, 2, 12}, {4, 1, 13, 4, 2, 13}, {6, 1, 13, 6, 2, 13}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeHayBaleVertState, biomeHayBaleVertState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2, 1, 0}, {3, 1, 1, 3, 1, 1}, {8, 1, 0, 8, 1, 0}, {7, 1, 1, 7, 1, 1}, {1, 3, 6, 1, 3, 6}, {2, 3, 5, 2, 3, 5}, {8, 3, 5, 8, 3, 5}, {9, 3, 6, 9, 3, 6}, {1, 3, 10, 1, 3, 10}, {2, 3, 11, 2, 3, 11}, {8, 3, 11, 8, 3, 11}, {9, 3, 10, 9, 3, 10}, {1, 3, 6, 1, 3, 6}, {2, 3, 5, 2, 3, 5}, {8, 3, 5, 8, 3, 5}, {9, 3, 6, 9, 3, 6}, {4, 5, 9, 4, 6, 9}, {6, 5, 9, 6, 6, 9}, {4, 5, 7, 4, 6, 7}, {6, 5, 7, 6, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 3, 4, 7, 3, 4}, {3, 3, 12, 7, 3, 12}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{0, 3, 7, 0, 3, 9}, {10, 3, 7, 10, 3, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 4, 11, 7, 4, 11}, {2, 4, 10, 3, 4, 10}, {7, 4, 10, 8, 4, 10}, {1, 4, 8, 1, 4, 8}, {2, 4, 7, 2, 4, 9}, {8, 4, 7, 8, 4, 9}, {9, 4, 8, 9, 4, 8}, {2, 4, 6, 3, 4, 6}, {7, 4, 6, 8, 4, 6}, {3, 4, 5, 7, 4, 5}, {5, 5, 10, 5, 5, 10}, {3, 5, 8, 3, 5, 8}, {7, 5, 8, 7, 5, 8}, {5, 5, 6, 5, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 7, 8, 5, 7, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 7, 9, 4, 7, 9}, {6, 7, 9, 6, 7, 9}, {4, 7, 7, 4, 7, 7}, {6, 7, 7, 6, 7, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 9, 4, 4, 9}, {6, 1, 9, 6, 4, 9}, {4, 1, 7, 4, 4, 7}, {6, 1, 7, 6, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 0, 9, 3, 0, 9}, {6, 0, 9, 5, 0, 9}, {4, 0, 7, 3, 0, 7}, {6, 0, 7, 5, 0, 7}, {1, 1, 7, 1, 1, 9}, {9, 1, 7, 9, 1, 9}, {5, 0, 13, 5, 0, 13}, {5, 0, 3, 5, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFillerState, biomeFillerState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 3, 13, 2}, {5, 3, 13, 2}, {6, 3, 13, 2}, {3, 4, 12, 2}, {4, 4, 12, 2}, {5, 4, 12, 2}, {6, 4, 12, 2}, {7, 4, 12, 2}, {2, 4, 11, 2}, {3, 4, 11, 0}, {7, 4, 11, 1}, {8, 4, 11, 2}, {1, 4, 10, 2}, {2, 4, 10, 0}, {8, 4, 10, 1}, {9, 4, 10, 2}, {0, 4, 9, 2}, {1, 4, 9, 0}, {9, 4, 9, 1}, {10, 4, 9, 2}, {0, 4, 8, 0}, {10, 4, 8, 1}, {0, 4, 7, 3}, {1, 4, 7, 0}, {9, 4, 7, 1}, {10, 4, 7, 3}, {1, 4, 6, 3}, {2, 4, 6, 0}, {8, 4, 6, 1}, {9, 4, 6, 3}, {2, 4, 5, 3}, {3, 4, 5, 0}, {7, 4, 5, 1}, {8, 4, 5, 3}, {3, 4, 4, 3}, {4, 4, 4, 3}, {5, 4, 4, 3}, {6, 4, 4, 3}, {7, 4, 4, 3}, {3, 5, 9, 0}, {7, 5, 9, 1}, {3, 5, 7, 0}, {7, 5, 7, 1}, {4, 5, 11, 2}, {5, 5, 11, 2}, {6, 5, 11, 2}, {3, 5, 10, 2}, {4, 5, 10, 0}, {6, 5, 10, 1}, {7, 5, 10, 2}, {2, 5, 9, 2}, {8, 5, 9, 2}, {2, 5, 8, 0}, {8, 5, 8, 1}, {2, 5, 7, 3}, {8, 5, 7, 3}, {3, 5, 6, 3}, {4, 5, 6, 0}, {6, 5, 6, 1}, {7, 5, 6, 3}, {4, 5, 5, 3}, {5, 5, 5, 3}, {6, 5, 5, 3}, {5, 7, 9, 2}, {4, 7, 8, 0}, {6, 7, 8, 1}, {5, 7, 7, 3}, {4, 3, 3, 3}, {5, 3, 3, 3}, {6, 3, 3, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 4, 10, 2}, {1, 3, 8, 1}, {9, 3, 8, 3}, {5, 4, 6, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{1, 1, 9}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 9;
            int chestV = 1;
            int chestW = 9;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvwoc : (ChestGenHooks)new int[][]{{1, 1, 7, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {9, 1, 7, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    Object orientation = uvwoc[3];
                    reference var34_61 = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    Object v = uvwoc[1];
                    reference var36_63 = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a((int)var34_61, (int)var36_63), this.func_74862_a((int)v), this.func_74873_b((int)var34_61, (int)var36_63), StructureVillageVN.getBedOrientationMeta((int)orientation, this.func_186165_e(), isHead), (int)uvwoc[4]);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 3, 2, 1, 1}, {5, 1, 13, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwg : new int[][]{{2, 1, 1, 1}, {8, 1, 1, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 7, -1, 0}, {8, 1, 7, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleMediumHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"             ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", "    F PP F   ", "      PP     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 12;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 3;
        private static final int DECREASE_MAX_U = 4;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleMediumHouse2() {
        }

        public JungleMediumHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleMediumHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)12, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleMediumHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleMediumHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{3, 0, 3, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 3, 0, 3})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 5, 1, 2}, {8, 1, 2, 11, 1, 2}, {1, 1, 3, 1, 1, 9}, {11, 1, 3, 11, 1, 9}, {1, 1, 10, 11, 1, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 2, 11, 5, 2}, {1, 5, 3, 1, 5, 9}, {11, 5, 3, 11, 5, 9}, {1, 5, 10, 11, 5, 10}, {1, 8, 2, 11, 8, 2}, {1, 8, 3, 1, 8, 9}, {11, 8, 3, 11, 8, 9}, {1, 8, 10, 11, 8, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 2, 2, 1, 4, 2}, {11, 2, 2, 11, 4, 2}, {1, 2, 10, 1, 4, 10}, {11, 2, 10, 11, 4, 10}, {1, 6, 2, 1, 7, 2}, {11, 6, 2, 11, 7, 2}, {1, 6, 10, 1, 7, 10}, {11, 6, 10, 11, 7, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 2, 10, 4, 2}, {2, 3, 2, 2, 3, 2}, {4, 3, 2, 5, 3, 2}, {8, 3, 2, 8, 3, 2}, {10, 3, 2, 10, 3, 2}, {2, 2, 2, 5, 2, 2}, {8, 2, 2, 10, 2, 2}, {2, 6, 2, 2, 7, 2}, {4, 6, 2, 4, 7, 2}, {6, 6, 2, 6, 7, 2}, {8, 6, 2, 8, 7, 2}, {10, 6, 2, 10, 7, 2}, {1, 4, 3, 1, 4, 9}, {1, 3, 3, 1, 3, 3}, {1, 3, 5, 1, 3, 5}, {1, 3, 7, 1, 3, 7}, {1, 3, 9, 1, 3, 9}, {1, 2, 3, 1, 2, 9}, {1, 6, 3, 1, 7, 3}, {1, 6, 5, 1, 7, 5}, {1, 6, 7, 1, 7, 7}, {1, 6, 9, 1, 7, 9}, {1, 9, 4, 1, 9, 5}, {1, 10, 6, 1, 10, 6}, {1, 9, 7, 1, 9, 8}, {11, 4, 3, 11, 4, 9}, {11, 3, 3, 11, 3, 3}, {11, 3, 5, 11, 3, 5}, {11, 3, 7, 11, 3, 7}, {11, 3, 9, 11, 3, 9}, {11, 2, 3, 11, 2, 9}, {11, 6, 3, 11, 7, 3}, {11, 6, 5, 11, 7, 5}, {11, 6, 7, 11, 7, 7}, {11, 6, 9, 11, 7, 9}, {11, 9, 4, 11, 9, 5}, {11, 10, 6, 11, 10, 6}, {11, 9, 7, 11, 9, 8}, {2, 4, 10, 10, 4, 10}, {2, 3, 10, 2, 3, 10}, {4, 3, 10, 4, 3, 10}, {6, 3, 10, 6, 3, 10}, {8, 3, 10, 8, 3, 10}, {10, 3, 10, 10, 3, 10}, {2, 2, 10, 10, 2, 10}, {2, 6, 10, 2, 7, 10}, {4, 6, 10, 4, 7, 10}, {6, 6, 10, 6, 7, 10}, {8, 6, 10, 8, 7, 10}, {10, 6, 10, 10, 7, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), false);
            }
            for (int[] uvwoc : new int[][]{{6, 3, 2, 1, GeneralConfig.useVillageColors ? this.townColor : 0}, {7, 3, 2, 2, GeneralConfig.useVillageColors ? this.townColor : 0}, {7, 0, 2, 0, GeneralConfig.useVillageColors ? this.townColor : 0}, {6, 0, 2, 1, GeneralConfig.useVillageColors ? this.townColor : 0}, {6, 0, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 0}, {7, 0, 3, 3, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 9, 3, 1, 9, 3}, {1, 10, 5, 1, 10, 5}, {1, 10, 7, 1, 10, 7}, {1, 9, 9, 1, 9, 9}, {11, 9, 3, 11, 9, 3}, {11, 10, 5, 11, 10, 5}, {11, 10, 7, 11, 10, 7}, {11, 9, 9, 11, 9, 9}, {2, 1, 3, 5, 1, 9}, {6, 1, 5, 7, 1, 9}, {8, 1, 3, 8, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 8, 1, 12, 8, 1}, {0, 9, 3, 0, 9, 3}, {2, 9, 3, 10, 9, 3}, {12, 9, 3, 12, 9, 3}, {0, 10, 5, 0, 10, 5}, {2, 10, 5, 10, 10, 5}, {12, 10, 5, 12, 10, 5}, {0, 10, 7, 0, 10, 7}, {2, 10, 7, 10, 10, 7}, {12, 10, 7, 12, 10, 7}, {0, 9, 9, 0, 9, 9}, {2, 9, 9, 10, 9, 9}, {12, 9, 9, 12, 9, 9}, {0, 8, 11, 12, 8, 11}, {2, 4, 3, 2, 4, 8}, {3, 4, 3, 5, 4, 9}, {6, 4, 3, 7, 4, 4}, {6, 4, 9, 7, 4, 9}, {8, 4, 3, 10, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 9, 2, 12, 9, 2}, {0, 10, 4, 12, 10, 4}, {0, 11, 6, 12, 11, 6}, {0, 10, 8, 12, 10, 8}, {0, 9, 10, 12, 9, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 9, 6, 4, 10, 6}, {8, 9, 6, 8, 10, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{6, 1, 4, 3}, {7, 1, 4, 3}, {2, 2, 3, 2}, {2, 2, 5, 3}, {6, 2, 6, 3}, {7, 2, 6, 3}, {6, 2, 7, 6}, {7, 2, 7, 6}, {6, 3, 7, 3}, {7, 3, 7, 3}, {6, 3, 8, 6}, {7, 3, 8, 6}, {6, 4, 8, 3}, {7, 4, 8, 3}, {6, 4, 9, 6}, {7, 4, 9, 6}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 3, 3, 0}, {4, 3, 9, 2}, {8, 3, 9, 2}, {10, 3, 5, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 8, 6}, {8, 8, 6}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 3, 2}, {9, 3, 2}, {3, 6, 2}, {3, 7, 2}, {5, 6, 2}, {5, 7, 2}, {7, 6, 2}, {7, 7, 2}, {9, 6, 2}, {9, 7, 2}, {3, 3, 10}, {5, 3, 10}, {7, 3, 10}, {9, 3, 10}, {3, 6, 10}, {3, 7, 10}, {5, 6, 10}, {5, 7, 10}, {7, 6, 10}, {7, 7, 10}, {9, 6, 10}, {9, 7, 10}, {1, 3, 4}, {1, 3, 6}, {1, 3, 8}, {1, 6, 4}, {1, 7, 4}, {1, 6, 6}, {1, 7, 6}, {1, 6, 8}, {1, 7, 8}, {11, 3, 4}, {11, 3, 6}, {11, 3, 8}, {11, 6, 4}, {11, 7, 4}, {11, 6, 6}, {11, 7, 6}, {11, 6, 8}, {11, 7, 8}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3}, {4, 1, 0, 2}, {5, 1, 1, 1}, {8, 1, 1, 3}, {9, 1, 0, 2}, {10, 1, 1, 1}, {5, 2, 7, 3}, {5, 3, 8, 3}, {8, 2, 7, 1}, {8, 3, 8, 1}, {0, 9, 6, 3}, {2, 9, 6, 1}, {10, 9, 6, 3}, {12, 9, 6, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{2, 2, 4}, {10, 2, 4}, {10, 2, 6}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 2, 3, 1}, {3, 2, 5, 1}}) {
                int signX = this.func_74865_a(uvwo[0], uvwo[2]);
                int signY = this.func_74862_a(uvwo[1]);
                int signZ = this.func_74873_b(uvwo[0], uvwo[2]);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(uvwo[3], this.func_186165_e().func_176736_b(), true)), 2);
            }
            IBlockState biomeBrickWallState = null;
            IBlockState biomeBrickBlockState = Blocks.field_150336_V.func_176223_P();
            biomeBrickWallState = ModObjects.chooseModBrickWallState();
            if (biomeBrickWallState == null) {
                biomeBrickWallState = Blocks.field_150463_bK.func_176203_a(0);
                biomeBrickBlockState = Blocks.field_150347_e.func_176203_a(0);
            }
            biomeBrickWallState = StructureVillageVN.getBiomeSpecificBlockState(biomeBrickWallState, this.materialType, this.biome, this.disallowModSubs);
            biomeBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(biomeBrickBlockState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 9, 2, 3, 9}, {2, 5, 9, 2, 8, 9}, {2, 10, 9, 2, 10, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBrickWallState, biomeBrickWallState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 9, 2, 4, 9}, {2, 9, 9, 2, 9, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeBrickBlockState, biomeBrickBlockState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 9, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState polishedGraniteState = Blocks.field_150348_b.func_176203_a(2);
            for (int[] uvw : new int[][]{{3, 2, 9}}) {
                this.func_175811_a(world, polishedGraniteState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{4, 2, 9}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{9, 2, 9, 9, 2, 9}, {10, 2, 9, 10, 3, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            IBlockState woolBlockState = Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0);
            for (int[] uuvvww : new int[][]{{9, 1, 3, 10, 1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], woolBlockState, woolBlockState, false);
            }
            for (int[] uvwoc : new int[][]{{5, 3, 1, 2, 0}, {8, 3, 1, 2, 0}, {5, 3, 3, 0, 0}, {8, 3, 3, 0, 0}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                if (GeneralConfig.useVillageColors) {
                    NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = new ItemStack(Items.field_179564_cE);
                    villageBanner.func_77983_a("BlockEntityTag", (NBTBase)villageNBTtag.func_74775_l("BlockEntityTag"));
                    tilebanner.func_175112_a(villageBanner, false);
                } else {
                    modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 1, 2, 2, 1, 1}, {7, 1, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 1, 1, 4, 1, 1}, {9, 1, 1, 9, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150349_c.func_176223_P(), Blocks.field_150349_c.func_176223_P(), false);
            }
            for (int[] uwg : new int[][]{{4, 2, 1, 0}, {9, 2, 1, 0}}) {
                if (uwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(2), uwg[0], uwg[1], uwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(3), uwg[0], uwg[1], uwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], uwg[1] + 1, uwg[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 5, 8, 2, GeneralConfig.useVillageColors ? this.townColor : 0}, {9, 5, 8, 2, GeneralConfig.useVillageColors ? this.townColor : 0}, {3, 5, 4, 0, GeneralConfig.useVillageColors ? this.townColor : 0}, {9, 5, 4, 0, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 5, 8, -1, 0}, {8, 5, 8, -1, 0}, {4, 5, 4, -1, 0}, {8, 5, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleMediumHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFPPFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 13;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleMediumHouse1() {
        }

        public JungleMediumHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleMediumHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)13, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleMediumHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleMediumHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{3, 0, 0, 3, 0, 0}, {6, 0, 0, 6, 0, 0}, {0, 1, 0, 3, 1, 0}, {6, 1, 0, 11, 1, 0}, {0, 1, 1, 0, 1, 2}, {11, 1, 1, 11, 1, 10}, {0, 1, 11, 11, 1, 11}, {4, 1, 2, 5, 1, 2}, {0, 1, 10, 1, 2, 10}, {0, 1, 11, 2, 2, 11}, {2, 1, 10, 2, 1, 10}, {0, 1, 3, 9, 2, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{4, 1, 1, 5, 1, 1, 3}, {4, 2, 2, 5, 2, 2, 3}, {2, 2, 10, 2, 2, 10, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 1, 0, 2, 2}, {0, 2, 0, 3, 2, 0}, {6, 2, 0, 11, 2, 0}, {11, 2, 1, 11, 2, 10}, {3, 2, 11, 11, 2, 11}, {0, 3, 3, 3, 3, 3}, {6, 3, 3, 9, 3, 3}, {9, 3, 4, 9, 3, 4}, {0, 3, 11, 2, 3, 11}, {0, 3, 4, 0, 3, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 3, 5, 3, 9, 5}, {9, 3, 5, 9, 9, 5}, {3, 3, 9, 3, 9, 9}, {9, 3, 9, 9, 9, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 3, 5, 4, 7, 5}, {4, 9, 5, 4, 9, 5}, {5, 3, 5, 5, 3, 5}, {5, 5, 5, 5, 9, 5}, {6, 3, 5, 6, 6, 5}, {6, 9, 5, 6, 9, 5}, {7, 5, 5, 7, 9, 5}, {8, 3, 5, 8, 7, 5}, {8, 9, 5, 8, 9, 5}, {3, 3, 6, 3, 9, 6}, {3, 3, 7, 3, 3, 7}, {3, 5, 7, 3, 7, 7}, {3, 9, 7, 3, 9, 7}, {3, 3, 8, 3, 9, 8}, {9, 3, 6, 9, 9, 6}, {9, 3, 7, 9, 3, 7}, {9, 5, 7, 9, 7, 7}, {9, 9, 7, 9, 9, 7}, {9, 3, 8, 9, 9, 8}, {4, 3, 9, 4, 4, 9}, {4, 6, 9, 4, 7, 9}, {4, 9, 9, 4, 9, 9}, {5, 3, 9, 5, 9, 9}, {6, 3, 9, 6, 5, 9}, {6, 8, 9, 6, 9, 9}, {7, 3, 9, 7, 9, 9}, {8, 3, 9, 8, 4, 9}, {8, 6, 9, 8, 7, 9}, {8, 9, 9, 8, 9, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 6, 3, 3, 6, 3}, {6, 6, 3, 6, 6, 3}, {9, 6, 3, 9, 6, 3}, {3, 10, 3, 9, 10, 9}, {5, 11, 5, 7, 11, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 5, 3, 1, 5, 10}, {4, 6, 3, 5, 6, 3}, {7, 6, 3, 8, 6, 3}, {3, 6, 4, 9, 6, 4}, {4, 6, 6, 8, 6, 7}, {4, 6, 8, 4, 6, 8}, {8, 3, 8, 8, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 5, 3, 0, 5, 11}, {2, 6, 3, 2, 6, 9}, {2, 10, 2, 10, 10, 2}, {2, 10, 10, 10, 10, 10}, {2, 10, 3, 2, 10, 9}, {10, 10, 3, 10, 10, 9}, {4, 11, 4, 8, 11, 4}, {4, 11, 8, 8, 11, 8}, {4, 11, 5, 4, 11, 7}, {8, 11, 5, 8, 11, 7}, {6, 12, 6, 6, 12, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 3, 0, 4, 3}, {0, 4, 11, 0, 4, 11}, {3, 7, 3, 3, 7, 4}, {4, 7, 3, 8, 7, 3}, {9, 7, 3, 9, 7, 4}, {3, 4, 3, 3, 5, 3}, {6, 4, 3, 6, 5, 3}, {9, 4, 3, 9, 5, 3}, {3, 8, 3, 3, 9, 3}, {9, 8, 3, 9, 9, 3}, {5, 9, 8, 5, 9, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 3, 8, 0}, {6, 4, 8, 0}, {7, 5, 8, 0}, {8, 6, 8, 0}, {6, 3, 8, 5}, {7, 4, 8, 5}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{0, 3, 0, -1}, {3, 3, 0, -1}, {6, 3, 0, -1}, {11, 3, 0, -1}, {2, 4, 11, -1}, {11, 3, 0, -1}, {11, 3, 11, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{8, 4, 8}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{5, 8, 8}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{5, 4, 5}, {4, 8, 5}, {8, 8, 5}, {4, 5, 9}, {8, 5, 9}, {6, 6, 9}, {6, 7, 9}, {4, 8, 9}, {8, 8, 9}, {3, 4, 7}, {3, 8, 7}, {9, 4, 7}, {9, 8, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{8, 3, 7, 2}, {7, 3, 8, 3}, {5, 7, 7, 2}, {6, 7, 7, 2}, {7, 7, 7, 2}, {5, 7, 8, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{7, 3, 5, 2, 1, 0}, {6, 7, 5, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 3, 1, 2}, {6, 1, 1, 10, 1, 2}, {10, 1, 3, 10, 1, 10}, {3, 1, 10, 9, 1, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150349_c.func_176223_P(), Blocks.field_150349_c.func_176223_P(), false);
            }
            for (int[] uvwg : new int[][]{{10, 2, 4, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 1, 1, 2, 1}, {10, 2, 1, 10, 2, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            for (int[] uvwoc : new int[][]{{4, 7, 7, 2, GeneralConfig.useVillageColors ? this.townColor3 : 0}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{3, 2, 2, 2}, {3, 3, 2, 2}, {3, 4, 2, 2}, {3, 5, 2, 2}, {3, 6, 2, 2}, {9, 2, 2, 2}, {9, 3, 2, 2}, {9, 4, 2, 2}, {9, 5, 2, 2}, {9, 6, 2, 2}, {10, 8, 6, 1}, {10, 9, 6, 1}, {10, 9, 7, 1}, {5, 9, 10, 0}, {5, 9, 10, 0}, {5, 3, 10, 0}, {5, 4, 10, 0}, {5, 5, 10, 0}, {5, 6, 10, 0}, {6, 6, 10, 0}, {6, 7, 10, 0}, {6, 8, 10, 0}, {6, 9, 10, 0}, {6, 10, 10, 0}, {7, 2, 10, 0}, {7, 3, 10, 0}, {7, 4, 10, 0}, {7, 5, 10, 0}, {7, 6, 10, 0}, {7, 7, 10, 0}, {7, 8, 10, 0}, {7, 9, 10, 0}, {8, 6, 10, 0}, {8, 7, 10, 0}, {8, 9, 10, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 7, 6, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleMasonHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF  ", "FFFFFFFFFFF  ", "FFFFFFFFFFF  ", "FFFFFFFFFFF  ", "FFFFFFFFFFF  ", "FFFFFFFFFFF  ", "FFFFFFFFFFFF ", "FFPFPFFFFFFFF", "FFPPFPFFFFFFF", "FFFPPFFFFFFFF", "FFFFPFFFFFFF ", "    FFFFFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 5;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleMasonHouse() {
        }

        public JungleMasonHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleMasonHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleMasonHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleMasonHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{5, 0, 5, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 5, 0, 5})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 6, 1, 1, 8}, {2, 1, 6, 2, 1, 6}, {2, 1, 8, 2, 1, 10}, {3, 1, 6, 3, 1, 6}, {3, 1, 8, 3, 1, 8}, {3, 1, 10, 3, 1, 10}, {4, 1, 6, 4, 1, 6}, {4, 1, 9, 4, 1, 9}, {5, 1, 9, 5, 1, 9}, {6, 1, 7, 6, 1, 7}, {6, 1, 9, 6, 1, 10}, {7, 1, 7, 7, 1, 7}, {7, 1, 9, 7, 1, 9}, {8, 1, 6, 8, 1, 6}, {8, 1, 8, 8, 1, 9}, {9, 1, 7, 9, 1, 8}, {9, 1, 10, 9, 1, 10}, {10, 1, 7, 10, 1, 7}, {10, 1, 9, 10, 1, 10}, {1, 3, 6, 1, 3, 6}, {1, 2, 10, 1, 2, 10}, {5, 3, 10, 5, 3, 10}, {1, 5, 7, 1, 5, 7}, {2, 5, 10, 3, 5, 10}, {3, 5, 6, 3, 5, 6}, {5, 5, 9, 5, 5, 9}, {3, 6, 8, 3, 6, 8}, {6, 1, 1, 7, 1, 1}, {9, 1, 1, 9, 1, 1}, {5, 1, 2, 11, 1, 2}, {7, 2, 2, 9, 2, 2}, {7, 1, 3, 9, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomeMossyStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 9, 1, 1, 10}, {2, 1, 7, 2, 1, 7}, {3, 1, 7, 3, 1, 7}, {3, 1, 9, 3, 1, 9}, {4, 1, 7, 4, 1, 8}, {4, 1, 10, 4, 1, 10}, {5, 1, 6, 5, 1, 8}, {5, 1, 10, 5, 1, 10}, {6, 1, 6, 7, 1, 6}, {6, 1, 8, 7, 1, 8}, {7, 1, 10, 7, 1, 10}, {8, 1, 7, 8, 1, 7}, {8, 1, 10, 8, 1, 10}, {9, 1, 6, 9, 1, 6}, {9, 1, 9, 9, 1, 9}, {10, 1, 6, 10, 1, 6}, {10, 1, 8, 10, 1, 8}, {1, 2, 6, 1, 2, 6}, {1, 3, 10, 1, 3, 10}, {5, 1, 6, 5, 3, 6}, {5, 2, 10, 5, 2, 10}, {1, 5, 8, 1, 5, 9}, {2, 5, 6, 3, 5, 6}, {4, 5, 6, 4, 5, 6}, {4, 5, 10, 4, 5, 10}, {5, 5, 7, 5, 5, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeMossyStoneBrickState, biomeMossyStoneBrickState, false);
            }
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{1, 4, 10}, {5, 4, 10}, {1, 4, 6}, {5, 4, 6}}) {
                this.func_175811_a(world, biomeChiseledStoneBrickState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{2, 1, 5, 0}, {3, 1, 5, 3}, {4, 1, 5, 1}, {2, 6, 9, 0}, {3, 6, 9, 2}, {4, 6, 9, 1}, {2, 6, 8, 0}, {4, 6, 8, 1}, {2, 6, 7, 0}, {3, 6, 7, 3}, {4, 6, 7, 1}, {9, 2, 7, 3}, {6, 1, 3, 0}, {8, 1, 1, 0}, {8, 1, 4, 2}, {10, 1, 1, 3}, {10, 2, 2, 2}, {10, 1, 3, 1}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(5), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{7, 2, 9}, {8, 2, 3}}) {
                this.func_175811_a(world, biomeStoneBrickSlabLowerState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePolishedStoneSlabDoubleState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150334_T.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 1, 1}, {0, 1, 3}, {1, 1, 4}}) {
                this.func_175811_a(world, biomePolishedStoneSlabDoubleState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePolishedStoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 2, 3}, {1, 1, 2}, {6, 2, 2}}) {
                this.func_175811_a(world, biomePolishedStoneSlabLowerState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickWallStone = ModObjects.chooseModStoneBrickWallState();
            biomeStoneBrickWallStone = StructureVillageVN.getBiomeSpecificBlockState(biomeStoneBrickWallStone != null ? biomeStoneBrickWallStone : Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 2, 6, 10, 2, 6}, {10, 2, 7, 10, 2, 9}, {6, 2, 10, 10, 2, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickWallStone, biomeStoneBrickWallStone, false);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 6, 2, 4, 6}, {3, 4, 6, 3, 4, 6}, {4, 2, 6, 4, 4, 6}, {5, 2, 7, 5, 4, 7}, {5, 4, 8, 5, 4, 8}, {5, 2, 9, 5, 4, 9}, {1, 2, 7, 1, 4, 7}, {1, 2, 8, 1, 2, 8}, {1, 4, 8, 1, 4, 8}, {1, 2, 9, 1, 4, 9}, {2, 2, 10, 2, 4, 10}, {3, 2, 10, 3, 2, 10}, {3, 4, 10, 3, 4, 10}, {4, 2, 10, 4, 4, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor4 : 9), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor4 : 9), false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 5, 2}, {4, 3, 5, 2}, {6, 3, 7, 1}, {6, 3, 9, 1}, {0, 3, 7, 3}, {0, 3, 9, 3}, {2, 3, 11, 0}, {4, 3, 11, 0}, {3, 4, 9, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 2, 9, 1}, {4, 2, 9, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 3, 8}, {3, 3, 10}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{7, 1, 4, StructureVillageVN.chooseFurnaceMeta(1, this.func_186165_e())}, {7, 2, 3, StructureVillageVN.chooseFurnaceMeta(1, this.func_186165_e())}, {7, 3, 2, 1}, {7, 2, 1, StructureVillageVN.chooseFurnaceMeta(3, this.func_186165_e())}, {7, 1, 0, StructureVillageVN.chooseFurnaceMeta(3, this.func_186165_e())}, {9, 1, 4, StructureVillageVN.chooseFurnaceMeta(1, this.func_186165_e())}, {9, 2, 3, StructureVillageVN.chooseFurnaceMeta(1, this.func_186165_e())}, {9, 3, 2, 1}, {9, 2, 1, StructureVillageVN.chooseFurnaceMeta(3, this.func_186165_e())}, {9, 1, 0, StructureVillageVN.chooseFurnaceMeta(3, this.func_186165_e())}}) {
                this.func_175811_a(world, Blocks.field_150448_aq.func_176203_a(uvwo[3]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 6, 2, 1, 0}, {5, 2, 8, 1, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{3, 2, 9}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            this.func_175811_a(world, ModObjects.chooseModStonecutterState(3, this.func_186165_e()), 8, 2, 8, structureBB);
            if (!this.entitiesGenerated) {
                int v;
                this.entitiesGenerated = true;
                int s = random.nextInt(30);
                int u = s <= 3 ? 2 : (s <= 7 ? 3 : (s <= 11 ? 4 : (s <= 13 ? 2 : (s <= 15 ? 3 : (s <= 17 ? 4 : (s <= 20 ? 6 : (s <= 22 ? 7 : (s <= 24 ? 8 : 9))))))));
                int n = v = s <= 11 ? 1 : 2;
                int w = s <= 3 ? s + 1 : (s <= 7 ? s - 3 : (s <= 11 ? s - 10 : (s <= 13 ? s - 5 : (s <= 15 ? s - 7 : (s <= 17 ? s - 9 : (s <= 20 ? s - 11 : (s <= 22 ? s - 14 : (s <= 23 ? s - 16 : (s <= 24 ? s - 15 : s - 17)))))))));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class JungleLibrary
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"           ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", "    FPF    ", "    PPP    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 14;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleLibrary() {
        }

        public JungleLibrary(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleLibrary buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)14, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleLibrary.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleLibrary(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{2, 0, 11, 8, 0, 11}, {1, 0, 2, 1, 0, 11}, {9, 0, 2, 9, 0, 11}, {2, 0, 2, 8, 0, 2}, {1, 1, 2, 4, 1, 2}, {6, 1, 2, 9, 1, 2}, {1, 1, 3, 1, 1, 10}, {9, 1, 3, 9, 1, 10}, {1, 1, 11, 9, 1, 11}, {4, 0, 1, 4, 1, 1}, {6, 0, 1, 6, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 6, 2, 9, 6, 2}, {1, 7, 4, 9, 7, 4}, {1, 8, 6, 3, 8, 7}, {7, 8, 6, 9, 8, 7}, {1, 7, 9, 9, 7, 9}, {1, 6, 11, 9, 6, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{1, 7, 8, 9, 7, 8}, {1, 7, 5, 9, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState concreteBlockState = Blocks.field_192443_dR.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0);
            for (int[] uuvvww : new int[][]{{1, 2, 2, 2, 3, 2}, {4, 2, 2, 4, 3, 2}, {5, 3, 2, 5, 3, 2}, {8, 2, 2, 9, 3, 2}, {6, 2, 2, 6, 3, 2}, {1, 4, 2, 9, 5, 2}, {1, 2, 3, 1, 3, 3}, {1, 2, 5, 1, 3, 8}, {1, 2, 10, 1, 3, 10}, {1, 4, 3, 1, 6, 10}, {0, 7, 5, 0, 7, 5}, {0, 7, 8, 0, 7, 8}, {9, 2, 3, 9, 3, 3}, {9, 2, 5, 9, 3, 8}, {9, 2, 10, 9, 3, 10}, {9, 4, 3, 9, 6, 10}, {10, 7, 5, 10, 7, 5}, {10, 7, 8, 10, 7, 8}, {1, 2, 11, 2, 3, 11}, {4, 2, 11, 4, 3, 11}, {8, 2, 11, 9, 3, 11}, {6, 2, 11, 6, 3, 11}, {1, 4, 11, 9, 5, 11}, {4, 8, 5, 6, 9, 5}, {4, 8, 8, 6, 9, 8}, {4, 8, 6, 4, 9, 7}, {6, 8, 6, 6, 9, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], concreteBlockState, concreteBlockState, false);
            }
            for (int[] uvwo : new int[][]{{5, 3, 1, 2}, {5, 4, 3, 0}, {5, 4, 10, 2}, {2, 4, 4, 1}, {2, 4, 9, 1}, {8, 4, 4, 3}, {8, 4, 9, 3}, {5, 8, 6, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 5, 1, 4, 5, 1}, {6, 5, 1, 6, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{4, 2, 1, 4, 4, 1}, {6, 2, 1, 6, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 4, 1, 3}, {5, 4, 1, 3}, {7, 4, 1, 3}, {3, 4, 12, 2}, {5, 4, 12, 2}, {7, 4, 12, 2}, {0, 4, 3, 3}, {0, 4, 4, 0}, {0, 4, 5, 2}, {0, 4, 8, 3}, {0, 4, 9, 0}, {0, 4, 10, 2}, {10, 4, 3, 3}, {10, 4, 4, 1}, {10, 4, 5, 2}, {10, 4, 8, 3}, {10, 4, 9, 1}, {10, 4, 10, 2}, {0, 6, 2, 4}, {0, 7, 4, 4}, {0, 8, 6, 4}, {10, 6, 2, 5}, {10, 7, 4, 5}, {10, 8, 6, 5}, {0, 6, 11, 4}, {0, 7, 9, 4}, {0, 8, 7, 4}, {10, 6, 11, 5}, {10, 7, 9, 5}, {10, 8, 7, 5}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 6, 1, 10, 6, 1}, {0, 7, 3, 10, 7, 3}, {0, 8, 5, 3, 8, 5}, {7, 8, 5, 10, 8, 5}, {0, 6, 12, 10, 6, 12}, {0, 7, 10, 10, 7, 10}, {0, 8, 8, 3, 8, 8}, {7, 8, 8, 10, 8, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 3, 8, 6, 3}, {2, 6, 10, 8, 6, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 8, 4, 4, 8, 4}, {6, 8, 4, 6, 8, 4}, {4, 8, 9, 4, 8, 9}, {6, 8, 9, 6, 8, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{0, 6, 3, 0, 6, 10, 4}, {10, 6, 3, 10, 6, 10, 5}, {4, 10, 5, 6, 10, 5, 3}, {4, 10, 8, 6, 10, 8, 2}, {4, 10, 6, 4, 10, 7, 0}, {6, 10, 6, 6, 10, 7, 1}, {4, 12, 5, 6, 12, 5, 3}, {4, 12, 8, 6, 12, 8, 2}, {4, 12, 6, 4, 12, 7, 0}, {6, 12, 6, 6, 12, 7, 1}, {5, 13, 6, 5, 13, 6, 3}, {5, 13, 7, 5, 13, 7, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvw : new int[][]{{3, 2, 2}, {3, 3, 2}, {7, 2, 2}, {7, 3, 2}, {3, 2, 11}, {3, 3, 11}, {5, 2, 11}, {5, 3, 11}, {7, 2, 11}, {7, 3, 11}, {1, 2, 4}, {1, 3, 4}, {1, 2, 9}, {1, 3, 9}, {0, 7, 6}, {0, 7, 7}, {9, 2, 4}, {9, 3, 4}, {9, 2, 9}, {9, 3, 9}, {10, 7, 6}, {10, 7, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 11, 5, 6, 11, 5}, {4, 11, 6, 4, 11, 7}, {6, 11, 6, 6, 11, 7}, {4, 11, 8, 6, 11, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int[] uvwo : new int[][]{{5, 1, 10, 2}}) {
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState), -1);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 2, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 3, 2, 4, 3}, {2, 1, 6, 2, 4, 7}, {2, 1, 10, 2, 4, 10}, {8, 1, 3, 8, 4, 3}, {8, 1, 6, 8, 4, 7}, {8, 1, 10, 8, 4, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            int woolMeta = GeneralConfig.useVillageColors ? this.townColor3 : 14;
            for (int[] uvwm : new int[][]{{2, 0, 3, 8, 0, 10}}) {
                this.func_175804_a(world, structureBB, uvwm[0], uvwm[1], uvwm[2], uvwm[3], uvwm[4], uvwm[5], Blocks.field_150325_L.func_176203_a(woolMeta), Blocks.field_150325_L.func_176203_a(woolMeta), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(5);
                int v = 1;
                int w = 3 + random.nextInt(7);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class JungleLargeHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"                      ", "       FFFFFFFFF      ", "       FFFFFFFFF      ", "FFF    FFFFFFFFF      ", "FFF    FFFFFFFFF      ", "FFF    FFFFFFFFF      ", "FFF    FFFFFFFFFFFFFF ", "PPP    FFFFFFFFFFFFFF ", "PPPP   FFFFFFFFFFFFFF ", " PPP   FFFFFFFFFFFFFF ", " PPPP  FFFFFFFFFFFFFF ", "  PPP  FFFFFFFFFFFFFF ", "  PPPP FFFFFFFFFFFFFF ", "   PPP FFFFFFFFF      ", "   PPP                "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 12;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 15;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleLargeHouse() {
        }

        public JungleLargeHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleLargeHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)12, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleLargeHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleLargeHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{15, 0, 15, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 15, 0, 15})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{7, 0, 1, 15, 0, 13}, {16, 0, 2, 20, 0, 8}, {0, 1, 9, 2, 1, 11}, {0, 2, 10, 2, 2, 11}, {6, 3, 9, 6, 3, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{0, 1, 8, 1}, {1, 1, 8, 3}, {2, 1, 8, 0}, {0, 2, 9, 1}, {1, 2, 9, 3}, {2, 2, 9, 0}, {2, 3, 10, 0}, {3, 3, 9, 5}, {3, 3, 10, 5}, {3, 3, 11, 5}, {3, 4, 10, 0}, {4, 4, 9, 5}, {4, 4, 10, 5}, {4, 4, 11, 5}, {5, 4, 9, 4}, {5, 4, 10, 4}, {5, 4, 11, 4}, {6, 2, 9, 4}, {6, 2, 10, 4}, {6, 2, 11, 4}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 8, 0, 2, 8}, {0, 3, 8, 0, 3, 11}, {1, 3, 11, 2, 3, 11}, {2, 4, 11, 3, 4, 11}, {3, 5, 11, 4, 5, 11}, {2, 2, 8, 2, 2, 8}, {2, 3, 8, 2, 3, 9}, {2, 4, 9, 3, 4, 9}, {3, 5, 9, 4, 5, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{15, 1, 2, 15, 8, 2}, {15, 1, 8, 15, 8, 8}, {11, 5, 8, 11, 7, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogHorizAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAcrossState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                }
            }
            for (int[] uuvvww : new int[][]{{7, 8, 1, 15, 8, 1}, {16, 8, 2, 20, 8, 2}, {7, 8, 13, 15, 8, 13}, {16, 8, 8, 20, 8, 8}, {7, 4, 1, 15, 4, 1}, {16, 4, 2, 20, 4, 2}, {7, 4, 13, 15, 4, 13}, {16, 4, 8, 20, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAcrossState, biomeStrippedLogHorizAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeStrippedLogHorizAlongState = biomeLogHorAlongState;
            if (biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogHorizAlongState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogHorizAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            for (int[] uuvvww : new int[][]{{7, 4, 2, 7, 4, 12}, {7, 8, 2, 7, 8, 12}, {20, 4, 3, 20, 4, 7}, {15, 4, 9, 15, 4, 12}, {20, 8, 3, 20, 8, 7}, {15, 8, 9, 15, 8, 12}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogHorizAlongState, biomeStrippedLogHorizAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{8, 4, 3, 8, 4, 3}, {11, 4, 5, 13, 4, 5}, {12, 4, 4, 12, 4, 4}, {12, 4, 6, 12, 4, 6}, {8, 1, 12, 8, 1, 12}, {14, 1, 12, 14, 1, 12}, {18, 5, 3, 19, 5, 7}, {8, 9, 1, 8, 9, 1}, {10, 10, 1, 10, 10, 1}, {12, 10, 1, 12, 10, 1}, {14, 9, 1, 14, 9, 1}, {20, 9, 3, 20, 9, 3}, {20, 10, 5, 20, 10, 5}, {20, 9, 7, 20, 9, 7}, {8, 9, 13, 8, 9, 13}, {10, 10, 13, 10, 10, 13}, {12, 10, 13, 12, 10, 13}, {14, 9, 13, 14, 9, 13}, {17, 10, 5, 17, 10, 5}, {6, 4, 9, 6, 4, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 5, 1, 6, 5, 1}, {5, 5, 1, 5, 5, 9}, {5, 5, 11, 5, 5, 13}, {6, 5, 13, 6, 5, 13}, {5, 6, 1, 5, 7, 1}, {5, 6, 3, 5, 7, 3}, {5, 6, 5, 5, 7, 5}, {5, 6, 7, 5, 7, 7}, {5, 6, 9, 5, 7, 9}, {5, 6, 11, 5, 7, 11}, {5, 6, 13, 5, 7, 13}, {11, 8, 8, 11, 8, 12}, {12, 8, 8, 14, 8, 8}, {15, 8, 3, 15, 8, 7}, {9, 5, 3, 13, 5, 3}, {13, 5, 2, 13, 5, 2}, {11, 10, 5, 11, 10, 5}, {10, 9, 5, 12, 9, 5}, {11, 8, 4, 11, 8, 6}, {17, 9, 5, 17, 9, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{0, 4, 8, -1}, {0, 4, 11, -1}, {4, 6, 11, -1}, {2, 4, 8, -1}, {4, 6, 9, -1}, {6, 6, 1, -1}, {6, 6, 13, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{7, 1, 1, 7, 3, 1}, {8, 1, 1, 8, 1, 1}, {9, 1, 1, 9, 3, 1}, {10, 1, 1, 10, 1, 1}, {11, 1, 1, 11, 3, 1}, {12, 1, 1, 12, 1, 1}, {13, 1, 1, 13, 3, 1}, {14, 1, 1, 14, 1, 1}, {15, 1, 1, 15, 3, 1}, {16, 1, 2, 16, 3, 2}, {17, 1, 2, 17, 1, 2}, {18, 1, 2, 18, 3, 2}, {19, 1, 2, 19, 1, 2}, {20, 1, 2, 20, 3, 2}, {20, 1, 3, 20, 1, 3}, {20, 1, 4, 20, 3, 4}, {20, 1, 5, 20, 1, 5}, {20, 1, 6, 20, 3, 6}, {20, 1, 7, 20, 1, 7}, {20, 1, 8, 20, 3, 8}, {15, 1, 9, 15, 3, 9}, {15, 1, 10, 15, 1, 10}, {15, 1, 11, 15, 3, 11}, {15, 1, 12, 15, 1, 12}, {7, 1, 2, 7, 1, 2}, {7, 1, 3, 7, 3, 3}, {7, 1, 4, 7, 1, 4}, {7, 1, 5, 7, 3, 5}, {7, 1, 6, 7, 1, 6}, {7, 1, 7, 7, 3, 13}, {19, 1, 8, 19, 1, 8}, {18, 1, 8, 18, 3, 8}, {17, 1, 8, 17, 1, 8}, {16, 1, 8, 16, 3, 8}, {15, 1, 13, 15, 3, 13}, {14, 1, 13, 14, 1, 13}, {13, 1, 13, 13, 3, 13}, {12, 1, 13, 12, 1, 13}, {11, 1, 13, 11, 3, 13}, {10, 1, 13, 10, 1, 13}, {9, 1, 13, 9, 3, 13}, {8, 1, 13, 8, 1, 13}, {7, 5, 1, 7, 7, 1}, {8, 5, 1, 8, 5, 1}, {9, 5, 1, 9, 7, 1}, {10, 5, 1, 10, 5, 1}, {11, 5, 1, 11, 7, 1}, {12, 5, 1, 12, 5, 1}, {13, 5, 1, 13, 7, 1}, {14, 5, 1, 14, 5, 1}, {15, 5, 1, 15, 7, 1}, {16, 5, 2, 16, 7, 2}, {17, 5, 2, 17, 5, 2}, {18, 5, 2, 18, 7, 2}, {19, 5, 2, 19, 5, 2}, {20, 5, 2, 20, 7, 2}, {20, 5, 3, 20, 5, 3}, {20, 5, 4, 20, 7, 4}, {20, 5, 5, 20, 5, 5}, {20, 5, 6, 20, 7, 6}, {20, 5, 7, 20, 5, 7}, {20, 5, 8, 20, 7, 8}, {15, 5, 9, 15, 7, 9}, {15, 5, 10, 15, 5, 10}, {15, 5, 11, 15, 7, 11}, {15, 5, 12, 15, 5, 12}, {7, 5, 2, 7, 5, 2}, {7, 5, 3, 7, 7, 3}, {7, 5, 4, 7, 5, 4}, {7, 5, 5, 7, 7, 5}, {7, 5, 6, 7, 5, 6}, {7, 5, 7, 7, 7, 7}, {7, 5, 8, 7, 5, 8}, {7, 5, 9, 7, 7, 9}, {7, 5, 11, 7, 7, 11}, {7, 5, 12, 7, 5, 12}, {7, 5, 13, 7, 7, 13}, {19, 5, 8, 19, 5, 8}, {18, 5, 8, 18, 7, 8}, {17, 5, 8, 17, 5, 8}, {16, 5, 8, 16, 7, 8}, {15, 5, 13, 15, 7, 13}, {14, 5, 13, 14, 5, 13}, {13, 5, 13, 13, 7, 13}, {12, 5, 13, 12, 5, 13}, {11, 5, 13, 11, 7, 13}, {10, 5, 13, 10, 5, 13}, {9, 5, 13, 9, 7, 13}, {8, 5, 13, 8, 5, 13}, {9, 9, 1, 10, 9, 1}, {11, 10, 1, 11, 10, 1}, {12, 9, 1, 13, 9, 1}, {20, 9, 4, 20, 9, 4}, {20, 9, 6, 20, 9, 6}, {9, 9, 13, 10, 9, 13}, {11, 10, 13, 11, 10, 13}, {12, 9, 13, 13, 9, 13}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), false);
            }
            for (int[] uuvvww : new int[][]{{14, 5, 12, 14, 5, 12}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor5 : 1), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor5 : 1), false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 8, 0, 5, 8, 14}, {7, 9, 0, 7, 9, 14}, {9, 10, 0, 9, 10, 14}, {11, 11, 0, 11, 11, 14}, {13, 10, 0, 13, 10, 4}, {13, 10, 6, 13, 10, 14}, {14, 10, 4, 21, 10, 4}, {14, 10, 6, 21, 10, 6}, {15, 9, 0, 15, 9, 2}, {15, 9, 8, 15, 9, 14}, {16, 9, 2, 21, 9, 2}, {16, 9, 8, 21, 9, 8}, {17, 5, 3, 17, 5, 7}, {8, 4, 2, 8, 4, 2}, {10, 3, 2, 10, 3, 2}, {12, 2, 2, 12, 2, 2}, {14, 1, 2, 14, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 8, 0, 6, 8, 14}, {8, 9, 0, 8, 9, 0}, {8, 9, 2, 8, 9, 12}, {8, 9, 14, 8, 9, 14}, {10, 10, 0, 10, 10, 0}, {10, 10, 2, 10, 10, 12}, {10, 10, 14, 10, 10, 14}, {12, 10, 0, 12, 10, 0}, {12, 10, 2, 12, 10, 12}, {12, 10, 14, 12, 10, 14}, {13, 10, 5, 16, 10, 5}, {18, 10, 5, 19, 10, 5}, {21, 10, 5, 21, 10, 5}, {14, 9, 0, 14, 9, 0}, {14, 9, 2, 14, 9, 3}, {14, 9, 7, 14, 9, 12}, {14, 9, 14, 14, 9, 14}, {15, 9, 3, 19, 9, 3}, {21, 9, 3, 21, 9, 3}, {15, 9, 7, 19, 9, 7}, {21, 9, 7, 21, 9, 7}, {16, 8, 0, 16, 8, 1}, {16, 8, 9, 16, 8, 14}, {17, 8, 1, 21, 8, 1}, {17, 8, 9, 21, 8, 9}, {5, 4, 1, 6, 4, 8}, {5, 4, 12, 6, 4, 13}, {8, 4, 4, 8, 4, 12}, {9, 4, 3, 10, 4, 12}, {11, 4, 3, 11, 4, 4}, {11, 4, 6, 11, 4, 12}, {12, 4, 3, 12, 4, 3}, {12, 4, 7, 12, 4, 12}, {13, 4, 2, 13, 4, 4}, {13, 4, 6, 13, 4, 12}, {14, 4, 2, 14, 4, 12}, {14, 4, 3, 19, 4, 7}, {9, 3, 2, 9, 3, 2}, {11, 2, 2, 11, 2, 2}, {13, 1, 2, 13, 1, 2}, {11, 1, 9, 12, 1, 10}, {19, 1, 4, 19, 2, 4}, {19, 1, 6, 19, 2, 6}, {11, 5, 9, 11, 5, 9}, {11, 5, 11, 11, 5, 11}, {11, 6, 10, 11, 6, 10}, {11, 7, 9, 11, 7, 9}, {11, 7, 11, 11, 7, 11}, {13, 7, 8, 13, 7, 8}, {15, 7, 5, 15, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{11, 7, 12, 7}, {11, 7, 10, 7}, {11, 6, 12, 7}, {11, 6, 11, 7}, {11, 6, 9, 7}, {11, 5, 12, 7}, {11, 5, 10, 7}, {12, 5, 8, 4}, {12, 6, 8, 4}, {12, 7, 8, 4}, {14, 5, 8, 5}, {14, 6, 8, 5}, {14, 7, 8, 5}, {15, 5, 7, 6}, {15, 6, 7, 6}, {15, 7, 7, 6}, {15, 7, 6, 7}, {15, 5, 3, 7}, {15, 6, 3, 7}, {15, 7, 3, 7}, {15, 7, 4, 6}, {10, 1, 10, 5}, {13, 1, 10, 4}, {10, 1, 9, 5}, {13, 1, 9, 4}, {9, 1, 12, 3}, {10, 1, 12, 3}, {11, 1, 12, 3}, {12, 1, 12, 3}, {13, 1, 12, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{11, 7, 4}, {11, 7, 6}, {10, 8, 5}, {12, 8, 5}, {17, 8, 5}, {8, 3, 3}, {12, 3, 5}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{14, 6, 12}, {8, 2, 12}, {19, 3, 4}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{8, 6, 1}, {8, 7, 1}, {10, 6, 1}, {10, 7, 1}, {12, 6, 1}, {12, 7, 1}, {14, 6, 1}, {14, 7, 1}, {17, 6, 2}, {17, 7, 2}, {19, 6, 2}, {19, 7, 2}, {20, 6, 3}, {20, 7, 3}, {20, 6, 5}, {20, 7, 5}, {20, 6, 7}, {20, 7, 7}, {19, 6, 8}, {19, 7, 8}, {17, 6, 8}, {17, 7, 8}, {15, 6, 10}, {15, 7, 10}, {15, 6, 12}, {15, 7, 12}, {14, 6, 13}, {14, 7, 13}, {12, 6, 13}, {12, 7, 13}, {10, 6, 13}, {10, 7, 13}, {8, 6, 13}, {8, 7, 13}, {7, 6, 12}, {7, 7, 12}, {7, 6, 8}, {7, 7, 8}, {7, 6, 6}, {7, 7, 6}, {7, 6, 4}, {7, 7, 4}, {7, 6, 2}, {7, 7, 2}, {8, 2, 1}, {8, 3, 1}, {10, 2, 1}, {10, 3, 1}, {12, 2, 1}, {12, 3, 1}, {14, 2, 1}, {14, 3, 1}, {17, 2, 2}, {17, 3, 2}, {19, 2, 2}, {19, 3, 2}, {20, 2, 3}, {20, 3, 3}, {20, 2, 5}, {20, 3, 5}, {20, 2, 7}, {20, 3, 7}, {19, 2, 8}, {19, 3, 8}, {17, 2, 8}, {17, 3, 8}, {15, 2, 10}, {15, 3, 10}, {15, 2, 12}, {15, 3, 12}, {14, 2, 13}, {14, 3, 13}, {12, 2, 13}, {12, 3, 13}, {10, 2, 13}, {10, 3, 13}, {8, 2, 13}, {8, 3, 13}, {7, 2, 6}, {7, 3, 6}, {7, 2, 4}, {7, 3, 4}, {7, 2, 2}, {7, 3, 2}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{11, 9, 0, 2}, {11, 9, 2, 0}, {19, 9, 5, 3}, {21, 9, 5, 1}, {11, 9, 12, 2}, {11, 9, 14, 0}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            int carpetMeta = GeneralConfig.useVillageColors ? this.townColor5 : 1;
            for (int[] uvwm : new int[][]{{8, 5, 12, 8, 5, 12}, {10, 5, 12, 10, 5, 12}, {9, 5, 11, 9, 5, 11}, {8, 5, 10, 8, 5, 10}, {10, 5, 10, 10, 5, 10}, {9, 5, 9, 9, 5, 9}, {8, 5, 8, 8, 5, 8}, {10, 5, 8, 10, 5, 8}, {9, 1, 4, 9, 1, 6}, {10, 1, 6, 10, 1, 7}, {11, 1, 7, 13, 1, 7}, {14, 1, 6, 14, 1, 7}, {15, 1, 4, 15, 1, 6}, {10, 1, 3, 10, 1, 4}, {11, 1, 3, 13, 1, 3}, {14, 1, 3, 14, 1, 4}}) {
                this.func_175804_a(world, structureBB, uvwm[0], uvwm[1], uvwm[2], uvwm[3], uvwm[4], uvwm[5], Blocks.field_150404_cg.func_176203_a(carpetMeta), Blocks.field_150404_cg.func_176203_a(carpetMeta), false);
            }
            carpetMeta = GeneralConfig.useVillageColors ? this.townColor2 : 4;
            for (int[] uvwm : new int[][]{{9, 5, 12, 9, 5, 12}, {8, 5, 11, 8, 5, 11}, {10, 5, 11, 10, 5, 11}, {9, 5, 10, 9, 5, 10}, {8, 5, 9, 8, 5, 9}, {10, 5, 9, 10, 5, 9}, {9, 5, 8, 9, 5, 8}, {11, 1, 6, 11, 1, 6}, {13, 1, 6, 13, 1, 6}, {10, 1, 5, 10, 1, 5}, {12, 1, 5, 12, 1, 5}, {14, 1, 5, 14, 1, 5}, {11, 1, 4, 11, 1, 4}, {13, 1, 4, 13, 1, 4}}) {
                this.func_175804_a(world, structureBB, uvwm[0], uvwm[1], uvwm[2], uvwm[3], uvwm[4], uvwm[5], Blocks.field_150404_cg.func_176203_a(carpetMeta), Blocks.field_150404_cg.func_176203_a(carpetMeta), false);
            }
            carpetMeta = GeneralConfig.useVillageColors ? this.townColor : 0;
            for (int[] uvwm : new int[][]{{12, 1, 6, 12, 1, 6}, {11, 1, 5, 11, 1, 5}, {13, 1, 5, 13, 1, 5}, {12, 1, 4, 12, 1, 4}}) {
                this.func_175804_a(world, structureBB, uvwm[0], uvwm[1], uvwm[2], uvwm[3], uvwm[4], uvwm[5], Blocks.field_150404_cg.func_176203_a(carpetMeta), Blocks.field_150404_cg.func_176203_a(carpetMeta), false);
            }
            IBlockState biomeStonePressurePlateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150456_au.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{11, 2, 10}, {12, 2, 10}}) {
                this.func_175811_a(world, biomeStonePressurePlateState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{17, 1, 3, 0}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{17, 1, 7}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{8, 1, 9, 8, 3, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{12, 2, 9}}) {
                this.func_175811_a(world, Blocks.field_150414_aQ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{19, 3, 6}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            for (int[] uvwoc : new int[][]{{18, 6, 4, 3, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {18, 6, 6, 3, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {13, 5, 11, 2, GeneralConfig.useVillageColors ? this.townColor2 : 4}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{18, 6, 3, -1, 0}, {18, 6, 7, -1, 0}, {13, 5, 10, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleFletcherHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFF", "FFFFFPPPPPFFFFF", "FFFFFFFPFFFFFFF", "FFFFFFFPFFFFFFF", "  FFFFFPFFFFF  ", "  FFFFFPFFFFF  ", "  FFFFFPFFFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 5;
        private static final int DECREASE_MAX_U = 5;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleFletcherHouse2() {
        }

        public JungleFletcherHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleFletcherHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleFletcherHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleFletcherHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{5, 0, 5, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 5, 0, 5})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{5, 0, 5, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 5, 0, 5})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 3, 4, 0, 7}, {10, 0, 3, 14, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 7, 9, 1, 7}, {5, 1, 3, 6, 1, 3}, {8, 1, 3, 9, 1, 3}, {1, 6, 6, 1, 6, 6}, {3, 6, 6, 3, 6, 6}, {1, 6, 4, 1, 6, 4}, {3, 6, 4, 3, 6, 4}, {11, 6, 6, 11, 6, 6}, {13, 6, 6, 13, 6, 6}, {11, 6, 4, 11, 6, 4}, {13, 6, 4, 13, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeFenceGateBlockstate = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{7, 1, 3}}) {
                this.func_175811_a(world, biomeFenceGateBlockstate.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(2, false)), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 7, 2, 1, 7}, {2, 3, 7, 2, 3, 7}, {0, 1, 5, 0, 1, 5}, {0, 3, 5, 0, 3, 5}, {4, 3, 5, 4, 3, 5}, {2, 1, 3, 2, 1, 3}, {2, 3, 3, 2, 3, 3}, {1, 5, 6, 1, 5, 6}, {2, 6, 6, 2, 6, 6}, {3, 5, 6, 3, 5, 6}, {1, 6, 5, 1, 6, 5}, {3, 6, 5, 3, 6, 5}, {1, 5, 4, 1, 5, 4}, {2, 6, 4, 2, 6, 4}, {3, 5, 4, 3, 5, 4}, {12, 1, 7, 12, 1, 7}, {12, 3, 7, 12, 3, 7}, {10, 3, 5, 10, 3, 5}, {14, 1, 5, 14, 1, 5}, {14, 3, 5, 14, 3, 5}, {12, 1, 3, 12, 1, 3}, {12, 3, 3, 12, 3, 3}, {11, 5, 6, 11, 5, 6}, {12, 6, 6, 12, 6, 6}, {13, 5, 6, 13, 5, 6}, {11, 6, 5, 11, 6, 5}, {13, 6, 5, 13, 6, 5}, {11, 5, 4, 11, 5, 4}, {12, 6, 4, 12, 6, 4}, {13, 5, 4, 13, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{5, 2, 7, -1}, {9, 2, 7, -1}, {5, 2, 3, -1}, {9, 2, 3, -1}, {1, 3, 5, 1}, {13, 3, 5, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 7, 0, 4, 7}, {4, 1, 7, 4, 4, 7}, {0, 1, 3, 0, 4, 3}, {4, 1, 3, 4, 4, 3}, {1, 4, 3, 3, 4, 3}, {0, 4, 4, 0, 4, 6}, {1, 4, 7, 3, 4, 7}, {4, 4, 4, 4, 4, 6}, {10, 1, 7, 10, 4, 7}, {14, 1, 7, 14, 4, 7}, {10, 1, 3, 10, 4, 3}, {14, 1, 3, 14, 4, 3}, {11, 4, 3, 13, 4, 3}, {10, 4, 4, 10, 4, 6}, {11, 4, 7, 13, 4, 7}, {14, 4, 4, 14, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 3, 1, 3, 3}, {3, 1, 3, 3, 3, 3}, {0, 1, 4, 0, 3, 4}, {0, 1, 6, 0, 3, 6}, {4, 1, 6, 4, 3, 6}, {4, 1, 4, 4, 3, 4}, {1, 1, 7, 1, 3, 7}, {3, 1, 7, 3, 3, 7}, {2, 5, 7, 2, 5, 7}, {0, 5, 5, 0, 5, 5}, {4, 5, 5, 4, 5, 5}, {2, 5, 3, 2, 5, 3}, {11, 1, 3, 11, 3, 3}, {13, 1, 3, 13, 3, 3}, {10, 1, 4, 10, 3, 4}, {10, 1, 6, 10, 3, 6}, {14, 1, 6, 14, 3, 6}, {14, 1, 4, 14, 3, 4}, {11, 1, 7, 11, 3, 7}, {13, 1, 7, 13, 3, 7}, {12, 5, 7, 12, 5, 7}, {10, 5, 5, 10, 5, 5}, {14, 5, 5, 14, 5, 5}, {12, 5, 3, 12, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 5, 7, 0}, {3, 5, 7, 1}, {0, 5, 6, 2}, {4, 5, 6, 2}, {0, 5, 4, 3}, {4, 5, 4, 3}, {1, 5, 3, 0}, {3, 5, 3, 1}, {11, 5, 7, 0}, {13, 5, 7, 1}, {10, 5, 6, 2}, {14, 5, 6, 2}, {10, 5, 4, 3}, {14, 5, 4, 3}, {11, 5, 3, 0}, {13, 5, 3, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 5, 7}, {4, 5, 7}, {0, 5, 3}, {4, 5, 3}, {10, 5, 7}, {14, 5, 7}, {10, 5, 3}, {14, 5, 3}, {5, 4, 6}, {6, 4, 6}, {7, 4, 6}, {8, 4, 6}, {9, 4, 6}, {5, 4, 4}, {6, 4, 4}, {7, 4, 4}, {8, 4, 4}, {9, 4, 4}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 3, 7}, {6, 3, 7}, {7, 3, 7}, {8, 3, 7}, {9, 3, 7}, {5, 4, 5}, {6, 4, 5}, {7, 4, 5}, {8, 4, 5}, {9, 4, 5}, {5, 3, 3}, {6, 3, 3}, {7, 3, 3}, {8, 3, 3}, {9, 3, 3}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 2, 7}, {0, 2, 5}, {2, 2, 3}, {12, 2, 7}, {14, 2, 5}, {12, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 6, 5}, {12, 6, 5}}) {
                this.func_175811_a(world, Blocks.field_150359_w.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            this.func_175811_a(world, ModObjects.chooseModFletchingTableState(3, this.func_186165_e()), 13, 1, 6, structureBB);
            for (int[] uuvvww : new int[][]{{1, 1, 6, 1, 1, 6}, {2, 0, 0, 6, 0, 2}, {8, 0, 0, 11, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150349_c.func_176223_P(), Blocks.field_150349_c.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{1, 2, 6}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{1, 1, 5, 2}, {2, 1, 6, 1}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{1, 1, 4}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 13;
            int chestV = 1;
            int chestW = 4;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_fletcher");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 5, 1, 1, 1}, {10, 1, 5, 3, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 0, 5, 1, 2}, {9, 1, 0, 9, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            for (int[] uvwg : new int[][]{{7, 1, 6, 0}, {5, 1, 6, 1}, {9, 1, 6, 1}, {6, 1, 6, 0}, {8, 1, 6, 0}, {5, 1, 4, 0}, {9, 1, 4, 0}, {2, 1, 2, 0}, {3, 1, 2, 0}, {4, 1, 2, 0}, {6, 1, 2, 0}, {8, 1, 2, 0}, {10, 1, 2, 0}, {11, 1, 2, 0}, {12, 1, 2, 0}, {2, 1, 1, 0}, {3, 1, 1, 0}, {4, 1, 1, 0}, {6, 1, 1, 0}, {8, 1, 1, 0}, {10, 1, 1, 0}, {11, 1, 1, 0}, {12, 1, 1, 0}, {2, 1, 0, 0}, {3, 1, 0, 0}, {4, 1, 0, 0}, {6, 1, 0, 0}, {8, 1, 0, 0}, {10, 1, 0, 0}, {11, 1, 0, 0}, {12, 1, 0, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(29);
                int u = s <= 0 ? 1 : (s <= 6 ? 2 + (s - 1) / 3 : (s <= 21 ? 3 + (s - 1) / 3 : (s <= 27 ? 4 + (s - 1) / 3 : 13)));
                int v = 1;
                int w = s <= 0 ? 5 : (s <= 27 ? 4 + (s - 1) % 3 : 5);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleFletcherHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", " FFFFFF  ", " FFFFFF  ", " FFFFFF  ", " FFFFFF  ", " FFFFFFF ", " FFFFFFF ", "  FPFFFF ", "   P FFF ", "   P     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 4;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleFletcherHouse1() {
        }

        public JungleFletcherHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleFletcherHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleFletcherHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleFletcherHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{1, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 1, 0, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{3, 0, 3, 3, 0, 3}, {1, 0, 4, 5, 0, 7}, {6, 0, 2, 6, 0, 4}, {5, 0, 3, 5, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 3, 1, 1, 8}, {2, 1, 3, 2, 1, 3}, {2, 1, 8, 5, 1, 8}, {6, 1, 5, 6, 1, 8}, {7, 1, 1, 7, 1, 4}, {5, 1, 1, 6, 1, 1}, {5, 1, 2, 5, 1, 2}, {4, 1, 3, 4, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 8, 2, 3, 8}, {3, 3, 8, 4, 3, 8}, {5, 2, 8, 5, 3, 8}, {1, 2, 4, 1, 3, 4}, {1, 3, 5, 1, 3, 6}, {1, 2, 7, 1, 3, 7}, {2, 2, 3, 2, 3, 3}, {4, 2, 3, 4, 3, 3}, {6, 3, 1, 6, 3, 1}, {5, 2, 2, 5, 3, 2}, {7, 3, 2, 7, 3, 3}, {6, 3, 5, 6, 3, 7}, {6, 2, 5, 6, 2, 5}, {6, 2, 7, 6, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 3, 1, 4, 3}, {5, 2, 1, 5, 4, 1}, {7, 2, 1, 7, 4, 1}, {1, 2, 8, 1, 4, 8}, {6, 2, 8, 6, 4, 8}, {7, 2, 4, 7, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{6, 1, 2, 6, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 4, 6}, {3, 3, 3, 7}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 3, 4, 0}, {3, 3, 7, 2}, {5, 3, 6, 3}, {6, 3, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 2, 5, 1, 2, 6}, {3, 2, 8, 4, 2, 8}, {6, 2, 6, 6, 2, 6}, {7, 2, 2, 7, 2, 3}, {6, 2, 1, 6, 2, 1}, {5, 2, 2, 5, 2, 2}, {1, 4, 4, 1, 4, 7}, {2, 4, 8, 5, 4, 8}, {6, 4, 5, 6, 4, 7}, {7, 4, 2, 7, 4, 3}, {6, 4, 1, 6, 4, 1}, {5, 4, 2, 5, 4, 2}, {2, 4, 3, 4, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 3}, {0, 4, 5}, {0, 4, 7}, {0, 4, 9}, {2, 4, 9}, {4, 4, 9}, {6, 4, 9}, {7, 4, 8}, {7, 4, 6}, {8, 4, 5}, {8, 4, 3}, {8, 4, 1}, {7, 4, 0}, {5, 4, 0}, {4, 4, 1}, {3, 4, 2}, {1, 4, 2}, {1, 5, 3}, {1, 5, 4}, {1, 5, 5}, {1, 5, 6}, {1, 5, 7}, {1, 5, 8}, {2, 5, 8}, {3, 5, 8}, {4, 5, 8}, {5, 5, 8}, {6, 5, 8}, {6, 5, 7}, {6, 5, 6}, {6, 5, 5}, {6, 5, 4}, {7, 5, 4}, {7, 5, 3}, {7, 5, 2}, {7, 5, 1}, {6, 5, 1}, {5, 5, 1}, {5, 5, 2}, {5, 5, 3}, {4, 5, 3}, {3, 5, 3}, {2, 5, 3}, {3, 6, 5}, {4, 6, 5}, {3, 6, 6}, {4, 6, 6}}) {
                this.func_175811_a(world, biomeWoodSlabBottomState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 2}, {0, 4, 4}, {0, 4, 6}, {0, 4, 8}, {1, 4, 9}, {3, 4, 9}, {5, 4, 9}, {7, 4, 9}, {7, 4, 9}, {7, 4, 7}, {7, 4, 5}, {8, 4, 4}, {8, 4, 2}, {8, 4, 0}, {6, 4, 0}, {4, 4, 0}, {2, 4, 2}, {4, 4, 2}, {2, 5, 4}, {2, 5, 5}, {2, 5, 6}, {2, 5, 7}, {3, 5, 7}, {4, 5, 7}, {5, 5, 7}, {5, 5, 6}, {5, 5, 5}, {5, 5, 4}, {4, 5, 4}, {3, 5, 4}, {6, 5, 3}, {6, 5, 2}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175811_a(world, ModObjects.chooseModFletchingTableState(1, this.func_186165_e()), 2, 1, 7, structureBB);
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{5, 1, 7}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 3, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{6, 2, 2}}) {
                int u = uvw[0];
                int v = uvw[1];
                int w = uvw[2];
                int x = this.func_74865_a(u, w);
                int y = this.func_74862_a(v);
                int z = this.func_74873_b(u, w);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            for (int[] uvwg : new int[][]{{2, 1, 2, 1}, {4, 1, 2, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 1, 6, 4, 1, 6, GeneralConfig.useVillageColors ? this.townColor : 0}, {3, 1, 5, 3, 1, 5, GeneralConfig.useVillageColors ? this.townColor : 0}, {4, 1, 5, 4, 1, 5, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {5, 1, 5, 5, 1, 5, GeneralConfig.useVillageColors ? this.townColor : 0}, {4, 1, 4, 5, 1, 4, GeneralConfig.useVillageColors ? this.townColor : 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150404_cg.func_176203_a(uuvvww[6]), Blocks.field_150404_cg.func_176203_a(uuvvww[6]), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(16);
                int u = s <= 1 ? 2 : (s <= 5 ? 3 : (s <= 9 ? 4 : (s <= 13 ? 5 : 6)));
                int v = 1;
                int w = s <= 1 ? s - 5 : (s <= 5 ? s + 2 : (s <= 9 ? s - 2 : (s <= 13 ? s - 7 : s - 9)));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleFisherCottage
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFF ", "    FFFFP ", "    FFFFP ", "    FFPPP "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 9;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 5;
        private int averageGroundLevel = -1;

        public JungleFisherCottage() {
        }

        public JungleFisherCottage(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleFisherCottage buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleFisherCottage.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleFisherCottage(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{4, 5, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 4, 5, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 5})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{5, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)9, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 3, 5, 0, 8}, {4, 0, 0, 5, 0, 2}, {6, 0, 1, 7, 0, 4}, {8, 0, 3, 8, 0, 5}, {9, 0, 4, 9, 0, 8}, {6, 0, 8, 8, 0, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{6, 0, 5, 7, 0, 7}, {8, 0, 6, 8, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 3, 1, 3, 3}, {2, 1, 3, 2, 1, 3}, {2, 3, 3, 2, 3, 3}, {3, 1, 3, 3, 3, 3}, {0, 1, 4, 0, 3, 4}, {0, 1, 5, 0, 1, 6}, {0, 3, 5, 0, 3, 6}, {0, 1, 7, 0, 3, 7}, {5, 1, 5, 5, 3, 5}, {5, 1, 6, 5, 1, 6}, {5, 3, 6, 5, 3, 6}, {5, 1, 7, 5, 3, 7}, {1, 1, 8, 1, 3, 8}, {2, 1, 8, 3, 1, 8}, {2, 3, 8, 3, 3, 8}, {4, 1, 8, 4, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor4 : 9), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor4 : 9), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 7, 1, 4, 7}, {4, 4, 7, 4, 4, 7}, {1, 4, 4, 1, 4, 4}, {4, 4, 4, 4, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 3, 0, 3, 3}, {0, 1, 8, 0, 3, 8}, {5, 1, 8, 5, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 3, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{9, 1, 4}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 0, 4, 2, 0}, {7, 1, 1, 7, 2, 1}, {8, 1, 4, 8, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 3, 3, 7}, {5, 3, 4, 5}, {1, 1, 5, 6}, {1, 1, 7, 7}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 3, 0, 5, 3, 0}, {6, 3, 1, 7, 3, 1}, {7, 3, 2, 7, 3, 2}, {8, 3, 3, 8, 3, 4}, {0, 4, 3, 1, 4, 3}, {0, 4, 4, 0, 4, 4}, {2, 4, 4, 3, 4, 4}, {4, 4, 3, 5, 4, 3}, {5, 4, 4, 5, 4, 4}, {4, 4, 5, 4, 4, 6}, {5, 4, 7, 5, 4, 8}, {4, 4, 8, 4, 4, 8}, {2, 4, 7, 3, 4, 7}, {0, 4, 7, 0, 4, 8}, {1, 4, 8, 1, 4, 8}, {1, 4, 5, 1, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 3, 1, 5, 3, 2}, {5, 3, 3, 5, 3, 3}, {6, 3, 2, 6, 3, 2}, {6, 3, 3, 7, 3, 4}, {1, 1, 6, 1, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvw : new int[][]{{2, 2, 3}, {2, 2, 8}, {3, 2, 8}, {0, 2, 5}, {0, 2, 6}, {5, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 5, 3, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150359_w.func_176203_a(0), Blocks.field_150359_w.func_176203_a(0), false);
            }
            for (int[] uvwoo : new int[][]{{7, 1, 3, 0, -1}, {6, 1, 8, 0, 1}, {7, 1, 8, 0, -1}, {6, 2, 8, 1, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), ModObjects.chooseModBarrelBlockState(this.func_186165_e(), uvwoo[4], uvwoo[3]), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 1, 3, 0, 1, 0}, {5, 1, 4, 3, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int flower_u = 1;
            int flower_v = 2;
            int flower_w = 5;
            int x = this.func_74865_a(flower_u, flower_w);
            int y = this.func_74862_a(flower_v);
            int z = this.func_74873_b(flower_u, flower_w);
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int randomPottedPlant = random.nextInt(10) - 1;
            if (randomPottedPlant == -1) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
            } else {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            int chestU = 4;
            int chestV = 1;
            int chestW = 7;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_fisher");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (Object uvwo : (ChestGenHooks)new int[][]{{-1, 1, 7, 3}, {-1, 2, 7, 3}, {-1, 3, 7, 3}, {-1, 1, 8, 3}, {-1, 2, 8, 3}, {3, 1, 9, 0}, {3, 2, 9, 0}, {3, 3, 9, 0}, {1, 1, 2, 2}, {1, 2, 2, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a((int)uvwo[0], (int)uvwo[2]), this.func_74862_a((int)uvwo[1]), this.func_74873_b((int)uvwo[0], (int)uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta((int)uvwo[3])), (int)uvwo[0], (int)uvwo[1], (int)uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = random.nextInt(3);
                int v = 1;
                int w = random.nextInt(3);
                if (random.nextBoolean()) {
                    u += 2;
                    w += 4;
                } else {
                    u += 4;
                    ++w;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class JungleCartographerHouse2
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFPPPFF", "FFFFFFFPFF", "FFFFFFFPFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFPPPFFFFF", "FFPFFFFFFF", "FFPFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 5;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleCartographerHouse2() {
        }

        public JungleCartographerHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleCartographerHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleCartographerHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleCartographerHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{5, 0, 5, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 5, 0, 5})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 0, 1, 0, 4}, {2, 0, 3, 4, 0, 4}, {3, 0, 0, 4, 0, 1}, {5, 0, 8, 9, 0, 9}, {5, 0, 5, 6, 0, 6}, {8, 0, 5, 9, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uuvvww : new int[][]{{5, 0, 0, 5, 0, 4}, {6, 0, 0, 7, 0, 1}, {6, 0, 4, 7, 0, 4}, {8, 0, 0, 9, 0, 4}, {0, 0, 5, 0, 0, 9}, {1, 0, 5, 3, 0, 5}, {1, 0, 9, 3, 0, 9}, {4, 0, 5, 4, 0, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{5, 1, 4, 5, 3, 4}, {9, 1, 4, 9, 3, 4}, {5, 1, 0, 5, 3, 0}, {9, 1, 0, 9, 3, 0}, {0, 1, 9, 0, 3, 9}, {4, 1, 9, 4, 3, 9}, {0, 1, 5, 0, 3, 5}, {4, 1, 5, 4, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState concreteBlockState = Blocks.field_192443_dR.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0);
            for (int[] uuvvww : new int[][]{{4, 1, 6, 4, 3, 6}, {4, 3, 7, 4, 3, 7}, {4, 1, 8, 4, 3, 8}, {1, 1, 9, 3, 1, 9}, {1, 3, 9, 3, 3, 9}, {0, 1, 6, 0, 1, 8}, {0, 3, 6, 0, 3, 8}, {1, 1, 5, 3, 1, 5}, {1, 3, 5, 3, 3, 5}, {6, 1, 4, 6, 3, 4}, {7, 3, 4, 7, 3, 4}, {8, 1, 4, 8, 3, 4}, {5, 1, 1, 5, 3, 1}, {5, 3, 2, 5, 3, 2}, {5, 1, 3, 5, 3, 3}, {9, 1, 1, 9, 1, 3}, {9, 3, 1, 9, 3, 3}, {6, 1, 0, 8, 1, 0}, {6, 3, 0, 8, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], concreteBlockState, concreteBlockState, false);
            }
            IBlockState biomeTerracottaState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150405_ch.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 5, 4, 4, 5}, {0, 4, 5, 0, 4, 9}, {0, 4, 9, 4, 4, 9}, {4, 4, 5, 4, 4, 9}, {5, 4, 0, 9, 4, 0}, {5, 4, 0, 5, 4, 4}, {5, 4, 4, 9, 4, 4}, {9, 4, 0, 9, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeTerracottaState, biomeTerracottaState, false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 2, 3}, {6, 4, 2, 1}, {5, 3, 7, 1}, {3, 4, 7, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 1, 1, 8, 1, 1}, {8, 1, 2, 8, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 5, 9, 2}, {1, 5, 9, 2}, {2, 5, 9, 2}, {3, 5, 9, 2}, {4, 5, 9, 2}, {0, 5, 8, 0}, {4, 5, 8, 1}, {0, 5, 7, 0}, {4, 5, 7, 1}, {0, 5, 6, 0}, {4, 5, 6, 1}, {0, 5, 5, 3}, {1, 5, 5, 3}, {2, 5, 5, 3}, {3, 5, 5, 3}, {4, 5, 5, 3}, {5, 5, 4, 2}, {6, 5, 4, 2}, {7, 5, 4, 2}, {8, 5, 4, 2}, {9, 5, 4, 2}, {5, 5, 3, 0}, {9, 5, 3, 1}, {5, 5, 2, 0}, {9, 5, 2, 1}, {5, 5, 1, 0}, {9, 5, 1, 1}, {5, 5, 0, 3}, {6, 5, 0, 3}, {7, 5, 0, 3}, {8, 5, 0, 3}, {9, 5, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{9, 2, 1, 9, 2, 3}, {6, 2, 0, 8, 2, 0}, {1, 2, 9, 3, 2, 9}, {0, 2, 6, 0, 2, 8}, {1, 2, 5, 3, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150410_aZ.func_176223_P(), Blocks.field_150410_aZ.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{1, 5, 8, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {2, 5, 8, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {3, 5, 8, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {1, 5, 7, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {2, 5, 7, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {3, 5, 7, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {1, 5, 6, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {2, 5, 6, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {3, 5, 6, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {6, 5, 3, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {7, 5, 3, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {8, 5, 3, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {6, 5, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {7, 5, 2, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {8, 5, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {6, 5, 1, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {7, 5, 1, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {8, 5, 1, GeneralConfig.useVillageColors ? this.townColor5 : 1}}) {
                this.func_175811_a(world, Blocks.field_150399_cn.func_176203_a(uvw[3]), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{1, 0, 8, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {2, 0, 8, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {3, 0, 8, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {1, 0, 7, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {2, 0, 7, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {3, 0, 7, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {1, 0, 6, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {2, 0, 6, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {3, 0, 6, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {6, 0, 3, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {7, 0, 3, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {6, 0, 2, GeneralConfig.useVillageColors ? this.townColor3 : 14}, {7, 0, 2, GeneralConfig.useVillageColors ? this.townColor5 : 1}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvw : new int[][]{{8, 2, 1}}) {
                int potted_sapling_x = this.func_74865_a(uvw[0], uvw[2]);
                int potted_sapling_y = this.func_74862_a(uvw[1]);
                int potted_sapling_z = this.func_74873_b(uvw[0], uvw[2]);
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(potted_sapling_x, potted_sapling_y, potted_sapling_z), Blocks.field_150345_g, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uvwo : new int[][]{{1, 1, 7, 1}}) {
                this.func_175811_a(world, ModObjects.chooseModCartographyTableState(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 2, 3, 1, 0}, {7, 1, 4, 0, 1, 1}, {4, 1, 7, 1, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 9, 9, 1, 9}, {9, 1, 5, 9, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 3, 1, 4}, {5, 2, 9, 9, 2, 9}, {9, 2, 5, 9, 2, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            for (int[] uvw : new int[][]{{5, 1, 8}, {7, 1, 8}, {8, 1, 7}, {8, 1, 5}, {5, 1, 6}, {6, 1, 5}}) {
                this.func_175811_a(world, Blocks.field_150328_O.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwg : new int[][]{{6, 1, 8, 0}, {8, 1, 8, 0}, {8, 1, 6, 0}, {6, 1, 6, 0}, {5, 1, 5, 0}, {0, 1, 4, 0}, {4, 1, 4, 0}, {0, 1, 3, 0}, {1, 1, 3, 0}, {2, 1, 3, 0}, {3, 1, 3, 0}, {4, 1, 3, 0}, {0, 1, 2, 0}, {1, 1, 2, 0}, {0, 1, 1, 0}, {1, 1, 1, 0}, {3, 1, 1, 0}, {4, 1, 1, 0}, {0, 1, 0, 0}, {1, 1, 0, 0}, {3, 1, 0, 0}, {4, 1, 0, 0}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int s = random.nextInt(28);
                int u = s <= 2 ? s + 1 : (s <= 4 ? s - 1 : (s <= 7 ? s - 4 : (s <= 11 ? s - 3 : (s <= 15 ? s - 7 : (s <= 19 ? s - 11 : (s <= 23 ? s - 15 : (s <= 25 ? s - 18 : s - 20)))))));
                int v = 1;
                int w = s <= 2 ? 8 : (s <= 4 ? 7 : (s <= 7 ? 6 : (s <= 11 ? 8 : (s <= 15 ? 7 : (s <= 19 ? 6 : (s <= 23 ? 5 : (s <= 25 ? 3 : 2)))))));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class JungleCartographerHouse1
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"         ", "         ", "         ", "         ", "         ", "         ", "         ", "         "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        public static final byte MEDIAN_BORDERS = 3;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 1;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 1;
        private int averageGroundLevel = -1;

        public JungleCartographerHouse1() {
        }

        public JungleCartographerHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleCartographerHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleCartographerHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleCartographerHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 1, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 1, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{1, 0, 1, 1})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{1, 1, 0, 1})[this.func_186165_e().func_176736_b()]), true, (byte)3, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 0);
            this.establishFoundation(world, structureBB, foundationPattern, 0, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 5, 1, 0, 5}, {1, 0, 6, 1, 0, 6}, {5, 0, 5, 6, 0, 5}, {5, 0, 6, 5, 0, 6}, {0, 0, 1, 1, 0, 1}, {1, 0, 0, 1, 0, 0}, {5, 0, 1, 6, 0, 1}, {5, 0, 0, 5, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvw : new int[][]{{0, -1, 5}, {0, -1, 6}, {1, -1, 5}, {1, -1, 6}, {5, -1, 5}, {5, -1, 6}, {6, -1, 5}, {6, -1, 6}, {0, -1, 0}, {0, -1, 1}, {1, -1, 0}, {1, -1, 1}, {0, -1, 5}, {0, -1, 6}, {1, -1, 5}, {1, -1, 6}}) {
                this.func_175808_b(world, biomeCobblestoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCobblestoneSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 0, 6, 0, 0, 6}, {6, 0, 6, 6, 0, 6}, {0, 0, 0, 0, 0, 0}, {6, 0, 0, 6, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneSlabLowerState, biomeCobblestoneSlabLowerState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 1, 5, 1, 1}, {1, 1, 5, 1, 1, 5}, {5, 1, 5, 5, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 2, 4, 1, 4}, {3, 2, 6, 6, 2, 6}, {5, 2, 5, 5, 2, 5}, {6, 2, 3, 6, 2, 5}, {3, 2, 1, 3, 4, 1}, {4, 2, 1, 4, 2, 1}, {4, 4, 1, 4, 4, 1}, {5, 2, 1, 5, 4, 1}, {6, 2, 2, 6, 5, 2}, {7, 3, 3, 7, 5, 3}, {7, 3, 4, 7, 3, 6}, {7, 5, 4, 7, 5, 6}, {7, 3, 7, 7, 5, 7}, {3, 3, 7, 3, 5, 7}, {4, 3, 7, 6, 3, 7}, {4, 5, 7, 6, 5, 7}, {2, 2, 6, 2, 5, 6}, {1, 2, 3, 1, 4, 3}, {1, 2, 4, 1, 2, 4}, {1, 4, 4, 1, 4, 4}, {1, 2, 5, 1, 4, 5}, {2, 5, 2, 5, 5, 2}, {2, 5, 3, 2, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 2, 4}, {2, 4, 1, 7}, {4, 2, 4, 3}, {5, 2, 4, 3}, {4, 2, 5, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 1, 1}, {1, 5, 1, 5, 5, 1}, {1, 5, 2, 1, 5, 5}, {3, 6, 3, 7, 6, 3}, {3, 6, 4, 3, 6, 6}, {7, 6, 4, 7, 6, 6}, {3, 6, 7, 7, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 1, 1, 4, 1}, {2, 1, 1, 4, 1, 1}, {2, 1, 5, 4, 1, 5}, {1, 1, 2, 1, 1, 4}, {5, 1, 2, 5, 1, 4}, {7, 2, 3, 7, 2, 7}, {3, 2, 7, 6, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{3, 5, 3}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 3, 1}, {4, 4, 7}, {5, 4, 7}, {6, 4, 7}, {1, 3, 4}, {7, 4, 4}, {7, 4, 5}, {7, 4, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 6, 4, 6, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150359_w.func_176203_a(0), Blocks.field_150359_w.func_176203_a(0), false);
            }
            for (int[] uvwo : new int[][]{{5, 3, 5, 1}}) {
                this.func_175811_a(world, ModObjects.chooseModCartographyTableState(uvwo[3], this.func_186165_e()), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{2, 2, 1, 0, 1, 1}, {1, 2, 2, 1, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 3, 6, 3, 3, 6}, {6, 3, 3, 6, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uvwm : new int[][]{{3, 2, 3, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {4, 2, 3, GeneralConfig.useVillageColors ? this.townColor : 0}, {5, 2, 3, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {3, 2, 4, GeneralConfig.useVillageColors ? this.townColor : 0}, {3, 2, 5, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {4, 3, 6, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {5, 3, 6, GeneralConfig.useVillageColors ? this.townColor : 0}, {6, 3, 6, GeneralConfig.useVillageColors ? this.townColor4 : 9}, {6, 3, 5, GeneralConfig.useVillageColors ? this.townColor : 0}, {6, 3, 4, GeneralConfig.useVillageColors ? this.townColor4 : 9}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeCraftingTableState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150462_ai.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{5, 2, 2}}) {
                this.func_175811_a(world, biomeCraftingTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 4, 6}, {6, 4, 3}}) {
                int x = this.func_74865_a(uvw[0], uvw[2]);
                int y = this.func_74862_a(uvw[1]);
                int z = this.func_74873_b(uvw[0], uvw[2]);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int randomPottedPlant = random.nextInt(10) - 1;
                if (randomPottedPlant == -1) {
                    StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
                    continue;
                }
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{0, 2, 4, 3}, {0, 1, 4, 3}, {6, 3, 8, 0}, {6, 2, 8, 0}, {6, 1, 8, 0}, {6, 4, 1, 2}, {6, 3, 1, 2}, {6, 2, 1, 2}, {7, 5, 2, 1}, {7, 4, 2, 1}, {7, 3, 2, 1}, {7, 2, 2, 1}, {7, 1, 2, 1}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            int chestU = 2;
            int chestV = 2;
            int chestW = 5;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_cartographer");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (!this.entitiesGenerated) {
                int v;
                this.entitiesGenerated = true;
                int s = random.nextInt(10);
                int u = s < 3 ? 3 : (s < 5 ? s + 1 : (s < 8 ? 6 : 13 - s));
                int n = v = s < 5 ? 2 : 3;
                int w = s < 3 ? 5 - s : (s < 5 ? 3 : (s < 8 ? s - 1 : 6));
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class JungleButcherShop
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFPFFFFFFF", "FFFFPPFFFF", "FFFFFFFPFF", "FFFPFFFFFF", "FFPFFFFFF ", "FFFFFFFFF ", "FFFFFFFFF ", "FFFFFFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleButcherShop() {
        }

        public JungleButcherShop(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleButcherShop buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleButcherShop.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleButcherShop(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{4, 0, 4, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 4, 0, 4})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 4, 1, 1}, {1, 1, 2, 1, 1, 7}, {2, 1, 8, 7, 1, 8}, {8, 1, 5, 8, 1, 7}, {6, 1, 4, 7, 1, 4}, {2, 6, 7, 2, 7, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{2, 9, 6, 3}, {1, 9, 7, 0}, {2, 9, 8, 2}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 5, 4, 1, 5}, {5, 1, 0, 5, 1, 0}, {8, 1, 0, 8, 1, 0}, {2, 6, 1, 4, 6, 1}, {1, 6, 3, 1, 6, 6}, {3, 6, 8, 6, 6, 8}, {5, 6, 2, 5, 6, 3}, {8, 6, 6, 8, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{2, 5, 2}, {3, 5, 2}, {4, 5, 2}, {4, 5, 3}, {4, 5, 4}, {4, 5, 6}, {4, 5, 7}}) {
                this.func_175811_a(world, Blocks.field_150334_T.func_176203_a(0), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 4, 5, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 5, -1}, {5, 2, 0, -1}, {8, 2, 0, -1}, {4, 6, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 2, 5, 1, 3}, {1, 8, 7, 1, 8, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 8, 1, 7, 8}, {8, 1, 8, 8, 7, 8}, {8, 1, 4, 8, 7, 4}, {1, 1, 1, 1, 7, 1}, {5, 1, 1, 5, 7, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 4, 8, 7, 4, 8}, {2, 4, 1, 4, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 4, 2, 1, 4, 7}, {5, 4, 2, 5, 4, 3}, {8, 4, 5, 8, 4, 7}, {3, 8, 1, 3, 8, 1}, {3, 8, 8, 3, 8, 8}, {6, 8, 8, 6, 8, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 2, 2, 5, 3, 3}, {2, 4, 2, 4, 4, 7}, {5, 4, 5, 7, 4, 7}, {1, 5, 2, 1, 5, 7}, {1, 6, 2, 1, 6, 2}, {1, 6, 7, 1, 6, 7}, {1, 7, 2, 1, 7, 7}, {2, 5, 1, 4, 5, 1}, {2, 8, 1, 2, 8, 1}, {4, 8, 1, 4, 8, 1}, {2, 7, 1, 4, 7, 1}, {5, 5, 2, 5, 5, 3}, {5, 7, 2, 5, 7, 3}, {8, 5, 5, 8, 5, 7}, {8, 6, 5, 8, 6, 5}, {8, 6, 7, 8, 6, 7}, {8, 7, 5, 8, 7, 7}, {2, 5, 8, 7, 5, 8}, {2, 6, 8, 2, 6, 8}, {7, 6, 8, 7, 6, 8}, {2, 7, 8, 7, 7, 8}, {2, 8, 8, 2, 8, 8}, {4, 8, 8, 5, 8, 8}, {7, 8, 8, 7, 8, 8}, {2, 8, 2, 4, 8, 6}, {2, 8, 8, 2, 8, 8}, {5, 8, 5, 7, 8, 7}, {3, 8, 7, 4, 8, 7}, {3, 9, 0, 3, 9, 5}, {3, 9, 6, 6, 9, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{6, 4, 4, 3}, {7, 4, 4, 3}, {6, 3, 3, 3}, {7, 3, 3, 3}, {6, 2, 2, 3}, {7, 2, 2, 3}, {6, 1, 1, 3}, {7, 1, 1, 3}, {6, 1, 2, 6}, {7, 1, 2, 6}, {6, 2, 3, 6}, {7, 2, 3, 6}, {6, 3, 4, 6}, {7, 3, 4, 6}, {2, 7, 2, 6}, {3, 7, 2, 6}, {4, 7, 2, 6}, {4, 7, 3, 4}, {4, 7, 4, 4}, {4, 7, 5, 6}, {5, 7, 5, 6}, {6, 7, 5, 6}, {7, 7, 6, 4}, {7, 7, 5, 4}, {3, 7, 7, 7}, {4, 7, 7, 7}, {5, 7, 7, 7}, {6, 7, 7, 7}, {7, 7, 7, 7}, {2, 7, 6, 5}, {2, 7, 5, 5}, {2, 7, 4, 5}, {2, 7, 3, 5}, {0, 7, 0, 0}, {0, 7, 1, 0}, {0, 7, 2, 0}, {0, 7, 3, 0}, {0, 7, 4, 0}, {0, 7, 5, 0}, {0, 7, 6, 0}, {0, 7, 7, 0}, {0, 7, 8, 0}, {0, 7, 9, 0}, {1, 8, 0, 0}, {1, 8, 1, 0}, {1, 8, 2, 0}, {1, 8, 3, 0}, {1, 8, 4, 0}, {1, 8, 5, 0}, {1, 8, 6, 0}, {1, 8, 8, 0}, {1, 8, 9, 0}, {6, 7, 0, 1}, {6, 7, 1, 1}, {6, 7, 2, 1}, {6, 7, 3, 1}, {5, 8, 0, 1}, {5, 8, 1, 1}, {5, 8, 2, 1}, {5, 8, 3, 1}, {5, 8, 4, 1}, {7, 7, 3, 3}, {8, 7, 3, 3}, {9, 7, 3, 3}, {6, 8, 4, 3}, {7, 8, 4, 3}, {8, 8, 4, 3}, {9, 7, 4, 1}, {9, 7, 5, 1}, {9, 7, 6, 1}, {9, 7, 7, 1}, {9, 7, 8, 1}, {9, 7, 9, 1}, {8, 8, 5, 1}, {8, 8, 6, 1}, {8, 8, 7, 1}, {8, 8, 8, 1}, {8, 8, 9, 1}, {1, 7, 0, 5}, {2, 8, 0, 5}, {4, 8, 0, 4}, {5, 7, 0, 4}, {1, 7, 9, 5}, {2, 8, 9, 5}, {7, 8, 9, 4}, {8, 7, 9, 4}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 9, 0, 2, 9, 5}, {2, 9, 9, 7, 9, 9}, {7, 9, 5, 7, 9, 8}, {4, 9, 5, 6, 9, 5}, {4, 9, 0, 4, 9, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 7, 6, 4, 7, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{4, 5, 5, 2}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, false)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 10, 6, 2}, {3, 10, 7, 1}, {2, 10, 8, 0}, {1, 10, 7, 3}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], false, true)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{2, 5, 5}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{2, 5, 7, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 5, 5, 2, 1, 1}, {7, 5, 5, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 3, 4, 1, 4}, {4, 2, 4, 4, 2, 4}, {5, 1, 5, 5, 1, 5}, {8, 1, 1, 8, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 5, 2, 0, 5}, {3, 0, 6, 3, 0, 6}, {6, 0, 5, 6, 0, 5}, {6, 0, 7, 6, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 6, 2, 0, 6}, {3, 0, 7, 4, 0, 7}, {7, 0, 6, 7, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150458_ak.func_176203_a(7), Blocks.field_150458_ak.func_176203_a(7), false);
            }
            for (int[] uuvvww : new int[][]{{7, 1, 6, 7, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150459_bM.func_176203_a(7), Blocks.field_150459_bM.func_176203_a(7), false);
            }
            for (int[] uvw : new int[][]{{6, 0, 6}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 8, 7}}) {
                if (campfireState.func_177230_c() == Block.func_149684_b((String)"campfire:campfire")) {
                    int woodmeta = biomePlankState.func_177230_c().func_176201_c(biomePlankState);
                    ModObjects.setModCampfireBlockstate(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), woodmeta);
                    continue;
                }
                this.func_175811_a(world, campfireState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{1, 3, 0, 2}, {1, 4, 0, 2}, {1, 5, 0, 2}, {1, 6, 0, 2}, {2, 2, 0, 2}, {2, 3, 0, 2}, {2, 4, 0, 2}, {4, 5, 0, 2}, {4, 6, 0, 2}, {4, 7, 0, 2}, {5, 3, 0, 2}, {5, 4, 0, 2}, {5, 5, 0, 2}, {8, 4, 3, 2}, {8, 5, 3, 2}, {8, 6, 3, 2}, {0, 5, 1, 3}, {0, 6, 1, 3}, {0, 4, 2, 3}, {0, 5, 2, 3}, {0, 6, 2, 3}, {0, 2, 3, 3}, {0, 3, 3, 3}, {0, 4, 3, 3}, {0, 5, 3, 3}, {0, 3, 6, 3}, {0, 4, 6, 3}, {0, 5, 6, 3}, {0, 5, 7, 3}, {0, 6, 7, 3}, {2, 3, 9, 0}, {2, 4, 9, 0}, {2, 5, 9, 0}, {2, 6, 9, 0}, {3, 5, 9, 0}, {3, 6, 9, 0}, {3, 7, 9, 0}, {3, 8, 9, 0}, {6, 2, 9, 0}, {6, 3, 9, 0}, {6, 4, 9, 0}, {7, 5, 9, 0}, {8, 5, 9, 0}, {8, 6, 9, 0}, {6, 2, 1, 1}, {6, 3, 1, 1}, {6, 4, 2, 1}, {6, 5, 2, 1}, {9, 3, 5, 1}, {9, 4, 5, 1}, {9, 5, 5, 1}, {9, 3, 8, 1}, {9, 4, 8, 1}, {9, 5, 8, 1}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2;
                int v = 5;
                int w = 5;
                while (u == 2 && (w == 5 || w == 7)) {
                    u = 2 + random.nextInt(2);
                    w = 3 + random.nextInt(5);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                if (VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 2) {
                    for (int[] uvw : new int[][]{{3, 1, 5}, {5, 1, 6}}) {
                        ArrayList<Object> arraylist_animal = new ArrayList<Object>();
                        if (VillageGeneratorConfigHandler.animaniaLivestock) {
                            for (String animal_namespace : ModObjects.animania_pig) {
                                EntityLiving testEntity = null;
                                try {
                                    testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(animal_namespace), (World)world);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (testEntity == null) continue;
                                for (int i = 0; i < 1; ++i) {
                                    arraylist_animal.add(testEntity);
                                }
                            }
                        }
                        if (arraylist_animal.isEmpty() && VillageGeneratorConfigHandler.villageAnimalRestrictionLevel < 1) {
                            arraylist_animal.add(new EntityPig(world));
                        }
                        if (arraylist_animal.isEmpty()) continue;
                        EntityLiving animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
                        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]))), null);
                        animal.func_70012_b((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)animal);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class JungleArmorerHouse
    extends StructureVillageVN.VNComponent {
        private static final String[] foundationPattern = new String[]{"  FFFFF  ", " FFFFFFF ", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", " FFFFFFF ", "  FPPPF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 2;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;
        private int averageGroundLevel = -1;

        public JungleArmorerHouse() {
        }

        public JungleArmorerHouse(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
            if (this.biome == null) {
                this.biome = start.field_74929_a.func_180631_a(new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, 64, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2));
            }
            if (this.materialType == null) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(this.biome);
            }
            if (this.villageType == null) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(this.biome);
            }
        }

        public static JungleArmorerHouse buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return JungleArmorerHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new JungleArmorerHouse(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{2, 0, 2, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 2, 0, 2})[this.func_186165_e().func_176736_b()]), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            this.populateVillageFields(world);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            for (int[] uuvvww : new int[][]{{0, 0, 3, 0, 0, 5}, {1, 0, 2, 1, 0, 6}, {2, 0, 1, 2, 0, 7}, {3, 0, 1, 3, 0, 2}, {3, 0, 5, 3, 0, 7}, {4, 0, 1, 4, 0, 2}, {4, 0, 6, 4, 0, 7}, {5, 0, 1, 5, 0, 3}, {5, 0, 6, 5, 0, 7}, {6, 0, 1, 6, 0, 7}, {7, 0, 2, 7, 0, 6}, {8, 0, 3, 8, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 2, 2, 1}, {4, 1, 1, 4, 2, 1}, {6, 1, 1, 6, 2, 1}, {2, 3, 1, 6, 3, 1}, {0, 1, 3, 0, 3, 3}, {0, 1, 5, 0, 3, 5}, {0, 1, 4, 0, 1, 4}, {0, 3, 4, 0, 3, 4}, {8, 1, 3, 8, 3, 3}, {8, 1, 5, 8, 3, 5}, {8, 1, 4, 8, 1, 4}, {8, 3, 4, 8, 3, 4}, {2, 1, 7, 2, 3, 7}, {6, 1, 7, 6, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 1, 6, 1, 3, 6}, {7, 1, 6, 7, 3, 6}, {1, 1, 2, 1, 3, 2}, {7, 1, 2, 7, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 4, 6, 6, 4, 6}, {2, 4, 2, 6, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 4, 3, 1, 4, 5}, {4, 4, 3, 4, 4, 5}, {7, 4, 3, 7, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 4, 1, 4, 4, 1}, {3, 6, 4, 5, 6, 4}, {4, 5, 6, 4, 5, 6}, {1, 4, 6, 1, 4, 6}, {7, 4, 6, 7, 4, 6}, {1, 4, 2, 1, 4, 2}, {7, 4, 2, 7, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 1, 3}, {2, 4, 1, 3}, {3, 4, 1, 3}, {5, 4, 1, 3}, {6, 4, 1, 3}, {7, 4, 1, 3}, {1, 5, 2, 3}, {2, 5, 2, 3}, {3, 5, 2, 3}, {4, 5, 2, 3}, {5, 5, 2, 3}, {6, 5, 2, 3}, {7, 5, 2, 3}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {0, 4, 6, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {8, 4, 2, 1}, {8, 4, 3, 1}, {8, 4, 4, 1}, {8, 4, 5, 1}, {8, 4, 6, 1}, {7, 5, 3, 1}, {7, 5, 4, 1}, {7, 5, 5, 1}, {1, 4, 7, 2}, {2, 4, 7, 2}, {3, 4, 7, 2}, {5, 4, 7, 2}, {6, 4, 7, 2}, {7, 4, 7, 2}, {1, 5, 6, 2}, {2, 5, 6, 2}, {3, 5, 6, 2}, {5, 5, 6, 2}, {6, 5, 6, 2}, {7, 5, 6, 2}, {2, 5, 3, 5}, {2, 5, 4, 5}, {2, 5, 5, 5}, {6, 5, 3, 4}, {6, 5, 4, 4}, {6, 5, 5, 4}, {1, 1, 3, 6}, {1, 1, 5, 7}, {7, 1, 3, 6}, {7, 1, 5, 7}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 6, 5, 6, 6, 5}, {2, 6, 4, 2, 6, 4}, {6, 6, 4, 6, 6, 4}, {2, 6, 3, 6, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 1, 1, 4}, {7, 1, 4, 7, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 4, 0, 4, 4, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 6, 3, 1, 6}, {4, 2, 6, 4, 2, 6}, {5, 1, 6, 5, 1, 6}, {3, 1, 7, 5, 3, 7}, {4, 4, 7, 4, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            Block biomeStoneBrickStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{3, 2, 6, 0}, {4, 3, 6, 3}, {5, 2, 6, 1}}) {
                this.func_175811_a(world, biomeStoneBrickStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            Block biomeTrapdoorBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvww : new int[][]{{2, 2, 6, 2}, {6, 2, 6, 2}, {2, 1, 6, 2}, {6, 1, 6, 2}}) {
                this.func_175811_a(world, biomeTrapdoorBlock.func_176203_a(StructureVillageVN.getTrapdoorMeta(uuvvww[3], true, false)), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 3, 0}, {4, 3, 4}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 2, 4}, {8, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{3, 0, 4, 0, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {5, 0, 4, 0, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {4, 0, 4, 1, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {4, 0, 3, 2, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {4, 0, 5, 2, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {3, 0, 3, 3, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {5, 0, 5, 3, GeneralConfig.useVillageColors ? this.townColor5 : 1}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 1, 6, 2}}) {
                IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(uvwo[3], this.func_186165_e());
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvwo[0], uvwo[1], uvwo[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), blastFurnaceState, 2);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}, {5, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{2, 4, 4, 1, GeneralConfig.useVillageColors ? this.townColor5 : 1}, {6, 4, 4, 3, GeneralConfig.useVillageColors ? this.townColor5 : 1}}) {
                int bannerXBB = uvwoc[0];
                int bannerYBB = uvwoc[1];
                int bannerZBB = uvwoc[2];
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(uvwoc[3], this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                modifystanding.func_74757_a("IsStanding", false);
                modifystanding.func_74768_a("Base", 15 - uvwoc[4]);
                tilebanner.func_145839_a(modifystanding);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 1, 2}, {1, 1, 1, 1, 1, 1}, {2, 1, 0, 2, 1, 0}, {8, 1, 2, 8, 1, 2}, {7, 1, 1, 7, 1, 1}, {6, 1, 0, 6, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{2, 1, 8, 0}, {3, 3, 8, 0}, {3, 2, 8, 0}, {3, 1, 8, 0}, {4, 4, 8, 0}, {4, 3, 8, 0}, {7, 2, 7, 0}, {7, 1, 7, 0}, {8, 3, 6, 1}, {8, 2, 6, 1}, {8, 1, 6, 1}, {0, 3, 2, 2}, {7, 3, 1, 2}, {7, 2, 1, 2}, {1, 2, 1, 3}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(5);
                int v = 1;
                int w = 2 + random.nextInt(4);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class JungleVilla
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"                ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "PPPPFFFFFFFFFFF ", "PPPPPFFFFFFFFFF ", "PPPPPPPFFFFFFFF ", "  PPPPPFFFFFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 3;
        private static final int INCREASE_MIN_U = 8;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 10;

        public JungleVilla() {
        }

        public JungleVilla(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 73, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 73, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            if (this.func_186165_e().func_176736_b() != 2) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 0 ? 3 : (this.func_186165_e().func_176736_b() == 1 ? 11 : 1)), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 1) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.EAST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() == 2) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 1) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 0 ? 1 : (this.func_186165_e().func_176736_b() == 2 ? 11 : 3)), EnumFacing.WEST, this.func_74877_c());
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{8, 10, 8, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 8, 10, 8})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 10})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{10, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)3, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            for (int[] grass_uw : new int[][]{{0, 4}, {1, 4}, {2, 4}, {3, 4}}) {
                this.func_175811_a(world, biomeGrassState, grass_uw[0], 0, grass_uw[1], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 5, 4, 1, 13}, {5, 1, 4, 5, 1, 13}, {6, 1, 3, 6, 1, 13}, {7, 1, 0, 7, 1, 13}, {8, 1, 0, 14, 1, 6}, {8, 1, 9, 12, 1, 9}, {8, 1, 12, 12, 1, 13}, {10, 1, 7, 10, 1, 8}, {10, 1, 10, 10, 1, 11}, {13, 1, 0, 14, 1, 13}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{4, 1, 4, 0}, {4, 1, 3, 3}, {5, 1, 3, 3}, {5, 1, 2, 0}, {6, 1, 2, 3}}) {
                this.func_175811_a(world, biomeCobblestoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 2, 5, 4, 2, 5}, {0, 2, 6, 0, 2, 13}, {1, 2, 13, 1, 2, 13}, {14, 2, 0, 14, 2, 2}, {7, 2, 0, 13, 2, 0}, {7, 2, 1, 7, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneWallState, biomeCobblestoneWallState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{10, 2, 1, 10, 3, 1}, {12, 2, 1, 12, 3, 1}, {14, 3, 1, 14, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwoc : new int[][]{{8, 1, 7, 1, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {9, 1, 7, 0, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {8, 1, 8, 2, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {9, 1, 8, 3, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {11, 1, 7, 0, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {12, 1, 7, 3, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {11, 1, 8, 1, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {12, 1, 8, 2, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {8, 1, 10, 2, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {9, 1, 10, 1, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {8, 1, 11, 3, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {9, 1, 11, 0, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {11, 1, 10, 3, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {12, 1, 10, 2, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {11, 1, 11, 0, GeneralConfig.useVillageColors ? this.townColor2 : 4}, {12, 1, 11, 1, GeneralConfig.useVillageColors ? this.townColor2 : 4}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], StructureVillageVN.chooseGlazedTerracottaMeta(uvwoc[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 9, 2, 2, 13}, {2, 2, 9, 2, 3, 9}, {2, 2, 11, 2, 3, 11}, {2, 2, 13, 2, 3, 13}, {2, 4, 9, 2, 4, 13}, {3, 4, 9, 6, 4, 9}, {4, 2, 9, 4, 3, 9}, {6, 2, 9, 6, 3, 9}, {7, 4, 6, 7, 4, 8}, {7, 2, 8, 7, 3, 8}, {7, 2, 6, 7, 3, 6}, {8, 4, 6, 9, 4, 6}, {9, 2, 6, 9, 3, 6}, {10, 4, 1, 10, 4, 5}, {10, 2, 5, 10, 3, 5}, {10, 2, 4, 10, 2, 4}, {10, 2, 3, 10, 3, 3}, {10, 4, 1, 14, 4, 3}, {11, 2, 3, 11, 3, 3}, {13, 2, 3, 14, 3, 3}, {14, 2, 4, 14, 2, 13}, {14, 3, 5, 14, 3, 5}, {14, 3, 7, 14, 3, 7}, {14, 3, 9, 14, 3, 9}, {14, 3, 11, 14, 3, 11}, {14, 3, 13, 14, 3, 13}, {14, 4, 4, 14, 4, 13}, {3, 2, 13, 13, 2, 13}, {4, 3, 13, 4, 3, 13}, {6, 3, 13, 6, 3, 13}, {8, 3, 13, 8, 3, 13}, {10, 3, 13, 10, 3, 13}, {12, 3, 13, 12, 3, 13}, {3, 4, 13, 13, 4, 13}, {2, 6, 9, 2, 6, 9}, {2, 6, 11, 2, 6, 11}, {2, 6, 13, 2, 6, 13}, {2, 7, 9, 2, 7, 13}, {4, 6, 9, 4, 6, 9}, {6, 6, 9, 6, 6, 9}, {8, 6, 9, 10, 6, 9}, {3, 7, 9, 10, 7, 9}, {10, 6, 5, 10, 7, 8}, {10, 7, 4, 10, 7, 4}, {10, 6, 3, 10, 7, 3}, {11, 7, 3, 11, 7, 3}, {12, 6, 3, 12, 8, 3}, {13, 7, 3, 13, 7, 3}, {14, 6, 3, 14, 7, 3}, {14, 6, 5, 14, 7, 5}, {14, 6, 7, 14, 7, 7}, {14, 6, 9, 14, 7, 9}, {14, 6, 11, 14, 7, 11}, {14, 6, 13, 14, 7, 13}, {14, 7, 4, 14, 7, 4}, {14, 7, 6, 14, 7, 6}, {14, 7, 8, 14, 7, 8}, {14, 7, 10, 14, 7, 10}, {14, 7, 12, 14, 7, 12}, {12, 6, 13, 12, 7, 13}, {10, 6, 13, 10, 7, 13}, {8, 6, 13, 8, 7, 13}, {6, 6, 13, 6, 7, 13}, {4, 6, 13, 4, 7, 13}, {13, 7, 13, 13, 7, 13}, {11, 7, 13, 11, 7, 13}, {9, 7, 13, 9, 7, 13}, {7, 7, 13, 7, 7, 13}, {5, 7, 13, 5, 7, 13}, {3, 7, 13, 3, 7, 13}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 0), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 2, 9, 7, 4, 9}, {10, 2, 6, 10, 4, 6}, {2, 5, 9, 10, 5, 9}, {10, 5, 3, 10, 5, 8}, {12, 5, 3, 14, 5, 3}, {14, 5, 4, 14, 5, 13}, {2, 5, 13, 13, 5, 13}, {2, 5, 10, 2, 5, 12}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, 5, 6, 7, 5, 8}, {8, 5, 6, 9, 5, 6}, {9, 6, 8, 9, 6, 8}, {11, 8, 3, 11, 8, 3}, {13, 8, 3, 13, 8, 3}, {11, 8, 5, 13, 8, 5}, {11, 8, 7, 13, 8, 7}, {11, 8, 9, 13, 8, 9}, {12, 8, 11, 13, 8, 11}, {12, 8, 12, 12, 8, 12}, {10, 8, 10, 10, 8, 12}, {8, 8, 10, 8, 8, 12}, {6, 8, 9, 6, 8, 13}, {4, 8, 10, 4, 8, 12}, {11, 8, 11, 11, 8, 11}, {12, 8, 10, 12, 8, 10}, {3, 2, 12, 3, 2, 12}, {8, 2, 12, 8, 2, 12}, {10, 2, 12, 10, 2, 12}, {13, 2, 9, 13, 2, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{11, 2, 12, 3}, {12, 2, 12, 3}, {13, 2, 12, 3}, {13, 2, 11, 0}, {13, 2, 10, 0}, {7, 2, 12, 0}, {8, 3, 12, 0}, {9, 4, 12, 0}, {13, 5, 10, 7}, {13, 5, 8, 6}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{9, 7, 2, 9, 7, 8}, {1, 7, 8, 8, 7, 8}, {1, 7, 9, 1, 7, 14}, {2, 7, 14, 15, 7, 14}, {15, 7, 2, 15, 7, 13}, {11, 8, 2, 11, 8, 2}, {13, 8, 2, 13, 8, 2}, {11, 8, 4, 13, 8, 4}, {11, 8, 6, 13, 8, 6}, {11, 8, 8, 13, 8, 8}, {11, 8, 10, 11, 8, 10}, {13, 8, 10, 13, 8, 10}, {11, 8, 12, 11, 8, 12}, {13, 8, 12, 13, 8, 12}, {9, 8, 10, 9, 8, 12}, {7, 8, 9, 7, 8, 13}, {5, 8, 9, 5, 8, 13}, {3, 8, 10, 3, 8, 12}, {3, 4, 10, 4, 4, 12}, {5, 4, 10, 9, 4, 11}, {8, 4, 9, 9, 4, 9}, {10, 4, 7, 10, 4, 12}, {10, 4, 7, 10, 4, 12}, {11, 4, 4, 13, 4, 12}, {13, 5, 9, 13, 5, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 5, 5, 6, 5, 8}, {7, 5, 5, 9, 5, 5}, {8, 6, 7, 8, 6, 8}, {9, 6, 7, 9, 6, 7}, {10, 8, 2, 10, 8, 9}, {8, 8, 9, 9, 8, 9}, {2, 8, 9, 4, 8, 9}, {2, 8, 10, 2, 8, 13}, {3, 8, 13, 4, 8, 13}, {8, 8, 13, 14, 8, 13}, {14, 8, 2, 14, 8, 12}, {12, 9, 2, 12, 9, 11}, {4, 9, 11, 11, 9, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState[] tableComponentBlockstates = ModObjects.chooseModWoodenTable(biomePlankState.func_177230_c() == Blocks.field_150344_f ? biomePlankState.func_177230_c().func_176201_c(biomePlankState) : 0);
            for (int[] uuvvww : new int[][]{{13, 5, 12}, {13, 5, 6}}) {
                for (int i = 1; i >= 0; --i) {
                    this.func_175811_a(world, tableComponentBlockstates[i], uuvvww[0], uuvvww[1] + 1 - i, uuvvww[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{10, 2, 9, 10, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uuvvww : new int[][]{{4, 5, 11, 4, 5, 12}, {4, 5, 11, 9, 5, 11}, {10, 5, 1, 10, 5, 2}, {11, 5, 1, 13, 5, 1}, {14, 5, 1, 14, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{2, 3, 10}, {2, 3, 12}, {3, 3, 13}, {5, 3, 13}, {7, 3, 13}, {9, 3, 13}, {11, 3, 13}, {13, 3, 13}, {14, 3, 12}, {14, 3, 10}, {14, 3, 8}, {14, 3, 6}, {14, 3, 4}, {10, 3, 4}, {2, 6, 10}, {2, 6, 12}, {3, 6, 13}, {5, 6, 13}, {7, 6, 13}, {9, 6, 13}, {11, 6, 13}, {13, 6, 13}, {14, 6, 12}, {14, 6, 10}, {14, 6, 8}, {14, 6, 6}, {14, 6, 4}, {13, 6, 3}, {10, 6, 4}, {3, 6, 9}, {5, 6, 9}, {7, 6, 9}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 3, 5, -1}, {0, 3, 5, -1}, {0, 3, 13, -1}, {14, 3, 0, -1}, {7, 3, 0, -1}, {7, 3, 2, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeHangingLanternState = ModObjects.chooseModLanternBlockState(true);
            for (int[] uvw : new int[][]{{4, 7, 11}, {12, 7, 11}, {12, 7, 5}}) {
                this.func_175811_a(world, biomeHangingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeSittingLanternState = ModObjects.chooseModLanternBlockState(false);
            for (int[] uvw : new int[][]{{10, 3, 12}, {13, 3, 9}}) {
                this.func_175811_a(world, biomeSittingLanternState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int flowernumber = 9;
            int potU = 13;
            int potV = 6;
            int potW = 9;
            int potX = this.func_74865_a(potU, potW);
            int potY = this.func_74862_a(potV);
            int potZ = this.func_74873_b(potU, potW);
            TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
            BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
            world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
            world.func_175690_a(flowerPotPos, flowerPot);
            int u = 3;
            int v = 3;
            int w = 12;
            int x = this.func_74865_a(u, w);
            int y = this.func_74862_a(v);
            int z = this.func_74873_b(u, w);
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int randomPottedPlant = random.nextInt(10) - 1;
            if (randomPottedPlant == -1) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
            } else {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            int chestU = 3;
            int chestV = 5;
            int chestW = 12;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwss : new int[][]{{-2, 1, 6, -1, 1}}) {
                Block dirtblock = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2]))).func_177230_c();
                Block saplingblock = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2]))).func_177230_c();
                if (dirtblock == null || dirtblock != Blocks.field_150346_d && dirtblock != Blocks.field_150349_c || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])))) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    Block dirtblock1 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))).func_177230_c();
                    Block dirtblock2 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))).func_177230_c();
                    Block dirtblock3 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]))).func_177230_c();
                    if (dirtblock1 == null || dirtblock2 == null || dirtblock3 == null || dirtblock1 != Blocks.field_150346_d && dirtblock1 != Blocks.field_150349_c || dirtblock2 != Blocks.field_150346_d && dirtblock2 != Blocks.field_150349_c || dirtblock3 != Blocks.field_150346_d && dirtblock3 != Blocks.field_150349_c || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4])))) continue;
                }
                this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2], structureBB);
                if (!(biomeSaplingState.func_177230_c() instanceof BlockSapling)) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                }
                ((BlockSapling)biomeSaplingState.func_177230_c()).func_176476_e(world, new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])), biomeSaplingState, world.field_73012_v);
            }
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signU = 1;
                int signV = 1;
                int signW = 4;
                int signO = 8;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                boolean hanging = false;
                TileEntitySign signContents = new TileEntitySign();
                String topLine = "Villa at";
                topLine = topLine.trim();
                if (this.namePrefix.length() + 1 + this.nameRoot.length() > 15) {
                    signContents.field_145915_a[0] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine.trim());
                    signContents.field_145915_a[1] = new TextComponentString(this.namePrefix.trim());
                    if (this.nameRoot.length() + 1 + this.nameSuffix.length() > 15) {
                        signContents.field_145915_a[2] = new TextComponentString(this.nameRoot.trim());
                        signContents.field_145915_a[3] = new TextComponentString(this.nameSuffix.trim());
                    } else {
                        signContents.field_145915_a[2] = new TextComponentString((this.nameRoot + " " + this.nameSuffix).trim());
                    }
                } else if (this.namePrefix.length() + 1 + this.nameRoot.length() + 1 + this.nameSuffix.length() <= 15) {
                    signContents.field_145915_a[1] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine);
                    signContents.field_145915_a[2] = new TextComponentString((this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                } else {
                    signContents.field_145915_a[1] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine.trim());
                    signContents.field_145915_a[2] = new TextComponentString((this.namePrefix + " " + this.nameRoot).trim());
                    signContents.field_145915_a[3] = new TextComponentString(this.nameSuffix.trim());
                }
                if (topLine.equals("")) {
                    for (int isign = 0; isign < 3; ++isign) {
                        signContents.field_145915_a[isign] = signContents.field_145915_a[isign + 1];
                    }
                    signContents.field_145915_a[3] = new TextComponentString("");
                }
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerU = 9;
                int bannerV = 4;
                int bannerW = 1;
                int bannerO = 3;
                boolean hanging = true;
                int bannerX = this.func_74865_a(bannerU, bannerW);
                int bannerY = this.func_74862_a(bannerV);
                int bannerZ = this.func_74873_b(bannerU, bannerW);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(bannerO, this.func_186165_e().func_176736_b(), true)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                NBTTagCompound modifystanding = new NBTTagCompound();
                tilebanner.func_189515_b(modifystanding);
                if (GeneralConfig.useVillageColors) {
                    tilebanner.func_145839_a(modifystanding);
                    ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                    tilebanner.func_175112_a(villageBanner, false);
                } else {
                    modifystanding.func_74768_a("Base", 15);
                    tilebanner.func_145839_a(modifystanding);
                }
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{12, 5, 2, -1, 0}, {6, 2, 4, -1, 0}, {12, 2, 11, -1, 0}, {3, 5, 11, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class JungleGarden
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"F     F     F     ", " FFFFFFFFFFFFFFFFF", " FFPFPFPFPFPFPFPPF", " FPPPPPPPPPPPPPPPF", " FFPFPFPFPFPFPFPPF", "FFPPPPPPPPPPPPPPPF", " FFPFPFFFFFFFFFPPP", "PPPPPPFFFFFFFFFPPP", "PPPPPPFFFFFFFFFPPP", "PPPPPPFFFFFFFFFPFF", "FFFFPPFFFFFFFFFPF ", "   FPPFFFFFFFFFPF ", " F FPPFFFFFFFFFPF ", "   FPPFFFFFFFFFPF ", "   FPPFFFFFFFFFPF ", "   FPPPPPPPPPPPPF ", "   FPPPFFFFFFPPPF ", "   FPPPFFFFFFPPPF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 11;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public JungleGarden() {
        }

        public JungleGarden(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 68, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 68, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            if (this.func_186165_e().func_176736_b() != 2) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 0 ? 4 : (this.func_186165_e().func_176736_b() == 1 ? 7 : (this.func_186165_e().func_176736_b() == 3 ? 8 : 0))), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                if (this.func_186165_e().func_176736_b() == 0) {
                    StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 13, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                }
            }
            if (this.func_186165_e().func_176736_b() != 3) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 0 ? 9 : (this.func_186165_e().func_176736_b() == 1 ? 4 : (this.func_186165_e().func_176736_b() == 2 ? 6 : 0))), EnumFacing.EAST, this.func_74877_c());
                if (this.func_186165_e().func_176736_b() == 1) {
                    StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 13, EnumFacing.EAST, this.func_74877_c());
                }
            }
            if (this.func_186165_e().func_176736_b() != 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 1 ? 6 : (this.func_186165_e().func_176736_b() == 2 ? 4 : (this.func_186165_e().func_176736_b() == 3 ? 9 : 0))), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                if (this.func_186165_e().func_176736_b() == 2) {
                    StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 13, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                }
            }
            if (this.func_186165_e().func_176736_b() != 1) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 0 ? 8 : (this.func_186165_e().func_176736_b() == 2 ? 7 : (this.func_186165_e().func_176736_b() == 3 ? 4 : 0))), EnumFacing.WEST, this.func_74877_c());
                if (this.func_186165_e().func_176736_b() == 3) {
                    StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 13, EnumFacing.WEST, this.func_74877_c());
                }
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)11, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{1, 1, 5}, {3, 1, 18}, {9, 1, 18}, {15, 1, 18}, {18, 1, 5}, {10, 1, -1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] grass_uw : new int[][]{{0, 7}, {0, 12}, {0, 17}, {1, 7}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {2, 7}, {2, 11}, {2, 13}, {2, 15}, {2, 16}, {3, 0}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 16}, {4, 11}, {4, 13}, {4, 15}, {4, 16}, {5, 16}, {6, 13}, {6, 15}, {6, 16}, {6, 17}, {7, 0}, {7, 1}, {7, 16}, {8, 0}, {8, 1}, {8, 13}, {8, 15}, {8, 16}, {9, 0}, {9, 1}, {9, 16}, {10, 0}, {10, 1}, {10, 13}, {10, 15}, {10, 16}, {11, 0}, {11, 1}, {11, 16}, {12, 0}, {12, 1}, {12, 13}, {12, 15}, {12, 16}, {12, 17}, {13, 16}, {14, 13}, {14, 15}, {14, 16}, {15, 16}, {16, 0}, {16, 1}, {16, 2}, {16, 3}, {16, 4}, {16, 5}, {16, 6}, {16, 7}, {16, 8}, {16, 16}, {17, 8}, {17, 12}, {17, 13}, {17, 14}, {17, 15}, {17, 16}}) {
                this.func_175811_a(world, biomeGrassState, grass_uw[0], 0, grass_uw[1], structureBB);
            }
            IBlockState biomeLeafState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150362_t.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 7, 3, 1, 7}, {3, 1, 1, 3, 1, 6}, {7, 1, 1, 12, 1, 1}, {16, 1, 1, 16, 1, 8}, {16, 1, 1, 17, 1, 1}, {1, 1, 12, 1, 1, 15}, {2, 1, 16, 16, 1, 16}, {17, 1, 12, 17, 1, 15}, {6, 1, 3, 6, 1, 3}, {6, 1, 11, 6, 1, 11}, {14, 1, 3, 14, 1, 3}, {14, 1, 11, 14, 1, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLeafState, biomeLeafState, false);
            }
            IBlockState biomePolishedDioriteBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150348_b.func_176203_a(4), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 0, 3, 6, 0, 3}, {6, 0, 11, 6, 0, 11}, {14, 0, 3, 14, 0, 3}, {14, 0, 11, 14, 0, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePolishedDioriteBlockState, biomePolishedDioriteBlockState, false);
            }
            IBlockState biomeDioriteWallState = ModObjects.chooseModDioriteWallState();
            if (biomeDioriteWallState == null) {
                biomeDioriteWallState = Blocks.field_150463_bK.func_176223_P();
            }
            biomeDioriteWallState = StructureVillageVN.getBiomeSpecificBlockState(biomeDioriteWallState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 15, 2, 2, 15}, {4, 1, 15, 4, 2, 15}, {6, 1, 15, 6, 2, 15}, {8, 1, 15, 8, 2, 15}, {10, 1, 15, 10, 2, 15}, {12, 1, 15, 12, 2, 15}, {14, 1, 15, 14, 2, 15}, {2, 1, 13, 2, 2, 13}, {4, 1, 13, 4, 2, 13}, {6, 1, 13, 6, 2, 13}, {8, 1, 13, 8, 2, 13}, {10, 1, 13, 10, 2, 13}, {12, 1, 13, 12, 2, 13}, {14, 1, 13, 14, 2, 13}, {2, 1, 11, 2, 2, 11}, {4, 1, 11, 4, 2, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDioriteWallState, biomeDioriteWallState, false);
            }
            this.func_74878_a(world, structureBB, 7, 0, 4, 13, 0, 10);
            IBlockState biomeDioriteBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150348_b.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 3, 15, 2, 3, 15}, {4, 3, 15, 4, 3, 15}, {6, 3, 15, 6, 3, 15}, {8, 3, 15, 8, 3, 15}, {10, 3, 15, 10, 3, 15}, {12, 3, 15, 12, 3, 15}, {14, 3, 15, 14, 3, 15}, {2, 3, 13, 2, 3, 13}, {4, 3, 13, 4, 3, 13}, {6, 3, 13, 6, 3, 13}, {8, 3, 13, 8, 3, 13}, {10, 3, 13, 10, 3, 13}, {12, 3, 13, 12, 3, 13}, {14, 3, 13, 14, 3, 13}, {2, 3, 11, 2, 3, 11}, {4, 3, 11, 4, 3, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDioriteBlockState, biomeDioriteBlockState, false);
            }
            IBlockState biomeDioriteSlabUpperState = ModObjects.chooseModDioriteSlabState(true);
            if (biomeDioriteSlabUpperState == null) {
                biomeDioriteSlabUpperState = Blocks.field_150333_U.func_176203_a(11);
            }
            biomeDioriteSlabUpperState = StructureVillageVN.getBiomeSpecificBlockState(biomeDioriteSlabUpperState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 3, 12}, {2, 3, 14}, {3, 3, 11}, {3, 3, 12}, {3, 3, 13}, {3, 3, 14}, {3, 3, 15}, {4, 3, 12}, {4, 3, 14}, {5, 3, 13}, {5, 3, 14}, {5, 3, 15}, {6, 3, 14}, {7, 3, 13}, {7, 3, 14}, {7, 3, 15}, {8, 3, 14}, {9, 3, 13}, {9, 3, 14}, {9, 3, 15}, {10, 3, 14}, {11, 3, 13}, {11, 3, 14}, {11, 3, 15}, {12, 3, 14}, {13, 3, 13}, {13, 3, 14}, {13, 3, 15}, {14, 3, 14}}) {
                this.func_175811_a(world, biomeDioriteSlabUpperState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomePolishedDioriteSlabLowerState = ModObjects.chooseModPolishedDioriteSlabState(false);
            if (biomePolishedDioriteSlabLowerState == null && (biomePolishedDioriteSlabLowerState = ModObjects.chooseModDioriteBrickSlabState(false)) == null && (biomePolishedDioriteSlabLowerState = ModObjects.chooseModDioriteSlabState(false)) == null) {
                biomePolishedDioriteSlabLowerState = Blocks.field_150333_U.func_176203_a(0);
            }
            biomePolishedDioriteSlabLowerState = StructureVillageVN.getBiomeSpecificBlockState(biomePolishedDioriteSlabLowerState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 11, 4, 4, 12}, {2, 4, 13, 14, 4, 15}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePolishedDioriteSlabLowerState, biomePolishedDioriteSlabLowerState, false);
            }
            Block biomeDioriteStairsBlock = ModObjects.chooseModDioriteStairsBlock();
            if (biomeDioriteStairsBlock == null) {
                biomeDioriteStairsBlock = Blocks.field_150446_ar;
            }
            biomeDioriteStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomeDioriteStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uvwo : new int[][]{{7, 0, 3, 2}, {8, 0, 3, 2}, {9, 0, 3, 2}, {10, 0, 3, 2}, {11, 0, 3, 2}, {12, 0, 3, 2}, {13, 0, 3, 2}, {6, 0, 4, 1}, {6, 0, 5, 1}, {6, 0, 6, 1}, {6, 0, 7, 1}, {6, 0, 8, 1}, {6, 0, 9, 1}, {6, 0, 10, 1}, {7, 0, 11, 3}, {8, 0, 11, 3}, {9, 0, 11, 3}, {10, 0, 11, 3}, {11, 0, 11, 3}, {12, 0, 11, 3}, {13, 0, 11, 3}, {14, 0, 4, 0}, {14, 0, 5, 0}, {14, 0, 6, 0}, {14, 0, 7, 0}, {14, 0, 8, 0}, {14, 0, 9, 0}, {14, 0, 10, 0}, {8, 0, 5, 3}, {9, 0, 5, 3}, {10, 0, 5, 3}, {11, 0, 5, 3}, {12, 0, 5, 1}, {12, 0, 6, 1}, {12, 0, 7, 1}, {12, 0, 8, 1}, {9, 0, 9, 2}, {10, 0, 9, 2}, {11, 0, 9, 2}, {12, 0, 9, 2}, {8, 0, 6, 0}, {8, 0, 7, 0}, {8, 0, 8, 0}, {8, 0, 9, 0}}) {
                this.func_175811_a(world, biomeDioriteStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeSandBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150354_m.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{7, -1, 4, 13, -1, 4}, {7, -1, 5, 7, -1, 9}, {7, -1, 10, 13, -1, 10}, {13, -1, 5, 13, -1, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandBlockState, biomeSandBlockState, false);
            }
            IBlockState biomeStoneBrickBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{8, -1, 5, 12, -1, 9}, {10, 0, 7, 10, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStoneBrickBlockState, biomeStoneBrickBlockState, false);
            }
            IBlockState biomeChiseledStoneBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{10, 1, 7, 10, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeChiseledStoneBrickState, biomeChiseledStoneBrickState, false);
            }
            this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), 10, 2, 7, structureBB);
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwss : new int[][]{{0, 1, 12, -1, 1}, {0, 1, 17, -1, 1}, {6, 1, 17, -1, 1}, {12, 1, 17, -1, 1}, {8, 1, 0, -1, -1}, {11, 1, 0, 1, -1}}) {
                Block dirtblock = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2]))).func_177230_c();
                if (dirtblock == null || dirtblock != Blocks.field_150346_d && dirtblock != Blocks.field_150349_c || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])))) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    Block dirtblock1 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))).func_177230_c();
                    Block dirtblock2 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))).func_177230_c();
                    Block dirtblock3 = world.func_180495_p(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1] - 1), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]))).func_177230_c();
                    if (dirtblock1 == null || dirtblock2 == null || dirtblock3 == null || dirtblock1 != Blocks.field_150346_d && dirtblock1 != Blocks.field_150349_c || dirtblock2 != Blocks.field_150346_d && dirtblock2 != Blocks.field_150349_c || dirtblock3 != Blocks.field_150346_d && dirtblock3 != Blocks.field_150349_c || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2] + uvwss[4]))) || !world.func_175710_j(new BlockPos(this.func_74865_a(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0] + uvwss[3], uvwss[2] + uvwss[4])))) continue;
                }
                this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2], structureBB);
                if (!(biomeSaplingState.func_177230_c() instanceof BlockSapling)) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                }
                ((BlockSapling)biomeSaplingState.func_177230_c()).func_176476_e(world, new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])), biomeSaplingState, world.field_73012_v);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{1, 2, 13, 3}, {1, 3, 13, 3}, {4, 2, 16, 0}, {4, 3, 16, 0}, {6, 2, 16, 0}, {6, 3, 16, 0}, {8, 2, 16, 0}, {8, 3, 16, 0}, {12, 3, 16, 0}, {12, 3, 16, 0}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signU = 1;
                int signV = 1;
                int signW = 11;
                int signO = 8;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                boolean hanging = false;
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerU = 1;
                int bannerV = 1;
                int bannerW = 7;
                int bannerO = 0;
                int bannerX = this.func_74865_a(bannerU, bannerW);
                int bannerY = this.func_74862_a(bannerV);
                int bannerZ = this.func_74873_b(bannerU, bannerW);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(bannerO, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{5, 1, 2, -1, 0}, {7, 1, 14, -1, 0}, {11, 1, 4, -1, 0}, {15, 1, 10, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class JungleCocoaTree
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"    PPP    ", "  PPPPPPP  ", " PPFFFFFPP ", " PFFFFFFFP ", "PPFFFFFFFPP", "PPFFFFFFFPP", "PPFFFFFFFPP", " PFFFFFFFP ", " PPFFFFFPP ", " PPPPPPPPP ", "    PPP    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 15;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public JungleCocoaTree() {
        }

        public JungleCocoaTree(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 74, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 74, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 4, EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 4, EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            Block biomeCobblestoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            for (int[] uuvvwwo : new int[][]{{4, 1, 2, 6, 1, 2, 3}, {7, 1, 2, 7, 1, 3, 1}, {8, 1, 3, 8, 1, 3, 3}, {8, 1, 4, 8, 1, 6, 1}, {7, 1, 7, 8, 1, 7, 2}, {7, 1, 8, 7, 1, 8, 1}, {4, 1, 8, 6, 1, 8, 2}, {3, 1, 7, 3, 1, 8, 0}, {2, 1, 7, 2, 1, 7, 2}, {2, 1, 4, 2, 1, 6, 0}, {2, 1, 3, 3, 1, 3, 3}, {3, 1, 2, 3, 1, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeCobblestoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] grass_uw : new int[][]{{3, 1, 4}, {3, 1, 5}, {4, 1, 4}, {4, 1, 6}, {4, 1, 7}, {5, 1, 3}, {5, 1, 5}, {5, 1, 7}, {6, 1, 3}, {6, 1, 6}, {7, 1, 5}}) {
                this.func_175811_a(world, biomeGrassState, grass_uw[0], grass_uw[1], grass_uw[2], structureBB);
            }
            IBlockState biomePodzolState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            for (int[] grass_uw : new int[][]{{3, 1, 6}, {4, 1, 3}, {4, 1, 5}, {5, 1, 4}, {5, 1, 6}, {6, 1, 4}, {6, 1, 5}, {6, 1, 7}, {7, 1, 4}, {7, 1, 6}}) {
                this.func_175811_a(world, biomePodzolState, grass_uw[0], grass_uw[1], grass_uw[2], structureBB);
            }
            for (int[] uw : new int[][]{{5, 2, 5, 5, 9, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], Blocks.field_150364_r.func_176203_a(3), Blocks.field_150364_r.func_176203_a(3), false);
            }
            for (int[] uuvvww : new int[][]{{3, 2, 4, 3, 2, 4}, {3, 2, 6, 3, 2, 6}, {4, 2, 5, 4, 2, 7}, {4, 3, 6, 4, 3, 6}, {5, 2, 3, 5, 2, 4}, {5, 3, 4, 5, 3, 4}, {5, 2, 6, 5, 2, 6}, {6, 2, 4, 6, 2, 5}, {7, 2, 5, 7, 2, 5}, {3, 7, 3, 4, 8, 7}, {5, 7, 3, 5, 8, 4}, {5, 7, 6, 5, 8, 7}, {6, 7, 3, 6, 8, 3}, {6, 7, 4, 7, 8, 7}, {4, 9, 5, 4, 10, 5}, {5, 9, 4, 5, 10, 4}, {6, 9, 5, 6, 10, 5}, {5, 9, 6, 5, 10, 6}, {5, 10, 5, 5, 10, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150362_t.func_176203_a(3), Blocks.field_150362_t.func_176203_a(3), false);
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int[] uvwo : new int[][]{{4, 3, 5, 3}, {5, 3, 6, 0}, {5, 5, 6, 0}, {5, 6, 6, 0}, {6, 5, 5, 1}, {5, 5, 4, 2}, {5, 6, 4, 2}}) {
                    if (!world.func_175623_d(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])))) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176203_a(StructureVillageVN.chooseVineMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                }
            }
            if (this.villageType == FunctionsVN.VillageType.JUNGLE || this.villageType == FunctionsVN.VillageType.SWAMP) {
                for (int i = 0; i < 5; ++i) {
                    int v;
                    int w;
                    int u;
                    int side = random.nextInt(4);
                    switch (side) {
                        case 0: {
                            u = 5;
                            w = 6;
                            v = 4 + (random.nextBoolean() ? 1 : 0) + (random.nextBoolean() ? 1 : 0);
                            break;
                        }
                        case 1: {
                            u = 6;
                            w = 5;
                            v = 4 + (random.nextBoolean() ? 1 : 0) + (random.nextBoolean() ? 1 : 0);
                            break;
                        }
                        default: {
                            u = 5;
                            w = 4;
                            v = 4 + (random.nextBoolean() ? 1 : 0) + (random.nextBoolean() ? 1 : 0);
                            break;
                        }
                        case 3: {
                            u = 4;
                            w = 5;
                            v = 4 + (random.nextBoolean() ? 1 : 0) + (random.nextBoolean() ? 1 : 0);
                        }
                    }
                    this.func_175811_a(world, Blocks.field_150375_by.func_176203_a(StructureVillageVN.getCocoaPodOrientationMeta(side, this.func_186165_e(), random.nextInt(3))), u, v, w, structureBB);
                    if (random.nextInt(4) == 0) break;
                }
            }
            for (int[] uvw : new int[][]{{3, 2, 5}, {5, 2, 7}, {6, 2, 6}}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signU = 2;
                int signV = 1;
                int signW = 2;
                int signO = 8;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                boolean hanging = false;
                this.func_175811_a(world, biomeCobblestoneState, signU, signV - 1, signW, structureBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerU = 8;
                int bannerV = 1;
                int bannerW = 2;
                int bannerO = 8;
                boolean hanging = false;
                this.func_175811_a(world, biomeCobblestoneState, bannerU, bannerV - 1, bannerW, structureBB);
                int bannerX = this.func_74865_a(bannerU, bannerW);
                int bannerY = this.func_74862_a(bannerV);
                int bannerZ = this.func_74873_b(bannerU, bannerW);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_180501_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(bannerO, this.func_186165_e().func_176736_b(), false)), 2);
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{1, 1, 5, -1, 0}, {8, 1, 8, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class JungleStatue
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"  PPFFPPF  ", " PPPPPPPPP ", " PFPPPPPPF ", "PPPPFFFFPPP", "PPPFFFFFPPP", "PPPFFFFFPPP", " PPPFFFFPPF", " FPPPPPPPP ", "  FPPPPPP  ", "    PPPFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        public static final int GROUND_LEVEL = 1;
        public static final byte MEDIAN_BORDERS = 11;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private static final int INCREASE_MIN_W = 0;
        private static final int DECREASE_MAX_W = 0;

        public JungleStatue() {
        }

        public JungleStatue(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 73, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 73, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            if (this.func_186165_e().func_176736_b() != 2) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 1 ? 3 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 3) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 2 ? 3 : 4), EnumFacing.EAST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 1 ? 3 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 1) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 2 ? 3 : 4), EnumFacing.WEST, this.func_74877_c());
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeDioriteWallState;
            IBlockState biomeDioriteBlockState;
            Block biomeDioriteStairsBlock;
            IBlockState biomePolishedDioriteBlockState;
            Block biomePolishedDioriteStairsBlock;
            if (this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78896_c + (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78893_d - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78892_f - (new int[]{0, 0, 0, 0})[this.func_186165_e().func_176736_b()]), true, (byte)11, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.clearSpaceAbove(world, structureBB, STRUCTURE_WIDTH, STRUCTURE_DEPTH, 1);
            this.establishFoundation(world, structureBB, foundationPattern, 1, this.materialType, this.disallowModSubs, this.biome, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeTopState, FunctionsVN.shouldUseCobblestoneFoundation(this.biome) ? biomeCobblestoneState : biomeFillerState);
            BlockPos signpos = new BlockPos(6, 2, 2);
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(signpos.func_177958_n(), signpos.func_177952_p()), this.func_74862_a(signpos.func_177956_o()), this.func_74873_b(signpos.func_177958_n(), signpos.func_177952_p()));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] decorUVW = new int[][]{{0, 1, 0}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorHeightY;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                if (this.decorHeightY.size() < j + 1) {
                    decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.field_74887_e.field_78895_b;
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = (Integer)this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                this.makeBlueprint(decorBlueprint, world, decorHeightY, uvw, structureBB, biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] grass_uw : new int[][]{{1, 2}, {2, 1}, {2, 7}, {3, 4}, {3, 5}, {4, 9}, {5, 9}, {7, 0}, {8, 0}, {8, 9}, {9, 7}, {10, 3}}) {
                this.func_175811_a(world, biomeGrassState, grass_uw[0], 0, grass_uw[1], structureBB);
            }
            for (int[] uvwg : new int[][]{{8, 1, 0, 0}, {10, 1, 3, 0}, {7, 1, 0, 1}}) {
                if (uvwg[3] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uvwg[0], uvwg[1], uvwg[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uvwg[0], uvwg[1], uvwg[2], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uvwg[0], uvwg[1] + 1, uvwg[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 0, 3, 7, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor5 : 1), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor5 : 1), false);
            }
            boolean useOnlyStone = false;
            while (true) {
                if (useOnlyStone) {
                    biomePolishedDioriteStairsBlock = Blocks.field_150390_bg;
                } else {
                    biomePolishedDioriteStairsBlock = ModObjects.chooseModPolishedDioriteStairsBlock();
                    if (biomePolishedDioriteStairsBlock == null && (biomePolishedDioriteStairsBlock = ModObjects.chooseModDioriteBrickStairsBlock()) == null && (biomePolishedDioriteStairsBlock = ModObjects.chooseModDioriteStairsBlock()) == null) {
                        useOnlyStone = true;
                        continue;
                    }
                }
                biomePolishedDioriteStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomePolishedDioriteStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
                biomePolishedDioriteBlockState = Blocks.field_150348_b.func_176203_a(4);
                if (useOnlyStone) {
                    biomePolishedDioriteBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
                }
                if (useOnlyStone) {
                    biomeDioriteStairsBlock = Blocks.field_150446_ar;
                } else {
                    biomeDioriteStairsBlock = ModObjects.chooseModDioriteStairsBlock();
                    if (biomeDioriteStairsBlock == null) {
                        useOnlyStone = true;
                        continue;
                    }
                }
                biomeDioriteStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(biomeDioriteStairsBlock.func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
                biomeDioriteBlockState = Blocks.field_150348_b.func_176203_a(3);
                if (useOnlyStone) {
                    biomeDioriteBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
                }
                if (useOnlyStone) {
                    biomeDioriteWallState = Blocks.field_150463_bK.func_176203_a(0);
                    break;
                }
                biomeDioriteWallState = ModObjects.chooseModDioriteWallState();
                if (biomeDioriteWallState != null) break;
                biomeDioriteWallState = Blocks.field_150463_bK.func_176203_a(0);
                useOnlyStone = true;
            }
            biomeDioriteWallState = StructureVillageVN.getBiomeSpecificBlockState(biomeDioriteWallState, this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 3, 3, 3}, {5, 3, 3, 3}, {6, 3, 3, 3}, {7, 3, 3, 1}, {7, 3, 4, 1}, {7, 3, 5, 1}, {7, 3, 6, 2}, {6, 3, 6, 2}, {5, 3, 6, 2}, {4, 3, 6, 0}, {4, 3, 5, 0}, {4, 3, 4, 0}, {5, 4, 4, 3}, {6, 4, 5, 3}, {5, 9, 4, 3}, {6, 9, 4, 1}, {6, 9, 5, 2}, {5, 9, 5, 0}}) {
                this.func_175811_a(world, biomePolishedDioriteStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 3, 4, 6, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePolishedDioriteBlockState, biomePolishedDioriteBlockState, false);
            }
            for (int[] uvwo : new int[][]{{5, 5, 5, 6}, {5, 5, 4, 7}, {5, 6, 4, 3}}) {
                this.func_175811_a(world, biomeDioriteStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 6, 5, 6, 7, 5}, {6, 5, 5, 6, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDioriteBlockState, biomeDioriteBlockState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 6, 4, 4, 6, 5}, {4, 7, 5, 4, 7, 5}, {7, 7, 3, 7, 7, 5}, {5, 8, 4, 6, 8, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDioriteWallState, biomeDioriteWallState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 4, 4, 4, 5, 4}, {4, 7, 4, 4, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState campfireState = ModObjects.chooseModCampfireBlockState(random.nextInt(4), this.func_186165_e());
            for (int[] uvw : new int[][]{{4, 8, 4}}) {
                if (campfireState.func_177230_c() == Block.func_149684_b((String)"campfire:campfire")) {
                    int woodmeta = biomePlankState.func_177230_c().func_176201_c(biomePlankState);
                    ModObjects.setModCampfireBlockstate(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), woodmeta);
                    continue;
                }
                this.func_175811_a(world, campfireState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int u = 7;
            int v = 8;
            int w = 3;
            int x = this.func_74865_a(u, w);
            int y = this.func_74862_a(v);
            int z = this.func_74873_b(u, w);
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int randomPottedPlant = random.nextInt(10) - 1;
            if (randomPottedPlant == -1) {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150327_N, 0);
            } else {
                StructureVillageVN.generateStructureFlowerPot(world, structureBB, random, new BlockPos(x, y, z), (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (!(!GeneralConfig.nameSign || Loader.isModLoaded((String)"toroquest") && GeneralConfig.TQVillageNames)) {
                int signU = 6;
                int signV = 2;
                int signW = 2;
                int signO = 2;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                boolean hanging = true;
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                signU = 5;
                signX = this.func_74865_a(signU, signW);
                signZ = this.func_74873_b(signU, signW);
                signContents = new TileEntitySign();
                String topLine = "Founder:";
                topLine = topLine.trim();
                String[] founderName = NameGenerator.newRandomName("villager", random);
                String founderPrefix = founderName[1];
                String founderRoot = founderName[2];
                String founderSuffix = founderName[3];
                if (founderPrefix.length() + 1 + founderRoot.length() > 15) {
                    signContents.field_145915_a[0] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine.trim());
                    signContents.field_145915_a[1] = new TextComponentString(founderPrefix.trim());
                    if (founderRoot.length() + 1 + founderSuffix.length() > 15) {
                        signContents.field_145915_a[2] = new TextComponentString(founderRoot.trim());
                        signContents.field_145915_a[3] = new TextComponentString(founderSuffix.trim());
                    } else {
                        signContents.field_145915_a[2] = new TextComponentString((founderRoot + " " + founderSuffix).trim());
                    }
                } else if (founderPrefix.length() + 1 + founderRoot.length() + 1 + founderSuffix.length() <= 15) {
                    signContents.field_145915_a[1] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine);
                    signContents.field_145915_a[2] = new TextComponentString((founderPrefix + " " + founderRoot + " " + founderSuffix).trim());
                } else {
                    signContents.field_145915_a[1] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine.trim());
                    signContents.field_145915_a[2] = new TextComponentString((founderPrefix + " " + founderRoot).trim());
                    signContents.field_145915_a[3] = new TextComponentString(founderSuffix.trim());
                }
                if (topLine.equals("")) {
                    for (int isign = 0; isign < 3; ++isign) {
                        signContents.field_145915_a[isign] = signContents.field_145915_a[isign + 1];
                    }
                    signContents.field_145915_a[3] = new TextComponentString("");
                }
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(signO, this.func_186165_e().func_176736_b(), hanging)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int[] nArray = new int[]{5, 6};
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int capeU;
                    int bannerU = capeU = nArray[i];
                    int bannerV = 7;
                    int bannerW = 6;
                    int bannerO = 0;
                    boolean hanging = true;
                    int bannerX = this.func_74865_a(bannerU, bannerW);
                    int bannerY = this.func_74862_a(bannerV);
                    int bannerZ = this.func_74873_b(bannerU, bannerW);
                    BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                    world.func_180501_a(bannerPos, Blocks.field_180394_cL.func_176203_a(StructureVillageVN.getSignRotationMeta(bannerO, this.func_186165_e().func_176736_b(), true)), 2);
                    TileEntityBanner tilebanner = new TileEntityBanner();
                    NBTTagCompound modifystanding = new NBTTagCompound();
                    tilebanner.func_189515_b(modifystanding);
                    ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                    tilebanner.func_175112_a(villageBanner, false);
                    world.func_175690_a(bannerPos, (TileEntity)tilebanner);
                }
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{2, 1, 3, -1, 0}, {2, 1, 3, -1, 0}, {5, 1, 8, -1, 0}, {9, 1, 5, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }
}

