/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village;

import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.DesertStructures;
import astrotibs.villagenames.village.biomestructures.JungleStructures;
import astrotibs.villagenames.village.biomestructures.PlainsStructures;
import astrotibs.villagenames.village.biomestructures.SavannaStructures;
import astrotibs.villagenames.village.biomestructures.SnowyStructures;
import astrotibs.villagenames.village.biomestructures.SwampStructures;
import astrotibs.villagenames.village.biomestructures.TaigaStructures;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class MapGenVillageVN
extends MapGenVillage {
    private float size = 0.0f;
    private int distance;
    private int minTownSeparation = VillageGeneratorConfigHandler.newVillageSpacingMedian - VillageGeneratorConfigHandler.newVillageSpacingSpread;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitMapGen(InitMapGenEvent event) {
        if (event.getType() == InitMapGenEvent.EventType.VILLAGE && VillageGeneratorConfigHandler.newVillageGenerator) {
            try {
                event.setNewGen((MapGenBase)new MapGenVillageVN());
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public MapGenVillageVN() {
        if (this.minTownSeparation < 1) {
            this.minTownSeparation = 1;
        }
        this.distance = VillageGeneratorConfigHandler.newVillageSpacingMedian + VillageGeneratorConfigHandler.newVillageSpacingSpread;
    }

    public MapGenVillageVN(Map par1Map) {
        this();
        for (Map.Entry entry : par1Map.entrySet()) {
            if (((String)entry.getKey()).equals("size")) {
                this.size = (float)MathHelper.func_82713_a((String)((String)entry.getValue()), (double)this.size, (double)0.0);
                continue;
            }
            if (!((String)entry.getKey()).equals("distance")) continue;
            this.distance = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)this.distance, (int)(this.minTownSeparation + 1));
        }
    }

    public String func_143025_a() {
        return "Village";
    }

    protected boolean func_75047_a(int chunkXin, int chunkZin) {
        int noVillagesRadius = VillageGeneratorConfigHandler.noVillagesRadius;
        if (chunkXin * chunkXin + chunkZin * chunkZin < noVillagesRadius * noVillagesRadius) {
            return false;
        }
        int chunkX = chunkXin;
        int chunkZ = chunkZin;
        if (chunkXin < 0) {
            chunkXin -= this.distance - 1;
        }
        if (chunkZin < 0) {
            chunkZin -= this.distance - 1;
        }
        int chunkXModulated = chunkXin / this.distance;
        int chunkZModulated = chunkZin / this.distance;
        Random random = this.field_75039_c.func_72843_D(chunkXModulated, chunkZModulated, 10387312);
        chunkXModulated *= this.distance;
        chunkZModulated *= this.distance;
        if (chunkX == (chunkXModulated += random.nextInt(this.distance - this.minTownSeparation)) && chunkZ == (chunkZModulated += random.nextInt(this.distance - this.minTownSeparation))) {
            Biome biome = this.field_75039_c.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8));
            if (VillageGeneratorConfigHandler.spawnBiomesNames != null) {
                Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
                for (int i = 0; i < mappedBiomes.get("BiomeNames").size(); ++i) {
                    if (!mappedBiomes.get("BiomeNames").get(i).equals((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"}))) continue;
                    BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
                    return true;
                }
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        double halfrange;
        float randomizedVillageSize;
        int order = VillageGeneratorConfigHandler.newVillageSizeNormalOrder;
        do {
            randomizedVillageSize = 0.0f;
            for (int n = 0; n < VillageGeneratorConfigHandler.newVillageSizeNormalOrder; ++n) {
                randomizedVillageSize += this.field_75038_b.nextFloat();
            }
            randomizedVillageSize /= (float)VillageGeneratorConfigHandler.newVillageSizeNormalOrder;
            halfrange = MathHelper.func_76132_a((double)(VillageGeneratorConfigHandler.newVillageSizeMaximum - VillageGeneratorConfigHandler.newVillageSizeMode), (double)(VillageGeneratorConfigHandler.newVillageSizeMode - VillageGeneratorConfigHandler.newVillageSizeMinimum));
            randomizedVillageSize = (float)((double)randomizedVillageSize * (2.0 * halfrange));
        } while ((randomizedVillageSize = (float)((double)randomizedVillageSize + ((double)VillageGeneratorConfigHandler.newVillageSizeMode - halfrange))) > VillageGeneratorConfigHandler.newVillageSizeMaximum || randomizedVillageSize < VillageGeneratorConfigHandler.newVillageSizeMinimum);
        this.size = randomizedVillageSize - 1.0f;
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.size);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World world, Random random, int chunkX, int chunkZ, float villageSize) {
            super(chunkX, chunkZ);
            int counter;
            double[] townCenterWeightArray;
            StructureVillageVN.StartVN[] townCenterElementArray;
            FunctionsVN.VillageType startVillageType;
            int posX = (chunkX << 4) + 2;
            int posZ = (chunkZ << 4) + 2;
            BiomeProvider biomeProvider = world.func_72959_q();
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            try {
                String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                startVillageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
            }
            catch (Exception e) {
                startVillageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
            }
            List list = StructureVillageVN.getStructureVillageWeightedPieceList(random, villageSize, startVillageType);
            if (GeneralConfig.debugMessages) {
                Map<String, ArrayList> mappedComponentVillageTypes = VillageGeneratorConfigHandler.unpackComponentVillageTypes(VillageGeneratorConfigHandler.componentVillageTypes);
                Map<String, ArrayList> mappedComponentVillageTypesNonModDefaults = VillageGeneratorConfigHandler.unpackComponentVillageTypes(VillageGeneratorConfigHandler.MODERN_VANILLA_COMPONENT_VILLAGE_TYPE_DEFAULTS);
                Iterator iterator = list.iterator();
                boolean unmappedComponent = false;
                ArrayList<StructureVillagePieces.PieceWeight> unmapped_mod_components = new ArrayList<StructureVillagePieces.PieceWeight>();
                while (iterator.hasNext()) {
                    StructureVillagePieces.PieceWeight pw = (StructureVillagePieces.PieceWeight)iterator.next();
                    if (mappedComponentVillageTypes.get("ClassPaths").contains(pw.field_75090_a.toString().substring(6))) continue;
                    if (mappedComponentVillageTypesNonModDefaults.get("ClassPaths").contains(pw.field_75090_a.toString().substring(6))) {
                        int classPathListIndexNonModDefaults = mappedComponentVillageTypesNonModDefaults.get("ClassPaths").indexOf(pw.field_75090_a.toString().substring(6));
                        if (classPathListIndexNonModDefaults == -1) continue;
                        LogHelper.warn("A village queued Village Names building component " + pw.field_75090_a.toString().substring(6) + " which does not appear in your \"Component Village Types\" config entry. Its default biome type of " + ((String)mappedComponentVillageTypesNonModDefaults.get("VillageTypes").get(classPathListIndexNonModDefaults)).trim().toLowerCase() + " will be used.");
                        continue;
                    }
                    unmapped_mod_components.add(pw);
                }
                if (unmapped_mod_components.size() > 0) {
                    LogHelper.warn("A village queued the following modded village components which do not appear in your \"Component Village Types\" config entry. They will be registered for all village types until otherwise specified:");
                    for (StructureVillagePieces.PieceWeight pw_unmapped : unmapped_mod_components) {
                        LogHelper.warn("Weight " + pw_unmapped.field_75088_b + ", Limit " + pw_unmapped.field_75087_d + ": " + pw_unmapped.field_75090_a.toString().substring(6));
                    }
                }
            }
            StructureVillageVN.StartVN start = null;
            StructureVillageVN.StartVN[] plainsStarters = new StructureVillageVN.StartVN[]{new PlainsStructures.PlainsFountain01(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new PlainsStructures.PlainsMeetingPoint1(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new PlainsStructures.PlainsMeetingPoint2(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new PlainsStructures.PlainsMeetingPoint3(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize)};
            StructureVillageVN.StartVN[] desertStarters = new StructureVillageVN.StartVN[]{new DesertStructures.DesertMeetingPoint1(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new DesertStructures.DesertMeetingPoint2(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new DesertStructures.DesertMeetingPoint3(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize)};
            StructureVillageVN.StartVN[] taigaStarters = new StructureVillageVN.StartVN[]{new TaigaStructures.TaigaMeetingPoint1(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new TaigaStructures.TaigaMeetingPoint2(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize)};
            StructureVillageVN.StartVN[] savannaStarters = new StructureVillageVN.StartVN[]{new SavannaStructures.SavannaMeetingPoint1(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SavannaStructures.SavannaMeetingPoint2(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SavannaStructures.SavannaMeetingPoint3(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SavannaStructures.SavannaMeetingPoint4(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize)};
            StructureVillageVN.StartVN[] snowyStarters = new StructureVillageVN.StartVN[]{new SnowyStructures.SnowyMeetingPoint1(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SnowyStructures.SnowyMeetingPoint2(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SnowyStructures.SnowyMeetingPoint3(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize)};
            StructureVillageVN.StartVN[] jungleStarters = new StructureVillageVN.StartVN[]{new JungleStructures.JungleStatue(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new JungleStructures.JungleCocoaTree(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new JungleStructures.JungleGarden(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new JungleStructures.JungleVilla(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize)};
            StructureVillageVN.StartVN[] swampStarters = new StructureVillageVN.StartVN[]{new SwampStructures.SwampWillow(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SwampStructures.SwampStatue(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SwampStructures.SwampPavilion(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize), new SwampStructures.SwampMonolith(world.func_72959_q(), 0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2, list, villageSize)};
            if (startVillageType == FunctionsVN.VillageType.DESERT) {
                townCenterElementArray = desertStarters;
                townCenterWeightArray = new double[]{VillageGeneratorConfigHandler.componentModernDesertFountain, VillageGeneratorConfigHandler.componentModernDesertWell, VillageGeneratorConfigHandler.componentModernDesertMarket};
            } else if (startVillageType == FunctionsVN.VillageType.TAIGA) {
                townCenterElementArray = taigaStarters;
                townCenterWeightArray = new double[]{VillageGeneratorConfigHandler.componentModernTaigaSquare, VillageGeneratorConfigHandler.componentModernTaigaWell};
            } else if (startVillageType == FunctionsVN.VillageType.SAVANNA) {
                townCenterElementArray = savannaStarters;
                townCenterWeightArray = new double[]{VillageGeneratorConfigHandler.componentModernSavannaMarket, VillageGeneratorConfigHandler.componentModernSavannaFountain, VillageGeneratorConfigHandler.componentModernSavannaDoubleWell, VillageGeneratorConfigHandler.componentModernSavannaWell};
            } else if (startVillageType == FunctionsVN.VillageType.SNOWY) {
                townCenterElementArray = snowyStarters;
                townCenterWeightArray = new double[]{VillageGeneratorConfigHandler.componentModernSnowyIceSpire, VillageGeneratorConfigHandler.componentModernSnowyFountain, VillageGeneratorConfigHandler.componentModernSnowyPavilion};
            } else if (startVillageType == FunctionsVN.VillageType.JUNGLE) {
                townCenterElementArray = jungleStarters;
                townCenterWeightArray = new double[]{VillageGeneratorConfigHandler.componentModernJungleStatue, VillageGeneratorConfigHandler.componentModernJungleCocoaTree, VillageGeneratorConfigHandler.componentModernJungleGarden, VillageGeneratorConfigHandler.componentModernJungleVilla};
            } else if (startVillageType == FunctionsVN.VillageType.SWAMP) {
                townCenterElementArray = swampStarters;
                townCenterWeightArray = new double[]{VillageGeneratorConfigHandler.componentModernSwampWillow, VillageGeneratorConfigHandler.componentModernSwampStatue, VillageGeneratorConfigHandler.componentModernSwampPavilion, VillageGeneratorConfigHandler.componentModernSwampMonolith};
            } else {
                townCenterElementArray = plainsStarters;
                townCenterWeightArray = new double[]{VillageGeneratorConfigHandler.componentModernPlainsFountain, VillageGeneratorConfigHandler.componentModernPlainsWell, VillageGeneratorConfigHandler.componentModernPlainsMarket, VillageGeneratorConfigHandler.componentModernPlainsOakTree};
            }
            double totalWeight = 0.0;
            for (int i = 0; i < townCenterWeightArray.length; ++i) {
                totalWeight += townCenterWeightArray[i];
            }
            start = totalWeight <= 0.0 ? plainsStarters[1] : (StructureVillageVN.StartVN)((Object)FunctionsVN.weightedRandom(townCenterElementArray, townCenterWeightArray, random));
            this.field_75075_a.add(start);
            start.func_74861_a((StructureComponent)start, this.field_75075_a, random);
            List paths = start.field_74930_j;
            List components = start.field_74932_i;
            while (!paths.isEmpty() || !components.isEmpty()) {
                StructureComponent structurecomponent;
                if (paths.isEmpty()) {
                    counter = random.nextInt(components.size());
                    structurecomponent = (StructureComponent)components.remove(counter);
                    structurecomponent.func_74861_a((StructureComponent)start, this.field_75075_a, random);
                    continue;
                }
                counter = random.nextInt(paths.size());
                structurecomponent = (StructureComponent)paths.remove(counter);
                structurecomponent.func_74861_a((StructureComponent)start, this.field_75075_a, random);
            }
            this.func_75072_c();
            counter = 0;
            for (StructureComponent structurecomponent_temp : this.field_75075_a) {
                if (structurecomponent_temp instanceof StructureVillagePieces.Road) continue;
                ++counter;
            }
            this.hasMoreThanTwoComponents = counter > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.hasMoreThanTwoComponents = tagCompound.func_74767_n("Valid");
        }
    }
}

