/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.version;

import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.utility.Reference;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.IOUtils;

public class VersionChecker
extends Thread {
    public static VersionChecker instance = new VersionChecker();
    private static boolean isLatestVersion = false;
    private static boolean warnaboutfailure = false;
    private static String latestVersion = "";
    private static boolean isUpdateCheckFinished = false;
    private static boolean quitChecking = false;
    private static boolean hasThreadStarted = false;
    private static final String CHECK_FOR_VERSIONS_AT_URL = "You can check for new versions at https://modrinth.com/mod/village-names";

    @Override
    public void run() {
        InputStream in;
        block9: {
            in = null;
            try {
                URL url = new URL("https://gitgud.io/AstroTibs/VillageNames/-/raw/1.12.2/CURRENT_VERSION");
                in = url.openStream();
            }
            catch (Exception e) {
                if (warnaboutfailure) break block9;
                LogHelper.error("Could not connect with server to compare Village Names version");
                LogHelper.error(CHECK_FOR_VERSIONS_AT_URL);
                warnaboutfailure = true;
            }
        }
        try {
            latestVersion = (String)IOUtils.readLines((InputStream)in, (Charset)Charset.defaultCharset()).get(0);
        }
        catch (Exception e) {
            if (!warnaboutfailure) {
                LogHelper.error("Failed to compare Village Names version");
                LogHelper.error(CHECK_FOR_VERSIONS_AT_URL);
                warnaboutfailure = true;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        isLatestVersion = "4.4.13".equals(latestVersion);
        if (!(this.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null))) {
            LogHelper.info("This version of " + Reference.MOD_NAME_COLORIZED + " (" + "4.4.13" + ") differs from the latest version: " + latestVersion);
        }
        isUpdateCheckFinished = true;
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getLatestVersion() {
        return latestVersion;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if ((latestVersion.equals(null) || latestVersion.equals("")) && !warnaboutfailure && !hasThreadStarted) {
            this.start();
            hasThreadStarted = true;
        }
        if (event.player.field_70173_aa >= 200 && !quitChecking && isUpdateCheckFinished) {
            LogHelper.error("Village Names version check failed.");
            LogHelper.error(CHECK_FOR_VERSIONS_AT_URL);
            quitChecking = true;
        }
        if (event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END && event.player.field_70173_aa >= 30 && isUpdateCheckFinished && !quitChecking && GeneralConfig.versionChecker && !instance.isLatestVersion() && !latestVersion.equals(null) && !latestVersion.equals("") && !"4.4.13".contains("DEV")) {
            quitChecking = true;
            event.player.func_145747_a((ITextComponent)new TextComponentString(Reference.MOD_NAME_COLORIZED + TextFormatting.RESET + " version " + TextFormatting.YELLOW + this.getLatestVersion() + TextFormatting.RESET + " is available! Get it at:"));
            event.player.func_145747_a(ForgeHooks.newChatWithLinks((String)"https://modrinth.com/mod/village-names"));
        }
        if (quitChecking || !GeneralConfig.versionChecker) {
            MinecraftForge.EVENT_BUS.unregister((Object)instance);
            return;
        }
    }
}

