/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.network;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.network.MessageModernVillagerSkin;
import astrotibs.villagenames.network.MessageVillageGuard;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import astrotibs.villagenames.tracker.ClientInfoTracker;
import astrotibs.villagenames.utility.LogHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class NetworkHelper {
    public static void sendModernVillagerSkinMessage(int villagerID, IModularSkin ims, EntityPlayer target) {
        if (villagerID > 0 && ims != null && ims.getCareer() > 0) {
            MessageModernVillagerSkin message = new MessageModernVillagerSkin(villagerID, ims.getProfession(), ims.getCareer(), ims.getBiomeType(), ims.getProfessionLevel(), ims.getSkinTone());
            VillageNames.VNNetworkWrapper.sendTo((IMessage)message, (EntityPlayerMP)target);
        }
    }

    public static void sendZombieVillagerProfessionMessage(int zombieId, IModularSkin ims, EntityPlayer target) {
        if (zombieId > 0 && ims != null && ims.getProfession() >= 0 && ims.getCareer() > 0 || zombieId > 0 && ims != null && ims.getProfession() >= 0) {
            MessageZombieVillagerProfession message = new MessageZombieVillagerProfession(zombieId, ims.getProfession(), ims.getCareer(), ims.getBiomeType(), ims.getProfessionLevel(), ims.getSkinTone());
            if (GeneralConfig.debugMessages) {
                LogHelper.info("NetworkHelper > target: " + target);
                LogHelper.info("NetworkHelper > " + message.toString());
            }
            VillageNames.VNNetworkWrapper.sendTo((IMessage)message, (EntityPlayerMP)target);
        }
    }

    public static void sendVillageGuardMessage(int guardId, IModularSkin ims, EntityPlayer target) {
        if (guardId > 0 && ims != null) {
            MessageVillageGuard message = new MessageVillageGuard(guardId);
            if (GeneralConfig.debugMessages) {
                LogHelper.info("NetworkHelper > target: " + target);
                LogHelper.info("NetworkHelper > " + message.toString());
            }
            VillageNames.VNNetworkWrapper.sendTo((IMessage)message, (EntityPlayerMP)target);
        }
    }

    public static class VillageGuardHandler
    implements IMessageHandler<MessageVillageGuard, IMessage> {
        public IMessage onMessage(MessageVillageGuard message, MessageContext ctx) {
            if (message.getEntityID() > 0) {
                ClientInfoTracker.addGuardMessage(message);
                ClientInfoTracker.SyncGuardMessage(message.getEntityID());
            }
            return null;
        }
    }

    public static class ZombieVillagerProfessionHandler
    implements IMessageHandler<MessageZombieVillagerProfession, IMessage> {
        public IMessage onMessage(MessageZombieVillagerProfession message, MessageContext ctx) {
            if (message.getEntityID() > 0 && message.getProfession() >= 0 && message.getCareer() > 0 || message.getEntityID() > 0 && message.getProfession() >= 0) {
                ClientInfoTracker.addZombieMessage(message);
                ClientInfoTracker.SyncZombieMessage(message.getEntityID());
            }
            return null;
        }
    }

    public static class ModernVillagerSkinHandler
    implements IMessageHandler<MessageModernVillagerSkin, IMessage> {
        public IMessage onMessage(MessageModernVillagerSkin message, MessageContext ctx) {
            if (message.getEntityID() > 0 && message.getProfession() >= 0) {
                ClientInfoTracker.addModernVillagerMessage(message);
                ClientInfoTracker.syncModernVillagerMessage(message.getEntityID());
            }
            return null;
        }
    }
}

