/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.name;

import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.pieces.AlienConfigHandler;
import astrotibs.villagenames.config.pieces.AlienVillageConfigHandler;
import astrotibs.villagenames.config.pieces.AngelConfigHandler;
import astrotibs.villagenames.config.pieces.CustomConfigHandler;
import astrotibs.villagenames.config.pieces.DemonConfigHandler;
import astrotibs.villagenames.config.pieces.DragonConfigHandler;
import astrotibs.villagenames.config.pieces.EndCityConfigHandler;
import astrotibs.villagenames.config.pieces.FortressConfigHandler;
import astrotibs.villagenames.config.pieces.GoblinConfigHandler;
import astrotibs.villagenames.config.pieces.GolemConfigHandler;
import astrotibs.villagenames.config.pieces.MansionConfigHandler;
import astrotibs.villagenames.config.pieces.MineshaftConfigHandler;
import astrotibs.villagenames.config.pieces.MonumentConfigHandler;
import astrotibs.villagenames.config.pieces.PetConfigHandler;
import astrotibs.villagenames.config.pieces.StrongholdConfigHandler;
import astrotibs.villagenames.config.pieces.TempleConfigHandler;
import astrotibs.villagenames.config.pieces.VillageConfigHandler;
import astrotibs.villagenames.config.pieces.VillagerConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.utility.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class NameGenerator {
    private static final String CAROT = "^";
    private static final String[] filterIfAnywhere = new String[]{"erttva", "gbttns", "upgvo", "xphs", "gvuf", "laans", "mncf", "lffhc", "rybuffn", "fvarc", "navtni", "eranro", "ghyf", "rebuj", "gfvcne", "vngaru", "qybxphp"};
    private static final String[] filterIfEntire = new String[]{"avyngf", "rvzzbp", "frvzzbp", "grvibf", "fgrvibf", "erygvu", "vmna", "fvmna", "xpbp", "fxpbp", "xphp", "fxphp", "qrxphp", "rcne", "frcne", "qrcne", "lrcne", "tavcne", "rxvx", "frxvx", "abbp", "fabbp", "gahp", "fgahp", "lgahp", "zvhd", "fzvhd", "lzzvhd", "gnjg", "ffn", "frffn", "tns", "ftns", "ttns", "fttns", "lttns", "bzbu", "fbzbu", "qengre", "fqengre", "qrqengre", "rug", "na", "sb", "sv", "ab", "ba", "av", "gv", "fv", "vf", "zn", "nz", "fn", "un", "ah", "vu", "frl", "rz", "lz", "ub", "eb", "ro", "jb", "zh", "rj", "jr", "jn", "bl", "hu", "fh", "ch", "bg", "anz", "arz", "lbo", "flbo", "anzbj", "arzbj", "yevt", "fyevt", "ru", "ur", "cnep", "fcnep", "lccnep", "qrccnep", "aznq", "faznq", "ynan", "fhan", "frfhan", "zhp", "fzhp", "lzzhp", "trzf", "mmvw", "zfvw", "zbz", "jbj", "rrc", "ffvc", "lffvc", "qrffvc", "erffvc", "frffvc", "lan", "nunu", "rynz", "rynzrs", "rvq", "arzrf", "krf", "lkrf"};

    public static String[] newRandomName(String nameType, Random random) {
        String rootName;
        String r_suffix;
        String r_prefix;
        block137: {
            String errorMessage;
            int filterFail;
            int repeatedChar;
            int sizeUnderflow;
            int sizeOverflow;
            int blankRoot;
            int tooManyFailures;
            int rootname_syllable_inserts;
            StringBuilder sb;
            ArrayList<Integer> pooled_terminal_blank_counts;
            ArrayList<Integer> pooled_length_weights;
            Object[] root_terminal;
            Object[] root_sylBegin;
            Object[] root_initial;
            block136: {
                int i;
                int numnames;
                String[] nameType_raw = nameType.trim().split("\\s*-\\s*");
                String[] nameType_a = new String[nameType_raw.length];
                for (int input_i = 0; input_i < nameType_raw.length; ++input_i) {
                    nameType_a[input_i] = nameType_raw[input_i].toLowerCase().trim();
                }
                Object[] prefix = new String[]{};
                root_initial = new String[]{};
                root_sylBegin = new String[]{};
                root_terminal = new String[]{};
                Object[] suffix = new String[]{};
                float prefix_chance = 0.0f;
                float suffix_chance = 0.0f;
                int normalization = 0;
                pooled_length_weights = new ArrayList<Integer>();
                pooled_terminal_blank_counts = new ArrayList<Integer>();
                if (Arrays.asList(nameType_a).contains("village")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])VillageConfigHandler.village_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])VillageConfigHandler.village_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])VillageConfigHandler.village_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])VillageConfigHandler.village_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])VillageConfigHandler.village_suffix);
                    numnames = VillageConfigHandler.village_root_initial.length;
                    prefix_chance += VillageConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += VillageConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < VillageConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + VillageConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(VillageConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < VillageConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + VillageConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(VillageConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("temple")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])TempleConfigHandler.temple_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])TempleConfigHandler.temple_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])TempleConfigHandler.temple_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])TempleConfigHandler.temple_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])TempleConfigHandler.temple_suffix);
                    numnames = TempleConfigHandler.temple_root_initial.length;
                    prefix_chance += TempleConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += TempleConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < TempleConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + TempleConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(TempleConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < TempleConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + TempleConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(TempleConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("mineshaft")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])MineshaftConfigHandler.mineshaft_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])MineshaftConfigHandler.mineshaft_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])MineshaftConfigHandler.mineshaft_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])MineshaftConfigHandler.mineshaft_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])MineshaftConfigHandler.mineshaft_suffix);
                    numnames = MineshaftConfigHandler.mineshaft_root_initial.length;
                    prefix_chance += MineshaftConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += MineshaftConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < MineshaftConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + MineshaftConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(MineshaftConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < MineshaftConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + MineshaftConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(MineshaftConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("fortress")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])FortressConfigHandler.fortress_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])FortressConfigHandler.fortress_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])FortressConfigHandler.fortress_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])FortressConfigHandler.fortress_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])FortressConfigHandler.fortress_suffix);
                    numnames = FortressConfigHandler.fortress_root_initial.length;
                    prefix_chance += FortressConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += FortressConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < FortressConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + FortressConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(FortressConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < FortressConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + FortressConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(FortressConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("stronghold")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])StrongholdConfigHandler.stronghold_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])StrongholdConfigHandler.stronghold_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])StrongholdConfigHandler.stronghold_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])StrongholdConfigHandler.stronghold_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])StrongholdConfigHandler.stronghold_suffix);
                    numnames = StrongholdConfigHandler.stronghold_root_initial.length;
                    prefix_chance += StrongholdConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += StrongholdConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < StrongholdConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + StrongholdConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(StrongholdConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < StrongholdConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + StrongholdConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(StrongholdConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("monument")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])MonumentConfigHandler.monument_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])MonumentConfigHandler.monument_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])MonumentConfigHandler.monument_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])MonumentConfigHandler.monument_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])MonumentConfigHandler.monument_suffix);
                    numnames = MonumentConfigHandler.monument_root_initial.length;
                    prefix_chance += MonumentConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += MonumentConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < MonumentConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + MonumentConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(MonumentConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < MonumentConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + MonumentConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(MonumentConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("endcity")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])EndCityConfigHandler.endcity_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])EndCityConfigHandler.endcity_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])EndCityConfigHandler.endcity_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])EndCityConfigHandler.endcity_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])EndCityConfigHandler.endcity_suffix);
                    numnames = EndCityConfigHandler.endcity_root_initial.length;
                    prefix_chance += EndCityConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += EndCityConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < EndCityConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + EndCityConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(EndCityConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < EndCityConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + EndCityConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(EndCityConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("mansion")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])MansionConfigHandler.mansion_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])MansionConfigHandler.mansion_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])MansionConfigHandler.mansion_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])MansionConfigHandler.mansion_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])MansionConfigHandler.mansion_suffix);
                    numnames = MansionConfigHandler.mansion_root_initial.length;
                    prefix_chance += MansionConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += MansionConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < MansionConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + MansionConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(MansionConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < MansionConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + MansionConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(MansionConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("alien")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])AlienConfigHandler.alien_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])AlienConfigHandler.alien_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])AlienConfigHandler.alien_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])AlienConfigHandler.alien_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])AlienConfigHandler.alien_suffix);
                    numnames = AlienConfigHandler.alien_root_initial.length;
                    prefix_chance += AlienConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += AlienConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < AlienConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + AlienConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(AlienConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < AlienConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + AlienConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(AlienConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("alienvillage")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])AlienVillageConfigHandler.alienvillage_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])AlienVillageConfigHandler.alienvillage_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])AlienVillageConfigHandler.alienvillage_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])AlienVillageConfigHandler.alienvillage_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])AlienVillageConfigHandler.alienvillage_suffix);
                    numnames = AlienVillageConfigHandler.alienvillage_root_initial.length;
                    prefix_chance += AlienVillageConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += AlienVillageConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < AlienVillageConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + AlienVillageConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(AlienVillageConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < AlienVillageConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + AlienVillageConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(AlienVillageConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("goblin")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])GoblinConfigHandler.goblin_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])GoblinConfigHandler.goblin_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])GoblinConfigHandler.goblin_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])GoblinConfigHandler.goblin_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])GoblinConfigHandler.goblin_suffix);
                    numnames = GoblinConfigHandler.goblin_root_initial.length;
                    prefix_chance += GoblinConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += GoblinConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < GoblinConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + GoblinConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(GoblinConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < GoblinConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + GoblinConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(GoblinConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("golem")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])GolemConfigHandler.golem_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])GolemConfigHandler.golem_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])GolemConfigHandler.golem_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])GolemConfigHandler.golem_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])GolemConfigHandler.golem_suffix);
                    numnames = GolemConfigHandler.golem_root_initial.length;
                    prefix_chance += GolemConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += GolemConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < GolemConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + GolemConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(GolemConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < GolemConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + GolemConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(GolemConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("demon")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])DemonConfigHandler.demon_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])DemonConfigHandler.demon_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])DemonConfigHandler.demon_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])DemonConfigHandler.demon_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])DemonConfigHandler.demon_suffix);
                    numnames = DemonConfigHandler.demon_root_initial.length;
                    prefix_chance += DemonConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += DemonConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < DemonConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + DemonConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(DemonConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < DemonConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + DemonConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(DemonConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("angel")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])AngelConfigHandler.angel_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])AngelConfigHandler.angel_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])AngelConfigHandler.angel_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])AngelConfigHandler.angel_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])AngelConfigHandler.angel_suffix);
                    numnames = AngelConfigHandler.angel_root_initial.length;
                    prefix_chance += AngelConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += AngelConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < AngelConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + AngelConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(AngelConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < AngelConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + AngelConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(AngelConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("dragon")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])DragonConfigHandler.dragon_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])DragonConfigHandler.dragon_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])DragonConfigHandler.dragon_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])DragonConfigHandler.dragon_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])DragonConfigHandler.dragon_suffix);
                    numnames = DragonConfigHandler.dragon_root_initial.length;
                    prefix_chance += DragonConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += DragonConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < DragonConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + DragonConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(DragonConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < DragonConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + DragonConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(DragonConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("pet")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])PetConfigHandler.pet_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])PetConfigHandler.pet_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])PetConfigHandler.pet_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])PetConfigHandler.pet_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])PetConfigHandler.pet_suffix);
                    numnames = PetConfigHandler.pet_root_initial.length;
                    prefix_chance += PetConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += PetConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < PetConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + PetConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(PetConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < PetConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + PetConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(PetConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("custom")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])CustomConfigHandler.custom_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])CustomConfigHandler.custom_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])CustomConfigHandler.custom_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])CustomConfigHandler.custom_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])CustomConfigHandler.custom_suffix);
                    numnames = CustomConfigHandler.custom_root_initial.length;
                    prefix_chance += CustomConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += CustomConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < CustomConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + CustomConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(CustomConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < CustomConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + CustomConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(CustomConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("villager") || root_initial.length <= 0) {
                    if (!Arrays.asList(nameType_a).contains("villager") && root_initial.length <= 0 && GeneralConfig.debugMessages) {
                        LogHelper.error("Submitted nameType contained no valid entries! Defaulting to Villager name pool.");
                    }
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])VillagerConfigHandler.villager_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])VillagerConfigHandler.villager_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])VillagerConfigHandler.villager_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])VillagerConfigHandler.villager_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])VillagerConfigHandler.villager_suffix);
                    numnames = VillagerConfigHandler.villager_root_initial.length;
                    prefix_chance += VillagerConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += VillagerConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < VillagerConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + VillagerConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(VillagerConfigHandler.syllable_count_weighting[i]);
                    }
                    for (i = 0; i < VillagerConfigHandler.terminal_blank_counts.length; ++i) {
                        if (pooled_terminal_blank_counts.size() > i) {
                            pooled_terminal_blank_counts.set(i, (Integer)pooled_terminal_blank_counts.get(i) + VillagerConfigHandler.terminal_blank_counts[i]);
                            continue;
                        }
                        pooled_terminal_blank_counts.add(VillagerConfigHandler.terminal_blank_counts[i]);
                    }
                }
                if (normalization > 0) {
                    prefix_chance /= (float)normalization;
                    suffix_chance /= (float)normalization;
                }
                r_prefix = "";
                r_suffix = "";
                rootName = "";
                sb = new StringBuilder();
                rootname_syllable_inserts = 1;
                tooManyFailures = 50;
                blankRoot = 0;
                sizeOverflow = 0;
                sizeUnderflow = 0;
                repeatedChar = 0;
                filterFail = 0;
                int prefixsuffixFail = 0;
                do {
                    r_prefix = "";
                    if (random.nextFloat() < prefix_chance && normalization > 0 && prefix.length > 0) {
                        r_prefix = ((String)prefix[random.nextInt(prefix.length)]).trim();
                    }
                    r_suffix = "";
                    if (random.nextFloat() < suffix_chance && normalization > 0 && suffix.length > 0) {
                        r_suffix = ((String)suffix[random.nextInt(suffix.length)]).trim();
                    }
                    if (r_prefix.equals("") || r_suffix.equals("") || !r_prefix.equals(r_suffix)) break block136;
                } while (++prefixsuffixFail < tooManyFailures);
                String errorMessage2 = "Name type " + nameType + " Matched too many prefixes and suffixes! Check your syllable configs.";
                LogHelper.fatal(errorMessage2);
                throw new RuntimeException(errorMessage2);
            }
            do {
                int i;
                int totalWeight = 0;
                for (int i2 = 0; i2 < pooled_length_weights.size(); ++i2) {
                    totalWeight += ((Integer)pooled_length_weights.get(i2)).intValue();
                }
                if (totalWeight <= 0) {
                    String errorMessage3 = "Name type " + nameType + " total syllable weighting was non-positive! Check the weighting values in your configs.";
                    LogHelper.fatal(errorMessage3);
                    throw new RuntimeException(errorMessage3);
                }
                int randomObject = random.nextInt(totalWeight);
                for (i = 0; i < pooled_length_weights.size(); ++i) {
                    if ((randomObject -= ((Integer)pooled_length_weights.get(i)).intValue()) > 0) continue;
                    rootname_syllable_inserts = i;
                    break;
                }
                if (root_initial.length <= 0) {
                    String errorMessage4 = "Name type " + nameType + " has no root-initial entries! No name can be constructed!";
                    LogHelper.fatal(errorMessage4);
                    throw new RuntimeException(errorMessage4);
                }
                sb.delete(0, sb.length());
                sb.append((String)root_initial[random.nextInt(root_initial.length)]);
                for (i = 0; i < rootname_syllable_inserts; ++i) {
                    if (root_sylBegin.length <= 0) {
                        String errorMessage5 = "Name type " + nameType + " has no root-syllable entries! You need at least one, even if it's the blank entry character: ^";
                        LogHelper.error(errorMessage5);
                        sb.append(CAROT);
                        continue;
                    }
                    sb.append((String)root_sylBegin[random.nextInt(root_sylBegin.length)]);
                }
                if (root_terminal.length <= 0) {
                    errorMessage = "Name type " + nameType + " has no root-terminal entries! You need at least one, even if it's the blank entry character: ^";
                    LogHelper.error(errorMessage);
                    sb.append(CAROT);
                } else {
                    Object random_root_terminal = root_terminal[random.nextInt(root_terminal.length)];
                    String error_using_carot_as_terminal_weighting = "Using the raw number of ^ characters to determine the chances of a blank root terminal character instead.";
                    boolean terminal_character_accepted = false;
                    if (pooled_terminal_blank_counts.size() < rootname_syllable_inserts + 1) {
                        LogHelper.error("You're missing the the corresponding value in your \"Terminal Blank Counts\" config entry. Did you change something?");
                    } else {
                        int terminal_blank_weight;
                        int name_weight = (Integer)pooled_length_weights.get(rootname_syllable_inserts);
                        if (name_weight < (terminal_blank_weight = ((Integer)pooled_terminal_blank_counts.get(rootname_syllable_inserts)).intValue())) {
                            LogHelper.error("Your \"Terminal Blank Counts\" config entry is higher than the corresponding \"Syllable Count Weighting\", implying there are more blank endings than names. Please check your configs.");
                        } else if (name_weight < 0) {
                            LogHelper.error("Your \"Syllable Count Weighting\" is less than zero. Please check your configs.");
                        } else if (terminal_blank_weight < 0) {
                            LogHelper.error("Your \"Terminal Blank Counts\" is less than zero. Please check your configs.");
                        } else {
                            boolean root_terminal_is_blank;
                            boolean bl = root_terminal_is_blank = random.nextInt(name_weight) < terminal_blank_weight;
                            if (root_terminal_is_blank) {
                                terminal_character_accepted = true;
                                sb.append(CAROT);
                            } else {
                                for (int i3 = 0; i3 < tooManyFailures * 2; ++i3) {
                                    Object try_terminal_character = root_terminal[random.nextInt(root_terminal.length)];
                                    if ((!((String)try_terminal_character).trim().equals(CAROT) || !root_terminal_is_blank) && (((String)try_terminal_character).trim().equals(CAROT) || root_terminal_is_blank)) continue;
                                    terminal_character_accepted = true;
                                    sb.append((String)try_terminal_character);
                                    break;
                                }
                            }
                            if (!terminal_character_accepted) {
                                LogHelper.error("Failed to generate an appropriate terminal character.");
                            }
                        }
                    }
                    if (!terminal_character_accepted) {
                        LogHelper.error(error_using_carot_as_terminal_weighting);
                        sb.append((String)random_root_terminal);
                    }
                }
                rootName = sb.toString().trim();
                rootName = rootName.replace(" ", "");
                rootName = rootName.replaceAll("\\_", " ");
                rootName = rootName.replace(CAROT, "");
                if (rootName.length() <= 15) {
                    int ci;
                    char[] nameRootArray;
                    if (rootName.length() >= 6) {
                        nameRootArray = rootName.toLowerCase().toCharArray();
                        int consecutives = 0;
                        for (ci = 0; ci <= nameRootArray.length - 6; ++ci) {
                            if (nameRootArray[ci] != nameRootArray[ci + 2] || nameRootArray[ci] != nameRootArray[ci + 4] || nameRootArray[ci + 1] != nameRootArray[ci + 3] || nameRootArray[ci + 1] != nameRootArray[ci + 5]) continue;
                            ++consecutives;
                            break;
                        }
                        if (consecutives > 0) {
                            ++repeatedChar;
                        }
                    }
                    if (rootName.length() >= 3) {
                        nameRootArray = rootName.toLowerCase().toCharArray();
                        int consecutives = 0;
                        for (ci = 0; ci < nameRootArray.length - 2; ++ci) {
                            if (nameRootArray[ci] != nameRootArray[ci + 1] || nameRootArray[ci] != nameRootArray[ci + 2]) continue;
                            ++consecutives;
                        }
                        if (consecutives == 0) {
                            if (!NameGenerator.contentScan(rootName)) break block137;
                            ++filterFail;
                        } else {
                            ++repeatedChar;
                        }
                    } else if (rootName.length() == 2) {
                        if (rootName.toLowerCase().charAt(0) != rootName.toLowerCase().charAt(1)) {
                            if (!NameGenerator.contentScan(rootName)) break block137;
                            ++filterFail;
                        }
                    } else if (rootName.length() > 0) {
                        ++sizeUnderflow;
                    } else {
                        ++blankRoot;
                    }
                } else {
                    ++sizeOverflow;
                }
                if (sizeOverflow >= tooManyFailures) {
                    errorMessage = "Name type " + nameType + " names are too long! Check your syllable lengths.";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                if (sizeUnderflow >= tooManyFailures) {
                    errorMessage = "Name type " + nameType + " names are too short! Check your syllables configs.";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                if (blankRoot >= tooManyFailures) {
                    errorMessage = "Name type " + nameType + " Produced blank names! Check your syllable configs.";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                if (repeatedChar < tooManyFailures) continue;
                errorMessage = "Name type " + nameType + " has too many consecutive repeated letters or pairs of letters! Check your syllable configs.";
                LogHelper.fatal(errorMessage);
                throw new RuntimeException(errorMessage);
            } while (filterFail < tooManyFailures);
            errorMessage = "Name type " + nameType + " has tripped the content filter too many times. Are you being naughty?";
            LogHelper.fatal(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        String headerTags = GeneralConfig.headerTags.trim();
        String[] nameStringArray = new String[]{headerTags, r_prefix, rootName, r_suffix};
        return nameStringArray;
    }

    public static String getCareerTag(String entityClasspath, int villagerProfession, String villagerProfessionForge, int villagerCareer, String targetPName) {
        StringBuilder careerTag = new StringBuilder().append("(");
        if (GeneralConfig.modNameMappingClickable_map.get("ClassPaths").contains(entityClasspath)) {
            careerTag.append(((String)GeneralConfig.modNameMappingClickable_map.get("Professions").get(GeneralConfig.modNameMappingClickable_map.get("ClassPaths").indexOf(entityClasspath))).trim());
        } else if (GeneralConfig.modNameMappingAutomatic_map.get("ClassPaths").contains(entityClasspath)) {
            careerTag.append(((String)GeneralConfig.modNameMappingAutomatic_map.get("Professions").get(GeneralConfig.modNameMappingAutomatic_map.get("ClassPaths").indexOf(entityClasspath))).trim());
        } else if (entityClasspath.equals("stevekung.mods.moreplanets.planets.nibiru.entity.EntityNibiruVillager") || entityClasspath.equals("stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityNibiruVillager")) {
            switch (villagerProfession % 3) {
                case 0: {
                    careerTag.append("Farmer");
                    break;
                }
                case 1: {
                    careerTag.append("Librarian");
                    break;
                }
                case 2: {
                    careerTag.append("Medic");
                }
            }
        } else if (!Reference.VANILLA_PROFESSIONS.contains(villagerProfessionForge)) {
            int index_profession_concat_career = Math.max(GeneralConfig.modProfessionMapping_map.get("IDs_concat_careers").indexOf(villagerProfessionForge + -99), GeneralConfig.modProfessionMapping_map.get("IDs_concat_careers").indexOf(villagerProfessionForge + villagerCareer));
            if (index_profession_concat_career != -1) {
                try {
                    String otherModProfString = (String)GeneralConfig.modProfessionMapping_map.get("Professions").get(index_profession_concat_career);
                    otherModProfString = otherModProfString.replaceAll("\\(", "");
                    otherModProfString = otherModProfString.replaceAll("\\)", "");
                    otherModProfString = otherModProfString.trim();
                    if (otherModProfString.toLowerCase().equals("null")) {
                        otherModProfString = "";
                    }
                    careerTag.append(otherModProfString);
                }
                catch (Exception e) {
                    if (GeneralConfig.debugMessages) {
                        LogHelper.info("Error evaluating mod profession ID when generating a villager nametag. Check the formatting of your Mod Professions config entry!");
                    }
                }
            }
        } else {
            block6 : switch (villagerProfession) {
                case 0: {
                    switch (villagerCareer) {
                        case 1: {
                            careerTag.append("Farmer");
                            break block6;
                        }
                        case 2: {
                            careerTag.append("Fisherman");
                            break block6;
                        }
                        case 3: {
                            careerTag.append("Shepherd");
                            break block6;
                        }
                        case 4: {
                            careerTag.append("Fletcher");
                            break block6;
                        }
                    }
                    careerTag.append("Farmer");
                    break;
                }
                case 1: {
                    switch (villagerCareer) {
                        case 1: {
                            careerTag.append("Librarian");
                            break block6;
                        }
                        case 2: {
                            careerTag.append("Cartographer");
                            break block6;
                        }
                    }
                    careerTag.append("Librarian");
                    break;
                }
                case 2: {
                    switch (villagerCareer) {
                        case 1: {
                            careerTag.append("Cleric");
                            break block6;
                        }
                    }
                    careerTag.append("Priest");
                    break;
                }
                case 3: {
                    switch (villagerCareer) {
                        case 1: {
                            careerTag.append("Armorer");
                            break block6;
                        }
                        case 2: {
                            careerTag.append("Weaponsmith");
                            break block6;
                        }
                        case 3: {
                            careerTag.append("Toolsmith");
                            break block6;
                        }
                        case 4: {
                            careerTag.append("Mason");
                            break block6;
                        }
                    }
                    careerTag.append("Blacksmith");
                    break;
                }
                case 4: {
                    switch (villagerCareer) {
                        case 1: {
                            careerTag.append("Butcher");
                            break block6;
                        }
                        case 2: {
                            careerTag.append("Leatherworker");
                            break block6;
                        }
                    }
                    careerTag.append("Butcher");
                    break;
                }
                case 5: {
                    String nitwitCareer = GeneralConfig.nitwitProfession.trim().equals("") || GeneralConfig.nitwitProfession.toLowerCase().trim().equals("null") ? "" : GeneralConfig.nitwitProfession;
                    switch (villagerCareer) {
                        case 1: {
                            careerTag.append(nitwitCareer);
                            break block6;
                        }
                    }
                    careerTag.append(nitwitCareer);
                }
            }
        }
        careerTag.append(")");
        if (careerTag.toString().equals("()")) {
            careerTag = new StringBuilder().append("");
        }
        return careerTag.toString();
    }

    private static boolean contentScan(String inputString) {
        for (String s : filterIfAnywhere) {
            if (!inputString.trim().toLowerCase().contains(new StringBuilder(NameGenerator.rot13(s)).reverse().toString())) continue;
            return true;
        }
        for (String s : filterIfEntire) {
            if (!inputString.trim().toLowerCase().equals(new StringBuilder(NameGenerator.rot13(s)).reverse().toString())) continue;
            return true;
        }
        return false;
    }

    public static String rot13(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            out.append(c);
        }
        return out.toString();
    }
}

