/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.integration.antiqueatlas;

import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import com.google.common.collect.ImmutableMap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.api.TileAPI;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.marker.Marker;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VillageWatcherAA {
    public static final String TILE_VILLAGE_FENCE = "npcVillageFence";
    public static final String TILE_VILLAGE_TREE = "npcVillageTree";
    public static final String TILE_VILLAGE_HOUSE = "npcVillageHouse";
    public static final String VILLAGE_MARKER = "village";
    private final Set<String> visited = new HashSet<String>();
    public static final String TILE_VILLAGE_LIBRARY = "npcVillageLibrary";
    public static final String TILE_VILLAGE_SMITHY = "npcVillageSmithy";
    public static final String TILE_VILLAGE_L_HOUSE = "npcVillageLHouse";
    public static final String TILE_VILLAGE_FARMLAND_SMALL = "npcVillageFarmlandSmall";
    public static final String TILE_VILLAGE_FARMLAND_LARGE = "npcVillageFarmlandLarge";
    public static final String TILE_VILLAGE_WELL = "npcVillageWell";
    public static final String TILE_VILLAGE_TORCH = "npcVillageTorch";
    public static final String TILE_VILLAGE_HUT = "npcVillageHut";
    public static final String TILE_VILLAGE_SMALL_HOUSE = "npcVillageSmallHouse";
    public static final String TILE_VILLAGE_BUTCHERS_SHOP = "npcVillageButchersShop";
    public static final String TILE_VILLAGE_CHURCH = "npcVillageChurch";
    private static final String VN_PATH = "VNPath";
    private static final String VN_DECOR_TORCH = "VNDecTor";
    private static final String PLAINS_FOUNTAIN = "VNPlF01";
    private static final String PLAINS_WELL = "VNPlMP1";
    private static final String PLAINS_MARKET = "VNPlMP2";
    private static final String PLAINS_CENTRAL_TREE = "VNPlMP3";
    private static final String DESERT_FOUNTAIN = "VNDeMP1";
    private static final String DESERT_WELL = "VNDeMP2";
    private static final String DESERT_MARKET = "VNDeMP3";
    private static final String TAIGA_GRASSY_CENTER = "VNTaMP1";
    private static final String TAIGA_WELL = "VNTaMP2";
    private static final String SAVANNA_MARKET = "VNSaMP1";
    private static final String SAVANNA_FOUNTAIN = "VNSaMP2";
    private static final String SAVANNA_DOUBLE_WELL = "VNSaMP3";
    private static final String SAVANNA_SINGLE_WELL = "VNSaMP4";
    private static final String SNOWY_ICE_SPIRE = "VNSnMP1";
    private static final String SNOWY_FOUNTAIN = "VNSnMP2";
    private static final String SNOWY_PAVILION = "VNSnMP3";
    private static final String JUNGLE_STATUE = "VNJuSta";
    private static final String JUNGLE_TREE = "VNJuTre";
    private static final String JUNGLE_GARDEN = "VNJuGar";
    private static final String JUNGLE_VILLA = "VNJuVil";
    private static final String SWAMP_WILLOW = "VNSwWil";
    private static final String SWAMP_STATUE = "VNSwSta";
    private static final String SWAMP_PAVILION = "VNSwPav";
    private static final String SWAMP_MONOLITH = "VNSwMon";
    private static final String PLAINS_FLOWER_PLANTER = "VNPlAcc1";
    private static final String PLAINS_SMALL_ANIMAL_PEN = "VNPlAnP1";
    private static final String PLAINS_LARGE_ANIMAL_PEN = "VNPlAnP2";
    private static final String PLAINS_DECORATED_ANIMAL_PEN = "VNPlAnP3";
    private static final String PLAINS_ARMORER_HOUSE = "VNPlArm1";
    private static final String PLAINS_LARGE_HOUSE = "VNPlBiH1";
    private static final String PLAINS_SMALL_BUTCHER_SHOP = "VNPlBut1";
    private static final String PLAINS_LARGE_BUTCHER_SHOP = "VNPlBut2";
    private static final String PLAINS_CARTOGRAPHER_HOUSE = "VNPlCar1";
    private static final String PLAINS_FISHER_COTTAGE = "VNPlFis1";
    private static final String PLAINS_FLETCHER_HOUSE = "VNPlFle1";
    private static final String PLAINS_LARGE_FARM = "VNPlLFa1";
    private static final String PLAINS_LARGE_LIBRARY = "VNPlLib1";
    private static final String PLAINS_SMALL_LIBRARY = "VNPlLib2";
    private static final String PLAINS_MASON_HOUSE = "VNPlMas1";
    private static final String PLAINS_MEDIUM_HOUSE_1 = "VNPlMeH1";
    private static final String PLAINS_MEDIUM_HOUSE_2 = "VNPlMeH2";
    private static final String PLAINS_LARGE_MARKET = "VNPlMeP4";
    private static final String PLAINS_SMALL_MARKET = "VNPlMeP5";
    private static final String PLAINS_SHEPHERDS_HOUSE = "VNPlShe1";
    private static final String PLAINS_SMALL_FARM = "VNPlSFa1";
    private static final String PLAINS_SMALL_HOUSE_1 = "VNPlSmH1";
    private static final String PLAINS_SMALL_HOUSE_2 = "VNPlSmH2";
    private static final String PLAINS_SMALL_HOUSE_3 = "VNPlSmH3";
    private static final String PLAINS_SMALL_HOUSE_4 = "VNPlSmH4";
    private static final String PLAINS_SMALL_HOUSE_5 = "VNPlSmH5";
    private static final String PLAINS_SMALL_HOUSE_6 = "VNPlSmH6";
    private static final String PLAINS_SMALL_HOUSE_7 = "VNPlSmH7";
    private static final String PLAINS_SMALL_HOUSE_8 = "VNPlSmH8";
    private static final String PLAINS_COBBLESTONE_STABLE = "VNPlSta1";
    private static final String PLAINS_TERRACOTTA_STABLE = "VNPlSta2";
    private static final String PLAINS_TANNERY = "VNPlTan2";
    private static final String PLAINS_TERRACOTTA_TEMPLE = "VNPlTem3";
    private static final String PLAINS_COBBLESTONE_TEMPLE = "VNPlTem4";
    private static final String PLAINS_TOOL_SMITHY = "VNPlTSm1";
    private static final String PLAINS_WEAPON_SMITHY = "VNPlWSm1";
    private static final String PLAINS_ROAD_DECOR = "VNPlStD1";
    private static final String DESERT_SMALL_ANIMAL_PEN = "VNDeAnP1";
    private static final String DESERT_COVERED_ANIMAL_PEN = "VNDeAnP2";
    private static final String DESERT_ARMORER_HOUSE = "VNDeArm1";
    private static final String DESERT_BUTCHER_SHOP = "VNDeBut1";
    private static final String DESERT_CARTOGRAPHER_HOUSE = "VNDeCar1";
    private static final String DESERT_SMALL_FARM = "VNDeFar1";
    private static final String DESERT_MEDIUM_FARM = "VNDeFar2";
    private static final String DESERT_FISHER_COTTAGE = "VNDeFis1";
    private static final String DESERT_FLETCHER_HOUSE = "VNDeFle1";
    private static final String DESERT_LARGE_FARM = "VNDeLFa1";
    private static final String DESERT_LIBRARY = "VNDeLib1";
    private static final String DESERT_MASON_HOUSE = "VNDeMas1";
    private static final String DESERT_MEDIUM_HOUSE = "VNDeMeH1";
    private static final String DESERT_LARGE_HOUSE = "VNDeMeH2";
    private static final String DESERT_SHEPHERDS_HOUSE = "VNDeShe1";
    private static final String DESERT_SMALL_HOUSE_1 = "VNDeSmH1";
    private static final String DESERT_SMALL_HOUSE_2 = "VNDeSmH2";
    private static final String DESERT_SMALL_HOUSE_3 = "VNDeSmH3";
    private static final String DESERT_SMALL_HOUSE_4 = "VNDeSmH4";
    private static final String DESERT_SMALL_HOUSE_5 = "VNDeSmH5";
    private static final String DESERT_SMALL_HOUSE_6 = "VNDeSmH6";
    private static final String DESERT_SMALL_HOUSE_7 = "VNDeSmH7";
    private static final String DESERT_SMALL_HOUSE_8 = "VNDeSmH8";
    private static final String DESERT_TANNERY = "VNDeTan1";
    private static final String DESERT_TEMPLE_1 = "VNDeTem1";
    private static final String DESERT_TEMPLE_2 = "VNDeTem2";
    private static final String DESERT_TOOL_SMITHY = "VNDeTSm1";
    private static final String DESERT_WEAPON_SMITHY = "VNDeWSm1";
    private static final String DESERT_ROAD_DECOR = "VNDeStD1";
    private static final String DESERT_ROAD_TERRACOTTA_ACCENT_1 = "VNDeStS1";
    private static final String DESERT_ROAD_TERRACOTTA_ACCENT_2 = "VNDeStS2";
    private static final String DESERT_ROAD_DECOR_3 = "VNDeStS3";
    private static final String TAIGA_ANIMAL_PEN = "VNTaAnP1";
    private static final String TAIGA_ARMORER_STATION = "VNTaArm2";
    private static final String TAIGA_ARMORER_HOUSE = "VNTaArm1";
    private static final String TAIGA_BUTCHER_SHOP = "VNTaBut1";
    private static final String TAIGA_CARTOGRAPHER_HOUSE = "VNTaCar1";
    private static final String TAIGA_FISHER_COTTAGE = "VNTaFis1";
    private static final String TAIGA_FLETCHER_HOUSE = "VNTaFle1";
    private static final String TAIGA_LARGE_FARM = "VNTaLFa1";
    private static final String TAIGA_MEDIUM_FARM = "VNTaLFa2";
    private static final String TAIGA_LIBRARY = "VNTaLib1";
    private static final String TAIGA_MASON_HOUSE = "VNTaMas1";
    private static final String TAIGA_MEDIUM_HOUSE_1 = "VNTaMeH1";
    private static final String TAIGA_MEDIUM_HOUSE_2 = "VNTaMeH2";
    private static final String TAIGA_MEDIUM_HOUSE_3 = "VNTaMeH3";
    private static final String TAIGA_MEDIUM_HOUSE_4 = "VNTaMeH4";
    private static final String TAIGA_SHEPHERD_HOUSE = "VNTaShe1";
    private static final String TAIGA_SMALL_FARM = "VNTaSFa1";
    private static final String TAIGA_SMALL_HOUSE_1 = "VNTaSmH1";
    private static final String TAIGA_SMALL_HOUSE_2 = "VNTaSmH2";
    private static final String TAIGA_SMALL_HOUSE_3 = "VNTaSmH3";
    private static final String TAIGA_SMALL_HOUSE_4 = "VNTaSmH4";
    private static final String TAIGA_SMALL_HOUSE_5 = "VNTaSmH5";
    private static final String TAIGA_TANNERY = "VNTaTan1";
    private static final String TAIGA_TEMPLE = "VNTaTem1";
    private static final String TAIGA_TOOL_SMITHY = "VNTaTSm1";
    private static final String TAIGA_WEAPON_SMITH_HOUSE = "VNTaWSm1";
    private static final String TAIGA_WEAPON_SMITH_STATION = "VNTaWSm2";
    private static final String TAIGA_ROAD_DECOR = "VNTaStD1";
    private static final String SAVANNA_COVERED_ANIMAL_PEN = "VNSaAnP1";
    private static final String SAVANNA_LARGE_ANIMAL_PEN = "VNSaAnP2";
    private static final String SAVANNA_MEDIUM_ANIMAL_PEN = "VNSaAnP3";
    private static final String SAVANNA_ARMORER_HOUSE = "VNSaArm1";
    private static final String SAVANNA_BUTCHER_SHOP_1 = "VNSaBut1";
    private static final String SAVANNA_BUTCHER_SHOP_2 = "VNSaBut2";
    private static final String SAVANNA_CARTOGRAPHER = "VNSaCar1";
    private static final String SAVANNA_FISHER_COTTAGE = "VNSaFis1";
    private static final String SAVANNA_FLETCHER_HOUSE = "VNSaFle1";
    private static final String SAVANNA_METHODICAL_FARM = "VNSaLFa1";
    private static final String SAVANNA_HAPHAZARD_FARM = "VNSaLFa2";
    private static final String SAVANNA_LIBRARY = "VNSaLib1";
    private static final String SAVANNA_MASON_HOUSE = "VNSaMas1";
    private static final String SAVANNA_MEDIUM_HOUSE_1 = "VNSaMeH1";
    private static final String SAVANNA_MEDIUM_HOUSE_2 = "VNSaMeH2";
    private static final String SAVANNA_SHEPHERD_HOUSE = "VNSaShe1";
    private static final String SAVANNA_SMALL_FARM = "VNSaSmFa";
    private static final String SAVANNA_SMALL_HOUSE_1 = "VNSaSmH1";
    private static final String SAVANNA_SMALL_HOUSE_2 = "VNSaSmH2";
    private static final String SAVANNA_SMALL_HOUSE_3 = "VNSaSmH3";
    private static final String SAVANNA_SMALL_HOUSE_4 = "VNSaSmH4";
    private static final String SAVANNA_SMALL_HOUSE_5 = "VNSaSmH5";
    private static final String SAVANNA_SMALL_HOUSE_6 = "VNSaSmH6";
    private static final String SAVANNA_SMALL_HOUSE_7 = "VNSaSmH7";
    private static final String SAVANNA_SMALL_HOUSE_8 = "VNSaSmH8";
    private static final String SAVANNA_TANNERY = "VNSaTsn1";
    private static final String SAVANNA_TEMPLE_1 = "VNSaTem1";
    private static final String SAVANNA_TEMPLE_2 = "VNSaTem2";
    private static final String SAVANNA_TOOL_SMITHY = "VNSaTSm1";
    private static final String SAVANNA_SMALL_WEAPON_SMITHY = "VNSaWSm1";
    private static final String SAVANNA_LARGE_WEAPON_SMITHY = "VNSaWSm2";
    private static final String SAVANNA_ROAD_DECOR = "VNSaStD1";
    private static final String SAVANNA_ROADSIDE_FARM_1 = "VNSaStS1";
    private static final String SAVANNA_ROADSIDE_FARM_2 = "VNSaStS2";
    private static final String SAVANNA_ROADSIDE_FARM_3 = "VNSaStS3";
    private static final String SAVANNA_ROADSIDE_FARM_4 = "VNSaStS4";
    private static final String SNOWY_ANIMAL_PEN_1 = "VNSnAnP1";
    private static final String SNOWY_ANIMAL_PEN_2 = "VNSnAnP2";
    private static final String SNOWY_ARMORER_HOUSE_1 = "VNSnArH1";
    private static final String SNOWY_ARMORER_HOUSE_2 = "VNSnArH2";
    private static final String SNOWY_BUTCHER_HOUSE = "VNSnBut1";
    private static final String SNOWY_BUTCHER_IGLOO = "VNSnBut2";
    private static final String SNOWY_CARTOGRAPHER_HOUSE = "VNSnCar1";
    private static final String SNOWY_SQUARE_FARM = "VNSnFar1";
    private static final String SNOWY_PATCH_FARM = "VNSnFar2";
    private static final String SNOWY_FISHER_COTTAGE = "VNSnFisC";
    private static final String SNOWY_FLETCHER_HOUSE = "VNSnFle1";
    private static final String SNOWY_LIBRARY = "VNSnLib1";
    private static final String SNOWY_MASON_HOUSE_1 = "VNSnMas1";
    private static final String SNOWY_MASON_HOUSE_2 = "VNSnMas2";
    private static final String SNOWY_MEDIUM_HOUSE_1 = "VNSnMeH1";
    private static final String SNOWY_MEDIUM_HOUSE_2 = "VNSnMeH2";
    private static final String SNOWY_MEDIUM_HOUSE_3 = "VNSnMeH3";
    private static final String SNOWY_SHEPHERD_HOUSE = "VNSnShe1";
    private static final String SNOWY_SMALL_HOUSE_1 = "VNSnSmH1";
    private static final String SNOWY_SMALL_HOUSE_2 = "VNSnSmH2";
    private static final String SNOWY_SMALL_HOUSE_3 = "VNSnSmH3";
    private static final String SNOWY_SMALL_HOUSE_4 = "VNSnSmH4";
    private static final String SNOWY_SMALL_HOUSE_5 = "VNSnSmH5";
    private static final String SNOWY_SMALL_HOUSE_6 = "VNSnSmH6";
    private static final String SNOWY_SMALL_HOUSE_7 = "VNSnSmH7";
    private static final String SNOWY_SMALL_HOUSE_8 = "VNSnSmH8";
    private static final String SNOWY_TANNERY = "VNSnTan1";
    private static final String SNOWY_TEMPLE = "VNSnTem1";
    private static final String SNOWY_TOOL_SMITHY = "VNSnTSm1";
    private static final String SNOWY_WEAPON_SMITHY = "VNSnWSm1";
    private static final String SNOWY_ROAD_DECOR = "VNSnStD1";
    private static final String JUNGLE_ARMORER_HOUSE = "VNJuArmH";
    private static final String JUNGLE_BUTCHER_SHOP = "VNJuButS";
    private static final String JUNGLE_CARTOGRAPHER_HOUSE_1 = "VNJuCaH1";
    private static final String JUNGLE_CARTOGRAPHER_HOUSE_2 = "VNJuCaH2";
    private static final String JUNGLE_FISHER_COTTAGE = "VNJuFshC";
    private static final String JUNGLE_FLETCHER_HOUSE_1 = "VNJuFlH1";
    private static final String JUNGLE_FLETCHER_HOUSE_2 = "VNJuFlH2";
    private static final String JUNGLE_LARGE_HOUSE = "VNJuLaHo";
    private static final String JUNGLE_LIBRARY = "VNJuLibr";
    private static final String JUNGLE_MASON_HOUSE = "VNJuMasH";
    private static final String JUNGLE_MEDIUM_HOUSE_1 = "VNJuMeH1";
    private static final String JUNGLE_MEDIUM_HOUSE_2 = "VNJuMeH2";
    private static final String JUNGLE_MEDIUM_HOUSE_3 = "VNJuMeH3";
    private static final String JUNGLE_MEDIUM_HOUSE_4 = "VNJuMeH4";
    private static final String JUNGLE_SHEPHERD_HOUSE = "VNJuShpH";
    private static final String JUNGLE_SMALL_HOUSE_1 = "VNJuSmH1";
    private static final String JUNGLE_SMALL_HOUSE_2 = "VNJuSmH2";
    private static final String JUNGLE_SMALL_HOUSE_3 = "VNJuSmH3";
    private static final String JUNGLE_SMALL_HOUSE_4 = "VNJuSmH4";
    private static final String JUNGLE_SMALL_HOUSE_5 = "VNJuSmH5";
    private static final String JUNGLE_SMALL_HOUSE_6 = "VNJuSmH6";
    private static final String JUNGLE_SMALL_HOUSE_7 = "VNJuSmH7";
    private static final String JUNGLE_SMALL_HOUSE_8 = "VNJuSmH8";
    private static final String JUNGLE_STABLE = "VNJuStbl";
    private static final String JUNGLE_STONE_ANIMAL_PEN = "VNJuStAP";
    private static final String JUNGLE_STEPPED_FARM = "VNJuStFa";
    private static final String JUNGLE_TAMED_FARM = "VNJuTaFa";
    private static final String JUNGLE_TANNERY_1 = "VNJuTan1";
    private static final String JUNGLE_TANNERY_2 = "VNJuTan2";
    private static final String JUNGLE_TEMPLE = "VNJuTemp";
    private static final String JUNGLE_TOOL_SMITHY_1 = "VNJuTSm1";
    private static final String JUNGLE_TOOL_SMITHY_2 = "VNJuTSm2";
    private static final String JUNGLE_WEAPON_SMITHY = "VNJuWpSm";
    private static final String JUNGLE_WILD_FARM = "VNJuWiFa";
    private static final String JUNGLE_WOOD_ANIMAL_PEN = "VNJuWdAP";
    private static final String JUNGLE_ROAD_DECOR = "VNJuStDe";
    private static final String JUNGLE_ROAD_ACCENT_1 = "VNJuRdA1";
    private static final String JUNGLE_ROAD_ACCENT_2 = "VNJuRdA2";
    private static final String SWAMP_ANIMAL_PEN_1 = "VNSwAnP1";
    private static final String SWAMP_ANIMAL_PEN_2 = "VNSwAnP2";
    private static final String SWAMP_ARMORER_HOUSE = "VNSwArHo";
    private static final String SWAMP_BUTCHER_SHOP = "VNSwBuSh";
    private static final String SWAMP_CARTOGRAPHER_HOUSE = "VNSwCaHo";
    private static final String SWAMP_FISHER_COTTAGE_1 = "VNSwFiC1";
    private static final String SWAMP_FISHER_COTTAGE_2 = "VNSwFiC2";
    private static final String SWAMP_FLETCHER_HOUSE = "VNSwFlHo";
    private static final String SWAMP_HORRIBLE_SECRET = "VNSwHoSe";
    private static final String SWAMP_HUT_FARM = "VNSwHuFa";
    private static final String SWAMP_LARGE_HOUSE = "VNSwLaHo";
    private static final String SWAMP_LIBRARY = "VNSwLibr";
    private static final String SWAMP_MASON_HOUSE = "VNSwMaHo";
    private static final String SWAMP_MEDIUM_HOUSE_1 = "VNSwMeH1";
    private static final String SWAMP_MEDIUM_HOUSE_2 = "VNSwMeH2";
    private static final String SWAMP_SHEPHERD_HOUSE_1 = "VNSwShH1";
    private static final String SWAMP_SHEPHERD_HOUSE_2 = "VNSwShH2";
    private static final String SWAMP_SMALL_HOUSE_1 = "VNSwSmH1";
    private static final String SWAMP_SMALL_HOUSE_2 = "VNSwSmH2";
    private static final String SWAMP_SMALL_HOUSE_3 = "VNSwSmH3";
    private static final String SWAMP_SMALL_HOUSE_4 = "VNSwSmH4";
    private static final String SWAMP_SMALL_HOUSE_5 = "VNSwSmH5";
    private static final String SWAMP_STABLE = "VNSwStb;";
    private static final String SWAMP_TANNERY = "VNSwTann";
    private static final String SWAMP_TEMPLE = "VNSwTemp";
    private static final String SWAMP_TOOL_SMITHY = "VNSwToSm";
    private static final String SWAMP_WEAPON_SMITHY = "VNSwWeSm";
    private static final String SWAMP_WILD_FARM = "VNSwWiFa";
    private static final String SWAMP_ROAD_DECOR = "VNSwStDe";
    private static final String SWAMP_ROAD_ACCENT = "VNSwRdAc";
    private static final String PLACEHOLDER = "plcholdr";
    private static final Map<String, String> COMPONENT_TO_TILE_MAP;
    private static final Map<String, Integer> TILE_TO_PRIORITY_MAP;

    @SideOnly(value=Side.CLIENT)
    public static void registerTextures() {
        VillageWatcherAA.setCustomTileTexture(TILE_VILLAGE_FENCE, "Village Fence", "fence");
        VillageWatcherAA.setCustomTileTexture(TILE_VILLAGE_TREE, "Village Central Tree", "forest");
        VillageWatcherAA.setCustomTileTexture(TILE_VILLAGE_HOUSE, "Village House", "house");
    }

    public static void setCustomTileTexture(String tileName, String printedName, String aaTileFileRoot) {
        TileAPI tileAPI = AtlasAPI.getTileAPI();
        tileAPI.setCustomTileTexture(tileName, tileAPI.registerTextureSet(printedName, new ResourceLocation[]{new ResourceLocation("antiqueatlas", "textures/gui/tiles/" + aaTileFileRoot + ".png")}));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            this.visitAllUnvisitedVillages(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Post event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            this.visitAllUnvisitedVillages(event.getWorld());
        }
    }

    public void visitAllUnvisitedVillages(World world) {
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
        if (data == null) {
            return;
        }
        NBTTagCompound villageNBTData = data.func_143041_a();
        Set tagSet = villageNBTData.func_150296_c();
        for (String coords : tagSet) {
            NBTBase tag;
            if (this.visited.contains(coords) || (tag = villageNBTData.func_74781_a(coords)).func_74732_a() != 10) continue;
            this.visitVillage(world, (NBTTagCompound)tag);
            this.visited.add(coords);
        }
    }

    private void visitVillage(World world, NBTTagCompound tag) {
        if (!VillageGeneratorConfigHandler.newVillageGenerator) {
            return;
        }
        if (!tag.func_74767_n("Valid")) {
            VillageWatcherAA.removeVillage(world, tag);
            return;
        }
        int startChunkX = tag.func_74762_e("ChunkX");
        int startChunkZ = tag.func_74762_e("ChunkZ");
        if (GeneralConfig.debugMessages) {
            LogHelper.info("Visiting NPC Village in dimension #" + world.field_73011_w.getDimension() + "\" at chunk (" + startChunkX + ", " + startChunkZ + ") ~ blocks (" + (startChunkX << 4) + ", " + (startChunkZ << 4) + ")");
        }
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            String tileName;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            int x = (boundingBox.field_78897_a + boundingBox.field_78893_d + 1) / 2;
            int y = (boundingBox.field_78895_b + boundingBox.field_78894_e + 1) / 2;
            int z = (boundingBox.field_78896_c + boundingBox.field_78892_f + 1) / 2;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (VillageWatcherAA.isTownCenter(childID)) {
                boolean foundMarker = false;
                for (int j = -1; j <= 1; ++j) {
                    block2: for (int k = -1; k <= 1; ++k) {
                        List markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), j + chunkX / 8, k + chunkZ / 8);
                        if (markers == null) continue;
                        for (Marker marker : markers) {
                            if (!marker.getType().equals(VILLAGE_MARKER)) continue;
                            foundMarker = true;
                            continue block2;
                        }
                    }
                }
                if (!foundMarker && SettingsConfig.gameplay.autoVillageMarkers) {
                    String aaMArkerName;
                    if (GeneralConfig.antiqueAtlasMarkerNames) {
                        NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, x, y, z);
                        String namePrefix = villageNBTtag.func_74779_i("namePrefix");
                        String nameRoot = villageNBTtag.func_74779_i("nameRoot");
                        String nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
                        aaMArkerName = (namePrefix + " " + nameRoot + " " + nameSuffix).trim();
                    } else {
                        aaMArkerName = "gui.antiqueatlas.marker.village";
                    }
                    AtlasAPI.markers.putGlobalMarker(world, false, VILLAGE_MARKER, aaMArkerName, x, z);
                }
            }
            if ((tileName = COMPONENT_TO_TILE_MAP.get(childID)) == null) continue;
            Integer curTilePriority = TILE_TO_PRIORITY_MAP.get(tileName);
            Integer prevTilePriority = TILE_TO_PRIORITY_MAP.get(VillageWatcherAA.tileAt(chunkX, chunkZ));
            if (curTilePriority != null && prevTilePriority != null) {
                if (curTilePriority < prevTilePriority) continue;
                AtlasAPI.getTileAPI().putCustomGlobalTile(world, tileName, chunkX, chunkZ);
                continue;
            }
            AtlasAPI.getTileAPI().putCustomGlobalTile(world, tileName, chunkX, chunkZ);
        }
    }

    private static String tileAt(int chunkX, int chunkZ) {
        int biomeID = AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(0, chunkX, chunkZ);
        return ExtTileIdMap.instance().getPseudoBiomeName(biomeID);
    }

    private static void removeVillage(World world, NBTTagCompound tag) {
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            List markers;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            int x = (boundingBox.field_78897_a + boundingBox.field_78893_d + 1) / 2;
            int z = (boundingBox.field_78896_c + boundingBox.field_78892_f + 1) / 2;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (VillageWatcherAA.isTownCenter(childID) && (markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), chunkX / 8, chunkZ / 8)) != null) {
                for (Marker marker : markers) {
                    if (!marker.getType().equals(VILLAGE_MARKER)) continue;
                    AtlasAPI.markers.deleteGlobalMarker(world, marker.getId());
                    if (!GeneralConfig.debugMessages) break;
                    LogHelper.info("Removed faux village marker at x=" + (chunkX << 4) + " z=" + (chunkZ << 4));
                    break;
                }
            }
            AtlasAPI.tiles.deleteCustomGlobalTile(world, chunkX, chunkZ);
            if (!GeneralConfig.debugMessages) continue;
            LogHelper.info("Removed faux village tile at x=" + (chunkX << 4) + " z=" + (chunkZ << 4));
        }
    }

    public static boolean isTownCenter(String childID) {
        return PLAINS_FOUNTAIN.equals(childID) || PLAINS_WELL.equals(childID) || PLAINS_MARKET.equals(childID) || PLAINS_CENTRAL_TREE.equals(childID) || DESERT_FOUNTAIN.equals(childID) || DESERT_WELL.equals(childID) || DESERT_MARKET.equals(childID) || TAIGA_GRASSY_CENTER.equals(childID) || TAIGA_WELL.equals(childID) || SAVANNA_MARKET.equals(childID) || SAVANNA_FOUNTAIN.equals(childID) || SAVANNA_DOUBLE_WELL.equals(childID) || SAVANNA_SINGLE_WELL.equals(childID) || SNOWY_ICE_SPIRE.equals(childID) || SNOWY_FOUNTAIN.equals(childID) || SNOWY_PAVILION.equals(childID) || JUNGLE_STATUE.equals(childID) || JUNGLE_TREE.equals(childID) || JUNGLE_GARDEN.equals(childID) || JUNGLE_VILLA.equals(childID) || SWAMP_WILLOW.equals(childID) || SWAMP_STATUE.equals(childID) || SWAMP_PAVILION.equals(childID) || SWAMP_MONOLITH.equals(childID);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)VN_DECOR_TORCH, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)PLAINS_FOUNTAIN, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)PLAINS_WELL, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)PLAINS_MARKET, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_CENTRAL_TREE, (Object)TILE_VILLAGE_TREE);
        builder.put((Object)DESERT_FOUNTAIN, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)DESERT_WELL, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)DESERT_MARKET, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_GRASSY_CENTER, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)TAIGA_WELL, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)SAVANNA_MARKET, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_FOUNTAIN, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)SAVANNA_DOUBLE_WELL, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)SAVANNA_SINGLE_WELL, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)SNOWY_ICE_SPIRE, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)SNOWY_FOUNTAIN, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)SNOWY_PAVILION, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_FLOWER_PLANTER, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)PLAINS_SMALL_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)PLAINS_LARGE_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)PLAINS_DECORATED_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)PLAINS_ARMORER_HOUSE, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)PLAINS_LARGE_HOUSE, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)PLAINS_SMALL_BUTCHER_SHOP, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)PLAINS_LARGE_BUTCHER_SHOP, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)PLAINS_CARTOGRAPHER_HOUSE, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)PLAINS_FISHER_COTTAGE, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_FLETCHER_HOUSE, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)PLAINS_LARGE_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)PLAINS_LARGE_LIBRARY, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)PLAINS_SMALL_LIBRARY, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)PLAINS_MASON_HOUSE, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)PLAINS_MEDIUM_HOUSE_1, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)PLAINS_MEDIUM_HOUSE_2, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)PLAINS_LARGE_MARKET, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_SMALL_MARKET, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_SHEPHERDS_HOUSE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)PLAINS_SMALL_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)PLAINS_SMALL_HOUSE_1, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_SMALL_HOUSE_2, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_SMALL_HOUSE_3, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_SMALL_HOUSE_4, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_SMALL_HOUSE_5, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)PLAINS_SMALL_HOUSE_6, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_SMALL_HOUSE_7, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)PLAINS_SMALL_HOUSE_8, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)PLAINS_COBBLESTONE_STABLE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)PLAINS_TERRACOTTA_STABLE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)PLAINS_TANNERY, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)PLAINS_TERRACOTTA_TEMPLE, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)PLAINS_COBBLESTONE_TEMPLE, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)PLAINS_TOOL_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)PLAINS_WEAPON_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)PLAINS_ROAD_DECOR, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)DESERT_SMALL_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)DESERT_COVERED_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)DESERT_ARMORER_HOUSE, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)DESERT_BUTCHER_SHOP, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)DESERT_CARTOGRAPHER_HOUSE, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)DESERT_SMALL_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)DESERT_MEDIUM_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)DESERT_FISHER_COTTAGE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_FLETCHER_HOUSE, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)DESERT_LARGE_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)DESERT_LIBRARY, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_MASON_HOUSE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_MEDIUM_HOUSE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_LARGE_HOUSE, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)DESERT_SHEPHERDS_HOUSE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)DESERT_SMALL_HOUSE_1, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_SMALL_HOUSE_2, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_SMALL_HOUSE_3, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_SMALL_HOUSE_4, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_SMALL_HOUSE_5, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_SMALL_HOUSE_6, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)DESERT_SMALL_HOUSE_7, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_SMALL_HOUSE_8, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_TANNERY, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)DESERT_TEMPLE_1, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)DESERT_TEMPLE_2, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)DESERT_TOOL_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)DESERT_WEAPON_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)DESERT_ROAD_DECOR, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)DESERT_ROAD_TERRACOTTA_ACCENT_1, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)DESERT_ROAD_TERRACOTTA_ACCENT_2, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)DESERT_ROAD_DECOR_3, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)TAIGA_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)TAIGA_ARMORER_STATION, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_ARMORER_HOUSE, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)TAIGA_BUTCHER_SHOP, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)TAIGA_CARTOGRAPHER_HOUSE, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)TAIGA_FISHER_COTTAGE, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_FLETCHER_HOUSE, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)TAIGA_LARGE_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)TAIGA_MEDIUM_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)TAIGA_LIBRARY, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)TAIGA_MASON_HOUSE, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)TAIGA_MEDIUM_HOUSE_1, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)TAIGA_MEDIUM_HOUSE_2, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)TAIGA_MEDIUM_HOUSE_3, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)TAIGA_MEDIUM_HOUSE_4, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)TAIGA_SHEPHERD_HOUSE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)TAIGA_SMALL_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)TAIGA_SMALL_HOUSE_1, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_SMALL_HOUSE_2, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_SMALL_HOUSE_3, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_SMALL_HOUSE_4, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)TAIGA_SMALL_HOUSE_5, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_TANNERY, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)TAIGA_TEMPLE, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)TAIGA_TOOL_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)TAIGA_WEAPON_SMITH_HOUSE, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)TAIGA_WEAPON_SMITH_STATION, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)TAIGA_ROAD_DECOR, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)SAVANNA_COVERED_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)SAVANNA_LARGE_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)SAVANNA_MEDIUM_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)SAVANNA_ARMORER_HOUSE, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SAVANNA_BUTCHER_SHOP_1, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SAVANNA_BUTCHER_SHOP_2, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SAVANNA_CARTOGRAPHER, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)SAVANNA_FISHER_COTTAGE, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_FLETCHER_HOUSE, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SAVANNA_METHODICAL_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)SAVANNA_HAPHAZARD_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)SAVANNA_LIBRARY, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)SAVANNA_MASON_HOUSE, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SAVANNA_MEDIUM_HOUSE_1, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_MEDIUM_HOUSE_2, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SAVANNA_SHEPHERD_HOUSE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SAVANNA_SMALL_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)SAVANNA_SMALL_HOUSE_1, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_SMALL_HOUSE_2, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_SMALL_HOUSE_3, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_SMALL_HOUSE_4, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SAVANNA_SMALL_HOUSE_5, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)SAVANNA_SMALL_HOUSE_6, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_SMALL_HOUSE_7, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_SMALL_HOUSE_8, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SAVANNA_TANNERY, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SAVANNA_TEMPLE_1, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)SAVANNA_TEMPLE_2, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)SAVANNA_TOOL_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SAVANNA_SMALL_WEAPON_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SAVANNA_LARGE_WEAPON_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SAVANNA_ROAD_DECOR, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)SAVANNA_ROADSIDE_FARM_1, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)SAVANNA_ROADSIDE_FARM_2, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)SAVANNA_ROADSIDE_FARM_3, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)SAVANNA_ROADSIDE_FARM_4, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)SNOWY_ANIMAL_PEN_1, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)SNOWY_ANIMAL_PEN_2, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)SNOWY_ARMORER_HOUSE_1, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SNOWY_ARMORER_HOUSE_2, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SNOWY_BUTCHER_HOUSE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SNOWY_BUTCHER_IGLOO, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_CARTOGRAPHER_HOUSE, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)SNOWY_SQUARE_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)SNOWY_PATCH_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)SNOWY_FISHER_COTTAGE, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_FLETCHER_HOUSE, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SNOWY_LIBRARY, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)SNOWY_MASON_HOUSE_1, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SNOWY_MASON_HOUSE_2, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SNOWY_MEDIUM_HOUSE_1, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_MEDIUM_HOUSE_2, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)SNOWY_MEDIUM_HOUSE_3, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_SHEPHERD_HOUSE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SNOWY_SMALL_HOUSE_1, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_SMALL_HOUSE_2, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_SMALL_HOUSE_3, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)SNOWY_SMALL_HOUSE_4, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_SMALL_HOUSE_5, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_SMALL_HOUSE_6, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_SMALL_HOUSE_7, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_SMALL_HOUSE_8, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SNOWY_TANNERY, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SNOWY_TEMPLE, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)SNOWY_TOOL_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SNOWY_WEAPON_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SNOWY_ROAD_DECOR, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)JUNGLE_ARMORER_HOUSE, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_BUTCHER_SHOP, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)JUNGLE_CARTOGRAPHER_HOUSE_1, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)JUNGLE_CARTOGRAPHER_HOUSE_2, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)JUNGLE_FISHER_COTTAGE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)JUNGLE_FLETCHER_HOUSE_1, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)JUNGLE_FLETCHER_HOUSE_2, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)JUNGLE_MASON_HOUSE, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)JUNGLE_LARGE_HOUSE, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)JUNGLE_LIBRARY, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)JUNGLE_MEDIUM_HOUSE_1, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)JUNGLE_MEDIUM_HOUSE_2, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)JUNGLE_MEDIUM_HOUSE_3, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_MEDIUM_HOUSE_4, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)JUNGLE_SHEPHERD_HOUSE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)JUNGLE_SMALL_HOUSE_1, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)JUNGLE_SMALL_HOUSE_2, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)JUNGLE_SMALL_HOUSE_3, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_SMALL_HOUSE_4, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_SMALL_HOUSE_5, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_SMALL_HOUSE_6, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_SMALL_HOUSE_7, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_SMALL_HOUSE_8, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)JUNGLE_STABLE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)JUNGLE_STEPPED_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)JUNGLE_STONE_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)JUNGLE_TAMED_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)JUNGLE_TANNERY_1, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)JUNGLE_TANNERY_2, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_TEMPLE, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)JUNGLE_TOOL_SMITHY_1, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)JUNGLE_TOOL_SMITHY_2, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)JUNGLE_WEAPON_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)JUNGLE_WILD_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)JUNGLE_WOOD_ANIMAL_PEN, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)JUNGLE_ROAD_DECOR, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)JUNGLE_ROAD_ACCENT_1, (Object)TILE_VILLAGE_WELL);
        builder.put((Object)JUNGLE_ROAD_ACCENT_2, (Object)TILE_VILLAGE_TREE);
        builder.put((Object)SWAMP_ANIMAL_PEN_1, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_ANIMAL_PEN_2, (Object)TILE_VILLAGE_FENCE);
        builder.put((Object)SWAMP_ARMORER_HOUSE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_BUTCHER_SHOP, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SWAMP_CARTOGRAPHER_HOUSE, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)SWAMP_FISHER_COTTAGE_1, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)SWAMP_FISHER_COTTAGE_2, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_FLETCHER_HOUSE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_HUT_FARM, (Object)TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)SWAMP_LARGE_HOUSE, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)SWAMP_LIBRARY, (Object)TILE_VILLAGE_LIBRARY);
        builder.put((Object)SWAMP_MASON_HOUSE, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_MEDIUM_HOUSE_1, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_MEDIUM_HOUSE_2, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_SHEPHERD_HOUSE_1, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)SWAMP_SHEPHERD_HOUSE_2, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SWAMP_SMALL_HOUSE_1, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_SMALL_HOUSE_2, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_SMALL_HOUSE_3, (Object)TILE_VILLAGE_HUT);
        builder.put((Object)SWAMP_SMALL_HOUSE_4, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_SMALL_HOUSE_5, (Object)TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)SWAMP_STABLE, (Object)TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)SWAMP_TANNERY, (Object)TILE_VILLAGE_L_HOUSE);
        builder.put((Object)SWAMP_TEMPLE, (Object)TILE_VILLAGE_CHURCH);
        builder.put((Object)SWAMP_TOOL_SMITHY, (Object)TILE_VILLAGE_HOUSE);
        builder.put((Object)SWAMP_WEAPON_SMITHY, (Object)TILE_VILLAGE_SMITHY);
        builder.put((Object)SWAMP_WILD_FARM, (Object)TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)SWAMP_ROAD_DECOR, (Object)TILE_VILLAGE_TORCH);
        builder.put((Object)SWAMP_ROAD_ACCENT, (Object)TILE_VILLAGE_TORCH);
        COMPONENT_TO_TILE_MAP = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put((Object)TILE_VILLAGE_WELL, (Object)7);
        builder.put((Object)TILE_VILLAGE_TREE, (Object)7);
        builder.put((Object)TILE_VILLAGE_CHURCH, (Object)7);
        builder.put((Object)TILE_VILLAGE_HOUSE, (Object)7);
        builder.put((Object)TILE_VILLAGE_L_HOUSE, (Object)6);
        builder.put((Object)TILE_VILLAGE_LIBRARY, (Object)6);
        builder.put((Object)TILE_VILLAGE_SMITHY, (Object)6);
        builder.put((Object)TILE_VILLAGE_BUTCHERS_SHOP, (Object)6);
        builder.put((Object)TILE_VILLAGE_SMALL_HOUSE, (Object)5);
        builder.put((Object)TILE_VILLAGE_HUT, (Object)4);
        builder.put((Object)TILE_VILLAGE_FARMLAND_LARGE, (Object)3);
        builder.put((Object)TILE_VILLAGE_FARMLAND_SMALL, (Object)3);
        builder.put((Object)TILE_VILLAGE_FENCE, (Object)2);
        builder.put((Object)TILE_VILLAGE_TORCH, (Object)1);
        TILE_TO_PRIORITY_MAP = builder.build();
    }
}

