/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class VillageConfigHandler {
    public static ConfigurationVN config;
    public static String[] village_prefix;
    public static String[] village_root_initial;
    public static String[] village_root_syllables;
    public static String[] village_root_terminal;
    public static String[] village_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            VillageConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        village_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "village syllable pool", "Bandar, Bandar, East, El, Flying, Fort, Half, Green, King, La, Le, Monte, Mount, New, New, North, Old, Port, Port, Port, Port, Port, Port, Port, Queen, S\u00e3o, S\u00e3o, Saint, Saint, Saint, Saint, San, San, San, San, San, San, San, San, Santa, Santo, Santo, South, Sri, St., St., St., St., St., St., St., St., The, The, Valley, West", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        village_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "village syllable pool", "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Aa, Ash, Au, Au, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Bai, Be, Be, Be, Be, Be, Be, Be, Be, Bea, Beau, Bei, Bei, Bei, Bi, Bi, Bi, Bi, Bi, Bloe, Bo, Bo, Bo, Boo, Bra, Bra, Bra, Bra, Bra, Bra, Bra, Bri, Bri, Bri, Bru, Bru, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bue, Bue, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Cai, Cai, Cay, Cay, Ce, Cha, Cha, Cha, Cha, Chi, Chi, Cley, Cli, Clo, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Conde, Cre, Cre, Cru, Cu, Da, Da, Da, Da, Da, Da, De, De, De, Dha, Dha, Di, Di, Dji, Dji, Do, Do, Do, Do, Do, Do, Do, Dou, Dou, Dou, Du, Du, Du, Du, Du, Du, Du, Du, Dy, E, E, E, E, E, E, E, Ed, Ed, Fa, Fa, Fa, Fai, Fi, Fi, Fi, Fi, Fi, Fi, Fra, Free, Free, Fu, Fu, Fy, Ga, Ga, Ga, Ga, Gai, Geo, Geo, Geo, Geo, Geo, Geo, Geo, Geo, Gi, Gi, Go, Goa, Gree, Gro, Gu, Gu, Gua, Gua, Gua, Gy, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, He, He, He, He, Hi, Ho, Ho, Ho, Ho, I, I, I, I, I, I, Ja, Ja, Ja, Ja, Ja, Je, Je, Je, Ji, Jo, Jo, Jo, Jo, Jo, Ju, Ju, Ju, Jua, Jua, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Kai, Kha, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Kie, Ko, Ko, Ko, Ko, Ku, Ku, Ku, Kua, Kua, Kyi, La, La, Li, Li, Li, Li, Li, Li, Li, Li, Li, Li, Li, Lju, Lju, Lo, Lo, Lo, Lo, Lo, Lo, Lo, Lou, Lou, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Luo, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Mba, Me, Me, Me, Me, Mi, Mi, Mi, Mi, Mi, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Moo, More, More, Mu, Mu, Mu, My, My, My, N, N, N, Na, Na, Na, Na, Na, Nai, Nai, Nay, Ne, Ni, Ni, Ni, Ni, Nia, Nia, Nou, Nou, Noua, Noua, Nu, Nu, Nuu, Nuu, O, O, O, O, O, O, O, Oua, Oua, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pau, Pe, Pe, Pe, Phi, Phno, Phno, Pi, Pi, Ply, Po, Po, Po, Po, Pra, Pra, Pra, Pra, Pra, Pre, Pre, Pri, Pri, Pri, Pri, Pu, Pyo, Pyo, Que, Que, Qui, Ra, Ra, Re, Re, Re, Rey, Rey, Ri, Ri, Ri, Ri, Ro, Ro, Ro, Ro, Ro, Roa, Roa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sai, Sai, Schaa, Se, Se, Se, Se, Se, Seou, Seou, Sha, Shi, Si, Si, Si, Sko, Sko, So, So, Spai, Sta, Sta, Ste, Ste, Sto, Sto, Su, Su, Su, Su, Su, Sy, Sy, T, T, T\u00f3, T\u00f3, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Tai, Tai, Te, Te, Te, Te, Te, Te, Tha, Thi, Thi, Thi, Ti, Ti, Ti, Ti, Ti, Ti, To, To, To, To, To, To, To, To, Tre, Tree, Tri, Tri, Troi, Tskhi, Tskhi, Tu, Tu, Tu, Tze, U, U, U, Va, Va, Va, Va, Va, Va, Ve, Vi, Vi, Vi, Vi, Vi, Vi, Vi, Vi, Vie, Vie, Wa, Wa, Wa, Wa, Wa, We, We, Wi, Wi, Wi, Wi, Wi, Wu, Xi, Ya, Ya, Ya, Ya, Ya, Ye, Ye, Yo, Z\u00fc, Za, Za, Zo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        village_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "village syllable pool", "_Chi, _Pe, 'a, 'Dja, 'Dja, a, a, a, a, a, a, a, ba, ba, ba, ba, ba, bai, be, beye, bi, bi, bi, bli, bli, bli, blja, blja, bo, bo, bo, bou, bou, bra, bra, bre, bre, bu, bu, bu, bu, bu, ccra, ccra, cha, cha, che, cho, cho, ci, ckbu, cke, ckho, ckho, ckla, co, co, co, cre, cto, cto, cto, da, da, da, da, da, dai, ddi, ddi, de, dee, dga, dgeto, dgeto, dgo, dgo, di, dney, do, doo, dri, dri, dsto, du, e, e, e, e, e, e, e, fa, fe, fi, fi, fto, fu, g\u00e5, ga, ga, ga, ga, ga, ga, ga, ga, ga, ga, ga, ga, ge, ghda, ghda, gla, gla, go, go, go, go, go, go, gre, gre, gu, gu, gua, gue, ha, ha, ha, hli, hra, hra, i, i, i\u00fa, ia, ia, ji, ju, ju, ju, ka, ka, ka, ka, ka, ka, ka, kcho, kcho, ke, khu, khu, kja, kja, kku, ku, ku, ku, ku, kyo, kyo, l\u00e9, l\u00e9, la, la, la, la, la, la, la, la, laa, lba, lbroo, le, le, lex, lfhei, lga, lgie, lgie, lgra, lgra, lhi, li, li, li, li, li, li, li, li, li, lka, lle, lle, lle, lle, llege, lley, lli, lli, lli, lma, lmo, lmo, lni, lni, lo, lo, lo, lo, lo, lo, loo, lpa, lsi, lsi, ltai, lva, lva, lvi, m_Pe, m_Pe, m\u00e9, m\u00e9, m\u00e9, m\u00e9, m\u00e9, ma, ma, ma, ma, ma, ma, ma, mbai, mbe, mdu, mesto, mey, mey, mfo, mhe, mi, mi, mi, mma, mma, mou, mou, mou, mou, mpa, mpa, mphi, mphu, mphu, mpo, mra, msi, mste, mste, mu, mu, n_Ba, na, na, na, na, na, na, na, na, na, na, na, na, na, na, naa, nbe, ndblu, ndhoe, ndhoe, ndo, ndo, ndo, ndo, ndo, ng_Ko, nga, nga, nga, nga, nghai, ngko, ngko, ngo, ngspo, ngsto, ngsto, ngsto, ngsto, ngsto, ngui, ngui, ngya, ngya, ngyea, ngyea, nhi, ni, ni, ni, ni, ni, ni, ni, nji, nju, nka, nley, nley, nnsmou, no, no, no, no, no, noi, nra, nro, nro, nsha, nsha, nta, nta, nta, nte, nte, nti, nti, ntia, ntia, nto, nva, nva, nwi, nzi, ou, pa, pa, pa, pe, pe, pe, pe, pei, pei, pi, pi, pi, pi, pje, pje, pli, po, po, po, pu, pu, pyi, r_Sa, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, ra, rble, re, re, re, re, re, re, re, rfa, rga, rge, rge, rge, rgei, rgeto, rgeto, rgeto, rshe, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, rkha, rki, rli, rli, rli, rlo, rlo, rlo, rme, rna, rne, ro, ro, ro, ro, ro, ro, ro, ro, ro, ro, ro, rpe, rre, rsa, rsa, rsha, rsha, rto, rtou, ru, ru, ru, ru, ru, rwe, s\u00e9, s\u00e9, s\u00ed, sa, sa, sa, sa, sbo, sbo, sby, sby, sca, sca, sce, sce, sco, sco, sco, se, se, seau, seau, sha, sha, shga, shga, shi, shke, shke, shke, shke, si, si, si, si, si, sla, sla, slo, slo, sma, sma, smo, ssau, ssau, ssau, ssau, sse, sse, sse-Te, sse-Te, ssete, ssete, sta, sta, sta, sta, sta, ste, stha, sti, sti, sti, sto, sto, sto, strie, strie, su, su, ta, ta, ta, ta, tai, te, te, te, te, the, the, thma, thma, tho, thri, ti, ti, ti, ti, tin, tio, to, to, to, to, to, tra, tre, tswoo, tta, tto, va, va, va, va, va, ve, vo, wa, wa, wai, wai, wbu, wloo, wso, xe, xe, xi, xi, ya, ya, ya, ya, ya, za, za, zny, zo, zo, zu, zu, zza, zza, _Be, _Be, _Dha, _Ga, _Lu, _Lu, _Mi, _Pa, _Ro, -No, -U, -U, 'a, 'a, 'a, 'a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, ba, ba, ba, bi, bi, bla, bo, ca, ca, ca, ca, chi, ci, ci, ci, ci, cle, co, co, co, da, deau, di, di, di, di, dja, do, do, dou, dou, dzou, dzou, e, e, e, e, e, e, fi, fi, fu, fu, ga, go, go, gua, gua, hea, i, ja, ja, je, je, je, ka, ka, ka, ki, ki, ko, ko, kry, kry, ku, la, la, la, la, laa, lhei, li, li, li, li, li, li, li, li, li, lia, lla, lta, lta, lto, ma, ma, ma, ma, ma, ma, ma, ma, ma, ma, ma, mba, mbo, mbou, mbou, mbu, mbu, me, me, mi, mi, mpi, msta, msta, msto, msto, n_Ba, n_Sa, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, nau, nau, nbaa, nbe, nbe, nbu, nbu, nci, nci, nd\u00e9, nda, nda, nda, ndo, ndu, ndu, ne, nge, ngo, ngo, ngto, ngto, ngto, ngwe, ngwe, nha, nha, ni, ni, ni, ni, ni, ni, ni, ni, nje, nje, nki, nki, nna, nna, nne, no, nou, ntei, nto, nto, nu, ny, o, o, pa, pe, pe, po, po, po, ppo, psbu, qui, ra, ra, ra, ra, ra\u00ed, rbye, rbye, rda, rda, re, re, re, re, rga, ri, ri, ri, ri, ri, ri, ri, ri, rka, rma, rnfo, ro, ro, ro, ro, ro, rra, rra, rra, rre, rta, rta, ru, ru, ru, ru, rul, ry, ry, s_A, s_A, s_Ai, s_Ai, sa, sa, sa, sa, sa, sa, sa, scu, si, si, sko, sko, sla, sla, spo, spo, ssou, ste, t\u00e1, t\u00e1, t\u00f1a, ta, ta, ti, ti, tie, to, to, to, tta, tte_A, tte_A, ty, u, u, va, va, vi, vi, vi, vi, vi, vi, vi, vi, vi, vi, vi, vi, vo, wa, wa, wa, you, \u00f3, \u00f3, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, ba, ba, ba, bi, bo, ca, ca, ce, de, de, fo, ga, ga, ga, ga, ge, ge, go, go, go, gou, gou, ha, ha, ke, ke, kro, la, la, le, le, le, lo, lo, ma, ma, mpu, mpu, mu, na, na, na, na, nca, nda, ndri, ne, ne, o, o, pi, pi, po, r, ra, ra, ra, ra, ra, rde, re, re, ri, ri, ri, sbu, shu, shu, si, si, si, so, sta, sta, ta, te, te, ti, ti, ti, to, tu, tu, va, va, vo, vo, vo, ya, za, a, ba, ba, bo, bo, fa, fa, lie, lie, lpa, lpa, m, m, ne, o, o, ri, ri, wa, wa, pu, vo, vo, ra", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        village_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "village syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, 's, 's, 's, b, b, c, c, ch, ch, d, d, d, d, d, d, d, d, d, d, d, d, d, d, de, de, de, de, de, des, dh, dh, fsk, ft, gh, gue, gue, gue, h, h, hl, hn, hn, k, k, k, k, k, k, k, k, k, k, k, k, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l', lb, le, le, ll, ll, lle, lle, lle, lle, lm, lm, lm, ls, ls, lse, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, mb, me, me, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, nce, nce, nce, nd, nd, nd, nd, ne, ne, ne, ne, ng, ng, ng, ng, ng, ng, ng, ng, nh, nh, nh, nn, nne, nne, ns, ns, nsk, nsk, nt, nt, nt, nt, pe, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, rd, rd, rd, rd, re, re, re, rg, rg, rg, rg, rge, rge, rh, rk, rn, rn, rnt, rre, rre, rre, rre, rre, rre, rs, rs, rs, rst, rt, rt, rt, rt, rt, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, sh, sh, st, st, st, st, st, t, t, t, t, t, t, t, t, t, t, t, t, t, te, th, th, tt, tt, v, v, ve, vn, vn, w, w, w, w, w, wn, wn, wn, wn, wn, wn, wn, wn, wn, wn, wn, wn, wn, wn, x, x, z, z, z, z, ze", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        village_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "village syllable pool", "Bank, Cantonment, Cantonment, Canyon, Castle, Cays, City, City, Cove, Cove, de la Sierra, del Sol, District, Estate, Ferry, Hill, Hollow, Inn, Kotte, Lake, Mountain, of the Sea, Park, Park, Pine, Point, Point, Port, Port, Town, Town, Town, Town, Town, Town, Town, Town, Valley, Vella, Vella, Village", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("village syllable pool", "Syllable Count Weighting", NamePieces.VILLAGE_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("village syllable pool", "Terminal Blank Counts", NamePieces.VILLAGE_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "village syllable pool", village_root_initial.length - 1 <= 0 ? 0.0f : ((float)village_prefix.length - 1.0f) / (float)(village_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "village syllable pool", village_root_initial.length - 1 <= 0 ? 0.0f : ((float)village_suffix.length - 1.0f) / (float)(village_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

