/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class TempleConfigHandler {
    public static ConfigurationVN config;
    public static String[] temple_prefix;
    public static String[] temple_root_initial;
    public static String[] temple_root_syllables;
    public static String[] temple_root_terminal;
    public static String[] temple_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            TempleConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        temple_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "temple syllable pool", "Abu, Abu, Beit, Divus, Jebel, Jebel, Mater, Saint, San, San, San, Santa, Santa, Santo", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        temple_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "temple syllable pool", "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Au, Au, B\u00f3, Ba, Ba, Ba, Ba, Ba, Ba, Baa, Baa, Be, Bo, Bor, Bu, C\u00f3, Ca, Ca, Ca, Cae, Ce, Ch\u00e2, Ci, Clau, Cle, Co, Co, Co, Co, Cou, Cu, Da, Da, De, De, De, De, Di, Di, Di, Di, Do, Do, Do, Do, Do, E, E, E, E, E, E, E, E, E, E, F\u00e2, Fau, Fe, Fi, Fle, G, G\u00f6, Ga, Ge, Ge, Gha, Giu, Gra, Grie, Ha, Ha, Ha, Ha, Ha, Ha, He, He, He, He, He, He, He, He, Hei, Hi, I, I, Ja, Je, Jo, Ju, Ju, Ju, Ka, Ka, Kha, Ko, Koe, Ku, La, Le, Le, Le, Li, Lo, Lu, Lu, Ly, Ly, M, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Me, Me, Me, Me, Mi, Mi, Mo, Mou, Mu, Mu, Ne, Ne, Ni, Ny, O, O, O, Pa, Pa, Pa, Pa, Pa, Pe, Pe, Pea, Phi, Po, Po, Po, Po, Pri, Pri, Pu, Qa, Qa, Qe, Ra, Ra, Re, Ro, Ro, Ro, Ro, Ro, S, Sa, Sa, Sa, Sa, Sa, Sch\u00f6, Se, Se, Se, Se, Se, Se, Se, Sha, Si, Si, Si, Si, Sko, So, So, Spe, Sy, Sy, Ta, Ta, Ta, Ta, Ta, Ta, Tau, Te, Te, Te, Thu, Ti, To, To, Tr\u00e9, Tra, Tu, U, U, V\u00e9, Va, Ve, Ve, Ve, Ve, Ve, Ve, Vei, Vi, Vi, Wa, Wa, Wa, We, Xa, Xe, Y, Za, Za, Zeu", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        temple_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "temple syllable pool", "\u017ea, a, a, ba, be, bei, bii, blai, bo, bu, cchu, chnou, ckwi, co, cro, ddi, di, di, di, dney, do, dri, dri, e, ffe, fli, fra, ga, ga, ge, ge, ge, gga, ghou, gi, gi, gi, gno, gou, gra, gu, gu, ha, ha, ja, kka, la, la, la, la, lai, lbe, lc\u00e1, le, le, li, li, li, li, li, llu, lo, ltba, lve, ma, ma, mae, mbe, me, me, me, mi, mi, mi, mna, mne, mo, mo, mo, mphae, mpho, mu, mu, mxi, n\u00f3, na, na, nai, nb\u00fc, nbi, nci, nco, nco, ncra, nd\u00e9, ndo, ndun, ne, ne, nge, ni, ni, nka, nma, nne, nni, nnu, no, no, nta, nte, nthe, ntju, nto, nu, nu, nu, nxay, o, o, o, o, o, pe, pha, pha, pha, phe, phro, phy, pi, pi, po, psi, pti, pto, ptu, qa, r\u00f3, ra, ra, ra, ra, ra, rai, rba, rbe, rco, rcu, rcu, rcu, rda, rdi, rdi, rdo, re, re, rfu, rgo, ri, ri, ri, ri, rka, rmo, rna, rna, rne, rne, ro, ro, ro, rr\u00e9e, rra, rre, rre, rsi, rsi, rta, rtbe, rte, rthe, rto, rtu, ru, rxi, s, sa, sca, scle, sei, sha, shmou, si, sme, so, spa, spa, st\u00f3, sta, sti, sto, stte, sy, tca, te, teli, the, to, tra, tra, tra, tro, tta, tti, tu, tu, u, u, u, ve, vi, wa, we, xo, ze, zo, zo, \u00e0, a, a, a, a, a, a, ba, ba, bba, bo, bou, bri, bsha, chta, chthe, cle, cto, cu, da, da, de, de, di, dna, do, e, e, e, e, e, e, ga, ge, gga, gni, gsho, gtu, i, i, i, ia, ja, ja, jdra, la, la, li, lle, lli, llo, lu, mbri, me, mi, mo, na, na, na, na, na, na, ndo, ne, ne, nga, ni, no, nta, nte, nti, nto, nu, nu, nu, nvi, ny, o, o, o, o, pe, pi, po, po, po, po, ppa, ppei, py, r\u00e1, ra, ra, rbo, rdi, re, re, ri, ri, ri, rme, rno, rnu, rra, rta, rva, ry, sa, sbu, scu, scu, si, si, so, sre, ssi, sta, sta, ste, stei, sti, stu, su, su, ta, te, te, ti, ti, tla, to, u, u, u, u, u, vi, wbu, wwa, ze, zi, a, a, a, a, a, a, ca, e, e, ffe, ga, ga, ja, ko, le, le, li, li, li, lo, lzu, ma, na, na, ne, ne, ni, ni, nia, no, no, nstei, nte, nu, o, o, o, qua, ra, ra, ra, ra, rdo, re, re, ri, ri, ri, rti, so, ssa, stu, stu, te, u, u, u, u, cu, ne, nki, nu, o, u", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        temple_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "temple syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, b, b, b, c, c, c, ce, d, g, g, gh, h, h, hl, k, k, k, l, l, l, l, l, l, l, l, le, lfe, lg, lle, m, m, m, m, m, m, m, m, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, ne, ne, ns, ns, r, r, r, r, r, r, r, r, r, r, rd, rd, re, re, re, rf, rg, rg, rg, rgh, rn, rn, rr, rs, rs, rx, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, se, t, t, t, t, t, t, tt, tte, x, x", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        temple_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "temple syllable pool", "Hill, Magna, Qim", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("temple syllable pool", "Syllable Count Weighting", NamePieces.TEMPLE_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("temple syllable pool", "Terminal Blank Counts", NamePieces.TEMPLE_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "temple syllable pool", temple_root_initial.length - 1 <= 0 ? 0.0f : ((float)temple_prefix.length - 1.0f) / (float)(temple_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "temple syllable pool", temple_root_initial.length - 1 <= 0 ? 0.0f : ((float)temple_suffix.length - 1.0f) / (float)(temple_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

