/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class StrongholdConfigHandler {
    public static ConfigurationVN config;
    public static String[] stronghold_prefix;
    public static String[] stronghold_root_initial;
    public static String[] stronghold_root_syllables;
    public static String[] stronghold_root_terminal;
    public static String[] stronghold_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            StrongholdConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        stronghold_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "stronghold syllable pool", "A, Devil's, Great, Great, Per, Santa", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        stronghold_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "stronghold syllable pool", "\u00c1, A, A, A, A, A, A, A, A, Au, Ba, Ba, Ba, Ba, Ba, Ba, Bei, Bi, Bou, Bri, Cai, Cha, Cha, Che, Co, Co, Co, Co, Co, Cze, Da, De, Di, Du, E, E, Fa, Fa, Flo, Flo, G\u00f6, Ge, Go, Gri, Gu, Ha, He, He, Hei, Hi, Hi, Hu, I, Ja, Ja, Je, Je, Je, Ju, Ka, Ke, Kli, Ko, Kre, Ku, Lo, Lu, Lu, M, Ma, Ma, Ma, Me, Me, Me, Mie, Mo, Mo, Ne, Ni, Ni, O, Pa, Pa, Pa, Pe, Po, Qry, Qua, Ra, Rha, Ru, Sa, Sa, Se, Se, Se, Se, Si, Sie, Sta, Sto, Su, Su, Svea, Tla, To, Tra, Tri, Va, Vi, Vi, Wa, Xi, Yo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        stronghold_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "stronghold syllable pool", "'a, al, ba, bo, bro, by, cho, co, co, csay, cto, czk\u00f3, dde, di, dri, dzy, e, e, ffa, fri, gfrie, ggu, gi, go, ja, ji, ka, la, lbi, le, li, lle, lo, lpine, lsea, lva, ma, ma, mbha, mli, mo, mste, msto, na, na, nde, nde, ndo, ndo, ne, ng_Ng\u00e3i, ngbo, ngle, ngseo, ni, ni, nne, no, nsta, nto, ntra, ntse, nwy, o, o, pe, r_Le, ra, ra, rce, rde, re, rga, rghe, rgu, ri, ri, rma, ro, rpe, rra, rre, rry, rtsmou, ru, rvi, sby, se, ssi, sta, ste, sti, su, ta, ta, tla, to, tro, tte, tto, ve, vi, wca, xa, xca, xo, ya, a, a, a, a, a, bla, cae, cho, di, gu, gu, hu, i, kli, ko, la, la, lga, li, lo, lo, me, mi, mo, mu, na, na, nbu, ne, ne, ni, ni, ni, no, nti, ntu, ra, rba, rda, rhei, ri, ri, ru, ry, rze, s_Ve, sa, sa, si, sia, slo, sta, stle, su, ti, tia, to, tta, va, vi, vi, vni, xa, a, a, a, a, a, cu, dra, k\u0131, le, lio, na, na, nli, no, no, o, ra, ra, ri, rke, rke, ro, sia, sta, t\u00e1, ta, va, di, m\u00e1, nna, ple", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        stronghold_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "stronghold syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, cz, d, de, k, k, l, l, m, m, m, m, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, ne, ng, ng, nt, r, r, r, r, r, rg, rg, rh, rk, s, s, s, s, s, s, s, s, s, s, s, s, sh, t, t, t, th, tz, v, v, v, w, x", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        stronghold_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "stronghold syllable pool", "Box, Castle, Citadel, Citadel, Eredo, Fortress, Fortress, Fortress, Hill, Shrine, Subterrane, Zuu", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("stronghold syllable pool", "Syllable Count Weighting", NamePieces.STRONGHOLD_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("stronghold syllable pool", "Terminal Blank Counts", NamePieces.STRONGHOLD_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "stronghold syllable pool", stronghold_root_initial.length - 1 <= 0 ? 0.0f : ((float)stronghold_prefix.length - 1.0f) / (float)(stronghold_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "stronghold syllable pool", stronghold_root_initial.length - 1 <= 0 ? 0.0f : ((float)stronghold_suffix.length - 1.0f) / (float)(stronghold_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

