/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;

public class PetConfigHandler {
    public static ConfigurationVN config;
    public static String[] pet_prefix;
    public static String[] pet_root_initial;
    public static String[] pet_root_syllables;
    public static String[] pet_root_terminal;
    public static String[] pet_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            PetConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        pet_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "pet syllable pool", "Beautiful, Best, Big, Big, Black, Black, Black, Bold, Bold, Brigadier, Brown, Colonel, Country, Dr., Fabulous, Faithful, Famous, Giant, Golden, Handsome, King, La, La, Lil, Little, Master, Mighty, Miss, Mlle., Mother, Mr., Mr., Mrs, Old, Old, Old, Prince, Professor, Red, Red, Red, Saint, Senator, Sweet, The, Tiny, Top, Two, Wise", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        pet_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "pet syllable pool", "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Bae, Bai, Bai, Be, Be, Be, Be, Be, Be, Be, Be, Be, Be, Be, Be, Be, Bea, Bea, Bea, Bea, Bea, Beau, Bee, Bee, Bi, Bi, Bi, Bi, Bla, Bla, Bla, Bla, Bla, Blai, Bli, Blo, Blo, Blue, Blue, Blue, Bo, Bo, Bo, Bo, Bo, Bo, Bo, Boa, Boo, Boo, Boo, Bou, Boye, Bra, Bra, Bre, Bro, Bro, Broo, Bru, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Cae, Cai, Cha, Cha, Cha, Cha, Cha, Cha, Cha, Cha, Che, Che, Che, Che, Che, Che, Chee, Chi, Chi, Chi, Chi, Chi, Chlo, Chou, Chro, Chu, Ci, Ci, Ci, Ci, Ci, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Cre, Crea, Cri, Cu, Da, Da, Da, Da, Da, Da, Da, Da, Da, Da, Da, Dai, De, De, De, Dee, Dhu, Di, Di, Di, Dia, Do, Do, Do, Do, Do, Do, Do, Do, Do, Doo, Dru, Du, Du, Du, Du, Dzo, E, E, E, E, E, E, E, E, E, E, F\u00e9, Fa, Fa, Fa, Fa, Fa, Fai, Fai, Fay, Fe, Fi, Fi, Fi, Fi, Fi, Fi, Flai, Flo, Flo, Flu, Fly, Fo, Fo, Foo, Fra, Fre, Fre, Fri, Fru, Fu, Ga, Ga, Ga, Ga, Ga, Ga, Gai, Ge, Ge, Ge, Gea, Gee, Geo, Geo, Geo, Gi, Gi, Gi, Gi, Gi, Gla, Glo, Gloa, Go, Go, Go, Goo, Gra, Gra, Grau, Grey, Grey, Grey, Gu, Gui, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, He, He, He, He, He, Hea, Hei, Hei, Hi, Hi, Hi, Hi, Ho, Ho, Ho, Hoo, Hou, Hou, Hu, Hu, Hua, Hy, I, I, I, I, I, I, I, I, I, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Jay, Je, Je, Je, Je, Je, Jea, Jeo, Ji, Ji, Ji, Ji, Jo, Jo, Jo, Jo, Jo, Jo, Jo, Jo, Jo, Joe, Joe, Joy, Ju, Ju, Ju, K, Ka, Ka, Ka, Ka, Ka, Kay, Ke, Ke, Ke, Kha, Khou, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ko, Ko, Ko, Ko, Ko, Ku, Ky, La, La, La, La, La, La, La, Lai, Le, Le, Le, Le, Le, Le, Le, Lea, Li, Li, Li, Li, Li, Li, Li, Lla, Llu, Lo, Lo, Lo, Lo, Lo, Lo, Lo, Lou, Lou, Lu, Lu, Lu, Lu, Lu, Lu, Lu, M, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Mar, Mau, Me, Me, Me, Me, Me, Mea, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Moi, Moo, Moo, Mou, Mou, Mou, Mu, Mu, Mu, Mu, Mu, Mu, Na, Na, Na, Na, Ne, Ne, Ne, Ne, Ne, Nee, Neu, Ni, Ni, Ni, Ni, Ni, Ni, No, No, No, No, Nu, Nu, Nui, Ny, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, Oei, Ol, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pe, Pe, Pe, Pe, Pe, Pe, Pe, Pea, Pea, Pha, Pha, Phi, Phi, Pi, Pi, Pi, Pi, Pi, Pi, Pi, Po, Po, Po, Po, Pra, Pre, Pre, Pri, Pri, Pro, Pro, Pu, Pu, Pu, Que, Que, Quee, Ra, Ra, Ra, Ra, Ra, Re, Re, Re, Re, Re, Re, Reu, Ri, Ri, Ri, Ri, Ri, Ri, Ro, Ro, Roy, Ru, Ru, Ru, Ru, Ru, Ru, Ru, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sai, Sau, Sca, Schno, Sci, Sco, Se, Se, Se, Se, Se, Se, Se, Sea, Sea, Sea, Sea, Sha, Sha, Sha, She, She, Si, Si, Si, Si, Si, Ske, Ski, Ski, Slei, Smo, Smo, Smo, Smu, Sna, Sni, Sno, Sno, Sno, Snu, So, So, So, So, Spa, Spe, Spi, Spi, Spo, Spri, Squea, Sta, Sta, Ste, Stee, Sti, Sto, Sto, Stre, Strei, Stri, Stro, Stu, Stu, Su, Su, Su, Su, Su, Su, Su, Su, Su, Swa, Sy, Sy, Sy, Sy, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Tao, Te, Te, Te, Te, Te, The, Thi, Tho, Thu, Thu, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, To, To, To, To, To, To, To, To, Tra, Tra, Tra, Tre, Tri, Tri, Tri, Troi, Tsai, Tsu, Tu, Tu, Tu, Tu, Tu, Tu, Twi, U, U, U, U, Va, Va, Vai, Ve, Vee, Vei, Vi, Vo, Wa, Wa, Wa, Wa, Wa, Whi, Whi, Whi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wo, Wri, Xa, Xaa, Xiao, Ya, Yea, Yi, Za, Za, Za, Za, Ze, Ze, Ze, Ze, Ze, Ze, Zeu, Zi, Zi, Zi, Zi, Zi, Zo, Zo, Zu, Zuy", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        pet_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "pet syllable pool", "_Boo, _Jo, _Ma, _Po, -Fi, -Miu, a, a, a, a, a, a, a, a, a, a, a, a, ao, ar, b, ba, ba, ba, bae, bbie, bby, bby, bby, bby, be, be, be, be, be, bee, bi, bi, bi, bi, ble, bo, bo, bo, bo, bou, bso, bu, bu, bui, by, ca, ca, ca, ca, cca, cce, cchi, cci, cco, cco, ce, ce, ce, cey, cha, che, che, chi, ci, cie, cie, cke, cke, ckee, cki, ckie, ckie, ckle, ckle, ckle, ckle, ckpa, cksie, ckstea, ckwe, cky, cky, cky, cky, cli, co, co, co, co, coa, cta, cto, cu, cu, cy, d_Ne, da, da, da, da, da, dda, dda, ddha, ddi, ddie, ddle, ddle, ddy, ddy, ddy, ddy, ddy, de, de, de, dge, dge, di, di, di, di, di, di, di, di, di, die, die, dle, dle, dle, dni, do, do, do, do, do, dsto, dy, dy, e, e, e, e, e, e, fa, faa, ffa, ffi, ffi, ffi, ffle, ffry, ffy, fi, fley, fo, fra, fri, fto, fy, ga, ga, ga, ga, ga, ga, ga, ga, ge, ge, ge, ge, ge, gga, gge, gge, ggi, ggie, ggy, ggy, ghya, gle, gnsto, go, go, gou, gre, gro, gu, ha, hei, hn_Ra, hnsto, ho, hou, hu, hu, i, i, i, i, ja, ja, jay, ji, jo, k, k\u00f3, ka, ka, ka, ka, ka, ke, ke, kee, key, key, kgu, ki, kie, kly, ko, ko, ko, ko, ko, ko, ky, ky, la, la, la, la, la, la, la, la, la, lba, lbe, lbo, lchi, lco, lcy, lda, lde, ldie, ldsmi, le, le, le, le, le, le, le, le, le, le, lee, lei, lei, leja, leto, ley, ley, lga, lgoo, li, li, li, li, li, li, li, li, li, li, li, li, lie, lja, lja, lka, lka, lky, lla, lla, lla, lla, lle, lle, lle, lle, lli, llie, llie, llie, llie, llie, llie, llie, llo, llo, llo, llseye, lly, lly, lly, lly, lly, lly, lly, lly, lly, lly, lme, lme, lo, lo, lo, lo, lo, lo, lo, lro, lsey, lso, lso, lso, ltay, lti, lti, lto, lto, lty, lu, lu, lve, lve, lvi, lwoo, ly, ly, ly, ly, ly, ly, lza, ma, ma, ma, ma, ma, ma, ma, mao, mb, mba, mbi, mble, mbo, mbo, mbo, mbo, mboo, mbra, mbrai, me, me, me, me, me, mi, mi, mi, mi, mi, mme, mmis, mmy, mmy, mo, mo, mo, mo, mo, mo, mo, mo, mpa, mpe, mphre, mpi, mpsey, mpso, mrei, mse, mu, my, n_Go, n_Ne, n_Ti, n_Ti, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, na, nba, nbrea, nbri, nca, nce, nce, nce, nce, nche, nchu, nci, nci, nci, ncse, ncy, ncy, nd_O, nda, nda, nda, nday, nde, nde, nde, nde, nde, ndi, ndi, ndie, ndo, ndo, ndra, ndu, ndy, ndy, ne, ne, ne, ne, ne, ne, nehi, nes, neso, ngbo, ngca, nge, ngey, ngfe, nggla, nghea, ngo, ngo, ngo, ngto, ngto, ngto, ngto, ngu, ngwa, nha, ni, ni, ni, ni, ni, ni, nie, nja, njee, njo, nka, nka, nka, nke, nke, nke, nkle, nko, nky, nli, nna, nna, nne, nnie, nnie, nnie, nny, nny, no, no, no, no, noo, nri, nri, nsa, nsbo, nse, nse, nsea, nsky, nslo, nso, nso, nsta, nsway, nte, nti, nti, nti, nu, nva, ny, ny, ny, nya, nya, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, pa, pa, pco, pe, pe, pe, pha, pi, pi, pi, pni, ppe, ppe, ppee, ppi, ppo, ppo, ppy, ppy, ppy, ppy, ppy, ppy, ppy, pu, pwri, quoi, r-Pie, ra, ra, ra, ra, ra, ra, ra, rao, rba, rba, rbe, rbe, rbi, rbi, rbi, rbo, rca, rche, rchi, rchie, rcu, rda, rda, rdi, rdo, re, re, re, re, re, re, re, rebi, rfe, rfie, rfo, rga, rga, rghe, rhou, ri, ri, ri, ri, ri, ri, ri, ri, rie, rjo, rka, rkle, rky, rky, rla, rle, rley, rley, rley, rli, rlie, rlie, rlo, rme, rmi, rmi, rmi, rmie, rmo, rmo, rna, rnbo, rney, ro, ro, ro, ro, ro, ro, ro, ro, ro, ro, ro, ro, rou, rou, rphe, rphy, rri, rri, rri, rri, rrie, rro, rry, rry, rry, rry, rsi, rsto, rte, rte, rtha, rto, rty, ru, ru, ru, ru, ru, rva, ry, ry, ry, ry, ry, rzey, rzi, sa, sa, sa, sa, sa, sau, sca, sca, sca, schi, scui, se, se, sha, sha, sha, shi, shka, shley, shne, shroo, si, si, sie, sio, ski, sley, sley, sli, smo, so, so, so, so, spe, spe, spe, spe, spe, sru, ssa, ssau, sse, ssey, ssi, ssi, ssi, ssie, ssie, st, sta, sta, ste, ste, ste, ste, ste, sti, sti, sti, stle, sty, sty, sty, stya, su, swa, sy, syu, szta, t\u00e1, ta, ta, ta, ta, ta, ta, ta, ta, ta, ta, tba, te, te, te, te, te, tha, thi, thle, thy, ti, ti, ti, ti, ti, tio, tio, tku, tle, tma, to, to, tra, tro, tro, tro, tsu, tswai, tsy, tta, tta, tte, tte, tte, tte, tti, ttle, ttle, ttle, ttle, tto, tty, tty, tty, tu, tu, ty, ty, tze, tzkrie, u, va, va, va, ve, ve, ve, ve, ve, ve, vei, vi, vi, vi, vi, vi, vi, vi, vie, vlo, vo, vre, way, wba, wba, wbray, wey, wi, wi, wie, wkeye, wma, wney, wny, wse, wti, wto, wy, xa, xe, xe, xi, xie, xie, xie, xte, y, ya, ya, yu, za, ze, ze, zi, zi, zley, zno, zza", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        pet_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "pet syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, b, b, b, bbs, bs, c, ce, ce, ch, che, ck, ck, ck, ck, ck, ck, ck, ck, ck, cks, cks, ct, ct, d, d, d, d, d, d, d, d, d, d, d, d, de, dge, dge, f, ff, ff, ff, g, g, g, ge, ge, ge, ggs, gh, gh, gh, ght, gs, h, h, h, h, h, h, h, hm, k, k, k, k, k, k, k, k, k, k, ke, ke, ke, ke, ke, kes, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, ld, le, le, lf, lk, ll, ll, ll, ll, ll, ll, lle, lle, lle, lle, lles, lp, lt, lt, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, me, me, me, mp, mp, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, nce, nce, nce, nce, nd, nd, nd, ne, ne, ne, ne, ne, ne, ne, nes, ng, ng, ng, ng, ng, ng, ng, ngs, nk, nk, nk, nk, nk, nn, nne, nne, ns, ns, ns, ns, ns, nx, p, p, p, p, p, p, p, ps, pse, qui, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, rbes, rce, rd, rd, rd, rd, rd, re, re, re, rge, rge, rk, rl, rm, rmed, rn, rp, rs, rs, rt, rt, rt, rt, rt, rt, rt, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, se, se, se, se, se, se, se, sh, sh, sh, sh, sk, sp, ss, ss, ss, ss, ss, ss, ss, ss, sse, st, t, t, t, t, t, t, t, t, t, t, t, t, t, t, t, t, t, t, t, t, tch, te, te, te, te, te, te, tes, th, th, th, th, th, ts, tt, tt, tte, tte, tte, tz, v, v, w, w, w, w, w, w, w, w, we, wn, wn, wn, x, x, x, x, x, x, x, x, x, x, y, y, y, z, ze", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        pet_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "pet syllable pool", "Bean, Blue, Boy, Butler, II, II, II, Jr., Pan, Puff, Ray, Ray, Rouge, the Great, Two, Wee", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("pet syllable pool", "Syllable Count Weighting", NamePiecesEntities.PET_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("pet syllable pool", "Terminal Blank Counts", NamePiecesEntities.PET_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "pet syllable pool", pet_root_initial.length - 1 <= 0 ? 0.0f : ((float)pet_prefix.length - 1.0f) / (float)(pet_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "pet syllable pool", pet_root_initial.length - 1 <= 0 ? 0.0f : ((float)pet_suffix.length - 1.0f) / (float)(pet_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

