/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class MonumentConfigHandler {
    public static ConfigurationVN config;
    public static String[] monument_prefix;
    public static String[] monument_root_initial;
    public static String[] monument_root_syllables;
    public static String[] monument_root_terminal;
    public static String[] monument_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            MonumentConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        monument_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "monument syllable pool", "Dread, Lost, Odd, Sunken", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        monument_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "monument syllable pool", "A, A, A, A, A, A, A, A, Aa, Bai, Bi, Bou, Bu, Ca, Ca, Ca, Ca, Can, Co, Cu, Di, Dwa, Ei, Ga, Ge, Ge, Ha, He, He, He, He, Kha, Ki, L, Le, Lo, Lu, Ly, Ma, Ma, Mu, Mu, Na, Na, Ne, Ne, O, O, O, Pa, Pha, Phe, Po, Pu, Quia, R, Ra, Ra, Ra, Rha, Ru, Sa, Sa, Sa, Sae, Shi, Su, Ta, Ta, Tho, Ti, Tu, Y, Ya, Yo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        monument_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "monument syllable pool", "'lye, a, ae, ba, be, che, co, de, du, du, fti, ga, gi, ha, hu, ia, ka, ke, la, lae, le, le, li, li, li, li, lo, ly, mba, mbha, mbu, me, mi, mpto, mu, na, na, na, ncho, ndao, ngho, ni, no, nti, ntre, o, o, po, ra, ra, ra, ra, rde, rga, rka, ro, ro, ro, rpi, rt_Ro, rte, ru, te, ti, ti, ti, tla, tli, ve, ve, vlo, _Pe, _Ro, ', a, ba, ca, cle, clei, fa, fa, go, gu, ke, ki, l_Ba, le, lee, na, ne, nghe, ni, ni, nje, nse, nspu, ntho, nti, o, pe, pu, r_U, rho, ri, rju, rxna, s_He, sso, t_Si, ta, ti, tu, u, u, u, xa, ya, yo, a, a, a, ca, ca, che, do, ha, i, li, li, lu, na, ndri, ni, ni, ni, nu, nu, o, o, r_Gwae, ra, ri, s_A, sta, tri, wa, wi, a, a, a, a, ko, lo, nca, ndre, no, o, o, pu, wa, a, nda, ra, tu", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        monument_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "monument syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, c, d, d, g, h, h, j, k, l, l, l, lt, m, m, m, n, n, n, n, n, n, n, ng, ng, r, r, rn, s, s, s, s, s, s, s, s, s, s, s, s, sse, t, t, t, zh", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        monument_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "monument syllable pool", "Heart, Mausoleum, Point, Tomb, Tongue", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("monument syllable pool", "Syllable Count Weighting", NamePieces.MONUMENT_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("monument syllable pool", "Terminal Blank Counts", NamePieces.MONUMENT_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "monument syllable pool", monument_root_initial.length - 1 <= 0 ? 0.0f : ((float)monument_prefix.length - 1.0f) / (float)(monument_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "monument syllable pool", monument_root_initial.length - 1 <= 0 ? 0.0f : ((float)monument_suffix.length - 1.0f) / (float)(monument_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

