/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class MineshaftConfigHandler {
    public static ConfigurationVN config;
    public static String[] mineshaft_prefix;
    public static String[] mineshaft_root_initial;
    public static String[] mineshaft_root_syllables;
    public static String[] mineshaft_root_terminal;
    public static String[] mineshaft_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            MineshaftConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        mineshaft_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "mineshaft syllable pool", "Big, Big, Black, Blue, East, East, El, El, El, El, Golden, Golden, Great, Green, High, Lake, Las, Little, Long, Low, Lower, Monte, Mount, Mount, Mount, New, New, New, New, North, North, Old, Parc, Qaf, Qaf, Red, Roter, San, San, Six, South, South, St., St., Upper, West, West, white", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        mineshaft_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "mineshaft syllable pool", "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Age, Ape, Ay, B\u00e4, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Bau, Be, Be, Be, Be, Be, Be, Bea, Bea, Bi, Bi, Bi, Bi, Bi, Bla, Blue, Bo, Bo, Boo, Bou, Boy, Bra, Bre, Bri, Bri, Bro, Bro, Bro, Broo, Brou, Bru, Bru, Bru, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bw, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Cau, Ce, Ce, Ch\u00f9i, Cha, Cha, Cha, Cha, Che, Chi, Chi, Ci, Cli, Cli, Cli, Cli, Cli, Cli, Clo, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Coo, Cra, Crei, Cri, Cro, Cy, Da, Da, Da, Da, Da, Da, De, Di, Di, Do, Do, Do, Do, Dru, Dvoi, E, E, E, E, E, E, Fa, Fa, Fe, Fe, Fe, Fi, Fi, Fle, Flee, Fo, Fo, Fra, Fro, Froo, Ga, Ga, Ga, Ge, Ge, Geo, Gi, Gi, Gi, Gi, Gi, Gla, Glei, Go, Goo, Gra, Gre, Gree, Gree, Gu, Gui, Gwa, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Hay, He, He, He, He, He, Hi, Hi, Hi, Hi, Hi, Hi, Hi, Ho, Ho, Ho, Ho, Hu, Hu, I, I, I, I, I, I, Ja, Jo, Jo, Ju, Jua, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ke, Ke, Ke, Ke, Kee, Kho, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Kii, Klo, Ko, Ko, Ko, Kra, Kre, Ku, Ku, L\u00f8, La, La, La, La, La, La, Le, Le, Li, Li, Li, Lo, Lo, Lu, Lu, Lu, Ly, M\u00e9, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, May, Me, Mi, Mi, Mi, Mi, Mi, Mo, Mo, Mo, Mo, Mo, Mo, Mu, Mu, Mu, Na, Na, Na, Na, Na, Ne, Ne, Neui, No, No, No, No, Noo, Nu, O, O, O, O, O, O, Oa, Oa, Ou, P, P\u00eb, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pau, Pe, Pe, Pe, Pe, Pe, Phoe, Pi, Pi, Plea, Plu, Pre, Pri, Prie, Pro, Pro, Pu, Py, Qui, Qui, Ra, Ra, Ra, Ra, Ra, Ray, Re, Re, Ri, Ri, Ro, Rou, Ru, Sa, Sa, Sa, Schuy, Se, Se, Se, Sea, Sha, Sha, Shi, Shu, Si, Si, Sli, Smi, Smu, Sna, Snae, So, Sou, Spa, Spri, Sta, Sta, Sta, Stave, Ste, Stee, Stee, Sti, Stra, Stro, Stu, Su, Su, Su, Su, Su, Su, Ta, Ta, Ta, Ta, Ta, Tau, Te, Te, Tha, The, Tho, Thu, Ti, Ti, To, To, Trea, Tu, Tu, Tu, Ty, Ty, U, U, Va, Vi, Vla, Wa, Wa, Wa, Wa, Wa, We, We, We, Whi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wie, Wo, Wri, Wu, Wy, Ye, Yo, You, Yu, Za, Zi, Zo, Zo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        mineshaft_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "mineshaft syllable pool", "_To, a, a, a, a, a, a, bbi, bbi, be, be, be, be, be, bfie, bi, bi, bi, bu, bu, chi, chni, ckbi, cke, cki, ckie, ckle, cko, cno, co, cro, cto, da, da, da, da, da, da, ddi, dfo, dfo, dgee, dgewa, dgeway, di, di, dley, dswo, du, dve, dwa, dwe, dy, e, f, fe, ffeau, ffie, fie, fl\u00f3, fto, fto, ga, ga, ga, ga, ggi, ggle, ghto, ghto, gla, gne, gu, h\u00e4, ha, hna, hnso, i, i, i, je, ka, kda, ke, ke, ke, khou, kie, kke, kna, ku, ky, la, la, la, la, la, laa, lau, lbe, lbi, lby, lde, ldesley, ldo, ldwa, le, leswoo, ley, ley, lfe, lga, lgie, lgoo, lhou, li, li, li, li, li, llcre, llcro, lle, llei, llfa, llgro, lli, lli, lli, lli, lli, llia, llie, llve, lma, lma, lmai, lmoy, lmy, lnhu, lo, lp\u00fa, lphi, lqi, lroo, lse, lse, lstho, ltby, lto, lto, lu, lu, lu, lva, lve, ly, lya, ma, ma, me, me, mesta, mesta, mfu, mi, mie, mla, mme, mme, mmi, mmo, mni, mro, mta, na, na, na, nco, ncy, ncy, nda, nde, ndee, ndho, ndle, ndle, ndo, ndre, ndri, ndso, ndso, ndso, ndwoo, ne, ne, nesi, nesu, nga, nghi, ngma, ngsbe, ngsbu, nhei, ni, ni, ni, ni, ni, ni, ni, ni, nkgru, nkli, nla, nlei, nlou, nme, nna, nne, nne, nne, nni, nno, nny, nny, no, nri, nro, nse, nshi, nsi, nsley, nsley, nso, nswi, nswi, nte, nte, ntga, nto, ntre, ntwoo, nty, nty, nve, nwoo, nye, nzewi, o, pi, po, ppe, ppe, ppe, psto, pu, pu, ra, ra, ra, ra, ra, rba, rchtree, rcro, rcu, rdi, rdy, re, re, reoa, rga, rgo, rgo, rgrea, rgrea, rgy, ri, ri, ri, rkfie, rkha, rkshi, rley, rli, rli, rlo, rma, rmi, rmi, rna, rnbu, rnda, rni, ro, ro, ro, ro, rra, rra, rray, rre, rro, rro, rroi, rsema, rsha, rsley, rsley, rso, rso, rte, rthla, rthu, rthu, rto, rto, ru, rve, rwa, rwi, rwo, s\u00e9, sa, sa, sbe, sca, sco, se, sfo, she, shee, sio, ska, sley, sley, sma, sma, so, so, sshi, sta, ste, ste, stley, sto, sto, stray, sty, sya, ta, ta, tche, tche, tche, te, tfie, tha, the, thlee, tla, tley, to, tra, tte, tti, ttle, ttle, ttle, tto, tto, tto, twoo, ve, ve, ve, wa, we, we, wla, wle, wso, xey, yo, yu, ze, zu, _Ba, _Bu, _To, \u00f1o, a, a, a, a, ba, ba, ba, bou, bu, ca, ca, ca, chae, chee, co, co, czka, de, dee, dko, do, do, dre, dy, e, fo, i, ke, ku, ku, l\u00e4, la, le, ley, li, lla, lla, llta, lsbe, lu, lu, lu, ma, ma, mi, mpi, mpto, mu, n_Co, n-Uu, na, na, na, na, na, na, na, nau, nba, nda, ndwa, nga, nge, ngley, ngto, ngto, ngto, nhu, ni, ni, nke, nmi, nne, nni, no, no, nsvi, ntry, ntu, nwoo, o, pi, qua, r, ra, ra, ra, rca, rcy, rdie, re, rei, rfie, ri, ri, ri, rley, rley, rlie, rmi, rna, rni, ro, rpe, rse, rsha, rso, rwoo, ry, ry, sa, sa, sby, se, sha, shi, sho, so, so, so, sque, sto, ta, te, te, ti, tia, to, to, to, to, tvi, va, va, ve, ve, vni, wa, wa, wa, wa, ye, z\u00eb, a, a, a, ca, ca, che, da, do, do, e, ga, hu, i, ka, ka, le, lgoi, lmi, lu, na, nda, ndi, no, nte, ntei, ntha, ra, rgw, rra, rry, rry, rsa, ry, ry, ry, shi, shi, si, ska, stine, t\u00fa, ta, ta, thi, tio, tr\u00eb, vaa, w, e, nska, ra, ra, te, thu, ya", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        mineshaft_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "mineshaft syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, c, c, c, c, ce, ch, ch, ck, ck, ck, ck, ck, d, d, d, d, d, d, d, d, d, d, d, de, de, dge, ff, ffs, ft, ft, ft, g, g's, ge, gh, ght, h, h, j, j, k, k, k, ke, ke, ke, ks, l, l, l, l, l, l, l, l, l, ld, ld, ld, ld, lds, le, le, le, le, le, le, le, le, lk, ll, ll, ll, ll, ll, ll, ll, ll, ll, ll, lle, lle, lls, lls, lm, lm, ls, m, m, m, m, m, m, m, m, mbe, me, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, nce, nd, nd, nd, nd, nds, ne, ne, ne, ne, ng, ng, ng, ng, ng, nks, nn, ns, ns, ns, nsch, nt, nt, nt, p, p, p, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, rce, rd, rd, rd, rd, rd, rd, re, re, re, re, rg, rg, rg, rg, rge, rgh, rke, rke, rn, rn, rpe, rr, rs, rs, rs, rshe, rst, rst, rt, rth, rth, s, s, s, s, s, s, s, s, s, s, s, s, se, se, se, sh, sh, ss, st, st, t, t, t, t, t, t, t, t, t, th, th, tt, vd, ve, ve, ves, ves, w, w, w, w, w, w, we, wk, ws, x, x, z", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        mineshaft_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "mineshaft syllable pool", "Bell, Bridge, Canyon, Cave, Cliff, Cliff, Corner, Crag, Creek, Creek, Creek, Creek, Dam, Dam, Dam, del Diablo, des Iles, Down, Down, Earth, Eye, Falls, Grande, Green, Grove, Hall, Hill, Hill, Hill, Hill, Hills, Jungle, Lake, Lake, Lake, Lake, Lake, Leg, Loch, Main, Main, Main, Main, Main, Main, Main, Mascot, Mia, Mill, Mill, Moss, Mountain, Park, Park, Park, Pit, Point, Point, Queen, River, River, River, Shaft, Shore, Tree, Tunnel, Velho", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("mineshaft syllable pool", "Syllable Count Weighting", NamePieces.MINESHAFT_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("mineshaft syllable pool", "Terminal Blank Counts", NamePieces.MINESHAFT_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "mineshaft syllable pool", mineshaft_root_initial.length - 1 <= 0 ? 0.0f : ((float)mineshaft_prefix.length - 1.0f) / (float)(mineshaft_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "mineshaft syllable pool", mineshaft_root_initial.length - 1 <= 0 ? 0.0f : ((float)mineshaft_suffix.length - 1.0f) / (float)(mineshaft_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

