/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class MansionConfigHandler {
    public static ConfigurationVN config;
    public static String[] mansion_prefix;
    public static String[] mansion_root_initial;
    public static String[] mansion_root_syllables;
    public static String[] mansion_root_terminal;
    public static String[] mansion_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            MansionConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        mansion_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "mansion syllable pool", "Flower of, Golden, Grey, Life of, North, Silver, The, The, The, The, The, The, The, The, The, The, The, White", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        mansion_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "mansion syllable pool", "'I, A, A, A, A, A, A, A, Be, Be, Be, Be, Bi, Blai, Bo, Brae, Bray, Brea, Ca, Ca, Ca, Cha, Co, Co, Coe, Da, Da, Du, Du, E, E, E, Fai, Fi, Fleu, Flo, Fri, Ga, Ge, Gle, Grey, Ha, Ha, Hay, He, Hea, Hi, Ho, Ho, Hu, Hy, Hy, I, I, I, Ka, Ky, Ly, Ly, Ma, Ma, McCu, Mea, Mi, Mi, Mo, Ne, O, O, O, O, Pa, Pa, Pa, Pa, Pa, Pay, Pe, Pe, Po, Pre, R\u00ea, Ra, Re, Rei, Ri, Ro, Ry, Se, Se, Sea, Sea, Sha, Sha, She, Shi, Ti, To, To, Twi, U, Ve, Vi, Wa, Wa, Whi, Whi, Wi, Wi, Wi, Woo, Xa, Ya, Zi", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        mansion_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "mansion syllable pool", "bble, ce, chre, ddo, dle, dlea, do, do, do, he, ke, kui, la, lai, lai, lbu, lde, li, lla, lli, lme, lmo, lo, lsto, lsto, ltmo, lv\u00e9, mba, mbro, mi, mou, mpstea, na, ncai, nde, ndi, ngdi, nge, ngwoo, ni, nna, nnewoo, nra, nsmo, nta, nte, nti, nwoo, o, pewe, pla, r-a, ra, rbo, rbo, rbu, rde, rdro, re, rfie, rha, rla, rli, rne, rne, ro, rsai, rsde, schma, she, stle, sto, sto, teha, tema, tto, ve, ve, ve, vie, vo, we, we, wnse, wse, _Hou, -La, a, d\u00e8, du, ge, ghe, gie, ka, la, la, li, li, lo, mea, na, ngto, ngto, ni, ni, o, ri, rie, rsi, rsky, rso, rthu, rto, rwoo, sfa, so, ssa, tto, w_Broo, ble, da, go, n_Ne, ni, o, ty, sa", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        mansion_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "mansion syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ck, ck, d, d, d, d, d, d, de, de, es, ff, ght, hn, k, ke, ke, l, l, l, ld, ldt, les, ll, ll, ll, lle, lles, lls, lm, m, m, n, n, n, n, n, n, n, n, n, nd, nd, nds, ne, ne, ne, ng, nt, r, r, r, r, r, r, r, r, r, re, re, re, rg, rls, rne, rs, rs, rs, rs, rsh, rst, s, s, s, s, s, se, se, t, t, ve, w, w, w, we, wn, z", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        mansion_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "mansion syllable pool", "Air, Brook, Castle, Castle, Castle, Castle, Castle, Ch\u00e2teau, Champ, Chateau, Court, Court, Creek, Farms, Ferry, Grove, Hacienda, Hall, Hall, Hall, Hall, Hall, Hall, Hall, Hall, Hill, Hill, Hill, Hill, Hill, House, House, House, House, House, House, House, House, House, House, House, House, House, House, House, Lawn, Lodge, Lodge, Manor, Manor, Manor, Manor, Mansion, Mansion, Mansion, Mansion, Mansion, Mansion, Mansion, Mansion, Mansion, Mansion, Mansion, Mansion, Meadows, Oaks, Palace, Park, Pond, Ranch, Ridge, Royal, Terrace, Terrace, Villa, Villa, Way", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("mansion syllable pool", "Syllable Count Weighting", NamePieces.MANSION_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("mansion syllable pool", "Terminal Blank Counts", NamePieces.MANSION_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "mansion syllable pool", mansion_root_initial.length - 1 <= 0 ? 0.0f : ((float)mansion_prefix.length - 1.0f) / (float)(mansion_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "mansion syllable pool", mansion_root_initial.length - 1 <= 0 ? 0.0f : ((float)mansion_suffix.length - 1.0f) / (float)(mansion_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

