/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;

public class GoblinConfigHandler {
    public static ConfigurationVN config;
    public static String[] goblin_prefix;
    public static String[] goblin_root_initial;
    public static String[] goblin_root_syllables;
    public static String[] goblin_root_terminal;
    public static String[] goblin_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            GoblinConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        goblin_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "goblin syllable pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        goblin_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "goblin syllable pool", "A, A, A, A, A, A, A, A, A, A, A, A, B, Ba, Ba, Bau, Be, Bei, Bla, Ble, Bo, Bo, Bri, Bri, Bro, Bu, Bu, Bu, Ca, Ca, Cae, Ce, Ci, Cl\u00edo, Clu, Cy, Cy, D\u00f6, Da, Da, Di, Do, Do, Do, Drau, Dry, Du, Dwa, E, E, E, E, E, E, E, Fae, Fai, Fau, Fi, Fi, Frey, Frey, Ga, Ga, Ghou, Gi, Glo, Gno, Go, Go, Go, Gre, Gre, Gwi, Gwy, Gwy, Ha, Ha, Ha, He, Hi, Hi, Ho, Ho, Hu, Hu, I, In, Ja, Je, Ji, Jo, Jo, Ka, Ka, Ka, Ke, Ki, Ki, Kla, Kno, Ko, Ko, La, La, Le, Li, Li, Lj\u00f3, Lu, Lu, Ma, Ma, Ma, Ma, Ma, Ma, Me, Mi, Mo, Mo, Mo, Moo, Moo, Na, Na, Nai, Ne, Ne, Ni, Ni, Nu, Nu, Ny, O, O, O, O, Pa, Pi, Po, Po, Poo, Pu, Pu, Ra, Re, Ro, Ru, Sa, Sa, Sa, Sa, Se, See, She, Si, Si, Smy, So, Sphi, Spri, Spri, Su, Sva, Sy, Te, Te, Tho, Ti, Ti, Ti, To, Tra, Tri, Tro, Tro, Tsu, U, U, V\u00e6, Va, Vi, Wa, Wa, We, Xa, Y, Ya, Ya, Ya, Ye, Yu, Zo, Zo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        goblin_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "goblin syllable pool", "^, a, a, ba, ba, ba, ba, bau, bbi, be, bgo, bli, bo, bou, bu, ca, ca, cca, ccu, cha, ci, cke, clo, cne, cu, cu, d, dca, dhe, dhna, dle, fa, ga, ga, ga, gbea, gda, gga, gga, gi, gle, go, go, gre, gua, ja, kba, ke, kha, ki, kk\u00e1, kkae, ko, ku, la, la, la, lbe, lca, lco, ldra, le, lge, li, li, lie, lkie, lky, lla, lli, lli, lly, lphoe, lta, lte, lti, ma, ma, mba, mbe, mbie, me, mi, mi, mli, mmi, mmy, mo, mpu, mte, na, na, na, na, na, nca, nde, ndi, ndi, ne, ne, ngku, ngu, ngu, ngvi, ni, nney, nni, nni, nni, no, no, no, no, ntau, nti, nva, nyi, o, ppa, pre, ra, ra, re, re, re, re, re, rgo, rgo, ri, ri, ri, rka, rli, ro, rpy, rri, rri, rry, ru, ry, s\u00e1, sa, si, ste, sto, sto, swa, ta, thy, to, to, tsu, tti, tu, ty, u, u, wa, wca, wnie, xie, ya, ze, -o, -u, a, a, a, ba, be, bi, bi, bli, bo, bu, bu, ce, chau, chau, cie, co, co, da, e, ga, ga, go, go, gu, ha, hu, i, ja, ka, ku, ku, la, lfa, lfa, lfa, lka, ma, mo, na, na, ne, ne, ngway, ngway, ni, nn\u00e1, nta, nye, pa, pe, po, pu, ra, rgei, ri, ri, ri, rie, ro, ro, ro, ro, rra, ru, sa, ta, tau, te, te, to, tsu, twa, vi, voi, a, ba, bi, do, ku, la, llo, me, mo, mo, na, na, nchei, nde, ne, ngga, nna, ntza, pha, ra, rma, tia, to, u, bi, ly, re, ro", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        goblin_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "goblin syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, b, b, ch, ch, ck, ck, d, d, d, d, d, g, g, g, k, k, l, l, l, l, ld, lf, ll, lph, ltz, m, me, mp, mph, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, ne, ng, ng, nn, nn, nn, ns, nt, nx, p, p, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, rc, rd, re, rf, rn, rn, rt, s, s, s, s, s, s, s, s, s, s, s, s, st, st, t, t, t, te, th, th, tt, tts, w, wn, x, yle", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        goblin_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "goblin syllable pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("goblin syllable pool", "Syllable Count Weighting", NamePiecesEntities.GOBLIN_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("goblin syllable pool", "Terminal Blank Counts", NamePiecesEntities.GOBLIN_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "goblin syllable pool", goblin_root_initial.length - 1 <= 0 ? 0.0f : ((float)goblin_prefix.length - 1.0f) / (float)(goblin_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "goblin syllable pool", goblin_root_initial.length - 1 <= 0 ? 0.0f : ((float)goblin_suffix.length - 1.0f) / (float)(goblin_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

