/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class EndCityConfigHandler {
    public static ConfigurationVN config;
    public static String[] endcity_prefix;
    public static String[] endcity_root_initial;
    public static String[] endcity_root_syllables;
    public static String[] endcity_root_terminal;
    public static String[] endcity_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            EndCityConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        endcity_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "end city syllable pool", "End, Mag, T\u00edr", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        endcity_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "end city syllable pool", "A, A, A, A, Ba, Brah, Ca, Ca, Ce, Ce, Cha, Di, Dy, E, E, E, E, E, Eu, Eu, Ga, Gai, Hau, Hea, Hla, I, I, I, I, I, Ju, Ka, Ko, Lu, Ma, Ma, Ma, Me, Me, Mi, Mi, Moo, N\u00f3, Ne, Ni, O, Pa, Plu, Pu, Rhe, Sa, Sa, Se, Su, Te, Te, Ti, Tla, Tri, U, U, U, U, Va, Ve, Yh, Yo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        endcity_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "end city syllable pool", "a, a, a, be, bi, cha, da, de, ke, la, la, la, le, le, lha, lli, lo, lo, ltha, lti, ly, ly, ma, ma, mbri, me, mi, mme, na, nce, nde, nga, ni, nnw, nu, ny, o, o, pi, ptu, ra, ra, rco, rcu, re, re, rga, ri, ri, rna, ro, ro, rra, rza, sga, ta, thy, ti, to, to, tu, ve, a, ca, e, e, ka, la, lla, ma, me, me, mo, nda, ne, ne, ni, no, no, nu, pa, pe, pha, pu, rla, rne, ro, ru, ry, sa, si, sto, te, th-Lee, to, tro, \u00ef, a, cia, du, ke, ni, ra, ry, tu, u, u", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        endcity_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "end city syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, b, b, de, g, k, k, kh, l, l, ll, ll, m, m, n, n, n, n, n, n, n, n, n, n, n, nd, ne, r, r, r, rd, rn, rs, s, s, s, s, s, s, s, s, s, th, th, th", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        endcity_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "end city syllable pool", "City", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("end city syllable pool", "Syllable Count Weighting", NamePieces.END_CITY_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("end city syllable pool", "Terminal Blank Counts", NamePieces.END_CITY_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "end city syllable pool", endcity_root_initial.length - 1 <= 0 ? 0.0f : ((float)endcity_prefix.length - 1.0f) / (float)(endcity_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "end city syllable pool", endcity_root_initial.length - 1 <= 0 ? 0.0f : ((float)endcity_suffix.length - 1.0f) / (float)(endcity_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

