/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;

public class DragonConfigHandler {
    public static ConfigurationVN config;
    public static String[] dragon_prefix;
    public static String[] dragon_root_initial;
    public static String[] dragon_root_syllables;
    public static String[] dragon_root_terminal;
    public static String[] dragon_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            DragonConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        dragon_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "dragon syllable pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        dragon_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "dragon syllable pool", "A, A, A, A, A, A, A, A, Ai, B, Ba, Ba, Ba, Bo, Boi, Co, Co, Cu, Ddrai, Dr\u00e1, Dra, Dra, Dre, E, E, E, E, Fa, Go, Gui, Gyo, He, Hua, Hy, I, I, I, J\u00f6, Ku, Ku, Ku, L', L\u00f3, La, La, Le, Li, Lo, Mu, N\u00ed, Na, Nea, No, O, Ou, Pa, Py, Q', Qi, Que, Que, Ry, Ry, S\u00e1, Sei, Sli, Smo, Sy, Te, Te, The, Ti, Ti, Ty, Ve, Vi, Vri, Wy, Wy, Xiu, Ya, Yi, Yo, Za, Zbu, Zi, Zi, Zi, Zmei, Zo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        dragon_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "dragon syllable pool", "\u00e9, a, a, bi, bre, bzu, ca, co, dh\u00f6, do, do, dra, fni, ga, ga, go, go, ha, jda, jde, ju, kha, k, ko, ku, ku, ku, la, la, lau, lbe, ldra, lla, llu, lshe, ma, mo, moo, ndwor, nglo, nglo, nri, nu, pa, pe, pho, po, ra, ra, re, re, re, rgo, rk\u00e1, rmu, rne, rni, ro, ro, ry, ryu, sha, shu, ta, ta, tho, tra, tza, tza, u, u, u, ve, ve, vi, vre, vre, za, zhi, _Ce, _Da, _Ja, _We, a, a, bo, chi, chi, dra, g\u00e4, gg, gi, ha, ji, la, lc\u00f3, lco, le, lka, ma, ma, mu, na, na, nga, ngba, nky, nsky, nsu, ny, ny, o, phi, q', rfl\u00f3, rha, ru, ssu, t\u00e1, ta, to, tra, ya, ze, a, a, bre, do, gu, ha, la, le, nd, nka, ro, t, tha, tso, u, wa, a, ka, ma, rmu, t, t", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        dragon_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "dragon syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, c, ch, g, ge, k, k, k, l, l, l, l, l, m, m, n, n, n, n, n, n, n, n, n, n, n, n, n, ng, ng, ng, ng, nt, nt, p, p, q, r, r, r, r, r, r, r, rm, rn, s, s, s, s, sque, t, t, t, t, t, th, tz", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        dragon_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "dragon syllable pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("dragon syllable pool", "Syllable Count Weighting", NamePiecesEntities.DRAGON_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("dragon syllable pool", "Terminal Blank Counts", NamePiecesEntities.DRAGON_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "dragon syllable pool", dragon_root_initial.length - 1 <= 0 ? 0.0f : ((float)dragon_prefix.length - 1.0f) / (float)(dragon_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "dragon syllable pool", dragon_root_initial.length - 1 <= 0 ? 0.0f : ((float)dragon_suffix.length - 1.0f) / (float)(dragon_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

