/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;

public class DemonConfigHandler {
    public static ConfigurationVN config;
    public static String[] demon_prefix;
    public static String[] demon_root_initial;
    public static String[] demon_root_syllables;
    public static String[] demon_root_terminal;
    public static String[] demon_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            DemonConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        demon_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "demon syllable pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        demon_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "demon syllable pool", "\u00d6, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Aa, Ae, Ai, As, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Baa, Bae, Be, Be, Be, Be, Be, Be, Be, Bhu, Bi, Bi, Bo, Bo, Bu, Bu, Bu, Bue, By, Ca, Ca, Ca, Ca, Caa, Caa, Cai, Ce, Cha, Cha, Che, Cho, Cho, Ci, Ci, Cla, Co, Cro, Cu, D, Da, Da, Da, Da, Da, Da, Dao, De, De, De, De, Di, Dji, Dre, E, E, E, Ei, Ex, Fla, Flau, Fo, Fo, Fo, Fo, Fo, Fo, Fu, Fu, Ga, Ga, Ga, Gaa, Gau, Ghou, Gla, Gla, Go, Go, Gre, Gre, Gri, Gu, Gu, Gu, Gu, Gua, Gua, Ha, Ha, Ha, Ha, Haa, Hau, Hei, Hi, I, I, I, I, I, I, If, Ji, Ji, Ka, Ka, Ka, Ka, Ka, Ki, Ko, Kra, Kro, Ku, Ku, Le, Le, Le, Le, Le, Le, Le, Leo, Li, Li, Li, Li, Lju, Lu, Ly, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Me, Me, Me, Me, Me, Mo, Mo, Mu, Na, Na, Na, Naa, Ne, Ne, Ni, O, O, O, O, O, O, O, O, Pa, Pa, Pai, Pe, Pe, Phe, Pho, Pi, Po, Po, Pre, Pro, Pru, Pu, Ra, Ra, Ra, Rau, Ro, Ru, Ru, S, Sa, Sa, Sa, Sa, Sa, Sa, Sca, Se, Sei, Sha, Shai, She, Si, Si, So, Sti, Sto, Su, Su, Sua, Ta, Ta, Ti, Ti, To, Tri, Tu, Twi, U, Va, Va, Va, Va, Va, Ve, Vi, We, We, We, Ye, Za, Ze, Zi, Zu", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        demon_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "demon syllable pool", "_To, ba, ba, be, be, be, bha, bi, bi, bi, bli, bli, blo, bno, bo, bo, by, ca, ca, ccu, ce, ce, chie, chu, chu, ci, co, cri, cro, cu, de, dea, dee, di, dra, du, du, e, e, fla, fri, fri, fro, ga, ga, ga, ge, gi, gi, gio, gna, go, go, gra, ha, ha, he, he, hi, hri, jja, ka, ka, ka, ka, ka, ke, ki, ki, ko, ko, kshaa, ku, ku, kva, la, la, la, la, la, la, la, la, lbe, le, le, le, le, le, lgo, li, li, li, li, li, li, li, li, li, llo, llo, llu, lo, lo, lo, lpha, lpha, lphe, lpsa, lsu, lthu, lu, lve, ma, ma, ma, may, mbha, mdu, me, mei, mi, mi, mi, mmo, mo, mo, mo, mo, mo, mo, mo, mo, mo, mpo, mpu, mta, my, mya, na, na, nci, ncu, nde, ndha, ndi, ndi, ndra, ndre, ndro, ne, ne, ne, nga, nggi, ngra, ni, ni, ni, nja, nni, no, no, nshee, nta, nta, nti, nti, nu, nzu, o, pa, pa, pa, pe, pe, phi, pho, po, po, pu, qo, ra, ra, ra, ra, ra, ra, ra, ra, raii, rba, rba, rba, rbe, rca, rca, rchai, rcho, rcho, rcu, rd\u00f6, re, re, ree, rfu, rga, rgo, rgu, ri, ri, ri, ri, ri, ri, rli, rma, rmi, rmu, rne, ro, ro, ro, ro, rra, rso, rthi, ru, ru, ru, rva, sa, sa, sa, sa, sb, se, she, shma, shya, si, si, si, sma, smo, so, so, ssa, ssi, ssya, sta, ste, su, sya, ta, ta, ta, ta, ta, ta, the, thi, thi, thi, thy, ti, ti, to, to, tri, tsco, v-e, vi, vi, vre, vro, ya, yo, yo, za, za, zi, zo, zu, zu, _\u0130, _Da, _Ma, _Mai, _N, _Se, -La, 'e, a, a, a, a, a, a, a, a, ba, ba, bi, bu, bu, ca, ca, ce, ce, cha, chu, dai, ddo, de, do, dya, e, e, e, fa, fa, fi, ge, gi, gli, go, go, go, go, go, go, he, i, i, i, ie, je, je, ka, ka, ka, kku, la, la, lcha, li, li, lka, lly, lma, lo, lze, m_Ma, ma, ma, ma, ma, ma, me, mme, mme, mo, mo, mo, mo, mo, mue, na, nda, nda, ndha, ni, ni, ni, nno, no, nti, nzo, o, o, o, pha, pha, pho, r'e, ra, ra, re, re, ri, ri, ri, ri, ri, ri, ro, ro, rta, ru, ry, ry, ry, ry, sa, si, si, si, si, ske, sta, sto, sto, stro, su, ta, ta, ti, to, u, u, u, va, va, va, ve, vi, y, z'e, za, ze, ze, zou, zu, zzo, -La, a, a, a, a, a, be, bi, bo, bo, bu, ccia, e, ge, gi, ha, la, laa, le, le, li, li, llu, lphu, na, na, na, na, nki, nte, nyu, o, o, o, phe, phe, pi, ra, rgo, rna, rna, ste, su, ta, tha, thi, u, u, vi, ye, a, a, bo, bou, ka, la, la, le, ne, pe, ra, re, ri, ssu, u, li", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        demon_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "demon syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, b, b, c, c, c, ch, ch, ch, ch, ck, d, d, d, dh, f, g, g, h, h, h, h, k, k, k, k, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, ll, ll, m, m, m, m, m, m, m, m, m, m, m, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, ne, ne, ng, ng, nn, nn, nn, ns, nth, p, p, pt, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, rck, rd, rge, rt, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, sh, t, t, t, t, t, t, t, t, t, th, th, th, th, th, th, th, th, ts, x, x, x, x, x, x", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        demon_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "demon syllable pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("demon syllable pool", "Syllable Count Weighting", NamePiecesEntities.DEMON_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("demon syllable pool", "Terminal Blank Counts", NamePiecesEntities.DEMON_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "demon syllable pool", demon_root_initial.length - 1 <= 0 ? 0.0f : ((float)demon_prefix.length - 1.0f) / (float)(demon_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "demon syllable pool", demon_root_initial.length - 1 <= 0 ? 0.0f : ((float)demon_suffix.length - 1.0f) / (float)(demon_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

