/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class CustomConfigHandler {
    public static ConfigurationVN config;
    public static String[] custom_prefix;
    public static String[] custom_root_initial;
    public static String[] custom_root_syllables;
    public static String[] custom_root_terminal;
    public static String[] custom_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            CustomConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        custom_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "custom syllable pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        custom_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "custom syllable pool", "No", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        custom_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "custom syllable pool", "", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        custom_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "custom syllable pool", "tch", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        custom_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "custom syllable pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("custom syllable pool", "Syllable Count Weighting", NamePieces.CUSTOM_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("custom syllable pool", "Terminal Blank Counts", NamePieces.CUSTOM_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "custom syllable pool", custom_root_initial.length - 1 <= 0 ? 0.0f : ((float)custom_prefix.length - 1.0f) / (float)(custom_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "custom syllable pool", custom_root_initial.length - 1 <= 0 ? 0.0f : ((float)custom_suffix.length - 1.0f) / (float)(custom_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

