/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;

public class AngelConfigHandler {
    public static ConfigurationVN config;
    public static String[] angel_prefix;
    public static String[] angel_root_initial;
    public static String[] angel_root_syllables;
    public static String[] angel_root_terminal;
    public static String[] angel_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            AngelConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        angel_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "angel syllable pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        angel_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "angel syllable pool", "A, A, A, A, A, A, A, A, A, A, A, A, Ba, Ba, Ca, Ca, Che, Da, Da, Du, E, E, Fe, Fe, Ga, Ga, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, He, He, Ho, I, I, I, Je, Je, Je, Je, Je, Ji, Jo, Ka, Ka, Ke, Ke, Ke, Kha, Ki, Ku, La, Le, Lu, Ma, Maa, Me, Me, Mi, Mi, Mi, Mo, Mu, Mu, Mu, Na, Na, Ne, Ni, Nu, O, O, Pa, Pe, Pha, Po, Pra, Pu, Qa, Ra, Ra, Ra, Ra, Ra, Rai, Re, Ri, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sche, Se, Se, Sha, Sha, Shi, Si, Te, Te, Tu, U, U, Va, Ve, Wor, Za, Za, Za, Za, Ze, Ze, Zo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        angel_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "angel syllable pool", "'a, ba, ba, ba, bra, bri, cha, cha, chi, ci, d, de, de, dki, dki, dra, dra, dri, dri, fa, fni, gu, gu, ha, ha, ha, ho, hu, ka, kbi, ki, kshmi, la, le, le, li, li, lka, ma, ma, ma, ma, ma, ma, ma, me, mha, mi, mi, mna, msi, mu, mu, mwoo, na, na, nda, ne, ni, ni, ni, nka, nni, no, nri, nri, nu, pha, pha, pha, pha, phi, phi, phki, pho, phsi, po, qu, ra, ra, ra, ra, ra, ra, ra, ra, rbi, re, ri, ri, ri, ri, ri, ri, ro, rti, ru, ru, ru, ru, se, shi, shma, si, sra, sra, ssi, su, su, ta, tha, tza, va, vu, ye, za, zi, zi, zra, zra, 'i, 'i, a, bi, bi, chi, ddo, di, di, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, fe, fe, fi, hi, hme, i, i, i, i, i, la, lchu, le, li, lly, lpho, ma, mi, mi, mpha, mu, ni, ni, ni, ni, ni, phi, phi, qi, qqi, qui, ra, re, re, ri, ri, si, tha, thi, tro, va, ya, ze, 'i, a, a, a, a, ba, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, e, o, rae, ri, ri, a, e", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        angel_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "angel syllable pool", "^, ^, ^, ^, ^, ^, ^, ch, d, h, h, h, h, h, h, h, k, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, n, n, n, n, n, n, n, n, n, r, r, r, r, r, r, r, s, s, t, t, t, t, th", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        angel_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "angel syllable pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("angel syllable pool", "Syllable Count Weighting", NamePiecesEntities.ANGEL_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("angel syllable pool", "Terminal Blank Counts", NamePiecesEntities.ANGEL_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "angel syllable pool", angel_root_initial.length - 1 <= 0 ? 0.0f : ((float)angel_prefix.length - 1.0f) / (float)(angel_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "angel syllable pool", angel_root_initial.length - 1 <= 0 ? 0.0f : ((float)angel_suffix.length - 1.0f) / (float)(angel_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

