/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.config.ConfigurationVN;
import astrotibs.villagenames.name.NamePieces;
import java.io.File;

public class AlienVillageConfigHandler {
    public static ConfigurationVN config;
    public static String[] alienvillage_prefix;
    public static String[] alienvillage_root_initial;
    public static String[] alienvillage_root_syllables;
    public static String[] alienvillage_root_terminal;
    public static String[] alienvillage_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;
    public static int[] terminal_blank_counts;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            AlienVillageConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        alienvillage_prefix = config.getStringWithoutDefaultsInComment("Prefixes", "alien village syllable pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        alienvillage_root_initial = config.getStringWithoutDefaultsInComment("Root: Initial", "alien village syllable pool", "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Ae, Ae, Au, Au, B, Ba, Baa, Baa, Be, Be, Bi, Bi, Bla, Bo, Bo, Bo, Bo, Bo, Bo, Bou, Bra, Bray, Bri, Bu, Bu, By, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Cau, Cau, Ce, Cha, Cle, Cle, Cloo, Co, Co, Co, Co, Cri, Cu, Cy, Da, Da, Da, Da, Da, De, De, Di, Di, Di, Do, Do, Dra, Dzie, E, E, E, E, E, Eu, Fe, Fe, Fe, Fi, Fla, Fo, Fo, Fre, Fri, Fu, Fu, G, G, G, G\u00e4, Ga, Ga, Ga, Ga, Ga, Gau, Gay, Ge, Gei, Gllo, Glo, Gly, Gna, Gra, Gra, Gri, Gru, Gue, H, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Hae, He, He, He, Hei, Hi, Hi, Hi, Ho, Hu, Hu, Hu, Huy, Hy, Hy, Hy, I, I, I, I, I, Ja, Ja, Ju, K, K, K, K, Ke, Ko, Ko, Kra, Krie, Ku, Ky, Ky, L, La, Le, Leu, Li, Li, Lie, Lu, Lu, Lu, M, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Mae, Mai, Mau, May, Me, Me, Me, Me, Me, Me, Mi, Mi, Mi, Mo, Mo, Mo, Ne, Ni, Ni, Ni, Niu, Nu, Nyi, O, O, O, O, O, O, O, O, O, Pa, Pa, Pa, Pe, Pe, Pe, Pe, Ph, Phe, Pi, Pi, Pi, Pi, Pla, Pla, Plei, Pli, Pni, Po, Po, Pri, Pro, Pru, Ptha, Pu, Py, R\u00e9, R\u00f6, R\u00fc, Ra, Re, Re, Re, Rei, Rei, Rhei, Rhy, Ri, Ri, Ri, Ri, Ro, Roo, Ru, Ru, Sa, Sa, Schr\u00f6, Schr\u00f6, Schr\u00f6, Sci, Se, Se, Seu, Sha, Sha, Shee, Sho, Shu, Si, Si, Sie, Smi, Smy, Sne, So, So, So, So, So, Spei, Spi, Spu, Ste, Sti, Su, Su, Su, Su, Sy, Sy, Ta, Tae, Tau, Te, Te, Te, Te, The, The, Thu, Thu, Thy, Ti, Ti, Ti, To, To, Tra, Tri, U, U, U, V, Va, Va, Ve, Ve, Ve, Vhoo, Vi, Vi, Vi, Vi, Vi, Vla, Vo, Wa, We, Whi, Wo, Wu, Xa, Xe, Xe, Xi, Xi, Xo, Y, Y, Y, Ya, Ya, Ya, Ya, Ya, Ya, Ye, Yi, Yi, Yi, Yli, Yu, Yu, Z, Za, Za, Zi, Zly, Zu", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        alienvillage_root_syllables = config.getStringWithoutDefaultsInComment("Root: Syllables", "alien village syllable pool", "-Lu, 'gi, 'gy, 'i, 'nu, 'u, 'y, 'yi, 'yo, 'za, a, a, ae, au, ba, bau, bbi, bey, bi, bi, bli, bu, ca, ca, cce, cchi, cci, cci, ce, cha, che, che, chy, ckla, cle, clea, clo, co, co, co, co, cre, cta, cta, cta, cti, cu, dda, ddi, de, de, de, di, di, di, di, di, di, dlee, dley, dley, do, do, e, e, e, e, e, fi, fne, g, g'gia, ga, ga, ga, ga, ga, ge, ge, ge, gfrie, ggai, ggli, ggo, ggo, gi, gi, gne, gni, go, go, gri, hi, i, i, iu, ka, kie, ko, kra, ku, l-Ya, l-ya, l'g, la, lae, lblo, lde, ldha, ldro, le, ley, lgo, li, li, li, li, li, li, li, li, li, lko, lla, lla, lle, lli, lly, lmi, lmi, lo, lo, lpe, lphe, lpho, lpi, ltai, lve, lvi, ma, ma, ma, ma, ma, mbo, mbo, mbri, me, mi, mke, mma, mne, mni, mni, mo, mo, mo, mo, mp\u00e8, mpo, msde, mu, n_Co, n-Yu, na, na, na, nau, nco, nda, ndai, nde, ndi, ndr\u00e9, ndra, ndru, ne, ne, ne, ng-Mei, nge, nge, nghi, ngu, nhi, ni, ni, ni, ni, ni, nie, nna, nnse, no, no, no, nqui, nse, nstee, nsu, nti, nto, o, o, o, o, o, pa, pe, pe, pe, pe, pe, phae, phu, pi, pla, po, po, ppe, ppe, ppo, psha, pso, pu, r', ra, ra, ra, ra, ra, ra, ra, rbi, rby, rca, rce, rcha, rche, rchi, rchy, rco, rctu, rda, rde, rdi, rdu, re, re, rga, rga, rgae, rgi, rgo, rgo, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, rka, rka, rke, rke, rlo, rme, rmi, rna, rne, rno, ro, ro, rpa, rr-Kthu, rry, rsa, rse, rse, rta, rti, rti, rtne, ru, ru, rva, rwi, rza, sa, sca, schne, sco, sco, sco, shma, si, si, si, si, sne, so, spa, spe, sse, ssi, sta, ste, stli, sto, stra, stu, stu, t, t\u00e6, ta, ta, ta, te, te, te, tha, thi, tho, thu, tla, to, to, to, tre, tru, tta, tte, tti, ttro, tu, ty, tya, tzbe, u, va, vi, vi, vy, we, wi, wso, wu, xce, xu, yeu, z'ni, za, ze, zla, _Na, -A, -Li, -U, 'h, a, a, ba, cha, che, chi, ci, ci, cli, co, cu, de, de, de, di, do, do, du, e, e, e, e, e, g-Tha, ge, gra, h-e, i, i, i, i, i, i, i, khu, l, l_Za, l'mno, la, la, lae, ldi, ldi, ldti, le, lee, lfe, lgeu, lhau, lhu, li, li, li, lla, lla, lle, lle, lli, llo, llo, llya, lmay, lo, ls, lski, lso, lu, lze, ma, me, me, mi, mni, mo, mu, n\u00e6, na, nae, ndi, ndi, ne, nga, nge, nge, ni, ni, ni, ni, ni, ni, ni, nni, no, no, nsu, nti, nti, ntla, nu, nu, nu, o, o, o, o, pa, pha, ppu, ra, ra, ra, rdi, rge, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, ri, rlo, rna, rna, rra, rtiu, ru, ru, ru, ru, ru, ru, sa, sh-Vho, shi, so, ssa, ssi, ssu, sta, ste, su, t, ta, ta, ta, ta, ta, te, te, th_Rho, th-Ghu, tha, tho, thu, ti, tia, tiu, to, to, tta, tu, tu, tu, tu, u, u, u, u, u, u, u, u, u, u, u, va, ve, vi, vi, vi, vi, vi, x'a, zy, a, ae, ae, ch'ya, cra, da, dae, de, de, de, di, do, du, e, e, ho, i, i, i, la, ldru, li, li, lli, mi, mi, ndi, ne, ni, ni, ni, no, no, nta, nti, ntu, o, o, ra, ra, ra, rchi, rchu, ri, ri, ri, ru, ru, si, ta, ta, ta, ta, ta, ta, ta, ti, ti, ti, ti, tra, tu, tu, u, u, u, u, u, u, u, u, u, u, u, u, vi, ya, a, a, ae, de, le, ni, ni, nse, nti, nu, se, ti, ti, ti, ti, ti, ti, ti, u, u, u, u, ae, ru", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        alienvillage_root_terminal = config.getStringWithoutDefaultsInComment("Root: Terminal", "alien village syllable pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, b, b, c, c, ce, ch, ch, d, d, ffe, fft, g, g, h, h, hr, k, k, k, ksh, l, l, l, l, l, l, l, l, l, l, ld, ldt, lf, lff, ll, lle, lt, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, m, mph, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, nc, nck, nck, nd, nd, nd, nd, nd, ng, nks, ns, ns, nz, p, pff, ph, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, r, rd, rd, rd, rd, re, re, rg, rl, rp, rre, rt, rth, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, se, sh, sle, ss, st, t, t, th, th, th, th, th, th, th, th, th, th, th, th, tte, tzsch, v, v, v, v, v, v, v, v, w, w, wes, x, x, x, z, z", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.\nThe raw number of ^ entries will be ignored if \"Syllable Count Weighting\" and \"Terminal Blank Counts\" are formatted correctly.").trim().split("\\s*,\\s*");
        alienvillage_suffix = config.getStringWithoutDefaultsInComment("Suffixes", "alien village syllable pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("alien village syllable pool", "Syllable Count Weighting", NamePieces.ALIEN_VILLAGE_SYLLABLE_COUNT_WEIGHTS, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        terminal_blank_counts = config.get("alien village syllable pool", "Terminal Blank Counts", NamePieces.ALIEN_VILLAGE_BLANK_TERMINAL_COUNTS, "The number of names that end on a blank \"Root: Terminal\" character (typically this means ending on a vowel sound). The number in the Nth row is the weighting for N-syllable names. If this number is larger than the corresponding row's number in \"Syllable Count Weighting\" or smaller than 0, then this config will be ignored and the \"Root: Terminal\" character will be drawn from directly.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "alien village syllable pool", alienvillage_root_initial.length - 1 <= 0 ? 0.0f : ((float)alienvillage_prefix.length - 1.0f) / (float)(alienvillage_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "alien village syllable pool", alienvillage_root_initial.length - 1 <= 0 ? 0.0f : ((float)alienvillage_suffix.length - 1.0f) / (float)(alienvillage_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

