/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import astrotibs.villagenames.config.ConfigurationVN;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneralConfig {
    public static ConfigurationVN config;
    public static boolean wellSlabs;
    public static boolean nameSign;
    public static boolean nameEntities;
    public static String headerTags;
    public static boolean villagerMakesBook;
    public static boolean villagerDropBook;
    public static boolean villagersOfferCodexTrade;
    public static boolean villagerMakesCodex;
    public static boolean recordStructureCoords;
    public static boolean addJobToName;
    public static String nitwitProfession;
    public static boolean villageBanners;
    public static int signYaw;
    public static boolean addLunarinBlocks;
    public static boolean concreteWell;
    public static boolean codexChestLoot;
    public static boolean versionChecker;
    public static boolean wellBoundary;
    public static boolean wellDecorations;
    public static boolean useVillageColors;
    public static boolean debugMessages;
    public static boolean nameGolems;
    public static String[] modNameMappingAutomatic;
    public static Map<String, List> modNameMappingAutomatic_map;
    public static String[] modNameMappingClickable;
    public static Map<String, List> modNameMappingClickable_map;
    public static String[] entitiesNameableLikePets;
    public static Set<String> entitiesNameableLikePets_set;
    public static String[] modProfessionMapping;
    public static Map<String, List> modProfessionMapping_map;
    public static int PMMerchantProfessionMap;
    public static int PMLostMinerProfessionMap;
    public static boolean TQVillageNames;
    public static String[] modStructureNames;
    public static Map<String, List> modStructureNames_map;
    public static boolean modernVillagerSkins;
    public static boolean moddedVillagerHeadwear;
    public static String[] moddedVillagerHeadwearGraylist;
    public static Map<String, List> moddedVillagerHeadwearWhitelist_map;
    public static Map<String, List> moddedVillagerHeadwearBlacklist_map;
    public static String[] moddedVillagerModularSkins;
    public static Map<String, List> moddedVillagerCareerSkins_map;
    public static ArrayList<String> careerAsset_a;
    public static ArrayList<String> zombieCareerAsset_a;
    public static ArrayList<String> professionID_a;
    public static ArrayList<Integer> careerID_a;
    public static ArrayList<String> profession_concat_career_a;
    public static boolean villagerSkinTones;
    public static float villagerSkinToneVarianceAnnealing;
    public static float villagerSkinToneVarianceScale;
    public static boolean modernVillagerTrades;
    public static boolean treasureTrades;
    public static boolean writtenBookTrade;
    public static boolean swampHutMushroomPot;
    public static String[] modBamboo;
    public static String[] modBarrel;
    public static String[] modBell;
    public static String[] modBlastFurnace;
    public static String[] modBlueIce;
    public static String[] modBountifulStone;
    public static String[] modCampfire;
    public static String[] modCartographyTable;
    public static String[] modComposter;
    public static String[] modDye;
    public static String[] modFletchingTable;
    public static String[] modFlower;
    public static String[] modGrindstone;
    public static String[] modLantern;
    public static String[] modLoom;
    public static String[] modPrismarine;
    public static String[] modMossyStone;
    public static String[] modSandstone;
    public static String[] modSmithingTable;
    public static String[] modSmoker;
    public static String[] modSmoothStone;
    public static String[] modStoneBrickWall;
    public static String[] modStonecutter;
    public static String[] modStrippedLog;
    public static String[] modStrippedWood;
    public static String[] modSuspiciousStew;
    public static String[] modSweetBerries;
    public static String[] modWood;
    public static String[] modWoodenTable;
    public static String[] modWoodenTrapdoor;
    public static String[] zombieCureCatalysts;
    public static Map<String, List> zombieCureCatalysts_map;
    public static String[] zombieCureGroups;
    public static Map<String, List> zombieCureGroups_map;
    public static float harvestcraftCropFarmRate;
    public static boolean antiqueAtlasMarkerNames;

    public static void init(File configFile) {
        if (config == null) {
            config = new ConfigurationVN(configFile);
            GeneralConfig.loadConfiguration();
        }
    }

    protected static void loadConfiguration() {
        nameSign = config.getBoolean("Name Sign", "general", true, "Town centers display their name on one or more signs.");
        recordStructureCoords = config.getBoolean("Record Structure Coords", "general", true, "Books generated by villagers or the Codex record the structure's coordinates.");
        villagerMakesBook = config.getBoolean("Villager makes book", "general", true, "Villagers record the village name, and other info, when you right-click them with a book.");
        villagerDropBook = config.getBoolean("Villager drops book/codex", "general", false, "Village books and Codices are dropped by the villager rather than going directly into your inventory.");
        villagersOfferCodexTrade = config.getBoolean("Villagers offer Codex trade", "general", true, "Librarian and Cartographer villagers can offer to sell you the Codex item via an ordinary trade.");
        villagerMakesCodex = config.getBoolean("Villager makes codex", "general", false, "Librarian villagers will give you a codex if you right-click them while holding emerald, iron ingots, and/or gold ingots.");
        useVillageColors = config.getBoolean("Use village colors", "general", true, "Whether to apply the village's colors to concrete, terracotta, carpet, etc.");
        wellBoundary = config.getBoolean("Well boundary", "general", true, "Whether to surround the well with colored blocks");
        wellSlabs = config.getBoolean("Well slabs", "general", true, "Replace the cobblestone rims of wells with stone slabs, making it easier for players and villagers to escape if they fall in.");
        villageBanners = config.getBoolean("Village Banner", "general", true, "The town banner pattern is displayed at the town center.");
        signYaw = config.getInt("Sign Yaw", "general", 3, 0, 4, "If Village Banner is enabled: Degree to which well signs and banners should face inward. At 0 they face directly outward away from the well; at 4 they face each other.");
        wellDecorations = config.getBoolean("Allow well decorations", "well kill switch", true, "Set this to false to disable all well decoration: sign, slabs, terracotta, concrete.");
        concreteWell = config.getBoolean("Concrete Well", "general", true, "Whether to decorate wells with Concrete and Glazed Terracotta instead of stained clay. This only applies to old-school wells, i.e. if \"Activate New Village Generator\" is false.");
        treasureTrades = config.getBoolean("Treasure Trades", "villager professions", true, "High-level Librarians and Cartographers will offer enchanted books and treasures in exchange for Village Names items.");
        writtenBookTrade = config.getBoolean("Written Book Trade", "villager professions", true, "Change the vanilla Librarian trade to require a single written book instead of two identical written books");
        modernVillagerSkins = config.getBoolean("Modern Villager Profession Skins", "villager professions", true, "Use the composite 1.14 Villager skins");
        modernVillagerTrades = config.getBoolean("Modern Villager Trades", "villager professions", true, "Use JE 1.14 / BE 1.12 trade offerings and add the Mason villager");
        moddedVillagerHeadwear = config.getBoolean("Modded Villager Headwear", "villager professions", false, "If modern skins are enabled: renders the headwear layer for non-vanilla villager professions, if one exists.");
        moddedVillagerHeadwearGraylist = config.getStringListWithoutDefaultsInComment("Modded Villager Headwear Graylist", "villager professions", new String[]{"bewitchment:alchemist", "custom:guard", "extrautils2:alchemist", "forestry:apiarist", "gravestone-extended:undertaker", "immersiveengineering:engineer|1", "immersiveengineering:engineer|2", "immersiveengineering:engineer|3", "immersiveengineering:engineer|4", "immersiveengineering:engineer|5", "is_mtc:card_master", "-openblocks:radio", "tolkienmobs:junk_dealer", "totemexpansion:witchdoctor"}, "(If modern skins are enabled) List of profession IDs for other mods' villagers. A normal value will be whitelisted: it will display that villager's headwear layer even if Modded Villager Headwear is false. Adding a negative sign in front of the ID int will blacklist the profession so that its headwear layer never renders.");
        moddedVillagerHeadwearWhitelist_map.clear();
        moddedVillagerHeadwearWhitelist_map = GeneralConfig.unpackModdedVillagerHeadwearGraylist(moddedVillagerHeadwearGraylist, true);
        moddedVillagerHeadwearBlacklist_map.clear();
        moddedVillagerHeadwearBlacklist_map = GeneralConfig.unpackModdedVillagerHeadwearGraylist(moddedVillagerHeadwearGraylist, false);
        moddedVillagerModularSkins = config.getStringListWithoutDefaultsInComment("Modded Villager Modular Skins", "villager professions", new String[]{"aa_engineer|aa_engineer|actuallyadditions:engineer", "aa_jam|aa_jam|actuallyadditions:jamguy", "am_petseller|am_petseller|animania:pet_seller", "bew_alchemist||bewitchment:alchemist", "ccp_stablehand||chococraftplus:stablehand", "custom_guard|custom_guard|custom:guard", "cm_druid|cm_druid|cyclicmagic:druid", "cm_sage|cm_sage|cyclicmagic:sage", "eu_alchemist|eu_alchemist|extrautils2:alchemist", "eu_red_mechanic|eu_red_mechanic|extrautils2:red_mechanic", "eu_shady_merchant|eu_shady_merchant|extrautils2:shady_merchant", "for_apiarist|for_apiarist|forestry:apiarist", "for_arborist|for_arborist|forestry:arborist", "fa_archaeologist||fossil:archeologist", "gs_undertaker|gs_undertaker|gravestone-extended:undertaker", "hac_researcher|hac_researcher|dcs_climate:agri_researcher", "hac_researcher|hac_researcher|dcs_climate:engineer", "hac_trader|hac_trader|dcs_climate:trader", "ie_engineer||immersiveengineering:engineer|1", "ie_machinist||immersiveengineering:engineer|2", "ie_electrician||immersiveengineering:engineer|3", "ie_outfitter||immersiveengineering:engineer|4", "ie_gunsmith||immersiveengineering:engineer|5", "mtc_cardmaster||is_mtc:card_master", "mtc_cardtrader||is_mtc:card_trader", "mh_retailer|mh_retailer|miniheads:storeowner", "myc_archivist||mystcraft:archivist", "ob_musicmerchant||openblocks:radio", "pc_mechanic||pneumaticcraft:mechanic", "rc_engineer|rc_engineer|railcraft:trackman", "ttm_coin_trader|ttm_coin_trader|tolkienmobs:coin_trader", "ttm_grocery_store|ttm_grocery_store|tolkienmobs:grocery_store", "ttm_junk_trader|ttm_junk_trader|tolkienmobs:junk_dealer", "ttm_pet_merchant|ttm_pet_merchant|tolkienmobs:pet_merchant", "te_witch_doctor||totemexpansion:witchdoctor"}, "(If modern skins are enabled) List of profession IDs for other mods' villagers to render in the modular skin style. Format is: careerAsset|zombieCareerAsset|professionID\ncareerAsset: career skin png to be overlaid onto the villager, located in assets\\" + "villagenames".toLowerCase() + "\\textures\\entity\\villager\\profession\nThe default values are all available in " + "Village Names" + ". You can access custom values with a resourcepack.\nzombieCareerAsset: a zombie career png, located in the corresponding zombie_villager directory. You may leave this value blank, in which case it will use the non-zombie career overlay.\nprofessionID: the ID associated with the mod profession.");
        moddedVillagerCareerSkins_map.clear();
        moddedVillagerCareerSkins_map = GeneralConfig.unpackModVillagerSkins(moddedVillagerModularSkins);
        careerAsset_a = (ArrayList)moddedVillagerCareerSkins_map.get("careerAsset");
        zombieCareerAsset_a = (ArrayList)moddedVillagerCareerSkins_map.get("zombieCareerAsset");
        professionID_a = (ArrayList)moddedVillagerCareerSkins_map.get("professionID");
        careerID_a = (ArrayList)moddedVillagerCareerSkins_map.get("careerID");
        profession_concat_career_a = (ArrayList)moddedVillagerCareerSkins_map.get("IDs_concat_careers");
        villagerSkinTones = config.getBoolean("Display Skin Tones", "villager skin tones", true, "Display Gaussian-distributed random skin tones assigned to villagers");
        villagerSkinToneVarianceAnnealing = config.getFloat("Skin Tone Variance Annealing", "villager skin tones", 2.6666667f, 0.0f, Float.MAX_VALUE, "Statistical variance in skin tone for a population decreases as the number of skin-tone-affecting biome tags increases.\nSetting this value to zero eliminates that effect, making skin tone vary equally everywhere (aside from culling to the darkest/lightest tones).\nIncreasing this value makes skin tone variation less likely in qualifying biomes.");
        villagerSkinToneVarianceScale = config.getFloat("Skin Tone Variance Scale", "villager skin tones", 1.0f, 0.0f, Float.MAX_VALUE, "Proportionality constant for variance everywhere, irrespective of biome. Set this to zero for absolutely no variation for a given biome.\nSkin tones are culled to the darkest and lightest values, so setting this arbitrarily high will result in ONLY the darkest or lightest villagers.\nI estimate that the distribution is flattest, and thus population variance is maximized, around a value of about 2.6.");
        zombieCureCatalysts = config.getStringListWithoutDefaultsInComment("Zombie Cure Catalysts", "general", new String[]{"vanilla|net.minecraft.block.BlockBed|tile.bed|-1", "vanilla|net.minecraft.block.BlockPane|tile.fenceIron|-1"}, "When performing the ritual to convert a zombie villager into a villager, having these blocks nearby (within a taxicab distance of 4) will speed up the process. Format is: group|classPath|unlocName|meta\ngroup is an arbitrary group name to which the block belongs, referenced in Zombie Cure Groups below.\nclassPath is the mod's address to the entity class.\nunlocName is the unlocalized name of the block. This is used as an extra discriminator in case class path and meta aren't enough. You can leave this blank to ignore it.\nmeta is integer meta value of the block. Enter -1 to ignore meta and count all blocks with that class path.");
        zombieCureCatalysts_map.clear();
        zombieCureCatalysts_map = GeneralConfig.unpackZombieCureCatalysts(zombieCureCatalysts);
        zombieCureGroups = config.getStringListWithoutDefaultsInComment("Zombie Cure Groups", "general", new String[]{"vanilla|0.3|14"}, "When curing a zombie villager, all blocks of the same named group will use these stats. Format is: group|speedup|limit\ngroup is the group name assigned in Zombie Cure Catalysts above.\nspeedup is the per-block percentage point boost in conversion speed. That is: a value of 1.0 increases the conversion by about 1 percentage point per group block found. negative values will likewise reduce the conversion speed, making conversion take longer.\nlimit is the maximum number of blocks in this group that will apply the group speedup effect.");
        zombieCureGroups_map.clear();
        zombieCureGroups_map = GeneralConfig.unpackZombieCureGroups(zombieCureGroups);
        versionChecker = config.getBoolean("Version Checker", "miscellaneous", true, "Displays a client-side chat message on login if there's an update available.");
        addLunarinBlocks = config.getBoolean("Add Lunarin Blocks", "miscellaneous", true, "Adds an original brick-style block for iron and gold");
        codexChestLoot = config.getBoolean("Codex Chest Loot", "miscellaneous", true, "The Codex can appear as rare chest loot.");
        debugMessages = config.getBoolean("Debug messages", "miscellaneous", false, "Print debug messages to the console, print the class paths of entities and blocks you right-click.");
        swampHutMushroomPot = config.getBoolean("Swamp Hut Mushroom", "miscellaneous", true, "1.8+ has a bug where the clay pot in the Witch's swamp hut is empty. This flag will correctly place a red mushroom in the pot.");
        nameEntities = config.getBoolean("Entity names", "naming", true, "Entities reveal their names when you right-click them, or automatically if so assigned.");
        addJobToName = config.getBoolean("Entity professions", "naming", false, "An entity's name also includes its profession/title. You may need to right-click the entity to update its name plate.");
        nameGolems = config.getBoolean("Golem names", "naming", true, "Right-click village Golems to learn their name.");
        nitwitProfession = config.getString("Nitwit Profession", "naming", "", "The career displayed for a Nitwit");
        modNameMappingAutomatic = config.getStringListWithoutDefaultsInComment("Automatic Names", "naming", new String[]{"villager-goblin|Witch|net.minecraft.entity.monster.EntityWitch|add", "alien-golem|Elder Guardian|net.minecraft.entity.monster.EntityElderGuardian|add", "villager-demon|Evoker|net.minecraft.entity.monster.EntityEvoker|add", "villager-demon|Vindicator|net.minecraft.entity.monster.EntityVindicator|add", "villager-demon|Illusioner|net.minecraft.entity.monster.EntityIllusionIllager|add", "alien-demon|Evolved Skeleton Boss|micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss|add", "alien-golem|Evolved Creeper Boss|micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss|add", "alien-goblin||micdoodle8.mods.galacticraft.planets.venus.entities.EntitySpiderQueen|add", "alien-goblin|Evolved Witch|stevekung.mods.moreplanets.core.entities.EntityEvolvedWitch|add", "alien-golem|Diona Creeper Boss|stevekung.mods.moreplanets.planets.diona.entities.EntityDionaCreeperBoss|add", "alien-golem|Fronos Creeper Boss|stevekung.mods.moreplanets.planets.fronos.entities.EntityFronosCreeperBossTemp|add", "alien-golem|Kapteyn B Creeper Boss|stevekung.mods.moreplanets.planets.kapteynb.entities.EntityKapteynBCreeperBoss|add", "alien-goblin|Evolved Infected Spider Boss|stevekung.mods.moreplanets.planets.nibiru.entities.EntityEvolvedInfectedSpiderBoss|add", "alien-golem|Pluto Creeper Boss|stevekung.mods.moreplanets.planets.pluto.entities.EntityPlutoCreeperBoss|add", "alien-angel|Cheese Cube Boss|stevekung.mods.moreplanets.planets.polongnius.entities.EntityCheeseCubeEyeBoss|add", "alien-demon-golem|Evolved Sirius Blaze Boss|stevekung.mods.moreplanets.planets.siriusb.entities.EntityEvolvedSiriusBlazeBoss|add", "alien-demon|Infected Crystallized Slime Boss|stevekung.mods.moreplanets.module.planets.diona.entity.EntityInfectedCrystallizeSlimeBoss|add", "alien-angel|Cheese Cube Boss|stevekung.mods.moreplanets.module.planets.chalos.entity.EntityCheeseCubeEyeBoss|add", "demon-goblin||nex.entity.passive.EntityPigtificate", "demon-goblin||nex.entity.passive.EntityPigtificateLeader", "alien-demon-angel|Evolved Boss Ghast|galaxyspace.galaxies.milkyway.SolarSystem.moons.io.entities.EntityBossGhast|add", "alien-demon-golem|Evolved Boss Blaze|galaxyspace.galaxies.milkyway.SolarSystem.planets.ceres.entities.EntityBossBlaze|add", "villager|Summoner|net.daveyx0.primitivemobs.entity.monster.EntityDSummoner|add", "villager-goblin|Witch of Domination|fathertoast.specialmobs.entity.witch.EntityDominationWitch|add", "villager-goblin|Witch of Shadows|fathertoast.specialmobs.entity.witch.EntityShadowsWitch|add", "villager-goblin|Witch of the Wilds|fathertoast.specialmobs.entity.witch.EntityWildsWitch|add", "villager-goblin|Witch of the Wind|fathertoast.specialmobs.entity.witch.EntityWindWitch|add", "villager-golem||twilightforest.entity.EntityTFArmoredGiant|add", "villager-golem||twilightforest.entity.EntityTFGiantMiner|add", "dragon|Naga|twilightforest.entity.boss.EntityTFNaga|add", "dragon|Hydra|twilightforest.entity.boss.EntityTFHydra|add", "demon-golem|Knight Phantom|twilightforest.entity.boss.EntityTFKnightPhantom|add", "demon|Twilight Lich|twilightforest.entity.boss.EntityTFLich|add", "goblin|Minoshroom|twilightforest.entity.boss.EntityTFMinoshroom|add", "angel|Snow Queen|twilightforest.entity.boss.EntityTFSnowQueen|add", "demon-angel|Ur-ghast|twilightforest.entity.boss.EntityTFUrGhast|add", "goblin-golem|Alpha Yeti|twilightforest.entity.boss.EntityTFYetiAlpha|add", "villager-demon||com.emoniph.witchery.entity.EntityVampire|add", "villager|Witch Hunter|com.emoniph.witchery.entity.EntityWitchHunter|add", "demon|Horned Huntsman|com.emoniph.witchery.entity.EntityHornedHuntsman|add"}, "List of entities that will generate a name automatically when they appear. Useful for aggressive or boss mobs.\nFormat is: nameType|profession|classPath|addOrRemove\nnameType is the name pool for the entity, or a hyphenated series of pools like \"angel-golem\".\nprofession is displayed if that config flag is enabled. It can be left blank for no profession.\nclassPath is the mod's address to the entity class.\nnameType options:\nvillager, dragon, golem, alien, angel, demon, goblin, pet, custom\naddOrRemove - type \"add\" to automatically add names tags to ALL COPIES of this entity upon spawning, or \"remove\" to automatically remove.\nBe VERY CAUTIOUS about what entities you choose to add to this list!");
        modNameMappingAutomatic_map.clear();
        modNameMappingAutomatic_map = GeneralConfig.unpackMappedNames(modNameMappingAutomatic);
        modNameMappingClickable = config.getStringListWithoutDefaultsInComment("Clickable Names", "naming", new String[]{"alien||micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager", "alien||stevekung.mods.moreplanets.moons.koentus.entities.EntityKoentusianVillager", "alien||stevekung.mods.moreplanets.module.moons.koentus.entities.EntityKoentusianVillager", "alien-villager-goblin||stevekung.mods.moreplanets.planets.fronos.entities.EntityFronosVillager", "alien-villager-goblin||stevekung.mods.moreplanets.module.planets.fronos.entities.EntityFronosVillager", "alien-villager-angel||stevekung.mods.moreplanets.planets.nibiru.entity.EntityNibiruVillager", "alien-villager-angel||stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityNibiruVillager", "goblin-demon||mods.natura.entity.ImpEntity", "goblin||thaumcraft.common.entities.monster.EntityPech", "villager|Sentry|net.torocraft.toroquest.entities.EntitySentry", "villager|Guard|net.torocraft.toroquest.entities.EntityGuard", "villager|Lord|net.torocraft.toroquest.entities.EntityVillageLord", "angel-golem-goblin|Questing Ram|twilightforest.entity.passive.EntityTFQuestRam", "villager|Guard|com.emoniph.witchery.entity.EntityVillageGuard", "goblin||com.emoniph.witchery.entity.EntityGoblin", "goblin-demon||com.emoniph.witchery.entity.EntityImp", "demon||com.emoniph.witchery.entity.EntityDemon", "villager|Traveling Merchant|net.daveyx0.primitivemobs.entity.passive.EntityTravelingMerchant", "villager|Miner|net.daveyx0.primitivemobs.entity.passive.EntityLostMiner", "villager||net.daveyx0.primitivemobs.entity.passive.EntitySheepman", "villager|Blacksmith|net.daveyx0.primitivemobs.entity.passive.EntitySheepmanSmith", "villager-goblin||nex.entity.passive.EntityPigtificate", "villager-goblin|Chief|nex.entity.passive.EntityPigtificateLeader", "villager-goblin||imc.common.EntityPigman"}, "List of entities that can generate a name when right-clicked. Format is: nameType|profession|classPath\nnameType is the name pool for the entity, or a hyphenated series of pools like \"angel-golem\".\nprofession is displayed if that config flag is enabled. It can be left blank for no profession.\nclassPath is mod's address to the entity class.\nnameType options:\nvillager, dragon, golem, alien, angel, demon, goblin, pet, custom\n");
        modNameMappingClickable_map.clear();
        modNameMappingClickable_map = GeneralConfig.unpackMappedNames(modNameMappingClickable);
        entitiesNameableLikePets = config.getStringListWithoutDefaultsInComment("Entities Nameable Like Pets", "naming", new String[]{"com.animania.addons.farm.common.entity.horses.HorseDraft$EntityStallionDraftHorse", "com.animania.addons.farm.common.entity.horses.HorseDraft$EntityMareDraftHorse", "com.animania.addons.farm.common.entity.horses.HorseDraft$EntityFoalDraftHorse"}, "List of class paths of entities that receive a random Pet name when right-clicked with a blank nametag, irrespective of if they're tamed or who tamed them.\nUse this for entities that can't receive a Pet name in the intended way (typically because owner ID is stored differently or not stored at all).");
        entitiesNameableLikePets_set.clear();
        for (int i = 0; i < entitiesNameableLikePets.length; ++i) {
            entitiesNameableLikePets_set.add(entitiesNameableLikePets[i]);
        }
        harvestcraftCropFarmRate = config.getFloat("Crop rate: Harvestcraft", "mod integration", 0.25f, 0.0f, 1.0f, "Generate Harvestcraft crops in farms. Only used with Village Generator. Set to 0 for no HC crops.");
        antiqueAtlasMarkerNames = config.getBoolean("Antique Atlas: Village Marker Names", "mod integration", true, "Label a new village marker with the village's name in your Antique Atlases.");
        modBamboo = config.getStringListWithoutDefaultsInComment("Mod Priority: Bamboo", "mod integration", new String[]{"futuremc", "growthcraft", "biomesoplenty", "sakura", "futureversions", "bamboozled"}, "Priority order for referencing Bamboo for village generation. The version highest on the list and registered in your game will be used.");
        modBarrel = config.getStringListWithoutDefaultsInComment("Mod Priority: Barrel", "mod integration", new String[]{"futuremc", "futureversions", "rustic"}, "Priority order for referencing Barrels for village generation and villager trades. The version highest on the list and registered in your game will be used.");
        modBell = config.getStringListWithoutDefaultsInComment("Mod Priority: Bell", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing Bells for villager trades. The version highest on the list and registered in your game will be used.");
        modBlastFurnace = config.getStringListWithoutDefaultsInComment("Mod Priority: Blast Furnace", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing Blast Furnace for village generation. The version highest on the list and registered in your game will be used.");
        modBlueIce = config.getStringListWithoutDefaultsInComment("Mod Priority: Blue Ice", "mod integration", new String[]{"futuremc", "oceanicexpanse", "futureversions"}, "Priority order for referencing Blue Ice for village generation. The version highest on the list and registered in your game will be used.");
        modBountifulStone = config.getStringListWithoutDefaultsInComment("Mod Priority: Bountiful Stone", "mod integration", new String[]{"quark", "vanillabuildersextension", "futureversions"}, "Priority order for referencing Granite, Diorite, and Andesite for things like walls and stairs. The version highest on the list and registered in your game will be used.");
        modCampfire = config.getStringListWithoutDefaultsInComment("Mod Priority: Campfire", "mod integration", new String[]{"campfire", "futuremc", "justacampfire", "toughasnails", "futureversions"}, "Priority order for referencing the Campfire for village generation and villager trade offers. The version highest on the list and registered in your game will be used.");
        modCartographyTable = config.getStringListWithoutDefaultsInComment("Mod Priority: Cartography Table", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Cartography Table for village generation. The version highest on the list and registered in your game will be used.");
        modComposter = config.getStringListWithoutDefaultsInComment("Mod Priority: Composter", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Composter for village generation. The version highest on the list and registered in your game will be used.");
        modDye = config.getStringListWithoutDefaultsInComment("Mod Priority: Dye", "mod integration", new String[]{"futuremc", "biomesoplenty", "quark", "botania", "futureversions"}, "Priority order for referencing dye for villager trade offers. The version highest on the list and registered in your game will be used.");
        modFletchingTable = config.getStringListWithoutDefaultsInComment("Mod Priority: Fletching Table", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Fletching Table for village generation. The version highest on the list and registered in your game will be used.");
        modFlower = config.getStringListWithoutDefaultsInComment("Mod Priority: Flower", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing flowers for village generation. The version highest on the list and registered in your game will be used.");
        modGrindstone = config.getStringListWithoutDefaultsInComment("Mod Priority: Grindstone", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Grindstone for village generation. The version highest on the list and registered in your game will be used.");
        modLantern = config.getStringListWithoutDefaultsInComment("Mod Priority: Lantern", "mod integration", new String[]{"charm", "futuremc", "futureversions"}, "Priority order for referencing Lanterns for village generation and villager trade offers. The version highest on the list and registered in your game will be used.");
        modLoom = config.getStringListWithoutDefaultsInComment("Mod Priority: Loom", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Loom for village generation. The version highest on the list and registered in your game will be used.");
        modMossyStone = config.getStringListWithoutDefaultsInComment("Mod Priority: Mossy Stone", "mod integration", new String[]{"etfuturum", "uptodate"}, "Priority order for referencing mossy stone blocks for village generation. The version highest on the list and registered in your game will be used.");
        modSandstone = config.getStringListWithoutDefaultsInComment("Mod Priority: Sandstone", "mod integration", new String[]{"quark", "futuremc", "vanillabuildersextension", "futureversions"}, "Priority order for referencing Sandstone variations for village generation. The version highest on the list and registered in your game will be used.");
        modSmithingTable = config.getStringListWithoutDefaultsInComment("Mod Priority: Smithing Table", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Smithing Table for village generation. The version highest on the list and registered in your game will be used.");
        modSmoker = config.getStringListWithoutDefaultsInComment("Mod Priority: Smoker", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Smoker for village generation. The version highest on the list and registered in your game will be used.");
        modSmoothStone = config.getStringListWithoutDefaultsInComment("Mod Priority: Smooth Stone", "mod integration", new String[]{"quark", "futuremc", "futureversions"}, "Priority order for referencing Smooth Stone for village generation. The version highest on the list and registered in your game will be used.");
        modStoneBrickWall = config.getStringListWithoutDefaultsInComment("Mod Priority: Stone Brick Wall", "mod integration", new String[]{"quark", "futuremc", "futureversions"}, "Priority order for referencing Stone Brick Walls for village generation. The version highest on the list and registered in your game will be used.");
        modStonecutter = config.getStringListWithoutDefaultsInComment("Mod Priority: Stonecutter", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing the Stonecutter for village generation. The version highest on the list and registered in your game will be used.");
        modStrippedLog = config.getStringListWithoutDefaultsInComment("Mod Priority: Stripped Log", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing Stripped Logs for village generation. The version highest on the list and registered in your game will be used.");
        modStrippedWood = config.getStringListWithoutDefaultsInComment("Mod Priority: Stripped Wood", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing Stripped Wood for village generation. The version highest on the list and registered in your game will be used.");
        modSuspiciousStew = config.getStringListWithoutDefaultsInComment("Mod Priority: Suspicious Stew", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing Suspicious Stew for villager trades. The version highest on the list and registered in your game will be used.");
        modSweetBerries = config.getStringListWithoutDefaultsInComment("Mod Priority: Sweet Berries", "mod integration", new String[]{"futuremc", "futureversions"}, "Priority order for referencing Sweet Berries for villager trades. The version highest on the list and registered in your game will be used.");
        modWood = config.getStringListWithoutDefaultsInComment("Mod Priority: Smooth Stone", "mod integration", new String[]{"quark", "futureversions"}, "Priority order for referencing Wood blocks (bark on all sides) for village generation. The version highest on the list and registered in your game will be used.");
        modWoodenTable = config.getStringListWithoutDefaultsInComment("Mod Priority: Table", "mod integration", new String[]{"chocolatequestrepoured", "macawsfurniture", "mrcrayfishsfurnituremod", "rustic", "variedcommodities", "minecraft", "bibliocraft"}, "Priority order for referencing Wooden Tables for village generation. The version highest on the list and registered in your game will be used. The \"minecraft\" entry refers to the vanilla-style pressure plate atop a fence post.");
        modWoodenTrapdoor = config.getStringListWithoutDefaultsInComment("Mod Priority: Smooth Stone", "mod integration", new String[]{"quark", "futureversions"}, "Priority order for referencing wooden trapdoors for village generation. The version highest on the list and registered in your game will be used.");
        modStructureNames = config.getStringListWithoutDefaultsInComment("Mod Structures", "mod integration", new String[]{"alienvillage|MoonVillage|Moon Village|Moon|moonvillage|micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager", "alienvillage|GC_AbandonedBase|Abandoned Base|Asteroid Belt|abandonedbase|", "alienvillage|FronosVillage|Fronos Village|Fronos|fronosvillage|stevekung.mods.moreplanets.planets.fronos.entities.EntityFronosVillager", "alienvillage|FronosVillage|Fronos Village|Fronos|fronosvillage|stevekung.mods.moreplanets.module.planets.fronos.entities.EntityFronosVillager", "alienvillage|KoentusVillage|Koentus Village|Koentus|koentusvillage|stevekung.mods.moreplanets.moons.koentus.entities.EntityKoentusianVillager", "alienvillage|KoentusVillage|Koentus Village|Koentus|koentusvillage|stevekung.mods.moreplanets.module.moons.koentus.entities.EntityKoentusianVillager", "alienvillage|NibiruVillage|Nibiru Village|Nibiru|nibiruvillage|stevekung.mods.moreplanets.planets.nibiru.entity.EntityNibiruVillager", "alienvillage|NibiruVillage|Nibiru Village|Nibiru|nibiruvillage|stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityNibiruVillager", "endcity|hardcoreenderdragon_EndTower|Dungeon Tower|The End|endcity|", "endcity|hardcoreenderdragon_EndIsland|Laboratory|The End|endcity|"}, "List of mod structures that can be named with a Codex, or by right-clicking an entity in that structure (optional). Structures must have been generated in a manner similarly to vanilla (e.g. Galacticraft Moon Villages).\nFormat is: nameType|structureType|structureTitle|dimensionName|bookType|entityClassPath\nnameType is your choice of name pool for the structure. Options: village, mineshaft, temple, stronghold, fortress, monument, endcity, mansion, alienvillage\nstructureType how the mod saves the structure info--e.g. dimension/data/[structureType].dat\nstructureTitle is the string type of the structure (e.g. \"Moon Village\"), which will be recorded into a book. It can be left blank.\ndimensionName is the name of the dimension that would be recorded into the book. It can be left blank.\nbookType is the kind of book that is generated. Options: village, mineshaft, temple, jungletemple, desertpyramid, swamphut, igloo, stronghold, fortress, monument, endcity, mansion, moonvillage, koentusvillage, fronosvillage, nibiruvillage, abandonedbase\nentityClassPath is the mod's address to the entity class that will generate this book (when inside the structure). It can be left blank, wherein the structure name can only be obtained via a Codex.\n");
        modStructureNames_map.clear();
        modStructureNames_map = GeneralConfig.unpackModStructures(modStructureNames);
        modPrismarine = config.getStringListWithoutDefaultsInComment("Mod Priority: Prismarine", "mod integration", new String[]{"quark", "futureversions"}, "Priority order for referencing prismarine variations for village generation. The version highest on the list and registered in your game will be used.");
        modProfessionMapping = config.getStringListWithoutDefaultsInComment("Mod Professions", "mod integration", new String[]{"Engineer|actuallyadditions:engineer|1", "Jam Guy|actuallyadditions:jamguy|0", "Alchemist|bewitchment:alchemist|2", "Stablehand|chococraftplus:stablehand|0", "Guard|custom:guard|-1", "Druid|cyclicmagic:druid|2", "Sage|cyclicmagic:sage|1", "Alchemist|extrautils2:alchemist|2", "Mechanic|extrautils2:red_mechanic|3", "Shady Merchant|extrautils2:shady_merchant|-1", "Apiarist|forestry:apiarist|4", "Arborist|forestry:arborist|0", "Archaeologist|fossil:archeologist|2", "Undertaker|gravestone-extended:undertaker|4", "Engineer|immersiveengineering:engineer|3|1", "Machinist|immersiveengineering:engineer|0|2", "Electrician|immersiveengineering:engineer|0|3", "Outfitter|immersiveengineering:engineer|0|4", "Gunsmith|immersiveengineering:engineer|0|5", "Card Master|is_mtc:card_master|2", "Card Trader|is_mtc:card_trader|0", "Store Owner|miniheads:storeowner|-1", "Archivist|mystcraft:archivist|1", "Music Merchant|openblocks:radio|5", "Engineer|railcraft:trackman|3", "Coin Banker|tolkienmobs:coin_trader|0", "Grocer|tolkienmobs:grocery_store|0", "Junk Dealer|tolkienmobs:junk_dealer|5", "Pet Supplier|tolkienmobs:pet_merchant|0", "Witch Doctor|totemexpansion:witchdoctor|2"}, "List of professions for other mods' villagers. Format is: Name|ID|pageType\nName is your choice of name for the profession.\nID is the ID associated with the mod profession.\npageType is the vanilla archetype the villager emulates in order to generate hint pages.\nUse this reference:\n-1=None\n0=Farmer\n1=Librarian\n2=Priest\n3=Blacksmith\n4=Butcher\n5=Nitwit\n");
        modProfessionMapping_map.clear();
        modProfessionMapping_map = GeneralConfig.unpackMappedProfessions(modProfessionMapping);
        PMMerchantProfessionMap = config.getInt("PM Traveling Merchant Profession ID", "mod integration", 0, 0, 5, "Which vanilla archetype the traveling merchant emulates in order to generate hint pages.\nUse this reference:\n-1=None\n0=Farmer\n1=Librarian\n2=Priest\n3=Blacksmith\n4=Butcher\n5=Nitwit\n");
        PMLostMinerProfessionMap = config.getInt("PM Lost Miner Profession ID", "mod integration", 3, 0, 5, "Which vanilla archetype the lost miner emulates in order to generate hint pages.\nUse this reference:\n-1=None\n0=Farmer\n1=Librarian\n2=Priest\n3=Blacksmith\n4=Butcher\n5=Nitwit\n");
        TQVillageNames = config.getBoolean("ToroQuest Village Names", "mod integration", true, "If you're using ToroQuest, write its town names into village books. Additionally, Village Names well signs will not generate, since they do so before ToroQuest assigns a town name.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Map<String, List> unpackMappedProfessions(String[] inputList) {
        ArrayList<String> otherModProfessions = new ArrayList<String>();
        ArrayList<String> otherModIDs = new ArrayList<String>();
        ArrayList<Integer> vanillaProfMaps = new ArrayList<Integer>();
        ArrayList<Integer> careerID_a = new ArrayList<Integer>();
        ArrayList<String> IDs_concat_careers = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("/", "");
            entry.replaceAll("\\\\", "");
            entry.replaceAll("..", "");
            String[] splitEntry = entry.split("\\|");
            String otherModProfession = "";
            String otherModID = "";
            int vanillaProfMap = -1;
            int careerID = -99;
            try {
                otherModProfession = splitEntry[0].trim();
            }
            catch (Exception e) {
                otherModProfession = "";
            }
            try {
                otherModID = splitEntry[1].trim();
            }
            catch (Exception e) {
                otherModID = "";
            }
            try {
                vanillaProfMap = Integer.parseInt(splitEntry[2].trim());
            }
            catch (Exception e) {
                vanillaProfMap = -1;
            }
            try {
                careerID = Integer.parseInt(splitEntry[3].trim());
            }
            catch (Exception e) {
                careerID = -99;
            }
            String IDs_concat_career = otherModID + careerID;
            if (otherModProfession.equals("") || otherModID.equals("")) continue;
            otherModProfessions.add(otherModProfession);
            otherModIDs.add(otherModID);
            vanillaProfMaps.add(vanillaProfMap);
            careerID_a.add(careerID);
            IDs_concat_careers.add(IDs_concat_career);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("Professions", otherModProfessions);
        map.put("IDs", otherModIDs);
        map.put("VanillaProfMaps", vanillaProfMaps);
        map.put("careerID", careerID_a);
        map.put("IDs_concat_careers", IDs_concat_careers);
        return map;
    }

    public static Map<String, List> unpackModStructures(String[] inputList) {
        ArrayList<String> otherModNameTypes = new ArrayList<String>();
        ArrayList<String> otherModStructureTypes = new ArrayList<String>();
        ArrayList<String> otherModStructureTitles = new ArrayList<String>();
        ArrayList<String> otherModDimensionNames = new ArrayList<String>();
        ArrayList<String> otherModBookTypes = new ArrayList<String>();
        ArrayList<String> otherModClassPaths = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String otherModNameType = "";
            String otherModStructureType = "FAILSAFE";
            String otherModStructureTitle = "";
            String otherModDimensionName = "";
            String otherModBookType = "";
            String otherModClassPath = "";
            try {
                otherModNameType = splitEntry[0].trim();
            }
            catch (Exception e) {
                otherModNameType = "";
            }
            try {
                otherModStructureType = splitEntry[1].trim();
            }
            catch (Exception e) {
                otherModStructureType = "FAILSAFE";
            }
            try {
                otherModStructureTitle = splitEntry[2].trim();
            }
            catch (Exception e) {
                otherModStructureTitle = "";
            }
            try {
                otherModDimensionName = splitEntry[3].trim();
            }
            catch (Exception e) {
                otherModDimensionName = "";
            }
            try {
                otherModBookType = splitEntry[4].trim();
            }
            catch (Exception e) {
                otherModBookType = "";
            }
            try {
                otherModClassPath = splitEntry[5].trim();
            }
            catch (Exception e) {
                otherModClassPath = "";
            }
            if (otherModNameType.equals("") || otherModStructureType.equals("") || otherModBookType.equals("")) continue;
            otherModNameTypes.add(otherModNameType);
            otherModStructureTypes.add(otherModStructureType);
            otherModStructureTitles.add(otherModStructureTitle);
            otherModDimensionNames.add(otherModDimensionName);
            otherModBookTypes.add(otherModBookType);
            otherModClassPaths.add(otherModClassPath);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("NameTypes", otherModNameTypes);
        map.put("StructureTypes", otherModStructureTypes);
        map.put("StructureTitles", otherModStructureTitles);
        map.put("DimensionNames", otherModDimensionNames);
        map.put("BookTypes", otherModBookTypes);
        map.put("ClassPaths", otherModClassPaths);
        return map;
    }

    public static Map<String, List> unpackMappedNames(String[] inputList) {
        ArrayList<String> otherModNameTypes = new ArrayList<String>();
        ArrayList<String> otherModProfessions = new ArrayList<String>();
        ArrayList<String> otherModClassPaths = new ArrayList<String>();
        ArrayList<String> addOrRemoveA = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String otherModNameType = "";
            String otherModProfession = "";
            String otherModClassPath = "";
            String addOrRemove = "";
            try {
                otherModNameType = splitEntry[0].trim();
            }
            catch (Exception e) {
                otherModNameType = "";
            }
            try {
                otherModProfession = splitEntry[1].trim();
            }
            catch (Exception e) {
                otherModProfession = "";
            }
            try {
                otherModClassPath = splitEntry[2].trim();
            }
            catch (Exception e) {
                otherModClassPath = "";
            }
            try {
                addOrRemove = splitEntry[3].trim();
            }
            catch (Exception e) {
                addOrRemove = "";
            }
            if (otherModClassPath.equals("") || otherModNameType.equals("")) continue;
            otherModClassPaths.add(otherModClassPath);
            otherModNameTypes.add(otherModNameType);
            otherModProfessions.add(otherModProfession);
            addOrRemoveA.add(addOrRemove);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("NameTypes", otherModNameTypes);
        map.put("Professions", otherModProfessions);
        map.put("ClassPaths", otherModClassPaths);
        map.put("AddOrRemove", addOrRemoveA);
        return map;
    }

    public static Map<String, List> unpackZombieCureCatalysts(String[] inputList) {
        ArrayList<String> zombieCureCatalystGroups = new ArrayList<String>();
        ArrayList<String> zombieCureCatalystClassPaths = new ArrayList<String>();
        ArrayList<String> zombieCureCatalystUnlocNames = new ArrayList<String>();
        ArrayList<Integer> zombieCureCatalystMetas = new ArrayList<Integer>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String zombieCureCatalystGroup = "";
            String zombieCureCatalystClassPath = "";
            String zombieCureCatalystUnlocName = "";
            int zombieCureCatalystMeta = -1;
            try {
                zombieCureCatalystGroup = splitEntry[0].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureCatalystClassPath = splitEntry[1].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureCatalystUnlocName = splitEntry[2].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureCatalystMeta = Integer.parseInt(splitEntry[3].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zombieCureCatalystGroup.equals("") || zombieCureCatalystClassPath.equals("")) continue;
            zombieCureCatalystGroups.add(zombieCureCatalystGroup);
            zombieCureCatalystClassPaths.add(zombieCureCatalystClassPath);
            zombieCureCatalystUnlocNames.add(zombieCureCatalystUnlocName);
            zombieCureCatalystMetas.add(zombieCureCatalystMeta);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("Groups", zombieCureCatalystGroups);
        map.put("ClassPaths", zombieCureCatalystClassPaths);
        map.put("UnlocNames", zombieCureCatalystUnlocNames);
        map.put("Metas", zombieCureCatalystMetas);
        return map;
    }

    public static Map<String, List> unpackZombieCureGroups(String[] inputList) {
        ArrayList<String> zombieCureGroupGroups = new ArrayList<String>();
        ArrayList<Double> zombieCureGroupSpeedups = new ArrayList<Double>();
        ArrayList<Integer> zombieCureGroupLimits = new ArrayList<Integer>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String zombieCureGroupGroup = "";
            double zombieCureGroupSpeedup = 0.0;
            int zombieCureGroupLimit = -1;
            try {
                zombieCureGroupGroup = splitEntry[0].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureGroupSpeedup = Double.parseDouble(splitEntry[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureGroupLimit = Integer.parseInt(splitEntry[2].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zombieCureGroupGroup.equals("")) continue;
            zombieCureGroupGroups.add(zombieCureGroupGroup);
            zombieCureGroupSpeedups.add(zombieCureGroupSpeedup);
            zombieCureGroupLimits.add(zombieCureGroupLimit);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("Groups", zombieCureGroupGroups);
        map.put("Speedups", zombieCureGroupSpeedups);
        map.put("Limits", zombieCureGroupLimits);
        return map;
    }

    public static Map<String, List> unpackModVillagerSkins(String[] inputList) {
        ArrayList<String> careerAsset_a = new ArrayList<String>();
        ArrayList<String> zombieCareerAsset_a = new ArrayList<String>();
        ArrayList<String> professionID_a = new ArrayList<String>();
        ArrayList<Integer> careerID_a = new ArrayList<Integer>();
        ArrayList<String> IDs_concat_careers = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("/", "");
            entry.replaceAll("\\\\", "");
            entry.replaceAll("..", "");
            String[] splitEntry = entry.split("\\|");
            String careerAsset = "";
            String zombieCareerAsset = "";
            String professionID = "";
            int careerID = -99;
            try {
                careerAsset = splitEntry[0].trim();
            }
            catch (Exception e) {
                careerAsset = "";
            }
            try {
                zombieCareerAsset = splitEntry[1].trim();
            }
            catch (Exception e) {
                zombieCareerAsset = "";
            }
            try {
                professionID = splitEntry[2].trim();
            }
            catch (Exception e) {
                professionID = "";
            }
            try {
                careerID = Integer.parseInt(splitEntry[3].trim());
            }
            catch (Exception e) {
                careerID = -99;
            }
            String IDs_concat_career = professionID + careerID;
            if (careerAsset.equals("")) continue;
            careerAsset_a.add(careerAsset);
            zombieCareerAsset_a.add(zombieCareerAsset);
            professionID_a.add(professionID);
            careerID_a.add(careerID);
            IDs_concat_careers.add(IDs_concat_career);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("careerAsset", careerAsset_a);
        map.put("zombieCareerAsset", zombieCareerAsset_a);
        map.put("professionID", professionID_a);
        map.put("careerID", careerID_a);
        map.put("IDs_concat_careers", IDs_concat_careers);
        return map;
    }

    public static Map<String, List> unpackModdedVillagerHeadwearGraylist(String[] inputList, boolean isWhitelist) {
        ArrayList<String> professionID_a = new ArrayList<String>();
        ArrayList<Integer> careerID_a = new ArrayList<Integer>();
        ArrayList<String> IDs_concat_careers = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("/", "");
            entry.replaceAll("\\\\", "");
            entry.replaceAll("..", "");
            String[] splitEntry = entry.split("\\|");
            String professionID = "";
            int careerID = -99;
            try {
                professionID = splitEntry[0].trim();
            }
            catch (Exception e) {
                professionID = "";
            }
            try {
                careerID = Integer.parseInt(splitEntry[1].trim());
            }
            catch (Exception e) {
                careerID = -99;
            }
            String IDs_concat_career = professionID + careerID;
            if (professionID.equals("") || (!isWhitelist || professionID.indexOf("-") == 0) && (isWhitelist || professionID.indexOf("-") != 0)) continue;
            if (isWhitelist && professionID.indexOf("-") != 0) {
                professionID_a.add(professionID);
                careerID_a.add(careerID);
                IDs_concat_careers.add(IDs_concat_career);
                continue;
            }
            if (isWhitelist || professionID.indexOf("-") != 0) continue;
            professionID_a.add(professionID.substring(1));
            careerID_a.add(careerID);
            IDs_concat_careers.add(IDs_concat_career);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("professionID", professionID_a);
        map.put("careerID", careerID_a);
        map.put("IDs_concat_careers", IDs_concat_careers);
        return map;
    }

    static {
        headerTags = "\u00a78\u00a7o";
        modNameMappingAutomatic_map = new HashMap<String, List>();
        modNameMappingClickable_map = new HashMap<String, List>();
        entitiesNameableLikePets_set = new HashSet<String>();
        modProfessionMapping_map = new HashMap<String, List>();
        modStructureNames_map = new HashMap<String, List>();
        moddedVillagerHeadwearWhitelist_map = new HashMap<String, List>();
        moddedVillagerHeadwearBlacklist_map = new HashMap<String, List>();
        moddedVillagerCareerSkins_map = new HashMap<String, List>();
        zombieCureCatalysts_map = new HashMap<String, List>();
        zombieCureGroups_map = new HashMap<String, List>();
    }
}

