/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.client.renderer.entity;

import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.capabilities.ModularSkinProvider;
import astrotibs.villagenames.client.model.ModelZombieVillagerModern;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.utility.Reference;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerVillagerArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderZombieVillagerModern
extends RenderBiped<EntityZombieVillager> {
    static final String ZVAD = "textures/entity/zombie_villager/";
    private static final ResourceLocation ZOMBIE_VILLAGER_BASE_SKIN = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "zombie_villager.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TIBS_SKIN = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "t_zv.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_DESERT = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/desert.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_JUNGLE = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/jungle.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_PLAINS = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/plains.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_SAVANNA = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/savanna.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_SNOW = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/snow.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_SWAMP = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/swamp.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_TAIGA = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/taiga.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_FOREST = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/forest.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_AQUATIC = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/aquatic.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_HIGHLAND = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/highland.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_MUSHROOM = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/mushroom.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_MAGICAL = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/magical.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_NETHER = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/nether.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TYPE_END = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "type/end.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_ARMORER = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/armorer.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_BUTCHER = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/butcher.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_CARTOGRAPHER = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/cartographer.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_CLERIC = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/cleric.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_FARMER = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/farmer.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_FISHERMAN = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/fisherman.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_FLETCHER = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/fletcher.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_LEATHERWORKER = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/leatherworker.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_LIBRARIAN = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/librarian.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_MASON = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/mason.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_NITWIT = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/nitwit.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_SHEPHERD = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/shepherd.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_TOOLSMITH = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/toolsmith.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_WEAPONSMITH = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession/weaponsmith.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_LEVEL_STONE = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession_level/stone.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_LEVEL_IRON = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession_level/iron.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_LEVEL_GOLD = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession_level/gold.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_LEVEL_EMERALD = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession_level/emerald.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PROFESSION_LEVEL_DIAMOND = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/zombie_villager/" + "profession_level/diamond.png");
    private static final ResourceLocation ZOMBIE_TEXTURE = new ResourceLocation("textures/entity/zombie/zombie.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TEXTURE = new ResourceLocation("textures/entity/zombie_villager/" + "zombie_villager.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_FARMER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/" + "zombie_farmer.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_LIBRARIAN_LOCATION = new ResourceLocation("textures/entity/zombie_villager/" + "zombie_librarian.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PRIEST_LOCATION = new ResourceLocation("textures/entity/zombie_villager/" + "zombie_priest.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_SMITH_LOCATION = new ResourceLocation("textures/entity/zombie_villager/" + "zombie_smith.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_BUTCHER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/" + "zombie_butcher.png");
    private ModelBiped modelBipedMain;
    private final ModelZombieVillagerModern zombieVillagerModel;
    private final List<LayerRenderer<EntityZombieVillager>> field_177121_n;
    private final List<LayerRenderer<EntityZombieVillager>> field_177122_o;

    public RenderZombieVillagerModern(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBiped)new ModelZombie(), 0.5f);
        this.func_177094_a(new LayerZombieVillagerBiomeType(this));
        this.func_177094_a(new LayerZombieVillagerProfession(this));
        LayerRenderer layerrenderer = (LayerRenderer)this.field_177097_h.get(0);
        this.modelBipedMain = new ModelBiped();
        this.zombieVillagerModel = new ModelZombieVillagerModern();
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        LayerBipedArmor layerbipedarmor = new LayerBipedArmor((RenderLivingBase)this){

            protected void func_177177_a() {
                this.field_177189_c = new ModelZombie(0.5f, true);
                this.field_177186_d = new ModelZombie(1.0f, true);
            }
        };
        this.func_177094_a((LayerRenderer)layerbipedarmor);
        this.field_177122_o = Lists.newArrayList((Iterable)this.field_177097_h);
        if (layerrenderer instanceof LayerCustomHead) {
            this.func_177094_a((LayerRenderer)new LayerCustomHead(this.zombieVillagerModel.field_78116_c));
        }
        this.func_177094_a((LayerRenderer)new LayerVillagerArmor((RenderLivingBase)this));
        this.field_177121_n = Lists.newArrayList((Iterable)this.field_177097_h);
    }

    public void doRender(EntityZombieVillager entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.func_82427_a(entity);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityZombieVillager zombievillager) {
        int profession;
        IModularSkin ims = (IModularSkin)zombievillager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
        String professionForge = zombievillager.getForgeProfession().getRegistryName().toString();
        int n = profession = ims == null ? -1 : ims.getProfession();
        if (GeneralConfig.modernVillagerSkins) {
            String trimmed_lc_zombievillager_name = zombievillager.func_95999_t().toLowerCase().trim();
            if (!trimmed_lc_zombievillager_name.equals("tibs") & !trimmed_lc_zombievillager_name.equals("astrotibs") & (trimmed_lc_zombievillager_name.length() < 11 || !trimmed_lc_zombievillager_name.substring(0, 11).equals("astrotibs (")) & (trimmed_lc_zombievillager_name.length() < 6 || !trimmed_lc_zombievillager_name.substring(0, 6).equals("tibs ("))) {
                return ZOMBIE_VILLAGER_BASE_SKIN;
            }
            return ZOMBIE_VILLAGER_TIBS_SKIN;
        }
        switch (profession) {
            case 0: {
                return ZOMBIE_VILLAGER_FARMER_LOCATION;
            }
            case 1: {
                return ZOMBIE_VILLAGER_LIBRARIAN_LOCATION;
            }
            case 2: {
                return ZOMBIE_VILLAGER_PRIEST_LOCATION;
            }
            case 3: {
                return ZOMBIE_VILLAGER_SMITH_LOCATION;
            }
            case 4: {
                return ZOMBIE_VILLAGER_BUTCHER_LOCATION;
            }
        }
        return ZOMBIE_VILLAGER_TEXTURE;
    }

    private void func_82427_a(EntityZombieVillager zombie) {
        this.field_77045_g = this.zombieVillagerModel;
        this.field_177097_h = this.field_177121_n;
        this.modelBipedMain = (ModelBiped)this.field_77045_g;
    }

    protected void applyRotations(EntityZombieVillager entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (entityLiving.func_82230_o()) {
            p_77043_3_ += (float)(Math.cos((double)entityLiving.field_70173_aa * 3.25) * Math.PI * 0.25);
        }
        super.func_77043_a((EntityLivingBase)entityLiving, p_77043_2_, p_77043_3_, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerZombieVillagerProfession
    implements LayerRenderer<EntityZombieVillager> {
        private final RenderZombieVillagerModern zombieVillagerLayerRenderer;
        private final ModelZombieVillagerModern zombieVillagerLayerModel = new ModelZombieVillagerModern(0.0f, 0.2f, false);

        public LayerZombieVillagerProfession(RenderZombieVillagerModern villagerRenderIn) {
            this.zombieVillagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityZombieVillager zombie, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            IModularSkin ims = (IModularSkin)zombie.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
            int profession = ims == null ? -1 : ims.getProfession();
            if (profession >= 0 & !zombie.func_82150_aj() & !zombie.func_70631_g_()) {
                String professionForge = zombie.getForgeProfession().getRegistryName().toString();
                if (Reference.VANILLA_PROFESSIONS.contains(professionForge)) {
                    if (GeneralConfig.modernVillagerSkins) {
                        int career = ims.getCareer();
                        block0 : switch (profession) {
                            case 0: {
                                switch (career) {
                                    default: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_FARMER);
                                        break block0;
                                    }
                                    case 2: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_FISHERMAN);
                                        break block0;
                                    }
                                    case 3: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_SHEPHERD);
                                        break block0;
                                    }
                                    case 4: 
                                }
                                this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_FLETCHER);
                                break;
                            }
                            case 1: {
                                switch (career) {
                                    default: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_LIBRARIAN);
                                        break block0;
                                    }
                                    case 2: 
                                }
                                this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_CARTOGRAPHER);
                                break;
                            }
                            case 2: {
                                switch (career) {
                                    default: 
                                }
                                this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_CLERIC);
                                break;
                            }
                            case 3: {
                                switch (career) {
                                    case 1: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_ARMORER);
                                        break block0;
                                    }
                                    case 2: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_WEAPONSMITH);
                                        break block0;
                                    }
                                    default: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_TOOLSMITH);
                                        break block0;
                                    }
                                    case 4: 
                                }
                                this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_MASON);
                                break;
                            }
                            case 4: {
                                switch (career) {
                                    default: {
                                        this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_BUTCHER);
                                        break block0;
                                    }
                                    case 2: 
                                }
                                this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_LEATHERWORKER);
                                break;
                            }
                            default: {
                                switch (career) {
                                    default: 
                                }
                                this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_PROFESSION_NITWIT);
                                break;
                            }
                        }
                    }
                } else {
                    int careerID = ims == null ? -1 : ims.getCareer();
                    int index_of_profession_and_career = Math.max(GeneralConfig.profession_concat_career_a.indexOf(professionForge + -99), GeneralConfig.profession_concat_career_a.indexOf(professionForge + careerID));
                    if (index_of_profession_and_career != -1) {
                        String zombieCareerProfRootname = GeneralConfig.zombieCareerAsset_a.get(index_of_profession_and_career);
                        String careerProfRootname = GeneralConfig.careerAsset_a.get(index_of_profession_and_career);
                        if (!zombieCareerProfRootname.equals("")) {
                            ResourceLocation modCareerSkin = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/villager/profession/" + zombieCareerProfRootname + ".png");
                            this.zombieVillagerLayerRenderer.func_110776_a(modCareerSkin);
                        } else if (!careerProfRootname.equals("")) {
                            ResourceLocation modCareerSkin = new ResourceLocation("villagenames".toLowerCase(), "textures/entity/villager/profession/" + careerProfRootname + ".png");
                            this.zombieVillagerLayerRenderer.func_110776_a(modCareerSkin);
                        }
                    }
                }
                this.zombieVillagerLayerModel.func_178686_a(this.zombieVillagerLayerRenderer.func_177087_b());
                this.zombieVillagerLayerModel.func_78088_a((Entity)zombie, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerZombieVillagerBiomeType
    implements LayerRenderer<EntityZombieVillager> {
        private final RenderZombieVillagerModern zombieVillagerLayerRenderer;
        private final ModelZombieVillagerModern zombieVillagerLayerModel = new ModelZombieVillagerModern(0.0f, 0.1f, false);

        public LayerZombieVillagerBiomeType(RenderZombieVillagerModern villagerRenderIn) {
            this.zombieVillagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityZombieVillager zombie, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            IModularSkin ims = (IModularSkin)zombie.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
            if (!zombie.func_82150_aj()) {
                if (GeneralConfig.modernVillagerSkins) {
                    switch (ims.getBiomeType()) {
                        case 11: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_SNOW);
                            break;
                        }
                        case 9: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_SAVANNA);
                            break;
                        }
                        case 8: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_DESERT);
                            break;
                        }
                        case 3: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_FOREST);
                            break;
                        }
                        case 7: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_TAIGA);
                            break;
                        }
                        case 6: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_SWAMP);
                            break;
                        }
                        case 5: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_JUNGLE);
                            break;
                        }
                        case 4: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_AQUATIC);
                            break;
                        }
                        case 2: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_HIGHLAND);
                            break;
                        }
                        case 10: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_MUSHROOM);
                            break;
                        }
                        case 1: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_MAGICAL);
                            break;
                        }
                        case 13: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_NETHER);
                            break;
                        }
                        case 12: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_END);
                            break;
                        }
                        default: {
                            this.zombieVillagerLayerRenderer.func_110776_a(ZOMBIE_VILLAGER_TYPE_PLAINS);
                        }
                    }
                }
                this.zombieVillagerLayerModel.func_178686_a(this.zombieVillagerLayerRenderer.func_177087_b());
                this.zombieVillagerLayerModel.func_78088_a((Entity)zombie, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

