/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.client.renderer.entity;

import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.capabilities.ModularSkinProvider;
import astrotibs.villagenames.client.model.ModelVillagerModern;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.utility.Reference;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderVillagerModern
extends RenderLiving<EntityVillager> {
    static final String VAD = "textures/entity/villager/";
    static final String MIDLC = "villagenames".toLowerCase();
    private static final ResourceLocation VILLAGER_BASE_SKIN = new ResourceLocation(MIDLC, "textures/entity/villager/" + "villager.png");
    private static final ResourceLocation VILLAGER_TYPE_DESERT = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/desert.png");
    private static final ResourceLocation VILLAGER_TYPE_JUNGLE = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/jungle.png");
    private static final ResourceLocation VILLAGER_TYPE_PLAINS = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/plains.png");
    private static final ResourceLocation VILLAGER_TYPE_SAVANNA = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/savanna.png");
    private static final ResourceLocation VILLAGER_TYPE_SNOW = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/snow.png");
    private static final ResourceLocation VILLAGER_TYPE_SWAMP = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/swamp.png");
    private static final ResourceLocation VILLAGER_TYPE_TAIGA = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/taiga.png");
    private static final ResourceLocation VILLAGER_TYPE_FOREST = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/forest.png");
    private static final ResourceLocation VILLAGER_TYPE_AQUATIC = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/aquatic.png");
    private static final ResourceLocation VILLAGER_TYPE_HIGHLAND = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/highland.png");
    private static final ResourceLocation VILLAGER_TYPE_MUSHROOM = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/mushroom.png");
    private static final ResourceLocation VILLAGER_TYPE_MAGICAL = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/magical.png");
    private static final ResourceLocation VILLAGER_TYPE_NETHER = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/nether.png");
    private static final ResourceLocation VILLAGER_TYPE_END = new ResourceLocation(MIDLC, "textures/entity/villager/" + "type/end.png");
    private static final ResourceLocation VILLAGER_PROFESSION_ARMORER = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/armorer.png");
    private static final ResourceLocation VILLAGER_PROFESSION_BUTCHER = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/butcher.png");
    private static final ResourceLocation VILLAGER_PROFESSION_CARTOGRAPHER = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/cartographer.png");
    private static final ResourceLocation VILLAGER_PROFESSION_CLERIC = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/cleric.png");
    private static final ResourceLocation VILLAGER_PROFESSION_FARMER = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/farmer.png");
    private static final ResourceLocation VILLAGER_PROFESSION_FISHERMAN = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/fisherman.png");
    private static final ResourceLocation VILLAGER_PROFESSION_FLETCHER = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/fletcher.png");
    private static final ResourceLocation VILLAGER_PROFESSION_LEATHERWORKER = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/leatherworker.png");
    private static final ResourceLocation VILLAGER_PROFESSION_LIBRARIAN = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/librarian.png");
    private static final ResourceLocation VILLAGER_PROFESSION_MASON = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/mason.png");
    private static final ResourceLocation VILLAGER_PROFESSION_NITWIT = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/nitwit.png");
    private static final ResourceLocation VILLAGER_PROFESSION_SHEPHERD = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/shepherd.png");
    private static final ResourceLocation VILLAGER_PROFESSION_TOOLSMITH = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/toolsmith.png");
    private static final ResourceLocation VILLAGER_PROFESSION_WEAPONSMITH = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession/weaponsmith.png");
    private static final ResourceLocation VILLAGER_PROFESSION_LEVEL_STONE = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession_level/stone.png");
    private static final ResourceLocation VILLAGER_PROFESSION_LEVEL_IRON = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession_level/iron.png");
    private static final ResourceLocation VILLAGER_PROFESSION_LEVEL_GOLD = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession_level/gold.png");
    private static final ResourceLocation VILLAGER_PROFESSION_LEVEL_EMERALD = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession_level/emerald.png");
    private static final ResourceLocation VILLAGER_PROFESSION_LEVEL_DIAMOND = new ResourceLocation(MIDLC, "textures/entity/villager/" + "profession_level/diamond.png");
    private static final ResourceLocation DEFAULT_OLD_NITWIT = new ResourceLocation("textures/entity/villager/" + "villager.png");
    private static final ResourceLocation DEFAULT_OLD_FARMER = new ResourceLocation("textures/entity/villager/" + "farmer.png");
    private static final ResourceLocation DEFAULT_OLD_LIBRARIAN = new ResourceLocation("textures/entity/villager/" + "librarian.png");
    private static final ResourceLocation DEFAULT_OLD_PRIEST = new ResourceLocation("textures/entity/villager/" + "priest.png");
    private static final ResourceLocation DEFAULT_OLD_SMITH = new ResourceLocation("textures/entity/villager/" + "smith.png");
    private static final ResourceLocation DEFAULT_OLD_BUTCHER = new ResourceLocation("textures/entity/villager/" + "butcher.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_LIGHT3 = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/l3.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_LIGHT2 = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/l2.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_LIGHT1 = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/l1.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_MEDIUM = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/m0.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_DARK1 = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/d1.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_DARK2 = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/d2.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_DARK3 = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/d3.png");
    private static final ResourceLocation VILLAGER_SKIN_TONE_DARK4 = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/d4.png");
    private static final ResourceLocation VILLAGER_SKIN_TIBS = new ResourceLocation(MIDLC, "textures/entity/villager/" + "skintone/t_v.png");

    public RenderVillagerModern(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelVillagerModern(0.0f), 0.5f);
        this.func_177094_a(new LayerVillagerBiomeType(this));
        this.func_177094_a(new LayerVillagerProfession(this));
        this.func_177094_a(new LayerVillagerProfessionLevel(this));
    }

    protected ResourceLocation getEntityTexture(EntityVillager villager) {
        String professionForge = villager.getProfessionForge().getRegistryName().toString();
        int career = ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getCareer();
        int indexofmodprof = GeneralConfig.professionID_a.indexOf(professionForge);
        int profession = villager.func_70946_n();
        if (GeneralConfig.modernVillagerSkins & Reference.VANILLA_PROFESSIONS.contains(professionForge) | GeneralConfig.profession_concat_career_a.contains(professionForge + -99) | GeneralConfig.profession_concat_career_a.contains(professionForge + career)) {
            String trimmed_lc_villager_name = villager.func_95999_t().toLowerCase().trim();
            if (!trimmed_lc_villager_name.equals("tibs") & !trimmed_lc_villager_name.equals("astrotibs") & (trimmed_lc_villager_name.length() < 11 || !trimmed_lc_villager_name.substring(0, 11).equals("astrotibs (")) & (trimmed_lc_villager_name.length() < 6 || !trimmed_lc_villager_name.substring(0, 6).equals("tibs ("))) {
                if (GeneralConfig.villagerSkinTones) {
                    switch (((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getSkinTone()) {
                        case 3: {
                            return VILLAGER_SKIN_TONE_LIGHT3;
                        }
                        case 2: {
                            return VILLAGER_SKIN_TONE_LIGHT2;
                        }
                        case 1: {
                            return VILLAGER_SKIN_TONE_LIGHT1;
                        }
                        default: {
                            return VILLAGER_SKIN_TONE_MEDIUM;
                        }
                        case -1: {
                            return VILLAGER_SKIN_TONE_DARK1;
                        }
                        case -2: {
                            return VILLAGER_SKIN_TONE_DARK2;
                        }
                        case -3: {
                            return VILLAGER_SKIN_TONE_DARK3;
                        }
                        case -4: 
                    }
                    return VILLAGER_SKIN_TONE_DARK4;
                }
                return VILLAGER_BASE_SKIN;
            }
            return VILLAGER_SKIN_TIBS;
        }
        switch (profession) {
            case 0: {
                return DEFAULT_OLD_FARMER;
            }
            case 1: {
                return DEFAULT_OLD_LIBRARIAN;
            }
            case 2: {
                return DEFAULT_OLD_PRIEST;
            }
            case 3: {
                return DEFAULT_OLD_SMITH;
            }
            case 4: {
                return DEFAULT_OLD_BUTCHER;
            }
        }
        return villager.getProfessionForge().getSkin();
    }

    protected void preRenderCallback(EntityVillager entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375f;
        if (entitylivingbaseIn.func_70874_b() < 0) {
            f = (float)((double)f * 0.5);
            this.field_76989_e = 0.25f;
        } else {
            this.field_76989_e = 0.5f;
        }
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerVillagerProfessionLevel
    implements LayerRenderer<EntityVillager> {
        private final RenderVillagerModern villagerLayerRenderer;
        private final ModelVillagerModern villagerLayerModel = new ModelVillagerModern(0.3f);

        public LayerVillagerProfessionLevel(RenderVillagerModern villagerRenderIn) {
            this.villagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityVillager villager, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            int profession = villager.func_70946_n();
            String professionForge = villager.getProfessionForge().getRegistryName().toString();
            int careerID = ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getCareer();
            int index_of_profession_and_career = Math.max(GeneralConfig.profession_concat_career_a.indexOf(professionForge + -99), GeneralConfig.profession_concat_career_a.indexOf(professionForge + careerID));
            if ((Reference.VANILLA_PROFESSIONS.contains(professionForge) | index_of_profession_and_career > -1) & !villager.func_82150_aj()) {
                if (GeneralConfig.modernVillagerSkins) {
                    int profLevel;
                    int n = profLevel = villager.func_70631_g_() | profession == 5 ? 0 : ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getProfessionLevel();
                    if (profLevel >= 5) {
                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_LEVEL_DIAMOND);
                    }
                    switch (profLevel) {
                        case 1: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_LEVEL_STONE);
                            break;
                        }
                        case 2: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_LEVEL_IRON);
                            break;
                        }
                        case 3: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_LEVEL_GOLD);
                            break;
                        }
                        case 4: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_LEVEL_EMERALD);
                        }
                    }
                }
                this.villagerLayerRenderer.func_177087_b().func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
                this.villagerLayerModel.func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerVillagerProfession
    implements LayerRenderer<EntityVillager> {
        private final RenderVillagerModern villagerLayerRenderer;
        private final ModelVillagerModern villagerLayerModel = new ModelVillagerModern(0.2f);

        public LayerVillagerProfession(RenderVillagerModern villagerRenderIn) {
            this.villagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityVillager villager, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            int profession = villager.func_70946_n();
            if (profession >= 0 & !villager.func_82150_aj() & !villager.func_70631_g_()) {
                String professionForge = villager.getProfessionForge().getRegistryName().toString();
                if (Reference.VANILLA_PROFESSIONS.contains(professionForge)) {
                    if (GeneralConfig.modernVillagerSkins) {
                        int career = ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getCareer();
                        block0 : switch (profession) {
                            case 0: {
                                switch (career) {
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_FARMER);
                                        break block0;
                                    }
                                    case 2: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_FISHERMAN);
                                        break block0;
                                    }
                                    case 3: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_SHEPHERD);
                                        break block0;
                                    }
                                    case 4: 
                                }
                                this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_FLETCHER);
                                break;
                            }
                            case 1: {
                                switch (career) {
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_LIBRARIAN);
                                        break block0;
                                    }
                                    case 2: 
                                }
                                this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_CARTOGRAPHER);
                                break;
                            }
                            case 2: {
                                switch (career) {
                                    default: 
                                }
                                this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_CLERIC);
                                break;
                            }
                            case 3: {
                                switch (career) {
                                    case 1: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_ARMORER);
                                        break block0;
                                    }
                                    case 2: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_WEAPONSMITH);
                                        break block0;
                                    }
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_TOOLSMITH);
                                        break block0;
                                    }
                                    case 4: 
                                }
                                this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_MASON);
                                break;
                            }
                            case 4: {
                                switch (career) {
                                    default: {
                                        this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_BUTCHER);
                                        break block0;
                                    }
                                    case 2: 
                                }
                                this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_LEATHERWORKER);
                                break;
                            }
                            case 5: {
                                switch (career) {
                                    default: 
                                }
                                this.villagerLayerRenderer.func_110776_a(VILLAGER_PROFESSION_NITWIT);
                                break;
                            }
                        }
                    }
                } else {
                    int careerID = ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getCareer();
                    int index_of_profession_and_career = Math.max(GeneralConfig.profession_concat_career_a.indexOf(professionForge + -99), GeneralConfig.profession_concat_career_a.indexOf(professionForge + careerID));
                    if (index_of_profession_and_career > -1) {
                        String profRootName = GeneralConfig.careerAsset_a.get(index_of_profession_and_career);
                        ResourceLocation modCareerSkin = new ResourceLocation(MIDLC, RenderVillagerModern.VAD + "profession/" + profRootName + ".png");
                        this.villagerLayerRenderer.func_110776_a(modCareerSkin);
                    }
                }
                this.villagerLayerRenderer.func_177087_b().func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
                this.villagerLayerModel.func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerVillagerBiomeType
    implements LayerRenderer<EntityVillager> {
        private final RenderVillagerModern villagerLayerRenderer;
        private final ModelVillagerModern villagerLayerModel = new ModelVillagerModern(0.1f);

        public LayerVillagerBiomeType(RenderVillagerModern villagerRenderIn) {
            this.villagerLayerRenderer = villagerRenderIn;
        }

        public void doRenderLayer(EntityVillager villager, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
            int profession = villager.func_70946_n();
            String professionForge = villager.getProfessionForge().getRegistryName().toString();
            int indexofmodprof = GeneralConfig.professionID_a.indexOf(professionForge);
            int careerID = ((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getCareer();
            if ((Reference.VANILLA_PROFESSIONS.contains(professionForge) | GeneralConfig.profession_concat_career_a.contains(professionForge + -99) | GeneralConfig.profession_concat_career_a.contains(professionForge + careerID)) & !villager.func_82150_aj()) {
                if (GeneralConfig.modernVillagerSkins) {
                    switch (((IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null)).getBiomeType()) {
                        case 11: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_SNOW);
                            break;
                        }
                        case 9: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_SAVANNA);
                            break;
                        }
                        case 8: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_DESERT);
                            break;
                        }
                        case 3: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_FOREST);
                            break;
                        }
                        case 7: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_TAIGA);
                            break;
                        }
                        case 6: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_SWAMP);
                            break;
                        }
                        case 5: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_JUNGLE);
                            break;
                        }
                        case 4: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_AQUATIC);
                            break;
                        }
                        case 2: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_HIGHLAND);
                            break;
                        }
                        case 10: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_MUSHROOM);
                            break;
                        }
                        case 1: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_MAGICAL);
                            break;
                        }
                        case 13: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_NETHER);
                            break;
                        }
                        case 12: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_END);
                            break;
                        }
                        default: {
                            this.villagerLayerRenderer.func_110776_a(VILLAGER_TYPE_PLAINS);
                        }
                    }
                }
                this.villagerLayerModel.func_178686_a(this.villagerLayerRenderer.func_177087_b());
                this.villagerLayerModel.func_78088_a((Entity)villager, p_177141_2_, p_177141_3_, p_177141_5_, p_177141_6_, p_177141_7_, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

