/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.block;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.block.BlockLunarinGold;
import astrotibs.villagenames.block.BlockLunarinIron;
import astrotibs.villagenames.config.GeneralConfig;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocksVN {
    public static final Block LUNARIN_GOLD_BRICK = new BlockLunarinGold("lunaringoldbrick");
    public static final Block LUNARIN_IRON_BRICK = new BlockLunarinIron("lunarinironbrick");

    public static void init() {
        if (GeneralConfig.addLunarinBlocks) {
            ModBlocksVN.registerBlock(LUNARIN_GOLD_BRICK, "lunaringoldbrick", CreativeTabs.field_78030_b, true);
            ModBlocksVN.registerBlock(LUNARIN_IRON_BRICK, "lunarinironbrick", CreativeTabs.field_78030_b, true);
        }
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab, boolean registerItemModels) {
        block.func_149663_c("villagenames".toLowerCase() + ":" + blockName);
        block.func_149647_a(tab);
        ModBlocksVN.registerBlockWithItem(block, blockName, ItemBlock.class);
        ModBlocksVN.registerBlockItemModel(block, blockName, 0);
        return block;
    }

    private static void registerBlockWithItem(Block block, String blockName, Class<? extends ItemBlock> clazz) {
        try {
            Item itemBlock = clazz != null ? (Item)clazz.getConstructor(Block.class).newInstance(block) : null;
            ResourceLocation location = new ResourceLocation("villagenames", blockName);
            block.setRegistryName(new ResourceLocation("villagenames", blockName));
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            if (itemBlock != null) {
                itemBlock.setRegistryName(new ResourceLocation("villagenames", blockName));
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred associating an item block during registration of " + blockName, e);
        }
    }

    public static void registerBlockItemModel(Block block, String stateName, int stateMeta) {
        Item item = Item.func_150898_a((Block)block);
        VillageNames.PROXY.registerItemVariantModel(item, stateName, stateMeta);
    }

    public static Item registerItem(Item item, String name, CreativeTabs tab) {
        item.func_77655_b(name);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        item.setRegistryName(new ResourceLocation("villagenames", name));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        VillageNames.PROXY.registerItemSided(item);
        return item;
    }
}

