/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.blocks.BlockRedLargeMushroom;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.config.ConfigLoader;
import paulevs.betternether.structures.IStructure;

public class StructureMedRedMushroom
implements IStructure {
    @Override
    public void generate(World world, BlockPos pos, Random random) {
        Block under = world.func_180495_p(pos).func_177230_c();
        if (ConfigLoader.isTerrain(under) || under == Blocks.field_150425_aM) {
            for (int i = 0; i < 10; ++i) {
                BlockPos npos;
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                int z = pos.func_177952_p() + (int)(random.nextGaussian() * 2.0);
                int y = pos.func_177956_o() + random.nextInt(6);
                for (int j = 0; j < 6 && (npos = new BlockPos(x, y - j, z)).func_177956_o() > 31; ++j) {
                    under = world.func_180495_p(npos.func_177977_b()).func_177230_c();
                    if (under != BlocksRegister.BLOCK_NETHER_MYCELIUM) continue;
                    this.grow(world, npos.func_177977_b(), random);
                }
            }
        }
    }

    private void grow(World chunk, BlockPos pos, Random random) {
        int size = 2 + random.nextInt(3);
        for (int y = 1; y <= size; ++y) {
            if (chunk.func_180495_p(pos.func_177981_b(y)).func_177230_c() == Blocks.field_150350_a) continue;
            size = y - 1;
            break;
        }
        if (size > 2) {
            IBlockState middle = BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)BlockRedLargeMushroom.EnumShape.MIDDLE));
            for (int y = 2; y < size; ++y) {
                chunk.func_175656_a(pos.func_177981_b(y), middle);
            }
            chunk.func_175656_a(pos.func_177981_b(size), BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)BlockRedLargeMushroom.EnumShape.TOP)));
            chunk.func_175656_a(pos.func_177984_a(), BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P());
        }
    }
}

