/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.city;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.noise.PregennedOpenSimplexNoise;
import paulevs.betternether.structures.big.BigStructure;
import paulevs.betternether.structures.big.StructureManager;
import paulevs.betternether.structures.city.BigStructureCity;
import paulevs.betternether.structures.city.CityGenerator;

public class CityStructureManager
extends StructureManager {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected CityGenerator generator = new CityGenerator();
    private PregennedOpenSimplexNoise noise;

    public CityStructureManager(long seed) {
        super("city", 80, seed);
        this.random.setSeed(seed);
    }

    @Override
    protected BigStructureCity makeStructure(int cx, int cz) {
        this.setSeed(cx, cz);
        BlockPos pos = new BlockPos(cx << 4, 40, cz << 4);
        return this.makeStructure(cx, cz, new BigStructureCity(pos, cx, cz, this.generator, this.random));
    }

    protected BigStructureCity makeStructure(int cx, int cz, BigStructureCity structure) {
        this.setSeed(cx, cz);
        BlockPos pos = new BlockPos(cx << 4, 40, cz << 4);
        BigStructureCity cave = new BigStructureCity(pos, cx, cz, this.generator, this.random);
        cave = structure;
        int caveSize = (int)((double)cave.getCitySide() * 0.6) + this.random.nextInt(50);
        this.makeCave(caveSize, 40, cave);
        List<BlockPos> positions = cave.getPosList(pos);
        List<Integer> radiuses = cave.getRadiuses();
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos cp = positions.get(i);
            int r = radiuses.get(i);
            this.makeCave(r, cp.func_177958_n(), cp.func_177956_o(), cp.func_177952_p(), cave);
        }
        return cave;
    }

    protected void makeCave(int radius, int centerY, BigStructure structure) {
        int bounds = (int)((double)radius * 1.5);
        radius = (int)((double)radius * 0.8);
        int rr = radius * radius;
        int minY = 5 - centerY;
        int lavaH = 31 - centerY;
        int height = Math.abs(minY) + radius;
        int noiseBounds = Math.max(bounds * 2, height);
        this.noise = new PregennedOpenSimplexNoise(noiseBounds, noiseBounds, new OpenSimplexNoise(this.random.nextLong()));
        for (int x = -bounds; x < bounds; ++x) {
            for (int y = minY; y < radius; ++y) {
                int wy = y + centerY - 40;
                int y2 = y * 2;
                for (int z = -bounds; z < bounds; ++z) {
                    double nz;
                    double zz;
                    double ny;
                    double yy;
                    double nx = this.warp(x, y - minY, z + bounds);
                    double xx = nx * nx;
                    if (!(xx + (yy = (ny = this.warp(y2, x + bounds, z + bounds)) * ny) + (zz = (nz = this.warp(z, x + bounds, y - minY)) * nz) < (double)rr)) continue;
                    if (wy > lavaH) {
                        structure.setBlock(AIR, new BlockPos(x, wy, z));
                        continue;
                    }
                    structure.setBlock(LAVA, new BlockPos(x, wy, z));
                }
            }
        }
    }

    protected void makeCave(int radius, int centerX, int centerY, int centerZ, BigStructure structure) {
        int bounds = (int)((double)radius * 1.5);
        radius = (int)((double)radius * 0.8);
        int rr = radius * radius;
        int minY = 5 - centerY;
        int lavaH = 31 - centerY;
        int height = Math.abs(minY) + bounds;
        int noiseBounds = Math.max(bounds * 2, height);
        this.noise = new PregennedOpenSimplexNoise(noiseBounds, noiseBounds, new OpenSimplexNoise(this.random.nextLong()));
        for (int x = -bounds; x < bounds; ++x) {
            int wx = x + centerX;
            for (int y = minY; y < bounds; ++y) {
                double y2 = y * 2;
                int wy = y + centerY - 40;
                for (int z = -bounds; z < bounds; ++z) {
                    double nz;
                    double zz;
                    double ny;
                    double yy;
                    int wz = z + centerZ;
                    double nx = this.warp(x, y - minY, z + bounds);
                    double xx = nx * nx;
                    if (!(xx + (yy = (ny = this.warp(y2, x + bounds, z + bounds)) * ny) + (zz = (nz = this.warp(z, x + bounds, y - minY)) * nz) < (double)rr)) continue;
                    if (wy > lavaH) {
                        structure.setBlock(AIR, new BlockPos(wx, wy, wz));
                        continue;
                    }
                    structure.setBlock(LAVA, new BlockPos(wx, wy, wz));
                }
            }
        }
    }

    private double warp(double val, int nx, int ny) {
        return val + this.noise.eval(nx, ny) * 5.0;
    }

    @Override
    public void load(World world) {
        String path = world.func_72860_G().func_75765_b().getAbsolutePath() + "/data/bn_" + this.name + ".nbt";
        File file = new File(path);
        if (file.exists()) {
            try {
                FileInputStream fs = new FileInputStream(file);
                NBTTagCompound root = CompressedStreamTools.func_74796_a((InputStream)fs);
                fs.close();
                NBTTagList structureData = root.func_150295_c("structures", 10);
                for (int i = 0; i < structureData.func_74745_c(); ++i) {
                    BigStructureCity city = new BigStructureCity(structureData.func_150305_b(i), this.generator);
                    if (!city.generationComplete()) {
                        this.makeStructure(city.getChunkX(), city.getChunkZ(), city);
                    }
                    this.structures.add(city);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

