/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.city;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import paulevs.betternether.structures.big.BigStructure;
import paulevs.betternether.structures.city.BuildingInfo;
import paulevs.betternether.structures.city.CityGenerator;

public class BigStructureCity
extends BigStructure {
    private static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected CityGenerator generator;
    protected ArrayList<BuildingInfo> buildings;

    public BigStructureCity(BlockPos pos, int cx, int cz, CityGenerator generator, Random random) {
        super(pos, cx, cz);
        this.generator = generator;
        this.buildings = generator.generate(pos, random);
    }

    public int getChunkX() {
        return this.cx;
    }

    public int getChunkZ() {
        return this.cz;
    }

    public BigStructureCity(NBTTagCompound structure, CityGenerator generator) {
        super(structure);
        NBTTagList builds = structure.func_150295_c("buildings", 10);
        this.buildings = new ArrayList();
        for (int i = 0; i < builds.func_74745_c(); ++i) {
            this.buildings.add(new BuildingInfo(builds.func_150305_b(i), generator.getBuildings()));
        }
    }

    @Override
    public NBTTagCompound toNBT() {
        NBTTagCompound root = super.toNBT();
        NBTTagList builds = new NBTTagList();
        root.func_74782_a("buildings", (NBTBase)builds);
        for (BuildingInfo b : this.buildings) {
            builds.func_74742_a((NBTBase)b.toNBT());
        }
        return root;
    }

    @Override
    public boolean setChunk(World world, int cx, int cz) {
        if (super.setChunk(world, cx, cz)) {
            int sx = cx << 4 | 8;
            int sz = cz << 4 | 8;
            StructureBoundingBox boundingBox = new StructureBoundingBox(sx, 0, sz, sx + 15, 256, sz + 15);
            for (BuildingInfo b : this.buildings) {
                b.building.placeInChunk(world, b.pos, boundingBox);
            }
            for (int y = 5; y < 32; ++y) {
                for (int x = 0; x < 16; ++x) {
                    int wx = x + sx;
                    for (int z = 0; z < 16; ++z) {
                        int wz = z + sz;
                        BlockPos pos = new BlockPos(wx, y, wz);
                        Block b = world.func_180495_p(pos).func_177230_c();
                        if (b != Blocks.field_150356_k) continue;
                        world.func_180501_a(pos, LAVA, 18);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public List<BlockPos> getPosList(BlockPos pos) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (BuildingInfo bi : this.buildings) {
            BlockPos center = bi.building.getBoungingBox().getCenter();
            center = center.func_177971_a((Vec3i)bi.pos).func_177973_b((Vec3i)pos);
            center = center.func_177982_a(0, 40 - center.func_177956_o(), 0);
            positions.add(center);
        }
        return positions;
    }

    public List<Integer> getRadiuses() {
        ArrayList<Integer> rad = new ArrayList<Integer>();
        for (BuildingInfo bi : this.buildings) {
            int sideX = bi.building.getBoungingBox().getSideX();
            int sideZ = bi.building.getBoungingBox().getSideZ();
            rad.add(Math.max(sideX, sideZ));
        }
        return rad;
    }

    public int getCitySide() {
        BuildingInfo info = this.buildings.get(0);
        int minX = info.pos.func_177958_n();
        int maxX = info.building.getBoungingBox().getMaxX() + info.pos.func_177958_n();
        int minZ = info.pos.func_177952_p();
        int maxZ = info.building.getBoungingBox().getMaxZ() + info.pos.func_177952_p();
        for (BuildingInfo bi : this.buildings) {
            minX = Math.min(minX, bi.pos.func_177958_n());
            maxX = Math.max(maxX, bi.building.getBoungingBox().getMaxX() + bi.pos.func_177958_n());
            minZ = Math.min(minZ, bi.pos.func_177952_p());
            maxZ = Math.max(maxZ, bi.building.getBoungingBox().getMinZ() + bi.pos.func_177952_p());
        }
        return Math.max(maxX - minX, maxZ - minZ);
    }
}

