/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.big;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.structures.big.StructureChunk;
import paulevs.betternether.structures.big.StructurePos;

public class BigStructure {
    protected HashMap<StructurePos, StructureChunk> data = new HashMap();
    protected int chunksGenerated = 0;
    protected int chunksMax = 0;
    protected BlockPos pos;
    protected int maxHeight = 0;
    protected int minHeight = 0;
    protected int chunkMinX = 0;
    protected int chunkMaxX = 0;
    protected int chunkMinZ = 0;
    protected int chunkMaxZ = 0;
    protected int cx;
    protected int cz;

    public BigStructure(BlockPos pos, int cx, int cz) {
        this.pos = pos;
        this.maxHeight = pos.func_177956_o();
        this.minHeight = pos.func_177956_o();
        this.cx = cx;
        this.cz = cz;
        this.chunkMaxX = this.chunkMinX = pos.func_177958_n() >> 4;
        this.chunkMaxZ = this.chunkMinZ = pos.func_177952_p() >> 4;
    }

    public BigStructure(NBTTagCompound structure) {
        this.chunksGenerated = structure.func_74762_e("chunksGenerated");
        this.chunksMax = structure.func_74762_e("chunksMax");
        this.maxHeight = structure.func_74762_e("maxHeight");
        this.minHeight = structure.func_74762_e("minHeight");
        this.chunkMinX = structure.func_74762_e("chunkMinX");
        this.chunkMaxX = structure.func_74762_e("chunkMaxX");
        this.chunkMinZ = structure.func_74762_e("chunkMinZ");
        this.chunkMaxZ = structure.func_74762_e("chunkMaxZ");
        this.cx = structure.func_74762_e("cx");
        this.cz = structure.func_74762_e("cz");
        int[] pos = structure.func_74759_k("pos");
        this.pos = new BlockPos(pos[0], pos[1], pos[2]);
    }

    protected StructureChunk getStructureChunk(int x, int y, int z) {
        StructurePos pos = new StructurePos(x >> 4, y >> 4, z >> 4);
        if (this.data.containsKey((Object)pos)) {
            return this.data.get((Object)pos);
        }
        StructureChunk chunk = new StructureChunk();
        this.data.put(pos, chunk);
        return chunk;
    }

    public void setBlock(IBlockState state, BlockPos pos) {
        int id = Block.func_149682_b((Block)state.func_177230_c());
        byte meta = (byte)state.func_177230_c().func_176201_c(state);
        this.maxHeight = Math.min(Math.max(this.maxHeight, pos.func_177956_o() + this.pos.func_177956_o()), 255);
        this.minHeight = Math.max(Math.min(this.minHeight, pos.func_177956_o() + this.pos.func_177956_o()), 0);
        StructureChunk chunk = this.getStructureChunk(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        chunk.setBlock(id, meta, pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
        this.updateBounds(pos);
    }

    public IBlockState getBlockState(int x, int y, int z) {
        StructureChunk chunk = this.getStructureChunk(x, y, z);
        return chunk.getBlockState(x & 0xF, y & 0xF, z & 0xF);
    }

    public boolean setChunk(World world, int cx, int cz) {
        if (cx >= this.chunkMinX && cx <= this.chunkMaxX && cz >= this.chunkMinZ && cz <= this.chunkMaxZ) {
            int sx = cx << 4 | 8;
            int sz = cz << 4 | 8;
            for (int y = this.minHeight; y <= this.maxHeight; ++y) {
                int py = y - this.pos.func_177956_o();
                for (int x = 0; x < 16; ++x) {
                    int wx = sx + x;
                    int px = wx - this.pos.func_177958_n();
                    for (int z = 0; z < 16; ++z) {
                        int wz = sz + z;
                        int pz = wz - this.pos.func_177952_p();
                        IBlockState state = this.getBlockState(px, py, pz);
                        if (state == null) continue;
                        world.func_180501_a(new BlockPos(wx, y, wz), state, 18);
                    }
                }
            }
            ++this.chunksGenerated;
            return true;
        }
        return false;
    }

    public boolean generationComplete() {
        return this.chunksGenerated >= this.chunksMax;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound structure = new NBTTagCompound();
        structure.func_74768_a("chunksGenerated", this.chunksGenerated);
        structure.func_74768_a("chunksMax", this.chunksMax);
        structure.func_74768_a("maxHeight", this.maxHeight);
        structure.func_74768_a("minHeight", this.minHeight);
        structure.func_74768_a("chunkMinX", this.chunkMinX);
        structure.func_74768_a("chunkMaxX", this.chunkMaxX);
        structure.func_74768_a("chunkMinZ", this.chunkMinZ);
        structure.func_74768_a("chunkMaxZ", this.chunkMaxZ);
        structure.func_74768_a("cx", this.cx);
        structure.func_74768_a("cz", this.cz);
        structure.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        return structure;
    }

    private void updateBounds(BlockPos pos) {
        int cx = pos.func_177958_n() + this.pos.func_177958_n() >> 4;
        int y = pos.func_177956_o() + this.pos.func_177956_o();
        int cz = pos.func_177952_p() + this.pos.func_177952_p() >> 4;
        this.maxHeight = y > this.maxHeight ? y : this.maxHeight;
        this.minHeight = y < this.minHeight ? y : this.minHeight;
        boolean update = false;
        if (cx < this.chunkMinX) {
            this.chunkMinX = cx;
            update = true;
        }
        if (cx > this.chunkMaxX) {
            this.chunkMaxX = cx;
            update = true;
        }
        if (cz < this.chunkMinZ) {
            this.chunkMinZ = cz;
            update = true;
        }
        if (cz > this.chunkMaxZ) {
            this.chunkMaxZ = cz;
            update = true;
        }
        if (update) {
            this.chunksMax = (this.chunkMaxX - this.chunkMinX + 1) * (this.chunkMaxZ - this.chunkMinZ + 1);
        }
    }
}

