/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import paulevs.betternether.config.ConfigLoader;

public class StructureNBT {
    protected ResourceLocation location;
    protected Template template;
    protected static final PlacementSettings DEFAULT_SETTINGS = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);

    public StructureNBT(String structure) {
        this.location = new ResourceLocation("betternether", structure);
        this.template = this.readTemplate(new ResourceLocation("betternether", structure));
    }

    protected StructureNBT(ResourceLocation location, Template template) {
        this.location = location;
        this.template = template;
    }

    public boolean generateCentered(World world, BlockPos pos, Random random) {
        return this.generateCentered(world, pos, Rotation.values()[random.nextInt(Rotation.values().length)]);
    }

    public boolean generateCentered(World world, BlockPos pos) {
        if (this.template == null) {
            System.out.println("No structure: " + this.location.toString());
            return false;
        }
        BlockPos blockpos2 = this.template.func_186259_a();
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);
        this.template.func_186260_a(world, pos.func_177982_a(-blockpos2.func_177958_n() >> 1, 0, -blockpos2.func_177952_p() >> 1), placementsettings);
        return true;
    }

    public boolean generateCentered(World world, BlockPos pos, Rotation rotation) {
        if (this.template == null) {
            System.out.println("No structure: " + this.location.toString());
            return false;
        }
        BlockPos blockpos2 = this.template.func_186259_a().func_190942_a(rotation);
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(rotation).func_186222_a(false).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);
        pos = pos.func_177982_a(-(blockpos2.func_177958_n() >> 1), 0, -(blockpos2.func_177952_p() >> 1));
        pos = pos.func_177982_a(blockpos2.func_177958_n() < 0 ? -1 : 0, 0, blockpos2.func_177952_p() < 0 ? -1 : 0);
        this.template.func_186260_a(world, pos, placementsettings);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Template readTemplate(ResourceLocation resource) {
        String s = resource.func_110624_b();
        String s1 = resource.func_110623_a();
        Path p = ConfigLoader.getStructureLoadPath().resolve(s1 + ".nbt");
        if (Files.exists(p, new LinkOption[0])) {
            try (BufferedInputStream inStream2 = new BufferedInputStream(Files.newInputStream(p, new OpenOption[0]));){
                Template template3 = this.readTemplateFromStream(inStream2);
                return template3;
            }
            catch (IOException e) {
                System.err.println("Error loading Better Nether structure " + s1 + " from config dir:");
                e.printStackTrace();
                return null;
            }
        }
        try (InputStream inStream = MinecraftServer.class.getResourceAsStream("/assets/" + s + "/structures/" + s1 + ".nbt");){
            if (inStream != null) {
                Template template2 = this.readTemplateFromStream(inStream);
                return template2;
            }
            System.err.println("Better Nether structure " + s + ":" + s1 + " not found in filesystem or classpath - double check your file paths.");
            Template template = null;
            return template;
        }
        catch (IOException e) {
            System.err.println("Error loading Better Nether structure " + "/assets/" + s + "/structures/" + s1 + ".nbt" + " from classpath");
            e.printStackTrace();
            return null;
        }
    }

    private Template readTemplateFromStream(InputStream stream) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        if (!nbttagcompound.func_150297_b("DataVersion", 99)) {
            nbttagcompound.func_74768_a("DataVersion", 500);
        }
        Template template = new Template();
        template.func_186256_b(nbttagcompound);
        return template;
    }

    public BlockPos getSize(Rotation rotation) {
        if (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180) {
            return this.template.func_186259_a();
        }
        BlockPos size = this.template.func_186259_a();
        int x = size.func_177958_n();
        int z = size.func_177952_p();
        return new BlockPos(z, size.func_177956_o(), x);
    }

    public String getName() {
        return this.location.func_110623_a();
    }
}

