/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.noise;

import paulevs.betternether.noise.PermutationTable;

public class WorleyNoiseOctaved3D {
    private PermutationTable randX;
    private PermutationTable randY;
    private PermutationTable randZ;
    private PermutationTable ids;
    private int maxID;

    public WorleyNoiseOctaved3D(long seed, int maxID) {
        this.randX = new PermutationTable(seed);
        this.randY = new PermutationTable(seed + 1337L);
        this.randZ = new PermutationTable(seed + 2673L);
        this.ids = new PermutationTable(seed + 135L);
        this.maxID = maxID;
    }

    public double GetValue(double x, double y, double z) {
        int px = (int)x;
        int py = (int)y;
        int pz = (int)z;
        x -= (double)px;
        y -= (double)py;
        z -= (double)pz;
        int indexX = px;
        int indexY = py;
        int indexZ = pz;
        double d = 10.0;
        for (int i = -1; i < 2; ++i) {
            int cx = px + i & 0xFF;
            for (int j = -1; j < 2; ++j) {
                int cy = py + j & 0xFF;
                for (int k = -1; k < 2; ++k) {
                    double oz;
                    double oy;
                    int cz = pz + k & 0xFF;
                    double ox = this.sqr(x - this.randX.PosReal(cx, -cy) - (double)i);
                    double nd = Math.sqrt(ox + (oy = this.sqr(y - this.randY.PosReal(-cz, -cx) - (double)j)) + (oz = this.sqr(z - this.randZ.PosReal(-cx, cy) - (double)k)));
                    if (!(nd < d)) continue;
                    d = nd;
                    indexX = cx;
                    indexY = cy;
                    indexZ = cz;
                }
            }
        }
        return this.ids.PosReal(indexX, indexY, indexZ) % (double)this.maxID;
    }

    private double sqr(double x) {
        return x * x;
    }
}

