/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.noise;

import paulevs.betternether.noise.OpenSimplexNoise;

public class PregennedOpenSimplexNoise {
    private final int xArrSize;
    private final int yArrSize;
    private final double[] noise;

    public PregennedOpenSimplexNoise(int xSize, int ySize, OpenSimplexNoise noiseGen) {
        this.xArrSize = (xSize >> 3) + 1;
        this.yArrSize = (ySize >> 3) + 1;
        this.noise = new double[(this.xArrSize + 1) * this.yArrSize + 1];
        for (int x = 0; x < this.xArrSize; ++x) {
            for (int y = 0; y < this.yArrSize; ++y) {
                this.put(x, y, noiseGen.eval(x, y));
            }
        }
    }

    private void put(int x, int y, double val) {
        this.noise[x * this.yArrSize + y] = val;
    }

    private double get(int x, int y) {
        return this.noise[x * this.yArrSize + y];
    }

    public double eval(int x, int y) {
        int lastX = x >> 3;
        int lastY = y >> 3;
        double distX = (double)(x & 7) / 8.0;
        double distY = (double)(y & 7) / 8.0;
        double q00 = this.get(lastX, lastY);
        double q10 = this.get(lastX + 1, lastY);
        double q01 = this.get(lastX, lastY + 1);
        double q11 = this.get(lastX + 1, lastY + 1);
        return PregennedOpenSimplexNoise.lerp(PregennedOpenSimplexNoise.lerp(q00, distX, q10), distY, PregennedOpenSimplexNoise.lerp(q01, distX, q11));
    }

    private static double lerp(double lower, double slide, double upper) {
        return lower + (upper - lower) * slide;
    }
}

