/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.entities;

import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.sounds.SoundRegister;
import paulevs.betternether.world.BNWorldGenerator;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityFirefly
extends EntityAmbientCreature
implements ILightProvider {
    private static final DataParameter<Byte> R = EntityDataManager.func_187226_a(EntityFirefly.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> G = EntityDataManager.func_187226_a(EntityFirefly.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> B = EntityDataManager.func_187226_a(EntityFirefly.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityFirefly.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> OFFSET = EntityDataManager.func_187226_a(EntityFirefly.class, (DataSerializer)DataSerializers.field_187193_c);
    private Random random;
    private boolean sitting;
    private boolean wantToSit;
    private float sitY;

    public EntityFirefly(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
        this.func_189654_d(true);
        this.field_70178_ae = true;
        this.random = new Random();
    }

    public boolean func_70601_bi() {
        NetherBiome biome = BNWorldGenerator.getBiome(this.field_70170_p, this.func_180425_c());
        return biome == BiomeRegister.BIOME_GRASSLANDS || biome == BiomeRegister.BIOME_NETHER_JUNGLE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(R, (Object)-1);
        this.field_70180_af.func_187214_a(G, (Object)-1);
        this.field_70180_af.func_187214_a(B, (Object)-1);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(OFFSET, (Object)Float.valueOf(0.77f));
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70729_aU && this.func_189652_ae()) {
            this.func_189654_d(false);
        }
        if (this.sitting) {
            this.field_70163_u = this.sitY;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.wantToSit) {
            if (this.sitting) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.random.nextInt(320) == 0) {
                    this.wantToSit = false;
                }
            } else {
                this.field_70159_w *= 0.5;
                this.field_70181_x = -0.02;
                this.field_70179_y *= 0.5;
                BlockPos under = new BlockPos((Entity)this).func_177963_a(0.0, -0.5, 0.0);
                if (this.field_70170_p.func_180495_p(under).isSideSolid((IBlockAccess)this.field_70170_p, under, EnumFacing.UP)) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.sitY = (float)under.func_177956_o() + (float)this.field_70170_p.func_180495_p((BlockPos)under).func_185890_d((IBlockAccess)this.field_70170_p, (BlockPos)under).field_72337_e;
                    this.sitting = true;
                }
            }
        } else if (this.sitting) {
            this.field_70181_x = 0.05;
            this.field_70159_w = 0.05 - this.random.nextDouble() * 0.1;
            this.field_70179_y = 0.05 - this.random.nextDouble() * 0.1;
            this.sitting = false;
        } else {
            if (this.random.nextInt(3) == 0) {
                double l;
                this.field_70159_w += 0.01 - this.random.nextDouble() * 0.02;
                this.field_70181_x += 0.02 - this.random.nextDouble() * 0.04;
                this.field_70179_y += 0.01 - this.random.nextDouble() * 0.02;
                BlockPos under = new BlockPos((Entity)this).func_177979_c(8);
                if (this.field_70170_p.func_180495_p(under).func_177230_c() == Blocks.field_150350_a && this.field_70170_p.func_180495_p(under.func_177981_b(7)).func_177230_c() == Blocks.field_150350_a) {
                    this.field_70181_x = -Math.abs(this.field_70181_x);
                }
                if ((l = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) > 0.0) {
                    l = Math.sqrt(l);
                    this.field_70159_w /= l;
                    this.field_70181_x /= l;
                    this.field_70179_y /= l;
                } else {
                    switch (this.random.nextInt(6)) {
                        case 0: {
                            this.field_70159_w = 1.0;
                            this.field_70181_x = 0.0;
                            this.field_70179_y = 0.0;
                            break;
                        }
                        case 1: {
                            this.field_70159_w = -1.0;
                            this.field_70181_x = 0.0;
                            this.field_70179_y = 0.0;
                            break;
                        }
                        case 2: {
                            this.field_70181_x = 1.0;
                            this.field_70159_w = 0.0;
                            this.field_70179_y = 0.0;
                            break;
                        }
                        case 3: {
                            this.field_70181_x = -1.0;
                            this.field_70159_w = 0.0;
                            this.field_70179_y = 0.0;
                            break;
                        }
                        case 4: {
                            this.field_70179_y = 1.0;
                            this.field_70159_w = 0.0;
                            this.field_70181_x = 0.0;
                            break;
                        }
                        default: {
                            this.field_70179_y = -1.0;
                            this.field_70159_w = 0.0;
                            this.field_70181_x = 0.0;
                        }
                    }
                }
                this.field_70159_w *= 0.05;
                this.field_70181_x *= 0.02;
                this.field_70179_y *= 0.05;
                float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70177_z += f1;
            }
            if (this.random.nextInt(320) == 0) {
                this.wantToSit = true;
            }
        }
    }

    public boolean func_145773_az() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void bindColor() {
        GL11.glColor3ub((byte)((Byte)this.field_70180_af.func_187225_a(R)), (byte)((Byte)this.field_70180_af.func_187225_a(G)), (byte)((Byte)this.field_70180_af.func_187225_a(B)));
    }

    @SideOnly(value=Side.CLIENT)
    public void transform() {
        GlStateManager.func_179109_b((float)0.0f, (float)((Float)this.field_70180_af.func_187225_a(OFFSET)).floatValue(), (float)0.0f);
        GlStateManager.func_179152_a((float)((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue(), (float)((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue(), (float)((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("R", ((Byte)this.field_70180_af.func_187225_a(R)).byteValue());
        compound.func_74774_a("G", ((Byte)this.field_70180_af.func_187225_a(G)).byteValue());
        compound.func_74774_a("B", ((Byte)this.field_70180_af.func_187225_a(B)).byteValue());
        compound.func_74776_a("Size", ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(R, (Object)compound.func_74771_c("R"));
        this.field_70180_af.func_187227_b(G, (Object)compound.func_74771_c("G"));
        this.field_70180_af.func_187227_b(B, (Object)compound.func_74771_c("B"));
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(compound.func_74760_g("Size")));
        this.updateOffset();
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        return Light.builder().pos((Entity)this).color((float)((Byte)this.field_70180_af.func_187225_a(R) & 0xFF) / 255.0f, (float)((Byte)this.field_70180_af.func_187225_a(G) & 0xFF) / 255.0f, (float)((Byte)this.field_70180_af.func_187225_a(B) & 0xFF) / 255.0f).radius(2.0f).build();
    }

    @Optional.Method(modid="albedo")
    public void gatherLights(GatherLightsEvent event, Entity entity) {
        event.add(this.provideLight());
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return this.random.nextInt(4) != 0 ? null : (this.sitting ? SoundRegister.FLY_SIT_AMBIENT : SoundRegister.FLY_SOUND);
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegister.FLY_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource d) {
        return this.random.nextInt(2) == 0 ? SoundRegister.FLY_HURT1 : SoundRegister.FLY_HURT2;
    }

    public float func_70599_aP() {
        return this.sitting ? 0.1f + this.random.nextFloat() * 0.15f : 0.2f + this.random.nextFloat() * 0.2f;
    }

    public float func_70647_i() {
        return this.random.nextFloat() * 0.4f + 0.8f;
    }

    private void updateOffset() {
        this.field_70180_af.func_187227_b(OFFSET, (Object)Float.valueOf(1.3f - ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue() * 1.06f));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.field_70180_af.func_187227_b(R, (Object)((byte)(0x80 | this.random.nextInt(128))));
        this.field_70180_af.func_187227_b(G, (Object)((byte)(0x80 | this.random.nextInt(128))));
        this.field_70180_af.func_187227_b(B, (Object)((byte)(0x80 | this.random.nextInt(128))));
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(0.25f + this.random.nextFloat() * 0.25f));
        this.updateOffset();
        return livingdata;
    }
}

