/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.config;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.items.ItemsRegister;
import paulevs.betternether.world.BNWorldGenerator;

public class ConfigLoader {
    private static Configuration config;
    private static boolean[] registerItems;
    private static Set<NetherBiome> enabledBiomes;
    private static List<NetherBiome> everywhereBiomes;
    private static Map<String, List<NetherBiome>> restrictedBiomes;
    private static final Set<Block> NETHER_TERRAIN;
    private static final Set<Block> NETHER_GEN_TERRAIN;
    private static final Set<Block> NETHER_GEN_REPL_TERRAIN;
    private static String[] netherTerrainIds;
    private static String[] netherGenTerrainIds;
    private static String[] netherGenReplTerrainIds;
    private static Path structureLoadPath;
    private static StructureConfigInfo[] scInfosLand;
    private static StructureConfigInfo[] scInfosLava;
    private static StructureConfigInfo[] scInfosCave;
    private static int totalWeightLand;
    private static int totalWeightLava;
    private static int totalWeightCave;
    private static int indexItems;
    private static int biomeSizeXZ;
    private static int biomeSizeY;
    private static Map<String, Boolean> registerBlocks;
    private static boolean hasCleaningPass;
    private static boolean hasNetherWart;
    private static int cityDistance;
    private static boolean hasCities;
    private static String[] centers;
    private static String[] buildings;

    public static void load(File file, File configDir) {
        structureLoadPath = configDir.toPath().resolve("betternether").resolve("structures");
        ArrayList<Boolean> items = new ArrayList<Boolean>();
        config = new Configuration(file);
        config.load();
        biomeSizeXZ = config.getInt("BiomeSizeXZ", "Generator", 100, 1, 4096, "Defines size in horisontal space");
        biomeSizeY = config.getInt("BiomeSizeY", "Generator", 32, 1, 4096, "Defines size in vertical space");
        hasCleaningPass = config.getBoolean("SecondPass", "Generator", true, "Enables|Disables second pass for smooth terrain");
        hasNetherWart = config.getBoolean("NetherWartGeneration", "Generator", true, "Enables|Disables vanilla nether wart generation in biomes");
        cityDistance = config.getInt("CityGridSize", "Cities", 80, 8, 2048, "City grid size in chunks");
        hasCities = config.getBoolean("CityEnabled", "Cities", true, "Enables|Disables cities");
        centers = config.getStringList("CityCenters", "Cities", new String[]{"city_center_01", "city_center_02"}, "List of structures to use as city centers. Loaded from config/betternether/structures/city. (You can also override built-in ones by putting files with the same name there.)");
        buildings = config.getStringList("CityBuildings", "Cities", new String[]{"city_building_01", "city_building_02", "city_building_03", "city_building_04", "city_building_05", "city_building_06", "city_building_07", "city_building_08", "city_building_09", "city_building_10", "city_library_01", "city_tower_01", "city_tower_02", "city_enchanter_01", "city_hall"}, "List of structures to use as city buildings. Loaded from config/betternether/structures/city. (You can also override built-in ones by putting files with the same name there.)");
        netherTerrainIds = config.getStringList("PlantableBlocks", "Other", new String[]{"minecraft:netherrack", "betternether:nether_mycelium", "betternether:netherrack_moss"}, "List of blocks plants can grow on. Some plants will always grow on soul sand.");
        netherGenTerrainIds = config.getStringList("TerrainBlocks", "Generator", new String[]{"minecraft:netherrack", "minecraft:soul_sand", "betternether:nether_mycelium", "betternether:netherrack_moss"}, "Blocks to consider normal terrain during worldgen for structure gen, etc.");
        netherGenReplTerrainIds = config.getStringList("TerrainReplaceBlocks", "Generator", new String[]{"minecraft:netherrack", "minecraft:soul_sand", "minecraft:gravel"}, "Blocks to replace with Better Nether's biome ground covering (if there is one) during worldgen");
        enabledBiomes = new HashSet<NetherBiome>();
        everywhereBiomes = new ArrayList<NetherBiome>();
        restrictedBiomes = new HashMap<String, List<NetherBiome>>();
        for (Map.Entry<String, NetherBiome> e : BiomeRegister.BIOME_REGISTRY.entrySet()) {
            String name = e.getKey();
            NetherBiome biome = e.getValue();
            boolean enabled = config.getBoolean(name, "Biomes", true, "Enables|Disables biome");
            if (enabled) {
                enabledBiomes.add(biome);
            }
            if (biome.isEdge()) continue;
            if (biome.isSub()) {
                biome.field_76292_a = config.getInt(name + "_chance", "Biomes", biome.getDefaultWeight(), 1, 1000, "Chance in 1000 for this sub-biome to appear within the main biome");
                continue;
            }
            biome.field_76292_a = config.getInt(name + "_weight", "Biomes", biome.getDefaultWeight(), 1, Short.MAX_VALUE, "Biome weight (higher = more common)");
            String[] validBiomes = config.getStringList(name + "_spawns", "Biomes", new String[0], "Proper MC-registered biomes this \"biome\" can spawn in. Leave empty for all biomes.");
            if (!enabled) continue;
            if (validBiomes.length == 0) {
                everywhereBiomes.add(biome);
                continue;
            }
            for (String b : validBiomes) {
                restrictedBiomes.computeIfAbsent(b, s -> new ArrayList()).add(biome);
            }
        }
        items.clear();
        registerBlocks = new HashMap<String, Boolean>();
        for (Field f : BlocksRegister.class.getDeclaredFields()) {
            if (!f.getType().isAssignableFrom(Block.class)) continue;
            registerBlocks.put(f.getName().toLowerCase(Locale.ROOT), config.getBoolean(f.getName().toLowerCase(Locale.ROOT), "Blocks", true, "Enables|Disables block"));
        }
        for (Field f : ItemsRegister.class.getDeclaredFields()) {
            if (!f.getType().isAssignableFrom(Item.class)) continue;
            items.add(config.getBoolean(f.getName().toLowerCase(Locale.ROOT), "Items", true, "Enables|Disables item"));
        }
        registerItems = new boolean[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            ConfigLoader.registerItems[i] = (Boolean)items.get(i);
        }
        items.clear();
        items = null;
        BNWorldGenerator.enablePlayerDamage = config.getBoolean("DamagePlayer", "EggplantDamage", true, "Damage for players");
        BNWorldGenerator.enableMobDamage = config.getBoolean("DamageMobs", "EggplantDamage", true, "Damage for mobs");
        ConfigLoader.resetItemIndex();
    }

    public static void init() {
        Block b;
        BNWorldGenerator.setPlantDensity(config.getFloat("GlobalDensity", "Generator", 1.0f, 0.0f, 1.0f, "Global plant density, multiplied on other"));
        BNWorldGenerator.setStructureDensity(config.getFloat("StructureDensity", "Generator", 0.015625f, 0.0f, 1.0f, "Structure density for random world structures"));
        BNWorldGenerator.setOreDensity(config.getFloat("OreDensity", "Generator", 9.765625E-4f, 0.0f, 1.0f, "Cincinnasite ore density"));
        for (NetherBiome biome : enabledBiomes) {
            biome.setDensity(config.getFloat(biome.getName().replace(" ", "") + "Density", "Generator", 1.0f, 0.0f, 1.0f, "Density for " + biome.getName() + " biome"));
        }
        for (String string : netherTerrainIds) {
            b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
            if (b == Blocks.field_150350_a) {
                System.out.println("Ignoring non-present block in valid plant blocks: " + string);
                continue;
            }
            NETHER_TERRAIN.add(b);
        }
        for (String string : netherGenTerrainIds) {
            b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
            if (b == Blocks.field_150350_a) {
                System.out.println("Ignoring non-present block in terrain gen terrain blocks: " + string);
                continue;
            }
            NETHER_GEN_TERRAIN.add(b);
        }
        for (String string : netherGenReplTerrainIds) {
            b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
            if (b == Blocks.field_150350_a) {
                System.out.println("Ignoring non-present block in terrain gen terrain replaceable blocks: " + string);
                continue;
            }
            NETHER_GEN_REPL_TERRAIN.add(b);
        }
        System.out.println(NETHER_TERRAIN);
        System.out.println(NETHER_GEN_TERRAIN);
        System.out.println(NETHER_GEN_REPL_TERRAIN);
        totalWeightLand = 0;
        totalWeightLava = 0;
        totalWeightCave = 0;
        for (StructureConfigInfo structureConfigInfo : scInfosLand) {
            structureConfigInfo.weight = config.getInt("StructureWeight_" + structureConfigInfo.name, "StructureGenWeights_Land", 1, 0, 100, "Spawn weight for selecting land structures to spawn");
            totalWeightLand += structureConfigInfo.weight;
        }
        for (StructureConfigInfo structureConfigInfo : scInfosLava) {
            structureConfigInfo.weight = config.getInt("StructureWeight_" + structureConfigInfo.name, "StructureGenWeights_Lava", 1, 0, 100, "Spawn weight for selecting lava structures to spawn");
            totalWeightLava += structureConfigInfo.weight;
        }
        for (StructureConfigInfo structureConfigInfo : scInfosCave) {
            structureConfigInfo.weight = config.getInt("StructureWeight_" + structureConfigInfo.name, "StructureGenWeights_Cave", 1, 0, 100, "Spawn weight for selecting cave structures to spawn");
            totalWeightCave += structureConfigInfo.weight;
        }
    }

    public static boolean mustInitBiome(NetherBiome biome) {
        return enabledBiomes.contains((Object)biome);
    }

    public static boolean mustInitBlock(Field field) {
        String s = field.getName().toLowerCase(Locale.ROOT);
        return registerBlocks.containsKey(s) && registerBlocks.get(s) != false;
    }

    public static boolean mustInitBlock(String key) {
        String s = key.toLowerCase(Locale.ROOT);
        return registerBlocks.containsKey(s) && registerBlocks.get(s) != false;
    }

    public static boolean mustInitItem() {
        return registerItems[indexItems++];
    }

    public static void resetItemIndex() {
        indexItems = 0;
    }

    public static void dispose() {
        config.save();
        registerBlocks = null;
        enabledBiomes = null;
        registerItems = null;
    }

    public static int getBiomeSizeXZ() {
        return biomeSizeXZ;
    }

    public static int getBiomeSizeY() {
        return biomeSizeY;
    }

    public static boolean hasCleaningPass() {
        return hasCleaningPass;
    }

    public static boolean hasNetherWart() {
        return hasNetherWart;
    }

    public static int getCityDistance() {
        return cityDistance;
    }

    public static boolean hasCities() {
        return hasCities;
    }

    public static String[] getCityCenters() {
        return centers;
    }

    public static String[] getCityBuildings() {
        return buildings;
    }

    public static List<NetherBiome> getEverywhereBiomes() {
        return everywhereBiomes;
    }

    public static Map<String, List<NetherBiome>> getRestrictedBiomes() {
        return restrictedBiomes;
    }

    public static boolean isTerrain(Block b) {
        return NETHER_TERRAIN.contains(b);
    }

    public static boolean isGenTerrain(Block b) {
        return NETHER_GEN_TERRAIN.contains(b);
    }

    public static boolean isReplace(Block b) {
        return NETHER_GEN_REPL_TERRAIN.contains(b);
    }

    public static Path getStructureLoadPath() {
        return structureLoadPath;
    }

    public static StructureConfigInfo[] getScInfosLand() {
        return scInfosLand;
    }

    public static StructureConfigInfo[] getScInfosLava() {
        return scInfosLava;
    }

    public static StructureConfigInfo[] getScInfosCave() {
        return scInfosCave;
    }

    public static int getTotalWeightLand() {
        return totalWeightLand;
    }

    public static int getTotalWeightLava() {
        return totalWeightLava;
    }

    public static int getTotalWeightCave() {
        return totalWeightCave;
    }

    static {
        NETHER_TERRAIN = new HashSet<Block>();
        NETHER_GEN_TERRAIN = new HashSet<Block>();
        NETHER_GEN_REPL_TERRAIN = new HashSet<Block>();
        scInfosLand = new StructureConfigInfo[]{new StructureConfigInfo("altar", 0), new StructureConfigInfo("altar_01", -1), new StructureConfigInfo("altar_02", -4), new StructureConfigInfo("altar_03", -3), new StructureConfigInfo("altar_04", -3), new StructureConfigInfo("altar_05", -2), new StructureConfigInfo("altar_06", -2), new StructureConfigInfo("portal_01", -4), new StructureConfigInfo("portal_02", -3), new StructureConfigInfo("garden_01", -3), new StructureConfigInfo("garden_02", -2), new StructureConfigInfo("pillar_01", -1), new StructureConfigInfo("respawn_point_01", -3), new StructureConfigInfo("respawn_point_02", -2)};
        scInfosLava = new StructureConfigInfo[0];
        scInfosCave = new StructureConfigInfo[]{new StructureConfigInfo("room_01", -5)};
    }

    public static class StructureConfigInfo {
        public final String name;
        public final int offsetY;
        public int weight = 1;

        StructureConfigInfo(String name, int offsetY) {
            this.name = name;
            this.offsetY = offsetY;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }
    }
}

