/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import paulevs.betternether.BetterNether;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.config.ConfigLoader;

public class BlockWartSeed
extends Block
implements IGrowable {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75);

    public BlockWartSeed() {
        super(Material.field_151575_d, MapColor.field_193559_aa);
        this.func_149647_a(BetterNether.BN_TAB);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setRegistryName("wart_seed");
        this.func_149663_c("wart_seed");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150425_aM) {
            boolean b1 = worldIn.func_180495_p(new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o() + 5, pos.func_177952_p())).func_177230_c() == Blocks.field_150350_a;
            boolean b2 = worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + 4, pos.func_177956_o() + 5, pos.func_177952_p())).func_177230_c() == Blocks.field_150350_a;
            boolean b3 = worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 5, pos.func_177952_p() - 4)).func_177230_c() == Blocks.field_150350_a;
            boolean b4 = worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 5, pos.func_177952_p() + 4)).func_177230_c() == Blocks.field_150350_a;
            boolean b5 = worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 10, pos.func_177952_p())).func_177230_c() == Blocks.field_150350_a;
            return b1 && b2 && b3 && b4 && b5;
        }
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random random, BlockPos pos, IBlockState state) {
        IBlockState bricks = Blocks.field_150385_bj.func_176223_P();
        IBlockState redBricks = Blocks.field_189879_dh.func_176223_P();
        IBlockState wart = Blocks.field_189878_dg.func_176223_P();
        world.func_175656_a(pos, wart);
        ArrayList<BlockPos> seedBlocks = new ArrayList<BlockPos>();
        int height = 5 + random.nextInt(5);
        int h2 = height >>> 1;
        int h3 = height >>> 2;
        int width = (height >>> 2) + 1;
        int offset = width >>> 1;
        for (int x = 0; x < width; ++x) {
            int px = x + pos.func_177958_n() - offset;
            for (int z = 0; z < width; ++z) {
                int pz = z + pos.func_177952_p() - offset;
                int rh = random.nextInt(h2);
                int rh2 = random.nextInt(h3);
                for (int y = 0; y < height; ++y) {
                    int py = y + pos.func_177956_o();
                    BlockPos pos2 = new BlockPos(px, py, pz);
                    if (!world.func_180495_p(pos2).func_177230_c().func_176200_f((IBlockAccess)world, pos2)) continue;
                    if (y < rh2 && random.nextInt(2) == 0) {
                        world.func_175656_a(pos2, bricks);
                        continue;
                    }
                    if (y < rh && random.nextInt(2) == 0) {
                        world.func_175656_a(pos2, redBricks);
                        continue;
                    }
                    world.func_175656_a(pos2, wart);
                    EnumFacing dir = EnumFacing.field_176754_o[random.nextInt(4)];
                    seedBlocks.add(pos2.func_177972_a(dir));
                }
            }
        }
        int headWidth = width + 2;
        ++offset;
        height = height - width - 1 + pos.func_177956_o();
        for (int x = 0; x < headWidth; ++x) {
            int px = x + pos.func_177958_n() - offset;
            for (int z = 0; z < headWidth; ++z) {
                if (x == z || x == headWidth - z - 1) continue;
                int pz = z + pos.func_177952_p() - offset;
                for (int y = 0; y < width; ++y) {
                    int py = y + height;
                    BlockPos pos2 = new BlockPos(px, py, pz);
                    if (world.func_180495_p(pos2) == wart || !world.func_180495_p(pos2).func_177230_c().func_176200_f((IBlockAccess)world, pos2)) continue;
                    world.func_175656_a(pos2, wart);
                }
            }
        }
        for (BlockPos pos2 : seedBlocks) {
            BlockWartSeed.PlaceRandomSeed(world, pos2);
        }
    }

    private static void PlaceRandomSeed(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            IBlockState seed = BlocksRegister.BLOCK_WART_SEED.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP);
            if (world.func_180495_p(pos.func_177978_c()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.SOUTH);
            } else if (world.func_180495_p(pos.func_177968_d()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.NORTH);
            } else if (world.func_180495_p(pos.func_177974_f()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.WEST);
            } else if (world.func_180495_p(pos.func_177976_e()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.EAST);
            } else if (world.func_180495_p(pos.func_177984_a()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.DOWN);
            }
            world.func_175656_a(pos, seed);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta % 6)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (this.canAttachTo(worldIn, pos.func_177984_a(), side)) {
            return true;
        }
        if (this.canAttachTo(worldIn, pos.func_177977_b(), side)) {
            return true;
        }
        if (this.canAttachTo(worldIn, pos.func_177976_e(), side)) {
            return true;
        }
        if (this.canAttachTo(worldIn, pos.func_177974_f(), side)) {
            return true;
        }
        if (this.canAttachTo(worldIn, pos.func_177978_c(), side)) {
            return true;
        }
        return this.canAttachTo(worldIn, pos.func_177968_d(), side);
    }

    private boolean canAttachTo(World p_193392_1_, BlockPos p_193392_2_, EnumFacing p_193392_3_) {
        IBlockState iblockstate = p_193392_1_.func_180495_p(p_193392_2_);
        boolean flag = BlockWartSeed.func_193382_c((Block)iblockstate.func_177230_c());
        return !flag && iblockstate.func_193401_d((IBlockAccess)p_193392_1_, p_193392_2_, p_193392_3_) == BlockFaceShape.SOLID && !iblockstate.func_185897_m();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!this.canAttachTo(worldIn, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block under = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return ConfigLoader.isTerrain(under) || under == Blocks.field_150425_aM;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (face) {
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return WEST_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

