/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import paulevs.betternether.blocks.BlocksRegister;

public class BlockLucisMushroom
extends Block {
    public static final PropertyEnum<EnumDir> FACING = PropertyEnum.func_177709_a((String)"facing", EnumDir.class);
    public static final PropertyEnum<EnumShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumShape.class);
    private static final AxisAlignedBB MUSHROOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);

    public BlockLucisMushroom() {
        super(Material.field_151575_d, MapColor.field_151673_t);
        this.setRegistryName("lucis_mushroom");
        this.func_149663_c("lucis_mushroom");
        this.func_149711_c(1.0f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)((Object)EnumDir.NORTH)).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.CENTER)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151114_aO;
    }

    public int func_149745_a(Random random) {
        return random.nextInt(3);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BlocksRegister.BLOCK_LUCIS_SPORE);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextBoolean()) {
            this.spawnSeeds(worldIn, pos);
        }
        worldIn.func_175655_b(pos, true);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(4) == 0) {
            this.spawnSeeds(worldIn, pos);
        }
        worldIn.func_175655_b(pos, true);
    }

    private void spawnSeeds(World world, BlockPos pos) {
        ItemStack drop = new ItemStack(BlocksRegister.BLOCK_LUCIS_SPORE, 1);
        EntityItem itemEntity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        world.func_72838_d((Entity)itemEntity);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state) {
        boolean west;
        boolean north = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean south = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean east = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean bl = west = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        if (north && south && east && west) {
            worldIn.func_175656_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.CENTER)));
        } else if (north && south) {
            EnumDir dir = null;
            dir = east ? EnumDir.WEST : EnumDir.EAST;
            worldIn.func_175656_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.SIDE)).func_177226_a(FACING, (Comparable)((Object)dir)));
        } else if (east && west) {
            EnumDir dir = null;
            dir = north ? EnumDir.SOUTH : EnumDir.NORTH;
            worldIn.func_175656_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.SIDE)).func_177226_a(FACING, (Comparable)((Object)dir)));
        } else {
            EnumDir dir = EnumDir.NORTH;
            if (north) {
                dir = east ? EnumDir.NORTH : EnumDir.WEST;
            } else if (south) {
                dir = west ? EnumDir.SOUTH : EnumDir.EAST;
            }
            worldIn.func_175656_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.CORNER)).func_177226_a(FACING, (Comparable)((Object)dir)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        int type = meta >> 2;
        int face = meta & 3;
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumDir.values()[face])).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.values()[type]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDir)((Object)state.func_177229_b(FACING))).getIndex() | ((EnumShape)((Object)state.func_177229_b(SHAPE))).getIndex() << 2;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, SHAPE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MUSHROOM_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        boolean central;
        boolean bl = central = state.func_177229_b(SHAPE) == EnumShape.CENTER;
        if (face == EnumFacing.DOWN) {
            return central ? BlockFaceShape.SOLID : BlockFaceShape.CENTER_BIG;
        }
        return BlockFaceShape.CENTER_BIG;
    }

    public static enum EnumDir implements IStringSerializable
    {
        NORTH(0, "north"),
        SOUTH(1, "south"),
        EAST(2, "east"),
        WEST(3, "west");

        private final String name;
        private final int index;

        private EnumDir(int index, String name) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum EnumShape implements IStringSerializable
    {
        CORNER(0, "corner"),
        SIDE(1, "side"),
        CENTER(2, "center");

        private final String name;
        private final int index;

        private EnumShape(int index, String name) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

