/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.biomes.NetherBiomeGravelDesert;
import paulevs.betternether.biomes.NetherBiomeJungle;
import paulevs.betternether.biomes.NetherBoneReef;
import paulevs.betternether.biomes.NetherGrasslands;
import paulevs.betternether.biomes.NetherMushroomForest;
import paulevs.betternether.biomes.NetherMushroomForestEdge;
import paulevs.betternether.biomes.NetherPoorGrasslands;
import paulevs.betternether.biomes.NetherWartForest;
import paulevs.betternether.biomes.NetherWartForestEdge;
import paulevs.betternether.config.ConfigLoader;

public class BiomeRegister {
    public static int biomeCount;
    public static final Map<String, NetherBiome> BIOME_REGISTRY;
    private static final Object2ObjectMap<Biome, List<NetherBiome>> SPAWN_MAP;
    public static final NetherBiome BIOME_EMPTY_NETHER;
    public static final NetherBiome BIOME_GRAVEL_DESERT;
    public static final NetherBiome BIOME_NETHER_JUNGLE;
    public static final NetherBiome BIOME_WART_FOREST;
    public static final NetherBiome BIOME_GRASSLANDS;
    public static final NetherBiome BIOME_MUSHROOM_FOREST;
    public static final NetherBiome BIOME_MUSHROOM_FOREST_EDGE;
    public static final NetherBiome BIOME_WART_FOREST_EDGE;
    public static final NetherBiome BIOME_BONE_REEF;
    public static final NetherBiome BIOME_POOR_GRASSLANDS;

    public static void registerBiomes() {
        List<NetherBiome> everywhereBiomes = ConfigLoader.getEverywhereBiomes();
        Map<String, List<NetherBiome>> restrictedBiomes = ConfigLoader.getRestrictedBiomes();
        for (Map.Entry<String, List<NetherBiome>> e : restrictedBiomes.entrySet()) {
            ArrayList<NetherBiome> list = new ArrayList<NetherBiome>();
            list.addAll(everywhereBiomes);
            list.addAll((Collection)e.getValue());
            SPAWN_MAP.put((Object)ForgeRegistries.BIOMES.getValue(new ResourceLocation(e.getKey())), list);
        }
        SPAWN_MAP.defaultReturnValue(everywhereBiomes);
        BiomeRegister.useEdgeBiome(BIOME_MUSHROOM_FOREST_EDGE, BIOME_MUSHROOM_FOREST, 10);
        BiomeRegister.useEdgeBiome(BIOME_WART_FOREST_EDGE, BIOME_WART_FOREST, 9);
        BiomeRegister.useSubBiome(BIOME_BONE_REEF, BIOME_GRASSLANDS);
        BiomeRegister.useSubBiome(BIOME_POOR_GRASSLANDS, BIOME_GRASSLANDS);
    }

    private static NetherBiome register(String id, NetherBiome biome) {
        BIOME_REGISTRY.put(id, biome);
        return biome;
    }

    private static void useEdgeBiome(NetherBiome biome, NetherBiome mainBiome, int size) {
        if (ConfigLoader.mustInitBiome(biome)) {
            mainBiome.setEdge(biome);
            mainBiome.setEdgeSize(size);
        }
    }

    private static void useSubBiome(NetherBiome biome, NetherBiome mainBiome) {
        if (ConfigLoader.mustInitBiome(biome)) {
            mainBiome.addSubBiome(biome);
        }
    }

    public static List<NetherBiome> getBiomesForMCBiome(Biome biome) {
        return (List)SPAWN_MAP.get((Object)biome);
    }

    static {
        BIOME_REGISTRY = new HashMap<String, NetherBiome>();
        SPAWN_MAP = new Object2ObjectOpenHashMap();
        BIOME_EMPTY_NETHER = BiomeRegister.register("empty_nether", new NetherBiome("Empty Nether"));
        BIOME_GRAVEL_DESERT = BiomeRegister.register("gravel_desert", new NetherBiomeGravelDesert("Gravel Desert"));
        BIOME_NETHER_JUNGLE = BiomeRegister.register("nether_jungle", new NetherBiomeJungle("Nether Jungle"));
        BIOME_WART_FOREST = BiomeRegister.register("wart_forest", new NetherWartForest("Wart Forest"));
        BIOME_GRASSLANDS = BiomeRegister.register("grasslands", new NetherGrasslands("Nether Grasslands"));
        BIOME_MUSHROOM_FOREST = BiomeRegister.register("mushroom_forest", new NetherMushroomForest("Nether Mushroom Forest"));
        BIOME_MUSHROOM_FOREST_EDGE = BiomeRegister.register("mushroom_forest_edge", new NetherMushroomForestEdge("Nether Mushroom Forest Edge"));
        BIOME_WART_FOREST_EDGE = BiomeRegister.register("wart_forest_edge", new NetherWartForestEdge("Nether Wart Forest Edge"));
        BIOME_BONE_REEF = BiomeRegister.register("bone_reef", new NetherBoneReef("Bone Reef"));
        BIOME_POOR_GRASSLANDS = BiomeRegister.register("poor_grasslands", new NetherPoorGrasslands("Poor Nether Grasslands"));
    }
}

