/*
 * Decompiled with CFR 0.152.
 */
package com.omegajak.powerdrop.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class DropMessage
implements IMessage {
    private double chargeFactor;
    private boolean isCtrlDown;

    public DropMessage() {
        this.chargeFactor = 1.0;
    }

    public DropMessage(double chargeFactor, boolean isCtrlDown) {
        this.chargeFactor = chargeFactor != 0.0 ? chargeFactor : 1.0;
        this.isCtrlDown = isCtrlDown;
    }

    public void fromBytes(ByteBuf buf) {
        this.chargeFactor = buf.readDouble();
        this.isCtrlDown = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.chargeFactor);
        buf.writeBoolean(this.isCtrlDown);
    }

    public static class Handler
    implements IMessageHandler<DropMessage, DropMessage> {
        public DropMessage onMessage(DropMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    if (player.field_71071_by.func_70448_g() != null) {
                        ItemStack currentItem = player.field_71071_by.func_70448_g().func_77946_l();
                        if (message.isCtrlDown) {
                            currentItem.func_190920_e(player.field_71071_by.func_70448_g().func_190916_E());
                        } else {
                            currentItem.func_190920_e(1);
                        }
                        EntityItem dropped = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)player.eyeHeight - 0.39, player.field_70161_v, currentItem);
                        dropped.func_174867_a(40);
                        dropped.func_145799_b(player.func_70005_c_());
                        double normalizer = 3.1;
                        Vec3d lookVector = player.func_70040_Z();
                        dropped.field_70159_w = lookVector.field_72450_a / normalizer * message.chargeFactor;
                        dropped.field_70181_x = lookVector.field_72448_b / normalizer * message.chargeFactor + 0.12;
                        dropped.field_70179_y = lookVector.field_72449_c / normalizer * message.chargeFactor;
                        player.field_70170_p.func_72838_d((Entity)dropped);
                        if (player.field_71071_by.func_70448_g().func_190916_E() > 1 && !message.isCtrlDown) {
                            player.field_71071_by.func_70448_g().func_190920_e(player.field_71071_by.func_70448_g().func_190916_E() - 1);
                        } else {
                            player.field_71071_by.func_184437_d(player.field_71071_by.func_70448_g());
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new ItemTossEvent(dropped, (EntityPlayer)player));
                    }
                });
            }
            return null;
        }
    }
}

