/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers;

import com.blamejared.recipestages.RecipeStages;
import com.blamejared.recipestages.recipes.RecipeStage;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.mc1120.recipes.MCRecipeManager;
import crafttweaker.mc1120.recipes.MCRecipeShaped;
import crafttweaker.mc1120.recipes.MCRecipeShapeless;
import crafttweaker.mc1120.recipes.MCRecipeWrapper;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.recipestages.Recipes")
@ZenRegister
public class Recipes {
    public static Map<String, List<IRecipe>> recipes = new LinkedHashMap<String, List<IRecipe>>();
    public static ActionSetOutputStages actionSetOutputStages;
    public static ActionSetRegexStages actionSetRegexStages;
    public static ActionSetNameStages actionSetNameStages;
    public static ActionSetModidStages actionSetModidStages;
    private static TIntSet usedHashes;
    private static HashSet<String> usedRecipeNames;
    public static Map<String, String[]> crafterStages;
    public static Map<String, String[]> packageStages;
    public static boolean printContainers;

    @ZenMethod
    public static void setPrintContainers(boolean print) {
        CraftTweakerAPI.apply((IAction)new ActionSetPrinting(print));
    }

    @ZenMethod
    public static void setContainerStage(String container, String[] stage) {
        CraftTweakerAPI.apply((IAction)new ActionSetCrafter(container, stage));
    }

    @ZenMethod
    public static void setPackageStage(String pack, String[] stage) {
        CraftTweakerAPI.apply((IAction)new ActionSetPack(pack, stage));
    }

    @ZenMethod
    public static void addShaped(String stage, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        RecipeStages.LATE_ADDITIONS.add(new ActionAddShapedRecipe(stage, output, new MCRecipeShaped(ingredients, output, function, action, false, false)));
    }

    @ZenMethod
    public static void addShaped(String name, String stage, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        RecipeStages.LATE_ADDITIONS.add(new ActionAddShapedRecipe(stage, name, output, new MCRecipeShaped(ingredients, output, function, action, false, false)));
    }

    @ZenMethod
    public static void addShapedMirrored(String stage, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        RecipeStages.LATE_ADDITIONS.add(new ActionAddShapedRecipe(stage, output, new MCRecipeShaped(ingredients, output, function, action, true, false)));
    }

    @ZenMethod
    public static void addShapedMirrored(String name, String stage, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        RecipeStages.LATE_ADDITIONS.add(new ActionAddShapedRecipe(stage, name, output, new MCRecipeShaped(ingredients, output, function, action, true, false)));
    }

    @ZenMethod
    public static void addShapeless(String stage, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
        }
        if (!valid) {
            CraftTweakerAPI.logError((String)("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!"));
            return;
        }
        RecipeStages.LATE_ADDITIONS.add(new ActionAddShapelessRecipe(stage, output, ingredients, function, action));
    }

    @ZenMethod
    public static void addShapeless(String name, String stage, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
        }
        if (!valid) {
            CraftTweakerAPI.logError((String)("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!"));
            return;
        }
        RecipeStages.LATE_ADDITIONS.add(new ActionAddShapelessRecipe(stage, name, output, ingredients, function, action, false));
    }

    @ZenMethod
    public static void setRecipeStage(String stage, IIngredient output) {
        if (actionSetOutputStages == null) {
            actionSetOutputStages = new ActionSetOutputStages();
            RecipeStages.LATE_REMOVALS.add(actionSetOutputStages);
        }
        actionSetOutputStages.addOutput(stage, output);
    }

    @ZenMethod
    public static void setRecipeStage(String stage, String recipeName) {
        if (actionSetNameStages == null) {
            actionSetNameStages = new ActionSetNameStages();
            RecipeStages.LATE_REMOVALS.add(actionSetNameStages);
        }
        actionSetNameStages.addName(stage, recipeName);
    }

    @ZenMethod
    public static void setRecipeStageByRegex(String stage, String regexString) {
        if (actionSetRegexStages == null) {
            actionSetRegexStages = new ActionSetRegexStages();
            RecipeStages.LATE_REMOVALS.add(actionSetRegexStages);
        }
        actionSetRegexStages.addRegex(stage, regexString);
    }

    @ZenMethod
    public static void setRecipeStageByMod(String stage, String modid) {
        if (actionSetModidStages == null) {
            actionSetModidStages = new ActionSetModidStages();
            RecipeStages.LATE_REMOVALS.add(actionSetModidStages);
        }
        actionSetModidStages.addModid(stage, modid);
    }

    private static void replaceRecipe(String stage, IRecipe iRecipe) {
        ResourceLocation registryName = iRecipe.getRegistryName();
        if (registryName == null) {
            return;
        }
        int width = 0;
        int height = 0;
        if (iRecipe instanceof IShapedRecipe) {
            width = ((IShapedRecipe)iRecipe).getRecipeWidth();
            height = ((IShapedRecipe)iRecipe).getRecipeHeight();
        } else if (iRecipe instanceof RecipeStage && !((RecipeStage)iRecipe).isShapeless()) {
            width = ((RecipeStage)iRecipe).getWidth();
            height = ((RecipeStage)iRecipe).getHeight();
        }
        boolean shapeless = width == 0 && height == 0;
        RecipeStage recipe = new RecipeStage(stage, iRecipe, shapeless, width, height);
        Recipes.setRecipeRegistryName(recipe, registryName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        List list = recipes.getOrDefault(stage, new LinkedList());
        list.add(recipe);
        recipes.put(stage, list);
        if (iRecipe instanceof MCRecipeBase) {
            MCRecipeManager.recipesToAdd.removeIf(baseAddRecipe -> baseAddRecipe.getRecipe() == iRecipe);
        }
        CraftTweakerAPI.logInfo((String)("Replacing recipe: " + iRecipe.func_77571_b() + " new recipe: " + (Object)((Object)recipe)));
    }

    private static void setRecipeRegistryName(IRecipe recipe, ResourceLocation registryName) {
        Loader loader = Loader.instance();
        ModContainer activeModContainer = loader.activeModContainer();
        ModContainer modContainer = (ModContainer)loader.getIndexedModList().get(registryName.func_110624_b());
        if (modContainer != null) {
            loader.setActiveModContainer(modContainer);
        }
        recipe.setRegistryName(registryName);
        loader.setActiveModContainer(activeModContainer);
    }

    private static String calculateName(IIngredient output, IIngredient[][] ingredients) {
        StringBuilder sb = new StringBuilder();
        sb.append(Recipes.saveToString(output));
        IIngredient[][] iIngredientArray = ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] ingredient;
            for (IIngredient iIngredient : ingredient = iIngredientArray[i]) {
                sb.append(Recipes.saveToString(iIngredient));
            }
        }
        int hash = sb.toString().hashCode();
        while (usedHashes.contains(hash)) {
            ++hash;
        }
        usedHashes.add(hash);
        return "ct_shaped" + hash;
    }

    public static String calculateNameShapeless(IIngredient output, IIngredient[] ingredients) {
        StringBuilder sb = new StringBuilder();
        sb.append(Recipes.saveToString(output));
        for (IIngredient ingredient : ingredients) {
            sb.append(Recipes.saveToString(ingredient));
        }
        int hash = sb.toString().hashCode();
        while (usedHashes.contains(hash)) {
            ++hash;
        }
        usedHashes.add(hash);
        return "ct_shapeless" + hash;
    }

    public static String saveToString(IIngredient ingredient) {
        if (ingredient == null) {
            return "_";
        }
        return ingredient.toString();
    }

    public static String cleanRecipeName(String s) {
        if (s.contains(":")) {
            CraftTweakerAPI.logWarning((String)"String may not contain a \":\"");
        }
        return s.replace(":", "_");
    }

    static {
        usedHashes = new TIntHashSet();
        usedRecipeNames = new HashSet();
        crafterStages = new HashMap<String, String[]>();
        packageStages = new HashMap<String, String[]>();
        printContainers = false;
    }

    public static class ActionBaseAddRecipe
    implements IAction {
        protected RecipeStage recipe;
        protected IItemStack output;
        protected boolean isShaped;
        protected String name;

        @Deprecated
        public ActionBaseAddRecipe() {
        }

        private ActionBaseAddRecipe(RecipeStage recipe, IItemStack output, boolean isShaped, boolean hasTransformers) {
            this.recipe = recipe;
            this.output = output;
            this.isShaped = isShaped;
            IRecipe mcRecipe = recipe.getRecipe();
            if (mcRecipe instanceof MCRecipeBase) {
                MCRecipeBase ctRecipe = (MCRecipeBase)mcRecipe;
                if (hasTransformers) {
                    MCRecipeManager.transformerRecipes.add(ctRecipe);
                }
                if (ctRecipe.hasRecipeAction()) {
                    MCRecipeManager.actionRecipes.add(ctRecipe);
                }
            }
        }

        public IItemStack getOutput() {
            return this.output;
        }

        public void setOutput(IItemStack output) {
            this.output = output;
        }

        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            if (name != null) {
                String proposedName = Recipes.cleanRecipeName(name);
                if (usedRecipeNames.contains(proposedName)) {
                    this.name = this.calculateName();
                    CraftTweakerAPI.logWarning((String)("Recipe name [" + name + "] has duplicate uses, defaulting to calculated hash!"));
                } else {
                    this.name = proposedName;
                }
            } else {
                this.name = this.calculateName();
            }
            usedRecipeNames.add(this.name);
        }

        public String calculateName() {
            int hash = ((MCRecipeBase)this.recipe.getRecipe()).toCommandString().hashCode();
            while (usedHashes.contains(hash)) {
                ++hash;
            }
            usedHashes.add(hash);
            return (this.isShaped ? "ct_shaped" : "ct_shapeless") + hash;
        }

        public void apply() {
            ForgeRegistries.RECIPES.register(this.recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
            List list = recipes.getOrDefault(this.recipe.getTier(), new LinkedList());
            list.add(this.recipe);
            recipes.put(this.recipe.getTier(), list);
        }

        public String describe() {
            if (this.output != null) {
                return "Adding " + (this.isShaped ? "shaped" : "shapeless") + " recipe for " + this.output.getDisplayName() + " with name " + this.name;
            }
            return "Trying to add " + (this.isShaped ? "shaped" : "shapeless") + "recipe without correct output";
        }

        public MCRecipeBase getRecipe() {
            return (MCRecipeWrapper)this.recipe.getRecipe();
        }
    }

    private static class ActionAddShapelessRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapelessRecipe(String stage, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
            this(stage, null, output, ingredients, function, action, false);
        }

        public ActionAddShapelessRecipe(String stage, String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action, boolean hidden) {
            super(new RecipeStage(stage, (IRecipe)new MCRecipeShapeless(ingredients, output, function, action, hidden), true), output, false, new MCRecipeShapeless(ingredients, output, function, action, hidden).hasTransformers());
            this.setName(name);
        }
    }

    private static class ActionAddShapedRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapedRecipe(String stage, IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored, boolean hidden) {
            this(stage, null, output, ingredients, function, action, mirrored, hidden);
        }

        public ActionAddShapedRecipe(String stage, String name, IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored, boolean hidden) {
            super(new RecipeStage(stage, (IRecipe)new MCRecipeShaped(ingredients, output, function, action, mirrored, hidden), false, ingredients[0].length, ingredients.length), output, true, new MCRecipeShaped(ingredients, output, function, action, mirrored, hidden).hasTransformers());
            this.setName(name);
        }

        public ActionAddShapedRecipe(String stage, IItemStack output, MCRecipeShaped recipe) {
            this(stage, null, output, recipe);
        }

        public ActionAddShapedRecipe(String stage, String name, IItemStack output, MCRecipeShaped recipe) {
            super(new RecipeStage(stage, (IRecipe)recipe, false, recipe.getRecipeWidth(), recipe.getRecipeHeight()), output, true, recipe.hasTransformers());
            this.setName(name);
        }
    }

    private static class ActionSetModidStages
    implements IAction {
        private final Map<String, List<String>> outputs = new HashMap<String, List<String>>();

        private ActionSetModidStages() {
        }

        public void addModid(String stage, String modid) {
            List outputsForStage = this.outputs.computeIfAbsent(stage, k -> new ArrayList());
            outputsForStage.add(modid);
        }

        public void apply() {
            HashSet entries = new HashSet(ForgeRegistries.RECIPES.getEntries());
            for (Map.Entry ent : entries) {
                for (Map.Entry<String, List<String>> entry : this.outputs.entrySet()) {
                    for (String s : entry.getValue()) {
                        if (!s.equalsIgnoreCase(((ResourceLocation)ent.getKey()).func_110624_b())) continue;
                        IRecipe recipe = (IRecipe)ent.getValue();
                        new ActionSetStage(Collections.singletonList(recipe), entry.getKey()).apply();
                    }
                }
            }
            actionSetNameStages = null;
        }

        public String describe() {
            return "Setting the stages for recipes based on modid, " + this.outputs.size();
        }
    }

    private static class ActionSetNameStages
    implements IAction {
        private final Map<String, List<String>> outputs = new HashMap<String, List<String>>();

        private ActionSetNameStages() {
        }

        public void addName(String stage, String name) {
            List outputsForStage = this.outputs.computeIfAbsent(stage, k -> new ArrayList());
            outputsForStage.add(name);
        }

        public void apply() {
            HashSet entries = new HashSet(ForgeRegistries.RECIPES.getEntries());
            for (Map.Entry ent : entries) {
                for (Map.Entry<String, List<String>> entry : this.outputs.entrySet()) {
                    for (String s : entry.getValue()) {
                        if (!s.equalsIgnoreCase(((ResourceLocation)ent.getKey()).toString())) continue;
                        IRecipe recipe = (IRecipe)ent.getValue();
                        new ActionSetStage(Collections.singletonList(recipe), entry.getKey()).apply();
                    }
                }
            }
            actionSetNameStages = null;
        }

        public String describe() {
            return "Setting the stages for recipes based on regex, " + this.outputs.size();
        }
    }

    private static class ActionSetRegexStages
    implements IAction {
        private final Map<String, List<String>> outputs = new HashMap<String, List<String>>();

        private ActionSetRegexStages() {
        }

        public void addRegex(String stage, String regex) {
            List outputsForStage = this.outputs.computeIfAbsent(stage, k -> new ArrayList());
            outputsForStage.add(regex);
        }

        public void apply() {
            HashSet entries = new HashSet(ForgeRegistries.RECIPES.getEntries());
            for (Map.Entry ent : entries) {
                for (Map.Entry<String, List<String>> entry : this.outputs.entrySet()) {
                    for (String s : entry.getValue()) {
                        Pattern pattern = Pattern.compile(s);
                        Matcher m = pattern.matcher(((ResourceLocation)ent.getKey()).toString());
                        if (!m.matches()) continue;
                        IRecipe recipe = (IRecipe)ent.getValue();
                        new ActionSetStage(Collections.singletonList(recipe), entry.getKey()).apply();
                    }
                }
            }
            actionSetRegexStages = null;
        }

        public String describe() {
            return "Setting the stages for recipes based on regex, " + this.outputs.size();
        }
    }

    private static class ActionSetOutputStages
    implements IAction {
        private final Map<String, List<IItemStack>> outputs = new HashMap<String, List<IItemStack>>();

        private ActionSetOutputStages() {
        }

        public void addOutput(String stage, IIngredient output) {
            List outputsForStage = this.outputs.computeIfAbsent(stage, k -> new ArrayList());
            outputsForStage.addAll(output.getItems());
            CraftTweakerAPI.logInfo((String)("Adding: " + output + " to stage: \"" + stage + "\""));
        }

        public void apply() {
            ArrayList values = new ArrayList(ForgeRegistries.RECIPES.getValues());
            for (IRecipe recipe : values) {
                MCItemStack stack = MCItemStack.createNonCopy((ItemStack)recipe.func_77571_b());
                if (stack == null) continue;
                block1: for (Map.Entry<String, List<IItemStack>> entry : this.outputs.entrySet()) {
                    for (IItemStack output : entry.getValue()) {
                        if (!output.matches((IItemStack)stack)) continue;
                        Recipes.replaceRecipe(entry.getKey(), recipe);
                        continue block1;
                    }
                }
            }
            actionSetOutputStages = null;
        }

        public String describe() {
            return "Setting the stages for recipes based on their output stack, " + this.outputs.size() + " stages";
        }
    }

    private static class ActionSetStage
    implements IAction {
        private final List<IRecipe> recipes;
        private final String stage;

        public ActionSetStage(List<IRecipe> recipe, String stage) {
            this.recipes = recipe;
            this.stage = stage;
        }

        public void apply() {
            for (IRecipe irecipe : this.recipes) {
                Recipes.replaceRecipe(this.stage, irecipe);
            }
        }

        public String describe() {
            return "Setting the stage for recipes that output: " + this.recipes.get(0).func_77571_b().func_82833_r();
        }
    }

    private static class ActionSetPack
    implements IAction {
        private final String pack;
        private final String[] stage;

        public ActionSetPack(String container, String[] stage) {
            this.pack = container;
            this.stage = stage;
        }

        public void apply() {
            packageStages.put(this.pack, this.stage);
        }

        public String describe() {
            return "Setting stage of: " + this.pack + " to: " + String.join((CharSequence)", ", this.stage);
        }
    }

    private static class ActionSetCrafter
    implements IAction {
        private final String container;
        private final String[] stage;

        public ActionSetCrafter(String container, String[] stage) {
            this.container = container;
            this.stage = stage;
        }

        public void apply() {
            crafterStages.put(this.container, this.stage);
        }

        public String describe() {
            return "Setting stage of: " + this.container + " to: " + String.join((CharSequence)", ", this.stage);
        }
    }

    private static class ActionSetPrinting
    implements IAction {
        private final boolean print;

        public ActionSetPrinting(boolean print) {
            this.print = print;
        }

        public void apply() {
            printContainers = this.print;
        }

        public String describe() {
            return "Setting print containers to: " + this.print;
        }
    }
}

