/*
 * Decompiled with CFR 0.152.
 */
package ljfa.tntutils.asm;

import java.util.ListIterator;
import ljfa.tntutils.asm.HooksExplosion;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ExplosionTransformer
implements IClassTransformer {
    private final Logger coreLogger = LogManager.getLogger((String)"TNTUtils Core", (MessageFactory)StringFormatterMessageFactory.INSTANCE);

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.world.Explosion")) {
            if (name.equals(transformedName)) {
                this.coreLogger.info("About to patch class %s", (Object)transformedName);
                return this.patchClassExplosion(basicClass, false);
            }
            this.coreLogger.info("About to patch obfuscated class %s (%s)", (Object)name, (Object)transformedName);
            return this.patchClassExplosion(basicClass, true);
        }
        return basicClass;
    }

    private byte[] patchClassExplosion(byte[] basicClass, boolean obfuscated) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(obfuscated ? "func_77279_a" : "doExplosionB") || !mn.desc.equals("(Z)V")) continue;
            this.coreLogger.trace("Found target method %s%s", (Object)mn.name, (Object)mn.desc);
            this.patchDoExplosionB(mn);
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void patchDoExplosionB(MethodNode mn) {
        ListIterator it = mn.instructions.iterator();
        boolean didInject = false;
        while (it.hasNext()) {
            AbstractInsnNode currentNode = (AbstractInsnNode)it.next();
            if (currentNode.getOpcode() != 110) continue;
            InsnNode fdivNode = (InsnNode)currentNode;
            if ((currentNode = currentNode.getPrevious()).getOpcode() != 180 || (currentNode = currentNode.getPrevious().getPrevious()).getOpcode() != 12) continue;
            this.coreLogger.trace("Found target instructions \"fconst_1\" through \"fdiv\"");
            LabelNode label = new LabelNode();
            mn.instructions.insert((AbstractInsnNode)fdivNode, (AbstractInsnNode)label);
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(HooksExplosion.class), "getDropChance", "(Lnet/minecraft/world/Explosion;)F", false));
            toInject.add((AbstractInsnNode)new JumpInsnNode(167, label));
            mn.instructions.insertBefore(currentNode, toInject);
            didInject = true;
            break;
        }
        if (didInject) {
            this.coreLogger.info("Successfully injected into %s%s", (Object)mn.name, (Object)mn.desc);
        } else {
            this.coreLogger.error("Failed injection into %s%s. There is probably an incompatibility with some other core mod.", (Object)mn.name, (Object)mn.desc);
        }
    }
}

