/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump;

import com.codetaylor.mc.artisanworkstumps.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumps;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumpsConfig;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.TileWorkstump;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.StackHandlerInput;
import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.ArtisanToolHandlers;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InteractionTool
extends InteractionUseItemBase<TileWorkstump> {
    public InteractionTool() {
        super(new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK);
    }

    protected boolean allowInteraction(TileWorkstump tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (player.func_71024_bL().func_75116_a() < tile.getMinimumHungerToUse()) {
            return false;
        }
        ItemStack heldItemStack = player.func_184586_b(hand);
        boolean sneaking = player.func_70093_af();
        if (sneaking && heldItemStack.func_190926_b() && ModuleWorkstumpsConfig.WORKSTUMP.ALLOW_RECIPE_CLEAR) {
            return true;
        }
        if (heldItemStack.func_190926_b()) {
            return false;
        }
        if (sneaking) {
            return ArtisanAPI.containsRecipeWithTool((ItemStack)heldItemStack) || ModuleWorkstumpsConfig.WORKSTUMP.isDefaultTool(tile.getTableName(), heldItemStack);
        }
        IArtisanRecipe recipe = tile.getWorkstumpRecipe(player);
        if (recipe != null) {
            if (recipe.getBaseOutput(tile.createCraftingContext(player)).isEmpty()) {
                return false;
            }
            if (recipe.getToolCount() == 0) {
                return ModuleWorkstumpsConfig.WORKSTUMP.isDefaultTool(tile.getTableName(), heldItemStack) && ArtisanToolHandlers.get((ItemStack)heldItemStack).canAcceptAllDamage(heldItemStack, ModuleWorkstumpsConfig.WORKSTUMP.DEFAULT_RECIPE_TOOL_DAMAGE);
            }
            return true;
        }
        return false;
    }

    protected void applyItemDamage(ItemStack itemStack, EntityPlayer player) {
    }

    protected boolean doInteraction(TileWorkstump tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184614_ca();
        if (player.func_70093_af()) {
            if (heldItem.func_190926_b()) {
                this.doRecipeClear(tile, world, player);
            } else if (ModuleWorkstumpsConfig.WORKSTUMP.ALLOW_RECIPE_REPEAT) {
                this.doRecipeRepeat(tile, player, heldItem);
            }
        } else {
            this.doRecipeProgress(tile, world, hitPos, player, hitX, hitY, hitZ);
        }
        return true;
    }

    private void doRecipeClear(TileWorkstump tile, World world, EntityPlayer player) {
        int slots = tile.getStackHandlerInput().getSlots();
        for (int i = 0; i < slots; ++i) {
            int slotLimit = tile.getStackHandlerInput().getSlotLimit(i);
            ItemStack itemStack = tile.getStackHandlerInput().extractItem(i, slotLimit, false);
            StackHelper.addToInventoryOrSpawn((World)world, (EntityPlayer)player, (ItemStack)itemStack, (BlockPos)tile.func_174877_v(), (double)1.0, (boolean)false, (boolean)true);
        }
    }

    private void doRecipeRepeat(TileWorkstump tile, EntityPlayer player, ItemStack heldItem) {
        int i;
        IArtisanRecipe recipe;
        IArtisanRecipe existingRecipe = tile.getWorkstumpRecipe(player);
        if (existingRecipe != null) {
            recipe = existingRecipe;
        } else {
            IArtisanRecipe retainedRecipe = tile.getRetainedRecipe();
            if (retainedRecipe == null) {
                return;
            }
            recipe = retainedRecipe;
        }
        List ingredientList = recipe.getIngredientList();
        StackHandlerInput inputStackHandler = tile.getStackHandlerInput();
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(ingredientList.size());
        block0: for (IArtisanIngredient ingredient : ingredientList) {
            if (ingredient.matches(ItemStack.field_190927_a)) {
                itemStackList.add(ItemStack.field_190927_a);
                continue;
            }
            for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                if (!ingredient.matches(itemStack)) continue;
                ItemStack copy = itemStack.func_77946_l();
                copy.func_190920_e(1);
                itemStackList.add(copy);
                itemStack.func_190918_g(1);
                continue block0;
            }
        }
        if (ingredientList.size() != itemStackList.size()) {
            for (ItemStack itemStack : itemStackList) {
                player.func_191521_c(itemStack);
            }
            return;
        }
        boolean tableHasRoom = true;
        for (i = 0; i < itemStackList.size(); ++i) {
            ItemStack remainingItemStack = inputStackHandler.insertItem(i, (ItemStack)itemStackList.get(i), true);
            if (remainingItemStack.func_190926_b()) continue;
            tableHasRoom = false;
            break;
        }
        if (!tableHasRoom) {
            for (ItemStack itemStack : itemStackList) {
                player.func_191521_c(itemStack);
            }
            return;
        }
        for (i = 0; i < itemStackList.size(); ++i) {
            inputStackHandler.insertItem(i, (ItemStack)itemStackList.get(i), false);
        }
        int toolDamage = ModuleWorkstumpsConfig.WORKSTUMP.RECIPE_REPEAT_TOOL_DAMAGE;
        if (!tile.func_145831_w().field_72995_K && toolDamage > 0) {
            ArtisanToolHandlers.get((ItemStack)heldItem).applyDamage(tile.func_145831_w(), heldItem, toolDamage, player, false);
        }
    }

    private void doRecipeProgress(TileWorkstump tile, World world, BlockPos hitPos, EntityPlayer player, float hitX, float hitY, float hitZ) {
        IArtisanRecipe recipe = tile.getWorkstumpRecipe(player);
        if (!world.field_72995_K) {
            this.doRecipeProgressServer(tile, world, hitPos, player, recipe);
        } else {
            this.doRecipeProgressClient(tile, world, hitX, hitY, hitZ);
        }
    }

    private void doRecipeProgressServer(TileWorkstump tile, World world, BlockPos hitPos, EntityPlayer player, IArtisanRecipe recipe) {
        world.func_184133_a(null, hitPos, SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (recipe != null) {
            tile.addRecipeProgress(1.0f / (float)tile.getHitsPerCraft(player.func_184614_ca()));
            if (tile.getExhaustionCostPerHit() > 0.0) {
                player.func_71020_j((float)tile.getExhaustionCostPerHit());
            }
            ModuleWorkstumps.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)hitPos.func_177958_n() + 0.5, hitPos.func_177956_o() + 1, (double)hitPos.func_177952_p() + 0.5, 2), world.field_73011_w.getDimension(), hitPos);
            if ((double)tile.getRecipeProgress() >= 0.9999) {
                tile.setRecipeProgress(0.0f);
                tile.setRetainedRecipeName(recipe.getName());
                ArrayList output = new ArrayList();
                recipe.doCraft(tile.createCraftingContext(player), output);
                if (recipe.getToolCount() == 0) {
                    IToolHandler toolHandler = ArtisanToolHandlers.get((ItemStack)player.func_184614_ca());
                    toolHandler.applyDamage(world, player.func_184614_ca(), ModuleWorkstumpsConfig.WORKSTUMP.DEFAULT_RECIPE_TOOL_DAMAGE, player, false);
                }
                for (ItemStack result : output) {
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)result, (BlockPos)tile.func_174877_v(), (double)0.75);
                }
                if (tile.usesDurability() && tile.addRemainingDurability(-1) == 0) {
                    tile.dropContents();
                    world.func_175655_b(tile.func_174877_v(), false);
                    world.func_184133_a(null, tile.func_174877_v(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, RandomHelper.random().nextFloat() * 0.4f + 0.8f);
                }
                if (tile.getExhaustionCostPerCraftComplete() > 0.0) {
                    player.func_71020_j((float)tile.getExhaustionCostPerCraftComplete());
                }
            }
        }
    }

    private void doRecipeProgressClient(TileWorkstump tile, World world, float hitX, float hitY, float hitZ) {
        int stateId = tile.getBlockStateIdForParticles();
        for (int i = 0; i < 2; ++i) {
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)tile.func_174877_v().func_177958_n() + hitX) + (double)(tile.func_145831_w().field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.1, (double)((float)tile.func_174877_v().func_177956_o() + hitY) + 0.1, (double)((float)tile.func_174877_v().func_177952_p() + hitZ) + (double)(tile.func_145831_w().field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.1, 0.0, 0.0, 0.0, new int[]{stateId});
        }
    }
}

