/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump;

import com.codetaylor.mc.artisanworkstumps.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumps;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumpsConfig;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.TileWorkstump;
import com.codetaylor.mc.artisanworktables.api.ArtisanToolHandlers;
import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.util.OreDictHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InteractionRepair
extends InteractionUseItemBase<TileWorkstump> {
    public InteractionRepair() {
        super(EnumFacing.values(), InteractionBounds.BLOCK);
    }

    protected boolean allowInteraction(TileWorkstump tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (!ModuleWorkstumpsConfig.WORKSTUMP.USES_DURABILITY) {
            return false;
        }
        if (!ModuleWorkstumpsConfig.WORKSTUMP.ALLOW_REPAIR) {
            return false;
        }
        if (tile.getDurability() == tile.getRemainingDurability()) {
            return false;
        }
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        ItemStack heldItemMainhand = player.func_184614_ca();
        ItemStack heldItemOffhand = player.func_184592_cb();
        return OreDictHelper.contains((String)"plankWood", (ItemStack)heldItemOffhand) && ModuleWorkstumpsConfig.WORKSTUMP.isRepairTool(heldItemMainhand);
    }

    protected void applyItemDamage(ItemStack itemStack, EntityPlayer player) {
    }

    protected boolean doInteraction(TileWorkstump tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.doRepairServer(tile, world, hitPos, player);
        } else {
            this.doRepairClient(tile, world, hitX, hitY, hitZ);
        }
        return true;
    }

    private void doRepairServer(TileWorkstump tile, World world, BlockPos hitPos, EntityPlayer player) {
        int repairAmount;
        int plankCount;
        world.func_184133_a(null, hitPos, SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 1.0f, 1.0f);
        int damage = ModuleWorkstumpsConfig.WORKSTUMP.REPAIR_TOOL_DAMAGE;
        if (damage > 0) {
            IToolHandler toolHandler = ArtisanToolHandlers.get((ItemStack)player.func_184614_ca());
            toolHandler.applyDamage(world, player.func_184614_ca(), damage, player, false);
        }
        if ((plankCount = Math.max(0, ModuleWorkstumpsConfig.WORKSTUMP.AMOUNT_OF_PLANKS_CONSUMED_PER_REPAIR)) > 0) {
            player.func_184592_cb().func_190918_g(plankCount);
        }
        if ((repairAmount = Math.max(0, ModuleWorkstumpsConfig.WORKSTUMP.AMOUNT_OF_DAMAGE_REPAIRED_PER_REPAIR)) > 0) {
            ModuleWorkstumps.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)hitPos.func_177958_n() + 0.5, hitPos.func_177956_o() + 1, (double)hitPos.func_177952_p() + 0.5, 2), world.field_73011_w.getDimension(), hitPos);
            tile.addRemainingDurability(repairAmount);
        }
    }

    private void doRepairClient(TileWorkstump tile, World world, float hitX, float hitY, float hitZ) {
        int stateId = tile.getBlockStateIdForParticles();
        for (int i = 0; i < 2; ++i) {
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)tile.func_174877_v().func_177958_n() + hitX) + (double)(tile.func_145831_w().field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.1, (double)((float)tile.func_174877_v().func_177956_o() + hitY) + 0.1, (double)((float)tile.func_174877_v().func_177952_p() + hitZ) + (double)(tile.func_145831_w().field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.1, 0.0, 0.0, 0.0, new int[]{stateId});
        }
    }
}

