/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile;

import com.codetaylor.mc.artisanworkstumps.ModArtisanWorkstumps;
import com.codetaylor.mc.artisanworkstumps.modules.tanks.block.BlockTankBase;
import com.codetaylor.mc.artisanworkstumps.modules.tanks.tile.TileTankBase;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumps;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumpsConfig;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.block.BlockWorkstump;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.EnumDamagedSide;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.FactoryCraftingContext;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.InteractionInput;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.InteractionRepair;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.InteractionShelf;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.InteractionTool;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.StackHandlerInput;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.StackHandlerShelf;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.util.ToolHarvestLevelHelper;
import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.ArtisanRegistries;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ISecondaryIngredientMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeRegistry;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementContext;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.RequirementContextSupplier;
import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataEnum;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.EnchantmentHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistry;

public class TileWorkstump
extends TileEntityDataBase
implements ITileInteractable {
    private TileDataItemStackHandler<StackHandlerInput> inputTileDataItemStackHandler;
    private StackHandlerInput stackHandlerInput = new StackHandlerInput(3, 3, this.getGridMaxStackSize());
    private StackHandlerShelf stackHandlerShelf;
    private TileDataInteger remainingDurability;
    private TileDataEnum<EnumDamagedSide>[] damagedSides;
    private TileDataFloat recipeProgress;
    private IInteraction[] interactions;
    private String tableName;
    private String retainedRecipeName;

    public TileWorkstump() {
        super(ModuleWorkstumps.TILE_DATA_SERVICE);
        int x;
        int i;
        this.stackHandlerInput.addObserver((handler, slot) -> {
            this.recipeProgress.set(0.0f);
            this.func_70296_d();
        });
        this.stackHandlerShelf = new StackHandlerShelf(this.getShelfMaxStackSize());
        this.stackHandlerShelf.addObserver((handler, slot) -> this.func_70296_d());
        this.recipeProgress = new TileDataFloat(0.0f);
        this.remainingDurability = new TileDataInteger(this.getDurability());
        this.damagedSides = new TileDataEnum[3];
        for (int i2 = 0; i2 < this.damagedSides.length; ++i2) {
            this.damagedSides[i2] = new TileDataEnum(ordinal -> EnumDamagedSide.values()[ordinal], Enum::ordinal, (Enum)EnumDamagedSide.None);
        }
        this.inputTileDataItemStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.stackHandlerInput);
        this.registerTileDataForNetwork(new ITileData[]{this.inputTileDataItemStackHandler, new TileDataItemStackHandler((ItemStackHandler)this.stackHandlerShelf), this.recipeProgress, this.remainingDurability, this.damagedSides[0], this.damagedSides[1], this.damagedSides[2]});
        ArrayList<Object> interactionList = new ArrayList<Object>();
        interactionList.add((Object)new InteractionRepair());
        interactionList.add((Object)new InteractionTool());
        for (i = 0; i < 9; ++i) {
            x = 2 - i % 3;
            int z = 2 - i / 3;
            interactionList.add((Object)new InteractionInput(this::getTableName, (ItemStackHandler)this.stackHandlerInput, i, x, z));
        }
        for (i = 0; i < 3; ++i) {
            x = i % 3;
            int index = i;
            interactionList.add((Object)new InteractionShelf((ItemStackHandler)this.stackHandlerShelf, i, x, () -> index == 2 || !this.isSideDamaged(EnumDamagedSide.West)));
        }
        this.interactions = interactionList.toArray(new IInteraction[0]);
    }

    public TileWorkstump(String tableName) {
        this();
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public IArtisanRecipe getRetainedRecipe() {
        if (this.retainedRecipeName == null) {
            return null;
        }
        IArtisanRecipe recipe = ArtisanAPI.getRecipe((String)this.retainedRecipeName);
        if (recipe == null) {
            this.retainedRecipeName = null;
        }
        return recipe;
    }

    public void setRetainedRecipeName(String recipeName) {
        this.retainedRecipeName = recipeName;
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public void setRecipeProgress(float recipeProgress) {
        this.recipeProgress.set(recipeProgress);
    }

    public void addRecipeProgress(float recipeProgress) {
        this.recipeProgress.add(recipeProgress);
    }

    public int getRemainingDurability() {
        return this.remainingDurability.get();
    }

    public int addRemainingDurability(int value) {
        int durabilityMax = this.getDurability();
        int remainingDurability = Math.max(0, Math.min(durabilityMax, this.remainingDurability.get() + value));
        this.remainingDurability.set(remainingDurability);
        this.updateDamagedSides(remainingDurability, durabilityMax);
        return remainingDurability;
    }

    public boolean isSideDamaged(EnumFacing side) {
        EnumDamagedSide damagedSide;
        EnumFacing localFacing;
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(blockState.func_177230_c() instanceof BlockWorkstump)) {
            return false;
        }
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        if (facing == side) {
            return false;
        }
        switch (facing) {
            case SOUTH: {
                localFacing = side.func_176746_e().func_176746_e();
                break;
            }
            case EAST: {
                localFacing = side.func_176735_f();
                break;
            }
            case WEST: {
                localFacing = side.func_176746_e();
                break;
            }
            default: {
                localFacing = side;
            }
        }
        switch (localFacing) {
            case EAST: {
                damagedSide = EnumDamagedSide.East;
                break;
            }
            case WEST: {
                damagedSide = EnumDamagedSide.West;
                break;
            }
            case SOUTH: {
                damagedSide = EnumDamagedSide.South;
                break;
            }
            default: {
                ModArtisanWorkstumps.LOGGER.error("Error translating local facing: " + localFacing.toString());
                return false;
            }
        }
        return this.isSideDamaged(damagedSide);
    }

    public boolean isSideDamaged(EnumDamagedSide side) {
        for (TileDataEnum<EnumDamagedSide> damagedSide : this.damagedSides) {
            if (damagedSide.get() != side) continue;
            return true;
        }
        return false;
    }

    public StackHandlerInput getStackHandlerInput() {
        return this.stackHandlerInput;
    }

    public boolean hasFluidStump() {
        return this.getTank() != null;
    }

    @Nullable
    public IFluidHandler getFluidHandler() {
        TileTankBase tileEntity = this.getTank();
        if (tileEntity == null) {
            return null;
        }
        return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    @Nullable
    public TileTankBase getTank() {
        for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
            TileEntity tileEntity;
            BlockPos offset = this.func_174877_v().func_177972_a(EnumFacing.field_176754_o[i]);
            IBlockState blockState = this.field_145850_b.func_180495_p(offset);
            if (!(blockState.func_177230_c() instanceof BlockTankBase) || blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL) != EnumFacing.field_176754_o[i].func_176734_d() || !((tileEntity = this.field_145850_b.func_175625_s(offset)) instanceof TileTankBase)) continue;
            return (TileTankBase)tileEntity;
        }
        return null;
    }

    @Nullable
    public IArtisanRecipe getWorkstumpRecipe(EntityPlayer player) {
        FluidStack simulatedFluidStackDrained;
        int playerExperience = EnchantmentHelper.getPlayerExperienceTotal((EntityPlayer)player);
        int playerLevels = player.field_71068_ca;
        boolean isPlayerCreative = player.func_184812_l_();
        RecipeRegistry registry = ArtisanAPI.getWorktableRecipeRegistry((String)this.tableName);
        FluidStack simulatedFluidStackAvailable = null;
        IFluidHandler fluidHandler = this.getFluidHandler();
        if (fluidHandler != null && (simulatedFluidStackDrained = fluidHandler.drain(Integer.MAX_VALUE, false)) != null && simulatedFluidStackDrained.amount > 0) {
            simulatedFluidStackAvailable = simulatedFluidStackDrained;
        }
        IForgeRegistry contextSupplierRegistry = ArtisanRegistries.REQUIREMENT_CONTEXT_SUPPLIER;
        HashMap contextMap = new HashMap();
        ICraftingContext craftingContext = this.createCraftingContext(player);
        for (Map.Entry entry : contextSupplierRegistry.getEntries()) {
            RequirementContextSupplier contextSupplier = (RequirementContextSupplier)entry.getValue();
            IRequirementContext context = contextSupplier.get();
            context.initialize(craftingContext);
            contextMap.put(entry.getKey(), context);
        }
        return registry.findRecipe(playerExperience, playerLevels, isPlayerCreative, new ItemStack[]{player.func_184614_ca()}, (ICraftingMatrixStackHandler)this.stackHandlerInput, simulatedFluidStackAvailable, ISecondaryIngredientMatcher.FALSE, EnumTier.WORKTABLE, contextMap);
    }

    public ICraftingContext createCraftingContext(EntityPlayer player) {
        IFluidHandler capability = this.getFluidHandler();
        if (capability != null) {
            return FactoryCraftingContext.create(this, player, capability);
        }
        return FactoryCraftingContext.create(this, player, null);
    }

    private int getGridMaxStackSize() {
        return ModuleWorkstumpsConfig.WORKSTUMP.GRID_MAX_STACK_SIZE;
    }

    private int getShelfMaxStackSize() {
        return ModuleWorkstumpsConfig.WORKSTUMP.SHELF_MAX_STACK_SIZE;
    }

    public boolean usesDurability() {
        return ModuleWorkstumpsConfig.WORKSTUMP.USES_DURABILITY;
    }

    public int getDurability() {
        return ModuleWorkstumpsConfig.WORKSTUMP.DURABILITY;
    }

    public int getHitsPerCraft(ItemStack itemStack) {
        int maxHarvestLevel = 0;
        Item item = itemStack.func_77973_b();
        for (String toolClass : item.getToolClasses(itemStack)) {
            int harvestLevel = item.getHarvestLevel(itemStack, toolClass, null, null);
            if (harvestLevel <= maxHarvestLevel) continue;
            maxHarvestLevel = harvestLevel;
        }
        int materialHarvestLevel = ToolHarvestLevelHelper.getHarvestLevel(itemStack);
        if (materialHarvestLevel > maxHarvestLevel) {
            maxHarvestLevel = materialHarvestLevel;
        }
        return ArrayHelper.getOrLast((int[])ModuleWorkstumpsConfig.WORKSTUMP.HITS_PER_CRAFT, (int)maxHarvestLevel);
    }

    public int getMinimumHungerToUse() {
        return ModuleWorkstumpsConfig.WORKSTUMP.MINIMUM_HUNGER_TO_USE;
    }

    public double getExhaustionCostPerHit() {
        return ModuleWorkstumpsConfig.WORKSTUMP.EXHAUSTION_COST_PER_HIT;
    }

    public double getExhaustionCostPerCraftComplete() {
        return ModuleWorkstumpsConfig.WORKSTUMP.EXHAUSTION_COST_PER_CRAFT_COMPLETE;
    }

    public void dropContents() {
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.stackHandlerInput, (BlockPos)this.field_174879_c);
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.stackHandlerShelf, (BlockPos)this.field_174879_c);
    }

    protected void func_190201_b(World world) {
        this.field_145850_b = world;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tableName = compound.func_74779_i("tableName");
        this.stackHandlerInput.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.stackHandlerShelf.deserializeNBT(compound.func_74775_l("shelfStackHandler"));
        this.remainingDurability.set(compound.func_74762_e("remainingDurability"));
        if (compound.func_74764_b("retainedRecipe")) {
            this.retainedRecipeName = compound.func_74779_i("retainedRecipe");
        }
        this.damagedSides[0].set((Enum)EnumDamagedSide.values()[compound.func_74771_c("damagedSide0")]);
        this.damagedSides[1].set((Enum)EnumDamagedSide.values()[compound.func_74771_c("damagedSide1")]);
        this.damagedSides[2].set((Enum)EnumDamagedSide.values()[compound.func_74771_c("damagedSide2")]);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("tableName", this.tableName);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.stackHandlerInput.serializeNBT());
        compound.func_74782_a("shelfStackHandler", (NBTBase)this.stackHandlerShelf.serializeNBT());
        compound.func_74768_a("remainingDurability", this.remainingDurability.get());
        if (this.retainedRecipeName != null) {
            compound.func_74778_a("retainedRecipe", this.retainedRecipeName);
        }
        compound.func_74774_a("damagedSide0", (byte)((EnumDamagedSide)this.damagedSides[0].get()).ordinal());
        compound.func_74774_a("damagedSide1", (byte)((EnumDamagedSide)this.damagedSides[1].get()).ordinal());
        compound.func_74774_a("damagedSide2", (byte)((EnumDamagedSide)this.damagedSides[2].get()).ordinal());
        return compound;
    }

    @Nullable
    public Stages getStages() {
        return ModuleWorkstumpsConfig.STAGES_WORKSTUMP;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockWorkstump) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    public int getBlockStateIdForParticles() {
        IBlockState state = Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.OAK);
        return Block.func_176210_f((IBlockState)state);
    }

    public void onTileDataUpdate() {
        boolean requiresBlockUpdate = false;
        if ("mage".equals(this.tableName) && this.inputTileDataItemStackHandler.isDirty()) {
            requiresBlockUpdate = true;
        }
        if (this.remainingDurability.isDirty()) {
            requiresBlockUpdate = true;
        }
        for (int i = 0; i < this.damagedSides.length; ++i) {
            if (!this.damagedSides[i].isDirty()) continue;
            requiresBlockUpdate = true;
        }
        if (requiresBlockUpdate) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
    }

    private EnumDamagedSide selectSideToDamage() {
        HashSet<EnumDamagedSide> sideSet = new HashSet<EnumDamagedSide>(3){
            {
                this.add(EnumDamagedSide.West);
                this.add(EnumDamagedSide.East);
                this.add(EnumDamagedSide.South);
            }
        };
        for (TileDataEnum<EnumDamagedSide> damagedSide : this.damagedSides) {
            sideSet.remove(damagedSide.get());
        }
        EnumDamagedSide[] sides = sideSet.toArray(new EnumDamagedSide[0]);
        return sides[RandomHelper.random().nextInt(sides.length)];
    }

    private void updateDamagedSides(int remainingDurability, int durabilityMax) {
        BlockPos fluidTankPos;
        IBlockState fluidTankBlockState;
        EnumFacing fluidTankFacing;
        EnumFacing workstumpFacing;
        TileTankBase fluidTank;
        float durabilityPercentage = (float)remainingDurability / (float)durabilityMax;
        if ((double)durabilityPercentage <= 0.11) {
            for (TileDataEnum<EnumDamagedSide> damagedSide : this.damagedSides) {
                if (damagedSide.get() != EnumDamagedSide.None) continue;
                damagedSide.set((Enum)this.selectSideToDamage());
            }
        } else if ((double)durabilityPercentage <= 0.22) {
            if (this.damagedSides[2].get() != EnumDamagedSide.None) {
                this.damagedSides[2].set((Enum)EnumDamagedSide.None);
            }
            for (int i = 0; i < this.damagedSides.length - 1; ++i) {
                if (this.damagedSides[i].get() != EnumDamagedSide.None) continue;
                this.damagedSides[i].set((Enum)this.selectSideToDamage());
            }
        } else if ((double)durabilityPercentage <= 0.33) {
            for (int i = 1; i < this.damagedSides.length; ++i) {
                if (this.damagedSides[i].get() == EnumDamagedSide.None) continue;
                this.damagedSides[i].set((Enum)EnumDamagedSide.None);
            }
            if (this.damagedSides[0].get() == EnumDamagedSide.None) {
                this.damagedSides[0].set((Enum)this.selectSideToDamage());
            }
        } else {
            for (TileDataEnum<EnumDamagedSide> damagedSide : this.damagedSides) {
                if (damagedSide.get() == EnumDamagedSide.None) continue;
                damagedSide.set((Enum)EnumDamagedSide.None);
            }
        }
        if ((fluidTank = this.getTank()) != null && this.isSideDamaged(workstumpFacing = (fluidTankFacing = (EnumFacing)(fluidTankBlockState = this.field_145850_b.func_180495_p(fluidTankPos = fluidTank.func_174877_v())).func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176734_d())) {
            this.field_145850_b.func_175655_b(fluidTankPos, true);
        }
        if (this.isSideDamaged(EnumDamagedSide.West)) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)this.stackHandlerShelf.extractItem(0, this.stackHandlerShelf.getStackInSlot(0).func_190916_E(), false), (BlockPos)this.field_174879_c);
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)this.stackHandlerShelf.extractItem(1, this.stackHandlerShelf.getStackInSlot(1).func_190916_E(), false), (BlockPos)this.field_174879_c);
        }
    }
}

