/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.plugin.waila;

import com.codetaylor.mc.artisanworkstumps.ModArtisanWorkstumps;
import com.codetaylor.mc.artisanworkstumps.lib.spi.plugin.ProviderDelegateBase;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumpsConfig;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.TileWorkstump;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.StackHandlerInput;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.util.InteractionRayTraceData;
import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class WorkstumpProviderDelegate
extends ProviderDelegateBase<IWorkstumpDisplay, TileWorkstump> {
    public static final String LANG_KEY_HOVERED_ITEM_QUANTITY = "gui.artisanworkstumps.waila.quantity";
    private Map<String, List<Item>> defaultTools = new HashMap<String, List<Item>>();

    public WorkstumpProviderDelegate(IWorkstumpDisplay display) {
        super(display);
    }

    @Override
    public void display(TileWorkstump tile) {
        this.display(tile, null);
    }

    public void display(TileWorkstump tile, @Nullable EntityPlayer player) {
        int durability;
        int remainingDurability;
        float d;
        ItemStack recipeOutput;
        IArtisanRecipe workstumpRecipe;
        float progress = tile.getRecipeProgress();
        StackHandlerInput stackHandler = tile.getStackHandlerInput();
        boolean notEmpty = false;
        for (int i = 0; i < 9; ++i) {
            if (stackHandler.getStackInSlot(i).func_190926_b()) continue;
            notEmpty = true;
            break;
        }
        if (notEmpty && (workstumpRecipe = tile.getWorkstumpRecipe(player)) != null && !workstumpRecipe.getBaseOutput(tile.createCraftingContext(player)).isEmpty() && !(recipeOutput = ((OutputWeightPair)workstumpRecipe.getOutputWeightPairList().get(0)).getOutput().toItemStack()).func_190926_b()) {
            List toolList = workstumpRecipe.getToolCount() > 0 ? Arrays.stream(workstumpRecipe.getToolEntries()[0].getToolStacks()).map(ItemStack::func_77973_b).collect(Collectors.toList()) : this.defaultTools.computeIfAbsent(tile.getTableName(), k -> {
                String itemString = ModuleWorkstumpsConfig.WORKSTUMP.DEFAULT_RECIPE_TOOL.get(tile.getTableName());
                try {
                    ParseResult parseResult = RecipeItemParser.INSTANCE.parse(itemString);
                    if ("ore".equals(parseResult.getDomain())) {
                        return OreDictionary.getOres((String)parseResult.getPath()).stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
                    }
                    ResourceLocation resourceLocation = new ResourceLocation(parseResult.getDomain(), parseResult.getPath());
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                    if (item == null) {
                        ModArtisanWorkstumps.LOGGER.error("Couldn't find registered item for resource location " + resourceLocation);
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(item);
                }
                catch (MalformedRecipeItemException e) {
                    ModArtisanWorkstumps.LOGGER.error("", (Throwable)e);
                    return Collections.emptyList();
                }
            });
            if (toolList.isEmpty()) {
                ((IWorkstumpDisplay)this.display).setRecipeProgress(new ItemStack(Blocks.field_150462_ai), recipeOutput, (int)(100.0f * progress), 100);
            } else {
                int index = (int)(tile.func_145831_w().func_82737_E() / 29L % (long)toolList.size());
                Item item = (Item)toolList.get(index);
                ((IWorkstumpDisplay)this.display).setRecipeProgress(new ItemStack(item), recipeOutput, (int)(100.0f * progress), 100);
            }
            ((IWorkstumpDisplay)this.display).setRecipeOutputName(recipeOutput);
        }
        if ((double)(d = (float)(remainingDurability = tile.getRemainingDurability()) / (float)(durability = tile.getDurability())) <= 0.33) {
            ((IWorkstumpDisplay)this.display).setCondition("gui.artisanworkstumps.waila.workstump.condition", TextFormatting.RED.toString(), "gui.artisanworkstumps.waila.workstump.condition.fractured");
        } else if ((double)d < 0.5) {
            ((IWorkstumpDisplay)this.display).setCondition("gui.artisanworkstumps.waila.workstump.condition", TextFormatting.YELLOW.toString(), "gui.artisanworkstumps.waila.workstump.condition.used");
        } else if ((double)d < 0.75) {
            ((IWorkstumpDisplay)this.display).setCondition("gui.artisanworkstumps.waila.workstump.condition", TextFormatting.GOLD.toString(), "gui.artisanworkstumps.waila.workstump.condition.fair");
        } else {
            ((IWorkstumpDisplay)this.display).setCondition("gui.artisanworkstumps.waila.workstump.condition", TextFormatting.GREEN.toString(), "gui.artisanworkstumps.waila.workstump.condition.good");
        }
        if (player != null) {
            int distance = 5;
            Vec3d posVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            RayTraceResult rayTraceResult = tile.func_145831_w().func_72901_a(posVec, posVec.func_178787_e(player.func_70040_Z().func_186678_a((double)distance)), false);
            if (rayTraceResult == null) {
                return;
            }
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            if (rayTraceResult.hitInfo instanceof InteractionRayTraceData.List) {
                InteractionRayTraceData.List list = (InteractionRayTraceData.List)rayTraceResult.hitInfo;
                for (InteractionRayTraceData data : list) {
                    ItemStack stackInSlot;
                    IInteraction interaction = data.getInteraction();
                    if (!interaction.isEnabled() || !(interaction instanceof IInteractionItemStack) || (stackInSlot = ((IInteractionItemStack)interaction).getStackInSlot()).func_190926_b()) continue;
                    ((IWorkstumpDisplay)this.display).setHoveredItem(stackInSlot);
                }
            }
        }
    }

    public static interface IWorkstumpDisplay {
        public void setRecipeProgress(ItemStack var1, ItemStack var2, int var3, int var4);

        public void setRecipeOutputName(ItemStack var1);

        public void setCondition(String var1, String var2, String var3);

        public void setHoveredItem(ItemStack var1);
    }
}

