/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.plugin.jei;

import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumps;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.plugin.jei.JEICategoryFactory;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.plugin.jei.JEIRecipeWrapper;
import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.event.ArtisanUpdateJEIRecipeVisibilityEvent;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeRegistry;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.recipe.ArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PluginJEI
implements IModPlugin {
    public static IRecipeRegistry RECIPE_REGISTRY;

    public PluginJEI() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        JEICategoryFactory factory = new JEICategoryFactory(registry.getJeiHelpers().getGuiHelper());
        for (String name : ArtisanAPI.getWorktableNames()) {
            registry.addRecipeCategories(new IRecipeCategory[]{factory.createCategory(name)});
        }
    }

    public void register(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_TAILOR), new String[]{PluginJEI.createUID("tailor")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_CARPENTER), new String[]{PluginJEI.createUID("carpenter")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_MASON), new String[]{PluginJEI.createUID("mason")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_BLACKSMITH), new String[]{PluginJEI.createUID("blacksmith")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_JEWELER), new String[]{PluginJEI.createUID("jeweler")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_BASIC), new String[]{PluginJEI.createUID("basic")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_ENGINEER), new String[]{PluginJEI.createUID("engineer")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_MAGE), new String[]{PluginJEI.createUID("mage")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_SCRIBE), new String[]{PluginJEI.createUID("scribe")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_CHEMIST), new String[]{PluginJEI.createUID("chemist")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_FARMER), new String[]{PluginJEI.createUID("farmer")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_CHEF), new String[]{PluginJEI.createUID("chef")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_DESIGNER), new String[]{PluginJEI.createUID("designer")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_TANNER), new String[]{PluginJEI.createUID("tanner")});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleWorkstumps.Blocks.WORKSTUMP_POTTER), new String[]{PluginJEI.createUID("potter")});
        for (String name : ArtisanAPI.getWorktableNames()) {
            registry.handleRecipes(ArtisanRecipe.class, recipe -> new JEIRecipeWrapper(name, (ArtisanRecipe)recipe), PluginJEI.createUID(name));
            List recipeList = new ArrayList();
            RecipeRegistry recipeRegistry = ArtisanAPI.getWorktableRecipeRegistry((String)name);
            recipeList = recipeRegistry.getRecipeListByTier(EnumTier.WORKTABLE, recipeList);
            registry.addRecipes(recipeList, PluginJEI.createUID(name));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        RECIPE_REGISTRY = jeiRuntime.getRecipeRegistry();
        this.hideRecipes();
    }

    private void hideRecipes() {
        for (String name : ArtisanAPI.getWorktableNames()) {
            RecipeRegistry registry = ArtisanAPI.getWorktableRecipeRegistry((String)name);
            List recipeList = registry.getRecipeListByTier(EnumTier.WORKTABLE, new ArrayList());
            for (IArtisanRecipe recipe : recipeList) {
                String uid;
                IRecipeWrapper recipeWrapper;
                if (!recipe.isHidden() && !this.shouldHideRecipe(recipe) || (recipeWrapper = RECIPE_REGISTRY.getRecipeWrapper((Object)recipe, uid = PluginJEI.createUID(name))) == null) continue;
                RECIPE_REGISTRY.hideRecipe(recipeWrapper, uid);
            }
        }
    }

    private boolean shouldHideRecipe(IArtisanRecipe recipe) {
        Collection values = recipe.getRequirements().values();
        for (IRequirement requirement : values) {
            if (!requirement.shouldJEIHideOnLoad()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void on(ArtisanUpdateJEIRecipeVisibilityEvent event) {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (RECIPE_REGISTRY == null) {
            return;
        }
        for (String name : ArtisanAPI.getWorktableNames()) {
            RecipeRegistry registry = ArtisanAPI.getWorktableRecipeRegistry((String)name);
            List recipeList = registry.getRecipeListByTier(EnumTier.WORKTABLE, new ArrayList());
            String uid = PluginJEI.createUID(name);
            for (IArtisanRecipe recipe : recipeList) {
                IRecipeWrapper recipeWrapper = RECIPE_REGISTRY.getRecipeWrapper((Object)recipe, uid);
                if (recipeWrapper == null) continue;
                boolean shouldHide = false;
                for (IRequirement requirement : recipe.getRequirements().values()) {
                    if (!requirement.shouldJEIHideOnUpdate()) continue;
                    shouldHide = true;
                    break;
                }
                if (shouldHide) {
                    RECIPE_REGISTRY.hideRecipe(recipeWrapper, uid);
                    continue;
                }
                RECIPE_REGISTRY.unhideRecipe(recipeWrapper, uid);
            }
        }
    }

    public static String createUID(String name) {
        return "artisanworkstumps_" + name;
    }
}

