/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.plugin.jei;

import com.codetaylor.mc.artisanworkstumps.ModArtisanWorkstumps;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.ModuleWorkstumpsConfig;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.recipe.ArtisanRecipe;
import com.codetaylor.mc.athenaeum.gui.GuiHelper;
import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class JEIRecipeWrapper
implements IRecipeWrapper {
    private static final ResourceLocation SHAPELESS_ICON = new ResourceLocation("artisanworkstumps", "textures/gui/shapeless_icon.png");
    private static Map<String, List<Item>> DEFAULT_TOOLS = new HashMap<String, List<Item>>();
    private final String tableName;
    private ArtisanRecipe artisanRecipe;
    private List<List<ItemStack>> inputs;
    private List<List<ItemStack>> tools;
    private List<ItemStack> output;

    public JEIRecipeWrapper(String tableName, ArtisanRecipe artisanRecipe) {
        this.tableName = tableName;
        this.artisanRecipe = artisanRecipe;
        this.inputs = new ArrayList<List<ItemStack>>();
        this.tools = new ArrayList<List<ItemStack>>();
        for (IArtisanIngredient input : this.artisanRecipe.getIngredientList()) {
            ItemStack[] matchingStacks = input.toIngredient().func_193365_a();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(matchingStacks.length);
            ItemStack[] itemStackArray = matchingStacks;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack matchingStack = itemStackArray[i];
                list.add(matchingStack.func_77946_l());
            }
            this.inputs.add(list);
        }
        for (int i = 0; i < artisanRecipe.getToolCount(); ++i) {
            ItemStack[] tools = this.artisanRecipe.getTools(i);
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(tools.length);
            for (ItemStack tool : tools) {
                itemStackList.add(tool.func_77946_l());
            }
            this.tools.add(itemStackList);
        }
        if (this.tools.isEmpty()) {
            List toolList = DEFAULT_TOOLS.computeIfAbsent(this.tableName, k -> {
                String itemString = ModuleWorkstumpsConfig.WORKSTUMP.DEFAULT_RECIPE_TOOL.get(this.tableName);
                try {
                    ParseResult parseResult = RecipeItemParser.INSTANCE.parse(itemString);
                    if ("ore".equals(parseResult.getDomain())) {
                        return OreDictionary.getOres((String)parseResult.getPath()).stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
                    }
                    ResourceLocation resourceLocation = new ResourceLocation(parseResult.getDomain(), parseResult.getPath());
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                    if (item == null) {
                        ModArtisanWorkstumps.LOGGER.error("Couldn't find registered item for resource location " + resourceLocation);
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(item);
                }
                catch (MalformedRecipeItemException e) {
                    ModArtisanWorkstumps.LOGGER.error("", (Throwable)e);
                    return Collections.emptyList();
                }
            });
            this.tools.add(toolList.stream().map(ItemStack::new).collect(Collectors.toList()));
        }
        List output = this.artisanRecipe.getOutputWeightPairList();
        this.output = new ArrayList<ItemStack>(output.size());
        for (OutputWeightPair pair : output) {
            this.output.add(pair.getOutput().toItemStack().func_77946_l());
        }
    }

    public ResourceLocation getRegistryName() {
        return new ResourceLocation(this.artisanRecipe.getName());
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public FluidStack getFluidStack() {
        return this.artisanRecipe.getFluidIngredient();
    }

    public List<OutputWeightPair> getWeightedOutput() {
        return this.artisanRecipe.getOutputWeightPairList();
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public boolean isShaped() {
        return this.artisanRecipe.isShaped();
    }

    public int getWidth() {
        return this.artisanRecipe.getWidth();
    }

    public int getHeight() {
        return this.artisanRecipe.getHeight();
    }

    public List<List<ItemStack>> getTools() {
        return this.tools;
    }

    public ItemStack getSecondaryOutput() {
        return this.artisanRecipe.getSecondaryOutput().toItemStack();
    }

    public ItemStack getTertiaryOutput() {
        return this.artisanRecipe.getTertiaryOutput().toItemStack();
    }

    public ItemStack getQuaternaryOutput() {
        return this.artisanRecipe.getQuaternaryOutput().toItemStack();
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.addAll(this.inputs);
        inputs.addAll(this.tools);
        ingredients.setInputLists(ItemStack.class, inputs);
        FluidStack fluidIngredient = this.artisanRecipe.getFluidIngredient();
        if (fluidIngredient != null) {
            ingredients.setInput(FluidStack.class, (Object)fluidIngredient);
        }
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        output.addAll(this.output);
        output.add(this.getSecondaryOutput());
        output.add(this.getTertiaryOutput());
        output.add(this.getQuaternaryOutput());
        ingredients.setOutputs(ItemStack.class, output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float chance;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
        String experienceString = null;
        if (this.artisanRecipe.getExperienceRequired() > 0) {
            experienceString = this.artisanRecipe.consumeExperience() ? I18n.func_135052_a((String)"jei.artisanworkstumps.xp.cost", (Object[])new Object[]{this.artisanRecipe.getExperienceRequired()}) : I18n.func_135052_a((String)"jei.artisanworkstumps.xp.required", (Object[])new Object[]{this.artisanRecipe.getExperienceRequired()});
        } else if (this.artisanRecipe.getLevelRequired() > 0) {
            experienceString = this.artisanRecipe.consumeExperience() ? I18n.func_135052_a((String)"jei.artisanworkstumps.level.cost", (Object[])new Object[]{this.artisanRecipe.getLevelRequired()}) : I18n.func_135052_a((String)"jei.artisanworkstumps.level.required", (Object[])new Object[]{this.artisanRecipe.getLevelRequired()});
        }
        if (experienceString != null) {
            this.drawExperienceString(minecraft, recipeHeight, experienceString);
        }
        this.drawToolDamageString(minecraft, 79, 39);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        int xPos = 301;
        int yPos = 6;
        if (!this.artisanRecipe.getSecondaryOutput().isEmpty()) {
            chance = this.artisanRecipe.getSecondaryOutputChance();
            this.drawSecondaryOutputChanceString(minecraft, chance, xPos, yPos);
        }
        if (!this.artisanRecipe.getTertiaryOutput().isEmpty()) {
            chance = this.artisanRecipe.getTertiaryOutputChance();
            this.drawSecondaryOutputChanceString(minecraft, chance, xPos, yPos + 36);
        }
        if (!this.artisanRecipe.getQuaternaryOutput().isEmpty()) {
            chance = this.artisanRecipe.getQuaternaryOutputChance();
            this.drawSecondaryOutputChanceString(minecraft, chance, xPos, yPos + 72);
        }
        GlStateManager.func_179121_F();
        if (!this.artisanRecipe.isShaped()) {
            GuiHelper.drawTexturedRect((Minecraft)minecraft, (ResourceLocation)SHAPELESS_ICON, (int)234, (int)8, (int)18, (int)17, (int)0, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-8.0f, (float)0.0f);
        if (!this.artisanRecipe.isShaped()) {
            int x = 117;
            int y = 4;
            if (mouseX >= x && mouseX <= x + 9 && mouseY >= y && mouseY <= y + 9) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(I18n.func_135052_a((String)"jei.artisanworkstumps.tooltip.shapeless.recipe", (Object[])new Object[0]));
                GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d, (int)200, (FontRenderer)minecraft.field_71466_p);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void drawSecondaryOutputChanceString(Minecraft minecraft, float secondaryOutputChance, int positionX, int positionY) {
        String label = (int)(secondaryOutputChance * 100.0f) + "%";
        minecraft.field_71466_p.func_175065_a(label, (float)positionX - (float)minecraft.field_71466_p.func_78256_a(label) * 0.5f, (float)positionY, -1, true);
    }

    private void drawExperienceString(Minecraft minecraft, int recipeHeight, String experienceString) {
        minecraft.field_71466_p.func_175065_a(experienceString, 0.0f, (float)(recipeHeight - 8), -8323296, true);
    }

    private void drawToolDamageString(Minecraft minecraft, int offsetX, int offsetY) {
        if (this.artisanRecipe.getToolCount() > 0) {
            for (int i = 0; i < this.artisanRecipe.getToolCount(); ++i) {
                String label = "-" + this.artisanRecipe.getToolDamage(i);
                minecraft.field_71466_p.func_175065_a(label, (float)offsetX - (float)minecraft.field_71466_p.func_78256_a(label) * 0.5f, (float)(offsetY + 22 * i), -1, true);
            }
        } else {
            String label = "-" + ModuleWorkstumpsConfig.WORKSTUMP.DEFAULT_RECIPE_TOOL_DAMAGE;
            minecraft.field_71466_p.func_175065_a(label, (float)offsetX - (float)minecraft.field_71466_p.func_78256_a(label) * 0.5f, (float)offsetY, -1, true);
        }
    }
}

