/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.plugin.jei;

import com.codetaylor.mc.artisanworkstumps.modules.workstumps.plugin.jei.JEIRecipeWrapper;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class JEICategoryWorkstump
implements IRecipeCategory {
    private final ICraftingGridHelper craftingGridHelper;
    private String uid;
    private String titleTranslateKey;
    private IDrawable background;

    public JEICategoryWorkstump(String titleTranslateKey, IDrawable background, String uid, IGuiHelper guiHelper) {
        this.titleTranslateKey = titleTranslateKey;
        this.background = background;
        this.uid = uid;
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    @Nonnull
    public String getUid() {
        return this.uid;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)this.titleTranslateKey, (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Artisan Workstumps";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        FluidStack fluidStack;
        JEIRecipeWrapper wrapper = (JEIRecipeWrapper)recipeWrapper;
        ResourceLocation registryName = wrapper.getRegistryName();
        if (registryName != null) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == this.getOutputSlotIndex()) {
                    boolean showAdvanced;
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.DARK_GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.id", (Object[])new Object[]{registryName.toString()}));
                    }
                }
            });
        }
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        List<List<ItemStack>> tools = wrapper.getTools();
        List<List<ItemStack>> inputs = wrapper.getInputs();
        List<ItemStack> outputs = wrapper.getOutput();
        stacks.init(0, false, 107, 18);
        stacks.set(0, outputs);
        this.setupTooltip(stacks, wrapper.getWeightedOutput());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                stacks.init(index, true, x * 18 + 16 - 4, y * 18 + 13 - 13);
            }
        }
        if (wrapper.isShaped()) {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)stacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)stacks, inputs);
        }
        stacks.init(10, true, 70, 18);
        if (tools.size() > 0) {
            stacks.set(10, tools.get(0));
        }
        stacks.init(11, false, 133, 0);
        stacks.init(12, false, 133, 18);
        stacks.init(13, false, 133, 36);
        ItemStack extraOutput = wrapper.getSecondaryOutput();
        if (!extraOutput.func_190926_b()) {
            stacks.set(11, extraOutput);
        }
        if (!(extraOutput = wrapper.getTertiaryOutput()).func_190926_b()) {
            stacks.set(12, extraOutput);
        }
        if (!(extraOutput = wrapper.getQuaternaryOutput()).func_190926_b()) {
            stacks.set(13, extraOutput);
        }
        if ((fluidStack = wrapper.getFluidStack()) != null) {
            fluidStacks.init(14, true, 1, 1, 6, 52, fluidStack.amount * 2, false, null);
            fluidStacks.set(14, fluidStack);
        }
    }

    private int getOutputSlotIndex() {
        return 0;
    }

    private void setupTooltip(IGuiItemStackGroup stacks, List<OutputWeightPair> weightedOutput) {
        if (weightedOutput.size() > 1) {
            int sum = 0;
            for (OutputWeightPair pair : weightedOutput) {
                sum += pair.getWeight();
            }
            int weightSum = sum;
            stacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    for (OutputWeightPair pair : weightedOutput) {
                        if (!ItemStack.func_77989_b((ItemStack)pair.getOutput().toItemStack(), (ItemStack)ingredient)) continue;
                        int chance = Math.round((float)pair.getWeight() / (float)weightSum * 100.0f);
                        ArrayList result = new ArrayList();
                        result.add(tooltip.get(0));
                        result.add(I18n.func_135052_a((String)"jei.artisanworkstumps.tooltip.chance", (Object[])new Object[]{TextFormatting.GRAY, String.valueOf(chance)}));
                        for (int i = 1; i < tooltip.size(); ++i) {
                            result.add(tooltip.get(i));
                        }
                        tooltip.clear();
                        tooltip.addAll(result);
                    }
                }
            });
        }
    }
}

